#include "headers.h"

#include <stdarg.h>
#include <time.h>

#include "shell.h"
#include "chuck.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"

#include "e_global.h"

#ifdef PC_VERSION
/*netWork Stuff*/
#include "\tanx\netnow\hmistd.h"
#include "\tanx\netnow\netnow.h"
#include "\tanx\menu.h"
#include "\tanx\netmenu2.h"
#include "netextra.h"
#endif






#ifdef FLOPPY_VERSION
GAME_IOSTRUCT game_data={
	1,		/* Flag */
	1,    /* Mission (current) */
	2,		/* Next mission */
	3,		/* Last armour level */
	24, 	/* Last armour integrity */
	6,		/* Armour level */
	48, 	/* Armour integrity */

   0,		/* Number of sams */
	0,		/* mine utilizaition system */
	0,		/* Night sight */

	/* Upgrades */

	0,		/* Air support */
	0,		/* engine upgrade */
	0,		/* Track upgrade */
	0,		/* reload upgrade */
	0,		/* Track upgrade */
	0,		/* chain gun upgrade */

	0,		/* Money */

	0,		/* Score */

   0, 	/* Hit acc percent */
   0,		/* Body count */

   32760,   /* Sound vol */
   32760,		/* music vol */
   2,		/* music */
   0,		/* Subtitles */
	ENGLISH,		/* Language */

	0,		/* Control device */

	0,		/* Mission status */
	25,
	3,
	10,
	89,
	100,
	95,
	8,
	"",

	/* Keys */

/******************* MODIFIED 12-1-96 ************************/

 	K_COMMA,					/* Left */
	K_DOT,			    	/* Right */
	K_Q,					  	/* Accelerate */
	K_A,				    	/* Reverse */
	K_J,K_L,K_K,      /* Turret controls */
	K_SPACE,			  	/* Fire weapon */
	K_S,			      	/* Select weapon */
	K_T,				    	/* Reselect target */
	K_TAB,						/* Access tactical */

  K_A,					  	/* Left track forward */
	K_Z,					  	/* Left track backward */
	K_COLON,			  	/* Right track forward */
	K_DOT,				  	/* Right track back */
	K_J,K_L,K_K,
	K_SPACE,       	 	/* Fire weapon */
	K_RET,			    	/* Select weapon */
	K_T,			  			/* Reselect target */
	K_TAB,						/* Tactical map */


/*************************************************************/

 };

GAME_IOSTRUCT original_game_data={
	1,		/* Flag */
	1,    /* Mission (current) */
	2,		/* Next mission */
	3,		/* Last armour level */
	24, 	/* Last armour integrity */
	6,		/* Armour level */
	48, 	/* Armour integrity */

   0,		/* Number of sams */
	0,		/* mine utilizaition system */
	0,		/* Night sight */

	/* Upgrades */

	0,		/* Air support */
	0,		/* engine upgrade */
	0,		/* Track upgrade */
	0,		/* reload upgrade */
	0,		/* Track upgrade */
	0,		/* chain gun upgrade */

	0,		/* Money */

	0,		/* Score */

   0, 	/* Hit acc percent */
   0,		/* Body count */

   32760,   /* Sound vol */
   32760,		/* music vol */
   2,		/* music */
   0,		/* Subtitles */
	ENGLISH,		/* Language */

	0,		/* Control device */

	0,		/* Mission status */
	25,
	3,
	10,
	89,
	100,
	95,
	8,
	"",

	/* Keys */

/******************* MODIFIED 12-1-96 ************************/

 	K_COMMA,					/* Left */
	K_DOT,			    	/* Right */
	K_Q,					  	/* Accelerate */
	K_A,				    	/* Reverse */
	K_J,K_L,K_K,      /* Turret controls */
	K_SPACE,			  	/* Fire weapon */
	K_S,			      	/* Select weapon */
	K_T,				    	/* Reselect target */
	K_TAB,						/* Access tactical */

  K_A,					  	/* Left track forward */
	K_Z,					  	/* Left track backward */
	K_COLON,			  	/* Right track forward */
	K_DOT,				  	/* Right track back */
	K_J,K_L,K_K,
	K_SPACE,       	 	/* Fire weapon */
	K_RET,			    	/* Select weapon */
	K_T,			  			/* Reselect target */
	K_TAB,						/* Tactical map */


/*************************************************************/

 };




int MAX_ENEMY_SHELLS=64;

#endif


/************************************************************/

SETUP	game_setup = {320,200,25,25,50,0,0};


/************************************************************/


// take_this_out
int	forcedgame=0;
int	normalCD=TRUE;
////////////////

char	happy=FALSE;
char	installDir[320]="";
char	dont_want_debug_info = TRUE;

#ifdef FLOPPY_VERSION
void		floppy_main(void);
#endif

void	interpret_parameters(int argc, char *argv[]);
void 	netit(void);


/************************************************************/
unsigned int	totalMalloced=0;
uchar	overrideDevice=0;


BOOL	gameMenu(void);


void	main(int	argc, char *argv[])
{
	interpret_parameters(argc, argv);

	reset_msg_file();

	SoundSetSetupPath(installDir);

	#ifndef FLOPPY_VERSION
	if ( normalCD )
	{
		setup(&game_setup, NO_MIDI|CD_ON);
		mg_setup();
		dave_main();
		getout("See yah.");
	}
	else
	if ( networkGame )
	{
		setup(&game_setup, NO_MIDI|CD_ON);
		game_data.mission = forcedgame;

		if (!startNet())
			net_getout ("startNet Failed");
	 	NINIT_PROGRAM();
		dave_main();
		net_getout("Have that!");
	}
	else
	{
		SoundSetSetupPath(installDir);
		setup(&game_setup, NO_MIDI);
		mg_setup();
		my_main();
		CDStop();
		getout("See yah.");
	}
	#else
		setup(&game_setup, NO_MIDI|CD_ON);
		mg_setup();
		floppy_main();
		getout("See yah.");
	#endif
}



/************************************************************/



void	interpret_parameters(int argc, char *argv[])
{
	int	n;

	for ( n=1; n<argc; n++ )
	{
		if ( (argv[n][0]=='/') || (argv[n][0]=='-') )
		{
			switch ( argv[n][1] )
			{
				case 'm':
				case 'M':
					game_data.nextmiss = (forcedgame = game_data.mission = atoi(&(argv[n][2]))) + 1;
					break;

				case 'r':
				case 'R':
					if ( rollingDemo )
					{
						break;
					}
					recordRollingDemo=TRUE;
					break;

				case 'd':
				case 'D':
					if ( recordRollingDemo )
					{
						break;
					}
					rollingDemo=TRUE;
					break;

				case 'n':
				case 'N':
					normalCD=FALSE;
					networkGame=TRUE;
					break;


				case 't':
				case 'T':
					normalCD=FALSE;
					break;

				case 's':
				case 'S':
					showStats=TRUE;
					break;

				case 'f':
				case 'F':
					fullArmourMent=TRUE;
					break;


				case 'w':
				case 'W':
					switch ( argv[n][2] )
					{
						case 'b':
						case 'B':
							waddStatus=build_wadds;
							break;

						case 'l':
						case 'L':
							waddStatus=load_wadds;
							break;

						case 'n':
						case 'N':
							waddStatus=no_wadds;
							break;
					}
					break;


				case 'c':
				case 'C':
					switch ( argv[n][2] )
					{
						case 'j':
							overrideDevice=1+joy_control;
							break;

						case 'n':
							overrideDevice=1+normal_control;
							break;

						case 'd':
							overrideDevice=1+tank_control;
							break;
					}
					break;


				case 'i':
				case 'I':
					dont_want_debug_info = FALSE;
					break;

				case 'h':
				case 'H':
					strlwr(argv[n]);
					if ( !(strcmp(argv[n]+1,"happy")) )
					{
						happy=TRUE;
					}
					break;
			}
		}
		else
		{
			sprintf(installDir, "%s", argv[n]);
		}
	}
}




char	debugFilename[256];


void	reset_msg_file(void)
{
	FILE *fp;
	time_t	time_of_day;

	if ( dont_want_debug_info )
	{
		return ;
	}

	time_of_day = time(NULL);

	sprintf(debugFilename,"c:\\shock_%02d.dbg",game_data.mission);

	fp = fopen(debugFilename, "w");
	fprintf(fp, "Shellshock debug file\n%s\n\n", ctime( &time_of_day));
	fprintf(fp, "Map %d.",game_data.mission);
	fclose(fp);
}




void	debug_msg(char *format, ...)
{
	FILE *fp;
	va_list	argptr;
	char	debugMessageString[640];

	if ( dont_want_debug_info )
	{
		return ;
	}

	va_start(argptr, format);
	vsprintf(debugMessageString, format, argptr);

	fp = fopen(debugFilename, "a+");
	fprintf(fp, "%s\n", debugMessageString);
	fclose(fp);
}



#ifndef FLOPPY_VERSION
/*Called when a net GAME is to be started*/
void netit (void)
{
	int i;

	myGame.noPlayers=hmiNETNOWGetActiveNodes();
	me.node=hmiNETNOWGetConsoleNode();
	TRANSMIT_SYSTEM= 1;

	/*This bit looks EXTREMELY DUBIOUS. Should be in net software*/
 	for (i=0;i<MAX_PLAYERS;i++)
 	{

		if (playerList.slot[i]&&playerPaks[i].node==me.node)
 	 	{
 	 		myID=i;
			tanks[myID]= &pl;
 	 	}

		tanks[i]= &(human_enemy_tanks[i]);
 	 }

	tanks[myID]= &pl;

	/*Ensures player regains marks if rejoining game*/
	ntanks[myID]->marks= playerPaks[myID].marks;

// dave's a bit squirty and I'm having to type in this shitty comment.

//	SoundLoadSamples(sfxFiles,arraysize(sfxFiles));
	net_main();
//	SoundFreeSamples();
}
#endif



#ifdef FLOPPY_VERSION


char	animTable[2][11] =
{
	{0,1,2,3,4,5,4,3,2,1,0},
	{6,7,8,9,10,11,10,9,8,7,6}
};


typedef struct
{
	uint	x;
	uint	y;
	uint	stx;
	uint	sty;
	uint	scale;
	int		scaleChange;
	uint	on;
	uint	cyclex;
	uint	cycley;
	uint	cyclexStep;
	uint	cycleyStep;
	int		xscale;
	int		yscale;
	uint	frame;
	uint	animcount;
	uint	transparent;
	uint	trailing;
	uint	animating;
	uint	modecount;
	uint	animTable;
}A_GEEZER;


typedef struct
{
	uint	used;
	uint	sprType;
	uint	sprNum;
}SPR_SLOT;

typedef struct
{
	uint	used;
	uint	x;
	uint	y;
	uint	scale;
	uint	trans;
	uint	shade;
	uint	frm;
}FRFX_SPR;

#define FLOPPY_MISSION		5

#define GET_IT_ON					500
#define ANGRY_SCOTTSMAN		1000
#define FRONTEND_LIMIT		2000
#define GEEZER_START_SIZE	0X28000
#define SCALE_SPEED				0X200
#define TURN_ON_GEEZERS		100
#define LARGEST_GEEZER 		0X6000
#define SMALLEST_GEEZER   0X14000
#define MAX_VEG_ANIM_FRM	9
#define CHANGE_BACKDROP		1000
#define MODE_CHANGE				0x100
#define CHANGE_FRAME			8
#define MAX_FRAMES				10
#define MAX_SPR_SLOTS			64
#define MAX_FR_FX_SPRS		32
#define	GEEZER_SPRITE			0
#define FR_FX_SPRITE			1


#define TRAN_MODE					1
#define TRAIL_MODE				(1<<1)
#define ANIMATE_MODE			(1<<2)


enum { MANSOOR_SPRITE = 0, DELL_SPRITE };
enum { NORMAL_BACKDROP = 0, RIZLA_BACKDROP, DAVE_BACKDROP };

char	*frontpal;
uchar	*veggraphs;
short	*vegnet;
uchar	*vegfront;
uchar	*rizlafront;
uchar	*davespaz;
A_GEEZER geezers[2];
FRFX_SPR frontsprs[MAX_FR_FX_SPRS];
SPR_SLOT drawList[MAX_SPR_SLOTS];

uint	frontendTimer;
uint	backdropId;
uint	cycleBackdrop;
int	fframes;

uchar	*vegwad;

void 	draw_shite(void);
void	init_geezers(void);
void	animate_geezers(void);
void	put_in_slot_list(uint sprtype, uint i);
void	animate_fr_fx_sprite(A_GEEZER *ageezer);
void	start_fr_fx_sprites(void);



void		floppy_main(void)
{
	int i;
	uint	runs=0;

	memset(blackpal,0,768);
	debug_msg("Reset the black palette\n");

	while ( TRUE )
	{
		vegwad = open_wad_file("wadds\\veg.shk");

		vegfront = load_wad_file("veg1.raw",NULL);
		frontpal = load_wad_file("veg.pal",NULL);
		for (i=0;i<768;i++)
		{
			frontpal[i]>>=2;
		}
 		debug_msg("Adjusted the palette");

		veggraphs = load_wad_file("geezer.pcd", NULL);
		vegnet = load_wad_file("geezer.net", NULL);
		rizlafront = load_wad_file("veg2.raw",NULL);
		davespaz = load_wad_file("veg3.raw",NULL);
		odepths = load_wad_file("veg.dep", NULL);
		interpol_tab = load_wad_file("veg.int", NULL);
		memset(drawList, 0, sizeof(drawList));
		memset(frontsprs, 0, sizeof(frontsprs));


		close_wad_file();

		init_geezers();
		backdropId = NORMAL_BACKDROP;
		cycleBackdrop = FALSE;
		frontendTimer = 0;
		sprite_y_clip = 199;
		scr_ptr = p1screen;

		// fade to black palette
		memset(blackpal,0,768);
		fade_to_pal(10, blackpal);
		wait_fade();

		// fade it in.
		fade_to_pal(10, frontpal);
		wait_fade();

		while ( TRUE )
		{
			fframes = Sync();

			draw_shite();

			ScreenDump();

			for ( ;fframes>=0; fframes-- )
			{
				animate_geezers();
			}

			ifkey(K_ESC)
				getout("See yah");

			if(keydata->keys_held!=0)
				break;
		}

		free_mem(vegwad);

		// play the fuckin' game

		game_data = original_game_data;	// reset the state of the tank

		game_data.nextmiss = game_data.mission = FLOPPY_MISSION;

		if ( forcedgame )
		{
			game_data.nextmiss = game_data.mission = forcedgame;
		}


		fade_to_pal(10, blackpal);
		wait_fade();

		debug_msg("Entering game.\n");
		my_main();
		while ( (keydata->keys_held!=0) ) {}
		debug_msg("Leaving game.\n");

		runs++;

		if ( runs>10000 )
		{
			happy=TRUE;
		}
	}
}



void draw_shite(void)
{
	int i;
	A_GEEZER *geezer;
	SPR_SLOT *slot;
	FRFX_SPR	*fxspr;

	// dump the 'frontend screen'.

	if ( !happy )
	{
		memcpy(p1screen, vegfront, 320*200);
		return ;
	}

	switch ( backdropId )
	{
		case NORMAL_BACKDROP:
			memcpy(p1screen, vegfront, 320*200);
			break;

		case RIZLA_BACKDROP:
			memcpy(p1screen, rizlafront, 320*200);
			break;

		case DAVE_BACKDROP:
			memcpy(p1screen, davespaz, 320*200);
			break;
	}


	// clear the draw list
	memset(drawList, 0, sizeof(drawList));


	// fill up the draw list

	for ( i=0, geezer=geezers; i<2; i++, geezer++ )
	{
		if ( geezer->on )
		{
			put_in_slot_list(GEEZER_SPRITE, i);
		}
	}

	for ( i=0, fxspr=frontsprs; i<MAX_FR_FX_SPRS; i++, fxspr++ )
	{
		if ( fxspr->used )
		{
			put_in_slot_list(FR_FX_SPRITE, i);
		}
	}


	// Dump the draw list

	for ( i=0, slot=(drawList+MAX_SPR_SLOTS-1); i<MAX_SPR_SLOTS; i++, slot-- )
	{
		if ( slot->used )
		{
			switch ( slot->sprType )
			{
				case GEEZER_SPRITE:
					geezer = geezers + slot->sprNum;
					scale_sprite(geezer->x, geezer->y, geezer->scale, animTable[geezer->animTable][geezer->frame], 32, FALSE, geezer->transparent, (uchar*)veggraphs, (uchar*)vegnet);
					break;

				case FR_FX_SPRITE:
					fxspr = frontsprs + slot->sprNum;
					scale_sprite(fxspr->x, fxspr->y, fxspr->scale, fxspr->frm, 32, FALSE, fxspr->trans, (uchar*)veggraphs, (uchar*)vegnet);
					break;
			}
		}
	}
}




void	init_geezers(void)
{
	int i;
	A_GEEZER *geezer;

	for ( i=0, geezer=geezers; i<2; i++, geezer++ )
	{
		geezer->on=FALSE;
		geezer->scale=GEEZER_START_SIZE - (i<<8);

		geezer->stx = 130 + (rand()%60);
		geezer->sty = 80 + (rand()%40);
		geezer->scaleChange = -SCALE_SPEED;

		geezer->cyclex = rand()&0x7ff;
		geezer->cycley = rand()&0x7ff;

		geezer->cyclexStep = (rand()&0x3)+1;
		geezer->cycleyStep = (rand()&0x3)+1;

		geezer->xscale = (rand()&0x3)+1;
		geezer->yscale = (rand()&0x3)+1;

		geezer->frame = 0;

		geezer->modecount = rand()&0x3f;

		geezer->animTable = i;

		geezer->transparent = geezer->trailing = 0;
	}
}



void	animate_geezers(void)
{
	int i;
	A_GEEZER *geezer;

	if ( happy )
	{
		frontendTimer++;
	}


	// put credits code in here.



	if ( !happy )
	{
		return ;
	}

	if ( (!cycleBackdrop) && (frontendTimer==TURN_ON_GEEZERS) )
	{
		for ( i=0, geezer=geezers; i<2; i++, geezer++ )
		{
			geezer->on = TRUE;
		}
		frontendTimer=0;
		cycleBackdrop=TRUE;
	}
	else
	{
		if ( frontendTimer==CHANGE_BACKDROP )
		{
			frontendTimer=0;
			backdropId++;
			if ( backdropId>DAVE_BACKDROP )
			{
				backdropId=NORMAL_BACKDROP;
			}
		}

		/*-----------------08/02/96 20:11-------------------
		 MOVE THE GEEZERS HERE
		--------------------------------------------------*/

		for ( i=0, geezer=geezers; i<2; i++, geezer++ )
		{
			geezer->scale+=geezer->scaleChange;

			if ( geezer->scaleChange < 0 )
			{
				if ( geezer->scale < LARGEST_GEEZER )
				{
					geezer->scaleChange = SCALE_SPEED;
				}
			}
			else
			{
				if ( geezer->scale > SMALLEST_GEEZER )
				{
					geezer->scaleChange = -SCALE_SPEED;
				}
			}


			geezer->x = geezer->stx + ((int)( (100*sintab[(geezer->cyclex*geezer->xscale)&0x7ff]) >> 15));
			geezer->y = geezer->sty + ((int)( ( 60*sintab[(geezer->cycley*geezer->yscale)&0x7ff]) >> 15));

			geezer->cyclex = (geezer->cyclex+geezer->cyclexStep)&0x7ff;
			geezer->cycley = (geezer->cycley+geezer->cycleyStep)&0x7ff;

			geezer->modecount++;

			if ( geezer->modecount==MODE_CHANGE )
			{
				int	newmode;

				geezer->modecount=0;
				newmode = rand()&0x7;

				if ( newmode&TRAN_MODE  )
				{
					geezer->transparent=TRUE;
				}
				else
				{
					geezer->transparent=FALSE;
				}

				if ( newmode&ANIMATE_MODE )
				{
					if(!geezer->animating)
					{
						geezer->animating=TRUE;
						geezer->frame=0;
						geezer->animcount=0;
					}
				}

				if ( newmode&TRAIL_MODE )
				{
					geezer->trailing=TRUE;
				}
				else
				{
					geezer->trailing=FALSE;
				}
			}

			if ( geezer->animating )
			{
				if ( geezer->animcount==CHANGE_FRAME )
				{
					geezer->animcount=0;
					geezer->frame++;
					if ( geezer->frame == MAX_FRAMES )
					{
						geezer->animating=FALSE;
						geezer->frame=0;
					}
				}
				else
					geezer->animcount++;
			}

			if ( (geezer->trailing) && ((geezer->modecount&7)==7) )
			{
				start_fr_fx_sprite(geezer);
			}
		}

		animate_fr_fx_sprites();
	}
}


void	start_fr_fx_sprite(A_GEEZER *ageezer)
{
	int i;
	FRFX_SPR *freespr;

	for ( i=0, freespr=frontsprs; i<MAX_FR_FX_SPRS; i++, freespr++ )
	{
		if ( !freespr->used )
		{
			freespr->used=TRUE;
			freespr->shade=32;
			freespr->x=ageezer->x;
			freespr->y=ageezer->y;
			freespr->scale=ageezer->scale;
			freespr->trans=ageezer->transparent;
			freespr->shade=32;
			freespr->frm = animTable[ageezer->animTable][ageezer->frame];
			break;
		}
	}
}


void	animate_fr_fx_sprites(void)
{
	int i;
	FRFX_SPR *freespr;

	for ( i=0, freespr=frontsprs; i<MAX_FR_FX_SPRS; i++, freespr++ )
	{
		if ( freespr->used )
		{
			freespr->shade--;
			if ( freespr->shade==0 )
			{
				freespr->used=FALSE;
			}
		}
	}
}



void	put_in_slot_list(uint sprType, uint i)
{
	int insertSlot;
	SPR_SLOT *freeSlot;

	if ( sprType==GEEZER_SPRITE )
	{
		insertSlot = ((geezers+i)->scale)>>12;
	}
	else
		insertSlot = ((frontsprs+i)->scale)>>12;

	freeSlot = drawList + insertSlot;

	while ( freeSlot->used && insertSlot<MAX_SPR_SLOTS )
	{
		freeSlot++;
		insertSlot++;
	}

	if ( insertSlot<MAX_SPR_SLOTS )
	{
		freeSlot->used = TRUE;
		freeSlot->sprType = sprType;
		freeSlot->sprNum = i;
	}
}



#endif


