int		phd_winwidth = 320;
int		phd_winheight = 200;


typedef struct phd_xbuf {
	int	Xleft;
	int Xright;
} PHD_XBUF;


PHD_XBUF	xbuffer[200];


/****************************************************************************
 *				Draw Flat Shaded Polygon..
 ***************************************************************************/
void	draw_poly_flat( sint16 *iptr )
{
	if ( (iptr = xgen_x(iptr)) )
		flatA( xgen_ymin, xgen_ymax, (char)*(iptr) );
}


/****************************************************************************
 ****************************************************************************
 *			Generate Polygon X coords ....
 ****************************************************************************
 ***************************************************************************/

entry short ptr to
;; number coords
; x1,y1,,
; x2,y2..etc      Clockwise!!!

sint16	*xgen_x( sint16 *iptr )
{
	int     	fcoords[16][2];			/* coords in clockwise order .....*/
	int			*lptr,*rptr;
	PHD_XBUF	*xptr;
	int			min_x,min_y;
	int			max_x,max_y;
	int			xadd,ydif;
	int			i,x1,y1,y2;
	int			numcoords;

	numcoords = (int)*(iptr++);						   /* Get Number Coords*/
	min_x = max_x = fcoords[numcoords][0] = fcoords[0][0] = (int)*(iptr);
	min_y = max_y = fcoords[numcoords][1] = fcoords[0][1] = (int)*(iptr+1);
	rptr = fcoords;
	iptr += 2;
	for ( i=1; i<numcoords; i++,iptr+=2 ) 	   		   /* find min,max X and Y*/
	{
		x1 = fcoords[i+numcoords][0] = fcoords[i][0] = (int)*(iptr);
		y1 = fcoords[i+numcoords][1] = fcoords[i][1] = (int)*(iptr+1);
		if ( x1<min_x )
			min_x = x1;
		else if ( x1>max_x )
			max_x = x1;
		if ( y1<min_y )
		{
			min_y = y1;
			rptr = &fcoords[i][0];
		}
		else if ( y1>max_y )
			max_y = y1;
	}
	if ( max_x<0 || max_y<0 || min_y==max_y || min_x>=phd_winwidth || min_y>=phd_winheight )
		return( NULL );

	if ( min_y<0 )
		min_y=0;
	if ( max_y>phd_winheight )
		max_y=phd_winheight;
	xgen_ymin = min_y;				// Insert Global Y bounds..
	xgen_ymax = max_y;


	lptr = rptr + (numcoords*2);

	xptr = xbuffer;
	for ( ;; lptr-=2 )  			/* for Left Hand Side.. */
	{
		y1 = *(lptr+1);       		/* get top y... */
		if ( y1>=max_y )
			break;
		y2 = *(lptr-1);     		/* get next y dowm */
		ydif = y2-y1;               /* calc y difference */

		if ( ydif>0 && y2>=0 ) 		/* if difference in Y */
		{
			x1 = *(lptr);							/* get top x... */
			xadd = ((*(lptr-2)-x1)<<16)/ydif;       /* Get Xadder */
			x1 = (x1<<16) + 0x00001;
			if ( y1<0 )
			{
				x1 -= y1*xadd;
				y1 = 0;
			}
			if ( y2>phd_winheight )
				y2 = phd_winheight;

  			for ( ; y1<y2; y1++,xptr++)
			{
   				x1 += xadd;
				xptr->Xleft = x1;
	   		}
  		}
	}

	xptr = xbuffer;
	for ( ;; rptr+=2 )  			/* for Right Hand Side... */
	{
		y1 = *(rptr+1);       		/* get top y... */
		if ( y1>=max_y )
			break;
		y2 = *(rptr+3);     		/* get next y dowm */
		ydif = y2-y1;               /* calc y difference */

		if ( ydif>0 && y2>=0 ) 		/* if difference in Y */
		{
			x1 = *(rptr);							/* get top x... */
			xadd = ((*(rptr+2)-x1)<<16)/ydif;
			x1 = (x1<<16) + 0x0ffff;

			if ( y1<0 )
			{
				x1 -= y1*xadd;
				y1 = 0;
			}
			if ( y2>phd_winheight )
				y2 = phd_winheight;

  			for ( ; y1<y2; y1++,xptr++)
			{
   				x1 += xadd;
				xptr->Xright = x1;
	   		}
  		}
	}
	return( iptr );
}


;***************************************************************************
;			Output Flat-Shaded Polygon
;***************************************************************************
flatA_ PROC PUBLIC

		pushad
		sub		edx,eax
		jle		@@exit

		cld									 ; Clear direction flag!
		lea     esi,[xbuffer+2]              ; Get Address Xbuffer

        imul    eax,[phd_scrwidth]      	 ; ebp = Line Pointer
		add		eax,[phd_winptr]
		mov		ebp,eax

		mov		bh,bl                   	 ; make eax = 4 Bytes of Color
		mov		ax,bx
		bswap	eax
		mov		ax,bx


@@lineloop:
		movsx	ecx,WORD PTR[esi]			 ; Get Xleft
		test	ecx,ecx
		jns		@@x1ok
		xor		ecx,ecx
@@x1ok: movsx	ebx,WORD PTR[esi+4]    	 	 ; Get Xright
		cmp		ebx,DWORD PTR[phd_winwidth]
		jle		@@x2ok
		mov		ebx,DWORD PTR[phd_winwidth]
@@x2ok:	sub		ebx,ecx  					 ; ebx = Xdif
		jle		@@nexl
		lea		edi,[ebp+ecx]				 ; edi = Pixptr
		neg		ecx                      	 ; negate xleft
		and		ecx,3 	                     ; get pixels to nearest longword
		cmp		ecx,ebx   	                 ; if this is >= num pixels branch
		jge		@bout
		sub		ebx,ecx       	           	 ; subtract from num pixels
		rep		stosb           	         ; store start number pixels
		mov		ecx,ebx               	   	 ; copy num pixels to ecx
		sar		ecx,2 	                     ; shift down by 2
		rep		stosd   	                 ; store longwords
		and		ebx,3        	           	 ; make ebx = 0-3
@bout:	mov		ecx,ebx           	       	 ; copy to ecx
		rep		stosb               	     ; store ecx bytes
@@nexl:	add		esi,8						 ; increment Xbuffer
		add		ebp,DWORD PTR[phd_scrwidth]	 ; Add screen width to LinePtr
		dec		edx
		jnz		@@lineloop
@@exit:	popad
		ret

flatA_ ENDP

