/* For use with object map detection. */

#define DET_TANK_D	0x01	/* Can the tank destroy the object. */
#define DET_SHELL_D	0x02	/* Can shells detroy the object. */
#define DET_PICKUP	0x04	/* Pickup? */
#define DET_SOLID		0x08	/* Object unpassable? */
#define DET_EXP			0x10	/* Object destroyable by explosion radius? */
#define DET_MINE		0X20	/* MINE OBJECT */


/* Linklist tags. */

#define TANK_TAG			0x01
#define HELI_TAG			0x02
#define PL_BULLET_TAG	0x03
#define EN_BULLET_TAG	0x04
#define GUN_EMPL_TAG	0x05
#define PL_SHELL_TAG	0x06
#define EN_SHELL_TAG	0x07
#define SAM_TAG	 			0x08
#define GUNBOAT_TAG		0x09
#define HOSTAGE_TAG		0x0A
#define ASM_TAG				0x10

/* Gibby's global variables. */

enum	{	WMAIN_GUN = 0, WCHAIN_GUN, WSAMS, W911B, W911A, MAX_WEAPONS, WANTI_MINE, TRIPLE, MAX_TOTAL_WEAPONS	};
#define BULLET_COL	236

extern	struct	tank_defs	td[];
extern	struct	eng_upg		eu[];
extern	struct	trak_upg	tu[];
extern	struct	bullets		*pl_bullets;
extern	struct	bullets		*en_bullets;
extern	struct	sams			sam[];
extern	struct	target		targ;
extern	int			otargLocked;

extern	struct	single_point	spnt;
extern	struct	closest_targets		ct[5];
extern	struct	target_points		tp[];

extern	short		engine_upg;
extern	short		track_upg;
extern	short		region;
extern	short		sunk,sink_add;
extern	short		cam_dist;
extern	short		target_no,change_target;
extern	short		tp_off;

extern	uchar		char_anim, chgun_lr;

extern 	long		tiltvel,tiltvelvel,objhitcnt;
extern	long		glob1,glob2,glob3,glob4;

extern	short		grip_tab[];
extern	short		slowd_tab[];
extern	short		det_tabs[6][64];

struct	single_point
{
		short		x;
		short		y;
		short		z;
};

struct	target_points
{
	long		scr_off;	/* Screen offset. */
	long		index;	/* Index into structure. */
	long		type;	/* 0 = Tank, Gun emplacement or Helicopter. */
	long		visible;	/* 0 = No, 1 = Yes. */
};


