#include "headers.h"

#include "chuck.h"
#include "frames.h"
#include "e_global.h"

#ifdef MEMCHK
#include <memcheck.h>
#endif

//*** take_this_out
extern int numFXspr;
extern int aadj;
//*****************



#define NUM_FRAGS								16


// take_this_out
int FxUsed;

////////////////



extern	ushort	currentIgnoreValue;		/*Used to speed up tank collision detection */

/*changed from static for DNETWORK reason*/
MOBS				*cmob;
static	SHELL_DATA 	*cshell;
static	TANK				*ctank;
static	struct	sams	*sam_ptr;

static	uchar	*delayTime, *delayType;
static	uint	started;
static	POSITION tempPos;






void	trigger_fx_sprite(int	animNum, int animx, int animy, int animz, int looping, int spriteType, int scaling, int rising);

void 	move_sprs(void);
void 	setup_mobs(void);
void	animate_fx_sprites(void);
void	animate_fragments(void);
void	update_delayed_fx(void);
void	setup_delayed_fx(int	delayFXgroup, POSITION *pos);
void	trigger_shroom(POSITION *shroomPos, int);
void 	get_gunboats(void);
void	get_gun_emplacements(void);
void	get_helicopters(void);
void 	get_hostages(void);
void	get_asms(void);
void	get_sams(void);







/*
	ANIMATION and MOVEMENT function declarations.
*/

void	get_shells(void);

void	update_shell_positions(void);



/* Animate the animting sprites */

void	anim_sprs(void)
{
	char_anim++;
	update_delayed_fx();
	animate_fx_sprites();
	animate_fragments();
}




/* Move all the moving objects */

void move_sprs(void)
{
	move_gunboats();

	move_tanks();
	move_helicopters();
	do_gun_emplacements();
	do_hostages();

	get_bullet_detectable_enemies();
	update_shell_positions();
	update_bullets();
	update_sams();
}



/*********************************************************************/

/* Get all the relevant objects into the mob list */

void setup_mobs(void)
{
	cmob = mob;

  get_enemy_tanks();										// Put them into the drawing loop
	get_gun_emplacements();
	get_gunboats();
	get_helicopters();
	get_hostages();
	get_shells();
	get_bullets();
	get_sams();
	get_asms();

	cmob->m_def = 0xffff;
}

/*********************************************************************/


#define MOB_DISPLAY_RANGE (48<<24)


/*-----------------09/10/95 15:34-------------------
 Put ASM's into the moblist
--------------------------------------------------*/

void	get_asms(void)
{
	ASM *casm;
	int	i;


	if ( !airSupportTriggerd )
	{
		return ;
	}

	for ( i=0, casm = asms; i<MAX_ASMS; i++, casm++)
	{
		if ( casm->fired )
		{
			cmob->m_ang = (32 - ((pangle - casm->angle) >>5) )&0x3f;
			cmob->m_x = casm->x>>16;
			cmob->m_y = casm->y;
			cmob->m_z = casm->z>>16;
			cmob->m_def = ROTATING_OBJECT_TAG+ASMS;
  		cmob->m_plyr = (i<<8) + ASM_TAG;
			cmob++;
		}
	}
}


/*********************************************************************/


void	get_helicopters(void)
{
	TANK *cheli;
	uint	 i;

	for ( i=0, cheli=helicopters; i<MAX_HELICOPTERS; i++, cheli++ )
	{
		cheli->sy = -1;
		if ( cheli->def && (cheli->def!=REGENERATE_OBJECT) && (cheli->flying))
		{
			if ( (abs(cheli->x-pl.x)<MOB_DISPLAY_RANGE) && ((abs(cheli->z-pl.z)<MOB_DISPLAY_RANGE)) )
			{

  			cmob->m_ang = (32 - ((pangle - cheli->angle) >>5) )&0x3f;
  			cmob->m_x 	= cheli->x>>16;
  			cmob->m_y 	= cheli->y;
  			cmob->m_z 	= cheli->z>>16;
  			cmob->m_def = ROTATING_OBJECT_TAG+cheli->def;
  			cmob->m_plyr = (i << 8) + HELI_TAG;	/* Tag to position in enemy tank list. */
  			cmob++;
			}
		}
	}
}



/*********************************************************************/




/* Put the enemy tanks into the mob list */

void	get_enemy_tanks(void)
{
	uint	i;

	for ( i=0, ctank=enemyTanks; i<MAX_ENEMY_TANKS; ctank++,i++ )
	{
		ctank->sy = -1;
		if ( ctank->def && (ctank->def!=REGENERATE_OBJECT))
		{
			if ( (abs(ctank->x-pl.x)<MOB_DISPLAY_RANGE) && ((abs(ctank->z-pl.z)<MOB_DISPLAY_RANGE)) )
			{
  			cmob->m_ang = (32 - ((pangle - ctank->angle) >>5) )&0x3f;
  			cmob->m_x 	= ctank->x>>16;
  			cmob->m_y 	= 0;
  			cmob->m_z 	= ctank->z>>16;
  			cmob->m_def = ROTATING_OBJECT_TAG+ctank->def;
  			cmob->m_plyr = (i << 8) + TANK_TAG;	/* Tag to position in enemy tank list. */
  			cmob++;
			}
		}
	}
}


/*********************************************************************/


void	get_gun_emplacements(void)
{
	GUN_EMPLACEMENT *cgunempl;
	uint	i;

	for ( i=0, cgunempl=gunempls; i<MAX_GUN_EMPLS; i++, cgunempl++)
	{
		cgunempl->sy = -1;
		if ( cgunempl->exist )
		{
			if ( (abs(cgunempl->x - pl.x)<MOB_DISPLAY_RANGE) && ((abs(cgunempl->z - pl.z)<MOB_DISPLAY_RANGE)) )
			{
  			cmob->m_ang = (32 - ((pangle - cgunempl->angle) >>5) )&0x3f;
  			cmob->m_x 	= cgunempl->x>>16;
  			cmob->m_y 	= 0;
  			cmob->m_z 	= cgunempl->z>>16;
  			cmob->m_def = ROTATING_OBJECT_TAG+E_GUNEMPL;
  			cmob->m_plyr = (i << 8) + GUN_EMPL_TAG;	/* Tag to position in enemy tank list. */
  			cmob++;
			}
		}
	}
}


/*********************************************************************/


void get_gunboats(void)
{
	GUN_BOAT *cgunboat;
	uint	i;

	for ( i=0, cgunboat=gunboats; i<MAX_GUN_BOATS; i++, cgunboat++)
	{
		if ( cgunboat->exist )
		{
			if ( (abs(cgunboat->x - pl.x)<MOB_DISPLAY_RANGE) && ((abs(cgunboat->z - pl.z)<MOB_DISPLAY_RANGE)) )
			{
  			cmob->m_ang = (32 - ((pangle - cgunboat->angle) >>5) )&0x3f;
  			cmob->m_x 	= cgunboat->x>>16;
  			cmob->m_y 	= 0;
  			cmob->m_z 	= cgunboat->z>>16;
  			cmob->m_def = ROTATING_OBJECT_TAG+ENEMY_GUNBOAT;
  			cmob->m_plyr = (i << 8) + GUNBOAT_TAG;	/* Tag to position in enemy tank list. */
  			cmob++;
			}
		}
	}
}


/*********************************************************************/



void get_hostages(void)
{
	HOSTAGE	*chostage;
	uint	i;

	for ( i=0, chostage=hostages; i<MAX_HOSTAGES; i++, chostage++  )
	{
		if ( chostage->def )
		{
			if ( (abs(chostage->x - pl.x)<MOB_DISPLAY_RANGE) && ((abs(chostage->z - pl.z)<MOB_DISPLAY_RANGE)) )
			{
  			cmob->m_ang = (32 - ((pangle - chostage->angle) >>5) )&0x3f;
  			cmob->m_x 	= chostage->x>>16;
  			cmob->m_y 	= 0;
  			cmob->m_z 	= chostage->z>>16;
  			cmob->m_def = ROTATING_OBJECT_TAG+chostage->def;
  			cmob->m_plyr = (i << 8) + HOSTAGE_TAG;	/* Tag to position in enemy tank list. */
  			cmob++;
			}
		}
	}
}


/*********************************************************************/


/* Put the shells into the mob list */

void	get_shells(void)
{
	uint	i;

	for ( i=0, cshell=playerShells; i<MAX_PLAYER_SHELLS; i++, cshell++)
	{
		if ( cshell->fired )
		{
			cmob->m_ang = (32 - ((pangle - cshell->direction) >>5) )&0x3f;
			cmob->m_x = cshell->x>>16;
			cmob->m_y = cshell->y;
			cmob->m_z = cshell->z>>16;
			cmob->m_def = ROTATING_OBJECT_TAG+SHELL;
  		cmob->m_plyr = (i << 8) + PL_SHELL_TAG;
			cmob++;
		}
	}

	for ( i=0, cshell=enemyShells; i<MAX_ENEMY_SHELLS; i++, cshell++)
	{
		if ( cshell->fired )
		{
			cmob->m_ang = (32 - ((pangle - cshell->direction) >>5) )&0x3f;
			cmob->m_x = cshell->x>>16;
			cmob->m_y = cshell->y;
			cmob->m_z = cshell->z>>16;
			cmob->m_def = ROTATING_OBJECT_TAG+SHELL;
  		cmob->m_plyr = (i << 8) + EN_SHELL_TAG;
			cmob++;
		}
	}
}


/*********************************************************************/



void	get_bullets(void)
{
	struct	bullets	*bull_ptr;
	uint	i;

	for ( i=0, bull_ptr = &pl_bullets[0]; i<(MAX_PLAYER_SHELLS<<2); i++, bull_ptr++)
	{
		if ( bull_ptr->on )
		{
			cmob->m_ang = 0;
			cmob->m_x = bull_ptr->x >> 16;
			cmob->m_y = bull_ptr->y >> 16;
			cmob->m_z = bull_ptr->z >> 16;
			cmob->m_def = BULLET_TAG;
			cmob->m_plyr = (i << 8) + PL_BULLET_TAG;
			cmob++;
		}
	}

	for ( i=0, bull_ptr = en_bullets; i<(MAX_ENEMY_SHELLS<<2); i++, bull_ptr++)
	{
		if ( bull_ptr->on )
		{
			cmob->m_ang = 0;
			cmob->m_x = bull_ptr->x >> 16;
			cmob->m_y = bull_ptr->y >> 16;
			cmob->m_z = bull_ptr->z >> 16;
			cmob->m_def = BULLET_TAG;
			cmob->m_plyr = (i << 8) + EN_BULLET_TAG;
			cmob++;
		}
	}
}


/*********************************************************************/


void	get_sams(void)
{
	int	i;

	for ( i=0, sam_ptr = &sam[0]; i<MAX_SAMS; i++, sam_ptr++)
	{
		if ( sam_ptr->fired )
		{
			cmob->m_ang = (32 - ((pangle - sam_ptr->dir) >>5) )&0x3f;
			cmob->m_x = sam_ptr->x>>16;
			cmob->m_y = sam_ptr->y;
			cmob->m_z = sam_ptr->z>>16;
			cmob->m_def = ROTATING_OBJECT_TAG+SAMS;
  		cmob->m_plyr = (i<<8) + SAM_TAG;
			cmob++;
		}
	}
}



/*********************************************************************/



void	update_sams(void)
{
	int	samx,samz,helx,helz,diff,diffadd,accval,i;

	for ( i=0, sam_ptr = &sam[0]; i<MAX_SAMS; i++, sam_ptr++)
	{
		if ( sam_ptr->fired )
		{
			ctank = helicopters + sam_ptr->index;

			if ( (!ctank->def) || (!ctank->flying) || (ctank->def==REGENERATE_OBJECT) )
			{
				sam_ptr->fired = FALSE;
				trigger_fx_sprite(AIRBURST_ANIM, sam_ptr->x, sam_ptr->y, sam_ptr->z, FALSE, 0, MEDIUM_SPRITE, FALSE);
				continue;
			}

			if (sam_ptr->speed < 0x800)
			{
				accval = ((0x800 - sam_ptr->speed) >> 5) + 16;
				sam_ptr->speed += accval;
			}

			if (sam_ptr->y < (ctank->y - 120))
				sam_ptr->yvel++;
			else if (sam_ptr->y > (ctank->y - 104))
				sam_ptr->yvel--;
			else
				sam_ptr->yvel>>=1;

			if (sam_ptr->yvel < -6)
				sam_ptr->yvel = -6;
			else if (sam_ptr->yvel > 6)
				sam_ptr->yvel = 6;

			samx = (int)((sam_ptr->x) >> 16);
 			samz = (int)((sam_ptr->z) >> 16);
			helx = (int)((ctank->x) >> 16);
 			helz = (int)((ctank->z) >> 16);
 			sam_ptr->angle = phd_atan((samx - helx),(samz - helz)) & 0x7ff;

 			diff = sam_ptr->dir - sam_ptr->angle;

 			if (diff < -1024)
 				diff += 2048;
 			else if (diff > 1024)
 				diff -= 2048;

			if (diff > 0)
			{
				if(sam_ptr->turn > 0)
					sam_ptr->turn >>= 1;
				sam_ptr->turn -= 2;
				if (sam_ptr->turn < -sam_ptr->maxturn)
					sam_ptr->turn = -sam_ptr->maxturn;
			}
			else
			{
				if(sam_ptr->turn < 0)
					sam_ptr->turn >>= 1;
				sam_ptr->turn += 2;
				if (sam_ptr->turn > sam_ptr->maxturn)
					sam_ptr->turn = sam_ptr->maxturn;
			}

			sam_ptr->dir += sam_ptr->turn;
			sam_ptr->dir &=0x7ff;

			if (sam_ptr->dir != sam_ptr->angle)
			{
 				diff = sam_ptr->dir - sam_ptr->angle;

 				if (diff < -1024)
 					diff += 2048;
 				else if (diff > 1024)
 					diff -= 2048;

				if(abs(diff) > 512)	/* Very large angle, reduce speed to compensate. */
				{
					//sam_ptr->speed -= (sam_ptr->speed>>2);
					sam_ptr->maxturn = 24;
				}
				else
					sam_ptr->maxturn = 12;

				diffadd = abs(diff >> 5) + 1;

				if (diff < 0)
					sam_ptr->dir += diffadd;
				else
					sam_ptr->dir -= diffadd;
				sam_ptr->dir &=0x7ff;
			}

			sam_ptr->oldx = sam_ptr->x;
			sam_ptr->oldz = sam_ptr->z;



	 		sam_ptr->x += (sam_ptr->speed >> 5) * ((int)sintab[sam_ptr->dir]);
			sam_ptr->y += sam_ptr->yvel;
	 		sam_ptr->z += (sam_ptr->speed >> 5) * ((int)sintab[sam_ptr->dir + 512]);

			if ( char_anim&2 )
			{
				trigger_fx_sprite(TRAIL_SMOKE, sam_ptr->x, sam_ptr->y, sam_ptr->z, FALSE, TRANSPARENT_SPRITE, LARGE_SPRITE, FALSE);
			}
		}
	}

	detect_sams();
}


/*********************************************************************/


void	update_bullets(void)
{
	int	i;
	struct	bullets	*bull_ptr;

	for (i=0, bull_ptr=pl_bullets; i<(MAX_PLAYER_SHELLS<<2); i++, bull_ptr++)
	{
		if (bull_ptr->on)
		{
			if (bull_ptr->dist_travelled > bull_ptr->range || bull_ptr->y >= 0)
			{
				bull_ptr->on = 0;
				continue;
			}

			bull_ptr->oldx = bull_ptr->x;
			bull_ptr->oldy = bull_ptr->y;
			bull_ptr->oldz = bull_ptr->z;

			bull_ptr->x += (bull_ptr->speed >> 5) * ((int)sintab[bull_ptr->dir]);
			bull_ptr->y += bull_ptr->yvel;
			bull_ptr->z += (bull_ptr->speed >> 5) * ((int)sintab[bull_ptr->dir + 512]);
			bull_ptr->dist_travelled += (bull_ptr->speed >> 5);

		}
	}

	bullet_detection(pl_bullets, (MAX_PLAYER_SHELLS<<2));

	for (i=0, bull_ptr=en_bullets; i<(MAX_ENEMY_SHELLS<<2); i++, bull_ptr++)
	{
		if (bull_ptr->on)
		{
			if (bull_ptr->dist_travelled > bull_ptr->range || bull_ptr->y >= 0)
			{
				bull_ptr->on = 0;
				continue;
			}

			bull_ptr->oldx = bull_ptr->x;
			bull_ptr->oldy = bull_ptr->y;
			bull_ptr->oldz = bull_ptr->z;

			bull_ptr->x += (bull_ptr->speed >> 5) * ((int)sintab[bull_ptr->dir]);
			bull_ptr->y += bull_ptr->yvel;
			bull_ptr->z += (bull_ptr->speed >> 5) * ((int)sintab[bull_ptr->dir + 512]);
			bull_ptr->dist_travelled += (bull_ptr->speed >> 5);

		}
	}

	bullet_detection(en_bullets, (MAX_ENEMY_SHELLS<<2));
}


/*********************************************************************/

/* Move the shells on their current trajectory */

void	update_shell_positions(void)
{
	int	i;
	for ( i=0, cshell=playerShells; i<MAX_PLAYER_SHELLS; i++, cshell++ )
	{
		if ( cshell->fired )
		{
			if ( cshell->dist_travelled > cshell->range )
			{
				cshell->y+=4;
				if ( cshell->y>=0 )
				{
					shell_explosion_sound(cshell->x, cshell->z);

					#ifdef PC_VERSION
					#ifndef FLOPPY_VERSION
					/*TRANSMIT THE FACKAH! ..DNETWORK*/
					if (nDef.flags&TRANSMIT_EXPLOSIONS)
						SHELL_EXPLODE_REMOTE (i, SHELL_GROUND_EXPLOSION);
					#endif
					#endif


					trigger_explosion(SHELL_GROUND_EXPLOSION, (POSITION*)&(cshell->x), NULL);
					cshell->fired=0;
					continue;
				}
			}

			cshell->ox=cshell->x;
			cshell->oz=cshell->z;
			cshell->oy=cshell->y;
			cshell->x+=(cshell->speed>>5) * ((int)sintab[cshell->direction]);
			cshell->z+=(cshell->speed>>5) * ((int)sintab[cshell->direction+512]);

			cshell->dist_travelled += (cshell->speed>>5);

		}
	}

	for ( i=0, cshell=enemyShells; i<MAX_ENEMY_SHELLS; i++, cshell++ )
	{
		if ( cshell->fired )
		{
			if ( cshell->dist_travelled > cshell->range )
			{
				cshell->y+=4;
				if ( cshell->y>=0/*(-alt)*/ )
				{
					#ifdef PC_VERSION
					shell_explosion_sound(cshell->x, cshell->z);
					#endif
					trigger_explosion(SHELL_GROUND_EXPLOSION, (POSITION*)&(cshell->x), NULL);
					cshell->fired=0;
					continue;
				}
			}

			cshell->ox=cshell->x;
			cshell->oz=cshell->z;
			cshell->oy=cshell->y;
			cshell->x+=(cshell->speed>>5) * ((int)sintab[cshell->direction]);
			cshell->z+=(cshell->speed>>5) * ((int)sintab[cshell->direction+512]);

			cshell->dist_travelled += (cshell->speed>>5);
		}
	}

	shell_detect();
}

/***************************************************************/

/* Find a free slot in the fx list and return a pointer to it (or null if no free slots) */

FX_SPRITE* find_free_fx_slot(void)
{
	uint	fxslot;
	FX_SPRITE		*freeFx;


	for ( fxslot=0, freeFx=fxSprites; fxslot<MAX_FX_SPRITES; fxslot++, freeFx++ )
	{
		if ( !freeFx->used )
		{
			return(freeFx);
		}
	}

	return(NULL);
}



/***************************************************************/

/* Animate the current fx sprites in the world */

void	animate_fx_sprites(void)
{
	FX_SPRITE		*animSprite;
	int	i;

	// take_this_out
	FxUsed=0;
	/////////

	for ( i=0, animSprite=fxSprites; i<MAX_FX_SPRITES; i++, animSprite++ )
	{
		if ( animSprite->used )
		{
			// take_this_out
			FxUsed++;
			/////////

			animSprite->frmDelay++;
			if ( animSprite->frmDelay>=8 )
			{
				animSprite->frmDelay=0;
				animSprite->frm++;
				if ( animSprite->frm >= animSprite->frmTable[LAST_ANIM_FRAME] )
				{
					if ( animSprite->looping )			/* If fx sprite is looping then carry on indefinitely */
					{
						animSprite->frm = animSprite->frmTable[FIRST_ANIM_FRAME];
						animSprite->spriteType ^= FLIPPED_SPRITE;
						continue;
					}
					else
					{
						animSprite->used = FALSE;			/* If fx sprite isn't looping then terminate it */
						// take this out
						FxUsed--;
						/////////
						continue;
					}
				}
				if ( animSprite->rising )					/* Lift sprite if it's rising (smoke etc..) */
				{
					animSprite->y -=50;
				}
			}
		}
	}
}



/***************************************************************/


/* Finds a free fragment slot, and returns the addres of the fragment */

FRAGMENT_DATA* find_free_fragment_slot(void)
{
	uint	freeFragSlot;
	FRAGMENT_DATA		*freeFragment;


	for ( freeFragSlot=0, freeFragment=fragments; freeFragSlot<MAX_FRAGMENTS; freeFragSlot++, freeFragment++ )
	{
		if (!freeFragment->used )
		{
			return(freeFragment);
		}
	}

	return(NULL);
}


/***************************************************************/


/* Move and animate the fragments currently in the world */

void	animate_fragments(void)
{
	FRAGMENT_DATA		*animFrag;
	FX_SPRITE		*animSprite;
	int	i;

	for ( i=0, animFrag=fragments; i<MAX_FRAGMENTS; i++, animFrag++ )
	{
		if ( animFrag->used )
		{
			animSprite=animFrag->spr;

			animFrag->x += (animFrag->speed>>5) * ((int)sintab[animFrag->dir]);
			animFrag->z += (animFrag->speed>>5) * ((int)sintab[animFrag->dir+512]);

			animSprite->x = animFrag->x>>16;
			animSprite->z = animFrag->z>>16;

			animSprite->y+=(animFrag->yvel>>3);

			animFrag->yvel+=4;

			if ( animFrag->premature )
			{
				if ( animSprite->used==FALSE )
				{
					animFrag->used=FALSE;
					continue;
				}
				else
				if ( animFrag->yvel>=0 && animFrag->premature==TRUE)
				{
					animSprite->frmTable = animations[F_FRAG_EXPL_ANIM];
					animSprite->frm = animSprite->frmTable[FIRST_ANIM_FRAME];
					animSprite->looping=FALSE;
					animFrag->premature=MAYBE;
				}
			}
			else
			{
				if ( animSprite->y >= FLOOR_LEVEL)
				{
					/*-----------------17/10/95 10:59-------------------
					 Check if the fragment has landed on ground or water
					--------------------------------------------------*/
					if ( grip_tab[ ((*( floor_map + ((animSprite->x>>8)&0xff) + (animSprite->z & 0xff00) ))>>3)&0xff ] >=0 )
					{	/* hit solid ground */
						animFrag->used=animSprite->looping=FALSE;
						animSprite->spriteType = TRANSPARENT_SPRITE;
						animSprite->frmTable = animations[FRAG_DISIN_ANIM];
						animSprite->frm = animations[FRAG_DISIN_ANIM][FIRST_ANIM_FRAME];
					}
					else
					{ /* hit water */
						animFrag->used=animSprite->looping=FALSE;
						animSprite->spriteType = TRANSPARENT_SPRITE;;
						animSprite->frmTable = animations[WATER_SPLASH_ANIM];
						animSprite->frm = animations[WATER_SPLASH_ANIM][FIRST_ANIM_FRAME];
					}
					continue;
				}
			}
		}
	}
}




/* Sends out a number of fragments from a specified position */

void	trigger_fragments(int numFrags, POSITION *pos, int fragType)
{
	uint	frg;
	uint	fragAngleStep, cfragAngle=0;
	FX_SPRITE		*animSprite;
	FRAGMENT_DATA		*animFrag;


	fragAngleStep = 0x7ff/(numFrags+1);				/* Spread fragments out as evenly as possible */
	cfragAngle = 0;

	for ( frg=0; frg<numFrags; frg++, cfragAngle+=fragAngleStep )
	{
		if ( (animFrag=find_free_fragment_slot())!=NULL )
		{
			if ( (animSprite=find_free_fx_slot())!=NULL )
			{
				animFrag->spr = animSprite;


				animFrag->dir = cfragAngle + (rand()&0xff);
				animFrag->speed = 0x100 + (rand()&0xfff);
				animFrag->used = TRUE;
				animFrag->yvel = -100 - (rand()&0xff);
				animFrag->x = pos->x + (animFrag->speed>>5) * ((int)sintab[animFrag->dir]);
				animFrag->z = pos->z + (animFrag->speed>>5) * ((int)sintab[animFrag->dir+512]);

				animSprite->used=TRUE;

				animSprite->x = animFrag->x>>16;
				animSprite->z = animFrag->z>>16;

				/*-----------------13/10/95 17:02-------------------
				 Y pos of fragment epicentre
				--------------------------------------------------*/
				//animSprite->y = MID_TANK_HEIGHT ;
				animSprite->y = pos->y ;
				animSprite->rising = FALSE;
				animSprite->spriteType = 0;
				animSprite->frmDelay = 0;


				if ( rand()&0x7 ) /* Randomly pick a normal fragment which will continue till it hits the floor */
				{
					animSprite->scaling = MEDIUM_SPRITE;

					switch ( fragType )
					{
						case TANK_FRAGMENTS:
							animSprite->frmTable = animations[rand()%5];
							break;

						case BUILDING_FRAGMENTS:
							animSprite->frmTable = animations[CONCRETE_1_ANIM + (rand()%3)];
							break;

						case WOODEN_BULDING_FRAGMENTS:
							if ( rand()&3 )
							{
								animSprite->frmTable = animations[WOODEN_PLANK_ANIM];
							}
							else
								animSprite->frmTable = animations[TWIGS_1_ANIM + (rand()&1)];
							break;

						case TREE_FRAGMENTS:
							animSprite->frmTable = animations[TWIGS_1_ANIM + (rand()&1)];
							break;

						case CORRIGATED_FRAGMENT:
							animSprite->frmTable = animations[CORRI_METAL_ANIM];
							break;

						case WIRE_MESH_FRAGMENT:
							animFrag->speed = 0x100 + rand()&0xff;
							animSprite->frmTable = animations[WIRE_MESH_ANIM];
							break;

						case METAL_FRAGMENTS:
							animSprite->scaling = SMALL_SPRITE;
							animSprite->frmTable = animations[rand()%3];
							break;

						case FUEL_CONTAINER_FRAGMENTS:
							animSprite->frmTable = animations[FUEL_TANK_FRAG_ANIM];
							break;
					}

					animFrag->premature = FALSE;
				}
				else
				{									/* Or randomly pick a firey fragment which explodes mid air */
					animSprite->frmTable = animations[FRAGMENT6_ANIM];
					animFrag->premature = rand()&1; 					/* 1=mid air disintergrate */
					animSprite->scaling = LARGE_SPRITE;
				}

				animSprite->looping = 1-animFrag->premature; /* If premature then not looping and visa-versa */

				animSprite->frm = animSprite->frmTable[FIRST_ANIM_FRAME];

			}
			else
				break;
		}
		else
			break;
	}

}


/***************************************************************/


/* Start off any waiting delayed fx */

void	update_delayed_fx(void)
{
	FX_SPRITE		*animSprite;
	DELAYED_FX	*delaySlot;
	uint				k,l;

	for ( k=0, delaySlot = delayedFX; k<MAX_DELAYED_FX_SLOTS; k++, delaySlot++ )
	{
		if ( delaySlot->used )
		{
			for ( l=0, delayTime=delaySlot->fxlistDelay, delayType=delaySlot->fxlistType, started=0;
						l<MAX_DELAY_FX;
						l++, delayTime++, delayType++ )
			{
				if ( (*delayTime)==0xFF ) /* Delayed fx already started, or doesn't exist */
				{
					started++;
					continue;
				}
				else
				{
					if ( (*delayTime) >0 ) 	/* Is it time to start the fx ? */
					{
						(*delayTime)--;
					}
					else
					{   										/* Yes - note the fx has been started */

						(*delayTime)=0XFF;
						started++;
						switch(*delayType)
						{
							case SMALL_GROUND_EXP:
								if ( (animSprite=find_free_fx_slot())!=NULL )
								{
									animSprite->used=TRUE;
									animSprite->frmDelay = 0;
									animSprite->x = delaySlot->x>>16;
									animSprite->z = delaySlot->z>>16;
									animSprite->y = -20;//delaySlot->y;
									animSprite->frmTable = animations[GROUND_EXPLOSION_ANIM];
									animSprite->frm = animations[GROUND_EXPLOSION_ANIM][FIRST_ANIM_FRAME];
									animSprite->spriteType = 0;
									animSprite->scaling = LARGE_SPRITE;

									animSprite->rising=animSprite->looping = FALSE;
								}
								break;


							case LARGE_TRAN_GROUND_EXP:
								if ( (animSprite=find_free_fx_slot())!=NULL )
								{
									animSprite->used=TRUE;
									animSprite->frmDelay = 0;
									animSprite->x = delaySlot->x>>16;
									animSprite->z = delaySlot->z>>16;
									animSprite->y = -20;//delaySlot->y;
									animSprite->frmTable = animations[GROUND_EXPLOSION_ANIM];
									animSprite->frm = animations[GROUND_EXPLOSION_ANIM][FIRST_ANIM_FRAME];
									animSprite->spriteType = TRANSPARENT_SPRITE|FLIPPED_SPRITE;
									animSprite->rising=animSprite->looping = FALSE;
									animSprite->scaling = VERY_LARGE_SPRITE;
								}
								break;


							case LARGE_TRAN_AIR_EXP:
								if ( (animSprite=find_free_fx_slot())!=NULL )
								{
									animSprite->used=TRUE;
									animSprite->frmDelay = 0;
									animSprite->x = delaySlot->x>>16;
									animSprite->z = delaySlot->z>>16;
									animSprite->y = delaySlot->y-(400-rand()&0x1ff);
									animSprite->frmTable = animations[AIRBURST_ANIM];
									animSprite->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
									animSprite->spriteType = TRANSPARENT_SPRITE|FLIPPED_SPRITE;
									animSprite->rising=animSprite->looping = FALSE;
									animSprite->scaling = VERY_LARGE_SPRITE;
								}
								break;


							case SMALL_AIRBURST_EXP:
								if ( (animSprite=find_free_fx_slot())!=NULL )
								{
									animSprite->used=TRUE;
									animSprite->frmDelay = 0;
									animSprite->x = (delaySlot->x>>16)-(0x100-rand()&0xff);
									animSprite->z = (delaySlot->z>>16)-(0x100-rand()&0xff);
									animSprite->y = delaySlot->y-(400-rand()&0x1ff);
									animSprite->frmTable = animations[AIRBURST_ANIM];
									animSprite->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
									animSprite->spriteType = TRANSPARENT_SPRITE|FLIPPED_SPRITE;
									animSprite->rising=animSprite->looping = FALSE;
									animSprite->scaling = MEDIUM_SPRITE;
								}
								break;


							case SMALL_AIRFRAG_BURST:
								if ( (animSprite=find_free_fx_slot())!=NULL )
								{
									memcpy(&tempPos, &(delaySlot->x), sizeof(POSITION));

									animSprite->x = (tempPos.x-=(0x1000000-rand()&0xffffff)) >>16;
									animSprite->z = (tempPos.z-=(0x1000000-rand()&0xffffff)) >>16;
									animSprite->used=TRUE;
									animSprite->frmDelay = 0;
									animSprite->y = delaySlot->y-(400-rand()&0x1ff);
									animSprite->frmTable = animations[AIRBURST_ANIM];
									animSprite->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
									animSprite->spriteType = TRANSPARENT_SPRITE|FLIPPED_SPRITE;
									animSprite->rising=animSprite->looping = FALSE;
									animSprite->scaling = MEDIUM_SPRITE;

									trigger_fragments(4, &tempPos, TANK_FRAGMENTS);
								}
								break;


							case LARGE_WATER_EXP:
								if ( (animSprite=find_free_fx_slot())!=NULL )
								{
									animSprite->used=TRUE;
									animSprite->frmDelay = 0;
									animSprite->x = delaySlot->x>>16;
									animSprite->z = delaySlot->z>>16;
									animSprite->y = -20;//delaySlot->y;
									animSprite->frmTable = animations[WATER_EXPLOSION_ANIM];
									animSprite->frm = animations[WATER_EXPLOSION_ANIM][FIRST_ANIM_FRAME];
									animSprite->spriteType = TRANSPARENT_SPRITE|FLIPPED_SPRITE;
									animSprite->rising=animSprite->looping = FALSE;
									animSprite->scaling = VERY_LARGE_SPRITE;
								}
								break;



							case MUSHROOM_CLOUD:
								trigger_shroom( (POSITION *)&(delaySlot->x), LARGE_SHROOM );
								break;
						}
					}
				}
			}
			if ( started==MAX_DELAY_FX ) 	/* All the delayed fx have been started - free up this slot */
			{
				delaySlot->used=FALSE;
			}
		}
	}
}



/***************************************************************/

/* Set off fx explosion sprites */


#define EXPLOSION_DAMAGE_RANGE		0x400

void	trigger_explosion(int explosionType, POSITION *shellExplosionPos, POSITION *objectExplosionPos)
{
	int	relx,relz;
	uint	explDist;

	FX_SPRITE		*newFx;
	newFx = NULL;


	switch ( explosionType )
	{
		case TANK_EXPLOSION:
			if ( (newFx = find_free_fx_slot())!=NULL )
			{
				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = shellExplosionPos->x>>16;
				newFx->z = shellExplosionPos->z>>16;
				newFx->y = TANK_VIEW_HEIGHT;
				newFx->frmTable = animations[AIRBURST_ANIM];
				newFx->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType=0;
				newFx->scaling = MEDIUM_SPRITE;
				newFx->rising=newFx->looping=FALSE;
				trigger_fragments(16, objectExplosionPos, TANK_FRAGMENTS);
				setup_delayed_fx(D_TANK1_GROUP, objectExplosionPos);

				relx=abs(((uint)pl.x>>16)-(objectExplosionPos->x>>16));
				relz=abs(((uint)pl.z>>16)-(objectExplosionPos->z>>16));

				if ( relx>relz )
				{
					explDist=relx+(relz>>1);
				}
				else
					explDist=relz+(relx>>1);

				if ( explDist < EXPLOSION_DAMAGE_RANGE )
				{
					damage_tank(&pl, 0x41);
				}
			}
			break;


		case HELI_EXPLOSION:
			if ( (newFx = find_free_fx_slot())!=NULL )
			{
				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = objectExplosionPos->x>>16;
				newFx->z = objectExplosionPos->z>>16;
				newFx->y = objectExplosionPos->y;
				newFx->frmTable = animations[AIRBURST_ANIM];
				newFx->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType=0;
				newFx->scaling = MEDIUM_SPRITE;
				newFx->rising=newFx->looping=FALSE;
				trigger_fragments(16, objectExplosionPos, TANK_FRAGMENTS);
				setup_delayed_fx(D_HELI_GROUP, objectExplosionPos);
			}
			break;



		case AIR_EXPLOSION:
			if ( (newFx = find_free_fx_slot())!=NULL )
			{
				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = shellExplosionPos->x>>16;
				newFx->z = shellExplosionPos->z>>16;
				newFx->y = TANK_VIEW_HEIGHT;
				newFx->frmTable = animations[AIRBURST_ANIM];
				newFx->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType=0;
				newFx->scaling = MEDIUM_SPRITE;
				newFx->rising=newFx->looping=FALSE;
			}
			break;


		case SHELL_HIT_EXPLOSION:
			if ( (newFx = find_free_fx_slot())!=NULL )
			{
				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = shellExplosionPos->x>>16;
				newFx->z = shellExplosionPos->z>>16;
				newFx->y = TANK_VIEW_HEIGHT;
				newFx->frmTable = animations[AIRBURST_ANIM];
				newFx->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType=TRANSPARENT_SPRITE;
				newFx->scaling = MEDIUM_SPRITE;
				newFx->rising=newFx->looping=FALSE;
			}
			break;


		case SHELL_GROUND_EXPLOSION:
			if ( (newFx = find_free_fx_slot())!=NULL )
			{
				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = shellExplosionPos->x>>16;
				newFx->z = shellExplosionPos->z>>16;
				newFx->y = 0;
				newFx->frmTable = animations[GROUND_EXPLOSION_ANIM];
				newFx->frm = animations[GROUND_EXPLOSION_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType=0;
				newFx->scaling = MEDIUM_SPRITE;
				newFx->rising=newFx->looping=FALSE;
			}
			break;


		case GUN_EMPLACEMENT_EXPLOSION:
			if ( (newFx = find_free_fx_slot())!=NULL )
			{
				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = shellExplosionPos->x>>16;
				newFx->z = shellExplosionPos->z>>16;
				newFx->y = 0;
				newFx->frmTable = animations[GROUND_EXPLOSION_ANIM];
				newFx->frm = animations[GROUND_EXPLOSION_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType=0;
				newFx->scaling = MEDIUM_SPRITE;
				newFx->rising=newFx->looping=FALSE;
				trigger_fragments(6, objectExplosionPos, TANK_FRAGMENTS);
				trigger_shroom(objectExplosionPos, MEDIUM_SHROOM);
			}
			break;

		case GUNBOAT_EXPLOSION:
			if ( (newFx = find_free_fx_slot())!=NULL )
			{
				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = shellExplosionPos->x>>16;
				newFx->z = shellExplosionPos->z>>16;
				newFx->y = TANK_VIEW_HEIGHT;
				newFx->frmTable = animations[WATER_EXPLOSION_ANIM];
				newFx->frm = animations[WATER_EXPLOSION_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType = 0;
				newFx->scaling = LARGE_SPRITE;
				newFx->rising=newFx->looping=FALSE;
				trigger_fragments(16, objectExplosionPos, TANK_FRAGMENTS);
				setup_delayed_fx(D_GUNBOAT_GROUP, objectExplosionPos);

				relx=abs(((uint)pl.x>>16)-(objectExplosionPos->x>>16));
				relz=abs(((uint)pl.z>>16)-(objectExplosionPos->z>>16));

				if ( relx>relz )
				{
					explDist=relx+(relz>>1);
				}
				else
					explDist=relz+(relx>>1);

				if ( explDist < EXPLOSION_DAMAGE_RANGE )
				{
					damage_tank(&pl, 0x41);
				}
			}
			break;

	}
}



/***************************************************************/


enum	{ W_SMALL_EXPLOSION, W_MEDIUM_EXPLOSION, W_LARGE_EXPLOSION, W_OIL_CONTAINER_EXPLOSION, W_TOWER_EXPLOSION, W_FUEL_CONTAINER_EXPLOSION };


void	trigger_wall_explosion(ushort *explodingWalls, int fragType)
{
	ushort	numWallsInGroup;			/* Number of walls that make up the group */
	ushort	grpmx, grpmz;					/* The middle of the group of walls */
	ushort	currentExplodingWall;	/* The loop wall number being exploded */
	ushort	explosionType;				/* The sort of explosion needed - depending on number of walls in structure, and the type of walls */
	ushort	ewally;/* Coordinates of particular wall to explode */
	int			dwallCnt;
	POINT_DATA	*exmidpt;
	POSITION	objectExplosionPos;
	FX_SPRITE		*newFx;
	int			relx,relz;
	uint		explDist;
	int			i;



	numWallsInGroup = *explodingWalls++;
	grpmx = *explodingWalls++;
	grpmz = *explodingWalls++;

	newFx = NULL;


	explosionType = W_SMALL_EXPLOSION;


	objectExplosionPos.x = grpmx<<16;
	objectExplosionPos.z = grpmz<<16;
	objectExplosionPos.y = TANK_VIEW_HEIGHT;


	if ( numWallsInGroup<=4 ) 										/* Small crates, gates etc... */
	{
		if ( fragType&0x8000 )
		{
			explosionType = W_TOWER_EXPLOSION;
		}
		else
			explosionType = W_SMALL_EXPLOSION;
	}
	else
	if ( numWallsInGroup<=8 ) 										/* Smallish buildings */
	{
		explosionType = W_MEDIUM_EXPLOSION;
	}
	else
	{
		explosionType = W_LARGE_EXPLOSION;
	}

	if ( fragType&0x7000 )
	{
		explosionType = W_TOWER_EXPLOSION;					/** frig for pylons */
	}

	fragType&=0xf;															/* mask off the top two bits incase it was set (for tower explosions) */

	if ( fragType==FUEL_CONTAINER_FRAGMENTS )
	{
		explosionType=W_FUEL_CONTAINER_EXPLOSION;
	}

	switch ( explosionType )
	{
		case W_SMALL_EXPLOSION:
    	for ( dwallCnt=0; dwallCnt<numWallsInGroup; dwallCnt++ )
    	{
    		if (  (newFx = find_free_fx_slot())==NULL ) 	/* If there are no slots for the explosionfx sprite then return */
    			return ;


    	 	currentExplodingWall = *explodingWalls++;			/* Get index of wall 2 explode */
    		ewally = pl.y;

    		exmidpt = (wallMids + currentExplodingWall);	/* Get midpoint of particular wall */

				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = exmidpt->x;
				newFx->z = exmidpt->z;
				newFx->y = TANK_VIEW_HEIGHT;
				newFx->frmTable = animations[AIRBURST_ANIM];
				newFx->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType= TRANSPARENT_SPRITE;;
				newFx->scaling = MEDIUM_SPRITE;
				newFx->rising=newFx->looping=FALSE;
			}

			trigger_shroom(&objectExplosionPos, MEDIUM_SHROOM);

			trigger_fragments(6, &objectExplosionPos, fragType);

			small_building_explosio_snd(grpmx, grpmz);
			break;


		case W_MEDIUM_EXPLOSION:
    	for ( dwallCnt=0; dwallCnt<numWallsInGroup; dwallCnt+=2 )
    	{
    		if (  (newFx = find_free_fx_slot())==NULL ) 	/* If there are no slots for the explosionfx sprite then return */
    			return ;


    	 	currentExplodingWall = *explodingWalls++;			/* Get index of wall 2 explode */
    		ewally = pl.y;

    		exmidpt = (wallMids + currentExplodingWall);	/* Get midpoint of particular wall */


				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = exmidpt->x;
				newFx->z = exmidpt->z;
				newFx->y = TANK_VIEW_HEIGHT;
				newFx->frmTable = animations[AIRBURST_ANIM];
				newFx->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType=0;
				newFx->scaling = MEDIUM_SPRITE;
				newFx->rising=newFx->looping=FALSE;
			}
			setup_delayed_fx(D_SMALL_BUILDING_GROUP, &objectExplosionPos);

			trigger_fragments(8, &objectExplosionPos, fragType);

			relx=abs(((uint)pl.x>>16)-grpmx);
			relz=abs(((uint)pl.z>>16)-grpmz);

			if ( relx>relz )
			{
				explDist=relx+(relz>>1);
			}
			else
				explDist=relz+(relx>>1);

			if ( explDist < EXPLOSION_DAMAGE_RANGE )
			{
				damage_tank(&pl, 0x41);
			}

			normal_building_explosion_snd(grpmx, grpmz);
			break;




		case W_LARGE_EXPLOSION:
    	for ( dwallCnt=0; dwallCnt<numWallsInGroup; dwallCnt+=4 )
    	{
    		if (  (newFx = find_free_fx_slot())==NULL ) 	/* If there are no slots for the explosionfx sprite then return */
    			return ;


    	 	currentExplodingWall = *explodingWalls++;			/* Get index of wall 2 explode */
    		ewally = pl.y;

    		exmidpt = (wallMids + currentExplodingWall);	/* Get midpoint of particular wall */

				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = exmidpt->x;
				newFx->z = exmidpt->z;
				newFx->y = TANK_VIEW_HEIGHT;
				newFx->frmTable = animations[AIRBURST_ANIM];
				newFx->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType=0;
				newFx->scaling = MEDIUM_SPRITE;
				newFx->rising=newFx->looping=FALSE;
			}
			setup_delayed_fx(D_TANK1_GROUP, &objectExplosionPos);
			trigger_fragments(20, &objectExplosionPos, fragType);

			relx=abs(((uint)pl.x>>16)-grpmx);
			relz=abs(((uint)pl.z>>16)-grpmz);

			if ( relx>relz )
			{
				explDist=relx+(relz>>1);
			}
			else
				explDist=relz+(relx>>1);

			if ( explDist < EXPLOSION_DAMAGE_RANGE )
			{
				damage_tank(&pl, 0x61);
			}

			large_building_explosion_snd(grpmx, grpmz);
			break;



		case W_FUEL_CONTAINER_EXPLOSION:
    	for ( dwallCnt=0; dwallCnt<numWallsInGroup; dwallCnt+=4 )
    	{
    		if (  (newFx = find_free_fx_slot())==NULL ) 	/* If there are no slots for the explosionfx sprite then return */
    			return ;


    	 	currentExplodingWall = *explodingWalls++;			/* Get index of wall 2 explode */
    		ewally = pl.y;

    		exmidpt = (wallMids + currentExplodingWall);	/* Get midpoint of particular wall */

				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = exmidpt->x;
				newFx->z = exmidpt->z;
				newFx->y = TANK_VIEW_HEIGHT;
				newFx->frmTable = animations[AIRBURST_ANIM];
				newFx->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType=0;
				newFx->scaling = MEDIUM_SPRITE;
				newFx->rising=newFx->looping=FALSE;
			}
			setup_delayed_fx(D_TANK1_GROUP, &objectExplosionPos);
			trigger_fragments(20, &objectExplosionPos, fragType);

			relx=abs(((uint)pl.x>>16)-grpmx);
			relz=abs(((uint)pl.z>>16)-grpmz);

			if ( relx>relz )
			{
				explDist=relx+(relz>>1);
			}
			else
				explDist=relz+(relx>>1);

			if ( explDist < EXPLOSION_DAMAGE_RANGE )
			{
				damage_tank(&pl, 0x61);
			}

			fuel_tank_explosion_snd(grpmx, grpmz);
			break;



		case W_TOWER_EXPLOSION:
    	for ( dwallCnt=0; dwallCnt<numWallsInGroup; dwallCnt++ )
    	{
    		if (  (newFx = find_free_fx_slot())==NULL ) 	/* If there are no slots for the explosionfx sprite then return */
    			return ;


    	 	currentExplodingWall = *explodingWalls++;			/* Get index of wall 2 explode */
    		ewally = pl.y;

    		exmidpt = (wallMids + currentExplodingWall);	/* Get midpoint of particular wall */

				newFx->used = TRUE;
				newFx->frmDelay=0;
				newFx->x = exmidpt->x;
				newFx->z = exmidpt->z;
				newFx->y = TANK_VIEW_HEIGHT;
				newFx->frmTable = animations[AIRBURST_ANIM];
				newFx->frm = animations[AIRBURST_ANIM][FIRST_ANIM_FRAME];
				newFx->spriteType= TRANSPARENT_SPRITE;;
				newFx->scaling = MEDIUM_SPRITE;
				newFx->rising=newFx->looping=FALSE;
			}

			for ( i=0; i<4; i++ )
			{
				trigger_fragments(4, &objectExplosionPos, fragType);
				trigger_fx_sprite(AIRBURST_ANIM, objectExplosionPos.x, objectExplosionPos.y, objectExplosionPos.z, FALSE, TRANSPARENT_SPRITE, MEDIUM_SPRITE, TRUE);
				objectExplosionPos.y-=0X100;
			}

			trigger_shroom(&objectExplosionPos, MEDIUM_SHROOM);

			small_building_explosio_snd(grpmx, grpmz);
			break;
	}
}


/***************************************************************/

/* Set up a list of fx which will start up in a sequence */

void	setup_delayed_fx(int	delayFXgroup, POSITION *pos)
{
	uint	k;
	DELAYED_FX	*freeDelayedFX;


	for ( k=0, freeDelayedFX=delayedFX; k<MAX_DELAYED_FX_SLOTS; k++, freeDelayedFX++  )
	{
		if ( !freeDelayedFX->used )
		{
			freeDelayedFX->used=TRUE;
			freeDelayedFX->fxlistType = fxlistTypes[delayFXgroup];
			memcpy(freeDelayedFX->fxlistDelay, fxlistDelays[delayFXgroup], MAX_DELAY_FX);
			memcpy(&(freeDelayedFX->x), pos, sizeof(POSITION));
			break;
		}
	}
}


/***************************************************************/

/* Set off a rising smoke cloud */

void	trigger_shroom(POSITION *shroomPos, int	shroom_size)
{
	FX_SPRITE		*animSprite;


	if ( shroom_size==LARGE_SHROOM )
	{
		if ( (animSprite=find_free_fx_slot())!=NULL )
		{
			animSprite->used = animSprite->rising = TRUE;
			animSprite->looping = FALSE;

			animSprite->frmDelay = 0;
			animSprite->x = shroomPos->x>>16;
			animSprite->z = shroomPos->z>>16;
			animSprite->y = shroomPos->y+TANK_VIEW_HEIGHT*2;
			animSprite->frmTable = animations[SMOKE_ANIM];
			animSprite->frm = animations[SMOKE_ANIM][FIRST_ANIM_FRAME];
			animSprite->spriteType = TRANSPARENT_SPRITE;
			animSprite->scaling = LARGE_SPRITE;
		}
		else
			return;
	}

	if ( (animSprite=find_free_fx_slot())!=NULL )
	{
		animSprite->used = animSprite->rising = TRUE;
		animSprite->looping = FALSE;

		animSprite->frmDelay = 0;
		animSprite->x = shroomPos->x>>16;
		animSprite->z = shroomPos->z>>16;
		animSprite->y = shroomPos->y+TANK_VIEW_HEIGHT;
		animSprite->frmTable = animations[SMOKE_ANIM];
		animSprite->frm = animations[SMOKE_ANIM][FIRST_ANIM_FRAME];
		animSprite->spriteType = TRANSPARENT_SPRITE;
		animSprite->scaling = MEDIUM_SPRITE;
	}
}


/***************************************************************/


void	trigger_fx_sprite(int	animNum, int animx, int animy, int animz, int looping, int spriteType, int scaling, int rising)
{
	FX_SPRITE		*animSprite;

	if ( (animSprite=find_free_fx_slot())!=NULL )
	{
		animSprite->used = TRUE;
		animSprite->rising = rising;
		animSprite->looping = looping;

		animSprite->frmDelay = 0;
		animSprite->x = animx>>16;
		animSprite->z = animz>>16;
		animSprite->y = animy;
		animSprite->frmTable = animations[animNum];
		animSprite->frm = animations[animNum][FIRST_ANIM_FRAME];
		animSprite->spriteType = spriteType;
		animSprite->scaling = scaling;
	}
}
