
#include "shock.h"
#include "netextra.h"
#include "chuck.h"
#include "e_global.h"

/*-----------------19/10/95 00:44-------------------

	N E T W O R K   C O L L E C T A B L E S

	created to hold all dat special SHELLSHOCK specific
	collectables stuff.

--------------------------------------------------*/

/*************************************************************

				               G L O B A L S

 *************************************************************/


int SHOW_CFLIGHT= 0;

C_GENERATE cGen;

int PICKUP_TOGGLE=0;
int SWITCHED_PICKUP_TOGGLE= 0;



/*no of objects held by player tank*/
int ALL_HELD= 0;


/*Stats on each TYPE of collectable for a level*/


COLLECT_STAT cStat[COLLECT_TYPES]=
{
	"-> -> -> ->  S P E E D U P -> -> -> ->",
	ctbl_tankStat,
	0, /*farg*/
	BLOW_JOB,
	0,NULL,0,0,0,0,
	&engine_upg,
	1,  /*default */
	4,  /*maximum*/
	4,  /*increments*/
	0,
	0,	/*cdown_max*/
	8,	/*sprite*/

	" | | |  T R I P L E  S H E L L  | | | ",
	ctbl_newWeapon,
	0, /*farg*/
	BLOW_JOB,
	0,NULL,0,0,0,0,
	&cStat[1].held,
	0,  /*default*/
	1,  /*maximum*/
	1,  /*increments*/
	0,
	0,	/*cdown_max*/
	8,	/*sprite*/

	" :-)		  	 	S M A R T I E	   			:-)",
	ctbl_newSuperWeapon,
	0, /*farg*/
	TRIGGERED,
	0,NULL,0,0,0,0,
	&cStat[2].held,
	0,  /*default*/
	1,  /*maximum*/
	1,  /*increments*/
	0,
	0,	/*cdown_max*/
	8, 	/*sprite*/

	"+++++++ S H E L L  S P E E D U P",
	ctbl_upgradeShells,
	0, /*farg*/
	BLOW_JOB,
	0,NULL,0,0,0,0,
	&pl.shellSpeed,
	0xE00,  /*default*/
	0x1000,  /*maximum*/
	4,  /*increments*/
	0,
	0,	/*cdown_max*/
	8,	/*sprite*/

	"+++++++ S H E L L  R A N G E  U P",
	ctbl_upgradeShells,
	1, /*farg*/
	BLOW_JOB,
	0,NULL,0,0,0,0,
	&pl.shellRange,
	0x2000,  /*default*/
	0x4000,  /*maximum*/
	4,  /*increments*/
	0,
	0,	/*cdown_max*/
	8, 	/*sprite*/

	"           F R E E  E N E R G Y !",
	ctbl_upgradeTank,
	0, /*farg*/
	BLOW_JOB,
	0,NULL,0,0,0,0,
	&pl.armour,
	NET_ARMOUR<<5,  /*default*/
	NET_ARMOUR<<5,  /*maximum*/
	4,  /*increments*/
	0,
	0,	/*cdown_max*/
	8, 	/*sprite*/

	"+++++++++ R E L O A D   R A T E   U P",
	ctbl_upgradeShells,
	0, /*farg*/
	BLOW_JOB,
	0,NULL,0,0,0,0,
	&pl.shellDelay,
	50                           , /*default*/
	20, /*maximum*/    /*This one is DECREASING!*/
	4, /*increments*/
	0,
	0, /*cdown_max*/
	8, /*sprite*/

	"						---R-A-D-A-R--C-L-O-A-K---",
	ctbl_tankStatus,
	RADAR_INVISIBLE,
	BLOW_JOB,
	0,NULL,0,0,0,0,
	NULL,
	0,  /*default*/
	1,  /*max*/
	1, /*increments*/
	0,
	0,
	8,    /*sprite*/

	"		- I - N - V - I - S - I - B - L -E ",
	ctbl_tankStatus,
	INVISIBILITY,
	BLOW_JOB,
	0,NULL,0,0,0,0,
	NULL,
	0,  /*default*/
	1,  /*max*/
	1, /*increments*/
	0,
	0,
	8    /*sprite*/

};




/*Ctbls can't land or fly over charred earth*/
char charred[]=
{ 220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,
	235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,
	250,251,252,253,254,255,
	23};


/*Ctbls can fly over the drink, but not land in it*/
char watery[]=
{
	0,4,5,6,7,8
};



/*Sprite used to represent collectable of type x*/
/*
char cSprite[]=
{8,8,8};
*/



/*An array like this for each level, with lists of tile
  positions. Types of object are separated by two {255,255}
 pairings. Two {0,0} pairings mark the end of the array. */
/*Byte preceding pairings marks 'max of type*/
/*New addition= Type is specified first*/


char cPositions1[]=
{
	C_SPEEDUP, 6,
	228,127, 233,128,
	240,128, 226,137,
	235,138, 240,138,

	255,255, 255,255,

	C_TRIPLE, 1,
	223,144,

	255,255,255,255,

	C_SMARTIE, 1,
	230,145,

	255,255,255,255,

	C_SHELLSPEED, 3,
	236,145, 222,150,
	229,152,

	255,255,255,255,


	C_SHELLRANGE, 3,
	238,152,218,158,
	225,159,

	255,255,255,255,

	C_ENERGY, 4,
	232,161, 216,166,
	222,171, 216,179,

	255,255,255,255,

	C_RELOAD, 2,
	210,186,
	203,195,

	255,255,255,255,

	C_RADAR_CLOAK, 1,
	230, 115,

	255,255,255,255,

	C_INVISIBILITY, 1,
	230,110,

/*End of data*/
	0,0, 0,0

};



/*Max countdown values for each object type*/
/*
int cExpiry[COLLECT_TYPES]=
{
	0,
	0,
	0
};
*/

/*************************************************************


										F U N C T I O N S

 *************************************************************/
/*************************************************************/

/*Clear preset collectables from map*/

void CLEAR_PRESET_COLLECTABLES (void)
{
	uchar *map_ptr;
	short map_val;
	int i;

	map_ptr= obj_map;

	for (i=0;i<0xffff;i++)
	{
		map_val = det_tabs[region][(((*map_ptr) - 1) << 1)+1];

		if (map_val & DET_PICKUP)
		{
			*map_ptr= 0;
		}
		map_ptr++;
	}
	/*TEST_GEN_COLLECT_GRID();*/
}



/*Initialize a level's collectables stats based on cPositions
 array. Do this for each level.*/
/*Each collectable type is given a NUMBER OF POSSIBLE POSITIONS
  and a MAXIMUM ACTIVE IN LEVEL value, plus pointer to positions */

/*Expiry times for each collectable are also taken- these
	will probably be the same for each level*/

void INITIALIZE_COLLECTSTATS (void)
{
	int cType;
	char *cPos; /*Points to {x,z} */
	char cease=0;


	cGen.type = 0;
	cGen.gestation = 100;
	cGen.preg = cGen.gestation;

	/*Reset some shit*/
	for (cType=0;cType< COLLECT_TYPES; cType++)
	{
		cStat[cType].cdown= cStat[cType].cdown_max;
		cStat[cType].num= 0;
		cStat[cType].posnum= 0;
		cStat[cType].held= 0;
		cStat[cType].emptied= 0;
	}

	ctbl_values_reset();



	/*Set up pointers & counters for ctbl positions*/
	cPos = cPositions1;
	cType= *cPos;
	cPos++;
	cStat[cType].max= *cPos;
	cPos++;
	cStat[cType].pos= cPos;


	while (!cease)
	{

		if (*((int *)cPos)==0xffffffff)
		{
	 		/*Move on to new type*/
	 		cPos+=4;
			cType= *cPos;
			cPos++;

	 		cStat[cType].max= *cPos;
	 		cPos++;
			cStat[cType].pos= cPos;

		}
		else
		{
	 		if (*((int *) cPos)==0 )
	 		{
	 			/*End of data*/
	 			cease=1;
	 		}
	 		else
	 		{
				/*Regular position*/
				cStat[cType].posnum++;
				cPos+=2;
	 		}

 		}
	}


}




/*A fucking test*/
void TEST_GEN_COLLECT_GRID (void)
{
	int i,j;
	char cx,cz;
	uchar *map_ptr;

	cx= 5;
	cz= 25;

	for (i=0;i<8;i++)
	{
		cx=5;
		for (j=0;j<10;j++)
		{
			map_ptr= obj_map+cx+(cz<<8);
			(*map_ptr)=8;
			cx+=4;
		}
		cz+=4;
	}
}





/*Implement the effect of the collectable as soon as it's
	picked up*/
/*return 0 if player already has max of collectable*/

char IMMEDIATE_COLLECTABLE_EFFECT (int cType)
{
	int *cval= cStat[cType].affected_val;
	int increase;


	/*Check if value has reached its extent (Great or Small)*/
	if (cStat[cType].max_val>=cStat[cType].default_val)
	{
		if (*cval>= cStat[cType].max_val)
			return (0);
	}
	else
	{
		if (*cval<=cStat[cType].max_val)
			return (0);
	}


	newTextMessage (cStat[cType].text);

	/*increment whichever main value the ctbl affects*/

	if ((cval!= &cStat[cType].held ) && (cval!=NULL))
	{
		/*HELD is already incremented in the calling function*/

		increase= cStat[cType].max_val- cStat[cType].default_val;

		if (increase==0)
			increase= cStat[cType].max_val;

		(*cval)+=
		increase/ cStat[cType].increments;


		if (cStat[cType].max_val>=cStat[cType].default_val)
		{
			if (*cval> cStat[cType].max_val)
	 			*cval = cStat[cType].max_val;
		}
		else
		{
			/*PARADOX=  ultimate ctbl val can be LESS than default*/
			if (*cval< cStat[cType].max_val)
				*cval = cStat[cType].max_val;
		}



	}



	/*Do the extra fancy stuff, if necc, eg Display update*/
	if (!(cStat[cType].gType&TRIGGERED))
	{
		if (cStat[cType].ctbl_func!=NULL)
			cStat[cType].ctbl_func (cStat[cType].farg,1);
	}

	return (1);
}



/*Trigger any key-activated collectable which is held.*/
void TRIGGER_COLLECTABLE_EFFECT (void)
{
	int i,j,k;


	for (i=0;i<COLLECT_TYPES;i++)
	{
		if (cStat[i].held!=0)
		{
			switch (i)
			{
				case C_SMARTIE:
					for (j=0;j<myGame.noPlayers;j++)
					{
						k=playerList.qi[j];

						/*Player must be on radar, for SMART effect*/

						if (thisTankOnRadar (tanks+k))
							SET_DAMAGE (&net[k]->S_HIT,HIT_DAMAGE*4);
					}
					USE_COLLECTABLE (C_SMARTIE);

				i= COLLECT_TYPES;
				break;
			}

		}

	}
}



/*Collectable has worn off/ player died. Cancel effect.*/
void CANCEL_COLLECTABLE_EFFECT (int cType)
{
	/*Remove/diminish whatever effect the ctbl had*/
	switch (cType)
	{
		case C_SPEEDUP:
		engine_upg= cStat[cType].held;
		if ( engine_upg>4 )
			engine_upg=4;
		update_pickups();
		break;

		case C_TRIPLE:
		pl.cWeapon= 0;
		break;

	}


}



/*If a collectable is generated,  returns slot position*/
int GENERATE_COLLECTABLE ()
{
	/*Prob change this to an argument*/
	COLLECT aCollect;
	COLLECT *tCollect= &aCollect;

	int pSlot;
	char ranval;
	/*number of attempts to find a free position*/
	int TRY_TO_PLACE=3;
	char *cPos;


	/*Frame counter between ctbl generation attempts*/
	cGen.preg--;

	if (cGen.preg>0)
		return (-1);

	/*restart count*/
	cGen.preg= cGen.gestation;


	/*Time to generate! Check if there's a partition slot free*/
	if ((pSlot=	findPartitionSlot (&collectList,
							net[myID]->partitionStart,
							net[myID]->partitionLength))==-1)
		return (-1);

	/*Choose the type of ctbl to generate*/

	cGen.type++;
	if (cGen.type>=COLLECT_TYPES)
		cGen.type=0;


	/*Are there already enough ctbls of this type?*/
	if (cStat[cGen.type].num>=cStat[cGen.type].max)
		return (-1);

	/*If the chosen ctbl can be generated, choose one of its
	 positions, NOT the same as the most recently emptied
	 position*/

	for (;TRY_TO_PLACE>0;TRY_TO_PLACE--)
	{
		/*Choose a position at random*/

		ranval= (char) rand();

		while (ranval>=cStat[cGen.type].posnum)
			ranval-=cStat[cGen.type].posnum;

		cPos= cStat[cGen.type].pos+ (ranval<<1);

		/*Check the position isn't already occupied*/
		if  ( *(obj_map+cPos[0]+ (cPos[1]<<8))  ==0)
		{
			tCollect->x= cPos[0];
			tCollect->z= cPos[1];
			tCollect->type= cGen.type; /*cGen.type is the default*/
			break;
		}

	}

	if (TRY_TO_PLACE==0)
		return (-1);


	/************* A COLLECTABLE HAS BEEN GENERATED ************/

	PLACE_COLLECTABLE (pSlot, *tCollect);
	return (1);

}



/*Move a collectable already existing in all the lists to a
	new position*/
void MOVE_COLLECTABLE (int cSlot,COLLECT tCollect)
{
	OBJ_MOV tMovObj;
	uchar sprite;

	collect[cSlot]= tCollect;

	sprite= cStat [tCollect.type].sprite;
	if (sprite!=8) net_getout ("Wrong ctbl sprite no");

	/*Update objmap*/

	*(obj_map+tCollect.x+ (tCollect.z<<8))  =cStat [tCollect.type].sprite;

	/*TRANSMIT THE SHIT*/
	tMovObj.id= cSlot;
	tMovObj.x= tCollect.x;
	tMovObj.z= tCollect.z;

	MOVOBJ_TO_OUTPUT_BUFFER (&tMovObj);
	TRANSMIT_OBJECT_DATA();

}


/*Move a collectable already existing in all the lists to a
	new position*/
void FUN_MOVE_COLLECTABLE (int cSlot,COLLECT tCollect)
{
	OBJ_MOV tMovObj;

	collect[cSlot]= tCollect;

	/*Update objmap*/
	*(obj_map+tCollect.x+ (tCollect.z<<8))  =cStat [tCollect.type].sprite;
}


/*PLACE a collectable generated by the LOCAL machine in all
	the appropriate lists																		*/

void PLACE_COLLECTABLE (int cSlot, COLLECT tCollect)
{
	OBJ_ADD tAddObj;

	/*UPDATE cStats*/
	cStat[tCollect.type].num++;

	/*Update objmap*/
	*(obj_map+tCollect.x+ (tCollect.z<<8))  = cStat[tCollect.type].sprite;

	/*Put object in slot partition*/

	spuzInsertSlotListDirect (&collectList,(char *) &tCollect,cSlot);

	/*TRANSMIT the SHIT*/
	tAddObj.id= cSlot;
	tAddObj.type= tCollect.type;
	tAddObj.x= tCollect.x;
	tAddObj.y= tCollect.z;
	tAddObj.z= tCollect.z;

	ADDOBJ_TO_OUTPUT_BUFFER (&tAddObj);
	TRANSMIT_OBJECT_DATA();

}



/*Remove a collectable from the collectList, and associated
  lists */
/*NOT held status though!*/
void REMOVE_COLLECTABLE (int cSlot)
{
	COLLECT *tCollect;
	OBJ_REM tRemObj;

	tCollect= collect+ cSlot;

	if (cStat[tCollect->type].num>0)
		cStat[tCollect->type].num--;

	/*uh- notice how 'delete and not 'spuzDelete is used here*/
	tRemObj.id= cSlot;
	tRemObj.type= collect[cSlot].type;

	deleteSlotList (&collectList, cSlot);
	REMOBJ_TO_OUTPUT_BUFFER (&tRemObj);
	TRANSMIT_OBJECT_DATA();

}




/*Local can 'use' a collectable which it HOLDS*/

void USE_COLLECTABLE (int cType)
{
	int i,j;

	/*None of that type to drop*/
	if (cStat[cType].held<=0) return;

	/*Find object of cType HELD by local*/
	for (j=0;j<collectList.els;j++)
	{
		i= collectList.qi[j];

		if (collect[i].type==cType)
		{
			if (collect[i].x==256+myID)
			{
				REMOVE_COLLECTABLE(i);
				break;
			}
		}

	}

	cStat[cType].held--;
	ALL_HELD--;

	/*Cancel the effect of the collectable*/
	CANCEL_COLLECTABLE_EFFECT (cType);


}



/*Move collectable 'inside tank' */

char PICKUP_COLLECTABLE (int mpos)
{
	int cx= mpos&0xff;
	int cz= mpos>>8;
	int clx,clz;
	OBJ_MOV tMovObj;

	int i,j;

	/*Search for object with the pickup coords in collectList*/
	for (j=0;j<collectList.els;j++)
	{
		i= collectList.qi[j];

		clx=collect[i].x;
		clz=collect[i].z;

		if (clx==cx&&clz==cz)
		{

			/*If collectable has an immediate effect, implement it*/

			/*User already have max of ctbl- if so, don't pick up*/
			if (!IMMEDIATE_COLLECTABLE_EFFECT (collect[i].type))
				return(0);

			/*Moves object 'Inside Tank' */
			cStat[collect[i].type].held++;
			ALL_HELD++;

			collect[i].x= 256+myID;
			collect[i].z= 256+myID;

			tMovObj.id=i;
			tMovObj.x= collect[i].x;
			tMovObj.z= collect[i].z;
			MOVOBJ_TO_OUTPUT_BUFFER (&tMovObj);
			TRANSMIT_OBJECT_DATA();

			break;
		}

	}

	return (1);

}





/*CHeck if floor is charGrilled*/
int nogoCharred (int x, int y)
{
	int i;
	uchar tile_tex;

	tile_tex= (uchar) (( *(floor_map+x+(y<<8) ) ) >>3);

	i= sizeof (charred)- 1;

	for (;i>=0;i--)
		if (tile_tex== charred[i])
			return (1);

	return (0);

}


/*Check if floor is watery*/
int nogoWatery (int x, int y)
{
	int i;
	uchar tile_tex;

	tile_tex= (uchar) (( *(floor_map+x+(y<<8) ) ) >>3);

	i= sizeof (watery)- 1;

	for (;i>=0;i--)
		if (tile_tex== watery[i])
			return (1);

	return (0);

}




/*Check if a collectable in flight will cross a wall*/
int wallCheck (short tx,short tz,short addx,short addz)
{
	short add_sgn;
	short i;


	/*Vertical first*/

	if (addz<0)
		add_sgn= -1;
	else
		add_sgn=1;


	for (i=add_sgn;i!=(addz+add_sgn);i+=add_sgn)
	{
		tz+=add_sgn;

		/*Check if ctbl has gone over map boundaries*/
		if (tz<0||tz>0xff)
			return(1);

		/*Check if ctbl has gone over los bit*/
		if (test_los_bit(tx,tz))
			return(1);
	}


	/*Horizontal */
		if (addx<0)
		add_sgn= -1;
	else
		add_sgn=1;


	for (i=add_sgn;i!=(addx+add_sgn);i+=add_sgn)
	{
		tx+=add_sgn;

		/*Check if ctbl has gone over map boundaries*/
		if (tx<0||tx>0xff)
			return(1);

		/*Check if ctbl has gone over los bit*/
		if (test_los_bit(tx,tz))
			return(1);
	}

	/*Hurrah! The ctbl's path was not blocked*/
	return (0);

}





/*Check if a flying collectable will hit a wall or object*/
int obstruction (int ox, int oy, int addx, int addy, int cSlot)
{
	int fx,fy;
	uchar cx,cy;
	int x1,x2,y1,y2;
	int i,frak,fraksum,xdif,ydif,xadd,yadd;
	COLLECT tCollect;
	int vbls;


	int rad=1;

	fx= ox+ addx;
	fy= oy+ addy;

	/*Trivial Rejection- check ctbls final position and the
		surrounding tiles for obstruction*/

	for (cy= (fy-rad);cy<= (fy+rad); cy++)
	{
		for (cx= (fx-rad);cx<= (fx+rad); cx++)
		{
			/*Walls*/
			if (test_los_bit (cx,cy))
		 		return (1);

			/*Objects*/
 			if (*(obj_map+(int) cx+ ((int)cy<<8) )!= 0)
				return (1);

			/*Floor tiles*/
			if (nogoCharred (cx,cy))
				return (1);

			if (nogoWatery (cx,cy))
				return(1);

		}

	}


	/*Serious Shit- Trace path of collectable*/

	x1= cx= ox;
	y1= cy= oy;
	x2= fx;
	y2= fy;

	xdif = x2-x1;
	ydif = y2-y1;

	if (xdif>=0)
		xadd = 1;
	else
	{
		xadd = -1;
		xdif = -xdif;
	}

	if (ydif>=0)
		yadd = 1;
	else
	{
		yadd = -1;
		ydif = -ydif;
	}


	fraksum= 0;

	if (xdif++ < ydif++)
	{
	  frak=((xdif<<16)/ydif);

		for(i=0; i<ydif; i++)
		{
			if (i!=0)
			{
				/*Check that cx,cy position!*/
				if (test_los_bit (cx,cy))
		 			return (1);

				/*  YUPP!
 				if (*(obj_map+ (int) cx+ ((int) cy<<8))!= 0)
					return (1);
				*/

				if (nogoCharred (cx,cy))
					return (1);
			}

	  	cy += yadd;
	  	fraksum += frak;
	  	if (fraksum>=65536)
			{
	  		cx += xadd;
	  		fraksum -= 65536;
	  	}


			if (SHOW_CFLIGHT)
			{
				tCollect.x= cx;
				tCollect.z= cy;
				tCollect.type= 0;

		 		FUN_MOVE_COLLECTABLE (cSlot, tCollect);
		 		draw_map();
		 		_dump_map_screen();

		 		*(obj_map+(int) cx+ ((int) cy<<8))  =0;

		 		vbls= 0;
		 		while (vbls<4)
		 		{
		 			vbls+= Sync();
		 		}
			}


		}
	}
	else
	{
		frak=((ydif<<16)/xdif);

		for(i=0; i<xdif; i++)
		{
			if (i!=0)
			{
			/*Check that cx,cy position!*/
				if (test_los_bit (cx,cy))
		 	 		return (1);

				/*  YUP!
 				if (*(obj_map+(int) cx+ ((int)cy<<8))!= 0)
					return (1);
				*/

				if (nogoCharred (cx,cy))
					return (1);

			}

	  	cx += xadd;
	  	fraksum += frak;
	  	if (fraksum>=65536)
			{
	  		cy += yadd;
	  		fraksum -= 65536;
	  	}

			if (SHOW_CFLIGHT)
			{
		 		tCollect.x= cx;
		 		tCollect.z= cy;
		 		tCollect.type= 0;

		 		FUN_MOVE_COLLECTABLE (cSlot, tCollect);
		 		draw_map();
		 		_dump_map_screen();

		 		*(obj_map+(int) cx+ ((int) cy<<8))  =0;

		 		vbls= 0;
		 		while (vbls<4)
		 		{
		 			vbls+= Sync();
		 		}
			}


	  }

	}


	/*Huzzah!*/

	return (0);

};




/*When a tank explodes, it drops all its collectables */
/*Search for a collectable owned by the tank in the collectList
	before dropping it*/

void SCATTER_COLLECTABLES (void)
{
	/*Scatter radius, in tiles*/
	int sRadius;
	int sDiam;
	int maxTries=2;
	int i,j;
	char gripping;
	short tx,tz;
	//short sx,sz; /*Surrounding squares*/
	//char ftile;
	short addx,addz;
	COLLECT tCollect;
	COLLECT *aCollect;
	int cSlot;
	char deathx, deathz; /*tank's final resting place*/
	int slotSeek;


	sRadius= 4;

	deathx= pl.x>>24;
	deathz= pl.z>>24;


	for (i=0;i<COLLECT_TYPES;i++)
	{
		slotSeek=0;

		/*Try to scatter all of type 'i */
		while (cStat[i].held!=0)
		{

			/*Find collectable of this type held by this tank*/
			cSlot= -1;
			while (slotSeek!=MAX_COLLECTABLES&&cSlot==-1)
			{
				aCollect=collect+slotSeek;
				if (aCollect->type==i&&collectList.slot[slotSeek]>0)
				{
					if (aCollect->x== 256+myID)
						cSlot= slotSeek;
				}
				slotSeek++;
			}


			gripping=1;

			while (gripping)
			{

				sDiam= sRadius*2;

				/* 'maxtries at placement before increasing radius*/
				for (j=0;j<(maxTries=sDiam);j++)
				{
					/*Randomly select collectable position*/
					/*Max diameter is 0xff*/
					addx= (rand()&0xff);
					while (addx>sDiam) addx-=sDiam;

					addz= (rand()&0xff);
					while (addz>sDiam) addz-=sDiam;

					addx-=sRadius;
					addz-=sRadius;


					tx= (short) deathx+ addx;
					tz= (short) deathz+ addz;


					/*Legitimize coords*/

					/*Out of map bounds*/
					if (tx>0xff||tx<0) continue;
					if (tz>0xff||tz<0) continue;


					/*Check the path of the object for obstruction*/
					if (!(gripping= obstruction (deathx,deathz,addx,addz,cSlot)))
						break;

				}/*j*/


				/*Difficulty finding room for object! E X P A N D ! */
				if (gripping)
					sRadius+=2;

				if (sRadius>60)
					break;

				ifkey (K_H)
					SHOW_CFLIGHT= 1;

			}/*gripping*/

			/*Place found for ctbl. Put it there!*/

			tCollect.x= tx;
			tCollect.z= tz;
			tCollect.type= i;


			if (cSlot==-1||gripping)
			/*if no slot, forget about replacing the 'held' objects*/
				cStat[i].held=0;
			else
			{
				/*new technique- MOVE instead of PLACE*/
				MOVE_COLLECTABLE (cSlot, tCollect);
				cStat[i].held--;
			}

		}/*Continue emptying type*/

	}/*i- move onto next type */


	ALL_HELD= 0;
	COLLECTABLES_COUNTDOWN_RESET ();

}





/*************************************************************/
/**************************************************************

						C O L L E C T A B L E S   E F F E C T S

 *************************************************************/

/*Reset all these to full when the player dies*/
void COLLECTABLES_COUNTDOWN_RESET (void)
{
	int i;
	for (i=0;i<COLLECT_TYPES;i++)
		cStat[i].cdown= cStat[i].cdown_max;

}


/*Fun! Decrements all collectables countdowns. Destroys 'em
	when cdown is 0, and makes the neccesary change to the
	player's tank*/

/*Hmm. Perhaps this could be extended to ownerless and perhaps
  inaccessable collectables, so they can be relocated after a
	timeout*/

void COLLECTABLES_COUNTDOWN (void)
{
	int cType;

	for (cType=0;cType<COLLECT_TYPES;cType++)
	{
		if (cStat[cType].cdown_max>0)
		{
			if (cStat[cType].held>0)
			{

				cStat[cType].cdown--;
		 		if (cStat[cType].cdown<=0)
				{
					/*Lose the collectable, cancel its effect*/
		 			USE_COLLECTABLE (cType);
		 			/*Restart countdown*/
		 			cStat[cType].cdown= cStat[cType].cdown_max;

		 		}

			}

		}
	}


}





/*************************************************************/
/*************************************************************/






/*Collectables with coords >255 are held *inside* tanks*/

/*These functions are called in objects.c using pointers
	GAME_ADDOBJ, GAME_REMOBJ */

void SHOK_ADDOBJ (OBJ_ADD *tAddObj)
{
	/*Add collectable to map*/
	/*insertSlotList has been done previous to this*/

	/*Only do it if all damage receieved*/
	if (WORLDREC_STATUS==WORLDREC_COMPLETE)
	{
		if (tAddObj->x<=255&&tAddObj->z<=255)
			( *(obj_map+tAddObj->x+ (tAddObj->z<<8)) )= cStat[tAddObj->type].sprite;
	}
	/*Update stats for this ctbl*/
	cStat[tAddObj->type].num++;

}



void SHOK_REMOBJ (OBJ_REM *tRemObj)
{
	int cx= collect[tRemObj->id].x;
	int cz= collect[tRemObj->id].z;

	/*Remove collectable from map(If it's on there)*/
	if (cx<=255&&cz<=255)
		( *(obj_map+cx+ (cz<<8)) )=0;

	/*Update stats for this ctbl*/
	cStat[tRemObj->type].num--;

}



/*If the object is being picked up, this removes it from the
	objmap, else it is moved to its new position*/

void SHOK_MOVOBJ (OBJ_MOV *tMovObj)
{
	COLLECT *pCollect;
	int cx;
	int cz;

	/*OBJECT IS BEING PICKED UP- remove it from map*/
	if (tMovObj->x>255)
	{
		pCollect= collect+tMovObj->id;

		cx= pCollect->x;
		cz= pCollect->z;

		(*(obj_map + cx + (cz<<8))) = 0;
	}
	else
	{
	/*OBJECT IS BEING MOVED, OR REPLACED ON MAP*/
		pCollect= collect+ tMovObj->id;

		cx= tMovObj->x;
		cz= tMovObj->z;

		/*Only do it if all damage received*/
		if (WORLDREC_STATUS==WORLDREC_COMPLETE)
	 		(*(obj_map + cx + (cz<<8))) = 8;/*cStat[pCollect->type].sprite; */

	}

}



/*-----------------22/01/96 14:26-------------------

	Functions which actually carry out the effects of ctbls

--------------------------------------------------*/

void ctbl_tankStat (int uType, char onoff)
{
	update_pickups();
};



void ctbl_newWeapon (int wType, char onoff)
{
	pl.cWeapon= TRIPLE;
};


void ctbl_newSuperWeapon (int wType, char onoff)
{

};



void ctbl_upgradeShells (int sType, char onoff)
{


};


void ctbl_upgradeTank (int uType, char onoff)
{

	switch (uType)
	{
		case 0:
			armourDisplayColour = ARMOUR_OK_COLOUR;
			play_armour_warning_sound();
			draw_armour_display ();
		break;


		default:
			net_getout ("ctbl_upgradeTank..... ARSE!");
		break;
	}


};



void ctbl_tankStatus (int uType, char onoff)
{
	ntanks[myID]->G_STATUS|=uType;
}


/****/




/*Just do it*/
void reset_ctbl_effects (void)
{
	ctbl_resetShells();

	ctbl_resetTank();
}



void ctbl_resetTank()
{

}


/*Convert game_data format to affect the tank*/
void ctbl_implementTank()
{

}


/*Reset shells to default values*/
void ctbl_resetShells (void)
{
	pl.shellDamage = 0x100;
	pl.shellSpeed = 0xe00;
	pl.shellDelay = enemyShellDelays[PLAYER_TANK];
	pl.shellRange = enemyShellRanges[PLAYER_TANK];
};


/*Resets values associated with collectables to default*/
void ctbl_values_reset (void)
{
	int cType;

	for (cType= 0;cType< COLLECT_TYPES; cType++)
	{
		* ((int *) cStat[cType].affected_val)=
			cStat[cType].default_val;
	}

}


/************************************************************/
static	int xadder[9] = {-256,0,256,-256,0,256,-256,0,256};
static	int zadder[9] = {-256,-256,-256,0,0,0,256,256,256};

void plyr_det_collectables (void)
{
	uchar *map_ptr;
	uchar *block[9];
	int tilePos;

	int tdx,tdz,dx,dz,obj_x,obj_z,i;
	int map_x,map_z;
	int tpx,tpz;
	int rad;
	short	map_val;



	char TEMP_PICKUP_TOGGLE= 0;


	tpx = (int) (pl.x >> 16) & 0xffff;
	tpz = (int) (pl.z >> 16) & 0xffff;

	map_ptr = obj_map;
	map_ptr += (tpx >> 8) + (tpz & 0xff00);

	map_x = (tpx & 0xff00) + 0x80;
	map_z = (tpz & 0xff00) + 0x80;

	block[0] = (map_ptr-257);
	block[1] = (map_ptr-256);			//  -----
	block[2] = (map_ptr-255);			// |0|1|2|
	block[3] = (map_ptr-1);		  	// |-|-|-|
	block[4] = (map_ptr);			  	// |3|P|5|	Player is on block 4.
	block[5] = (map_ptr+1);		  	// |-|-|-|
	block[6] = (map_ptr+255);			// |6|7|8|
	block[7] = (map_ptr+256);			//  -----
	block[8] = (map_ptr+257);


	for (i=0;i<9;i++)
	{
		if ((*block[i]) && det_tabs[region][((*block[i]) - 1) << 1])
		{
			rad = det_tabs[region][((*block[i]) - 1) << 1];
			obj_x = map_x + xadder[i];
			obj_z = map_z + zadder[i];

 			dx = tdx = tpx - obj_x;
 			dz = tdz = tpz - obj_z;

			rad *= rad;
			dx *= dx;
			dz *= dz;

			if ((dx+dz) < (rad + 0x20000))
			{
				map_val = det_tabs[region][(((*block[i]) - 1) << 1)+1];

				if (map_val & DET_PICKUP)
 				{
					tilePos= block[i]- obj_map;

						/*Only picked up if player doesn't have max*/
						if (PICKUP_COLLECTABLE(tilePos))
						{
							*block[i] =0;
							play_picked_up_collectable_sound();
						}
						else
						{
							if (!PICKUP_TOGGLE)
								newTextMessage (" CAN'T 'AVE THAT");
						}

					/*Only set if player has newly run over ctbl*/
 					TEMP_PICKUP_TOGGLE= 1;
 					PICKUP_TOGGLE= 1;
				}
			}
		}
	}


	if ((!PICKUP_TOGGLE)&&TEMP_PICKUP_TOGGLE)
		SWITCHED_PICKUP_TOGGLE++;

	/*NETWORK*/
	/*Stops non-picked up ctbl being repeatedly picked up*/
	PICKUP_TOGGLE=TEMP_PICKUP_TOGGLE;

}




