#include <ctype.h>
#include "headers.h"
#include "chuck.h"
#include "walldraw.h"
#include "e_global.h"
#include "rshock.h"
#include "shock.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"


#include "enemlogc.h"


#define CHEATS_AVAILABLE	9






extern char key_to_ascii [256][3];






enum { INFINITE_SHIELD_CHEAT, FULL_ARMOUR_CHEAT, FULL_ENGINE_CHEAT,
			 FULL_TRACKS_CHEAT, NO_COLLISION_CHEAT, FULL_ARMOURMENT_CHEAT,
			 NO_DROWNING_CHEAT, JUMP_LEVEL_CHEAT, STONED_CHEAT };

char	cheatCodes[CHEATS_AVAILABLE][32] =
{
	"CHEESY PEAS",      			// INFINITE SHIELDS
	"RATTY RAT RATTY",				// full armour
	"ELVIS LIX",							// full engine
	"EDDIE PANTS",						// full	tracks
	"TENDRIL",								// no collision detection
	"THE FEARNS",							// full armourment
	"BEARDED LADY",						// no drowning
	"BELL",										// jump to a level
	"GRIFTA GRIFTA BIFTA" 		// stoned mode
};

uchar	posCheatCodes[CHEATS_AVAILABLE] =
{
	0,0,0,0,0,0,0,0
};

uchar	cheatCodeProccessed[CHEATS_AVAILABLE] =
{
	0,0,0,0,0,0,0,0
};

uchar	cheatCodeLengths[CHEATS_AVAILABLE] =
{
	0,0,0,0,0,0,0,0
};



uchar	cheatKeyPressed=FALSE;
char	currentCheatCode=-1;
uchar	currentCheatChar=0;
int		keyPressed=0;


uchar	kUp=0, kDown=0, kSelect=0, kLeft=0, kRight=0;


void	set_options(void)
{
	int	paletteChanged=FALSE;


	if ( checkExitGame )
	{
		ifkey( K_Y )
		{
			setoptions=FALSE;
			set_exit_game(ENDGAME_QUIT);
			game_data.missstatus=MISSION_FAILED;
			objectiveAchieved=FALSE;
		}

		ifkey( K_N )
		{
			checkExitGame=FALSE;
		}

		return ;
	}


	ifkey( K_UP )
	{
		if ( !kUp )
		{
			optionItem--;
			if ( optionItem<0 )
			{
				optionItem=MAX_OPTION_ITEMS-1;
			}
			kUp=TRUE;
			play_click_sound();
		}
	}
	else
		kUp=FALSE;


	ifkey( K_DOWN )
	{
		if ( !kDown )
		{
			optionItem++;
			if ( optionItem>=MAX_OPTION_ITEMS )
			{
				optionItem=0;
			}
			kDown=TRUE;
			play_click_sound();
		}
	}
	else
		kDown=FALSE;


	if ( (keydata->keymap[K_RET]) || (keydata->keymap[K_SPACE]) )
	{
		if ( !kSelect )
		{
			kSelect=TRUE;

			switch ( optionItem )
			{
				case SOUND_OPTION:
					optionSettings[SOUND_OPTION]^=TRUE;
					SoundDIGIEnable(optionSettings[SOUND_OPTION]);
					play_click_sound();
					break;

				case MUSIC_OPTION:
					optionSettings[MUSIC_OPTION]^=TRUE;

					if ( !optionSettings[MUSIC_OPTION] )
					{
						CDStop();
					}
					else
					{
				 		play_me_a_song(optionSettings[MUSIC_TRK_OPTION]);
					}
					play_click_sound();
					break;

				case MUSIC_TRK_OPTION:
					play_me_a_song(optionSettings[MUSIC_TRK_OPTION]);
					optionSettings[MUSIC_OPTION] = TRUE;
					play_click_sound();
					break;

				case QUIT_MENU_OPTION:
					//setoptions=FALSE;
					checkExitGame=TRUE;
					//set_exit_game(ENDGAME_QUIT);
					//game_data.missstatus=MISSION_FAILED;
					//objectiveAchieved=FALSE;
					play_click_sound();
					break;
			}
		}
	}
 	else
		kSelect=FALSE;


	if ( optionItem==MUSIC_TRK_OPTION )
	{
		ifkey( K_LEFT )
		{
			if ( (optionSettings[MUSIC_TRK_OPTION]>1) && !kLeft )
			{
				optionSettings[MUSIC_TRK_OPTION]--;
				kLeft=TRUE;
				play_click_sound();
			}
		}
		else
			kLeft=FALSE;

		ifkey( K_RIGHT )
		{
			if ( (optionSettings[MUSIC_TRK_OPTION] < optionLimits[MUSIC_TRK_OPTION]) && !kRight )
			{
				optionSettings[MUSIC_TRK_OPTION]++;
				kRight=TRUE;
				play_click_sound();
			}
		}
		else
			kRight=FALSE;
	}


	if ( optionItem==SOUND_VOLUME_OPTION )
	{
		ifkey( K_LEFT )
		{
			if ( optionSettings[SOUND_VOLUME_OPTION]>0 )
			{
				optionSettings[SOUND_VOLUME_OPTION]--;
				play_click_sound();
			}
		}
		else
		ifkey( K_RIGHT )
		{
			if ( optionSettings[SOUND_VOLUME_OPTION] <= optionLimits[SOUND_VOLUME_OPTION] )
			{
				optionSettings[SOUND_VOLUME_OPTION]++;
				play_click_sound();
			}
		}
	}


	if ( optionItem==SATURATION_OPTION )
	{
		ifkey( K_LEFT )
		{
			if ( optionSettings[SATURATION_OPTION]>0 )
			{
				optionSettings[SATURATION_OPTION]--;
				paletteChanged=TRUE;
			}
		}
		else
		ifkey( K_RIGHT )
		{
			if ( optionSettings[SATURATION_OPTION] <= optionLimits[SATURATION_OPTION] )
			{
				optionSettings[SATURATION_OPTION]++;
				paletteChanged=TRUE;
			}
		}
	}


	if ( optionItem==VALUE_OPTION )
	{
		ifkey( K_LEFT )
		{
			if ( optionSettings[VALUE_OPTION]>0 )
			{
				optionSettings[VALUE_OPTION]--;
				paletteChanged=TRUE;
			}
		}
		else
		ifkey( K_RIGHT )
		{
			if ( optionSettings[VALUE_OPTION] <= optionLimits[VALUE_OPTION] )
			{
				optionSettings[VALUE_OPTION]++;
				paletteChanged=TRUE;
			}
		}
	}



	if ( paletteChanged )
	{
		alter_palette(originalPal, palette, optionSettings[SATURATION_OPTION], optionSettings[VALUE_OPTION] );
		dump_pal(palette, 0, 256);
	}


	/*-----------------21/12/95 14:12-------------------
	 cheat mode detection section
	--------------------------------------------------*/
	if(!cheatKeyPressed && keydata->keys_held!=0)
	{
		int i;

		for ( i=0; i<CHEATS_AVAILABLE; i++ )
		{
			ifkey( cheatCodes[i][cheatCodeProccessed[i]] )
			{
				setcol(WHITE);
				cheatCodeProccessed[i]++;
				if ( cheatCodeProccessed[i]==cheatCodeLengths[i] )
				{
					set_cheat(i);
					cheatCodeProccessed[i]=0;
				}
			}
			else
			{
				cheatCodeProccessed[i]=0;
			}
		}
	}



	if ( keydata->keys_held==0 )
	{
		cheatKeyPressed=FALSE;
	}
	else
		cheatKeyPressed=TRUE;
}




void	set_cheat(int cheatNumber)
{
	switch ( cheatNumber )
	{
		case STONED_CHEAT:
			tripFactor=TRUE;
			break;
	}
}


void	print_cheat_stats(void)
{
	print(10,72,"%02d %02d %02d %02d %02d %02d %02d %02d %02d",
		cheatCodeProccessed[0],
		cheatCodeProccessed[1],
		cheatCodeProccessed[2],
		cheatCodeProccessed[3],
		cheatCodeProccessed[4],
		cheatCodeProccessed[5],
		cheatCodeProccessed[6],
		cheatCodeProccessed[7],
		cheatCodeProccessed[8]);
}




void	reset_cheat_checks(void)
{
	memset(cheatCodeProccessed, 0, sizeof(cheatCodeProccessed));
	memset(posCheatCodes, 0, sizeof(posCheatCodes));

	cheatKeyPressed=FALSE;
	currentCheatCode=0xff;
	currentCheatChar=0;
}


void	init_cheat_checks(void)
{
	int i,j,k;


	for ( i=0; i<CHEATS_AVAILABLE; i++ )
	{
		cheatCodeLengths[i]=strlen(cheatCodes[i]);				// get length of cheat code
		for ( j=0; j<cheatCodeLengths[i]; j++ )
		{
			k=0;
			while ( k<255 ) 																// convert ascii characters to scan codes
			{
				if ( cheatCodes[i][j]==key_to_ascii[k][1] )
				{
					cheatCodes[i][j]=key_to_ascii[k][0];
				}

				if ( cheatCodes[i][j]==0 )
				{
					break;
				}

				k++;
			}
		}
	}
}
/*************************************************************************/





#ifdef FLOPPY_VERSION
char key_to_ascii [256][3] =
 {
 ZOWT,     			 0,		0,
 K_ESC, 				 0,		0,
 K_1,           49,		33,
 K_2,           50,		34,
 K_3,           51,		0,
 K_4,           52,		36,
 K_5,           53,		37,
 K_6,           54,		0,
 K_7,           55,		38,
 K_8,           56,		42,
 K_9,           57,		40,
 K_0,           48,		41,
 K_MINUS,       45,		0,
 K_PLUS,        43,		0,
 K_BSP,         0 ,   0,
 K_TAB,         0 ,   0,
 K_Q,          113,  81,
 K_W,          119,  87,
 K_E,          101,  69,
 K_R,          114,  82,
 K_T,          116,  84,
 K_Y,          121,  89,
 K_U,          117,  85,
 K_I,          105,  73,
 K_O,          111,  79,
 K_P,          112,  80,
 K_OPENSB,       0,   0,
 K_CLOSESB,      0,   0,
 K_RET,          13,  0,
 K_LCTRL,         0 , 0,
 K_A,            97, 65,
 K_S,           115, 83,
 K_D,           100, 68,
 K_F,           102, 70,
 K_G,           103, 71,
 K_H,           104, 72,
 K_J,           106, 74,
 K_K,           107, 75,
 K_L,           108, 76,
 K_COLON,        58,  0,
 K_APOST,        39,   0,
 K_APOST2,       96,   0,
 K_LSHIFT,      0 ,   0,
 K_BSLASH,      0 ,   0,
 K_Z,          122,  90,
 K_X,          120,  88,
 K_C,           99,  67,
 K_V,          118,  86,
 K_B,           98,  66,
 K_N,          110,  78,
 K_M,          109,  77,
 K_COMMA,       44,   0,
 K_DOT,         46,   0,
 K_SLASH,       47,   63,
 K_RSHIFT,       0,   0,
 K_NUMSTAR,      0,   0,
 K_LALT,         0,   0,
 K_SPACE,       32,   0,
 K_CAPS,         0,   0,
 K_F1,           0,   0,
 K_F2,           0,   0,
 K_F3,           0,   0,
 K_F4,           0,   0,
 K_F5,           0,   0,
 K_F6,           0,   0,
 K_F7,           0,   0,
 K_F8,           0,   0,
 K_F9,           0,   0,
 K_F10,          0,   0,
 K_NUMLOCK,      0,   0,
 K_SCRLOCK,      0,   0,
 K_HOME,         0,   0,
 K_UP,           0,   0,
 K_PGUP,         0,   0,
 K_NUMMINUS,     0,   0,
 K_LEFT,         0,   0,
 K_NUM5,         0,   0,
 K_RIGHT,        0,   0,
 K_NUMPLUS,      0,   0,
 K_END,          0,   0,
 K_DOWN,         0,   0,
 K_PGDN,         0,   0,
 K_INSERT,       0,   0,
 K_DELETE,       0,   0,
 K_SYSREQ,       0,   0,
 ZOWT,           0,   0,
 ZOWT,           0,   0,
 K_F11,      	 	 0,   0,        /*87*/
 K_F12,	         0,   0
};


#endif
