	.386

	.MODEL	flat,stdcall

	INCLUDE	aglobals.h

	.DATA




VEIWPORT_HEIGHT	EQU	64

; Look_at_this
; Speed up notes :
; -Put in roving pointer


lastlink	dword	0
linkfree	DWORD	0  	; Free entry in link list.
sebx		DWORD	0  	; Store for ebx
secx		DWORD	0  	; Store for ecx
sedx		DWORD	0  	; Store for edx
;sprrotnum	DWORD	0

d2		DWORD	0
d3		DWORD	0
d4		DWORD	0
d5		DWORD	0
d6		DWORD	0
D7		DWORD	0

WALLCOUNT	DWORD	0
WALLNUMBER	DWORD	0

FXNUMBER	DWORD 	0

ZDEPTH		SWORD	0
LAST_WALL_Z	SWORD	0

depthsortx	SWORD	0
depthsortz	SWORD	0

bearing		SWORD	0
xand		SWORD	0
zand		SWORD	0
xloop		SWORD	0
yloop		SWORD	0

xoff		SWORD	0	; X screen offset.
splyr		SWORD	0

xmod		SWORD	0
ZMOD		SWORD	0

COSANG		SWORD	0
sinang		sword	0









	.CODE



NSCR_WIDTH		EQU	320
Z_CLIP_DEPTH		EQU	612
WALL_CHECK_RANGE	EQU 	4000H
WALL_TAG		EQU	0ff00h
MIN_WALL_APPEAR_DIST	EQU 	2000H
Max_FX_SPRITES		EQU	128	; If you change this remember to
					; change equivalent define statment in
					; shock.h
FX_SPRITE_TAG		EQU	256




testforobject	MACRO

	LOCAL	@@noobj

	mov	eax,esi
	sub	eax,obj_map

	jl	@@noobj

	cmp	eax,65535	; = 0xffff - 511, (Was 15871=0x4000-511 approx)
	jg	@@noobj

	mov	al,[esi]
	or	al,al
	jz	@@noobj

	call	oneobject

@@noobj:
	dec	esi
	dec	xloop

	ENDM




sprite_origin_	PROC C PUBLIC

   	pushad

	mov	xoff,160

	call	clearlinklist

moveobjs:
	MOV	esi,MOB

	mov	bearing,2047
	mov	cx,pangle
	sub	bearing,cx

@@mdoloop:
	mov	edi,linkfree

	mov	cx,[esi+amob.m_def]
	cmp	cx,0ffffh
	je	floorobj			; Reached end of list of moving objects - test for visible floor obects and walls

	MOV	cx,WORD PTR PXPOS
	sub	cx,word ptr [esi+amob.m_x]    	; X position (relative to player)
	mov	[edi+allst.l_sx],cx
	mov	depthsortx,cx	; mg

	mov	dx,word ptr [esi+amob.m_z] 	; Z position (relative to player)
	sub	dx,word ptr pzpos
	mov	[edi+allst.l_sz],dx
	mov	depthsortz,dx	; mg


	mov	cx,WORD PTR [esi+amob.m_def]
	shl	cx,6
	mov	[edi+allst.l_def],cx		; Get Sprite definition number

	mov	cx,[esi+amob.m_ang]		; Get rotation
	and	cx,63

	or	[edi+allst.l_def],cx		; Use rotation to index into frame table (in bottom 6 bits of frame number)


	mov	cx,[esi+amob.m_y]
	mov	[edi+allst.l_sy],cx

	mov	cx,alt
	sub	[edi+allst.l_sy],cx

	CALL	ROTATE2

	sub	[edi+allst.l_sz],512

	call	perspective


	mov	dx,[esi+amob.m_plyr]

	cmp	WORD PTR [edi+allst.l_sx],-100           ; Check if on screen in x (left)
	JL	@@MOUTRANGE
	cMP	WORD PTR [edi+ALLST.L_SX],NSCR_WIDTH+100 ; Check if on screen in x (right)
	jg	@@moutrange
	cmp	WORD PTR [edi+allst.l_sz],130		 ; z check
	jl	@@moutrange

@@nocheck:
	mov	[edi+allst.l_pl],dx 	; Get player number.

	call	insertll

	add	linkfree,sizeof ALLST

@@moutrange:
	add	esi,SIZEOF AMOB
	jmp	@@mdoloop

floorobj:						; Test for the visible floor objects, then walls
	mov	esi,obj_map
	mov	ecx,pxpos
	movzx	bp,cl
	shr	cx,8
	add	cx,20

	mov	edx,pzpos
	MOVZX	bx,DL
	shr	dx,8
	add	dx,20
	shl	dx,8
	add	esi,edx
	add	esi,ecx

	mov	xand,bp
	mov	zand,bx

	mov	yloop,40
@@loop1:
	mov	xloop,40

	REPEAT	40
	testforobject
	ENDM

	sub	esi,256-40
	dec	yloop
	jnz	@@loop1

;Insert walls into list here
;


wallobj:

	MOVZX	eax,NUMSFCS
	MOV	WALLCOUNT,eax
	MOV	WALLNUMBER,0

	MOV	esi,WALLMIDS			; esi points to MID POINTS OF WALLS

	MOV	LAST_WALL_Z,WALL_CHECK_RANGE

	MOV	ecx,PZPOS
	ADD	LAST_WALL_Z,cx
	JNc	@@END_RANGE_OK

	MOV	LAST_WALL_Z,0FFFFH

@@END_RANGE_OK:

	SUB	cx,WALL_CHECK_RANGE
	JNS	@@SKIP_WALL_LOOP
	xor	cx,cx

@@SKIP_WALL_LOOP:
	MOV	dx,[esi+2]				; Get z midpoint of wall
	CMP	dx,cx					; Compare to minimum range value

	jae	short @@wall_loop			; Found the first one in range - start putting into draw list

	ADD	esi,4					; skip another wall
	INC	WALLNUMBER				; Note current wall number
	DEC	WALLCOUNT

	jz	@@end_wall_loop				; Just in case like.
	jmp	@@SKIP_WALL_LOOP

@@WALL_LOOP:
	MOV	edi,LINKFREE

	MOV	ecx,PXPOS
	MOVzx	edx,word ptr [esi+2]			; Get z midpoint of wall

	CMP	dx,LAST_WALL_Z
	JA	@@END_WALL_LOOP				; Skip rest of loop if reached end of wall range

	MOVZX	ebx,WORD PTR [esi]

	SUB	ecx,ebx					; Relative midpoint of wall (x)
	SUB	edx,pzpos				; Relative midpoint of wall (z)

	MOV	bp,cx
	MOV	bx,dx
	mov	depthsortx,cx	; mg
	mov	depthsortz,dx	; mg

;Range check on walls

	OR	ecx,ecx
	JNS	short @@WALLXPOSITIVE

	NEG	ecx

@@WALLXPOSITIVE:
	OR	edx,edx
	JNS	short @@WALLZPOSITIVE

	NEG	edx

@@WALLZPOSITIVE:
	CMP	edx,ecx
	Jg	@@WDZL					; dont ask.

	SHR	edx,1
	ADD	ecx,edx
	JMP	SHORT @@WALLRANGE

@@WDZL:
	SHR	ecx,1
	ADD	ecx,edx

@@WALLRANGE:
	MOV	edx,WALLNUMBER
	IMUL	edx,SIZEOF AWALL_DATA
	MOV	eax,WALLSFCS

	ADD	eax,edx
	MOVZX	edx,WORD PTR [eax+AWALL_DATA.WALLTYPE]	; Get wall height
	AND	edx,1E00H
	SHR	edx,1

	add	edx,MIN_WALL_APPEAR_DIST		; The larger the wall the further away it can be seen

	CMP	ecx,edx
	jA	short @@wallOutRange

	mov	word ptr [edi+allst.l_sx],bp		; Store relative x,z midpoints
	MOV	word ptr [edi+allst.l_sz],bx

	CALL	ROTATE2

	MOV	word ptr [edi+allst.l_def],WALL_TAG  	; signify a wall (768<<6)
	MOV	ebx, WALLNUMBER
	MOV	WORD PTR [edi+allst.l_pl],bx		; Store wall index in pl

	CALL	insertll
	ADD	LINKFREE, SIZEOF ALLST

@@wallOutRange:
	add	esi,4
	inc	wallnumber
	DEC	WALLCOUNT
	jnz	@@wall_loop

@@END_WALL_LOOP:

;*************************************************************************

fxspritelist:
	MOV	esi, FXSPRITES
	mov	fxnumber,Max_FX_SPRITES

@@fdoloop:
	mov	edi,linkfree

	MOV	ecx,[esi+AFX_SPRITE.USED]
	or	ecx,ecx
	je  	@@skipSprite			; FX sprite not in use

	MOV	cx,WORD PTR PXPOS
	sub	cx,word ptr [esi+afx_sprite.x]  ; X position (relative to player)
	mov	WORD PTR d4,cx			; store in d4
	mov	depthsortx,cx	; mg
	or	cx,cx
	jns	@@fxpsit
      	neg	cx

@@fxpsit:
	mov	WORD PTR d2,cx

	mov	dx,word ptr [esi+afx_sprite.z] 	; Z position (relative to player)
	sub	dx,word ptr pzpos
	mov	WORD PTR d5,dx			; store in d5
	mov	depthsortz,dx	; mg
	or	dx,dx
	jns	@@fxpsit2
	neg	dx

@@fxpsit2:
       	cmp	dx,WORD PTR d2
	jg	@@fdzl

	mov	cx,dx
	shr	cx,1
	movsx	ecx,cx
	movsx	ebp,WORD PTR d2
	add	ecx,ebp
	jmp	@@farange

@@fdzl:
	mov	cx,WORD PTR d2
	shr	cx,1
	movsx	ecx,cx
	movsx	edx,dx
	add	ecx,edx

@@farange:					; Range Check
	cmp	cx,obrange
	ja	@@skipSprite

	MOV	cx,WORD PTR [esi+AFX_SPRITE.FRM]
	SHL	cx,2
	OR 	cx,WORD PTR [esi+AFX_SPRITE.SPRITETYPE]
	ADD	cx, FX_SPRITE_TAG

	SHL	cx,6
	OR	cx,WORD PTR [esi+AFX_SPRITE.SCALING]

	MOV	[edi+ALLST.L_DEF],cx		; Get Sprite definition number

	mov	cx,WORD PTR d4
	mov	[edi+allst.l_sx],cx

	mov	cx,[esi+amob.m_y]
	mov	[edi+allst.l_sy],cx

	mov	cx,alt
	sub	[edi+allst.l_sy],cx

	mov	cx,WORD PTR d5
	mov	[edi+allst.l_sz],cx


	CALL	ROTATE2

	sub	[edi+allst.l_sz],512

	call	perspective

	cmp	WORD PTR [edi+allst.l_sx],-100           ; Check if on screen in x (left)
	JL	@@skipSprite
	cMP	WORD PTR [edi+ALLST.L_SX],NSCR_WIDTH+100 ; Check if on screen in x (right)
	jg	@@skipSprite
	cmp	WORD PTR [edi+allst.l_sz],130		 ; z check
	jl	@@skipSprite

	mov	WORD PTR [edi+allst.l_pl],0		; Not a targettable sprite.


	CALL	INSERTLL


	add	linkfree,SIZEOF ALLST

@@skipSprite:
	ADD	esi,SIZEOF AFX_SPRITE

	DEC	FXNUMBER
	jnz	@@fdoloop


@@endFXSpriteLoop:

;*************************************************************************

	mov	edi,linkfree				; Note that you have reached end of list
	mov	DWORD PTR [edi+allst.l_prev],0
	mov	DWORD PTR [edi+allst.l_next],0

	popad

	ret

;*********************
;* ONEOBJECT routine *
;*********************

oneobject:
	mov	edi,linkfree

	mov	bx,xloop
	neg	bx
	add	bx,20
	sal	bx,8
	add	bx,xand
	sub	bx,128

	mov	bp,bx

	mov	depthsortx,bx	; mg

	or	bx,bx
	jns	@@psit
	neg	bx

@@psit:
	mov	cx,yloop
      	sub	cx,20
	sal	cx,8

	sub	cx,zand
	add	cx,128 		; cx = d7.
	mov	dx,cx		; dx = d5.
	mov	depthsortz,cx	; mg
	or	cx,cx
	jns	short @@psit2
	neg	cx
@@psit2:
	cmp	cx,bx
	jg	short @@dzl

	ror	edx,16
	mov	dx,cx		;
	shr	dx,1		; Top 16 bits of dx = d3.
	add	dx,bx		;
	jmp	short @@arange
@@dzl:
	ror	edx,16
	mov	dx,bx
	shr	dx,1
	add	dx,cx
@@arange:
	cmp	dx,obrange
	jg	@@outrange

	movzx	bx,BYTE PTR [esi]

	shl	bx,6
	mov	[edi+allst.l_def],bx

	mov	[edi+allst.l_sx],bp		; X
	mov	WORD PTR [edi+allst.l_sy],0
	mov	bx,alt
	sub 	WORD PTR [edi+allst.l_sy],bx    ; Y
	ror	edx,16
	mov	[edi+allst.l_sz],dx	    	; Z

	call	rotate2				; rotate about player

	sub	[edi+allst.l_sz],512

	call	perspective			; apply perspective transformation

	cmp	WORD PTR [edi+allst.l_sx],-100
	jl	@@outrange
	cmp	WORD PTR [edi+allst.l_sx],NSCR_WIDTH+100
	jg	@@outrange
	cmp	WORD PTR [edi+allst.l_sz],130
	jl	@@outrange

	mov	WORD PTR [edi+allst.l_pl],0	; Not a player sprite.
	call	insertll
	add	linkfree,SIZEOF allst

@@outrange:
	ret

;***********************
;* PERSPECTIVE routine *
;***********************

perspective:
	movsx	ecx,WORD PTR [edi+allst.l_sz]	; Z range.
	or	ecx,ecx
	jnz	short @@ndiv0
	mov	ecx,10

@@ndiv0:
	MOVSX	eax,WORD PTR [edi+allst.l_sx]	; X
	MOV	edx,eax
	SAR	edx,31

	sal	eax,7   	;7
	idiv	ecx
	add	ax,xoff
	mov	[edi+allst.l_sx],ax

	MOVSX	eax,WORD PTR [edi+allst.l_sy]  	; Y
	MOV	edx,eax
	SAR	edx,31

	sal	eax,8	;8
	idiv	ecx
	add	ax,VEIWPORT_HEIGHT
	mov	[edi+allst.l_sy],ax

	ret


;*******************
;* ROTATE2 routine *
;*******************

rotate2:
	mov	edx,OFFSET sintab
	movzx	ebx,bearing
	add	ebx,ebx
	add	edx,ebx

	MOVSX	ebx,WORD PTR [edi+allst.l_sx]
	movsx	ecx,WORD PTR [edx+1024]
	imul	ebx,ecx

	movsx	ebp,WORD PTR [edi+allst.l_sz]
	movsx	ecx,WORD PTR [edx]
	imul	ebp,ecx

	sub	ebx,ebp

	sar	ebx,14
	mov	sebx,ebx

	movsx	ebx,WORD PTR [edi+allst.l_sx]
	movsx	ecx,WORD PTR [edx]
	imul	ebx,ecx			; ebx = d4

	movsx	ebp,WORD PTR [edi+allst.l_sz]
	movsx	ecx,WORD PTR [edx+1024]
	imul	ebp,ecx		     	; ebp = d5

	add	ebx,ebp
	sar	ebx,14

	MOV	[edi+allst.l_sz],bx 		; Store rotated z
	mov	ebx,sebx

	MOV	[edi+allst.l_sx],bx

	ret


;********************
;* INSERTLL routine *
;********************


INSERTLL:
	MOV	EDX,LASTLINK            ; edx = nlink
	mov	ebx,[edx+allst.l_prev]	; ebx = plink


; Get depth sorting value for new object in draw list

	push	edx

	movsx	ecx,depthsortz
	movsx	edx,depthsortx

	;Frigged square root
	or	ecx,ecx
	jns	@@znn
	neg	ecx
@@znn:
	or	edx,edx
	jns	@@xnn
	neg	edx
@@xnn:
	cmp	edx,ecx
	jg	@@zl

	shl	ecx,1
	add	ecx,edx
	jmp	@@mg1
@@zl:
	shl	edx,1
	add	ecx,edx		; ecx = depthval
@@mg1:
	pop	edx


; Decide which side of the list the new object goes in

	CMP	ECX,DWORD PTR [EDX+ALLST.L_ZDEPTH] ; if (depthval > nlink->z_depth)

	Jbe	short	@@NEARLIST	; depthval <= nlink->z_depth

	; depthval > nlink->z_depth

@@FARLIST:
	CMP	ECX,DWORD PTR [EBX+ALLST.L_ZDEPTH]

	Ja	SHORT	@@FARLIST_NO_INSERT

	;if ( depthval <= plink->z_depth) : found slot
	MOV	EDX,[EBX+ALLST.L_NEXT]	; nlink = plink->next

	MOV	dword ptr [edi+allst.l_zdepth],ecx
	MOV	[edx+ALLST.L_prev],edi
	MOV	[ebx+ALLST.L_next],edi

	MOV	[edi+ALLST.L_PREV],ebx
	MOV	[EDI+ALLST.L_NEXT],edx
	mov	lastlink,edi

	RET

@@FARLIST_NO_INSERT:
	;else
	; depthval > plink->z_depth
	MOV	EBX,[EBX+ALLST.L_PREV]	; plink = plink->prev
;	MOV	EDX,[EBX+ALLST.L_NEXT]	; nlink = plink->next  --- special speeeed up

	OR	EBX,EBX
	JNZ	short	@@FARLIST
	RET




	; (depthval <= nlink->z_depth)

@@NEARLIST:
	CMP	ECX,DWORD PTR [EdX+ALLST.L_ZDEPTH]

	Jbe	SHORT	@@NEARLIST_NO_INSERT
	;if ( depthval > nlink->z_depth ) : found slot

;speedup
	MOV	EBX,[EDX+ALLST.L_PREV]	; plink = nlink
;

	MOV	dword ptr [edi+allst.l_zdepth],ecx
	MOV	[edx+ALLST.L_prev],edi
	MOV	[ebx+ALLST.L_next],edi

	MOV	[edi+ALLST.L_PREV],ebx
	MOV	[EDI+ALLST.L_NEXT],Edx
	MOV	LASTLINK,EDI

	ret

@@NEARLIST_NO_INSERT:
	;else
	; depthval <= nlink->z_depth
;old way
;	MOV	EBX,edx			; plink = nlink
;	MOV	EDX,[EbX+ALLST.L_NEXT]	; nlink = plink->next


;speedup
	MOV	EDX,[EdX+ALLST.L_NEXT]	; nlink = plink->next
;


	OR	EdX,EdX
	JNZ	short	@@NEARLIST
	ret

;*************************
;* CLEARLINKLIST routine *
;*************************

clearlinklist:

	MOV	eax, LL

	MOV	LASTLINK, eax

	mov	ebx,eax
	add	ebx,sizeof ALLST	; ebx = Head - a0.
	mov	ecx,ebx
	add	ecx,SIZEOF ALLST   	; ecx = First entry.

	mov	DWORD PTR [ebx+allst.l_prev],0
	mov	DWORD PTR [ebx+allst.l_next],eax
	mov	WORD PTR [ebx+allst.l_def],0
	MOV	DWORD PTR [ebx+allst.l_zdepth],20000

	mov	DWORD PTR [eax+allst.l_next],0
	mov	DWORD PTR [eax+allst.l_prev],ebx
	mov	WORD PTR [eax+allst.l_def],0
	mov	dWORD PTR [eax+allst.l_zdepth],5

	MOV	LINKFREE,ECX

	ret

sprite_origin_	ENDP





SETUP_TRANSFORM_	PROC C PUBLIC

	push	ecx

	mov	bearing,2047		; Setup angle for rotate
	MOV	cx,PANGLE
	sub	BEARING,cx

	mov	xoff,160		; Middle of screen for perspective transform

	pop	ecx

	RET

SETUP_TRANSFORM_	ENDP






rotate_point_		PROC C PUBLIC

	PUSHAD

	MOV	edi,eax				; Get edi to point to 6 byte stucture (x,y,z)
	mov	esi,edx				; esi points to original point data

	MOV	ax,word ptr pxpos          	; Get relative x position
	sub	ax, word ptr [esi]
	mov	word ptr [edi+workpnt.x], ax	; store

	xor	ax,ax
	mov	[edi+workpnt.floor_y],ax		; Bottom y of wall point

	MOV	word ptr ax,[esi+2]
	SUB	ax,word ptr PZPOS
	MOV	[edi+workpnt.z],ax		; Z relative position

	MOV	eax, CURRENTWALLHEIGHT
	mov	[edi+workpnt.top_y],ax		; Top of wall point

; Rotate points around player

	mov	edx,OFFSET sintab
	movzx	ebx,bearing
	add	ebx,ebx
	add	edx,ebx

	movsx	ebx,WORD PTR [edi+workpnt.x]
	movsx	ecx,WORD PTR [edx+1024]
	imul	ebx,ecx

	movsx	ebp,WORD PTR [edi+workpnt.z]
	movsx	ecx,WORD PTR [edx]
	imul	ebp,ecx

	sub	ebx,ebp

	sar	ebx,14
	mov	sebx,ebx		; Save rotated x

	movsx	ebx,WORD PTR [edi+workpnt.x]
	movsx	ecx,WORD PTR [edx]
	imul	ebx,ecx			; ebx = d4

	movsx	ebp,WORD PTR [edi+workpnt.z]
	movsx	ecx,WORD PTR [edx+1024]
	imul	ebp,ecx		     	; ebp = d5

	add	ebx,ebp
	sar	ebx,14

	mov	[edi+workpnt.z],bx
	mov	ebx,sebx		; Get rotated x back

	mov	[edi+workpnt.x],bx		; Store rotated x

	MOV	cx, WORD PTR [edi+workpnt.z]	; save z (after rotation)

	MOV	WORD PTR [edi+workpnt.z_depth], cx	; Keep z distance for clipping reasons

	MOV	ZDEPTH, cx		; Keep it for the clipping test

	POPAD

	MOVSX	eax,zdepth		; get z depth
	CMP	eax,Z_CLIP_DEPTH
	Jle	@@CLIPPING

	XOR	eax,eax			; Returns 1 if don't need to clip
	inc	eax
	RET

@@CLIPPING:
	XOR	eax,eax			; Returns 0 if need to clip

	RET

ROTATE_POINT_		ENDP





apply_perspective_	PROC C PUBLIC

; apply perspective transformation

	PUSHAD

	MOV	edi,eax			; Get edi to point to 6 byte stucture (x,y,z)

	MOVSX	ecx,WORD PTR [edi+WORKPNT.Z]	; Z range.

	sub	ecx,512			; Move the viewplane

	or	ecx,ecx
	jnz	short @@ndiv0
	mov	ecx,10

@@ndiv0:

	MOVSX	eax,WORD PTR [edi+workpnt.x]	; X
	MOV	edx,eax
	SAR	edx,31

	sal	eax,7
	idiv	ecx
	add	ax,xoff
	mov	[edi+workpnt.scrn_x],ax		;

	MOV	ax,WORD PTR [edi+workpnt.floor_y]  	; YBOTTOM
	sub	ax,alt
	movsx	eax,ax

	MOV	edx,eax
	SAR	edx,31

	sal	eax,8
	IDIV	ecx

	add	ax,VEIWPORT_HEIGHT		;scr_height
	mov	[edi+workpnt.floor_y],ax


	MOV	ax,WORD PTR [edi+workpnt.top_y]  	; YTOP
	sub	ax,alt
	movsx	eax,ax

	MOV	edx,eax
	SAR	edx,31

	sal	eax,8
	idiv	ecx
	add	ax,scr_height
	mov	[edi+workpnt.top_y],ax

	POPAD
	ret

apply_perspective_		ENDP

;*************************************************************
;* Rotate single point and apply perspective transformation. *
;*************************************************************

rot_single_point_	PROC C PUBLIC

   	pushad

	mov	esi,eax

	mov	bearing,2047
	mov	cx,pangle
	sub	bearing,cx

	mov	cx,word ptr pxpos
	sub	cx,word ptr [esi] 	   	; X position (relative to player)
	mov	[esi],cx

	mov	dx,word ptr [esi+4]	 	; Z position (relative to player)
	sub	dx,word ptr pzpos
	mov	[esi+4],dx

	mov	cx,alt
	sub	[esi+2],cx

	call	sp_rotate

	sub	word ptr [esi+4],512

	call	sp_pers

	popad

	ret

;*******************************
;* Rotate point around player. *
;*******************************

sp_rotate:
	mov	edx,OFFSET sintab
	movzx	ebx,bearing
	add	ebx,ebx
	add	edx,ebx

	movsx	ebx,word ptr [esi]
	movsx	ecx,word ptr [edx+1024]
	imul	ebx,ecx

	movsx	ebp,word ptr [esi+4]
	movsx	ecx,word ptr [edx]
	imul	ebp,ecx

	sub	ebx,ebp

	sar	ebx,14
	mov	sebx,ebx

	movsx	ebx,word ptr [esi]
	movsx	ecx,word ptr [edx]
	imul	ebx,ecx			; ebx = d4

	movsx	ebp,word ptr [esi+4]
	movsx	ecx,word ptr [edx+1024]
	imul	ebp,ecx		     	; ebp = d5

	add	ebx,ebp
	sar	ebx,14

	MOV	[esi+4],bx 		; Store rotated z
	mov	ebx,sebx

	MOV	[esi],bx

	ret

;***********************
;* PERSPECTIVE routine *
;***********************

sp_pers:
	movsx	ecx,word ptr [esi+4]	; Z range.
	or	ecx,ecx
	jnz	short @@ndiv0
	mov	ecx,10

@@ndiv0:
	movsx	eax,word ptr [esi]	; X
	mov	edx,eax
	sar	edx,31

	sal	eax,7   	;7
	idiv	ecx
	add	ax,160
	mov	[esi],ax

	movsx	eax,word ptr [esi+2]  	; Y
	mov	edx,eax
	sar	edx,31

	sal	eax,8	;8
	idiv	ecx
	add	ax,VEIWPORT_HEIGHT
	mov	[esi+2],ax

	ret

rot_single_point_	ENDP


	END



