#include "headers.h"

#include "chuck.h"
#include "e_global.h"


#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"

#ifdef MEMCHK
	#include <memcheck.h>
#endif


// take this out
enum {TANK_ENEMY, HELICOPTER_ENEMY, GUN_EMPLACEMENT_ENEMY, GUNBOAT_ENEMY};
extern uint followPosition;
extern int showStatType=FALSE;
extern uint	currentEnemyStats;
//

#define TURRET_VELOCITY_INCREMENT	1
#define MAX_TURRET_VELOCITY		64
#define TURRET_SLOWDOWN_TOLERANCE	64
#define TURRET_LOCK_TOLERANCE	24

#define MAX_ANGLE							0x7FF
#define ANGLE_RANGE			 			0x800

#define SMALLEST_TURN					2

#define MIN_FLOOR_GRIP				4
#define MAX_FLOOR_GRIP				0

#define MAX_TILT_TURN_FACTOR	0x40
#define MAX_TILT_FACTOR				18
#define MEDIUM_TILT_FACTOR		14
#define LOW_TILT_FACTOR				10
#define TILT_RATE							4

#define BOTTOM_BOUNDARY   		0x0100
#define TOP_BOUNDARY   				0x1000

#define MAP_SCALE_ZOOM				K_PLUS
#define MAP_SCALE_REDUCE			K_MINUS





/*-----------------17/10/95 23:10-------------------
 Constants used for the rolling demo shite
--------------------------------------------------*/

#define TANKMLEFT							1
#define TANKMRIGHT						(1<<1)
#define TANKMFORWARD					(1<<2)
#define TANKMBACK							(1<<3)
#define TANKFIRE							(1<<4)
#define TANKSELECT						(1<<5)
#define TANKTACTICAL					(1<<6)
#define TANKZOOMIN						(1<<7)
#define TANKZOOMOUT						(1<<8)
#define TANKTARGET						(1<<9)







/*********************************************/

/* Variables below inserted by MG - 12-07-95 */

long		diffadd, accval, turnval, maxturn;
long		tgrip,taccelr,taccelc,tpreaccel,tbrake;
short		grip_val,slowd_val;
ushort	det_off,obj_hit;

/*********************************************/

extern short	fadeTime;

static long 	diff=0;

static int 	 	cfwrd,crvrs,clft,crgt,turretLeft,turretRight,turretCentre;

static int	  ltrack,rtrack;

static uint		justSelectedWeapon=FALSE;
static uint		justSelectedTactical=FALSE;
static uint		justSelectedTarget=FALSE;


static uint		playerTank=0;
static int		mapzoomdelay=0;
static int		mapreducedelay=0;

static uchar  fireweapon;

/** Variables used for movement of tank - that might be put into the plblock struct **/

MOVEMENT_A	*normalKeys;
MOVEMENT_B	*tankKeys;


int		reloadSoundPlayed=FALSE;


/****************************************************************/
/** Prototypes **/
/****************************************************************/

void	update_tank_status(TANK *tank);
void	update_helicopter_status(TANK *copter);


/********************************************************************/

#define AWOL_START_MIN	15
#define AWOL_START_MAX	240
#define AWOL_MIN				5
#define AWOL_MAX				250



void player_control(void)
{
	int	ochaingunheat=pl.chaingunHeat;
	int	weaponStatusDrawn=FALSE;

	fireweapon = 0;

	get_controls();

	if (pl.cWeapon==WCHAIN_GUN && cgunBurstCount )	/* Minimum burst rate on the machine gun */
	{
		fireweapon=TRUE;
	}

	update_tank_status(&pl);

	/*-----------------04/01/96 14:31-------------------
	 deal with turret shite here
	--------------------------------------------------*/

	if ( turretCentre )
	{
		turretCentering=TRUE;
	}
	else
	if ( turretRight )
	{
		turretCentering=FALSE;
		turretVelocity-=TURRET_VELOCITY_INCREMENT;
	}
	else
	if ( turretLeft )
	{
		turretCentering=FALSE;
		turretVelocity+=TURRET_VELOCITY_INCREMENT;
	}
	else
	if ( !turretCentering )
	{
		if ( turretVelocity>0 )
		{
			turretVelocity-=TURRET_VELOCITY_INCREMENT;
		}
		else
		if ( turretVelocity<0 )
		{
			turretVelocity+=TURRET_VELOCITY_INCREMENT;
		}
	}


	if ( turretCentering )
	{
		if ( turret_angle<0 )
		{
			if ( turret_angle>-TURRET_LOCK_TOLERANCE ) // check if close enough to lock
			{
				turretVelocity=turret_angle=0;				 // LOCK
				turretCentering=FALSE;
				play_turret_locked_sound();
			}
			else
			if ( turret_angle>-0x3ff )
			{
				turretVelocity+=TURRET_VELOCITY_INCREMENT;
			}
			else
			{
				turretVelocity-=TURRET_VELOCITY_INCREMENT;
			}
		}
		else
		if ( turret_angle>0 )
		{
			if ( turret_angle<TURRET_LOCK_TOLERANCE ) // check if close enough to lock
			{
				turretVelocity=turret_angle=0;				 // LOCK
				turretCentering=FALSE;
				play_turret_locked_sound();
			}
			else
			if ( turret_angle<0x3ff )
			{
				turretVelocity-=TURRET_VELOCITY_INCREMENT;
			}
			else
			{
				turretVelocity+=TURRET_VELOCITY_INCREMENT;
			}
		}
		else
		{
			turretVelocity=turret_angle=0;				 // LOCK
			turretCentering=FALSE;
		}
	}


	if ( turretVelocity<-MAX_TURRET_VELOCITY )
	{
		turretVelocity=-MAX_TURRET_VELOCITY;
	}
	else
	if ( turretVelocity>MAX_TURRET_VELOCITY )
	{
		turretVelocity=MAX_TURRET_VELOCITY;
	}

	turret_angle+=(turretVelocity>>2);

	if ( turret_angle>0x4ff ) // 7ff <-> 4ff
	{
		turret_angle-=0x7ff;
	}

	if ( turret_angle<-0x4ff ) // 7ff <-> 4ff
	{
		turret_angle+=0x7ff;
	}


	if ( turretVelocity )
	{
		start_turret_moving_sound();
	}
	else
	{
		stop_turret_moving_sound();
	}

	/*-----------------01/02/96 11:48-------------------
	 end of turret shite
	--------------------------------------------------*/

	if ( (pl.cWeapon!=WCHAIN_GUN) || ((pl.cWeapon==WCHAIN_GUN) && !fireweapon))
	{
		update_chaingun_count((&pl));

		if ( pl.chaingunHeat )
		{
			pl.chaingunHeat--;							/* Reduce the heat gun of the chain gun */
		}
	}
	else
	{
		if ( playerCoolDelay )
		{
			playerCoolDelay--;
			if ( !playerCoolDelay )
			{
//				pl.chaingunHeat-=(6+(game_data.cgunupg<<1));
				pl.chaingunHeat-=8;
			}
		}
	}

	if (pl.cWeapon==WCHAIN_GUN) 			/* Update the chain gun status */
	{
		if ( pl.chaingunHeat<4 )
		{
			if ( pl.chaingunHeat!=ochaingunheat )
			{
				weaponStatusDrawn=TRUE;
			}
		}
		else
		{
			if ( (ochaingunheat>>2) != (pl.chaingunHeat>>2) )
			{
				weaponStatusDrawn=TRUE;
			}
		}

		if ( otargLocked!=targ.locked )
		{
			weaponStatusDrawn=TRUE;
			otargLocked=targ.locked;
		}

		if ( weaponStatusDrawn )
		{
			draw_weapon_display(WCHAIN_GUN);
		}
	}


	/* Make sure tank doesn't go near the edges of the map */

	if ( ((pl.x>>24) < AWOL_MIN) || ((pl.x>>24) > AWOL_MAX) ||
			 ((pl.z>>24) < AWOL_MIN) || ((pl.z>>24) > AWOL_MAX)  )
	{
		objectiveAchieved=FALSE;
		game_data.missstatus=MISSION_FAILED;
		set_exit_game(ENDGAME_AWOL);
	}
	else
	{
		if ( ((pl.x>>24) < AWOL_START_MIN) || ((pl.x>>24) > AWOL_START_MAX) ||
			 ((pl.z>>24) < AWOL_START_MIN) || ((pl.z>>24) > AWOL_START_MAX)  )
		{
			show_message(AWOL_MESSAGE);
			start_message(EAR_MSG4);
		}
		else
			clear_messages;
	}

	camera_angle = (pl.angle+turret_angle)&0X7FF;

	#ifdef PC_VERSION
	#ifdef DEBUG_VERSION
	if ( followPosition )
	{
		switch ( showStatType )
		{
			case TANK_ENEMY:
				pl.x = enemyTanks[currentEnemyStats].x;
				pl.z = enemyTanks[currentEnemyStats].z;
				break;

			case HELICOPTER_ENEMY:
				pl.x = helicopters[currentEnemyStats].x;
				pl.z = helicopters[currentEnemyStats].z;
				break;
		}

	}
	#endif
	#endif

	if ( (playerChainCount>0)&&(!playerCoolDelay) )
	{
		playerChainCount--;
	}
}


/********************************************************************/






/********************************************************************/



void	update_tank_status(TANK *tank)
{
	int	tnkx, tnkz;

	playerTank = (tank->def == PLAYER_TANK);

	if ( tank->resetLos )
	{
		tnkx = (tank->x>>24)&0xff;
		tnkz = (tank->z>>24)&0xff;

		reset_los_bit(tnkx, tnkz);
		tank->resetLos = FALSE;
	}

 	tank->oldx = tank->x;
 	tank->oldz = tank->z;

	tank->yvel += 3;
	if ((tank->y + (tank->yvel>>3)) > 0)
	{
		tank->y = 0;
		if (tank->yvel > 32)
			tank->yvel = -tank->yvel>>3;
		else
			tank->yvel = 0;
	}
	else
		tank->y += (tank->yvel>>3);


	if (fireweapon)
	{
		fire_weapons(tank);
	}

	if (tank->spin_cnt)	/* Surpassed allowable skid? */
	{
		if(!tank->spin_delay)
		{
			if(abs(tank->turn) > (tank->maxturn >> 1))
			{
				if ( tank->turn < 0 )
				{
					tank->turn+=2 ;
					if ( tank->turn > 0 )
						tank->turn = 0 ;
				}

				if ( tank->turn > 0 )
				{
					tank->turn-=2;
					if ( tank->turn < 0 )
						tank->turn = 0 ;
				}
				if(!tank->turn)
					tank->spin_cnt >>= 1;
				else
					tank->spin_cnt-=2;
			}
			else
				tank->spin_cnt--;

			if(tank->spin_cnt < 0)
				tank->spin_cnt = 0;

			tank->angle += tank->turn >> 2;
		}
		else
		{
			tank->angle += tank->spin_delay >> 2;

			if(tank->spin_delay < 0)
				tank->spin_delay-=2;
			else
				tank->spin_delay+=2;
			if(abs(tank->spin_delay) >= (abs(tank->turn<<1)))
				tank->spin_delay = 0;
		}

		if(tank->spin_cnt < tank->maxturn)
			tank->speed -= (tank->speed >> 3);
		else
			tank->speed -= (tank->speed >> 5);

		if(tank->spin_cnt > tank->maxturn)
			clft = crgt = cfwrd = crvrs = 0;	/* Disable control. */
	}

	if (cfwrd && crvrs)
	{
		turnval = 4;
 		maxturn = tank->maxturn + (tank->maxturn >> 1) + (tank->maxturn >> 2);
	}
	else
	{
		turnval = 2;
		maxturn = tank->maxturn;
	}

	det_off = floor_map[(tank->x >> 24) + ((tank->z >> 16) & 0xffffff00)];
	grip_val = grip_tab[(det_off>>3) & 0xff];
	slowd_val = slowd_tab[(det_off>>3) & 0xff];

	/* NEGATIVE slowd_val MEANS BUMP SCREEN!!!! */



	if(playerTank)
	{
		if (grip_val == -1)	/* Deep water. */
		{
			sink_add+=2;
			grip_val = 6;

			if ( abs(tank->speed) > 0x180 )
			{
				tank->speed -= (tank->speed>>4);
			}
			else
			if ( tank->speed>0 )
			{
				tank->speed--;
			}
			else
			if ( tank->speed<0 )
			{
				tank->speed++;
			}
		}
		else if (grip_val == -2)	/* Shallow water / marshland. */
		{
			if(sink_add < 96)
		 		sink_add++;
			grip_val = 7;
		}
		else if (sink_add)
		{
			if((sink_add>>2) > 8)
				sink_add -= 8;
			else if(sink_add > 8)
				sink_add -= sink_add>>2;
			else
				sink_add--;
		}
	}
	else if (grip_val < 0)
		grip_val = 6;

	tpreaccel = tank->pre_accel + (grip_val << 5) + (grip_val << 4);	/* Affect stand still accel. */
	taccelr = tank->accelr + (grip_val << 4);		/* Affect accel rate. */
	taccelc = tank->accelc - (grip_val >> 2);		/* Affect accel constant. */
	tgrip = tank->trak_grip - (grip_val << 3);		/* Affect grip. */
	tbrake = tank->top_brake - (grip_val << 1);	/* Affect braking. */
	maxturn -= grip_val;													/* Affect turning capabilities. */

	if (crgt)
 	{
		if ( tank->turn - turnval > -maxturn )
			tank->turn -= turnval ;
		else if ( tank->turn >= -maxturn )
			tank->turn = -maxturn ;
		else
			tank->turn++;
	}
	else if (clft)
	{
		if ( tank->turn + turnval < maxturn )
			tank->turn += turnval;
		else if ( tank->turn <= maxturn )
			tank->turn = maxturn ;
		else
			tank->turn--;
	}
	else
	{
		if(!tank->spin_delay)
		{
			if ( tank->turn < 0 )
			{
				tank->turn++ ;
				if ( tank->turn > 0 )
					tank->turn = 0 ;
			}

			if ( tank->turn > 0 )
			{
				tank->turn--;
				if ( tank->turn < 0 )
					tank->turn = 0 ;
			}
		}
	}


	/** Forward and reverse */

	if (cfwrd)
	{
		if (tank->speed < 0)	/* Going backwards? */
		{
			if(playerTank && !objhitcnt)
				tiltvel += 8;
			accval = tbrake;
		}
		else if (tank->speed < (tank->top_speed >> 2))	/* Accelerating from standstill? */
		{
			if(playerTank && !objhitcnt)
				tiltvel -= 8;
			if (tank->speed < tank->top_speed)
				accval = ((tank->top_speed - tank->speed) / tpreaccel) + (taccelc >> 1);
			else
				accval = 0;
		}
		else  /* 1/4 speed to top speed. */
		{
			if(playerTank && tiltLev >= 104 && !objhitcnt)
				tiltvel -= 4;
			if (tank->speed < tank->top_speed)
				accval = ((tank->top_speed - tank->speed) / taccelr) + taccelc;
			else
				accval = 0;
		}

		if(tank->speed > 0)
		{
			if ((tank->speed - tank->top_speed) > 16)
				tank->speed -= 16;
			else if ((tank->speed + accval) > tank->top_speed)
				tank->speed = tank->top_speed;
			else
				tank->speed += accval;
		}
		else
			tank->speed += accval;
	}
	else if (crvrs)
	{
		if (tank->speed>0)  /* going forwards ? */
		{
			if(playerTank && !objhitcnt)
				tiltvel += 8;
			accval = tbrake;
		}
		else if (tank->speed > - (tank->top_speed >> 2))
		{
			if(playerTank && !objhitcnt)
				tiltvel -= 8;
			if(tank->speed > -tank->top_speed)
				accval = ((tank->top_speed + tank->speed) / tpreaccel) + (taccelc >> 1);
			else
				accval = 0;
		}
		else
		{
			if(playerTank && tiltLev >= 104 && !objhitcnt) // 104 was 120
				tiltvel -= 4;
			if(tank->speed > -tank->top_speed)
				accval = ((tank->top_speed + tank->speed) / taccelr) + taccelc;
  		else
				accval = 0;
		}

		if (tank->speed < 0)
		{
			if ((tank->speed + tank->top_speed) < -16)
				tank->speed += 16;
			else if ((tank->speed - accval) < -tank->top_speed )
				tank->speed = -(tank->top_speed >> 1);
			else
	 			tank->speed -= accval;
		}
		else
	 		tank->speed -= accval;
	}
	else
	{
		if (playerTank)
		{
			if(!objhitcnt && tank->speed != 0)
				tiltvel += 8;
			else
			{
				if (tiltvel < 0 && tiltLev == 8)
					tiltvel >>= 2;
				else if (tiltvel > 0 && tiltLev == 255)
					tiltvel >>= 2;
			}
		}
		accval = 0;

		if (!tank->y)	/* On floor? */
		{
			if ( tank->speed < -(tbrake >> 1) )
				tank->speed += (tbrake >> 1);
			else if ( tank->speed > (tbrake >> 1) )
				tank->speed -= (tbrake >> 1);
			else
	 			tank->speed = 0;
		}
	}




	if(!tank->spin_cnt)
		tank->angle += (tank->turn >> 2);
	tank->angle &= 2047;

	if (tank->dir != tank->angle)
	{
		diff = tank->dir - tank->angle;

		if (diff < -1024)
			diff += 2048;
		else if (diff > 1024)
			diff -= 2048;

		if(abs(diff) > 512 && !tank->spin_cnt && grip_val > 5)	/* Induce spin if skidding too much. */
		{
			tank->spin_delay = tank->turn;
			tank->turn <<= 1;
			tank->spin_cnt = abs(tank->turn);
		}

		if(tank->speed >= 0)
		{
			if(tank->speed < tank->top_speed)
			{
				if(accval)
					diffadd = (tgrip >> 5) + 2 + ( (abs(diff) / (144 - tgrip)) + ((tank->top_speed - tank->speed) >> 6));
				else
					diffadd = (tgrip >> 5) + ( (abs(diff) / (144 - tgrip)) + ((tank->top_speed - tank->speed) >> 6));
			}
			else
				diffadd = (tgrip >> 5) + 2 + (abs(diff) / (144 - tgrip));
		}
		else
		{
			if(tank->speed > -tank->top_speed)
			{
				if(accval)
					diffadd = (tgrip >> 5) + 2 + ( (abs(diff) / (144 - tgrip)) + ((tank->top_speed + tank->speed) >> 6));
				else
					diffadd = (tgrip >> 5) + ( (abs(diff) / (144 - tgrip)) + ((tank->top_speed + tank->speed) >> 6));
			}
			else
				diffadd = (tgrip >> 5) + 2 + (abs(diff) / (144 - tgrip));
		}

		if(tank->spin_cnt > tank->maxturn)
			diffadd >>= 1;

		if (diff < 0)
			tank->dir += diffadd;
		else
			tank->dir -= diffadd;
	}

	tank->dir &= 2047 ;

/****************/

	obj_hit = 0;

	if(playerTank)
	{
		tank->x += (tank->speed>>5) * ((int)sintab[tank->dir]) + (tank->shuntSpeed>>5) * ((int)sintab[tank->shuntDir]);
		tank->z += (tank->speed>>5) * ((int)sintab[tank->dir+512]) + (tank->shuntSpeed>>5) * ((int)sintab[tank->shuntDir+512]);
		if (plyr_det())											/* Detect against floor objects. */
		{
			tank->x += (tank->speed>>5) * ((int)sintab[tank->dir]) + (tank->shuntSpeed>>5) * ((int)sintab[tank->shuntDir]);
			tank->z += (tank->speed>>5) * ((int)sintab[tank->dir+512]) + (tank->shuntSpeed>>5) * ((int)sintab[tank->shuntDir+512]);
			if (plyr_det())											/* Detect against floor objects. */
			{
				tank->x += (tank->speed>>5) * ((int)sintab[tank->dir]) + (tank->shuntSpeed>>5) * ((int)sintab[tank->shuntDir]);
				tank->z += (tank->speed>>5) * ((int)sintab[tank->dir+512]) + (tank->shuntSpeed>>5) * ((int)sintab[tank->shuntDir+512]);
 				if (plyr_det())											/* Detect against floor objects. */
				{
					tank->x += (tank->speed>>5) * ((int)sintab[tank->dir]) + (tank->shuntSpeed>>5) * ((int)sintab[tank->shuntDir]);
					tank->z += (tank->speed>>5) * ((int)sintab[tank->dir+512]) + (tank->shuntSpeed>>5) * ((int)sintab[tank->shuntDir+512]);
				}
				else
					obj_hit = 1;
			}
			else
				obj_hit = 1;
		}
		else
			obj_hit = 1;
	}

/*-----------------12/04/95 16:22-------------------
 Asimilate pitch and tilt factors
--------------------------------------------------*/

	if ( playerTank )
	{
	 	update_tilt();
	}

	if (!obj_hit)
	{
		tank->x = tank->oldx;
		tank->z = tank->oldz;

		tank->x += (tank->speed>>5) * ((int)sintab[tank->dir]) + (tank->shuntSpeed>>5) * ((int)sintab[tank->shuntDir]);

		if (detect_collision(tank, NULL_ID) || (check_4_object_collision(tank)))
		{
			obj_hit=TRUE;
 			tank->x = tank->oldx;

			if (playerTank)
				tank->speed -= tank->speed>>5;
			else
				tank->speed -= tank->speed>>7;
		}

		tank->z += (tank->speed>>5) * ((int)sintab[tank->dir+512]) + (tank->shuntSpeed>>5) * ((int)sintab[tank->shuntDir+512]);

		if (second_detect_collision(tank, NULL_ID) || (second_check_4_object_collision(tank)))
		{
			obj_hit=TRUE;
			tank->z = tank->oldz;

			if (playerTank)
				tank->speed -= tank->speed>>5;
			else
				tank->speed -= tank->speed>>7;
		}


	}

	if ( tank->shuntSpeed )
	{
		if ( tank->shuntSpeed>0x100 )
		{
			tank->shuntSpeed -= tank->shuntSpeed>>4;
		}
		else
		if ( tank->shuntSpeed>0x40 )
		{
			tank->shuntSpeed -= tank->shuntSpeed>>5;
		}
		else
			tank->shuntSpeed=0;
	}


	if (tank->shellDelayCount) 								/* Update delay period between firing shells */
	{
		tank->shellDelayCount--;

		if ( playerTank )
		{
			if ( (!reloadSoundPlayed) && (pl.shellDelayCount<=20) )
			{
				reload_sample();
			}
		}
	}


	if ( !playerTank && tank->def!=ALLIED_TRUCK )
	{
		tnkx = (tank->x>>24)&0xff;
		tnkz = (tank->z>>24)&0xff;

		if ( !(test_los_bit(tnkx, tnkz )) )
		{
			set_los_bit(tnkx, tnkz);
			tank->resetLos = TRUE;
		}
	}


}



/**************************************************************/


#define DET_CONST	6



void	update_helicopter_status(TANK *tank)
{
 	tank->oldx = tank->x;
 	tank->oldz = tank->z;

	if (fireweapon)
		fire_weapons(tank);

	if (tank->spin_cnt)	/* Surpassed allowable skid? */
	{
		if(!tank->spin_delay)
		{
			if(abs(tank->turn) > (tank->maxturn >> 1))
			{
				if ( tank->turn < 0 )
				{
					tank->turn+=2 ;
					if ( tank->turn > 0 )
						tank->turn = 0 ;
				}

				if ( tank->turn > 0 )
				{
					tank->turn-=2;
					if ( tank->turn < 0 )
						tank->turn = 0 ;
				}
				if(!tank->turn)
					tank->spin_cnt >>= 1;
				else
					tank->spin_cnt-=2;
			}
			else
				tank->spin_cnt--;

			if(tank->spin_cnt < 0)
				tank->spin_cnt = 0;

			tank->angle += tank->turn >> 2;
		}
		else
		{
			tank->angle += tank->spin_delay >> 2;

			if(tank->spin_delay < 0)
				tank->spin_delay-=2;
			else
				tank->spin_delay+=2;
			if(abs(tank->spin_delay) >= (abs(tank->turn<<1)))
				tank->spin_delay = 0;
		}

		if(tank->spin_cnt < tank->maxturn)
			tank->speed -= tank->speed >> 3;
		else
			tank->speed -= tank->speed >> 5;

		if(tank->spin_cnt > tank->maxturn)
			clft = crgt = cfwrd = crvrs = 0;							/* Disable control. */
	}

	if (cfwrd || crvrs)
	{
		turnval = 2;
		maxturn = tank->maxturn + (tank->maxturn >> 2);
	}
	else
	{
		turnval = 1;
		maxturn = tank->maxturn;
	}

	det_off = floor_map[(tank->x >> 24) + ((tank->z >> 16) & 0xffffff00)];
	grip_val = grip_tab[(det_off>>3) & 0xff];

	grip_val = 6;

	tpreaccel = tank->pre_accel + (grip_val << 5) + (grip_val << 4);	/* Affect stand still accel. */
	taccelr = tank->accelr + (grip_val << 4);					/* Affect accel rate. */
	taccelc = tank->accelc - (grip_val >> 2);					/* Affect accel constant. */
	tgrip = tank->trak_grip - (grip_val << 3);				/* Affect grip. */
	tbrake = tank->top_brake - (grip_val << 1);				/* Affect braking. */
	maxturn -= grip_val;															/* Affect turning capabilities. */

	if (crgt)
 	{
		if ( tank->turn - turnval > -maxturn )
			tank->turn -= turnval ;
		else if ( tank->turn >= -maxturn )
			tank->turn = -maxturn ;
		else
			tank->turn++;
	}
	else if (clft)
	{
		if ( tank->turn + turnval < maxturn )
			tank->turn += turnval;
		else if ( tank->turn <= maxturn )
			tank->turn = maxturn ;
		else
			tank->turn--;
	}
	else
	{
		if(!tank->spin_delay)
		{
			if ( tank->turn < 0 )
			{
				tank->turn++ ;
				if ( tank->turn > 0 )
					tank->turn = 0 ;
			}

			if ( tank->turn > 0 )
			{
				tank->turn--;
				if ( tank->turn < 0 )
					tank->turn = 0 ;
			}
		}
	}

	if (cfwrd)
	{

		if (tank->speed < 0)														/* Going backwards? */
		{
			accval = tbrake;
		}
		else if (tank->speed < (tank->top_speed >> 2))	/* Accelerating from standstill? */
		{
			if (tank->speed < tank->top_speed)
				accval = ((tank->top_speed - tank->speed) / tpreaccel) + (taccelc >> 1);
			else
				accval = 0;
		}
		else  																					/* 1/4 speed to top speed. */
		{
			if (tank->speed < tank->top_speed)
				accval = ((tank->top_speed - tank->speed) / taccelr) + taccelc;
			else
				accval = 0;
		}

		if(tank->speed > 0)
		{
			if ((tank->speed - tank->top_speed) > 16)
				tank->speed -= 16;
			else if ((tank->speed + accval) > tank->top_speed)
				tank->speed = tank->top_speed;
			else
				tank->speed += accval;
		}
		else
			tank->speed += accval;
	}
	else if (crvrs)
	{

		if (tank->speed>0)
		{
			accval = tbrake;
		}
		else if (tank->speed > - (tank->top_speed >> 3))
		{
			if(tank->speed > -(tank->top_speed >> 1))
				accval = (((tank->top_speed >> 1) + tank->speed) / tpreaccel) + (taccelc >> 1);
			else
				accval = 0;
		}
		else
		{
			if(tank->speed > -(tank->top_speed >> 1))
				accval = (((tank->top_speed >> 1) + tank->speed) / taccelr) + taccelc;
  		else
				accval = 0;
		}

		if (tank->speed < 0)
		{
			if ((tank->speed + (tank->top_speed>>1)) < -16)
				tank->speed += 16;
			else if ((tank->speed - accval) < -(tank->top_speed >> 1))
				tank->speed = -(tank->top_speed >> 1);
			else
	 			tank->speed -= accval;
		}
		else
	 		tank->speed -= accval;
	}
	else
	{
		accval = 0;

		if ( tank->speed < -(tbrake >> 2) )
			tank->speed += (tbrake >> 2);
		else if ( tank->speed > (tbrake >> 2) )
			tank->speed -= (tbrake >> 2);
		else
	 		tank->speed = 0;
	}

	if(!tank->spin_cnt)
		tank->angle += (tank->turn >> 2);
	tank->angle &= 2047;

	if (tank->dir != tank->angle)
	{
		diff = tank->dir - tank->angle;

		if (diff < -1024)
			diff += 2048;
		else if (diff > 1024)
			diff -= 2048;

		if(abs(diff) > 512 && !tank->spin_cnt && grip_val > 5)	/* Induce spin if skidding too much. */
		{
			tank->spin_delay = tank->turn;
			tank->turn <<= 1;
			tank->spin_cnt = abs(tank->turn);
		}

		if(tank->speed >= 0)
		{
			if(tank->speed < tank->top_speed)
			{
				if(accval)
					diffadd = (tgrip >> 5) + 2 + ( (abs(diff) / (144 - tgrip)) + ((tank->top_speed - tank->speed) >> 6));
				else
					diffadd = (tgrip >> 5) + ( (abs(diff) / (144 - tgrip)) + ((tank->top_speed - tank->speed) >> 6));
			}
			else
				diffadd = (tgrip >> 5) + 2 + (abs(diff) / (144 - tgrip));
		}
		else
		{
			if(tank->speed < tank->top_speed)
			{
				if(accval)
					diffadd = (tgrip >> 5) + 2 + ( (abs(diff) / (144 - tgrip)) + (((tank->top_speed >> 1) + tank->speed) >> 6));
				else
					diffadd = (tgrip >> 5) + ( (abs(diff) / (144 - tgrip)) + (((tank->top_speed >> 1) + tank->speed) >> 6));
			}
			else
				diffadd = (tgrip >> 5) + 2 + (abs(diff) / (144 - tgrip));
		}


		if(tank->spin_cnt > tank->maxturn)
			diffadd >>= 1;

		if (diff < 0)
			tank->dir += diffadd;
		else
			tank->dir -= diffadd;
	}

	tank->dir &= 2047 ;


/****************/

 	tank->x += (tank->speed>>5) * ((int)sintab[tank->dir]);
	tank->z += (tank->speed>>5) * ((int)sintab[tank->dir+512]);


//	if ( detect_helicopter_collision(tank, HELICOPTER_DETECT_HEIGHT) )
//	{
//		tank->x = tank->oldx;
//		tank->z = tank->oldz;
//		tank->speed = 0;
//	}

	if (tank->shellDelayCount) 													/* Update delay period between firing shells */
		tank->shellDelayCount--;
}


/********************************************************************/


void	move_tank(TANK *mtank, int trnleft, int trnright, int mvforward, int mvbackwards, int gshoot)
{
	clft 	= trnleft;
	crgt 	= trnright;
	cfwrd 	= mvforward;
	crvrs	= mvbackwards;
	fireweapon = gshoot;

	update_tank_status(mtank);

	if ( (mtank->def==ENEMY_APC) && !fireweapon )
	{
		update_chaingun_count(mtank);
	}

}

/********************************************************************/


void	move_helicopter(TANK *mheli, int trnleft, int trnright, int mvforward, int mvbackwards, int gshoot, int detflag)
{
	clft 	= trnleft;
	crgt 	= trnright;
	cfwrd 	= mvforward;
	crvrs	= mvbackwards;
	fireweapon = gshoot;

	detflag = 0;

	update_helicopter_status(mheli);

	if ( !fireweapon )
	{
		update_chaingun_count(mheli);
	}
}



/********************************************************************/

#define 	MIN_JOYSTICK_TURN_VALUE		16


void get_controls(void)
{
	short	rollDemoKeys;


	/* Get the input from keyboard/joystick */

	fireweapon = cfwrd = crvrs = clft = crgt = ltrack = rtrack = 0;
	turretLeft = turretRight = turretCentre = 0;

	rollDemoKeys = 0;

	/*-----------------08/01/96 18:13-------------------
	 rolling demo playback code
	--------------------------------------------------*/

	if ( rollingDemo )
	{
		/* Take control from the demo file */

		rollDemoKeys = *crollData++;

		cfwrd = rollDemoKeys & TANKMFORWARD;
		crvrs = rollDemoKeys & TANKMBACK;
		clft 	= rollDemoKeys & TANKMLEFT;
		crgt	= rollDemoKeys & TANKMRIGHT;
		fireweapon = rollDemoKeys & TANKFIRE ;

  	if ( mapmode )
  	{
  	if(rollDemoKeys & TANKZOOMIN)
  	{
  		if ( mapzoomdelay==FALSE )
  		{
  			if ( mapscale>3 )
   				mapscale--;
  			mapzoomdelay=TRUE;
  		}
  	}
  	else
  		mapzoomdelay=FALSE;

  	if(rollDemoKeys & TANKZOOMOUT)
  	{
  		if ( mapreducedelay==FALSE )
  		{
  			if ( mapscale<6 )
  			{
  				mapscale++;
  			}
  			mapreducedelay=TRUE;
  		}
  	}
  	else
  		mapreducedelay=FALSE;
  	}


    if(rollDemoKeys & TANKTARGET)
    {
     	if (!change_target && justSelectedTarget==FALSE)
     	{
    		justSelectedTarget=TRUE;
    		change_target = 1;
    		target_no++;
    		target_no &= 0x03;
     	}
    }
    else
    	justSelectedTarget=FALSE;


    if( rollDemoKeys & TANKSELECT )
    {
    	if ( justSelectedWeapon==FALSE )
    	{
  			pl.cWeapon = (pl.cWeapon+1)%MAX_WEAPONS;

  			while ( !weaponsAvailable[pl.cWeapon] )
  			{
  				pl.cWeapon = (pl.cWeapon+1)%MAX_WEAPONS;
  			}

    		draw_weapon_display(pl.cWeapon);
    		justSelectedWeapon=TRUE;
    	}
    }
    else
    	justSelectedWeapon=FALSE;



    if( rollDemoKeys & TANKTACTICAL )
    {

    	if ( justSelectedTactical==FALSE )
    	{
    		mapmode ^= TRUE;
    		justSelectedTactical = TRUE;
    		if(drawCockpit = 1-mapmode)
    		{
    			draw_weapon_display(pl.cWeapon);
    			draw_armour_display();
    		}
  			else
  			{
  				drawMapScreen = TRUE;
  			}
    	}
    }
    else
    	justSelectedTactical = FALSE;

		return ;
	}

	/*-----------------08/01/96 18:13-------------------
	 end of rolling demo playback code
	--------------------------------------------------*/



	/*-----------------08/01/96 18:14-------------------
	 normal keyboard input code
	--------------------------------------------------*/

	if ( cinp.mType != joy_control )
	{
		switch(cinp.mType)
		{
		/* Ordinary controls */

			case normal_control:

				normalKeys=(MOVEMENT_A *) &(cinp.movement.normal_ctrl);

				ifkey(normalKeys->acclr)
					cfwrd=1;
				ifkey(normalKeys->declr)
					crvrs=1;
				ifkey(normalKeys->pan_left)
					clft=1;
				ifkey(normalKeys->pan_right)
					crgt=1;
				break;


		/* battle zone style controls */

			case tank_control:
				tankKeys=(MOVEMENT_B *) &(cinp.movement.tank_ctrl);

				ifkey(tankKeys->left_track_forward)	ltrack=1;
				ifkey(tankKeys->left_track_back)	ltrack-=1;

				ifkey(tankKeys->right_track_forward) rtrack=1;
				ifkey(tankKeys->right_track_back) rtrack-=1;

				switch(ltrack+rtrack)
				{
					case 2: 			/* Both tracks forward */
						cfwrd=1;
						break;

					case -2:			/* Both tracks backwards */
						crvrs=1;
						break;

					case 1:				/* only one track going - forward and rotate */
						cfwrd=1;
						clft=rtrack;
						crgt=ltrack;
						break;

					case -1:			/* Only one track going - backwards and rotate */
						crvrs=1;
						clft=ltrack;
						crgt=rtrack;
						break;

					case 0:				/* Both tracks going in opposite directions */
						crgt=(rtrack==-1);
						clft=(ltrack==-1);
			 		break;
				}

				break;
		}

		if ( mapmode )
		{
		ifkey(MAP_SCALE_ZOOM)
		{
			rollDemoKeys |= TANKZOOMIN;

			if ( mapzoomdelay==FALSE )
			{
				if ( mapscale>2 )
					mapscale--;
				mapzoomdelay=TRUE;
			}
		}
		else
			mapzoomdelay=FALSE;

		ifkey(MAP_SCALE_REDUCE)
		{
			rollDemoKeys |= TANKZOOMOUT;

			if ( mapreducedelay==FALSE )
			{
				if ( mapscale<6 )
				{
					mapscale++;
				}
				mapreducedelay=TRUE;
			}
		}
		else
			mapreducedelay=FALSE;
		}


		ifkey(cinp.target)
		{
			rollDemoKeys |= TANKTARGET;
 			if (!change_target && justSelectedTarget==FALSE)
 			{
				justSelectedTarget=TRUE;
				change_target = 1;
				target_no++;
				target_no &= 0x03;
 			}
		}
		else
			justSelectedTarget=FALSE;


		ifkey( cinp.select )
		{
			rollDemoKeys |= TANKSELECT;
			if ( justSelectedWeapon==FALSE )
			{
				pl.cWeapon = (pl.cWeapon+1)%MAX_WEAPONS;

				while ( !weaponsAvailable[pl.cWeapon] )
				{
					pl.cWeapon = (pl.cWeapon+1)%MAX_WEAPONS;
				}

				draw_weapon_display(pl.cWeapon);
				justSelectedWeapon=TRUE;
			}
		}
		else
			justSelectedWeapon=FALSE;



		ifkey( cinp.tactical)
		{
			rollDemoKeys |= TANKTACTICAL;
			if ( (justSelectedTactical==FALSE) && (fadeTime>=FADEPOINT))
			{
				mapmode ^= TRUE;
				justSelectedTactical = TRUE;
				if(drawCockpit = 1-mapmode)
				{
					draw_weapon_display(pl.cWeapon);
					draw_armour_display();
				}
				else
				{
					drawMapScreen = TRUE;
				}
			}
		}
		else
			justSelectedTactical = FALSE;


		ifkey( cinp.tleft )
		{
			turretLeft=TRUE;
		}

		ifkey( cinp.tright )
		{
			turretRight=TRUE;
		}

		ifkey( cinp.tcentre )
		{
			turretCentre=TRUE;
		}

		ifkey( cinp.fire )
		{
			fireweapon=TRUE;
			rollDemoKeys |= TANKFIRE;
		}
	}
	else
	{
		/*-----------------27/11/95 12:00-------------------
		 joystick controls
		--------------------------------------------------*/

		JoyRead();

		if ( joy1_x <= - MIN_JOYSTICK_TURN_VALUE )
		{
			clft = TRUE;
		}
		else if ( joy1_x >= MIN_JOYSTICK_TURN_VALUE )
		{
			crgt = TRUE;
		}

		if ( joy1_y <= - MIN_JOYSTICK_TURN_VALUE )
		{
			cfwrd = TRUE;
		}
		else if ( joy1_y >= MIN_JOYSTICK_TURN_VALUE )
		{
			crvrs = TRUE;
		}


		// FIRE SELECTED WEAPON

		if ( joy_fire & JOY_FIRE1 )
		{
			fireweapon=TRUE;
		}

		// SELECT TARGET FOR CHAIN/SAMS

		if ( joy_fire & JOY_FIRE2 )
		{
			if (!change_target && justSelectedTarget==FALSE)
 			{
				justSelectedTarget=TRUE;
				change_target = 1;
				target_no++;
				target_no &= 0x03;
 			}
		}
		else
			justSelectedTarget=FALSE;


		// CHANGE SELECTED WEAPON (USING THRUSTMASTER OR SECOND JOYSTICK)

		if ( joy_fire & JOY_FIRE3 )
		{
			if ( justSelectedWeapon==FALSE )
			{
				pl.cWeapon = (pl.cWeapon+1)%MAX_WEAPONS;

				while ( !weaponsAvailable[pl.cWeapon] )
				{
					pl.cWeapon = (pl.cWeapon+1)%MAX_WEAPONS;
				}

				draw_weapon_display(pl.cWeapon);
				justSelectedWeapon=TRUE;
			}
		}
		else
			justSelectedWeapon=FALSE;


		// switch to tactical map (USING THRUSTMASTER OR SECOND JOYSTICK)

		if ( joy_fire & JOY_FIRE4)
		{
			if ( justSelectedTactical==FALSE )
			{
				mapmode ^= TRUE;
				justSelectedTactical = TRUE;
				if(drawCockpit = 1-mapmode)
				{
					draw_weapon_display(pl.cWeapon);
					draw_armour_display();
				}
				else
				{
					drawMapScreen = TRUE;
				}
			}
		}
		else
			justSelectedTactical = FALSE;



		// THRUSTMASTER / JOYSTICK TWO CONTROL OF TURRET
		if ( joy_hat==HAT_RIGHT )
		{
			turretRight=TRUE;
		}
		else
		if ( joy_hat==HAT_LEFT )
		{
			turretLeft=TRUE;
		}

		if ( (joy_hat==HAT_UP) || (joy_hat==HAT_DOWN) )
		{
			turretCentre=TRUE;
		}
	}



	/*-----------------08/01/96 18:14-------------------
	 rolling demo recording code
	--------------------------------------------------*/


	if ( !recordRollingDemo )
	{
		return ;
	}

	if ( clft )
	{
		rollDemoKeys |= TANKMLEFT;
	}
	if ( crgt )
	{
		rollDemoKeys |= TANKMRIGHT;
	}
	if ( cfwrd )
	{
		rollDemoKeys |= TANKMFORWARD;
	}
	if ( crvrs )
	{
		rollDemoKeys |= TANKMBACK;
	}

	fwrite(&rollDemoKeys, sizeof(short), 1, rollingDemoFile);
}


/********************************************************************/


void update_tilt()
{
	if (objhitcnt)
		objhitcnt--;
	tiltLev += tiltvel/12;

	if(tiltLev < 8)
		tiltLev = 8;
	else if(tiltLev > 255)
		tiltLev = 255;

	if(tiltLev > 136 && tiltvel > 0 && tiltvelvel >= 0)
		tiltvel -= tiltvel>>2;
	if(tiltLev < 136 && tiltvel < 0 && tiltvelvel <= 0)
		tiltvel -= tiltvel>>2;

	if (tiltLev < 136)
	{
		if (tiltvelvel < 3)
			tiltvelvel++;
	}
	else if (tiltLev > 136)
	{
		if (tiltvelvel > -3)
			tiltvelvel--;
	}

	tiltvel += tiltvelvel;
	if (tiltvel > 128)
		tiltvel = 128;
	else if (tiltvel < -128)
		tiltvel = -128;
}


/********************************************************************/


