#include "3Dglodef.h"

/****************************************************************************
 *					Draw Scaled Sprite Please!!!
 * INPUT IS.
 *   0. X1 coord
 *   1. Y1 coord
 *   2. X2 coord
 *   3. Y2 coord
 *   4. Sprite Number
 *   5. Shade Of Sprite
 *
 ****************************************************************************/
void	draw_scaled_spriteC( sint16 *inptr )
{
	sint32				x1,y1,x2,y2;
	sint32 				xdif;
	sint32				u,ustart,uadd;
	sint32				vstart,vadd,pixadd;
	unsigned	char	*pixptr,*dqptr;
	unsigned	char	*ssptr,*slptr;
	unsigned	char	pix;
	PHDSPRITESTRUCT		*dptr;


	x1 = (int)*(inptr);					// Get Top Left X
	y1 = (int)*(inptr+1);               // Get Top Left Y
	x2 = (int)*(inptr+2);               // Get Bottom Right X
	y2 = (int)*(inptr+3);               // Get Bottom Right Y

	if ( x2<=x1 || y2<=y1 ||
		 x2<=0 || y2<=0 ||
		 x1>=phd_winwidth || y1>=phd_winheight )
			return;

	dqptr = &depthq_table[(*(inptr+5))>>8][0];        // *(inptr+5) = DepthQ*8
	dptr = phdsprinfo + *(inptr+4);

	// Uadd = ((width<<16)-256) / (y2-y1);
	// Vadd = ((height<<16)-256) / (y2-y1);

	vadd = (int)((dptr->height<<8)/(y2-y1) );		  // Extract Width of Sprite
	uadd = (int)((dptr->width<<8)/(x2-x1) );          // Extract Height of Sprite
	ssptr = dptr->ptr;                                // Pointer to Sprite Data

	ustart = vstart = 0;
	if ( x1<0 )						// Clip On Screen Coordinates..
	{
		ustart = -uadd*x1;
		x1 = 0;
	}
	if ( y1<0 )
	{
		vstart = -vadd*y1;
		y1 = 0;
	}
	if ( x2>phd_winwidth )
		x2 = phd_winwidth;
	if ( y2>phd_winheight )
		y2 = phd_winheight;


	x2 -= x1;
	y2 -= y1;
	pixptr = phd_winptr + y1*phd_scrwidth + x1;
	pixadd = phd_scrwidth - x2;

/*	if ( (*(inptr+5)>>8)==16 )                           // If DepthQ
	{                                                    // Is At Middle
		for ( ;y2>0; y2-- )                              // We Dont need any
		{                                                // DepthQ look up..
			slptr = ssptr + ((vstart>>16)<<8);
			u = ustart;
			for ( xdif=x2; xdif>0; xdif-- )
			{
				if (  ( pix=*(slptr+(u>>16)) )  )
					*(pixptr) = pix;
				u += uadd;
				pixptr++;
			}
			pixptr += pixadd;
			vstart += vadd;
		}
	}
	else     */
	{
		for ( ;y2>0; y2-- )
		{
			slptr = ssptr + ((vstart>>16)<<8);           // Use DepthQ
			u = ustart;                                  // LookUp Draw....
			for ( xdif=x2; xdif>0; xdif-- )
			{
				if (  ( pix=*(slptr+(u>>16)) )  )
					*(pixptr) = *(dqptr + pix );
				u += uadd;
				pixptr++;
			}
			pixptr += pixadd;
			vstart += vadd;
		}
	}
}
