/*
 * This is the include file for the PC Shell.
 * By Dude, August 1995.  Do not change anything in this file, ever.
 * Or may the sky fall on your head.  Unless you fancy taking over
 * responsibility for the shell.  In which case go ahead, make my day.
 */

extern unsigned int totalMalloced;

#ifndef __SHELL_H
#define __SHELL_H

/*** defines ***/
#ifndef NULL
#define NULL ((void *)0)
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

//#define USE_STUPID_MALLOC

#define SETUP_FILE "hmiset.cfg"

#define NO_MIDI	0x00000001
#define NO_DIGI	0x00000002
#define NO_SOS		(NO_MIDI|NO_DIGI)
#define CD_ON		0x00000004
#define NO_JOYSTICK	0x00000008
#define NO_MOUSE	0x00000010

#define FILELOAD_IFPRESENT	0x00000001

#define MCGA_RAM ((void *)0xa0000)
#define TIMER_SPEED	1193180

#define BLACK	0x000000
#define BLUE	0x00003f
#define GREEN	0x003f00
#define YELLOW	0x003f3f
#define RED	0x3f0000
#define MAGENTA 0x3f003f
#define CYAN	0x3f3f00
#define WHITE	0x3f3f3f

#define CDERR_WRITEPROT	0x00
#define CDERR_UNKUNIT	0x01
#define CDERR_NOTREADY	0x02
#define CDERR_UNKCOM	0x03
#define CDERR_CRC		0x04
#define CDERR_BADREQLEN	0x05
#define CDERR_SEEK		0x06
#define CDERR_UNKMEDIA	0x07
#define CDERR_NOSECTOR	0x08
#define CDERR_PRINTER	0x09
#define CDERR_WRITE		0x0A
#define CDERR_READ		0x0B
#define CDERR_GEN		0x0C
#define CDERR_RESVD1	0x0D
#define CDERR_RESVD2	0x0E
#define CDERR_DISKCHNG	0x0F

#define CD_DOOROPEN		1
#define CD_DOORLOCKED	2
#define CD_COOKED		4
#define CD_READONLY		8
#define CD_DATAREAD		16
#define CD_INTERLEAVE	32
#define CD_RESERVED		64
#define CD_PREFETCH		128
#define CD_AUDIOMAN		256
#define CD_HSG			512

#define SIZE_KEYMAP 256	// 256 possible keys
#define SIZE_KEYBUF 64 	// room for 64 keys in the keyboard buffer

enum keys
	{
	K_ESC=0x01,			// 1
	K_1,            // 2
	K_2,            // 3
	K_3,            // 4
	K_4,            // 5
	K_5,            // 6
	K_6,            // 7
	K_7,            // 8
	K_8,            // 9
	K_9,            // 10

	K_0,            // 11
	K_MINUS,        // 12
	K_PLUS,         // 13
	K_BSP,          // 14
	K_TAB,          // 15
	K_Q,            // 16
	K_W,            // 17
	K_E,            // 18
	K_R,            // 19
	K_T,            // 10

	K_Y,						// 21
	K_U,            // 22
	K_I,            // 23
	K_O,            // 24
	K_P,            // 25
	K_OPENSB,       // 26
	K_CLOSESB,      // 27
	K_RET,          // 28
	K_LCTRL,        // 29
	K_A,            // 30

	K_S,						// 31
	K_D,            // 32
	K_F,            // 33
	K_G,            // 34
	K_H,            // 35
	K_J,            // 36
	K_K,            // 37
	K_L,            // 38
	K_COLON,        // 39
	K_APOST,        // 40

	K_APOST2,				// 41
	K_LSHIFT,       // 42
	K_BSLASH,       // 43
	K_Z,            // 44
	K_X,            // 45
	K_C,            // 46
	K_V,            // 47
	K_B,            // 48
	K_N,            // 49
	K_M,            // 50

	K_COMMA,				// 51
	K_DOT,          // 52
	K_SLASH,        // 53
	K_RSHIFT,       // 54
	K_NUMSTAR,      // 55
	K_LALT,         // 56
	K_SPACE,        // 57
	K_CAPS,         // 58
	K_F1,           // 59
	K_F2,           // 60

	K_F3,						// 61
	K_F4,           // 62
	K_F5,           // 63
	K_F6,           // 64
	K_F7,           // 65
	K_F8,           // 66
	K_F9,           // 67
	K_F10,          // 68
	K_NUMLOCK,      // 69
	K_SCRLOCK,      // 80

	K_NUM7,							// 81
	K_NUMHOME=K_NUM7,   // 82
	K_NUM8,             // 83
	K_NUMUP=K_NUM8,     // 84
	K_NUM9,             // 85
	K_NUMPGUP=K_NUM9,   // 86
	K_NUMMINUS,         // 87
	K_NUM4,             // 88
	K_NUMLEFT=K_NUM4,   // 89
	K_NUM5,             // 90

	K_NUM6,							// 91
	K_NUMRIGHT=K_NUM6,  // 92
	K_NUMPLUS,          // 93
	K_NUM1,             // 94
	K_NUMEND=K_NUM1,    // 95
	K_NUM2,             // 96
	K_NUMDOWN=K_NUM2,   // 97
	K_NUM3,             // 98
	K_NUMPGDN=K_NUM3,   // 99
	K_NUM0,             // 100

	K_NUMINS=K_NUM0,		// 101
	K_POINT,            // 102
	K_NUMDEL=K_POINT,   // 103
	K_SYSREQ,           // 104
	K_BSLASH2=0x56,     // 105
	K_F11,              // 106
	K_F12,              // 107
	K_NUMENTER=0x9c,    // 108
	K_RCTRL,            // 109
	K_NUMSHIFT=0xaa,    // 110

	K_NUMDIVIDE=0xb5,		// 111
	K_PRINTSCREEN=0xb7, // 112
	K_RALT,             // 113
	K_PAUSE=0xc5,       // 114
	K_BREAK,            // 115
	K_HOME,             // 116
	K_UP,               // 117
	K_PGUP,             // 118
	K_LEFT=0xcb,        // 119
	K_RIGHT=0xcd,       // 120

	K_END=0xcf,					// 121
	K_DOWN,             // 122
	K_PGDN,             // 123
	K_INSERT,           // 124
	K_DELETE,           // 125
	K_MACRO=0xef        // 126
	};




enum shell_errors
	{
	E_OK,
	E_READ,
	E_WRITE,
	E_MEMORY,
	E_DOSMEM,
	E_MAXERR
	};

enum
	{
	HAT_UP,
	HAT_RIGHT,
	HAT_DOWN,
	HAT_LEFT,
	HAT_CENTRE
	};

#define JOY_FIRE1 1
#define JOY_FIRE2 2
#define JOY_FIRE3 4
#define JOY_FIRE4 8

/*** typedefs ***/
typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long dword;
typedef int bool;

typedef void *SONG;		// an abstraction so you don't have to include sos.h

typedef struct
	{
	dword dwFlags;		// misc. flags
	byte szName[128];	// name of .ini file
	char *pData;		// pointer to .ini file in memory
	dword dwSize;		// size, in bytes, of file
	dword dwMaxSize;	// maximum size in bytes of the .ini
	char *pCurrent;	// current location in file
	dword dwCurrent;	// current location in file
	char *pSection;	// pointer to section start
	char *pItemPtr;	// pointer to the start of line w/item
	char *pItem;		// pointer to last item
	char *pList;		// pointer to last item location, for list management.
	char *pListPtr;	// pointer for raw string list
	}
	_INI_INSTANCE;

#pragma pack(1)
typedef struct
	{
	byte *pData;
	dword dwBytes;
	dword dwSamples;
	dword dwBytesPerSample;
	dword dwBitsPerSample;
	dword dwChannels;
	}
	SampleInfo;

typedef struct
	{
	byte Length;		/* Length in bytes of WHOLE request packet.*/
	byte SubUnit;		/* Sub unit code for minor devices (usually 0).*/
	byte CommandCode;	/* Command code for request type. */
	word Status;		/* Status returned by request */
						/* Bit 0-7 = error code if bit 15 set. */
						/* Bit 8 = Done. */
						/* Bit 9 = Busy. */
						/* Bit 10-14 = Reserved */
						/* Bit 15 = Error. */
	byte Resvd[8];		/* Reserved */
	}
	RQSTHDR;

typedef struct
	{
	RQSTHDR RHdr;		/* Device request header */
	byte MediaDesc;	/* Media descriptor */
	dword TransAddr;	/* Transfer address */
	short TransBytes;	/* Bytes to transfer */
	short StartSecTot;	/* Starting sector for whole volume (0) */
	dword VolIDPtr;		/* Ptr to volume id if error = 0FH */
	byte CtrlSubcode;	/* Subcommand for various IOCTL read types */
	byte TrackNum;		/* Track number to get info for. */
	dword TrackStart;	/* Track start point returned by MSCDEX */
	byte TrackCtrl;	/* Track control byte returned by MSCDEX */
	}
	TRACKINFRQ;

typedef struct
	{
	RQSTHDR RHdr;		/* Device request header */
	byte MediaDesc;	/* Media descriptor */
	dword TransAddr;	/* Transfer address */
	word TransBytes;	/* Bytes to transfer */
	word StartSecTot;	/* Starting sector for whole volume (0) */
	dword VolIDPtr;	/* Ptr to volume id if error = 0FH */
	byte CtrlSubcode;	/* Subcommand for various IOCTL read types */
	byte TrackLo;		/* returned Lowest track number on disk. */
	byte TrackHi;		/* returned Highest track number on disk. */
	dword LOutTrackStart;/* Start point of lead out track. */
	}
	AUDIOINFRQ;

typedef struct
	{
	RQSTHDR RHdr;		/* Device request header */
	byte MediaDesc;	/* Media descriptor */
	dword TransAddr;	/* Transfer address */
	word TransBytes;	/* Bytes to transfer */
	word StartSecTot;	/* Starting sector for whole volume (0) */
	dword VolIDPtr;	/* Ptr to volume id if error = 0FH */
	byte CtrlSubcode;	/* Subcommand for various IOCTL read types */
	byte ChangeByte;	/* returned byte showing change status. */
	}
	MEDCHGRQ;

typedef struct
	{
	RQSTHDR RHdr;		/* Device request header */
	byte AddrMode;		/* Addressing mode (0=HSG, 1=RED BOOK) */
	dword TransAddr;	/* Transfer address */
	word ReadSect;		/* Number of sectors to read */
	dword StartSect;	/* Starting sector to seek to */
	}
	SEEKRQ;

typedef struct
	{
	RQSTHDR RHdr;		/* Device request header */
	byte AddrMode;		/* Addressing mode (0=HSG, 1=RED BOOK) */
	dword StartSect;	/* Starting sector for play */
	dword PlaySect;	/* Number of sectors to play */
	}
	PLAYRQ;

typedef struct
	{
	RQSTHDR RHdr;		/* Device request header */
	}
	STOPRQ;

typedef struct
	{
	RQSTHDR RHdr;		/* Device request header */
	}
	RESUMERQ;

typedef struct
	{
	RQSTHDR RHdr;		/* Device request header */
	byte MediaDesc;	/* Media descriptor */
	dword TransAddr;	/* Transfer address */
	word TransBytes;	/* Bytes to transfer */
	word StartSecTot;	/* Starting sector for whole volume (0) */
	dword VolIDPtr;	/* Ptr to volume id if error = 0FH */
	byte CtrlSubcode;	/* Subcommand for various IOCTL read types */
	dword Info;		/* info status bits. */
	}
	DRVINFORQ;

typedef struct
	{
	RQSTHDR RHdr;		/* Device request header */
     byte MediaDesc;	/* Media descriptor */
	dword TransAddr;	/* Transfer address */
	word TransBytes;	/* Bytes to transfer */
	word StartSecTot;	/* Starting sector for whole volume (0) */
	dword VolIDPtr;	/* Ptr to volume id if error = 0FH */
	byte CtrlSubcode;	/* Subcommand for various IOCTL read types */
	byte QInfo[10];	/* Q channel info bytes. */
	}
	QCHANRQ;

typedef struct
	{
	byte keymap[SIZE_KEYMAP]; //keymap array, 0 = released, 1 = pressed
	byte keybuf[SIZE_KEYBUF];
	byte bufin;
	byte bufout;
	byte bufchars;
	byte extended;
	byte last_key;			// last key pressed
	byte keys_held;		// number of keys currently held down
	}
	KEYSTUFF;

typedef struct
	{
	dword old_pmoff;
	word old_pmseg;
	dword clock;			// big clock counter, 60hz
	word vbl_count;		// no. of vbls since last sync()
	word timer;			// reset timer to this at end of interrupt
	word vbl_overflow;		// wait for vbl overflow counter
	word vbl_max;			// normal wait for vbl count
	byte palette[256*3];	// current palette
	byte temp_pal[256*3];	// temp palette store
	void *pal_ptr;			// ptr to palette to fade to
	dword fade_cnt;		// fade count = 256-0 << 8
	dword fade_dec;		// 256/60 << 8 = fade in 1 sec
	byte fade_flag;
	byte pal_flag;
	}
	TODSTUFF;

typedef struct
	{
	byte ctrl_break;
	}
	BRKSTUFF;

typedef struct
	{
	byte crit_err; 			// value returned by critical error handler
	}
	CRITSTUFF;

typedef struct
	{
	short	sc_width,sc_height;
	short	mx_sense,my_sense,ms_dthresh;
	void		*scrn_ptr;
	short	col_mode;
	short	dump_x,dump_y,dump_width,dump_height;
	}
	SETUP;
#pragma pack()

/*** Global variables ***/

extern int file_len;
extern volatile TODSTUFF toddata;
extern volatile KEYSTUFF *keydata;
extern volatile BRKSTUFF *brkdata;
extern volatile CRITSTUFF *critdata;
extern SETUP *gamedata;
extern int cd_tracks,last_track;
extern void (*int_func)(void);	// pointer to user interrupt function
extern short mbut;
extern short mx;
extern short my;
extern short mickey_x;
extern short mickey_y;
extern short mbuttons;
extern int joy1_x;				// values from -32 to 31
extern int joy1_y;
extern byte joy_fire;
extern int joy_hat,joy_throttle;
extern bool joy_knackered,joy_found;
extern int digi_inst,midi_inst,sfx_on,music_on;
extern char txt_col;			// draw colour for text
extern byte *txt_screen;
extern volatile dword GdwClock;	// incremented 60 times per second
extern dword GdwOldClock;		// used by Sync()
extern word bank_cnt;			// something to do with SVGA
extern char *GpSetupFilePath;	// Path for sound setup file

/*** macros ***/
#define ifkey(k) if (keydata->keymap[k])
#define ifnotkey(k) if (keydata->keymap[k]==0)
#define rawkey(k) (keydata->keymap[k])
#define whilenotkey(k) while (keydata->keymap[k]==0)
#define whilenokey while (keydata->keys_held==0)

#define SoundIsDIGIInstalled() (digi_inst)
#define SoundIsMIDIInstalled() (midi_inst)
#define SoundIsDIGIEnabled() (sfx_on)
#define SoundIsMIDIEnabled() (music_on)
#define SoundDIGIEnable(t_or_f) (sfx_on=t_or_f)
#define SoundMIDIEnable(t_or_f) (music_on=t_or_f)
#define SoundSetSetupPath(path) GpSetupFilePath=path

// align macro. size is a power of two, or 'edbutt.
#define align(thing,size) (((thing)+(size)-1)&(~((size)-1)))

#define makefourcc(b0,b1,b2,b3) (((dword)b0)|(((dword)b1)<<8)|(((dword)b2)<<16)|(((dword)b3)<<24))
#define checkfourcc(p,b0,b1,b2,b3) (*((dword *)p)==makefourcc(b0,b1,b2,b3))

#define RGB(r,g,b) ((((r>>2)&63)<<16)|(((g>>2)&63)<<8)|((b>>2)&63))

#define arraysize(array) (sizeof(array)/sizeof(array[0]))

/*** Prototypes ***/

// init & exit
void ShellInit(SETUP *pSetup,dword dwFlags);
void ShellExit(char *szFormat,...);
void ShellExitErrno(char *szFormat,...);
void ShellExitMemErr(void);
#pragma aux ShellExit aborts;
#pragma aux ShellExitErrno aborts;
#pragma aux ShellExitMemErr aborts;

// files
void *FileLoad(char *szName,void *pWhere,dword dwFlags);
void FileSave(char *szName,void *pWhere,dword dwBytes);
dword FileSize(char *szName);

// video
void FadeToPal(dword dwCount,byte *pPal);
void FadeWait(void);
int SwitchVideoMode(SETUP *pSetup);
void ScreenClear(void);
void ScreenPartialClear(void);
void ScreenDump(void);
void ScreenPartialDump(void);
void ScreenDumpAndClear(void);
void ScreenWaitVbl(void);
void PalSetBorder(dword dwColour);
void PalInsertColours(byte *pPal,int nOffset,int nCount);
#pragma aux PalInsertColours parm [esi][eax][ecx] modify [edx];
void VesaSetBank(int bank);

// keyboard
int KeyGet(void);
void KeyClearBuffer(void);

// mouse
word MouseInit(void);
void MouseRead(void);

// joystick
void JoyDetect(void);
void JoySetCentre(void);
void JoyRead(void);

// CD
int CDPlay(dword dwTrack);
int CDPlayPart(dword dwTrack,dword dwOffset,dword dwLen);
void CDStop(void);
void CDResume(void);
void CDLoop(void);

dword CDRequest(RQSTHDR *pHeader,int nSize);
dword CDStatus(void);
dword CDRedAddr(dword dwPosition);
dword CDPosition(void);

// memory
void *MemAllocReal(dword dwSize);
void MemFreeReal(void *pMem);

// printing
void PrintText(char *string,int xpos,int ypos);
#pragma aux PrintText parm [esi][eax][ebx] modify exact [];
void Print(int xpos,int ypos,char *format,...);

// sound
SONG SoundLoadSong(char *szName,dword *phSong);
void SoundFreeSong(SONG pSSong,dword hSong);
void SoundLoadSamples(char **apName,int nSamples);
void SoundFreeSamples(void);
dword SoundPlaySample(dword dwSample,word wVol,word wPitch,word wPan);
dword SoundPlaySampleLooped(dword dwSample,word dwVol,word wPitch,word dwPan,dword dwCount,dword dwOffset,dword dwLength);
void SoundStopAllSamples(void);
void SoundStopSample(dword handle);
void SoundSetPitch(dword handle,word pitch);
dword SoundPauseSample(dword handle);
void SoundUnpauseSample(dword handle,dword dwOldRate);
void SoundSetMasterVolume(word vol);
void SoundSetPan(dword handle,word wPan);
void SoundWaitSample(dword handle);
bool SoundSampleIsPlaying(dword handle);
dword SoundSamplePosition(dword handle);
bool SoundGetSampleInfo(dword dwSample,SampleInfo *pSInfo);
int SoundPlaySong(dword handle);
void SoundStopSong(dword handle);
int SoundFadeInSong(dword handle,int nSecs);
void SoundFadeOutSong(dword handle,int nSecs);
void SoundWaitSong(dword handle);
bool SoundSongIsPlaying(dword handle);
void SoundPauseSong(dword handle);
void SoundUnpauseSong(dword handle);
void SoundSetSongTempo(dword handle,dword dwPercent);
void SoundSetSongVolume(dword handle,word wVolume);
void SoundStreamUpdate(dword handle);
dword SoundGetSOSHandle(void);

// interrupts etc
dword Sync(void);
#pragma aux Sync=\
"		mov	eax,[GdwClock]		"\
"		mov	ebx,[GdwOldClock]	"\
"		mov	[GdwOldClock],eax	"\
"		sub	eax,ebx			"\
	value [eax]	\
	modify [ebx];

// .INI file handling. Used by sound stuff. Should be useful for game settings etc.
bool IniOpen              (_INI_INSTANCE *sInstance,char *szName);
bool IniClose             (_INI_INSTANCE *sInstance);
bool IniLocateSection     (_INI_INSTANCE *sInstance,char *szName);
bool IniLocateItem        (_INI_INSTANCE *sInstance,char *szItem);
bool IniGetDecimal        (_INI_INSTANCE *sInstance,dword *wValue);
bool IniGetString         (_INI_INSTANCE *sInstance,char *pString,dword wMaxLength);
bool IniWriteDecimal      (_INI_INSTANCE *sInstance,dword wValue);
bool IniWriteString       (_INI_INSTANCE *sInstance,char *szString);
bool IniDeleteItem        (_INI_INSTANCE *sInstance,char *szItem);
bool IniDeleteSection     (_INI_INSTANCE *sInstance,char *szSection);
bool IniGetRawString      (_INI_INSTANCE *sInstance,char *pString,dword wMaxLength);
bool IniGetItemDecimal    (_INI_INSTANCE *sInstance,char *szItem,dword *wValue);
bool IniGetItemString     (_INI_INSTANCE *sInstance,
		    				char *szItem,
		    				char *pString,
	    					dword wMaxSize);
bool IniAddItemDecimal    (_INI_INSTANCE *sInstance,
						char *szItem,
						dword wValue,
						dword wJustify,
						dword wRadix);
bool IniAddItemString     (_INI_INSTANCE *sInstance,char *szItem,char *szString,dword wJustify);
bool IniAddSection        (_INI_INSTANCE *sInstance,char *szSection);
bool IniGetQuery          (_INI_INSTANCE *sInstance,char *szItem);
bool IniWriteQuery        (_INI_INSTANCE *sInstance,char *szItem,bool wState);

#ifndef NOOLDNAMES
/*** old names for shell routines ***/
#define load_file(name,where) FileLoad(name,where,0)
#define save_file FileSave

#define getout ShellExit
#define setup ShellInit

#define fade_to_pal FadeToPal
#define wait_fade FadeWait
#define switch_vmode SwitchVideoMode

#define get_key KeyGet
#define clear_keyb KeyClearBuffer

#define init_mouse MouseInit
#define read_mouse MouseRead

#define read_joy JoyRead

#define get_dosmem MemRealAlloc
#define free_dosmem MemRealFree
#ifdef USE_STUPID_MALLOC
#define malloc MemAllocDebug
#define free MemFreeDebug
#endif
#define get_mem(a) malloc(a);totalMalloced+=a;debug_msg("allocated %d bytes\n",a)
#define free_mem free

#define get_display VgaGetMode
#define set_display VgaSetMode
#define clr_screen ScreenClear
#define clr_part_screen ScreenPartialClear
#define dump_screen ScreenDump
#define dump_part_screen ScreenPartialDump
#define dumpclr_screen ScreenDumpAndClear
#define wait_vbl ScreenWaitVbl
#define setcol PalSetBorder
#define dump_pal PalInsertColours

#define print_text PrintText
#define print Print

#define init_cdsys CDInit
#define free_cdsys CDFree
#define play_track CDPlay
#define stop_track CDStop
#define resume_track CDResume
#define loop_track CDLoop
#define play_parttrack CDPlayPart
#define send_request CDRequest
#define drv_status CDStatus
#define drv_error CDError
#define red_addr CDRedAddr

// call_dpmi taken out.
// digi & midi stuff have changed a lot.

#define read_timer TimerRead
#define sync Sync
#endif

/*** various stuff ***/
void Trap(void);
#pragma aux Trap="int 3" modify exact [];

#endif //__SHELL_H
