/*-----------------09/07/95 15:46-------------------
	This file contains all the structure definitions
	enumerated types, and type definitions used in
 	shellshock.
--------------------------------------------------*/
/*-----------------15/11/95 14:30-------------------
 Final version altered for network.
 (Urrrgh... Dave Muir's been messin' with it)
--------------------------------------------------*/

#ifndef SHELLSHOCK_STRUCTURES
#define SHELLSHOCK_STRUCTURES

#define DEBUG_VERSION

#include "typedefs.h"





#define 	PC_VERSION

#define 	LINE_OF_SIGHT_BITMAP_BYTES_ACROSS 	32
#define 	LINE_OF_SIGHT_BITMAP_BYTES_DOWN			256
#define 	LINE_OF_SIGHT_BITMAP_SIZE						32*256
#define 	LINE_OF_SIGHT_BITMAP_BYTES_SHIFT		5

#define 	set_los_bit(x,y) (*(los_map+(y<<LINE_OF_SIGHT_BITMAP_BYTES_SHIFT)+(x>>3))|=bitSetTable[x&7])
#define 	test_los_bit(x,y) (*(los_map+(y<<LINE_OF_SIGHT_BITMAP_BYTES_SHIFT)+(x>>3)) & bitSetTable[x&7])
#define 	reset_los_bit(x,y) (*(los_map+(y<<LINE_OF_SIGHT_BITMAP_BYTES_SHIFT)+(x>>3))&=bitResetTable[x&7])

#define 	set_qdt_bit(x,y) (*(qdt_map+(y<<LINE_OF_SIGHT_BITMAP_BYTES_SHIFT)+(x>>3))|=bitSetTable[x&7])
#define 	test_qdt_bit(x,y) (*(qdt_map+(y<<LINE_OF_SIGHT_BITMAP_BYTES_SHIFT)+(x>>3)) & bitSetTable[x&7])
#define 	reset_qdt_bit(x,y) (*(qdt_map+(y<<LINE_OF_SIGHT_BITMAP_BYTES_SHIFT)+(x>>3))&=bitResetTable[x&7])


#define FADEPOINT								200

#define SCREEN_BUFFER_SIZE			(132*320)

#define MAYBE										2
#define ONE_2_ONE_SPRITE				0X10000


#define	NO_POINTS								0XFFFF		/* Used in the z indexing to indicate there are no walls in that z range */
#define TANK_WIDTH							0x100			/* Half the tank width and length for collision detection */
#define TANK_LENGTH							0x100


#ifdef PC_VERSION
#define Z_CLIP_DEPTH						612				/* Depth at which walls are no longer drawn (behind the view area) (-300) */
#else
#define Z_CLIP_DEPTH						700
#endif


#define SCREEN_HORIZON_LEVEL	64

#define	MAX_SONG_TRACKS				6


#ifdef PC_VERSION
#define SOUND_CENTRE					0X8000
#define SOUND_ORIGINAL_PITCH	50
#define SOUND_NORMAL_VOLUME		0X4000
#define SOUND_V_QUIET					0x800
#define SOUND_QUIET						0X1000
#define SOUND_LOUD						0X7000
#define SOUND_V_LOUD					0x7fff
#define SOUND_FOREVER					-1
#define SOUND_FROM_START			0
#define SOUND_FULL_LENGTH			1
#define set_actual_volume(a) ((a*optionSettings[SOUND_VOLUME_OPTION])>>6)
#endif

#define CHAIN_GUN_TOO_HOT					63

#define OBJECTIVE_BUILDING_TAG	(1<<15)
#define TREE_TAG								(1<<14)
#define HITVALUE_MASK						(~(OBJECTIVE_BUILDING_TAG|TREE_TAG))
#define is_objective_building(a) (wallHitList[a]&OBJECTIVE_BUILDING_TAG)
#define is_tree_texture(a) 			(wallHitList[a]&TREE_TAG)

#define	PITCH_FORWARD						7
#define NO_PITCH								4
#define PITCH_BACK							0


#define	NSCR_WIDTH							320 /* Width of the screen */

#define HORIZON_Y_POS						80	/* Y pos on screen of the start of the flooe */
#define VIEWPORT_TOP						16	/* Y pos on screen of the top of the scene */


#define ARMOUR_OK_COLOUR				238
#define ARMOUR_FUCKED_COLOUR		248


#define HELICOPTER_DETECT_HEIGHT	6

#define TANK_VIEW_HEIGHT				-208/* View height */
#define MID_TANK_HEIGHT					-104
#define FLOOR_LEVEL							104


#define VIDEO_SEQUENCE_FRAMES		6
#define MAX_ATTACKING_TANKS			12

#define MAX_CONVOYS							3
#define MAX_CONVOY_MEMBERS			12

#define MAX_DRAW_FLAGS					4
#define MAX_REGENERATIONS				10

#define POINT_RESET_BLOCK_SIZE	32	/* Size of point checklist to reset on every gameloop */
#define MAXIMUM_TOP_SPEED				0Xa7c	/* Highest possible speed a tank can go at */

#define	HELICOPTER_ALTITUDE 		-900

#define	RADAR_SCALE_SHIFT				24	/* The sacling factor used to draw the radar display */
#define RADAR_SIZE							56	/* Size of radar map box */

#define MAX_ENEMY_TANKS					34
#define MAX_GUN_EMPLS						10
#define MAX_GUN_BOATS						10
#define MAX_HELICOPTERS					10
#define MAX_HOSTAGES						16
#define MAX_CONVOY_BOATS				6

#define MAX_ASMS								10

#ifndef PC_VERSION
#define DRAW_LIST_SIZE          512     /* Number of elements that can be put into the draw list */
#endif

#define MAX_FRAGMENTS						128	/* The number of fragment slots available */
#define MAX_PLAYER_SHELLS				8		/* Number of shells the player can have fired at any one time */

#define MAX_CPU_SHELLS					64

#ifdef	PC_VERSION
extern 	int MAX_ENEMY_SHELLS;				/* Total number of shells that can by fired by ALL the tanks at any given time */
#else
#define MAX_ENEMY_SHELLS				64
#endif



#define MAX_SAMS								4
#define MAX_DELAYED_FX_SLOTS		32	/* Total number of delayed fx groups available at any one time */
#define MAX_DELAY_FX						4		/* Maximum number of delayed fx per delayed fx group */
#define MAX_FX_SPRITES					128	/* The number of fx sprites available -  */
/*If you REALLY MUST change MAX_FX_SPRITES remember to change corresponding equate in sprorgs.asm */

#define ROTATING_OBJECT_TAG			64	/* Sprite objects labelled over 512 are rotating objects */
#define FX_SPRITE_TAG						256	/* Fx sprites such as explosions and smoke */
#define BULLET_TAG							1019/* Signifying a bullet */
#define WALL_TAG								1020/* Signifying a wall */
#define WALL_INSERT_TAG					0x0ff00

#define PLAYER_SHELL_DELAY			50 	/* Number of frames before you can fire another shell */
#define ETANK_SHELL_DELAY				60
#define BTANK_SHELL_DELAY				70
#define	AFV_SHELL_DELAY					45
#define APC_SHELL_DELAY

#define TOTALLED_TEXTURE				0xffff	/* texture number indicating that you don't need to draw the texture */
#define TOTALLY_TOTALLED_WALL		5		/* Detection tag signifying wall can be ignored */

#define VERY_LARGE_SPRITE				0
#define LARGE_SPRITE						1
#define MEDIUM_SPRITE						2
#define SMALL_SPRITE						3

#define TRANSPARENT_SPRITE			1
#define FLIPPED_SPRITE					2

#define MAX_OPTION_ITEMS				7



enum { 	FAR_EXPLOSION=0,
				NEAR_EXPLOSION,
				HELI_GUN1,
				HELI_ROTOR_BLADES,
				PLYR_CANNON,
				PLYR_NRG_WARNING,
				PLYR_RELOAD_SHELL,
				PLYR_CHAIN_GUN,
				PLYR_HIT_SND1,
				PLYR_HIT_SND2,
				PLYR_HIT_SND3,
				PLYR_HIT_SND4,
				PLYR_THR_FENCE,
				PLYR_ENGN,
				ENEM_CHAINGUN_FIRE,
				COLLECTABLE_SOUND,
				SAM_LAUNCH_SOUND,

				DT_SPCH1,
				DT_SPCH2,
				DT_SPCH3,
				DT_SPCH4,
				DT_SPCH5,
				DT_SPCH6,
				DT_SPCH7,
				DT_SPCH8,

				ERSHOT_SPCH1,
				ERSHOT_SPCH2,
				ERSHOT_SPCH3,
				ERSHOT_SPCH4,

				DG_SPCH1,
				DG_SPCH2,

				NINE_SPCH1,
				NINE_SPCH2,

				TURRET_MOVE_SOUND,
				TURRET_LOCKED_SOUND,

				ERSHOT_SPCH5,

				MAX_SOUND_FX };




/** different ways of ending the game **/

enum { ENDGAME_COMPLETED, ENDGAME_QUIT, ENDGAME_KILLED, ENDGAME_AWOL, ENDGAME_DROWNED, ENDGAME_FUCKDUP };

/** colour constants */

/** normal ingame colours */
enum { 	P_GREY = 240, P_YELLOW, P_PURPLE, P_GREEN1, P_DGREEN2, P_GREEN4,
				P_GREEN6, P_AMBER, P_RED3, P_RED2, P_RED1, P_GREEN7, P_GREEN5, P_GREEN3,
				P_BLACK, P_WHITE };


/** tactical map colours */
enum { T_RED=192, T_GREEN, T_BLUE, T_YELLOW, T_PURPLE, T_CYAN, T_BLACK, T_WHITE,
			 T_DRED, T_DGREEN, T_DBLUE, T_ORANGE, T_GREY1, T_GREY2, T_GREY3, T_DPURPLE };

#define T_GRAD_RED					208
#define T_GRAD_GREEN				216
#define T_GRAD_BLUE					224
#define T_GRAD_WHITE				232
#define T_GRAD_YELLOW				240
#define T_GRAD_PURPLE				248


#define COCKPIT_RED					248
#define COCKPIT_GREEN				246
#define COCKPIT_WHITE				239
#define COCKPIT_BLACK				243
#define COCKPIT_YELLOW			241
#define COCKPIT_PURPLE			242
#define COCKPIT_GREY				240
#define COCKPIT_BROWN				249

enum { T_SHADE_0=0, T_SHADE_1, T_SHADE_2, T_SHADE_3, T_SHADE_4, T_SHADE_5, T_SHADE_6, T_SHADE_7 };

#define ENEMY_TANK_COLR			T_RED
#define ENEMY_HELI_COLR			T_RED
#define ENEMY_GUNEMPL_COLR	T_GREEN
#define ENEMY_GUNBOAT_COLR	T_RED
#define HOSTAGE_COLR				(T_GRAD_WHITE+T_SHADE_5)

#define SHELL_COLR					T_YELLOW

#define MAP_GRID_COLR				T_GREY1

#define PLAYER_TANK_COLR		T_WHITE



/** Menu option constants */

enum { 	ON_OFF, SLIDER_TYPE, NUMBER_TYPE };


enum { 	SOUND_OPTION, MUSIC_OPTION, SOUND_VOLUME_OPTION,
				MUSIC_TRK_OPTION, SATURATION_OPTION, VALUE_OPTION,
				QUIT_MENU_OPTION };

enum { 	QUIT_REQUEST_MESSAGE = 0,			/* Menu option text messages */
				OPTION_HEADING,
				SOUND_ONOFF,
				MUSIC_ONOFF,
				SOUND_VOLUME_TXT,
				MUSIC_TRACK_OPTION,
				COLOUR_SATURATION_OPTION,
				COLOUR_VALUE_OPTION,
				OPTION_QUIT_TEXT,
				MAX_MENU_TXT_MESSAGES };

enum { 	AWOL_WARNING_TXT=0,  					/* In game text messages */
				RENDEZVOUS_MSG_TXT,
				OBJECTIVE_HEADING_TXT,
				DESTROY_HOSTILES_TXT,
				TARGETS_LEFT_TXT,
				DESTROY_COMPOUNDS_TXT1,
				HOSTAGE_RESCUE_TXT,
				HOSTAGEES_LEFT_TXT,
				DESTROY_CONVOY_TXT,
				PROTECT_CONVOY_TXT,
				MAX_INGAME_MESSAGES };


enum { 	NINE_TXT1, 		NINE_TXT2, 		NINE_TXT3, 		NINE_TXT4,		/* character in game text */

				DTOUR_TXT1, 	DTOUR_TXT2, 	DTOUR_TXT3, 	DTOUR_TXT4,
				DTOUR_TXT5, 	DTOUR_TXT6, 	DTOUR_TXT7, 	DTOUR_TXT8,

				EAR_TXT1, 		EAR_TXT2, 		EAR_TXT3, 		EAR_TXT4, 		EAR_TXT5,

				DOG_TXT1, 		DOG_TXT2,

				MAX_CHARACTER_MESSAGES };


enum { 	NINE_SEQUENCE, DOGTAG_SEQUENCE, EARSHOT_SEQUENCE };


enum { 	NINE_MSG1, NINE_MSG2, NINE_MSG3, NINE_MSG4,							/* character in game messages */

				DTOUR_MSG1, DTOUR_MSG2, DTOUR_MSG3, DTOUR_MSG4,
				DTOUR_MSG5, DTOUR_MSG6, DTOUR_MSG7, DTOUR_MSG8,


				EAR_MSG1, EAR_MSG2, EAR_MSG3, EAR_MSG4, EAR_MSG5,

				DOG_MSG1, DOG_MSG2  };


enum { 	LOW_PRIORITY, MEDIUM_PRIORITY, HIGH_PRIORITY };


enum { RETURN_2_NORMAL=1, BRIGHT_FLASH, VBRIGHT_FLASH };

enum { NO_MESSAGE=0, AWOL_MESSAGE, RENDEZVOUS_MESSAGE, MAX_MAIN_MESSAGES };

enum { IGNORE_POSSIBLE_COLLISION_FLAG = 0, CHECK_POSSIBLE_COLLISION_FLAG };

enum { HOSTAGE_STANDING_ANIM, HOSTAGE_RUN_ANIM };

enum { DESTROY_ALL_ENEMIES_OBJECTIVE, DESTROY_BUILDINGS_OBJECTIVE,
			 DESTROY_CONVOY_OBJECTIVE, PROTECT_CONVOY_OBJECTIVE, RESCUE_HOSTAGE_OBJECTIVE };

enum CONVOY_TYPES { TRUCK_CONVOY, GUNBOAT_CONVOY };


enum ROTATING_OBJECTS {	SHELL=0,
												PLAYER_TANK,
												ENEMY_TANK,
											 	BATTLE_TANK,
												AMOURED_FIGHTER,
											 	ENEMY_APC,
											 	ENEMY_GUNBOAT,
												E_GUNEMPL,
											 	ALLIED_TRUCK,
												ENEMY_TRUCK,
											 	HOSTAGE_1,
												HOSTAGE_2,
											 	E_HELICOPTER,
												E_GUNSHIP,
												NETWORK_TANK,
											 	P_HELICOPTER,
												P_PLANE,
												MAX_ROTATING_OBJECTS,
												SAMS,
												ASMS,
												MAX_3D_OBJECTS,
												REGENERATE_OBJECT };



enum EXPLOSIONS { TANK_EXPLOSION, WALL_EXPLOSION, AIR_EXPLOSION, SHELL_EXPLOSION, SHELL_GROUND_EXPLOSION, GUN_EMPLACEMENT_EXPLOSION, SHELL_HIT_EXPLOSION, HELI_EXPLOSION,
									GUNBOAT_EXPLOSION };



enum pitch_mode {		STANDING_START=0,
										STANDING_MOVE_OFF,
										STANDING_LEVEL_OFF,
										MOVING_LEVEL,
										BRAKING_BACK,
										BRAKING_FRWD };


enum FX_GROUPS { D_TANK1_GROUP, D_SMALL_BUILDING_GROUP , D_HELI_GROUP, D_GUNBOAT_GROUP, MAX_FX_GROUPS };

enum FX_TYPES { SMALL_GROUND_EXP, LARGE_TRAN_GROUND_EXP, SMALL_AIRBURST_EXP,
								SMALL_AIRFRAG_BURST, MUSHROOM_CLOUD, SMOKE_BALL, LARGE_TRAN_AIR_EXP, LARGE_WATER_EXP };


enum SIZE_TYPES { PLAYER_TANK_SIZE , ENEMY_TANK_SIZE };


enum { VIDEO_MESSAGE, SPEECH_ONLY_MESSAGE, TEXT_ONLY_MESSAGE };




/*
 * Storage for control keys
 */

enum	movement_type  { normal_control=0, tank_control, joy_control };

enum  PANEL_SPRITES { PANEL_TOP_BAR=0, PANEL_BOTTOM, COMPASS_DISPLAY, RADAR_RINGS, RADAR_SURROUNDS, DISPLAY_TARGET1, SPEEDO_DIAL,
											MAIN_GUN_READOUT, CHAINGUN_READOUT, SAM_READOUT, HELI_AIRSTRIKE, PLANE_AIRSTRIKE,
											ARMOUR_UNIT, TAC_MAP_SOLID_OVL=21, TAC_MAP_SCREEN, OBJECTIVE_IND_LEFT=26, OBJECTIVE_IND_RIGHT, OBJECT_IND_PIN_PT };


enum	DRAW_FLAGS { DRAW_WEAPONS_DISPLAY, DRAW_SHEILDS, DRAW_MINE_INDICATOR, DRAW_MESSAGE_BOX };




enum	PRINT_STYLE {MULTICOLOURED_PRINT, SINGLE_COLOURED_PRINT, TRANSPARENT_PRINT};



enum	OBJECT_SIDES { OBJ_FRONT, OBJ_RIGHT, OBJ_BACK, OBJ_LEFT };						/* Tag numbers for identifying sides of tank - used in collisions */
enum	COLLISION_ACTIONS { C_NO_ACTION=0, C_REDUCE_SPEED, C_ALLIGN_TANK, C_STOP_DEAD, C_ROTATEABLE, C_MOVEMENT_ONLY }; /* Different possibilities for outcome of collision */



/* Enemy tank control types */


/* Stationary tank modes */
enum { ESTAT_INACTIVE, ESTAT_ROTATE, ESTAT_BECOME_INACTIVE };

/* Pursue tank modes */
enum { EPURSUE_MOVE_2_POINT, EPURSUE_DECISION, SWING_2_TARGET_POINT, ROTATE_2_TARGET_POINT };

enum { REACHED_TARGET, SLOW_DOWN, CONTINUE_MOVEMENT };


/*Truck path/convoy modes */
enum { START_CONVOY, START_CONVOY_ROTATE };
enum { FOLLOW_CONVOY_PATH, CONVOY_SWING_2_TARGET_POINT, CONVOY_ROTATE_2_TARGET_POINT };

/*Hostage modes*/
enum {HOSTAGE_STANDING, HOSTAGE_RUNNING, HOSTAGE_WINGEING, HOSTAGE_DYING, HOSTAGE_DEADED};


/* Turn command decisions */
enum { NO_TURN, LARGE_LEFT_TURN, SMALL_LEFT_TURN, LARGE_RIGHT_TURN, SMALL_RIGHT_TURN};


/* Enemy intelligence */
enum { QUITE_DIM, SMART };

/* Dummy id for null waypoints */
#define NULL_ID		0xffff




/* Structure type definitions */
typedef struct kokpit_message
{
	ushort	msgType;									/* Video/speech/text */
	ushort	videoSequence;						/* The video sequence to play */
	ushort	speechSequence;						/* The speech sequence to play */
	ushort	priority;									/* Priority of message */
	ushort	speechPitch;
	ushort	messageText;							/* The character speech 'text' to be displayed */
}KOKPIT_MESSAGE;



typedef struct											/* Normal control key structure */
{
	uint	pan_left;
	uint	pan_right;
	uint	acclr;
	uint	declr;
} MOVEMENT_A;



typedef struct                    	/* Battle zone key structure */
{
	uint	left_track_forward;
	uint	right_track_forward;
	uint	left_track_back;
	uint	right_track_back;
} MOVEMENT_B;



typedef union
{
	MOVEMENT_A	normal_ctrl;
	MOVEMENT_B	tank_ctrl;
} M_TYPE;



typedef	struct
{
	uint			mType;									/* Type of control being used */
	M_TYPE  	movement;								/* The movement keys */
	uint			fire;                   /* Key for firing shells */
	uint			select;									/* Key for weapon select */
	uint		  target;									/* Key for targeting enemy */
	uint			tactical;								/* Key for tactical display */

	uint			tleft;  								/* Key for turret left */
	uint			tright;									/* Key for turret right */
	uint			tcentre;								/* Key for centring the turret */

} CONTROL_INPUT;




typedef struct enemy_tank_ctrl
{
	void		(*control_func)(void);
	struct	tank	*targetTank;
	ushort	tank_mode;
	ushort	last_waypoint;
	ushort	rejoin_waypoint;
	ushort	target_waypoint;
	ushort	next_target_waypoint;
	ushort	slow_decision_made;
	ushort	twayptx;
	ushort	twayptz;
	ushort	iq;
	ushort 	angle_2_target;
	ushort	small_turn_count;
	ushort	regenerate;
	ushort	restricted;
	ushort	pathUsed;
	ushort	rx1, rz1, rx2, rz2;
	ushort	stillCount;
	ushort	stillx;
	ushort	stillz;
	ushort	regenerateId, regenx, regenz, regenAng, regenCount;
	ushort	convoyLeader;
}ENEMY_TANK_CTRL;


#define MAX_DETECT_WALLS			16
#define MAX_DETECT_OBJECTS	  8
#define MAX_DETECT_GUNEMPLS		4

typedef struct attacking_tank_data		/* To speed up enemy collision detection - */
{																			/* Keep a record of the walls that the tank might hit on the first pass */
	ushort	slotUsed;										/* And only detect against them on the second pass */
	ushort	numWalls;										/* Number of walls that tank may hav collided with */
	ushort	numObjs;										/* Number of objects that tank may hav collided with */
	ushort	numGunempls;
	ushort	walls[MAX_DETECT_WALLS]; 		/* List of walls that tank may have collided with */
	ushort	objs[MAX_DETECT_OBJECTS];		/* List of objects that tank may have collided with */
	ushort	gunempls[MAX_DETECT_GUNEMPLS];
}ATTACKING_TANK_DATA;



/*
 * Tank characteristics
 */



typedef	struct tank
{

	uint 		x;               		      /* Actual position of tank : X, */
	int		 	y;	 									    /* Y, */
	uint 		z;	 									  	/* Z. */
	uint		angle;						      	/* direction tank is trying to go in (view direction) */
	/*ABOVE 16 bytes= TANK HEADER for NETWORK*/

	uint		dir; 							       /* Actual direction of tank */
	uint		oldx;
	uint		oldz;

	uint 		def;								      /* Sprite definition number */
	int			yvel;



/* Shunt variables - when a tank gets hit by a shell */
	uint		shuntDir;  								/* Direction the shell was going in plus a random factor */
	int			shuntSpeed;								/* The Magnitude of the shunt */

/* Sound handle */
	uint		soundHandle;							/* Handle for helicopter rotor sound fx */

/* Tank performance statistics */
	int			spin_cnt;									/* Spin count. */
	int			spin_delay;     					/* Accelration to full spin (spin_cnt). */

	int			turn;								      /* Turning factor */
	int			speed;							      /* Tank engine speed */
	int			pre_accel;							  /* From stand still to speed = top_speed / 4 */
	int			accelr;							      /* Tank acceleration rate. */
	int			accelc;							      /* Tank acceleration constant. */
	int			maxturn;			 				    /* Maximum turning rate of tank */
	int			top_speed;
	int			top_brake;
	uint		trak_grip;					      /* The grip provided by the current tracks */

/* To do with speeding up collision detection */
	uint		sqrObjDetval;							/* size of the tank squared - */
	uint		sqrWallDetval;
	ATTACKING_TANK_DATA *collData;		/* To speed up collision detection */


	ENEMY_TANK_CTRL	*ectrl;						/* Enemy control logic data pointer */

/* Tank weapon information */
	uint		shellFired; 						  /* Used to restrict rate of shell fire */
	uint		shellDelayCount;
	uint		cWeapon; 									/* Current weapon tank is using */
	int 		shellRange; 						  /* How far the shells will be fired */
	int 		shellSpeed; 						  /* How fast the shells will travel */
	uint		shellDelay;
	uint		shellDamage;
	int			chaingunHeat;							/* Chain gun heat level */

/* To do with player targetting */
	int			dist_from_player;					/* Taken from linklist's Z value. */
	short		sx;												/* Screen X position. */
	short		sy;												/* Screen Y position. */


	short		max_armour;
	short		armour;


/* Miscellaneous */
	ushort	flying;										/* For helicopters */
	ushort	possObjCollisions;				/* For object collision detection */
	ushort	possWallCollisions;				/* For object collision detection */
	ushort	moveTank;									/* Flag to indicate if the tank has to go through the move_tank routine */
	ushort 	objectiveTarget;					/* Flag indicating wether or not this is an object target tank */

	ushort	resetLos;									/* Flag indicating wether or not tank has to be removed from the los map */
	ushort	targetVisible;						/* Flag indicating wether an enemy tank can see you */

	ushort	chaingunSound;						/* Count for timing the chaingun sfx */
} TANK;






struct tank_defs
{
	int			pre_accel;							      /* Tank acceleration rate. */
	int			accelr;							      /* Tank acceleration rate. */
	int			accelc;							      /* Tank acceleration constant. */
	int			maxturn;			 				    /* Maximum turning rate of tank */
	int			top_speed;
	int			top_brake;
	uint		trak_grip;					      /* The grip provided by the current tracks */

};


struct eng_upg
{
	int			accelr;
	int			accelc;
	int			maxturn;
	int			pre_accel;
	int			top_speed;
};



struct trak_upg
{
	int			trak_grip;
	int			top_brake;
	int			maxturn;
	int			pre_accel;
	int			top_speed;

};



typedef struct gen_empl
{
	uint		exist;
	uint		x;
	uint		z;
	int			angle;
	int			startangle;
	int			dist_from_player;					/* Taken from linklist's Z value. */
	TANK		*targetTank;
	short		shellDelayCount;
	ushort	burstCount;
	ushort	chaingunSound;
	short		turnRate;
	short		armour;
	short		sx;												/* Screen X position. */
	short		sy;												/* Screen Y position. */
}GUN_EMPLACEMENT;



typedef struct gun_boat
{
	uint		exist;
	uint		x;
	uint		z;
	int			speed;
	int			armour;
	int			angle;
	ENEMY_TANK_CTRL	*ectrl;						/* Enemy control logic data pointer */
	short		shellDelayCount;
	ushort	chaingunSound;
	ushort	burstCount;
}GUN_BOAT;



typedef struct hostage
{
	uint	def;
	uint	x;
	uint	z;
	uint	angle;
	ushort	frame;
	ushort	animframe;
	ushort	mode;
	ushort	frmDelay;
	ushort	anim;
}HOSTAGE;



typedef struct convoy_data
{
	ushort	numMembers;
	ushort	convoyType;
	ushort	members[MAX_CONVOY_MEMBERS];
	ushort	currentTarget;
	ushort	initMembers;
	ushort	convoyCompleted;
}CONVOY_DATA;





typedef struct
{
	uint	x;
	int		y;
	uint	z;
}POSITION;





typedef struct
{
	uint		pl_id;							      /* Player id */
	uint		def;								      /* Sprite definition number */
	uint		x;									      /* World coords */
	int			y;
	uint		z;
	uint		angle;							      /* Direction object is facing */
}NETWORK_BLOCK;





typedef struct
{
	int	y_txt_add;                    /* The scaling factor for step through source data (in y) */
	int	x_txt;                        /* The collumn of texture which is being used */
	int	y_screen;                     /* The Y position on the screen where texture starts */
	int	height;                       /* The height of the collumn to be drawn */
	int	y_txt;                        /* The fractional offset into the collumn at start */
	int	dc_table;                     /* The depth cue table the collumn is using (if at all). */
}WALLDRAW_DATA;




typedef	struct
{
	short	x;
	short	floor_y;
	short	z;
	short top_y;
	short	z_depth;
	short	scrn_x;
}WORKING_POINT;




typedef struct
{
	ushort	p1;
	ushort	p2;
	ushort	wallType;
}WALL_DATA;




typedef struct
{
	uint	currFrame;
	uint	frmCnt;
	uint	frmRate;
}ANIM_TXTR_DATA;




typedef struct
{
	uint	x;									/* Position of shell */
	int		y;
	uint	z;
	int		direction; 					/* direction shell is moving in */

	uint	ox;									/* Old position of shell */
	int		oy;
	uint	oz;

	int		fired;							/* Flag indicating if shell has to be drawn */
	int		speed;							/* Speed shell is travelling at */
	int 	range;							/* How far shell will travel before exploding on its own */
	int		dist_travelled;			/* How far shell has travelled */
	ushort		damage;
	ushort		owner;    			/* Identity of tank that fired shell */
	ushort		ownerType;			/* player/enemy */
}SHELL_DATA;






typedef struct
{
	uint	used;								/* Flag indicating if slot is being used at the moment */
	uint	x;									/* Position of fx sprite in world */
	int		y;
	uint	z;
	uint	frm;								/* Current Frame of fx sprite */
	uint	spriteType;					/* Transparent/solid/flipped sprite (bit 0=transparent, bit 1=flipped*/
	int		scaling;						/* Scale factor on fire/smoke etc... */
	uint	rising;							/* Flag for rising smoke */
	uint	looping;						/* Looping flag for fragments */
	uchar	*frmTable;					/* Animation frame table to be used */
	uint	frmDelay;						/* Count between updates of frames */
}FX_SPRITE;

/* If you change this structure, remember to change corresponding structure in aglobals.h */




typedef struct
{
	uint	used;								/* Flag indicating if slot is being used at the moment */
	uint	x;
	uint	z;
	FX_SPRITE	*spr;						/* Actual sprite info for fragment */
	uint	dir;                /* Direction fragment is travelling in */
	int		speed;							/* Speed of fragment */
	int		yvel;								/* Initial y velocity of fragment */
	uint	premature;					/* Fragment switches animations mid flight */
}FRAGMENT_DATA;             /* Count between updates of frames */





typedef struct							/* Used to store composite effects which start at different times */
{
	uint	used;								/* Slot flag */
	uint	x;									/* Where the effect is placed (approximately) */
	int		y;
	uint	z;
	uchar	*fxlistType;				/* Points to a group of fx */
	uchar	fxlistDelay[MAX_DELAY_FX]; /* Holds the timings for the group of fx */
}DELAYED_FX;




typedef struct							/* General structure */
{
	ushort	x;
	ushort	z;
}POINT_DATA;




typedef struct
{
	int			x;
	int			z;
}POINT;




typedef	struct							/* Used for collision detection */
{
	short	width;
	short	length;
}SIZE_INFO;




typedef struct
{
	WALL_DATA *wallid;      	/* Which wall was hit */
	short	angle[4];						/* angle between the wall and tank */
	short	intercept[4];				/* which side of the tank hit the wall */
	short	swapped;            /* Point 1 inside tank - point 2 used as lead point */
}WALL_COLLISION_INFO;



typedef struct
{
	char	wallType;
	char	texture;
}DESTRUCT_INFO;




typedef struct
{
	char					*detectType;
	DESTRUCT_INFO	*destructInfo;
}WALL_DETECTION_INFO;



typedef struct
{
		short		xstart;
		short 	ystart;
		short 	dx;
		short 	dy;
}TVBTAB;
/* If you change this structure, remember to change corresponding structure in aglobals.h */




typedef struct linklist
{
	struct 	linklist *prev;
	struct 	linklist *next;
	ushort 	def;
	short 	sx;
	short 	sy;
	short	 	sz;
	short		pl;
	uint		z_depth;
}LINKLIST;
/* If you change this structure, remember to change corresponding structure in aglobals.h */



typedef struct
{
		ushort 	t_xsize;				/* X size (in pixels). */
		short  	t_scr_xpos;  		/* Screen X position. */
		short  	t_scr_ypos;  		/* Screen Y position. */
	  uint   	t_xscale;	 			/* X Scaling factor. */
	  uint   	t_yscale;  			/* Y Scaling factor. */
	  ushort  t_xloop;  			/* X loop count. */
	  ushort  t_yloop;  			/* Y loop count. */
		uint		t_init_xscale;	/* Clipped start X scale value. */
		uint		t_init_yscale;	/* Clipped start Y scale value. */
		uint		t_dataoff;			/* Sprite graphic data offset. */
		ushort	t_ylines;				/* Sprite graphic data offset. */
}SPRBLOCK;
/* If you change this structure, remember to change corresponding structure in aglobals.h */










typedef struct									/* For use when positioning & drawing sprites.*/
{
		int			m_x;                /* World x,y,z coord */
		int			m_z;
		short		m_y;
		ushort  m_def;							/* Object tag */
		short		m_ang;							/* Angle object is facing */
		short 	m_plyr;
}MOBS;
/* If you change this structure, remember to change corresponding structure in aglobals.h */

struct bullets
{
	uchar	on;									/* Flag indicating if shell has to be drawn */
	uint	x;									/* Position of shell */
	int		y;
	uint	z;
	uint	oldx;								/* Old position of shell */
	int		oldy;								/* Old position of shell */
	uint	oldz;
	int		yvel;
	short	speed;							/* Speed shell is travelling at */
	int 	range;							/* How far shell will travel before exploding on its own */
	int		dist_travelled;			/* How far shell has travelled */
	int		dir; 					/* direction shell is moving in */
	ushort	owner;
	ushort	ownerType;
};


struct target
{
	short		index;
	short		dest_x;
	short		dest_y;
	short		x;
	short		y;
	short		xvel;
	short		yvel;
	short		locked;
	short		max_xvel;	/* MANSOOR - update max vels when buy upgrades. */
	short		max_yvel;
	uchar		type;		/* Tank, Helicopter or Gun emplacement. */
};

struct closest_targets
{
	short		index;
	uchar		type;		/* Tank, Helicopter or Gun emplacement. */
};


typedef struct sams
{
	int		fired;							/* Flag indicating if shell has to be drawn */
	uint	x;									/* Position of shell */
	int		y;
	uint	z;
	uint	oldx;								/* Old position of shell */
	uint	oldz;
	short	turn;
	short	maxturn;
	int		yvel;
	int		speed;							/* Speed shell is travelling at */
	int		angle; 		 					/* direction shell is moving in */
	int		dir; 		 						/* direction shell is moving in */
	int		index;           		/* Index into structure of helicopter being tracked. */
}SAM;


typedef struct asms					/* Air to surface missiles */
{
	int		fired;
	uint	x;
	int		y;
	uint	z;

	uint	ox;
	uint	oz;

	uint	otx;								/* old positions of tanks */
	uint	otz;

	int		angle;							/* angle which sam is currently facing */

	TANK	*targetTank;

}ASM;

typedef struct nineAir
{
	uint	x;
	int		y;
	uint	z;
	int		angle;
	int		speed;
}NINE_11;


#endif

