#include "headers.h"

#include "chuck.h"
#include "e_global.h"

#ifdef MEMCHK
#include <memcheck.h>
#endif



int		sprite_y_clip=GSCRYHT;


void	scale_sprite(int xpos,int ypos,int scale,int def,uchar shade,uchar flip,uchar trans,uchar *gfx,uchar *net)
{
	long		sprxsize , sprysize;
	long		sprxorg , spryorg;
	long		xlp;
	long		xinc , yinc;
	long		xsize , ysize;
	long		xspr , yspr;
	long		xsprst , ysprst;
	long		tx, ty;

	long		numspr;
	int			*netptrl;
	short		*gfxptrs , *netptrs;

	uchar 	*sprptr2;

	if (def < 0)
		return;

	netptrs = (short*) (net + (def << 1) + 2);
	netptrs = (short*) (net + *netptrs);

	numspr = *netptrs++;

	tx = xpos;
	ty = ypos;

	while	(numspr-- >= 0)
	{
		xpos = tx;
		ypos = ty;
		sprxorg = *netptrs++;
		spryorg = *netptrs++;

		netptrl = (int*) netptrs;
		gfxptrs = (short*) (*netptrl + gfx);
		netptrs += 2;

		sprxsize = *gfxptrs++;
		sprysize = *gfxptrs++;

		g_addr = sprptr2 = (uchar*) gfxptrs;

		sprxsize++;

		xsize = (sprxsize << 16) / scale;	// xloop
		ysize = (sprysize << 16) / scale;  // yloop

	/*	if (!xsize && sprxsize < 8)
 				xsize = 1;	*/

		if (xsize<=0 || ysize<=0)
			return;

		xinc = scale;	//(sprxsize << 16) / xsize;
		yinc = scale; //(sprysize << 16) / ysize;

//	if (xinc < 0x2aab || xinc > 0x5ffff)	/* Greater than x6 or less than /6 ? */
   	if (xinc < 0x2aab )	/* Greater than x6 or less than /6 ? */
			return;

		if ( flip == 0 )
			xpos += (sprxorg*xsize)/sprxsize;
		else
			xpos += ((-(sprxsize+sprxorg))*xsize)/sprxsize;

		ypos += (spryorg * ysize) / sprysize;

		if (xpos >= 320 || ypos >= sprite_y_clip)
			return;

		if (xpos + xsize <= 0 || ypos + ysize <= 0)
			return;

		spb.t_init_xscale = spb.t_init_yscale = xsprst = 0;

		if (xpos<0)
		{
			spb.t_init_xscale = xsprst = (-xpos) * xinc;
			xsize += xpos;
			xpos = 0;
		}
		if (xpos+xsize >= 320)
			xsize = 320 - xpos;

		ysprst = 0;
		if (ypos<0)
		{
			spb.t_init_yscale = ysprst = (-ypos) * yinc;
			ysize += ypos;
			ypos = 0;
		}

		if (ypos+ysize >= sprite_y_clip)
			ysize = sprite_y_clip - ypos;

		xspr = xsprst;

		if (xinc >= 0xc000 && !flip)	/* Shrunk sprite. */
		{
			for ( xlp=0; xlp<xsize; xlp++ )
			{
				scaletab[xlp] = ( xspr>>16 );
				xspr += xinc;
			}
		}
		else if (flip)		/* Flipped sprite. */
		{
			for ( xlp=0; xlp<xsize; xlp++ )
			{
				scaletab[xlp] = ( (sprxsize-1) - (xspr>>16) );
				xspr += xinc;
			}
   		scaletab[xsize] = -1;
		}

		yspr = ysprst;

 		spb.t_xsize = sprxsize;
 		spb.t_scr_xpos = xpos;
 		spb.t_scr_ypos = ypos;
 		spb.t_xscale = xinc;
 		spb.t_yscale = yinc;
 		spb.t_xloop = xsize;
 		spb.t_yloop = ysize;


		if (flip)
		{
			if (shade == 32) 	/* Not depth queued.	*/
			{
				if (xinc < 0xc000 )  		/* Expanding sprite. */
				{
						spb.t_dataoff = ((ysprst>>16) * sprxsize) + scaletab[0];
						spb.t_ylines = 0x10000/yinc;
						if (trans)	/* Transparent? */
	  					_fsize_sprite_trans(&spb);
						else
							_fsize_sprite(&spb);		/* Expanded sprite. */
				}
				else
				{
							spb.t_dataoff = ((ysprst>>16) * sprxsize);
							if (trans)	/* Transparent? */
			    			_spr_14_trans_ndc(&spb);
							else
 								_spr_14_ndc((short*)&spb);      	/* Shrunk sprite. */
				}
			}
			else      /* Depth queued. */
			{
				depth_tab = odepths + (shade<<8);
				spb.t_dataoff = ((ysprst>>16) * sprxsize);
				if (trans)
					_spr_14_trans(&spb);
				else
					_spr_14((short*)&spb); 			/* Sprite draw with depth que. */
			}
		}
		else
		{
			if (shade == 32)
			{
				if (xinc < 0xc000 )  		/* Expanding sprite. */
				{
	 					spb.t_ylines = 0x10000/yinc;
						spb.t_dataoff = ((ysprst>>16) * sprxsize) + (xsprst>>16);
						if (trans)
	  					_size_sprite_trans(&spb);
						else
				 			_size_sprite((short*)&spb);		/* Expanded sprite. */
				}
				else
				{
							spb.t_dataoff = ((ysprst>>16) * sprxsize);
							if (trans)
			  	 			_spr_14_trans_ndc(&spb);
				 			else
		    				_spr_14_ndc((short*)&spb);      	/* Shrunk sprite. */
				}
			}
			else
			{
				depth_tab = odepths + (shade<<8);
				spb.t_dataoff = ((ysprst>>16) * sprxsize);
				if (trans)
					_spr_14_trans(&spb);
				else
					_spr_14((short*)&spb); 			/* Sprite draw with depth que. */
			}
		}
	}
}



#define SPRITE_CLIP_HORIZONTAL 		320
#define SPRITE_CLIP_VERTICAL			GSCRYHT


void	network_tank_scale_sprite(int x1,int y1,int scale,int def,uchar shade,uchar flip,uchar trans,uchar *gfx,uchar *net)
{
// gibby's original vars
	long		sprxsize , sprysize;
	long		sprxorg , spryorg;
	long		xsize , ysize;
	long		tx, ty;

	long		numspr;
	uint		*netptrl;
	short		*netptrs;
	short		*gfxptrs;

// pauls's additional stuff
	int		x2,y2;
	int 	xdif;
	int		u,ustart,uadd;
	int		vstart,vadd,pixadd;
	uchar	*pixptr,*dqptr;
	uchar	*ssptr,*slptr;
	uchar	pix;


	if (def < 0)
		return;

	netptrs = (short*) (net + (def << 1) + 2);
	netptrs = (short*) (net + *netptrs);

	numspr = *netptrs++;

	tx = x1;
	ty = y1;

	while	(numspr-- >= 0)
	{
		x1 = tx;
		y1 = ty;

		sprxorg = *netptrs++;
		spryorg = *netptrs++;

		netptrl = (uint*) netptrs;
		gfxptrs = (short*) (*netptrl + gfx); // Pointer to Sprite Data
		netptrs += 2;


		sprxsize = *gfxptrs++;		// extract the bitmap size from the bitmap data
		sprysize = *gfxptrs++;

		ssptr = (uchar*)gfxptrs;

		sprxsize++;

		xsize = (sprxsize << 16) / scale;	// xloop
		ysize = (sprysize << 16) / scale;  // yloop

		if (xsize<=0 || ysize<=0)
			return;

		if ( flip == 0 )
			x1 += (sprxorg*xsize) / sprxsize;
		else
			x1 += ((-(sprxsize+sprxorg))*xsize)/sprxsize;

		y1 += (spryorg * ysize) / sprysize;

		x2 = x1+xsize;
		y2 = y1+ysize;

		if (x1 >= 320 || y1 >= sprite_y_clip)
			return;

		if (x2 <= 0 || y2 <= 0)
			return;


		/** got screen coords of top left corner of sprite (unclipped) */

		vadd = (int)((sprysize<<16)-256)/(y2-y1);	  // Extract Width of Sprite
		uadd = (int)((sprxsize<<16)-256)/(x2-x1);   // Extract Height of Sprite

		ustart = vstart = 0;

		if ( flip )
		{
			uadd = -uadd;											// go backwards through bitmap
			ustart = (sprxsize<<16)-256;			// start at right side of bitmap
		}


		/** now clip to the screen */



		// clip to the left

		if ( x1<0 )						// Clip On Screen Coordinates..
		{
			ustart -= uadd*x1;
			x1 = 0;
		}

		// clip to the top

		if ( y1<0 )
		{
			vstart = -vadd*y1;
			y1 = 0;
		}

		// clip to the right

		if ( x2>SPRITE_CLIP_HORIZONTAL )
			x2 = SPRITE_CLIP_HORIZONTAL;

		// clip to the bottom

		if ( y2>SPRITE_CLIP_VERTICAL )
			y2 = SPRITE_CLIP_VERTICAL;

		xsize = x2-x1;
		ysize = y2-y1;
		pixptr = scr_ptr + y1*320 + x1;
		pixadd = 320 - xsize;

		// setup depth cue table

		if ( shade==32 )
		{
			dqptr = pdepths;
		}
		else
			dqptr = pdepths+(shade<<8);


		if ( trans )
		{
  		for ( ;ysize>0; ysize-- )
  		{
  			slptr = ssptr + ((vstart>>16)*sprxsize);           // Use DepthQ
  			u = ustart;                                  // LookUp Draw....
  			for ( xdif=xsize; xdif>0; xdif-- )
  			{
  				if (  ( pix=*(slptr+(u>>16)) )  )
					{
  					pix = *(dqptr + pix );
						*(pixptr) = interpol_tab[(*(pixptr)<<8)+pix];
					}
  				u += uadd;
  				pixptr++;
  			}
  			pixptr += pixadd;
  			vstart += vadd;
  		}
		}
		else
		{
  		for ( ;ysize>0; ysize-- )
  		{
  			slptr = ssptr + ((vstart>>16)*sprxsize);           // Use DepthQ
  			u = ustart;                                  // LookUp Draw....
  			for ( xdif=xsize; xdif>0; xdif-- )
  			{
  				if (  ( pix=*(slptr+(u>>16)) )  )
  					*(pixptr) = *(dqptr + pix );
  				u += uadd;
  				pixptr++;
  			}
  			pixptr += pixadd;
  			vstart += vadd;
  		}
		}
	}
}

