#include <stdio.h>
#include <stdlib.h>

#include "chuck.h"
#include "walldraw.h"

#ifdef MEMCHK
#include <memcheck.h>
#endif



#define VIEWPORT_HEIGHT					60
#define	WALL_CHECK_RANGE	 			0x4000
#define MIN_WALL_APPEAR_DIST		0x2000
#define Z_CLIP_DEPTH						0x1000



int	xoff=160;



extern	int	startz, endz, startx, endx;
extern	int	cosang, sinang;
extern 	int currentWallHeight;

static	LINKLIST	*clink, *linkfree;
static	LINKLIST	*nlink, *plink, *lastlink;

static	MOBS		*cmob;
static	short		bearing;
static	int			relx, relz, arelx, arelz;
static	int			indsz, indez; 											/* Indexing start and end values */
POINT_DATA	*cwallmid;															/* Current midpoint being checked */
WALL_DATA		*cwall;													/* The current wall to test against */
static	int	numlinks;


void	sprite_origin(void)
{
	int		appear_dist;
	int		yardstick;
	int		wallnumber = 0;
	int		n, m, tx, x, z;
	uchar	*cobj, *objrow;



	clear_linked_list();

	bearing = 2047 - pangle;
	cosang = (int)sintab[bearing+512];
	sinang = (int)sintab[bearing];








	/* Get the moving objects into the draw list */

	cmob = mob;

	while ( cmob->m_def != 0xffff )
	{
		/* Get relative positions of moving object to player */

		arelx = abs(relx = pxpos - cmob->m_x);
		arelz = abs(relz = cmob->m_z - pzpos);

		/* Range check on moving objects */

		if ( arelx>arelz )
		{
			arelz>>=1;
			if ( (arelz+arelx) > obrange )
			{
				cmob++;
				continue;
			}
		}
		else
		{
			arelx>>=1;
			if ( (arelx+arelz) > obrange )
			{
				cmob++;
				continue;
			}
		}

		/* Get Sprite definition number along with rotation frame offset */

		linkfree->def = ((cmob->m_def<<6) | (cmob->m_ang & 63));

		/* Store relative pos in linklist */

		linkfree->sx = relx;
		linkfree->sz = relz;
		linkfree->sy = cmob->m_y - alt;

		rotate_point();

		linkfree->sz -= 512;

		get_perspective();

		/* Check if sprite on screen */

		if ( linkfree->sx < -100 )
		{
			cmob++;
			continue;
		}

		if ( linkfree->sx > NSCR_WIDTH+100 )
		{
			cmob++;
			continue;
		}

		if ( linkfree->sz < 130 )
		{
			cmob++;
			continue;
		}


		linkfree->pl = cmob->m_plyr;

		insert_in_list();

		cmob++;
	}



	/*******************************************************/



	/* Get the walls into the draw list */

	startz = ( (int)(pzpos - WALL_CHECK_RANGE) <0) ? 0 : (pzpos - WALL_CHECK_RANGE);

	startx = ( (int)(pxpos - WALL_CHECK_RANGE) <0) ? 0 : (pxpos - WALL_CHECK_RANGE);

	endz = ( (int)(pzpos + WALL_CHECK_RANGE) > 0xffff ) ? 0xffff : (pzpos + WALL_CHECK_RANGE);

	endx = ( (int)(pxpos + WALL_CHECK_RANGE) > 0xffff ) ? 0xffff : (pxpos + WALL_CHECK_RANGE);


	/* Find first wall in z range */

	cwallmid = NULL;

	indsz = startz >> 8;
	indez = endz >> 8;


	while ( TRUE )
	{
		if ( wall_z_index[indsz] != NO_POINTS )
		{
			cwallmid = wallMids + (wallnumber = wall_z_index[indsz]);
			cwall = wallSfcs + wall_z_index[indsz];
			break;
		}
		indsz++;
		if ( indsz>indez ) 												/* No walls to test against */
		{
			break;
		}
	}


	while ( cwallmid!=NULL )
	{
		if ( wallnumber >= numSfcs )
			break;

		if ( cwallmid->z > endz ) 								/* Gone beyond range of wall check */
			break;

		if ( cwallmid->x>=startx && cwallmid->x<=endx )
		{
			appear_dist = ((cwall->wallType&0x1e00)>>1) + MIN_WALL_APPEAR_DIST;

			arelx = abs(relx = pxpos - cwallmid->x);
			arelz = abs(relz = cwallmid->z - pzpos);

			yardstick = ((min(arelx, arelz))>>1) + max(arelx,arelz);

			if ( yardstick > appear_dist )
			{
				cwallmid++;
				cwall++;
				wallnumber++;
				continue;
			}

			linkfree->sx = relx;
			linkfree->sz = relz;

			rotate_point();

			linkfree->def = WALL_INSERT_TAG;
			linkfree->pl = wallnumber;

			insert_in_list();
		}
		cwallmid++;
		cwall++;
		wallnumber++;
	}


	/*******************************************************/

	/* Get the floor object sprites into the draw list */
/*
	startz = ( (int)(pzpos - obrange) <0) ? 0 : (pzpos - obrange);

	startx = ( (int)(pxpos - obrange) <0) ? 0 : (pxpos - obrange);

	endz = ( (int)(pzpos + obrange) > 0xffff ) ? 0xffff : (pzpos + obrange);

	endx = ( (int)(pxpos + obrange) > 0xffff ) ? 0xffff : (pxpos + obrange);

	z = (startz&=0xff00) - pzpos;
	endz&=0xff00;
	endz-=startz;

	endz>>=8;

	tx = pxpos - (startx&0xff00);


	startx>>=8;
	endx>>=8;
	endx-=startx;


	objrow = obj_map + startz;

	for ( n=0; n<=endz; n++, objrow+=0x100, z+=0x100 )
	{
		cobj = objrow;
		x = tx;
		for ( m=0; m<=endx; m++, cobj++, x+=0x100 )
		{
			if ( *cobj!=0 )
			{
				linkfree->sz = z;
				linkfree->sx = x;
				linkfree->sy = -alt;
				linkfree->def = (1<<6);

				rotate_point();

				linkfree->sz -= 0x200;

				get_perspective;

				if ( linkfree->sx < -100 )
				{
					continue;
				}

				if ( linkfree->sx > NSCR_WIDTH+100 )
				{
					continue;
				}

				if ( linkfree->sz < 130 )
				{
					continue;
				}

				insert_in_list();

			}
		}
	}
*/



	/*******************************************************/

	/* Get the fxsprites into the draw list */

	//setcol(BLACK);


}



void	clear_linked_list(void)
{
	clink = ll;

	clink->next = NULL;
	clink->prev = ll+1;
	clink->def	= 0;
	clink->z_depth = 5;

	clink++;

	clink->next = ll;
	clink->prev = NULL;
	clink->def	= 0;
	clink->z_depth = 2000000;

	linkfree = ll + 2;

	numlinks=0;

	lastlink = (ll+1)->next;
}





void	insert_in_list(void)
{
	int				zcheck;


/*	plink = ll+1;
		nlink = plink->next;*/


	zcheck = (linkfree->sz*linkfree->sz) + (linkfree->sx*linkfree->sx);


	while ( TRUE )
	{
		if ( zcheck > nlink->z_depth ) 	/* Found slot */
		{
			linkfree->z_depth = zcheck;

			plink->next = linkfree;
			nlink->prev = linkfree;

			linkfree->prev = plink;
			linkfree->next = nlink;

			linkfree++;
			return;
		}
		else
		{
			plink = nlink;
			nlink = plink->next;

			if ( nlink==NULL  )
				return;
		}

	}

}





void	rotate_point(void)
{
	int	rx,rz;

	rx = ((int)(linkfree->sx*cosang - linkfree->sz*sinang)) >> 14;
	rz = ((int)(linkfree->sz*cosang + linkfree->sx*sinang)) >> 14;

	linkfree->sz = rz;
	linkfree->sx = rx;
}




void	get_perspective(void)
{
	int	z;

	z=linkfree->sz;

	if ( z==0 )
	{
		z=10;
	}

	linkfree->sx = ((linkfree->sx<<7)/z)+xoff;
	linkfree->sy = ((linkfree->sy<<8)/z)+VIEWPORT_HEIGHT;
}






int		rotate_wall_point(WORKING_POINT *cwpt, POINT_DATA *wpt)
{
	int	rx,rz;
	int	relx, relz;

	bearing = 2047 - pangle;
	cosang = (int)sintab[bearing+512];
	sinang = (int)sintab[bearing];

	/* Get relative position of point compared to player */

	relx = pxpos - wpt->x;
	relz = wpt->z - pzpos;

	/* Rotate about the tank */

	rx = ((int)(relx*cosang - relz*sinang)) >> 14;
	rz = ((int)(relz*cosang + relx*sinang)) >> 14;

	/* Store result in working point structure */

	cwpt->x = rx;
	cwpt->z_depth = cwpt->z = rz;
	cwpt->floor_y = 0;

	cwpt->top_y = currentWallHeight;

	/* Check for clipping against the view plane */

	if ( cwpt->z_depth <Z_CLIP_DEPTH )
	{
		return (FALSE);
	}
	else
		return (TRUE);
}



void	apply_wallpoint_perspective(WORKING_POINT *cwpt)
{
	int	perdiv;
	int	tx,ty;

	perdiv = cwpt->z-512;

	if ( perdiv==0 )
	{
		perdiv=1;
	}

	tx = cwpt->x<<7;
	cwpt->scrn_x = (tx/perdiv) + xoff;

	ty = (cwpt->floor_y - alt)<<8;
	cwpt->floor_y = ty/perdiv + VIEWPORT_HEIGHT;

	ty = (cwpt->top_y - alt)<<8;
	cwpt->top_y = ty/perdiv + scr_height;
}



