

#include <stdlib.h>

#include "teleport.h"
#include "shock.h"
#include "chuck.h"
#include "e_global.h"
#include "frontend.h"


/*Num of telePod types used in this level*/
int TELE_TYPES= 0;
int TELE_MODE= 0;


/*Tiles in centre of pad, which distinguish teleType*/
uchar teleTiles []=
{18,13,15,16,17};

/*Middle square may be 15,16,17,18 for a number 1-4*/

uchar teleFloor  [TELE_HEIGHT][TELE_WIDTH]=
{
	{173,173,173,173,173},
	{173, 19, 19, 19,173},
	{173, 19, 18, 19,173},
	{173, 19, 19, 19,173},
	{173,173,173,173,173}
};





/*Format is- TELEPOD TYPE, NUMBER OF POSITIONS FOR THIS TYPE,
	followed by the set of position coordinates.
  Currently there is only a set of telepods for ONE level*/

uchar telePods[][2]=
{
	{TELE_RANDOMIZER,2},
	{148,76},
	{148,219},

	{PLANET_WARP,1},
	{20,64},

	{2,2},
	{212,57},
	{200,196},

	{3,3},
	{148,37},
	{134,187},
	{79,118},

	{4,2},
	{109,162},
	{27,72},

	{EO_TPODS,EO_TPODS}
};



/*Calculate the num of teleTypes used in the current level*/
void getNumTeleTypes (void)
{
	int i=0;

	TELE_TYPES= 0;

	while (telePods[i][0]!=EO_TPODS)
	{
		i+=telePods[i][1]+1;
		TELE_TYPES++;
	}

}




/*Plant telepads in virgin soil*/
void plantTelePods (void)
{
	int i=0,j,k;
	ushort *padPos= floor_map;
	int padAdd;
	uchar podPair[2];
	uchar podType,podNum;
	uchar padx,padz;

	while (telePods[i][0]!=EO_TPODS)
	{
		memcpy (podPair, telePods[i],2);
		i++;

		podType= podPair[0];
		podNum = podPair[1];

		/*Plant those pads***/
		for (;podNum>0;podNum--)
		{
			padx= telePods[i][0];
			padz= telePods[i][1];

						/*centre the pad*/
			padx-=TELE_WIDTH>>1;
			padz-=TELE_HEIGHT>>1;

			for (j=0;j<TELE_HEIGHT;j++)
			{
				for (k=0;k<TELE_WIDTH;k++)
				{
					padAdd =(int) padx+ (((int) padz)<<8);
					padPos= floor_map+ padAdd;

					/*central tile*/
					if ((j==TELE_HEIGHT>>1)&&(k==TELE_WIDTH>>1))
						*padPos= (ushort) teleTiles[podType]<<3;
					else
						*padPos= ((ushort) teleFloor[j][k])<<3;
					padx++;
				}

				padx-=TELE_WIDTH;
				padz++;
			}

			i++;
		}

	}

}





/*Returns the distance between two (X,Z) in TILES*/
short PROXIMITY (POSITION *one,POSITION *two)
{
  int xtent,ztent;

  xtent=abs ((two->x>>24) -(one->x>>24));
  ztent=abs ((two->z>>24) -(one->z>>24));



  if (xtent>ztent)
	{
		return ((short) (xtent+(ztent>>1)));
	}
  else
  return ((short) (ztent+(xtent>>1)));

}




char thisTankOnRadar (TANK *ttank)
{
	POSITION *p1,*p2;

	p1= (POSITION *) &tanks[myID]->x;
	p2= (POSITION *) ttank->x;

	if ((PROXIMITY (p1,p2) ) < RADAR_TILE_RADIUS )
		return (1);

	return (0);

}



/*YES, if another tank is within the RADAR_TILE_RADIUS */
char tankOnRadar (void)
{
	int i,j;


	for (i=0;i<myGame.noPlayers;i++)
	{
		j=playerList.qi[i];

		if (j!=myID)
		{
			if (thisTankOnRadar (tanks[j]))
				return (1);
		}
	}

	return (0);
}




/*Based on telePod player is in contact with, move him to a
	new telePod position */
/*If there is only a choice of one other pad, and that pad is
	occupied, don't do teleport*/

char telePortZap (TANK *tTank, uchar podType, uchar podNo)
{
	char clearPos;
	int j,k;
	int tooClose= 8; /*radius of 8 tiles*/
	POSITION p1, *p2;
	uchar podMax;
	uchar nuPod; /*Destination Pod*/
	int ixPod=0; /*Index of first pod of podType*/
	uchar podRand;
	uchar oPodType;
	uchar oPodNo;

	clearPos=0;
	oPodType= podType;
	oPodNo= podNo;

	/*#1 LOCATE the telePod type in the telePods array*/

	do
	{

		/*Select a pod at random*/
		/*If first random placement fails, it'll be retried*/

		if (oPodType==TELE_RANDOMIZER)
		{
			/*DON'T select PLANET_WARP!!!*/

			do
			{
				ixPod= 0;

				podRand= (uchar) rand();
				podRand= podRand- ((podRand/TELE_TYPES)*TELE_TYPES);

				for (;podRand>0;podRand--)
					ixPod+=telePods[ixPod][1]+1;

				podType= telePods[ixPod][0];
			}	while (podType==PLANET_WARP);

			podMax=  telePods[ixPod][1];

			podNo= (uchar) rand();
			podNo= podNo- ((podNo/podMax)* podMax);
			podNo+=1;

		}
		else
		if (podType==PLANET_WARP)
		{
			if (myID==LEADER_ID)
				LEADER_CHLEV_PHASE();
			else
			{
				STATPAK.type=SP_CHLEV;
				VAROBJ_TO_OUTPUT_BUFFER (&STATPAK);
				STATPAK.type= 0;
			}

			return(1);
		}
		else
		{
 			while (telePods[ixPod][0]!= podType)
				ixPod+=telePods[ixPod][1]+1;

 			podMax= telePods[ixPod][1];
		}


		nuPod= podNo;

		nuPod++;
		if (nuPod>podMax)
			nuPod= 1;


		/*#2 SELECT the destination telePod*/

		while ((nuPod!=podNo)&&(!clearPos))
		{

		/*#3 VERIFY the destination- check no other player is there*/

			p1.x= telePods[ixPod+nuPod][0]<<24;
			p1.z= telePods[ixPod+nuPod][1]<<24;

			clearPos=1;
			/*Check no other tank is nearby- just human ones for now*/
			for (j=0;j<myGame.noPlayers;j++)
			{
				k= playerList.qi[j];

				if (tanks[k]!=tTank)
				{
					p2=(POSITION *) &(tanks[k]->x);

					if (PROXIMITY (&p1,p2)<=tooClose)
					{
						clearPos=0;
						break;
					}
				}

			}/*j loop*/

			if (!clearPos)
			{
				nuPod++;
				if (nuPod>podMax)
					nuPod= 1;
			}
			else
			{
				tTank->x= p1.x;
				tTank->z= p1.z;
			}

		}


		/*STOP PLAYER RANDOMLY TELEPORTING TO ORIGINAL POSITION*/
		if ((oPodType==TELE_RANDOMIZER)&&clearPos)
		{
			if (podType==oPodType&&podNo==oPodNo)
				clearPos= 0;
		}

	}	while ((oPodType==TELE_RANDOMIZER)&&!clearPos);

	/*#4 DISSOLVEY effect*/
	/*if (GAME_LOOPS)
	{*/
		if (OSCREEN_SIZE==1)
			dissolveFrame= DISSOLVE_MAX;
		else
		{
			dissolveFrame= 256;
			memcpy (oscreen,(char *) (0xa0000+16*320),OSCREEN_SIZE);
		}
/*}*/


	/*Can't re- teleport until off pad*/
	TELE_MODE= 1;
	return(1);
}






/*Checked every frame******************************************/
char DETECT_TELEPORT (void)
{
	int tpx,tpz;
	ushort *floor_ptr;
	uchar podType;
	int ixPod=0;
	ushort tile_tex;
	uchar podNo;


	tpx = (int) (pl.x >> 24);
	tpz = (int) (pl.z >> 24);

	floor_ptr= floor_map;
	floor_ptr +=  tpx  + (tpz <<8 );



	/*Check if floor_ptr is equal to one of the tele-tiles*/
	/*Future- use an invisible floor OBJECT for teleport detect*/
	/*THEN- work out teleType from POSITION*/

	tile_tex= (*floor_ptr)>>3;

	for (podType=0;podType<MAX_TELE_TYPES;podType++)
	{
		/*Is tank on a teleTile?*/
		if (tile_tex==teleTiles[podType])
		{
			if (TELE_MODE==0)
			{

				if (podType!= TELE_RANDOMIZER)
		 		{
		 			/*Seek this podType in telePods array*/
		 			while (telePods[ixPod][0]!=podType)
		 				ixPod+=telePods[ixPod][1]+1;

		 			/*Seek the particular pod in telePods array*/
		 			podNo= 1;
		 			while (!(	telePods[ixPod+ podNo][0]==tpx &&
		 								telePods[ixPod+ podNo][1]==tpz ))
			 			podNo++;
		 		}

		 		telePortZap (&pl, podType, podNo);
			}

			return(1);
		}

	}

	/*Tank wasn't on a teleTile*/
	TELE_MODE= 0;
	return(0);

}


