#include "headers.h"

#include "chuck.h"
#include "e_global.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"


#ifdef MEMCHK
#include <memcheck.h>
#endif

#define MAIN_GUN_TARGET		5
#define MAIN_GUN_LOCKED		13
#define LOCK_ON						14
#define CHAIN_GUN_TARGET	15
#define CHAIN_GUN_LOCKED1	16
#define CHAIN_GUN_LOCKED2	17
#define SAM_TARGET				18
#define SAM_LOCKED1				19
#define SAM_LOCKED2				20

#define TARGETX 					161
#define TARGETY						64





int	numSams=0;

extern	int		reloadSoundPlayed;

extern	int		firstPass;


void	do_weapons(void)
{
	if (pl.cWeapon == WMAIN_GUN)
	{
		do_main_gun();
	}
	else if (pl.cWeapon == WCHAIN_GUN)
	{
		do_chain_gun_1();
		do_chain_gun_2();
	}
	else if (pl.cWeapon == WSAMS)
	{
		do_sams_1();
		do_sams_2();
	}
}


void	do_weapons_1(void)
{
	if ( firstPass )
	{
		return ;
	}

	if (pl.cWeapon == WCHAIN_GUN)
		do_chain_gun_1();
	else if (pl.cWeapon == WSAMS)
		do_sams_1();
}


void do_weapons_2(void)
{
	if (pl.cWeapon == WMAIN_GUN)
		do_main_gun();
	else if (pl.cWeapon == WCHAIN_GUN)
		do_chain_gun_2();
	else if (pl.cWeapon == WSAMS)
		do_sams_2();
}


void do_main_gun()
{
	int	angdiff, targang, n, ang_tolerance, dist, locked;

	TANK	*atank;
	struct	target_points	*tp_ptr;

 	scr_ptr = currentScreen;
 	sprite_y_clip=GSCRYHT;

	locked = 0;

	tp_ptr = &tp[64];

	for (n=0 ; n < 64; n++,tp_ptr++)
	{
 		if (tp_ptr->visible == -1)
			break;
		else if (tp_ptr->visible == 0)
			continue;

		atank = &enemyTanks[tp_ptr->index];

		if ( atank->def )
		{
			targang = phd_atan((atank->x >> 8) - (pl.x >> 8) , (atank->z >> 8) - (pl.z >> 8)) & 0x7ff;
			targang = (targang + 0x400) & 0x7ff;
			angdiff = targang - ((pl.angle+turret_angle)&0X7FF);

			if (angdiff > 1024)
				angdiff -= 2048;
			else if (angdiff < -1024)
				angdiff += 2048;

			dist = 0x1000000/atank->dist_from_player;

			ang_tolerance = (dist >> 7) + (dist >> 9);
			if (ang_tolerance < 8)
				ang_tolerance = 8;
			else if (ang_tolerance > 256)
				ang_tolerance = 256;

			if (abs(angdiff) < ang_tolerance)
			{
				locked = 1;
				break;
			}
		}
	}

	if (locked)
		draw_sprite(TARGETX, TARGETY, MAIN_GUN_LOCKED, (uchar *) panel_display_graphics, (uchar *) panel_display_net);
	else
		draw_sprite(TARGETX, TARGETY, MAIN_GUN_TARGET, (uchar *) panel_display_graphics, (uchar *) panel_display_net);
}




void do_chain_gun_1(void)
{
	int	i,j,k,dist;

	TANK	*atank;
	GUN_EMPLACEMENT	*ge;
	struct	target_points	*tp_ptr;

	for(i=0;i<5;i++)
		ct[i].index = -1;	/* Reset closest targets. */

	if (targ.index != -1)
	{
		if (!change_target)
		{
			tp_ptr = &tp[64];

			for (i=0;i<64;i++,tp_ptr++)
			{
				if (tp_ptr->visible == -1)
				{
					change_target = 1;
					break;
				}
				else if (tp_ptr->type == targ.type && tp_ptr->index == targ.index)
				{
					if (tp_ptr->visible == 0)
						change_target = 1;
					break;
				}
			}
		}

		if (change_target || i == 64)
		{
			change_target = 0;
			targ.index = -1;
			targ.xvel = 0;
			targ.yvel = 0;
			targ.locked = 0;
		}
	}

	tp_ptr = &tp[64];

	for (i=0;i<64;i++,tp_ptr++)
	{
		if (tp_ptr->visible == -1)
			break;
		else if (tp_ptr->visible == 0)
			continue;

		if (tp_ptr->type == HELI_TAG)
		{
			atank = &helicopters[tp_ptr->index];

			if (atank->def && atank->def != REGENERATE_OBJECT)
			{
				if (tp_ptr->index == targ.index && targ.type == HELI_TAG)
					continue;

				dist = atank->dist_from_player;

				for(j=0;j<4;j++)
				{
					if (ct[j].index == -1 || dist < helicopters[ct[j].index].dist_from_player)
					{
						for(k=4;k>j;k--)
						{
							ct[k].index = ct[k-1].index;
							ct[k].type = ct[k-1].type;
						}
						ct[j].index = tp_ptr->index;
						ct[j].type = HELI_TAG;
						break;
					}
				}
			}
		}
		else
		{
			ge = &gunempls[tp_ptr->index];

			if (ge->exist)
			{
				if (tp_ptr->index == targ.index && targ.type == GUN_EMPL_TAG)
					continue;

				dist = ge->dist_from_player;

				for(j=0;j<4;j++)
				{
					if (ct[j].index == -1 || dist < gunempls[ct[j].index].dist_from_player)
					{
						for(k=4;k>j;k--)
						{
							ct[k].index = ct[k-1].index;
							ct[k].type = ct[k-1].type;
						}
						ct[j].index = tp_ptr->index;
						ct[j].type = GUN_EMPL_TAG;
						break;
					}
				}
			}
		}
	}

	if (targ.index == -1)
	{
		if (ct[target_no].index != -1)
		{
			targ.index = ct[target_no].index;
			targ.type = ct[target_no].type;
		}
		else
		{
			target_no = 0;
			targ.index = ct[0].index;
			targ.type = ct[0].type;
		}
	}

	if (targ.index != -1)
	{
		if (targ.type == HELI_TAG)
		{
			targ.dest_x = helicopters[targ.index].sx;
			targ.dest_y = helicopters[targ.index].sy;
		}
		else if ( targ.type == GUN_EMPL_TAG )
 		{
			targ.dest_x = gunempls[targ.index].sx;
			targ.dest_y = gunempls[targ.index].sy;
		}
		else	// if the current target is anything else then don't try to lock on to it.
		{
			targ.dest_x = TARGETX;
			targ.dest_y = TARGETY;
		}
	}
	else
	{
		targ.dest_x = TARGETX;
		targ.dest_y = TARGETY;
	}

	if (!targ.locked)
		update_target_pos();
}



void	do_chain_gun_2(void)
{
 	scr_ptr = currentScreen;
 	sprite_y_clip = GSCRYHT;

	if (!targ.locked)
	{
		if (targ.index != -1)
			scale_sprite(targ.dest_x, targ.dest_y, 0x10000, LOCK_ON, 0, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
		scale_sprite(targ.x, targ.y, 0x10000, CHAIN_GUN_TARGET, 0, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
	}
	else
	{
		if (char_anim & 4)
			scale_sprite(targ.dest_x, targ.dest_y, 0x10000, CHAIN_GUN_LOCKED1, 0, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
		else
 			scale_sprite(targ.dest_x, targ.dest_y, 0x10000, CHAIN_GUN_LOCKED2, 0, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);

		targ.x = targ.dest_x;
		targ.y = targ.dest_y;
	}
}



void do_sams_1(void)
{
	int	i,j,k,dist;
	TANK	*atank;
	struct	target_points	*tp_ptr;


	for(i=0;i<5;i++)
		ct[i].index = -1;	/* Reset closest targets. */

	if (targ.index != -1)
	{
		if (!change_target)
		{
			tp_ptr = &tp[64];

			for (i=0;i<64;i++,tp_ptr++)
			{
				if (tp_ptr->visible == -1)
				{
					change_target = 1;
					break;
				}
				else if (tp_ptr->index == targ.index)
				{
					if (tp_ptr->visible == 0)
						change_target = 1;
					break;
				}
			}
		}

		if (change_target || i == 64)
		{
			change_target = 0;
			targ.index = -1;
			targ.xvel = 0;
			targ.yvel = 0;
			targ.locked = 0;
		}
	}

	tp_ptr = &tp[64];

	for (i=0;i<64;i++,tp_ptr++)
	{
		if (tp_ptr->visible == -1)
			break;
		else if (tp_ptr->visible == 0)
			continue;

	   	atank = &helicopters[tp_ptr->index];

		if (atank->def && atank->def != REGENERATE_OBJECT)
		{
			if (tp_ptr->index == targ.index)
				continue;

			dist = atank->dist_from_player;

			for(j=0;j<4;j++)
			{
				if (ct[j].index == -1 || dist < helicopters[ct[j].index].dist_from_player)
				{
					for(k=4;k>j;k--)
					{
						ct[k].index = ct[k-1].index;
						ct[k].type = ct[k-1].type;
					}
					ct[j].index = tp_ptr->index;
					ct[j].type = HELI_TAG;
					break;
				}
			}
		}
	}

	if (targ.index == -1)
	{
		if (ct[target_no].index != -1)
		{
			targ.index = ct[target_no].index;
			targ.type = ct[target_no].type;
		}
		else
		{
			target_no = 0;
			targ.index = ct[0].index;
			targ.type = ct[0].type;
		}
	}

	if (targ.index != -1)
	{
		targ.dest_x = helicopters[targ.index].sx;
		targ.dest_y = helicopters[targ.index].sy;
	}
	else
	{
		targ.dest_x = TARGETX;
		targ.dest_y = TARGETY;
	}

	if (!targ.locked)
		update_target_pos();

}


void	do_sams_2(void)
{
 	scr_ptr = currentScreen;
 	sprite_y_clip = GSCRYHT;

	if (!targ.locked)
	{
		if (targ.index != -1)
			scale_sprite(targ.dest_x, targ.dest_y, 0x10000, LOCK_ON, 0, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
		scale_sprite(targ.x, targ.y, 0x10000, SAM_TARGET, 0, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
	}
	else
	{
		if (char_anim & 4)
			scale_sprite(targ.dest_x, targ.dest_y, 0x10000, SAM_LOCKED1, 0, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
		else
 			scale_sprite(targ.dest_x, targ.dest_y, 0x10000, SAM_LOCKED2, 0, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);

		targ.x = targ.dest_x;
		targ.y = targ.dest_y;
	}
}


/************************************************/

void update_target_pos(void)
{
	short	xlock = 0, ylock = 0;

	if (targ.dest_x > targ.x)
	{
 		if (targ.xvel < 0)
			targ.xvel >>= 1;

		if ((targ.dest_x - targ.x) <= targ.xvel)
			targ.xvel >>= 1;
		else if (targ.xvel < targ.max_xvel)
			targ.xvel++;

		if ((targ.x + targ.xvel - targ.dest_x) <= (targ.max_xvel >> 1) &&
				(targ.x + targ.xvel - targ.dest_x) >= 0)
		{
			targ.x = targ.dest_x;
			targ.xvel = 0;
			xlock = 1;
		}
	}
	else if (targ.dest_x < targ.x)
	{
		if (targ.xvel > 0)
			targ.xvel >>= 1;

		if ((targ.dest_x - targ.x) >= targ.xvel)
			targ.xvel >>= 1;
		else if (targ.xvel > -targ.max_xvel)
			targ.xvel--;

		if ((targ.x + targ.xvel - targ.dest_x) >= (-targ.max_xvel >> 1) &&
				(targ.x + targ.xvel - targ.dest_x) <= 0)
		{
			targ.x = targ.dest_x;
			targ.xvel = 0;
			xlock = 1;
		}
	}
	else
		xlock = 1;

	if (targ.dest_y > targ.y)
	{
		if (targ.yvel < 0)
			targ.yvel >>= 1;

		if ((targ.dest_y - targ.y) <= targ.yvel)
			targ.yvel >>= 1;
		else if (targ.yvel < targ.max_yvel)
			targ.yvel++;

		if ((targ.y + targ.yvel - targ.dest_y) <= (targ.max_yvel >> 1) &&
				(targ.y + targ.yvel - targ.dest_y) >= 0)
		{
			targ.y = targ.dest_y;
			targ.yvel = 0;
			ylock = 1;
		}
	}
	else if (targ.dest_y < targ.y)
	{
		if (targ.yvel > 0)
			targ.yvel >>= 1;

		if ((targ.dest_y - targ.y) >= targ.yvel)
			targ.yvel >>= 1;
		else if (targ.yvel > -targ.max_yvel)
			targ.yvel--;

		if ((targ.y + targ.yvel - targ.dest_y) >= (-targ.max_xvel >> 1) &&
				(targ.y + targ.yvel - targ.dest_y) <= 0)
		{
			targ.y = targ.dest_y;
			targ.yvel = 0;
			ylock = 1;
		}
	}
	else
		ylock = 1;

	targ.x += targ.xvel;
	targ.y += targ.yvel;

	if (xlock && ylock && targ.index != -1)
		targ.locked = 1;
}


/**************************************/

void fire_weapons(TANK *tank)
{
#ifdef PC_VERSION
#ifndef FLOPPY_VERSION
	/*Network only firepower*/
	if (NET_WEAPONS(tank))
		return;
#endif
#endif
	if (tank->cWeapon == WMAIN_GUN)
	{
		fire_shell(tank);
	}
	else if (tank->cWeapon == WCHAIN_GUN)
	{
		fire_bullet(tank);
	}
	else if (tank->cWeapon == WSAMS)
	{
		fire_sam(tank);
	}

/*-----------------06/10/95 11:36-------------------
 911 AIR SUPPORT - SMART BOMB
--------------------------------------------------*/
	else if (tank->cWeapon == W911B )
	{
		weaponsAvailable[W911B] = FALSE;								/* Offensive air support no longer available */
		start_message(NINE_MSG2);												/* 911 acknowledgement */
		draw_weapon_display(pl.cWeapon=WMAIN_GUN);      /* Gone back to the main cannon - delay before you can fire another shell */
		pl.shellDelayCount = pl.shellDelay;
		init_nine_air_support();
	}
}


/**************************************/

#define SHELL_START_HEIGHT		(-0X110)


void	fire_shell(TANK *tank)
{
	int	i, maxShells, owner, ownerType;
	SHELL_DATA *currentShell;

	if ( tank->shellDelayCount ) 		/* Cannot fire a shell yet */
		return;

	if ( tank->def == PLAYER_TANK )
	{
		currentShell= playerShells;
		maxShells = MAX_PLAYER_SHELLS;
		numShotsFired++;
		ownerType = PLAYER_TANK;
	}
	else
	{
		currentShell= enemyShells;
		maxShells = MAX_ENEMY_SHELLS;
		owner = tank - enemyTanks;
		ownerType = tank->def;
	}

	fire_shell_sound(tank);

	ownerType = tank->def;

	for ( i=0; i<maxShells; i++,currentShell++ )
	{
		if (!currentShell->fired)
		{
			currentShell->fired = 1;		/* Note shell has been fired */
			currentShell->x = (currentShell->ox=tank->x) + (0x80 * (int)(sintab[tank->angle]) );
			currentShell->y = tank->y + SHELL_START_HEIGHT;
			currentShell->z = (currentShell->oz=tank->z) + (0x80 * (int)(sintab[tank->angle+512]) );

			currentShell->dist_travelled = 0;
			currentShell->range = tank->shellRange;

			currentShell->direction = tank->angle;
			currentShell->speed = tank->shellSpeed;
			currentShell->owner = owner;
			currentShell->ownerType = ownerType;
			currentShell->damage = tank->shellDamage;

			tank->shellDelayCount = tank->shellDelay;

			if (tank->def == PLAYER_TANK)	/* Set recoil. */
			{
				tiltvel -= 128;
				currentShell->direction = (pl.angle+turret_angle)&0X7FF;
				currentShell->x = (currentShell->ox=tank->x) + (0x80 * (int)(sintab[ (pl.angle+turret_angle)&0X7FF]) );
				currentShell->z = (currentShell->oz=tank->z) + (0x80 * (int)(sintab[((pl.angle+turret_angle)&0X7FF)+0x200]) );
			}

			shunt_tank(tank, currentShell, TRUE);

			break;
		}
	}
}

/**************************************/


#define PLAYER_CGUN_DELAY	4

#define ENEMY_CHAINGUNE_TOO_HOT	  32
#define ENEMY_CHAINGUN_COOLED			96
#define HELICOPTER_GUN_SPAN				0x100
#define GUNSHIP_GUN_SPAN					0x1A0


void	fire_bullet(TANK *tank)
{
	int	i, maxbullets,ex,ez,px,pz,dx,dy,dz,spd,tdy, owner, ownerType;
	int	ey;
	struct	bullets	*bull_ptr;
	TANK	*entank;
	GUN_EMPLACEMENT	*ge;
	int	ochaingunheat=tank->chaingunHeat>>2;

	if ( tank==&pl )
	{
		if (playerChainCount)
			return ;
	}
	else
	if ((tank->shellDelayCount>>3)) 		/* Cannot fire a bullet yet. */
		return ;


	if ( tank->def!=PLAYER_TANK )
	{
		if(tank->chaingunHeat >= ENEMY_CHAINGUNE_TOO_HOT)
		{
			tank->chaingunHeat++;
			if ( tank->chaingunHeat >= ENEMY_CHAINGUN_COOLED )
			{
				tank->chaingunHeat=0;
			}
			return ;
		}
	}
	else
	{
		if ( tank->chaingunHeat >= CHAIN_GUN_TOO_HOT )
		{
			cgunBurstCount=0;
			if ( !playerCoolDelay )
			{
				playerCoolDelay=16;
			}
			return ;
		}
		else
			playerCoolDelay=0;
	}



	if (tank->def == PLAYER_TANK)
	{
		bull_ptr = &pl_bullets[0];
		maxbullets = MAX_PLAYER_SHELLS << 2;
		ownerType = PLAYER_TANK;
	}
	else
	if ( (tank->def == E_HELICOPTER) || (tank->def == E_GUNSHIP) )
	{
		bull_ptr= &en_bullets[0];
		maxbullets = MAX_ENEMY_SHELLS << 2;
		owner = tank - helicopters;
		ownerType = tank->def;

	}
	else
	{
		bull_ptr= &en_bullets[0];
		maxbullets = MAX_ENEMY_SHELLS << 2;
		owner = tank - enemyTanks;
		ownerType = tank->def;
	}




	for ( i=0; i<maxbullets; i++,bull_ptr++ )
	{
		if (!bull_ptr->on) 				/* Not fired? */
		{
			bull_ptr->on = 1;				/* Note bullet has been fired */

			chaingun_sound(tank);

			if ( tank->def == PLAYER_TANK)									/* Update the chaingun readout */
			{
				if (cgunBurstCount) cgunBurstCount--;

				tank->chaingunHeat+= (5-game_data.cgunupg);

				if ( tank->chaingunHeat > CHAIN_GUN_TOO_HOT )
				{
					tank->chaingunHeat = CHAIN_GUN_TOO_HOT;
				}

				if ( pl.chaingunHeat<4 )
				{
					if ( pl.chaingunHeat!=ochaingunheat )
					{
						draw_weapon_display(WCHAIN_GUN);
					}
				}
				else
				{
					if ( (ochaingunheat>>2) != (pl.chaingunHeat>>2) )
					{
						draw_weapon_display(WCHAIN_GUN);
					}
				}
			}
			else
				tank->chaingunHeat++;



			if ( tank->def == E_HELICOPTER )
			{
				bull_ptr->y = (tank->y << 16) + (0x1200000); // 0xf00000

 				bull_ptr->x = tank->x + (sintab[tank->angle]<<7);
				bull_ptr->z = tank->z + (sintab[tank->angle+0x200]<<7);

				switch ( char_anim&1 )
				{
					case 0:
						bull_ptr->x += (HELICOPTER_GUN_SPAN*(sintab[tank->angle+0x200]));
						bull_ptr->z -= (HELICOPTER_GUN_SPAN*(sintab[tank->angle]));
						break;

					case 1:
						bull_ptr->x -= (HELICOPTER_GUN_SPAN*(sintab[tank->angle+0x200]));
						bull_ptr->z += (HELICOPTER_GUN_SPAN*(sintab[tank->angle]));
						break;
				}

			}
			else if ( tank->def == E_GUNSHIP )
			{
				bull_ptr->y = (tank->y << 16) + (0x1700000); // 0xf00000

 				bull_ptr->x = tank->x + (sintab[tank->angle]<<7);
				bull_ptr->z = tank->z + (sintab[tank->angle+0x200]<<7);

				switch ( char_anim&1 )
				{
					case 0:
						bull_ptr->x += (GUNSHIP_GUN_SPAN*(sintab[tank->angle+0x200]));
						bull_ptr->z -= (GUNSHIP_GUN_SPAN*(sintab[tank->angle]));
						break;

					case 1:
						bull_ptr->x -= (GUNSHIP_GUN_SPAN*(sintab[tank->angle+0x200]));
						bull_ptr->z += (GUNSHIP_GUN_SPAN*(sintab[tank->angle]));
						break;
				}
			}
			else if ( tank->def != PLAYER_TANK )										/* APC */
			{
				bull_ptr->y = (tank->y << 16) - (0x1200000);
 				bull_ptr->x = tank->x + (sintab[tank->angle]<<7);
				bull_ptr->z = tank->z + (sintab[tank->angle+0x200]<<7);
			}
			else
			{
				bull_ptr->y = (tank->y << 16) - (0x1200000);
			}




			if (tank->def == PLAYER_TANK)
			{
				chgun_lr ^= 1;
				if (chgun_lr)
				{
					px = (int)((tank->x+(sintab[(tank->angle+0x20)&0x7ff]<<7)) >> 16);
					pz = (int)((tank->z+(sintab[(tank->angle+0x220)&0x7ff]<<7)) >> 16);
 					bull_ptr->x = tank->x+(sintab[(tank->angle+0x20)&0x7ff]<<7);
	 				bull_ptr->z = tank->z+(sintab[(tank->angle+0x220)&0x7ff]<<7);
				}
				else
				{
					px = (int)((tank->x+(sintab[(tank->angle-0x20)&0x7ff]<<7)) >> 16);
					pz = (int)((tank->z+(sintab[(tank->angle+0x1e0)&0x7ff]<<7)) >> 16);

 					bull_ptr->x = tank->x+(sintab[(tank->angle-0x20)&0x7ff]<<7);
	 				bull_ptr->z = tank->z+(sintab[(tank->angle+0x1e0)&0x7ff]<<7);
				}
			}
			else
			{
				px = (int)((tank->x+(sintab[tank->angle]<<7)) >> 16);
 				pz = (int)((tank->z+(sintab[tank->angle+0x200]<<7)) >> 16);
			}

			bull_ptr->dist_travelled = 0;
			bull_ptr->range = tank->shellRange;
			bull_ptr->speed = enemyShellSpeed[E_GUNEMPL];// + (rand() & 0x3ff);
			//bull_ptr->speed = tank->shellSpeed + (rand() & 0x3ff);
			bull_ptr->owner = owner;
			bull_ptr->ownerType = ownerType;

			if ( tank->def == PLAYER_TANK )
			{
			 	playerChainCount = playerChainReset;
			}
			else
				tank->shellDelayCount = tank->shellDelay>>2;


			if (tank->def == PLAYER_TANK && !targ.locked)
			{
				int	bulletAngle=(pl.angle+turret_angle)&0X7FF;

				bull_ptr->yvel = 0x40000 - (0x1000 - (rand()&0x1fff));
				bull_ptr->dir = (bulletAngle + (((160 - targ.x) * 7) >> 2) + (16-(rand()&0x1f))) & 0x7ff;

				ex = (int)((tank->x+( (int)sintab[bulletAngle]<<16)) >> 16);
 				ez = (int)((tank->z+( (int)sintab[bulletAngle+0x200]<<16)) >> 16);
				ey = -0x40;
				break;
			}
			else if (tank->def == PLAYER_TANK && targ.locked)
			{
				if (targ.type == TANK_TAG)
				{
					entank = &enemyTanks[targ.index];
 					ex = (int) (entank->x >> 16);
					ey = entank->y - 0x70;
					ez = (int) (entank->z >> 16);
				}
				else if (targ.type == HELI_TAG)
				{
					entank = &helicopters[targ.index];
 					ex = (int) (entank->x >> 16);
					ey = entank->y + 0x40;	/* MANSOOR - change this to whatever. */
					ez = (int) (entank->z >> 16);
				}
 				else
				{
					ge = &gunempls[targ.index];
 					ex = (int) (ge->x >> 16);
					ey = -0x40;
					ez = (int) (ge->z >> 16);
				}
			}
			else
			{
				entank = &pl;
				ex = (int) (entank->x >> 16);
//				ey = entank->y - 0x90;
				ey = entank->y - 0x80 + (rand()&0x1f);

				if ( (tank->def == E_HELICOPTER) ||  (tank->def == E_GUNSHIP) )
				{
					ey = entank->y - 0x200;
				}

 				ez = (int) (entank->z >> 16);
			}

 			bull_ptr->dir = (phd_atan((px-ex),(pz-ez)) + (16-(rand()&0x1f))) & 0x7ff;

			dx = (px - ex)<<16;
			tdy = dy = (tank->y - 0xF0) - ey;
			dz = (pz - ez)<<16;

			spd = (bull_ptr->speed >> 5) * ((int)sintab[bull_ptr->dir]);
			spd += (bull_ptr->speed >> 5) * ((int)sintab[bull_ptr->dir + 512]);

			dx += dz;
			if (spd == 0)
				spd = 1;
			dx /= spd;	/* Number of bullet updates to target. */
			dy <<= 16;
			if (dx == 0)
				dx = 1;
			dy /= dx;

 			if((tdy > 0 && dy > 0) || (tdy <= 0 && dy < 0))
				dy = -dy;

			bull_ptr->yvel = dy;
			break;
		}
	}
}



#define CHAIN_GUN_BURST_LENGTH	12
#define CHAIN_GUN_BURST_DELAY		(CHAIN_GUN_BURST_LENGTH+48)

void	gunempl_fire_bullet(GUN_EMPLACEMENT *fgunempl, TANK *entank)
{
	int	i, maxbullets,ex,ez,px,pz,dx,dy,dz,spd,tdy, owner, ownerType;
	int	ey;
	struct	bullets	*bull_ptr;

	if (fgunempl->shellDelayCount) 		/* Cannot fire a bullet yet. */
		return;

	if (fgunempl->burstCount>CHAIN_GUN_BURST_LENGTH )
	{
		update_gunempl_chaingun_count(fgunempl);

		fgunempl->burstCount++;
		if ( fgunempl->burstCount>CHAIN_GUN_BURST_DELAY )
		{
			fgunempl->burstCount=0;
		}
		return ;
	}
	else
	{
		fgunempl->burstCount++;
	}


	bull_ptr= en_bullets;
	maxbullets = MAX_ENEMY_SHELLS << 2;
	owner = fgunempl - gunempls;
	ownerType = E_GUNEMPL;

	for ( i=0; i<maxbullets; i++,bull_ptr++ )
	{
		if (!bull_ptr->on) 	/* Not fired? */
		{
			bull_ptr->on = 1;		/* Note shell has been fired */
			bull_ptr->y = -0x700000;

			gunempl_chaingun_sound(fgunempl);

			px = (int)((fgunempl->x+(sintab[fgunempl->angle]<<7)) >> 16);
			pz = (int)((fgunempl->z+(sintab[fgunempl->angle+0x200]<<7)) >> 16);
			bull_ptr->x = fgunempl->x+(sintab[fgunempl->angle]<<7);
			bull_ptr->z = fgunempl->z+(sintab[fgunempl->angle+0x200]<<7);

			bull_ptr->dist_travelled = 0;
			bull_ptr->range = enemyShellRanges[E_GUNEMPL];
			bull_ptr->speed = enemyShellSpeed[E_GUNEMPL] + (rand() & 0x1ff);
			bull_ptr->owner = owner;
			bull_ptr->ownerType = ownerType;

			fgunempl->shellDelayCount = enemyShellDelays[E_GUNEMPL]>>2;

			ex = (int) (entank->x >> 16);
			ey = entank->y - 0x100;
			ez = (int) (entank->z >> 16);

 			bull_ptr->dir = (phd_atan((px-ex),(pz-ez)) + (32-(rand()&0x3F))) & 0x7ff;

			dx = (px - ex)<<16;
			tdy = dy = - 0x100 - ey;
			dz = (pz - ez)<<16;

			spd = (bull_ptr->speed >> 5) * ((int)sintab[bull_ptr->dir]);
			spd += (bull_ptr->speed >> 5) * ((int)sintab[bull_ptr->dir + 512]);

			dx += dz;
			if (spd == 0)
				spd = 1;
			dx /= spd;	/* Number of bullet updates to target. */
			dy <<= 16;
			if (dx == 0)
				dx = 1;
			dy /= dx;

 			if((tdy > 0 && dy > 0) || (tdy <= 0 && dy < 0))
				dy = -dy;

			bull_ptr->yvel = dy;
			break;
		}
	}
}



void	gunboat_fire_bullet(GUN_BOAT *fgunboat, TANK *entank)
{
	int	i, maxbullets,ex,ez,px,pz,dx,dy,dz,spd,tdy, owner, ownerType;
	int	ey;
	struct	bullets	*bull_ptr;

	if (fgunboat->shellDelayCount) 		/* Cannot fire a bullet yet. */
		return;

	if (fgunboat->burstCount>CHAIN_GUN_BURST_LENGTH )
	{
		update_gunempl_chaingun_count(fgunboat);		// this is a macro

		fgunboat->burstCount++;
		if ( fgunboat->burstCount>CHAIN_GUN_BURST_DELAY )
		{
			fgunboat->burstCount=0;
		}
		return ;
	}
	else
	{
		fgunboat->burstCount++;
	}


	bull_ptr= en_bullets;
	maxbullets = MAX_ENEMY_SHELLS << 2;
	owner = fgunboat - gunboats;
	ownerType = GUNBOAT_TAG;

	for ( i=0; i<maxbullets; i++,bull_ptr++ )
	{
		if (!bull_ptr->on) 	/* Not fired? */
		{
			bull_ptr->on = 1;		/* Note shell has been fired */
			bull_ptr->y = -0x2400000;

			gunboat_chaingun_sound(fgunboat);

			px = (int)((fgunboat->x+(sintab[fgunboat->angle]<<7)) >> 16);
			pz = (int)((fgunboat->z+(sintab[fgunboat->angle+0x200]<<7)) >> 16);
			bull_ptr->x = fgunboat->x+(sintab[fgunboat->angle]<<7);
			bull_ptr->z = fgunboat->z+(sintab[fgunboat->angle+0x200]<<7);

			bull_ptr->dist_travelled = 0;
			bull_ptr->range = enemyShellRanges[ENEMY_GUNBOAT];
			bull_ptr->speed = enemyShellSpeed[ENEMY_GUNBOAT] + (rand() & 0x1ff);
			bull_ptr->owner = owner;
			bull_ptr->ownerType = ownerType;

			fgunboat->shellDelayCount = enemyShellDelays[ENEMY_GUNBOAT]>>2;

			ex = (int) (entank->x >> 16);
//			ey = entank->y - 0x100;
			ey = entank->y + 0x40;
			ez = (int) (entank->z >> 16);

 			bull_ptr->dir = (phd_atan((px-ex),(pz-ez)) + (16-(rand()&0x1f))) & 0x7ff;

			dx = (px - ex)<<16;
			tdy = dy = - 0x100 - ey;
			dz = (pz - ez)<<16;

			spd = (bull_ptr->speed >> 5) * ((int)sintab[bull_ptr->dir]);
			spd += (bull_ptr->speed >> 5) * ((int)sintab[bull_ptr->dir + 512]);

			dx += dz;
			if (spd == 0)
				spd = 1;
			dx /= spd;	/* Number of bullet updates to target. */
			dy <<= 16;
			if (dx == 0)
				dx = 1;
			dy /= dx;

 			if((tdy > 0 && dy > 0) || (tdy <= 0 && dy < 0))
				dy = -dy;

			bull_ptr->yvel = dy;
			break;
		}
	}
}






void	fire_sam(TANK *tank)
{
	int	i;
	struct	sams	*sam_ptr;

	if (tank->shellDelayCount || !targ.locked) 		/* Cannot fire a sam yet. */
		return;

	if ( game_data.nsams<=0 )
	{
		return ;
	}

	for ( i=0,sam_ptr=sam; i<MAX_SAMS; i++,sam_ptr++ )
	{
		if (sam_ptr->fired && sam_ptr->index==targ.index ) 	// sam has already been launched at target
			return ;
	}

	game_data.nsams--;
	weaponsAvailable[WSAMS] = game_data.nsams;

	if ( !weaponsAvailable[WSAMS] )
	{
		while ( !weaponsAvailable[pl.cWeapon] )
		{
			pl.cWeapon = (pl.cWeapon+1)%MAX_WEAPONS;
		}
		draw_weapon_display(pl.cWeapon);
	}

	draw_weapon_display(WSAMS);

	for ( i=0, sam_ptr=sam; i<MAX_SAMS; i++,sam_ptr++ )
	{
		if (!sam_ptr->fired) 	/* Not fired? */
		{
			tank->shellDelayCount = tank->shellDelay>>1;

			sam_ptr->fired = 1;		/* Note sam has been fired */
			sam_ptr->x = tank->x;
			sam_ptr->y = tank->y-224;
			sam_ptr->z = tank->z;
			sam_ptr->yvel = -0x20000;
			sam_ptr->speed = 0;
			sam_ptr->dir = sam_ptr->angle = (pl.angle+turret_angle)&0X7FF;
			sam_ptr->index = targ.index;

			play_launch_sam_sound();

			break;
		}
	}
}

/**************************************/

/****************************
* Sprite draw, no clipping. *
****************************/

void	draw_sprite(int xpos, int ypos, int def, uchar *gfx, uchar *net)
{
	int		numspr , xoff , yoff ;
	int		*netptrl ;
	short	*netptrs ;

	netptrs = (short*)( net + (def*2) + 2 ) ;
	netptrs = (short*)( net + *netptrs ) ;

	numspr = *netptrs++ ;

	xoff = *netptrs++ ;
	yoff = *netptrs++ ;

	netptrl = (int*)netptrs ;
 	g_addr =  (uchar*)(*netptrl + gfx ) ;

	spb.t_scr_xpos = xpos + xoff ;
	spb.t_scr_ypos = ypos + yoff ;

	if (spb.t_scr_xpos > 16 && spb.t_scr_xpos < 304 &&
			spb.t_scr_ypos > 16 && spb.t_scr_ypos < 144)
		_generic_spr(&spb);
}

void	process_visible_enemies()
{
	long		i;
	uchar	*tscrptr;
 	scr_ptr = currentScreen;

	for (i=0;i<64;i++)
	{
		if (tp[i].visible == -1)			/* End of list? */
		{
			tp[i+64].visible = -1;
			break;
		}

		tp[i+64].type = tp[i].type;       	/* Type of baddie. */
		tp[i+64].index = tp[i].index;		/* Index into structure of baddie. */

		tscrptr = scr_ptr + tp[i].scr_off;	/* Get screen address of targeting pixel. */
		if (*tscrptr == BULLET_COL)
		{
			tp[i+64].visible = 1;
			*tscrptr = *(tscrptr + 1);	/* Remove targeting pixel. */
		}
		else
			tp[i+64].visible = 0;
	}
}

/**************************************/


