#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/************************************************************************/
/* palbuf is a (char)buffer containing original palette data (R,G,B)    */
/* hsvbuffer is a (float)buffer to stash data into (H,S,V)              */
/************************************************************************/

//#define max3(a,b,c) max((max(a,b)),c)
//#define min3(a,b,c) min((min(a,b)),c)

float		max3(float v1, float v2, float v3);
float		min3(float v1, float v2, float v3);

void		alter_palette(char *palin, char *palout, int deltaS, int deltaV);
void		convert_palette_to_hsv(char *palbuf);
void		make_palette_from_hsv(char *palbuf);

void		convert_rgb_to_hsv	(int red, int green, int blue, float *hsvptr);
void		convert_hsv_to_rgb(float h, float s, float v, char *palbuf);

int			sortcol(int val);
int			unsortcol(int val);

int			roundme(float num);


void	debug_msg(char *format, ...);

/************************************************************************/
/************************************************************************/
/************************************************************************/
float		hsvbuffer[768];


/************************************************************************/
/************************************************************************/
/************************************************************************/

void		alter_palette(char *palin, char *palout, int deltaS, int deltaV)
{
	int	i;
	int	deltaVal;
	int	newval;
	unsigned char	*palptr;
	float	*hsvptr, deltaSat;

	convert_palette_to_hsv(palin);

	hsvptr = hsvbuffer+1;

	deltaSat=deltaS-32;
	deltaSat/=128;

	// Change the colour saturation of the palette

	for ( i=0; i<0x100; i++,hsvptr+=3 )
	{
		*hsvptr += deltaSat;

		if ( *hsvptr<0 )
		{
			*hsvptr=0;
		}
		if ( *hsvptr>1 )
		{
			*hsvptr=1;
		}
	}

	make_palette_from_hsv(palout);


	// change the brightness of the palette

	deltaVal = (deltaV-32)>>2;

	for ( i=0, palptr=palout; i<0x300; i++ )
	{
		newval = (int)(((unsigned int)(*palptr))+deltaVal);

		if ( newval<0 )
		{
			newval=0;
		}

		if ( newval>63 )
		{
			newval=63;
		}

		*palptr=(unsigned char)newval;
		palptr++;
	}
}




void		convert_palette_to_hsv(char *palbuf)
{
int			i;
int			r,g,b;
float		*hsvptr;

	hsvptr=hsvbuffer;

	for (i=0; i<0x100; i++)
	 	{
		r = sortcol( *(palbuf++) );		/* get RED as value 0-100 */
		g = sortcol( *(palbuf++) );		/* get GREEN as value 0-100 */
		b = sortcol( *(palbuf++) );		/* get BLUE as value 0-100 */
		convert_rgb_to_hsv(r,g,b, hsvptr);	/* convert to HSV */
		hsvptr += 3;					/* next position in hsvbuf */
		}
	return;
}



/**************************************/
/** Convert RGB values to HSV values **/
/**************************************/
/** Converted from some CACK pascal code in my RED COMPUTER GFX BOOK! */
/** after about 35 mins of pissing around (I don't actually know pascal!) */
/** I sussed what the fuck was going on! (DEL - 30/06/94) */
/**********************************************************/
/* convert_rgb_to_hsv(red,green,blue) */
/* RGB values must be 0-100 */


void		convert_rgb_to_hsv	(int red, int green, int blue, float *hsvptr)

{
float		r,g,b;
float		h,s,v;
float		m,rl,gl,bl;

	r = (float) red/100;
	g = (float) green/100;
	b = (float) blue/100;

	v = max3(r,g,b);					/* set V */
	m = min3(r,g,b);

	if (v != 0)
		{
		s = (v-m)/v;
		}
	else
		{
		s = 0;	  					/* set S */
		}


	if (s != 0)
		{
		rl = (v - r) / (v - m);			/* distance of col from red */
		gl = (v - g) / (v - m);			/* distance of col from green */
		bl = (v - b) / (v - m);			/* distance of col from blue */

		if (v == r)
			{
			if (m == g)
				{
				h = (5.0 + bl);
				}
			else
				{
				h = (1.0 - gl);
				}
			}

		if (v == g)
			{
			if (m == b)
				{
				h = (1.0 + rl);
				}
			else
				{
				h = (3.0 - bl);
				}
			}

		if ( (v != r) && (v != g) )		/* if above two cases not met */
			{
			if (m == r)
				{
				h = (3.0 + gl);
				}
			else
				{
				h = (5.0 - rl);
				}
			}


		h *= 60.0;					/* convert to degrees */
		if ( h == 360)					/* 360 degrees? */
			{
			h = 0;					/* zero degrees! */
			}
		}

	else
		{
		h = 0;						/* h is undefined */
		}

	*hsvptr++ = h;						/* stash HUE */
	*hsvptr++ = s;						/* stash SATURATION */
	*hsvptr++ = v;						/* stash VALUE */

	return;
}



/************************************************************************/
/* make palette from HSV values!                                        */
/************************************************************************/
/* hsvbuffer is a (float)buffer containing HSV data!                    */
/* palbuf is a (char)buffer to stash RGB palette in!                    */
/************************************************************************/


void		make_palette_from_hsv(char *palbuf)

{
float		h,s,v;
int			i;
float		*hsvptr=hsvbuffer;

	for (i=0; i<0x100; i++)
		{
		h = *(hsvptr++);			/* get HUE */
		s = *(hsvptr++);			/* get SATURATION */
		v = *(hsvptr++);			/* get VALUE */

		convert_hsv_to_rgb(h, s, v, palbuf);
		palbuf += 3;

		}

	return;
}



/***********************/
/** HSV TO RGB VALUES **/
/***********************/
/*** Ok... Del is really on form now..! let's see if we can convert the */
/*** values back from HSV to RGB... (sounds easy...? well it is actually) */
/**************************************************************************/
/** working at 09:43am 01/07/94 **/
/*********************************/

void		convert_hsv_to_rgb(float h, float s, float v, char *palbuf)
{
float		r,g,b;
float		p1,p2,p3;
float		f;
int			i;

int		cock;


	if ( h == 360 )
		{
		h = 0;
		}
	h = h / 60.0;	  				/* convert h from degrees */

	i = floor(h);						/* i = greatest integer <=h */
	f = (float) (h - i);		/* f = fractional part of h */

	p1 = v * (1.0 - s);
	p2 = v * (1.0 - (s * f));
	p3 = v * (1.0 - (s * (1.0 - f)));


	switch (i)
		{
		case (0):
			{
			r = v;
			g = p3;
			b = p1;
			break;
			}

		case (1):
			{
			r = p2;
			g = v;
			b = p1;
			break;
			}

		case (2):
			{
			r = p1;
			g = v;
			b = p3;
			break;
			}

		case (3):
			{
			r = p1;
			g = p2;
			b = v;
			break;
			}

		case (4):
			{
			r = p3;
			g = p1;
			b = v;
			break;
			}

		case (5):
			{
			r = v;
			g = p1;
			b = p2;
			break;
			}

		}


	cock = roundme(r*100);
	cock = unsortcol(cock);
	*palbuf++ = (char)cock;

	cock = roundme(g*100);
	cock = unsortcol(cock);
	*palbuf++ = (char)cock;

	cock = roundme(b*100);
	cock = unsortcol(cock);
	*palbuf++ = (char)cock;				/* stash cols in buffer */

	return;
}

/***********************************************************/
/* SORTCOL(val)                                            */
/***********************************************************/
/* sorts colours to be DPAINT 0-100 style from 0-63        */
/***********************************************************/

int			sortcol(int val)
{
	float	piss;

//	debug_msg("%d->",val);
	if (val != 0)					/* colour not zero? */
		{
		val++;					/* colour + 1 */
		}
	piss = (float)val;
	piss = (piss*100.0)/64.0;		/* multiply by 100 and divide by 64 */
	val = roundme(piss);			/* round colour to nearest! */

//	debug_msg("%d ",val);

	return(val);					/* return colour as 0-100 */
}


/***********************************************************/
/* UNSORTCOL(val)                                          */
/***********************************************************/
/* sorts colours to be 0-63 from DPAINT 0-100 style        */
/***********************************************************/

int			unsortcol(int val)
{
	if (val != 0)					/* colour not zero? */
		{
		val--;					/* colour - 1 */
		}
	val *= 64;					/* multiply by 64 */
	val /= 100;					/* divide by 100 */

	return(val);					/* return colour as 0-63 */
}

/***************************************************/
/* round floating point figure to nearest integer! */
/***************************************************/
/* not built for min3us numbers really is it DEL??! */
/***************************************************/

int			roundme(float num)
{
	float		f;

	f=num+0.5;
	return((int)f);

//	i = floor(num);				/* i = greatest integer <=num */
//	f = num - i;					/* f = fractional part of num */
//	if ( f >= 0.5 )
//		{
//		i++;						/* round int up a digit! */
//		}
//	return(i);					/* return integer */
}



/****************************/
/* Del's handy max routine? */
/****************************/


float		max3(float v1, float v2, float v3)
{
	float		max3;

	max3 = (v1 > v2) ? v1 : v2;		/* max3 = biggest v1 or v2 */
	max3 = (max3 > v3) ? max3 : v3;		/* max3 = biggest max or v3 */
	return(max3);
}

/****************************/
/* Del's handy min routine? */
/****************************/

float		min3(float v1, float v2, float v3)
{
	float		min3;

	min3 = (v1 < v2) ? v1 : v2;		/* min3 = smallest v1 or v2 */
	min3 = (min3 < v3) ? min3 : v3;		/* min3 = smallest min or v3 */
	return(min3);
}


