#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <dpmi.h>
#include <go32.h>
#include <pc.h>
#include <math.h>
#include <sys\farptr.h>
#include "sb_lib.h"
#include "sbdetect.h"
#include "sb_misc.h"
#include "allegro.h"       /* Allegro game programming library header file */
#include "shuffle.h"             /* Contains information about SHUFFLE.DAT */ 
typedef struct                     /* Contains information for each player */
{
   int old_x, old_y, x, y, speed_x, speed_y, score, device;
   BITMAP *bat, *progress;
}  player;
void mixingDemo(void);
void modDemo(void);
sb_sample *sample[2];
sb_mod_file *mod;
sb_status stat;
player one, two, ball;
long frame_count = 10;                     /* Incremented by 1 every cycle */
volatile int game_time = 1;               /* Incremented by 1 every second */
FILE *fp;                         /* File pointer used only in debug mode  */
int goal_dist = 30;                  /* Half distance goal posts are apart */
int exit_loop = 0;                           /* Used for exiting main loop */
int debug = 0;                               /* Used to control debug mode */
int game_speed = 10;                       /* Speed at which the game goes */
int sound_on = 1;                                 /* Used to control sound */
int t = 0;                            /* Used for fade in routine at start */
int show_frame = 1;                  /* Used to control frequency of draws */
int redo = 0;                               /* Used to control spin effect */
int score_max = 11;                     /* Represents score to play to - 1 */
char score_buf[80], c;            /* Used to show fps & also in debug mode */
double const pi = 3.14159265;       /* Used for angles (angles are in rad) */
int just_hit = 0;                    /* Used to help prevent repeated hits */
double fps = 20;                 /* Used to calc the fps rate & control speed */
BITMAP *active_page, *page1, *page2, *page3; /* Current & sub page bitmaps */
BITMAP *end1, *end2, *shrink, *rotate;                     /* Misc bitmaps */
DATAFILE *datafile;                            /* Used to read shuffle.dat */
void game_timer()               /* This function increments game_time by 1 */
{                               /* and is called every 1000ms (1 second)   */
   game_time++;                 /* so that the fps rate can be calculated  */
}
END_OF_FUNCTION(game_timer);
double too_circle(double x, double y)     /* Used by ball_interaction to   */
{                                         /* calculate whole circle angles */
   double temp_angle;
   if(y != 0) temp_angle = atan(x/y);
      else if(x < 0) return(3*pi/2);
         else return(pi);
   if(y > 0) return(pi - temp_angle);
   if(x > 0) return(   0 - temp_angle);
   if(x < 0) return(pi*2 - temp_angle);
   return(temp_angle);
}
void main(int argc, char *argv[])
{
   int too_close = 0;             /* Postive if ball is too close to a bat */
   int x, y, w = 0, an_pos = 0, an_dir = 1;
   int word = 0;                  /* Stores which word should be displayed */
   int human_speed, computer_speed;       /* Variables storing max. speeds */
   int show_const = 2;            /* Controls how often the graphics drawn */
   int serve = 0;                /* 0 - Player 1 serve, 1 - Player 2 serve */
   int boris = 0;           /* Helps calculate when the word should change */
   int smiley = 0;              /* Controls whether smiley face is showing */
   int eofscore;
   char *message[] =            /* Contains message shown during game play */
   {
      "this","game","is","coming","to","you","all","the","way","from","nz",
      "i","made","it","to","try","out","djgpp","with","the","allegro",
      "library","thanx","to","the","dudes","who","made","them","hope","you",
      "enjoy","playing","this","anyone","with","some","better","routine",
      "for","making","the","balls","bounce","right","is","welcome","to",
      "donate","it","to","me","my","email","address","is","michael","dot",
      "bevin","at","stone","bow","dot","otago","dot","ac","dot","nz","",
      "god","bless","you","all","","james","4;8","draw","near","to","god",
      "and","he","will","draw","near","to","you","","that","verse","came",
      "to","you","from","the","bible","which","is","the","word","of","god",
      "amen","",NULL
   };
   for(x=1;x<argc;x++) {
   if(!strcmp(argv[x], "-1")) show_const = 1;
   if(!strcmp(argv[x], "-2")) show_const = 3;
   if(!strcmp(argv[x], "-3")) show_const = 4;
   if(!strcmp(argv[x], "-n")) sound_on = 0;
   if(!strcmp(argv[x], "-d")) {debug = 1;fp=fopen("data.dat","wb");}
   if(!strcmp(argv[x], "-s1")) game_speed = 5;
   if(!strcmp(argv[x], "-s2")) game_speed = 15;
   if(!strcmp(argv[x], "-s3")) game_speed = 20;
   }
   init();
   install_int(game_timer, 1000);
   intro();
restart:
   frame_count *= (2.3 * show_const);
   if(two.device < 3) serve = 1;
   if(one.device < 3) serve = 0;
   if((two.device < 3 && one.device < 3) || (two.device > 2 && one.device > 2)) serve = rand() % 2;
   if(!serve) {ball.x=16000; ball.y=14000;}
   if(serve) {ball.x=16000; ball.y=6000;} 
   if(smiley) draw_compiled_sprite(page3, datafile[BITMAP_007].dat, 0, 0);
   else draw_compiled_sprite(page3, datafile[BITMAP_002].dat, 0, 0);
   while(!key[KEY_ESC] && !exit_loop)
   {
      human_speed=1000*fps; frame_count++; show_frame--;
      if(just_hit) just_hit--;
      w--; if(w < 0) w = 0;
      if((ball.y+ball.speed_y) >= 16900) {
        if((ball.speed_x*(16900-ball.y))/ball.speed_y+ball.x > 16000-goal_dist*100 
        && (ball.speed_x*(16900-ball.y))/ball.speed_y+ball.x < 16000+goal_dist*100 ) {
           if(sound_on) sb_mix_sample(sample[1]);
           if (serve==1) two.score++;
              else serve=1;
           if(two.score == score_max+1) {exit_loop = 2; two.score = 0;}
           else {
              ball.x=16000; ball.y=6000;
              ball.speed_x=0; ball.speed_y=0;
              one.x = 16000; one.y = 16900; two.speed_x = 0; two.speed_y = 0; 
              two.x = 16000; two.y = 3000; one.speed_x = 0; one.speed_y = 0;
           }
        }
        else {
           ball.speed_y *= -0.95;
           if(sound_on) {
              sample[0]->left_volume=20;
              sample[0]->right_volume=20;
              sb_mix_sample(sample[0]);
           }
        }
      }
      if ((ball.y+ball.speed_y) <= 3000) {
        if((ball.speed_x*(3000-ball.y))/ball.speed_y+ball.x > 16000-goal_dist*100 
        && (ball.speed_x*(3000-ball.y))/ball.speed_y+ball.x < 16000+goal_dist*100 ) {
           if(sound_on) sb_mix_sample(sample[1]);
           if (serve==0) one.score++;
              else serve=0;
           if(one.score == score_max+1) {exit_loop = 1; one.score = score_max;}
           else {
              ball.x=16000; ball.y=14000;
              ball.speed_x=0; ball.speed_y=0;
              one.x = 16000; one.y = 16900; two.speed_x = 0; two.speed_y = 0; 
              two.x = 16000; two.y = 3000; one.speed_x = 0; one.speed_y = 0;
           }
        }
        else {
           ball.speed_y *= -0.95;
           if(sound_on) {
              sample[0]->left_volume=20;
              sample[0]->right_volume=20;
              sb_mix_sample(sample[0]);
           }
        }
      }
      if((ball.x+ball.speed_x) >= 22900 || (ball.x+ball.speed_x) <= 9000) {
         ball.speed_x*=-0.95;
         if(sound_on) {
            sample[0]->left_volume=20;
            sample[0]->right_volume=20;
            sb_mix_sample(sample[0]);
         }
     }
      ball.x += ball.speed_x; ball.y += ball.speed_y;
      switch(one.device)
      {
         case 0 :
            one.speed_x+=(mouse_x-100)*4*(game_speed/fps)*(game_speed/fps)*show_const;
            one.speed_y+=(mouse_y-100)*4*(game_speed/fps)*(game_speed/fps)*show_const;
            if(one.speed_x > human_speed) one.speed_x = human_speed;
            else if(one.speed_x < -human_speed) one.speed_x = -human_speed;
            if(one.speed_y > human_speed) one.speed_y = human_speed;
            else if(one.speed_y < -human_speed) one.speed_y = -human_speed;
            break;
         case 1 :
            if(key[KEY_UP])    one.speed_y = -human_speed;
            if(key[KEY_DOWN])  one.speed_y = human_speed;
            if(key[KEY_RIGHT]) one.speed_x = human_speed;
            if(key[KEY_LEFT])  one.speed_x = -human_speed;
            break;
         case 2 :
            if(key[KEY_W]) one.speed_y = -human_speed;
            if(key[KEY_X] || key[KEY_S]) one.speed_y = human_speed;
            if(key[KEY_D]) one.speed_x = human_speed;
            if(key[KEY_A]) one.speed_x = -human_speed;
            break;
         case 3 :  computer_speed=150*fps;
            break;
         case 4 :  computer_speed=300*fps;
            break;
         case 5 :  computer_speed=450*fps;
            break;
         default : computer_speed=700*fps;
      }
      if(one.device > 2) {
         if(one.x > ball.x && one.x > 9000) one.speed_x = -computer_speed;
         if(one.x < ball.x && one.x < 22900) one.speed_x = computer_speed;
         if(one.y > ball.y && ball.y > 10000) one.speed_y = -computer_speed;
         if(one.y < 16900 && (ball.y < 10000 || one.y < ball.y+1000)) one.speed_y = computer_speed;
         if(abs(one.x-ball.x) < 500 && ball.y < 10000) one.speed_x=computer_speed/2*(rand() % 3 - 1);
         if(abs(ball.x-16000) > 10000 && ball.y > 10900) {one.speed_x = -one.speed_x;one.speed_y = -one.speed_y;}
      }
      switch(two.device)
      {
         case 0 :
            two.speed_x+=(mouse_x-100)*(game_speed/fps)*8*show_const;
            two.speed_y+=(mouse_y-100)*(game_speed/fps)*8*show_const;
            if(two.speed_x > human_speed) two.speed_x = human_speed;
            else if(two.speed_x < -human_speed) two.speed_x = -human_speed;
            if(two.speed_y > human_speed) two.speed_y = human_speed;
            else if(two.speed_y < -human_speed) two.speed_y = -human_speed;
            break;
         case 1 :
            if(key[KEY_UP])    two.speed_y = -human_speed;
            if(key[KEY_DOWN])  two.speed_y = human_speed;
            if(key[KEY_RIGHT]) two.speed_x = human_speed;
            if(key[KEY_LEFT])  two.speed_x = -human_speed;
            break;
         case 2 : 
            if(key[KEY_W]) two.speed_y = -human_speed;
            if(key[KEY_X] || key[KEY_S]) two.speed_y = human_speed;
            if(key[KEY_D]) two.speed_x = human_speed;
            if(key[KEY_A]) two.speed_x = -human_speed;
            break;
         case 3 :  computer_speed=150*fps;
            break;
         case 4 :  computer_speed=300*fps;
            break;
         case 5 :  computer_speed=450*fps;
            break;
         default : computer_speed=700*fps;
      }
      if(two.device > 2) {
         if(two.x > ball.x && two.x > 9000) two.speed_x = -computer_speed;
         if(two.x < ball.x && two.x < 22900) two.speed_x = computer_speed;
         if(two.y < ball.y && ball.y < 10000) two.speed_y = computer_speed;
         if(two.y > 3000 && (ball.y > 10000 || two.y > ball.y-1000)) two.speed_y = -computer_speed;
         if(abs(two.x-ball.x) < 500 && ball.y > 10000) two.speed_x=computer_speed/2*(rand() % 3 - 1);
         if(abs(ball.x-16000) > 10000 && ball.y < 9000) {two.speed_x = -two.speed_x;two.speed_y = -two.speed_y;}
      }
      if(!two.device || !one.device) position_mouse(100,100);
      one.x+=one.speed_x; one.y+=one.speed_y;
      two.x += two.speed_x; two.y += two.speed_y;
      if(two.x < 9000) two.x = 9000; 
      else if(two.x > 22900) two.x = 22900;
      if(two.y < 3000) two.y = 3000;
      else if(two.y > 9000) two.y = 9000;
      if(one.x < 9000) one.x = 9000;
      else if(one.x > 22900) one.x = 22900;
      if(one.y < 11000) one.y = 11000;
      else if(one.y > 16900) one.y = 16900;
      ball_interaction(one.x,one.y,one.speed_x,one.speed_y);
      ball_interaction(two.x,two.y,two.speed_x,two.speed_y);
      if(too_close) too_close--;
      if ( (one.x-ball.x)*(one.x-ball.x) + (one.y-ball.y)*(one.y-ball.y)
      < 3600000 && too_close < 6) {
         one.x = one.old_x;
         one.y = one.old_y;
         ball.x = ball.old_x;
         ball.y = ball.old_y;
         ball.speed_x *= 1.4;
         ball.speed_y *= 1.4;
         too_close += 2;
      }
      if ( (two.x-ball.x)*(two.x-ball.x) + (two.y-ball.y)*(two.y-ball.y) 
      < 3600000 && too_close < 6) {
         two.x = two.old_x;
         two.y = two.old_y;
         ball.x = ball.old_x;
         ball.y = ball.old_y;
         ball.speed_x *= 1.4;
         ball.speed_y *= 1.4;
         too_close += 2;
      }
      one.speed_x = 0; one.speed_y = 0; two.speed_x = 0; two.speed_y = 0;
      if(!show_frame) {
      show_frame=show_const;
      if (key[KEY_F]) {                                             
         sprintf(score_buf, "%d", (int)((game_speed/fps)/show_const));
         draw_word(1,1,score_buf,205);
      }
      set_clip(active_page, 80, 20, 239, 179);
      blit(page3, active_page, 0, 0, 80, 20, 160, 160); 
      if(!smiley && game_time % 5 == 0 && boris != game_time) {
          boris = game_time; 
          draw_word((rand() % (160-strlen(message[word])*20)),
          (rand() % 140), message[word], 201);
          word++;
          if(word > 103) {
             smiley = 1;
             draw_compiled_sprite(page3, datafile[BITMAP_007].dat, 0, 0);
          }
      }
      if(!w) {
         an_pos += an_dir; if (an_pos > 150) an_dir=-1; if (an_pos < 1) an_dir=1;
         fps=(double)game_speed/((double)frame_count/game_time);
         clear(one.progress); clear(two.progress);
        if(!sb_mod_active) sb_mod_play(mod);
         blit(datafile[BITMAP_004].dat, one.progress, an_pos, 0, 0, 0, 160-(11-score_max)*14, 15);
         blit(datafile[BITMAP_004].dat, two.progress, 150-an_pos, 0, 0, 0, 160-(11-score_max)*14, 15);
         drawing_mode(DRAW_MODE_COPY_PATTERN, datafile[BITMAP_003].dat, 150-an_pos, 0);
         for (x=0; x<two.score; x++) {
            circlefill(two.progress, (x*14) + 10, 7, 5, 1);
         }
         drawing_mode(DRAW_MODE_COPY_PATTERN, datafile[BITMAP_003].dat, an_pos, 0);
         circlefill(one.bat, 10, 10, 10, 0);
         for (x=0; x<one.score; x++) {
            circlefill(one.progress, (x*14) + 10, 7, 5, 1);
         }
         solid_mode();
         draw_sprite(one.progress, end1, 0, 0); draw_sprite(two.progress, end1, 0, 0);
         floodfill(one.progress, 1, 1, 0);      floodfill(two.progress, 1, 1, 0);
         floodfill(one.progress, 1, 14, 0);     floodfill(two.progress, 1, 14, 0);
         eofscore = 14 * score_max + 5;
         draw_sprite(one.progress, end2, eofscore-7, 0); draw_sprite(two.progress, end2, eofscore-7, 0);
         floodfill(one.progress, eofscore, 1, 0);        floodfill(two.progress, eofscore, 1, 0);
         floodfill(one.progress, eofscore, 14, 0);       floodfill(two.progress, eofscore, 14, 0);
         drawing_mode(DRAW_MODE_COPY_PATTERN, ball.progress, an_pos, 0);
         circlefill(ball.bat, 10, 10, 10, 0);
         drawing_mode(DRAW_MODE_COPY_PATTERN, datafile[BITMAP_003].dat, 299-an_pos, 0);
         circlefill(two.bat, 10, 10, 10, 0);
         solid_mode();
         w=(game_speed/fps)/5;
      }
      draw_sprite(active_page, two.bat, (two.x/100)-10, (two.y/100)-10);
      if(!exit_loop) draw_sprite(active_page, ball.bat, (ball.x/100)-10, (ball.y/100)-10);
      draw_sprite(active_page, one.bat, (one.x/100)-10, (one.y/100)-10);
      one.old_x = one.x; two.old_x = two.x; one.old_y = one.y; two.old_y = two.y;
      ball.old_x = ball.x; ball.old_y = ball.y;
      set_clip(active_page, 0 , 0, 319, 199);
      draw_sprite(active_page, one.progress, 80+(11-score_max)*7, 183);
      draw_sprite(active_page, two.progress, 80+(11-score_max)*7, 2);
      drawing_mode(DRAW_MODE_COPY_PATTERN, datafile[BITMAP_003].dat, 0+an_pos, 0);
      circlefill(active_page, 160-goal_dist, 180, 3, 1);
      circlefill(active_page, 160+goal_dist, 180, 3, 1);
      drawing_mode(DRAW_MODE_COPY_PATTERN, datafile[BITMAP_003].dat, 150-an_pos, 0);
      circlefill(active_page, 160-goal_dist, 20, 3, 1);
      circlefill(active_page, 160+goal_dist, 20, 3, 1);
      solid_mode();
      page_flip();
      }
   }
   rectfill(active_page, 0, 0, 319, 19, 0);
   rectfill(active_page, 0, 180, 319, 199, 0);
   draw_word(70,2,"game over",0);
   if(exit_loop == 1) draw_word(40,182,"player 1 win",0);
   else if(exit_loop == 2) draw_word(40,182,"player 2 win",0);
   else draw_word(70,182,"game over",0);
   page_flip();
   rectfill(active_page, 0, 0, 319, 19, 0);
   rectfill(active_page, 0, 180, 319, 199, 0);
   draw_word(70,2,"game over",0);
   if(exit_loop == 1) draw_word(40,182,"player 1 win",0);
   else if(exit_loop == 2) draw_word(40,182,"player 2 win",0);
   else draw_word(70,182,"game over",0);
   page_flip();
   frame_count /= (2.3 * show_const);
   x=0;
   while(x<(25/fps) && !key[KEY_SPACE] && !key[KEY_ENTER]) {
      blit(screen, shrink, 80, 20, 0, 0, 160, 160);
      redo=1; ball.speed_x=0; ball.speed_y=0; x++;
      one.x = 16000; one.y = 16900; two.speed_x = 0; two.speed_y = 0;
      two.x = 16000; two.y = 3000; one.speed_x = 0; one.speed_y = 0;
      one.score=0; two.score=0; exit_loop = 0; w = 0;
   }
   intro();
   goto restart;
}
ball_interaction(int bat_x, int bat_y, int bat_xspeed, int bat_yspeed)
{
   long temp;
   double angle, incoming_angle, out_angle, new_velocity, ball_velocity,
          bat_velocity, bat_angle, real_bat_velocity;
   temp = ((bat_x+bat_xspeed-(ball.x+ball.speed_x))*(bat_x+bat_xspeed-(ball.x+ball.speed_x))
   + (bat_y+bat_yspeed-(ball.y+ball.speed_y))*(bat_y+bat_yspeed-(ball.y+ball.speed_y))); 
   if(temp < 4000000) {
      angle = too_circle((ball.x-bat_x), (ball.y-bat_y));
      incoming_angle = too_circle(ball.speed_x, ball.speed_y) - pi;
      if(incoming_angle < 0) incoming_angle += 2 * pi;
      if((ball.speed_x == 0 && ball.speed_y == 0) || just_hit) incoming_angle = angle;
      if(!just_hit && sound_on) {
         sample[0]->left_volume=36;
         sample[0]->right_volume=36;
         sb_mix_sample(sample[0]);
      }
      just_hit = 2;
      out_angle = 2 * angle - incoming_angle;
      if(fabs(incoming_angle-angle) > pi/2 && fabs(incoming_angle-angle) < 3*pi/2)
         out_angle += pi;
      if(out_angle > 2 * pi) out_angle -= 2 * pi;
      else if(out_angle < 0) out_angle += 2 * pi;
      if(fabs(angle-out_angle) > pi/2 && fabs(angle-out_angle) < 3*pi/2)
         out_angle += pi;
      if(out_angle > 2 * pi) out_angle -= 2 * pi;
      ball_velocity=(double)(ball.speed_x*ball.speed_x+ball.speed_y*ball.speed_y);
      bat_velocity= (double)(bat_xspeed*bat_xspeed+bat_yspeed*bat_yspeed);
      bat_angle = too_circle(bat_xspeed, bat_yspeed);
      real_bat_velocity = sqrt(bat_velocity) * cos(out_angle - bat_angle);
      new_velocity=( sqrt(ball_velocity) * 0.7 + real_bat_velocity * 1.4 );
      ball.speed_x = fabs(new_velocity * sin(out_angle));
      ball.speed_y = fabs(new_velocity * cos(out_angle));
      if(out_angle >= 0 && out_angle < pi / 2) ball.speed_y *= -1;
      else if(out_angle >= pi && out_angle < 3 * pi / 2)  ball.speed_x *= -1;
      else if(out_angle >= 3 * pi / 2 && out_angle < 2 * pi) {
         ball.speed_y *= -1; ball.speed_x *= -1;
      }
      if(((bat_x-(ball.x+ball.speed_x))*(bat_x-(ball.x+ball.speed_x)) +
      (bat_y-(ball.y+ball.speed_y))*(bat_y-(ball.y+ball.speed_y))) < temp) {
         bat_xspeed *= -1; bat_yspeed *= -1;
      }
      if(debug) {
         sprintf(score_buf, "A: %d IA %d OA %d BA %d T %d\n", (int)(angle*180/pi),
         (int)(incoming_angle*180/pi), (int)bat_angle*180/pi, (int)(out_angle*180/pi),
         frame_count);
         fputs(score_buf, fp);
      }
   }
}
page_flip()
{      
   if (active_page == page1) {
      scroll_screen(0, 0);
      if(!t) {t=1;fade_in_range(datafile[PALLETE_001].dat, 2, 0, 255);}
      active_page = page2;
   }
   else {
      scroll_screen(0, SCREEN_H);
      active_page = page1;
   }
}
init()
{
   int x, y; char c;
   printf("Shuffle v 1.1 by Michael Bevin - feel free to distribute\n");
   allegro_init();
   install_timer();
   install_mouse();
   install_keyboard();
   set_gfx_mode(GFX_MODEX, 320, 200, 0, 720);
   set_mouse_speed(2, 2);
   position_mouse(100,100);
   datafile = load_datafile("shuffle.dat");
   if (!datafile) {
      allegro_exit();
      printf("Error loading shuffle.dat!\n\n");
      exit(1);
   }
   set_pallete(black_pallete);
   if(sound_on) {
      if(sb_install_driver(11000)!=SB_SUCCESS) sound_on = 0;
      else {
         sample[0]=sb_load_sample("hit.wav",_SB_WAV);
         sample[1]=sb_load_sample("cheer.wav",_SB_WAV);
         mod=sb_load_mod_file("tune.mod");
         if(mod==NULL || sample[0]==NULL || sample[1]==NULL) {
            allegro_exit();
            printf("Error initialising sound system\n");
            sb_uninstall_driver();
            exit(1);
         }
         sb_mod_play(mod);
      }
   }
   page1 = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
   page2 = create_sub_bitmap(screen, 0, SCREEN_H, SCREEN_W, SCREEN_H);
   page3 = create_sub_bitmap(screen, 0, SCREEN_H*2, SCREEN_W, SCREEN_H);
   one.bat =  create_bitmap(24,24);      clear(one.bat);
   two.bat =  create_bitmap(24,24);      clear(two.bat);
   ball.bat = create_bitmap(24,24);      clear(ball.bat);
   two.progress = create_bitmap(160,15); clear(two.progress);
   one.progress = create_bitmap(160,15); clear(one.progress);
   shrink = create_bitmap(160,160);      clear(shrink);
   rotate = create_bitmap(200,200);      clear(rotate);
   ball.progress = create_bitmap(320,64);
   circlefill(one.bat, 12, 13, 10, 4);
   circlefill(two.bat, 12, 13, 10, 4);
   circlefill(ball.bat, 12, 13, 10, 4);
   blit(datafile[BITMAP_003].dat, ball.progress, 0, 0, 0, 0, 320, 64);
   for(x=0;x<320;x++) {
      for(y=0; y<25;y++)
         ball.progress->line[y][x] = 255 - ball.progress->line[y][x];
   }
   end1 = create_bitmap(8,15); clear_to_color(end1, 255);
   end2 = create_bitmap(8,15); clear_to_color(end2, 255);
   circlefill(end1, 7, 7, 7, 0);
   circlefill(end2, 0, 7, 7, 0);
   active_page = page2; ball.speed_x=0;
   ball.speed_y=0; one.device=0; two.device=3;
   one.old_x = 16000; one.old_y = 16900; two.old_x = 16000; two.old_y = 3000;
   one.x = 16000;     one.y = 16900;     two.x = 16000;     two.y = 3000;               
   one.speed_x = 0;   one.speed_y = 0;   two.speed_x = 0;   two.speed_y = 0; 
   one.score = 0;     two.score = 0;
   draw_compiled_sprite(page1, datafile[BITMAP_001].dat, 0, 0);
   draw_compiled_sprite(page2, datafile[BITMAP_001].dat, 0, 0);
}
intro()
{
   int x = 0; int an_pos, w, an_dir, smileypos; int r = 0;
   char max_buf[3];
   an_pos=0; w=1; an_dir=1; smileypos=0;
   clear_keybuf();
   draw_compiled_sprite(page3, datafile[BITMAP_001].dat, 0, 0);
   while(r != KEY_SPACE && r != KEY_ENTER) {
      w--; if(w<0) w=0;
      x += 20/(game_speed/fps) + 1;
      if(!w) {
         an_pos += an_dir;
         w=(game_speed/fps)/3;
         if (an_pos > 150) an_dir = -1;
         if (an_pos < 2) an_dir = 1;
      }
      blit(page3, active_page, 0, 0, 0, 0, 320, 200); 
      if(redo && x<160) {
         clear(rotate);
         stretch_blit(shrink, rotate, 0, 0, 160, 160, x/2 + 20, x/2 + 20, 160-x, 160-x);
         rotate_sprite(active_page, rotate, 60, 0, itofix(x*2));
      }
      rectfill(active_page, 0, 0, 319, 19, 0);
      rectfill(active_page, 0, 180, 319, 199, 0);
      rectfill(active_page, 92, 52, 232, 57, 1);
      draw_word(90, 30, "shuffle", an_pos);
      drawing_mode(DRAW_MODE_COPY_PATTERN, datafile[BITMAP_003].dat, an_pos, 0);
      rectfill(active_page, 90, 50, 230, 55, 255);
      solid_mode();
      draw_word(60, 90+smileypos*20, ":", 0);
      if(keypressed()) {
         r = readkey() >> 8;
         if(r == KEY_ESC) {
           sb_uninstall_driver();
           sb_free_sample(sample[0]);
           sb_free_sample(sample[1]);
           sb_free_mod_file(mod);
           unload_datafile(datafile);
           if(debug) fclose(fp);
           exit(0);
         }
         if(r == KEY_DOWN) {smileypos++; if(smileypos > 3) smileypos = 0;}
         if(r == KEY_UP) {smileypos--; if(smileypos < 0) smileypos = 3;}
         else if(r == KEY_RIGHT) {
            if(!smileypos) {one.device++; if(one.device>6) one.device=0;}
            else if(smileypos == 1) {two.device++;if(two.device>6) two.device=0;}
            else if(smileypos == 2) {score_max++;if(score_max>11) score_max = 1;}
            else {goal_dist++;if(goal_dist>80) goal_dist = 80;}
         }
         else if(r == KEY_LEFT) {
            if(!smileypos) {one.device--; if(one.device<0) one.device=6;}
            else if(smileypos == 1) {two.device--;if(two.device<0) two.device=6;}
            else if(smileypos == 2) {score_max--;if(score_max<1) score_max = 11;}
            else {goal_dist--;if(goal_dist<30) goal_dist = 30;}
         }
         clear_keybuf();
      }
      switch(one.device) {
         case 0 :  draw_word(80, 90, "1;mouse", 0);     break;
         case 1 :  draw_word(80, 90, "1;keypad", 0);    break;
         case 2 :  draw_word(80, 90, "1;keyboard", 0);  break;
         case 3 :  draw_word(80, 90, "1;kiddie", 0);    break;
         case 4 :  draw_word(80, 90, "1;easy", 0);      break;
         case 5 :  draw_word(80, 90, "1;medium", 0);    break;
         default : draw_word(80, 90, "1;hard", 0);
      }
      switch(two.device) {
         case 0 :  draw_word(80, 110, "2;mouse", 0);     break;
         case 1 :  draw_word(80, 110, "2;keypad", 0);    break;
         case 2 :  draw_word(80, 110, "2;keyboard", 0);  break;
         case 3 :  draw_word(80, 110, "2;kiddie", 0);    break;
         case 4 :  draw_word(80, 110, "2;easy", 0);      break;
         case 5 :  draw_word(80, 110, "2;medium", 0);    break;
         default : draw_word(80, 110, "2;hard", 0);
      }
      clear(one.progress);
      blit(datafile[BITMAP_004].dat, one.progress, an_pos, 0, 0, 0, 160-(11-score_max)*14, 15);
      draw_sprite(one.progress, end1, 0, 0);
      floodfill(one.progress, 1, 1, 0);     
      floodfill(one.progress, 1, 14, 0);    
      draw_sprite(one.progress, end2, 14 * score_max - 2, 0);
      floodfill(one.progress, 14 * score_max + 5, 1, 0);      
      floodfill(one.progress, 14 * score_max + 5, 14, 0);     
      draw_sprite(active_page, one.progress, 80, 130);
      drawing_mode(DRAW_MODE_COPY_PATTERN, datafile[BITMAP_004].dat, an_pos, 0);
      line(active_page, 80, 158, 240, 158, 0);
      drawing_mode(DRAW_MODE_COPY_PATTERN, datafile[BITMAP_003].dat, 150-an_pos, 0);
      circlefill(active_page, 160-goal_dist, 158, 3, 1);
      circlefill(active_page, 160+goal_dist, 158, 3, 1);
      solid_mode();
      page_flip();
      frame_count++;
      fps=(double)game_speed/(frame_count/game_time)*2;
   }
   draw_compiled_sprite(page1, datafile[BITMAP_001].dat, 0, 0);
   draw_compiled_sprite(page2, datafile[BITMAP_001].dat, 0, 0);
   srand(an_pos);
}
draw_word(int xx, int yy, char *cc, int col)
{
   BITMAP *letter, *temp;
   int v, w, y, z; char ccc, d;
   z = strlen(cc);
   if(col && col<200) {
      letter = create_bitmap(z*20+2, 18);
      temp = create_bitmap(z*20,16);
      clear(temp);
   }
   else letter = create_bitmap(z*20,16);
   clear(letter);
   if(col==205) draw_compiled_sprite(active_page, datafile[BITMAP_001].dat, 0, 0);
   for(w=0; w<z;w++) {
      ccc = *cc++;
      v = ccc - 97;                    
      if(v>=0) y = 1;     
         else {v += 49; y = 19;}
      blit(datafile[BITMAP_005].dat, letter, v*17+1, y, w*20, 0, 16, 16);
   }
   if(col && col<200) {
      blit(letter, temp, 0, 0, 0, 0, z*20, 17);
      for(v=0;v<16;v++) {
         for(w=0;w<(z*20);w++) {
            d = getpixel(datafile[BITMAP_003].dat, col+w, v);
            if(getpixel(temp, w, v) > 13) {
               letter->line[v+2][w+2] = 1;
               letter->line[v][w] = d;
            };
         }
      }
   }
   if(col==201) {
      draw_compiled_sprite(page3, datafile[BITMAP_002].dat, 0, 0);
      for(v=0;v<16;v++) {
         for(w=0;w<(z*20);w++) {
            d = getpixel(datafile[BITMAP_006].dat, w+xx, v+yy);
            if(getpixel(letter, w, v) < 13) letter->line[v][w] = 0;
            else letter->line[v][w] = d;
         }
      }
      draw_sprite(page3, letter, xx, yy);
   }
   else draw_sprite(active_page, letter, xx, yy);
   destroy_bitmap(letter);
}
