DEFINT A-Z
DECLARE SUB Mouse (cx, dx, bx)
DECLARE SUB MousePointer (SW)
DECLARE SUB clkticks (Ticks%)
DECLARE SUB Ledbar (Number%)
DECLARE SUB LedDisplay (Number%)
DECLARE SUB font (a$, X%, Y%, stepX%, stepY%, CO%, Background%, SHADOW%)

DIM SHARED DisplayLedX, DisplayLedY, LedDigits
DIM SHARED GraphLedX, GraphLedY, GraphElements, GraphNum
DIM SHARED a(9)
DIM laserx(1)
DIM lasery(1)


SCREEN 7
'-------- Led Digit Display Setup -----------------
DisplayLedX = 130 '|- Upper Left corner of
DisplayLedY = 0 '|  Led Digit display
LedDigits = 3   'Number of digits to have on display
'--------------------------------------------------
'-------- Led Bar Graph Display Setup -------------
GraphLedX = 110  '|- Upper Left corner of
GraphLedY = 15 '|  Led Graph display
GraphElements = 32  'Number of graph elements. Maximum 32
GraphNum = 100 'The number when the graph is 100%
'--------------------------------------------------
'--------- Led Lights Setup -----------------------
TYPE Led
     X AS INTEGER
     Y AS INTEGER
     s AS INTEGER
     END TYPE
DIM SHARED Led(5) AS Led

FOR Temp = 1 TO 5
     Led(Temp).s = -1
NEXT Temp

Led(1).X = 40: Led(1).Y = 5: Led(1).s = 0  '|- Make some LED's
Led(2).X = 60: Led(2).Y = 5: Led(2).s = 0  '|

LedDisplay -1
Ledbar -1


    DEF SEG = VARSEG(a(0))
                                  
    FOR i = 0 TO 17
       READ r
       POKE VARPTR(a(0)) + i, r
    NEXT i

'**************************** Machine Code *********************************

DATA &HB8,&H00,&H00   :   ' mov  AX,[n]       [Swap code-(L),(H)] in AX
DATA &H55             :   ' push BP           Save BP
DATA &H8B,&HEC        :   ' mov  BP,SP        Get BP to c Seg
DATA &HCD,&H33        :   ' int  33           Interrupt 33
DATA &H92             :   ' xchg AX,[reg]     [Swap code-reg] in AX
DATA &H8B,&H5E,&H06   :   ' mov  BX,[BP+6]    Point to (variable)
DATA &H89,&H07        :   ' mov  [BX],AX      Put AX in (variable)
DATA &H5D             :   ' pop  BP           Restore BP
DATA &HCA,&H02,&H00   :   ' ret  2            Far return

'****************************** Mouse set up ******************************
          
                CALL MousePointer(0)      'Reset mouse and
                CALL MousePointer(3)      'Get coordinates

'****************************** P R O G R A M ******************************


'-------------------------------variables-----------------------------------
CONST TRUE = 1
CONST FALSE = 0

shipCOL = 5
dividevalue = 2
charge = 2 * (dividevalue + 10)
'backfire = TRUE :rapidfire = TRUE
enemysize = 50
shipsize = 10
rotatespeed = 2


'--------------------------------draw stars-----------------------------
CLS
RANDOMIZE TIMER

start:

DIM sx(100)
DIM sy(100)
DIM ss(100)
DIM sc(100)


numstars = 100
FOR t = 0 TO numstars
sx(t) = INT(RND * 319) + 1
sy(t) = INT(RND * 199) + 1
sc(t) = INT(RND * 20) + 1
ss(t) = sc(t) \ 8 + 1
NEXT

DO
SCREEN 7, , 3, 1
CLS
FOR t = 0 TO numstars
IF sx(t) = 0 AND sy(t) = 0 THEN
sx(t) = INT(RND * 20) + 300
sy(t) = INT(RND * 319) + 1
sc(t) = INT(RND * 20) + 1
ss(t) = sc(t) \ 8 + 1
END IF
IF ss(t) = 1 THEN sc(t) = 8
IF ss(t) = 2 THEN sc(t) = 7
IF ss(t) = 3 THEN sc(t) = 15
sx(t) = sx(t) - ss(t)
PSET (sx(t), sy(t)), sc(t)
IF sx(t) < 0 THEN sx(t) = 0: sy(t) = 0
NEXT
LINE (0, 0)-(320, 30), 0, BF

PCOPY 3, 0
SCREEN 7, , 0, 1

'------------------------------print stats-----------------------------------
LOCATE 1, 1
PRINT "SCORE:"; score
LOCATE 2, 1
PRINT "MISSED:"; missed
LOCATE 3, 1
PRINT "LIVES LEFT:"; lives + 3
font "SPACE BLASTER", 185, 7, 10, 0, 10, 0, 2


'-------------------------------draw ship-----------------------------------

cx = shipX = cx
dx% = shipY = dx

CIRCLE (shipX, shipY + divide), shipsize, shipCOL
CIRCLE (shipX, shipY - divide), shipsize, shipCOL
PAINT (shipX, shipY - divide), shipCOL
PAINT (shipX, shipY + divide), shipCOL
IF divide <> 0 THEN GOTO there:
GOTO overthere:
there:
IF divide < 5 THEN PAINT (shipX, shipY + shipsize - 1), shipCOL: PAINT (shipX, shipY - shipsize + 1), shipCOL
'-------------------------------draw enemy------------------------------------
overthere:
IF enemyscr = TRUE THEN GOTO skip:
enemyscr = TRUE
enemy = 1
enemyY = INT(RND * 200) + 1
enemyX = 320 - enemysize

skip:
IF enemydestroy = TRUE THEN GOTO whatever:
enemyX = enemyX - speed
enemydirectY = INT(RND * 2) - 1


whatever:
IF enemy = 1 THEN
        LINE (enemyX - enemysize + enemydirectX, enemyY - enemysize + enemydirectY)-(enemyX + enemysize + enemydirectX, enemyY + enemysize + enemydirectY), 3, BF
        enemyscr = TRUE
END IF
IF enemyX < 10 THEN enemyscr = FALSE: missed = missed + 1
'-----------------------------------figure lives----------------------------
IF missed = 10 THEN
        FOR expand = 1 TO (2 * shipsize + 100)
        SCREEN 7, , 0, 1
        CLS
        CIRCLE (shipX, shipY), expand, 4
        PAINT (shipX, shipY), 4
        PCOPY 0, 1
        WAIT &H3DA, 8
        SCREEN 7, , 1, 0
        NEXT
        lives = lives - 1
        missed = 0
        shipY = 100
        shipX = 20
        enemydestroy = TRUE
        count = 0
END IF

IF shipX + shipsize + divide > enemyX - enemysize AND shipY + shipsize + divide > enemyY - enemysize AND shipY - shipsize < enemyY + enemysize AND shipX - shipsize < enemyX + enemysize THEN
        FOR expand = 1 TO (2 * shipsize + 100)
        SCREEN 7, , 0, 1
        CLS
        CIRCLE (shipX, shipY), expand, 4
        PAINT (shipX, shipY), 4
        PCOPY 0, 1
        WAIT &H3DA, 8
        SCREEN 7, , 1, 0
        NEXT
        lives = lives - 1
        shipY = 100: shipX = 20
        enemydestroy = TRUE
        count = 0
END IF

IF lives < -3 THEN
        SLEEP
        clkticks 18.6
        LOCATE 1, 10
        PRINT "GAME OVER"
        END
END IF
'--------------------------------firing sequence-----------------------------
charge = (count / 2) + 20

IF rapidfire = TRUE THEN count = 1

IF fire1 = TRUE THEN
        divide = count / 2.5
        LINE (shipX - shipsize, shipY + divide)-(shipX + shipsize, shipY - divide), 0, BF
        LINE (shipX - shipsize + shipsize / 5, shipY + divide)-(shipX + shipsize - shipsize / 5, shipY - divide), 7, BF
        LINE (shipX + rotate - shipsize + shipsize / 5, shipY + divide)-(shipX + rotate - shipsize + shipsize / 5, shipY - divide), 6, BF
        rotate = rotate + rotatespeed
END IF
IF rotate > ((5 * shipsize) / 3) THEN rotate = 0
IF fire = TRUE THEN
        CIRCLE (shipX, shipY), radius + charge, 10
        radius = radius - 1
END IF

IF radius < -charge + divide + 12 AND backfire = TRUE AND fire = TRUE THEN
        LINE (shipX - 4, shipY + divide)-(shipX - 320, shipY - divide), 4, BF
        SND = INT(RND * 4) + 1
        count = 0
END IF
IF radius < -charge + divide + 12 THEN
        fire = FALSE
        fire1 = FALSE
        LINE (shipX + 4, shipY + divide)-(shipX + 320, shipY - divide), 4, BF
        radius = 0
        divide = 0
        shot = TRUE
        LINE (shipX + 4, shipY + divide)-(shipX + 320, shipY - divide), 4, BF
        SND = 1'INT(RND * 4) + 1
        count = 0
END IF
IF shipY - divide < enemyY + enemysize AND shipY + divide > enemyY - enemysize AND shot = TRUE THEN
        score = score + 10
        enemydestroy = TRUE
        LINE (shipX + 4, shipY + divide)-(shipX + 320, shipY - divide), 4, BF
END IF
IF SND = 1 THEN SOUND 4000, .1: SND = 0

IF shot = TRUE THEN LINE (shipX + 4, shipY + divide)-(shipX + 320, shipY - divide), 4, BF
shot = FALSE
IF fire1 = FALSE THEN count = count + 1
IF count > 100 THEN count = 100
     LedDisplay count   'Update Led Digits with current number
     Ledbar count       'Update Led Bar graph with current number


'---------------------------------enemy destroyed----------------------------

explosionX = INT(RND * (2 * enemysize)) - enemysize
explosionY = INT(RND * (2 * enemysize)) - enemysize
explosionsize = INT(RND * enemysize / 3) + enemysize / 5
explosionCLR = INT(RND * 2) + 1
IF explosionCLR = 1 THEN explosionCLR = 4
IF explosionCLR = 2 THEN explosionCLR = 12
IF this = TRUE THEN GOTO that:
NumExplosions = 50

that:
explode = INT(RND * 100) + 50
IF enemydestroy = TRUE THEN
        CIRCLE (enemyX + explosionX, enemyY + explosionY), explosionsize, explosionCLR
        PAINT (enemyX + explosionX, enemyY + explosionY), explosionCLR
        SOUND explode, 1
        explosionCOUNT = explosionCOUNT + 1: that = TRUE
END IF
IF explosionCOUNT = NumExplosions THEN
        enemyscr = FALSE
        enemydestroy = FALSE
        explosionCOUNT = 0
        that = FALSE
        enemysize = enemysize + 1
        speed = speed + 1
END IF

PCOPY 0, 1
   WAIT &H3DA, 8
SCREEN 7, , 1, 0
'-------------------------------ship controls---------------------------------
k$ = UCASE$(INKEY$)
SELECT CASE k$
        CASE "Q"
                END
        CASE "4"
                shipX = shipX - 11
        CASE "6"
                shipX = shipX + 11
        CASE "2"
                shipY = shipY + 11
        CASE "8"
                shipY = shipY - 11
        CASE "1"
                shipY = shipY + 11
                shipX = shipX - 11
        CASE "3"
                shipY = shipY + 11
                shipX = shipX + 11
        CASE "7"
                shipY = shipY - 11
                shipX = shipX - 11
        CASE "9"
                shipY = shipY - 11
                shipX = shipX + 11
        CASE " "
            
                divide = dividevalue
                fire = TRUE
                fire1 = TRUE
END SELECT
IF shipX < 10 THEN shipX = 10
IF shipY < 35 THEN shipY = 35
IF shipX > 310 THEN shipX = 310
IF shipY > 190 THEN shipY = 190
LOOP

DEF SEG
MousePointer (2)

DEFSNG A-Z
SUB clkticks (Ticks%)
  Pause% = Ticks%
  DEF SEG = 0
  DO UNTIL Pause% < 1
    CurrentTick% = PEEK(&H46C)
    DO WHILE CurrentTick% = PEEK(&H46C): LOOP
      Pause% = Pause% - 1
    LOOP
  DEF SEG
END SUB

DEFINT A-Z
SUB font (a$, X%, Y%, stepX%, stepY%, CO%, Background%, SHADOW%)

extX% = stepX%: extY% = stepY%
DEF SEG = &HFFA6
 FOR i% = 1 TO LEN(a$)
   addr% = 8 * ASC(MID$(a$, i%)) + 14
IF Background% THEN
IF Background% = 256 THEN BG% = FALSE ELSE BG% = Background%
                                                         
IF i% = LEN(a$) THEN extX% = FALSE: extY% = FALSE
LINE (X%, Y%)-(X% + 7 + extX%, Y% + 7 + extY%), BG%, BF
END IF
FOR j% = 0 TO 7
mask% = PEEK(addr% + j%) * 128
IF SHADOW% > 0 THEN
LINE (X% + 9, Y% + j% + 2)-(X% + 2, Y% + j% + 2), SHADOW%, , mask%
END IF
LINE (X% + 7, Y% + j%)-(X%, Y% + j%), CO%, , mask%
NEXT
X% = X% + extX%
Y% = Y% + extY%
NEXT
DEF SEG


END SUB

SUB Ledbar (Number%)
IF Number < 0 THEN 'If Negitive then blank Bar Graph
     FOR MakeGraph = 1 TO GraphElements * 2 STEP 2 'Make the Bar graph
          LINE (GraphLedX + MakeGraph, GraphLedY)-(GraphLedX + MakeGraph, GraphLedY + 5), 1
     NEXT MakeGraph
     EXIT SUB
END IF

Elements = INT(Number * GraphElements / GraphNum) 'Calculate Number Elements
IF Elements > GraphElements THEN Elements = GraphElements 'Check limts

'----------------- Draw Bar Graph --------------------------------
FOR MakeGraph = 1 TO Elements * 2 STEP 2 'Make the Bar graph (Lit)
LINE (GraphLedX + MakeGraph, GraphLedY)-(GraphLedX + MakeGraph, GraphLedY + 5), 9
NEXT MakeGraph
FOR MakeGraph = Elements * 2 + 1 TO GraphElements * 2 STEP 2 'Make the Bar graph (Dim
LINE (GraphLedX + MakeGraph, GraphLedY)-(GraphLedX + MakeGraph, GraphLedY + 5), 1
NEXT MakeGraph
'------------------------------------------------------------------
END SUB

SUB LedDisplay (Number%)
IF Number < 0 THEN  'Setup Led Display panel
     FOR PlotX = DisplayLedX TO DisplayLedX + ((LedDigits - 1) * 8) STEP 8
          '----------- One LED Matrix digit --------------------
          LINE (PlotX + 1, DisplayLedY)-(PlotX + 5, DisplayLedY), 1
          LINE (PlotX, DisplayLedY + 1)-(PlotX, DisplayLedY + 5), 1
          LINE (PlotX + 6, DisplayLedY + 1)-(PlotX + 6, DisplayLedY + 5), 1
          LINE (PlotX + 1, DisplayLedY + 6)-(PlotX + 5, DisplayLedY + 6), 1
          LINE (PlotX, DisplayLedY + 7)-(PlotX, DisplayLedY + 11), 1
          LINE (PlotX + 6, DisplayLedY + 7)-(PlotX + 6, DisplayLedY + 11), 1
          LINE (PlotX + 1, DisplayLedY + 12)-(PlotX + 5, DisplayLedY + 12), 1
          '------------------------------------------------------
     NEXT PlotX
     EXIT SUB
END IF

Number = FIX(Number) 'Get rid of the decimals incase there are some
Number = VAL(LEFT$(STR$(Number), LedDigits + 1)) 'Chop Number to LED size

PlotX = DisplayLedX

IF LEN(STR$(Number)) - 1 < LedDigits THEN  'Clear Unused digits
     FOR ClearEmptyDigits = 1 TO LedDigits - (LEN(STR$(Number)) - 1)
     LINE (PlotX + 1, DisplayLedY)-(PlotX + 5, DisplayLedY), 1
     LINE (PlotX, DisplayLedY + 1)-(PlotX, DisplayLedY + 5), 1
     LINE (PlotX + 6, DisplayLedY + 1)-(PlotX + 6, DisplayLedY + 5), 1
     LINE (PlotX + 1, DisplayLedY + 6)-(PlotX + 5, DisplayLedY + 6), 1
     LINE (PlotX, DisplayLedY + 7)-(PlotX, DisplayLedY + 11), 1
     LINE (PlotX + 6, DisplayLedY + 7)-(PlotX + 6, DisplayLedY + 11), 1
     LINE (PlotX + 1, DisplayLedY + 12)-(PlotX + 5, DisplayLedY + 12), 1
     PlotX = PlotX + 8
     NEXT ClearEmptyDigits
END IF


FOR PlotDigit = 1 TO LEN(STR$(Number)) - 1 'Plot each number to a LED

WorkDigit$ = MID$(STR$(Number), PlotDigit + 1, 1) 'Get 1 Digit

SELECT CASE WorkDigit$ 'Find and select which elements to turn on
     CASE "0"
          E1 = 9: E2 = 9: E3 = 9: E4 = 1: E5 = 9: E6 = 9: E7 = 9
  
     CASE "1"
          E1 = 1: E2 = 1: E3 = 9: E4 = 1: E5 = 1: E6 = 1: E7 = 9
 
     CASE "2"
          E1 = 1: E2 = 9: E3 = 9: E4 = 9: E5 = 9: E6 = 9: E7 = 1
 
     CASE "3"
          E1 = 1: E2 = 9: E3 = 9: E4 = 9: E5 = 1: E6 = 9: E7 = 9
 
     CASE "4"
          E1 = 9: E2 = 1: E3 = 9: E4 = 9: E5 = 1: E6 = 1: E7 = 9

     CASE "5"
          E1 = 9: E2 = 9: E3 = 1: E4 = 9: E5 = 1: E6 = 9: E7 = 9
 
     CASE "6"
          E1 = 9: E2 = 1: E3 = 1: E4 = 9: E5 = 9: E6 = 9: E7 = 9
 
     CASE "7"
          E1 = 1: E2 = 9: E3 = 9: E4 = 1: E5 = 1: E6 = 1: E7 = 9
 
     CASE "8"
          E1 = 9: E2 = 9: E3 = 9: E4 = 9: E5 = 9: E6 = 9: E7 = 9
 
     CASE "9"
          E1 = 9: E2 = 9: E3 = 9: E4 = 9: E5 = 1: E6 = 1: E7 = 9
END SELECT
'Plot the LEDs to the screen------------------------
LINE (PlotX, DisplayLedY + 1)-(PlotX, DisplayLedY + 5), E1
LINE (PlotX + 1, DisplayLedY)-(PlotX + 5, DisplayLedY), E2
LINE (PlotX + 6, DisplayLedY + 1)-(PlotX + 6, DisplayLedY + 5), E3
LINE (PlotX + 1, DisplayLedY + 6)-(PlotX + 5, DisplayLedY + 6), E4
LINE (PlotX, DisplayLedY + 7)-(PlotX, DisplayLedY + 11), E5
LINE (PlotX + 1, DisplayLedY + 12)-(PlotX + 5, DisplayLedY + 12), E6
LINE (PlotX + 6, DisplayLedY + 7)-(PlotX + 6, DisplayLedY + 11), E7
'--------------------------------------------------
PlotX = PlotX + 8
NEXT PlotDigit

END SUB

SUB Mouse (cx, dx, bx)
        
          POKE VARPTR(a(4)), &H92
          CALL absolute(cx, VARPTR(a(0)))
          POKE VARPTR(a(4)), &H91
          CALL absolute(dx, VARPTR(a(0)))
          POKE VARPTR(a(4)), &H93
          CALL absolute(bx, VARPTR(a(0)))

END SUB

SUB MousePointer (SW)
        
           POKE VARPTR(a(0)) + 1, SW
          CALL absolute(c, VARPTR(a(0)))

END SUB

