'===========================================================================
' Subject: STICK FIGHTER                      Date: 10-14-96 (09:09)       
'  Author: Brian Flanagan                     Code: QB, QBasic, PDS        
'  Origin: Brianster@aol.com                Packet: GAMES.ABC
'===========================================================================
' This is a quick beta for a fighter-type ( i.e. mortal kombat ) QBasic game.
' I looked for a good fighter game written in QBasic, but most the ones that
' I found were pretty lame - mostly tiny graphics with very little feel for
' player movement, which I think is what really makes these type of games
' fun.  Anyway, there is still plenty of work left to do here, but seeing
' how several programmers jumped on Peter Cooper's raycasting engine, I
' figured that I might bounce it here and get some feed-back.  Feel free to
' do with this what you will, and I would appreciate any improvements to the
' code sent to me.
'
' Brianster@aol.com
' :-)
'
' BTW, some of these lines may wrap once posted to the newsgroup, so you
' might have to edit the code a little bit before it runs...
'

TYPE playerdata
   xpos AS INTEGER
   ypos AS INTEGER
   frame AS INTEGER
   mframe AS INTEGER
   tframe AS INTEGER
   strength AS INTEGER
END TYPE

DIM player(2) AS playerdata

TYPE PointType
   xpos AS INTEGER
   ypos AS INTEGER
END TYPE

TYPE splatdata
   xpos AS INTEGER
   ypos AS INTEGER
   frame AS INTEGER
END TYPE

DIM splat AS splatdata

maxmoves% = 9

DIM rs(maxmoves%) AS PointType
DIM ls(maxmoves%) AS PointType
DIM re(maxmoves%) AS PointType
DIM le(maxmoves%) AS PointType
DIM rh(maxmoves%) AS PointType
DIM lh(maxmoves%) AS PointType
DIM rw(maxmoves%) AS PointType
DIM lw(maxmoves%) AS PointType
DIM rk(maxmoves%) AS PointType
DIM lk(maxmoves%) AS PointType
DIM ra(maxmoves%) AS PointType
DIM la(maxmoves%) AS PointType
DIM rt(maxmoves%) AS PointType
DIM lt(maxmoves%) AS PointType

FOR i% = 1 TO maxmoves%
   READ rh(i%).xpos, rh(i%).ypos, lh(i%).xpos, lh(i%).ypos
   READ re(i%).xpos, re(i%).ypos, le(i%).xpos, le(i%).ypos
   READ rs(i%).xpos, rs(i%).ypos, ls(i%).xpos, ls(i%).ypos
   READ rw(i%).xpos, rw(i%).ypos, lw(i%).xpos, lw(i%).ypos
   READ rk(i%).xpos, rk(i%).ypos, lk(i%).xpos, lk(i%).ypos
   READ ra(i%).xpos, ra(i%).ypos, la(i%).xpos, la(i%).ypos
   READ rt(i%).xpos, rt(i%).ypos, lt(i%).xpos, lt(i%).ypos
NEXT i%

' Standing still.
' Frame 1.
DATA 14,88,24,79
DATA 12,109,16,102
DATA 1,81,1,81
DATA 0,119,0,119
DATA 20,148,5,148
DATA 31,178,-7,175
DATA 39,180,-2,184

' Punch.
' Frame 2.
DATA 19,85,33,86
DATA 12,108,17,103
DATA 1,80,1,80
DATA 0,119,0,119
DATA 21,147,6,147
DATA 31,178,-14,175
DATA 40,181,-9,183

' Frame 3.
DATA 26,81,49,77
DATA 11,110,29,89
DATA 5,79,5,79
DATA 0,120,0,120
DATA 23,148,-7,151
DATA 33,180,-36,175
DATA 44,183,-31,182

' Frame 4.
DATA 40,78,80,76
DATA 25,108,51,79
DATA 18,80,18,80
DATA 0,120,0,120
DATA 27,149,-6,151
DATA 36,181,-34,174
DATA 47,183,-29,183

' Kick.
' Frame 5.
DATA 26,79,16,87
DATA 20,104,13,110
DATA 2,80,2,80
DATA 0,124,0,124
DATA 19,153,-5,156
DATA 21,186,-20,186
DATA 31,189,-16,192

' Frame 6.
DATA 2,82,14,79
DATA -5,106,11,102
DATA -1,73,-1,73
DATA 0,114,0,114
DATA 19,143,31,127
DATA 22,176,16,158
DATA 32,177,22,165

' Frame 7.
DATA -14,98,10,76
DATA -27,112,8,99
DATA -11,78,-11,78
DATA 0,119,0,119
DATA 5,149,38,117
DATA 8,183,9,138
DATA 15,181,8,149

' Frame 8.
DATA -13,97,11,68
DATA -24,117,8,90
DATA -13,86,-13,86
DATA 0,125,0,125
DATA -14,156,37,123
DATA -28,190,70,125
DATA -22,188,63,119

' Player got hit.
' Frame 9.
DATA -5,129,23,112
DATA -13,101,7,98
DATA -9,76,-9,76
DATA 0,119,0,119
DATA 6,147,21,147
DATA -14,174,30,178
DATA -8,180,41,178

' Player data.
player(1).xpos = 60
player(1).ypos = 0
player(2).xpos = 260
player(2).ypos = 0

FOR i% = 1 TO 2
   player(i%).mframe = 0
   player(i%).tframe = 0
   player(i%).frame = 1
   player(i%).strength = 30
NEXT i%

splat.frame = 0

' Instructions.
   SCREEN 12
   LOCATE 6, 1
   PRINT "                Left player controls:     Right player controls"
   PRINT "                *********************     *********************"
   PRINT "                  'A' - backup                'L' - backup"
   PRINT "                  'S' - kick                  'K' - kick"
   PRINT "                  'D' - punch                 'J' - punch"
   PRINT "                  'F' - forward               'H' - forward"
   PRINT : PRINT
   PRINT "                              'Q' - ends program"
   PRINT : PRINT
   PRINT "                                 Press a key..."
   DO WHILE INKEY$ = "": LOOP

' Main game loop.
DO UNTIL gameend$ = "Q"

   ' Get player input.
   p$ = ""
   p$ = INKEY$
   IF player(1).frame = 1 THEN
      SELECT CASE UCASE$(p$)
         CASE "D"  ' Punch
            player(1).frame = 2
            player(1).mframe = 1
            player(1).tframe = 0
         CASE "S"  ' Kick
            player(1).frame = 5
            player(1).mframe = 1
            player(1).tframe = 0
         CASE "F"  ' Forward    ' Change this to a quick step forward animation.
            player(1).xpos = player(1).xpos + 7
            IF player(1).xpos > 280 THEN player(1).xpos = 280
         CASE "A"  ' Backward. ' Change this to a quick step backward animation.
            player(1).xpos = player(1).xpos - 7
            IF player(1).xpos < 20 THEN player(1).xpos = 20
         CASE "Q"
            gameend$ = "Q"
      END SELECT
   END IF

   IF player(2).frame = 1 THEN
      SELECT CASE UCASE$(p$)
         CASE "J"
            player(2).frame = 2
            player(2).mframe = 1
            player(2).tframe = 0
         CASE "K"
            player(2).frame = 5
            player(2).mframe = 1
            player(2).tframe = 0
         CASE "L"  ' Backward.    ' Change this to a quick step forward animation.
            player(2).xpos = player(2).xpos + 7
            IF player(2).xpos > 280 THEN player(2).xpos = 280
         CASE "H"  ' Forward. ' Change this to a quick step backward animation.
            player(2).xpos = player(2).xpos - 7
            IF player(2).xpos < 20 THEN player(2).xpos = 20
         CASE "Q"
            gameend$ = "Q"
      END SELECT
   END IF

   ' Check for collision.
   ' Player 1 attacking.
   xcheck% = 0
   IF player(1).xpos < player(2).xpos THEN
      IF player(1).frame > 1 THEN   ' See if player is throwing an appendage.
         ' Check basic boundary box.
         IF player(1).frame = 4 THEN  ' Move was a punch.
            xcheck% = player(1).xpos + lh(player(1).frame).xpos
            splat.ypos = lh(player(1).frame).ypos
         ELSEIF player(1).frame = 8 THEN ' Move was a kick.
            xcheck% = player(1).xpos + la(player(1).frame).xpos
            splat.ypos = la(player(1).frame).ypos
         END IF
         ' Check against player 2's boundary.
         IF xcheck% > 0 AND player(2).frame <> 9 THEN
            IF xcheck% > (player(2).xpos - 20) AND xcheck% < (player(2).xpos + 20) THEN
               player(2).frame = 9
               player(2).mframe = 1
               player(2).xpos = player(2).xpos + 14
               player(2).strength = player(2).strength - 3
               IF player(2).xpos > 280 THEN player(2).xpos = 280
               splat.frame = 1
               splat.xpos = xcheck%
            END IF
         END IF
      END IF

      'Player 2.
      xcheck% = 0
      IF player(2).frame > 1 THEN   ' See if player is throwing an appendage.
         ' Check basic boundary box.
         IF player(2).frame = 4 THEN  ' Move was a punch.
            xcheck% = player(2).xpos - lh(player(2).frame).xpos
            splat.ypos = lh(player(2).frame).ypos
         ELSEIF player(2).frame = 8 THEN ' Move was a kick.
            xcheck% = player(2).xpos - la(player(2).frame).xpos
            splat.ypos = la(player(2).frame).ypos
         END IF
         ' Check against player 1's boundary.
         IF xcheck% > 0 AND player(1).frame <> 9 THEN
            IF xcheck% > (player(1).xpos - 20) AND xcheck% < (player(1).xpos + 20) THEN
               player(1).frame = 9
               player(1).mframe = 1
               player(1).xpos = player(1).xpos - 14
               player(1).strength = player(1).strength - 3
               IF player(1).xpos < 20 THEN player(1).xpos = 20
               splat.frame = 1
               splat.xpos = xcheck%
            END IF
         END IF
      END IF
   ELSE
      IF player(1).frame > 1 THEN   ' See if player is throwing an appendage.
         ' Check basic boundary box.
         IF player(1).frame = 4 THEN  ' Move was a punch.
            xcheck% = player(1).xpos - lh(player(1).frame).xpos
            splat.ypos = lh(player(1).frame).ypos
         ELSEIF player(1).frame = 8 THEN ' Move was a kick.
            xcheck% = player(1).xpos - la(player(1).frame).xpos
            splat.ypos = la(player(1).frame).ypos
         END IF
         ' Check against player 2's boundary.
         IF xcheck% > 0 AND player(2).frame <> 9 THEN
            IF xcheck% > (player(2).xpos - 20) AND xcheck% < (player(2).xpos + 20) THEN
               player(2).frame = 9
               player(2).mframe = 1
               player(2).xpos = player(2).xpos - 14
               player(2).strength = player(2).strength - 3
               IF player(2).xpos < 20 THEN player(2).xpos = 20
               splat.frame = 1
               splat.xpos = xcheck%
            END IF
         END IF
      END IF

      'Player 2.
      xcheck% = 0
      IF player(2).frame > 1 THEN   ' See if player is throwing an appendage.
         ' Check basic boundary box.
         IF player(2).frame = 4 THEN  ' Move was a punch.
            xcheck% = player(2).xpos + lh(player(2).frame).xpos
            splat.ypos = lh(player(2).frame).ypos
         ELSEIF player(2).frame = 8 THEN ' Move was a kick.
            xcheck% = player(2).xpos + la(player(2).frame).xpos
            splat.ypos = la(player(2).frame).ypos
         END IF
         ' Check against player 1's boundary.
         IF xcheck% > 0 AND player(1).frame <> 9 THEN
            IF xcheck% > (player(1).xpos - 20) AND xcheck% < (player(1).xpos + 20) THEN
               player(1).frame = 9
               player(1).mframe = 1
               player(1).xpos = player(1).xpos + 14
               player(1).strength = player(1).strength - 3
               IF player(1).xpos > 280 THEN player(1).xpos = 280
               splat.frame = 1
               splat.xpos = xcheck%
            END IF
         END IF
      END IF
   END IF

   ' Determine if a player has lost.
   IF player(1).strength <= 0 OR player(2).strength <= 0 THEN END

   SCREEN 7, , 1, 0
   CLS
   ' Draw background stuff.
      LINE (0, 150)-(319, 150), 14
      FOR floor% = 160 TO 0 STEP -10
         LINE (floor%, 150)-(floor% - (160 - floor%) * 1.2, 190), 14
         LINE (320 - floor%, 150)-(320 - (floor% - (160 - floor%) * 1.2), 190), 14
      NEXT floor%
      LINE (0, 190)-(319, 190), 14

   ' Draw players.
   IF player(1).xpos < player(2).xpos THEN
   ' Draw player 1.
   ' Draw right side.
      LINE (player(1).xpos + rt(player(1).frame).xpos,rt(player(1).frame).ypos)-(player(1).xpos + ra(player(1).frame).xpos,ra(player(1).frame).ypos), 1
      LINE (player(1).xpos + ra(player(1).frame).xpos,ra(player(1).frame).ypos)-(player(1).xpos + rk(player(1).frame).xpos,rk(player(1).frame).ypos), 1
      LINE (player(1).xpos + rk(player(1).frame).xpos,rk(player(1).frame).ypos)-(player(1).xpos + rw(player(1).frame).xpos,rw(player(1).frame).ypos), 1
      LINE (player(1).xpos + rw(player(1).frame).xpos,rw(player(1).frame).ypos)-(player(1).xpos + rs(player(1).frame).xpos,rs(player(1).frame).ypos), 1
      LINE (player(1).xpos + rs(player(1).frame).xpos,rs(player(1).frame).ypos)-(player(1).xpos + re(player(1).frame).xpos,re(player(1).frame).ypos), 1
      LINE (player(1).xpos + re(player(1).frame).xpos,re(player(1).frame).ypos)-(player(1).xpos + rh(player(1).frame).xpos,rh(player(1).frame).ypos), 1

   ' Draw left side.
      LINE (player(1).xpos + lt(player(1).frame).xpos,lt(player(1).frame).ypos)-(player(1).xpos + la(player(1).frame).xpos,la(player(1).frame).ypos), 9
      LINE (player(1).xpos + la(player(1).frame).xpos,la(player(1).frame).ypos)-(player(1).xpos + lk(player(1).frame).xpos,lk(player(1).frame).ypos), 9
      LINE (player(1).xpos + lk(player(1).frame).xpos,lk(player(1).frame).ypos)-(player(1).xpos + lw(player(1).frame).xpos,lw(player(1).frame).ypos), 9
      LINE (player(1).xpos + lw(player(1).frame).xpos,lw(player(1).frame).ypos)-(player(1).xpos + ls(player(1).frame).xpos,ls(player(1).frame).ypos), 9
      LINE (player(1).xpos + ls(player(1).frame).xpos,ls(player(1).frame).ypos)-(player(1).xpos + le(player(1).frame).xpos,le(player(1).frame).ypos), 9
      LINE (player(1).xpos + le(player(1).frame).xpos,le(player(1).frame).ypos)-(player(1).xpos + lh(player(1).frame).xpos,lh(player(1).frame).ypos), 9

   ' Draw head.
      CIRCLE (player(1).xpos + rs(player(1).frame).xpos + 4,rs(player(1).frame).ypos - 7), 7, 9, , , 1.25

   ' Draw player 2.
   ' Draw right side.
      LINE (player(2).xpos - rt(player(2).frame).xpos,rt(player(2).frame).ypos)-(player(2).xpos - ra(player(2).frame).xpos,ra(player(2).frame).ypos), 3
      LINE (player(2).xpos - ra(player(2).frame).xpos,ra(player(2).frame).ypos)-(player(2).xpos - rk(player(2).frame).xpos,rk(player(2).frame).ypos), 3
      LINE (player(2).xpos - rk(player(2).frame).xpos,rk(player(2).frame).ypos)-(player(2).xpos - rw(player(2).frame).xpos,rw(player(2).frame).ypos), 3
      LINE (player(2).xpos - rw(player(2).frame).xpos,rw(player(2).frame).ypos)-(player(2).xpos - rs(player(2).frame).xpos,rs(player(2).frame).ypos), 3
      LINE (player(2).xpos - rs(player(2).frame).xpos,rs(player(2).frame).ypos)-(player(2).xpos - re(player(2).frame).xpos,re(player(2).frame).ypos), 3
      LINE (player(2).xpos - re(player(2).frame).xpos,re(player(2).frame).ypos)-(player(2).xpos - rh(player(2).frame).xpos,rh(player(2).frame).ypos), 3

   ' Draw left side.
      LINE (player(2).xpos - lt(player(2).frame).xpos,lt(player(2).frame).ypos)-(player(2).xpos - la(player(2).frame).xpos,la(player(2).frame).ypos), 11
      LINE (player(2).xpos - la(player(2).frame).xpos,la(player(2).frame).ypos)-(player(2).xpos - lk(player(2).frame).xpos,lk(player(2).frame).ypos), 11
      LINE (player(2).xpos - lk(player(2).frame).xpos,lk(player(2).frame).ypos)-(player(2).xpos - lw(player(2).frame).xpos,lw(player(2).frame).ypos), 11
      LINE (player(2).xpos - lw(player(2).frame).xpos,lw(player(2).frame).ypos)-(player(2).xpos - ls(player(2).frame).xpos,ls(player(2).frame).ypos), 11
      LINE (player(2).xpos - ls(player(2).frame).xpos,ls(player(2).frame).ypos)-(player(2).xpos - le(player(2).frame).xpos,le(player(2).frame).ypos), 11
      LINE (player(2).xpos - le(player(2).frame).xpos,le(player(2).frame).ypos)-(player(2).xpos - lh(player(2).frame).xpos,lh(player(2).frame).ypos), 11

   ' Draw head.
      CIRCLE (player(2).xpos - rs(player(2).frame).xpos - 4,rs(player(2).frame).ypos - 7), 7, 3, , , 1.25

   ELSE
   ' Draw player 1.
   ' Draw right side.
      LINE (player(1).xpos - rt(player(1).frame).xpos,rt(player(1).frame).ypos)-(player(1).xpos - ra(player(1).frame).xpos,ra(player(1).frame).ypos), 1
      LINE (player(1).xpos - ra(player(1).frame).xpos,ra(player(1).frame).ypos)-(player(1).xpos - rk(player(1).frame).xpos,rk(player(1).frame).ypos), 1
      LINE (player(1).xpos - rk(player(1).frame).xpos,rk(player(1).frame).ypos)-(player(1).xpos - rw(player(1).frame).xpos,rw(player(1).frame).ypos), 1
      LINE (player(1).xpos - rw(player(1).frame).xpos,rw(player(1).frame).ypos)-(player(1).xpos - rs(player(1).frame).xpos,rs(player(1).frame).ypos), 1
      LINE (player(1).xpos - rs(player(1).frame).xpos,rs(player(1).frame).ypos)-(player(1).xpos - re(player(1).frame).xpos,re(player(1).frame).ypos), 1
      LINE (player(1).xpos - re(player(1).frame).xpos,re(player(1).frame).ypos)-(player(1).xpos - rh(player(1).frame).xpos,rh(player(1).frame).ypos), 1

   ' Draw left side.
      LINE (player(1).xpos - lt(player(1).frame).xpos,lt(player(1).frame).ypos)-(player(1).xpos - la(player(1).frame).xpos,la(player(1).frame).ypos), 9
      LINE (player(1).xpos - la(player(1).frame).xpos,la(player(1).frame).ypos)-(player(1).xpos - lk(player(1).frame).xpos,lk(player(1).frame).ypos), 9
      LINE (player(1).xpos - lk(player(1).frame).xpos,lk(player(1).frame).ypos)-(player(1).xpos - lw(player(1).frame).xpos,lw(player(1).frame).ypos), 9
      LINE (player(1).xpos - lw(player(1).frame).xpos,lw(player(1).frame).ypos)-(player(1).xpos - ls(player(1).frame).xpos,ls(player(1).frame).ypos), 9
      LINE (player(1).xpos - ls(player(1).frame).xpos,ls(player(1).frame).ypos)-(player(1).xpos - le(player(1).frame).xpos,le(player(1).frame).ypos), 9
      LINE (player(1).xpos - le(player(1).frame).xpos,le(player(1).frame).ypos)-(player(1).xpos - lh(player(1).frame).xpos,lh(player(1).frame).ypos), 9

   ' Draw head.
      CIRCLE (player(1).xpos - rs(player(1).frame).xpos - 4,rs(player(1).frame).ypos - 7), 7, 9, , , 1.25

   ' Draw player 2.
   ' Draw right side.
      LINE (player(2).xpos + rt(player(2).frame).xpos,rt(player(2).frame).ypos)-(player(2).xpos + ra(player(2).frame).xpos,ra(player(2).frame).ypos), 3
      LINE (player(2).xpos + ra(player(2).frame).xpos,ra(player(2).frame).ypos)-(player(2).xpos + rk(player(2).frame).xpos,rk(player(2).frame).ypos), 3
      LINE (player(2).xpos + rk(player(2).frame).xpos,rk(player(2).frame).ypos)-(player(2).xpos + rw(player(2).frame).xpos,rw(player(2).frame).ypos), 3
      LINE (player(2).xpos + rw(player(2).frame).xpos,rw(player(2).frame).ypos)-(player(2).xpos + rs(player(2).frame).xpos,rs(player(2).frame).ypos), 3
      LINE (player(2).xpos + rs(player(2).frame).xpos,rs(player(2).frame).ypos)-(player(2).xpos + re(player(2).frame).xpos,re(player(2).frame).ypos), 3
      LINE (player(2).xpos + re(player(2).frame).xpos,re(player(2).frame).ypos)-(player(2).xpos + rh(player(2).frame).xpos,rh(player(2).frame).ypos), 3

   ' Draw left side.
      LINE (player(2).xpos + lt(player(2).frame).xpos,lt(player(2).frame).ypos)-(player(2).xpos + la(player(2).frame).xpos,la(player(2).frame).ypos), 11
      LINE (player(2).xpos + la(player(2).frame).xpos,la(player(2).frame).ypos)-(player(2).xpos + lk(player(2).frame).xpos,lk(player(2).frame).ypos), 11
      LINE (player(2).xpos + lk(player(2).frame).xpos,lk(player(2).frame).ypos)-(player(2).xpos + lw(player(2).frame).xpos,lw(player(2).frame).ypos), 11
      LINE (player(2).xpos + lw(player(2).frame).xpos,lw(player(2).frame).ypos)-(player(2).xpos + ls(player(2).frame).xpos,ls(player(2).frame).ypos), 11
      LINE (player(2).xpos + ls(player(2).frame).xpos,ls(player(2).frame).ypos)-(player(2).xpos + le(player(2).frame).xpos,le(player(2).frame).ypos), 11
      LINE (player(2).xpos + le(player(2).frame).xpos,le(player(2).frame).ypos)-(player(2).xpos + lh(player(2).frame).xpos,lh(player(2).frame).ypos), 11

   ' Draw head.
      CIRCLE (player(2).xpos + rs(player(2).frame).xpos + 4,rs(player(2).frame).ypos - 7), 7, 3, , , 1.25
  
   END IF

   ' Draw strength meters.
   ' Player 1.
   LINE (20, 10)-(player(1).strength + 20, 14), 15, BF
   IF player(1).strength < 30 THEN LINE -(50, 10), 4, BF
   ' Player 2.
   LINE (300, 10)-(300 - player(2).strength, 14), 15, BF
   IF player(2).strength < 30 THEN LINE -(270, 10), 4, BF

   ' Draw hit graphic.
   IF splat.frame > 0 THEN
      LINE (splat.xpos, (splat.ypos - 5))-(splat.xpos + 1, (splat.ypos - 2)), 12
      LINE -(splat.xpos + 4, (splat.ypos - 3)), 12
      LINE -(splat.xpos + 2, splat.ypos), 12
      LINE -(splat.xpos + 4, (splat.ypos + 3)), 12
      LINE -(splat.xpos + 1, (splat.ypos + 2)), 12
      LINE -(splat.xpos, (splat.ypos + 5)), 12
      LINE -(splat.xpos - 1, (splat.ypos + 2)), 12
      LINE -(splat.xpos - 4, (splat.ypos + 3)), 12
      LINE -(splat.xpos - 2, (splat.ypos)), 12
      LINE -(splat.xpos - 4, (splat.ypos - 3)), 12
      LINE -(splat.xpos - 1, (splat.ypos - 2)), 12
      LINE -(splat.xpos, (splat.ypos - 5)), 12
      splat.frame = splat.frame + 1
      IF splat.frame > 5 THEN splat.frame = 0
   END IF

   PCOPY 1, 0

   ' Adjust players' frame.
   FOR i% = 1 TO 2
      player(i%).frame = player(i%).frame + player(i%).mframe

      IF player(i%).frame = 4 OR player(i%).frame = 8 THEN
         player(i%).mframe = -player(i%).mframe
         player(i%).tframe = 1
      END IF

      IF player(i%).frame = 1 AND player(i%).tframe = 1 THEN
         player(i%).tframe = 0
         player(i%).frame = 1
         player(i%).mframe = 0
      END IF

      IF player(i%).frame = 5 AND player(i%).tframe = 1 THEN
         player(i%).tframe = 0
         player(i%).frame = 1
         player(i%).mframe = 0
      END IF

      IF player(i%).frame > 9 THEN
         IF player(i%).frame < 14 THEN
            player(i%).frame = 9
            player(i%).mframe = player(i%).mframe + 1
         ELSE
            player(i%).frame = 1
            player(i%).mframe = 0
         END IF
      END IF

   NEXT i%

LOOP
