/*

            T A N Q U E S   1.0        1.996   BY  FEGOR                

                                                                        
 MODULO   > TECLADO.C                                                   
 AUTOR    > Fernando Gonzlez Ruano (FEGOR)                             
 VERSION  > 1.0                                                         
 LENGUAJE > Borland C/C++ versin 3.1                                   
                                                                        

                                                                        
 Funciones de vdeo                                                     
                                                                        

                   CLUB VIRTUAL ZONE    -1.996-                         

*/

#pragma inline

#include <dos.h>
#include <stdlib.h>

/*

 defines                                                                

*/
#define INTER_KEYB_BIOS 0x16
#define IRQ9            0x9

/*

 variables pblicas o generales                                         

*/
unsigned int CodigoLetra[128];			// tabla de cd. de teclas
unsigned char CodigoActual;			// cdigo actual
void interrupt (*IRQ9Anterior)(void);		// interr. IRQ 9 (teclado)

/*

 funcin de control del teclado                                         

*/
void interrupt ControlaTeclado()
{
  disable();				// fuera interrupciones

lazo:                   		// limpia buffer de teclado
      asm{
	   mov	ah,0x11
	   int	0x16
	   jz	fuera
	   mov	ah,0x10
	   int	0x16
	   jmp	lazo
      }
fuera:

  CodigoActual = inportb(0x60);		// lectura del cdigo scan

  if(CodigoActual < 0x80)		// make?
    CodigoLetra[CodigoActual]=1;	// si
  else
    CodigoLetra[CodigoActual-0x80]=0;	// no (resta 128)

  enable();				// activacin de interrupciones
  IRQ9Anterior();			// llamamos al vector original
}

/*

 instalacin de rutina de teclado                                       

*/
void InstalaTeclado()
{
  int i;				// contador

  for(i=1;i<127;i++)
    CodigoLetra[i] = 0;         	// inicializa tabla

  IRQ9Anterior = getvect(IRQ9);		// recoge vector original
  setvect(IRQ9,ControlaTeclado);	// nueva funcin
}

/*

 restaura la IRQ 9 antigua                                              

*/
void DesInstalaTeclado()
{
  setvect(IRQ9,IRQ9Anterior);
}
