DECLARE SUB Soundk (Adlib%)
DECLARE SUB FileCheck ()
DECLARE SUB Check ()
DECLARE SUB Centre (QRow%, Text$)
DECLARE SUB GetCDRom (NoCDDrives%, firstcd$, IsMSCDEX%)
DECLARE SUB GetCountryInfo (CountryID%, CodePage%, DateForm$, CurrSym$, CurrForm$(), ThousSep$, DecSep$, TimeSep$, Clock%, ASCIIZSep$)
DECLARE SUB GetDiskSpace (Dr$, TotalSpace&, FreeSpace&)
DECLARE SUB GetFloppyInfo (Dr$, FlopSize!, FlopCap$)
DECLARE SUB GetMachineInfo (BIOSDate$, MachType$)
DECLARE SUB GetMem (convmem%, extmem%, videomem%)
DECLARE SUB GetScreenMode (ScrMode%, ScrCols%, ScrRows%, CharHor%, CharVer%, ScrMaxX%, ScrMaxY%, MaxColours%, videomem%, Page%)
DECLARE SUB GetSysConfig (FlDrives%, copro%, RS232s%, GPort%, modem%, Printers%)
DECLARE SUB MouseClear ()
DECLARE SUB MouseDriver (m0%, m1%, m2%, m3%)
DECLARE SUB MouseInfo (MouseVers!, MouseType$, MouseIRQ%)
DECLARE FUNCTION GetCallingPath$ ()
DECLARE FUNCTION GetDosVer! ()
DECLARE FUNCTION GetNoDrives% ()
DECLARE FUNCTION GetPrinterStatus% ()
DECLARE FUNCTION IsAnsi% ()
DECLARE FUNCTION IsDoskey% ()
DECLARE FUNCTION IsHimem% ()
DECLARE FUNCTION IsPrintQ% ()
DECLARE FUNCTION IsShare% ()
DECLARE FUNCTION MouseCheck% ()
DECLARE FUNCTION VolLab$ (Dr$)

DEFINT A-Z

CONST PI = 3.14159265358979#
CONST TRUE = -1
CONST FALSE = NOT TRUE

TYPE RegTypeX
  ax    AS INTEGER
  bx    AS INTEGER
  cx    AS INTEGER
  dx    AS INTEGER
  bp    AS INTEGER
  si    AS INTEGER
  di    AS INTEGER
  flags AS INTEGER
  ds    AS INTEGER
  es    AS INTEGER
END TYPE

DECLARE SUB InterruptX (IntNum%, regsx AS RegTypeX)

DIM SHARED regsx AS RegTypeX
DIM SHARED MousePresent
DIM SHARED MouseChecked

ON ERROR GOTO Fehler
SCREEN 12: SCREEN 0

Check

Fehler:
  COLOR 12, 0
 PRINT "Programmabbruch !"
 PRINT "Fehlernummer:"; ERR
  SLEEP
  COLOR 7, 0
  SYSTEM
RESUME
'-----------------------------------------------------------------------------------------------
'hex data for interrupt routines
DATA  &H55, &H8B, &HEC, &H83, &HEC, &H08, &H56, &H57, &H1E, &H55, &H8B, &H5E
DATA  &H06, &H8B, &H47, &H10, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H10, &H8B, &H47, &H12, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H12, &H8B, &H47, &H08, &H89, &H46, &HF8, &H8B, &H07, &H8B, &H4F, &H04
DATA  &H8B, &H57, &H06, &H8B, &H77, &H0A, &H8B, &H7F, &H0C, &HFF, &H77, &H12
DATA  &H07, &HFF, &H77, &H02, &H1E, &H8F, &H46, &HFA, &HFF, &H77, &H10, &H1F
DATA  &H8B, &H6E, &HF8, &H5B, &HCD, &H21, &H55, &H8B, &HEC, &H8B, &H6E, &H02
DATA  &H89, &H5E, &HFC, &H8B, &H5E, &H06, &H1E, &H8F, &H46, &HFE, &HFF, &H76
DATA  &HFA, &H1F, &H89, &H07, &H8B, &H46, &HFC, &H89, &H47, &H02, &H89, &H4F
DATA  &H04, &H89, &H57, &H06, &H58, &H89, &H47, &H08, &H89, &H77, &H0A, &H89
DATA  &H7F, &H0C, &H9C, &H8F, &H47, &H0E, &H06, &H8F, &H47, &H12, &H8B, &H46
DATA  &HFE, &H89, &H47, &H10, &H5A, &H1F, &H5F, &H5E, &H8B, &HE5, &H5D, &HCA
DATA  &H02, &H00

DATA 5,4
DATA 4,6
DATA 5.5,7.5
DATA 6.5,6.5
DATA 7.5,7.5
DATA 8,6
DATA 3,3
DATA 6.5,4
DATA 5,6
DATA 7,7
DATA 9,7
DATA 9,9

'Prints Text$ centrally on QRow.
'[DB]
SUB Centre (QRow, Text$)

  GetScreenMode 0, ScrCols, 0, 0, 0, 0, 0, 0, 0, 0
  LOCATE QRow, (ScrCols - LEN(Text$)) \ 2
  PRINT Text$;

END SUB

SUB Check

CLS
COLOR 14, 9
FOR i% = 1 TO 80
 LOCATE 1, i%
 PRINT " "
NEXT i%

Centre 1, "INT OSystem Version 1.2"

COLOR 30, 1

PRINT
PRINT "Initialisierung ..."
 t! = TIMER: DO: LOOP UNTIL TIMER > t! + 1
LOCATE CSRLIN - 1
 COLOR 7, 0
PRINT "Initialisierung ... OK"

'***********************
CALL Soundk(Adlib%)
CALL GetCDRom(cdanz%, firstcd$, mscdex%)
CALL GetDiskSpace(MID$(GetCallingPath, 1, 1), total&, free&)
CALL GetMem(convmem%, extmem%, videomem%)
CALL GetSysConfig(flanz%, copro%, rs%, gp%, modem%, printeranz%)
CALL GetMachineInfo(bd$, mt$)
CALL MouseInfo(mver!, mtyp$, irq)
mc = MouseCheck
dosver! = GetDosVer
label$ = VolLab(MID$(GetCallingPath, 1, 1))
callpath$ = GetCallingPath

'***********************
PRINT "Setze Videomodus ..."
 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5
WIDTH 80, 43

COLOR 14, 9
FOR i% = 1 TO 80
 LOCATE 1, i%
 PRINT " "
NEXT i%

Centre 1, "INT OSystem Version 1.2"

COLOR 7, 0

PRINT
PRINT "Initialisierung ... OK"
PRINT "Setze Videomodus ... OK"
PRINT
'***********************
PRINT "Startlaufwerk: "; label$
'***********************
PRINT "Startaufruf:   "; callpath$
'***********************
PRINT
PRINT "berprfe DOS Version ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF dosver! > 4 THEN               'berprfen, ob DOS Version > ist als 4.0
  PRINT "berprfe DOS Version ..."; dosver!; "OK"        'ja, dann weiter
ELSE
  COLOR 12, 0
   PRINT "berprfe DOS Version ..."; dosver!; "FAILED"  'nein, dann abbrechen
  SYSTEM
END IF
'**********************
PRINT
PRINT "berprfe Speicher ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF convmem% - 305 > 250 THEN         'berprfe, ob Konv. Sp. ausreicht
 PRINT "berprfe Speicher ..."; convmem% - 305; "KB"; " OK"
ELSE
 COLOR 12, 0
  PRINT "berprfe Speicher ..."; convmem% - 305; "KB"; " FAILED"
 SYSTEM
END IF
'**********************
PRINT "berprfe Videospeicher ..."
LOCATE CSRLIN - 1
 
 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF videomem% > 255 THEN                  'berprfe, ob Videospeicher mind. 256KB
 PRINT "berprfe Videospeicher ..."; videomem%; "KB"; " (oder grer)"; " OK"
ELSE
 COLOR 12, 0
  PRINT "berprfe Videospeicher ..."; videomem%; "KB"; " FAILED"
 SYSTEM
END IF
'**********************
PRINT "berprfe Festplattenplatz ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF free& > 500000 THEN
 PRINT "berprfe Festplattenplatz ..."; free&; "Byte"; " OK"
ELSE
 COLOR 12, 0
  PRINT "berprfe Festplattenplatz ..."; free&; "Byte"; " FAILED"
 SYSTEM
END IF
'**********************
PRINT
PRINT "berprfe Maus ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF mc = -1 THEN
 PRINT "berprfe Maus ... gefunden"
ELSE
 COLOR 12, 0
  PRINT "berprfe Maus ... nicht gefunden"
 SYSTEM
END IF
'**********************
PRINT "Maus Info ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

PRINT "Maus Info ... "; "Version:"; mver!; "  Typ: "; mtyp$, "  Interrupt:"; irq
'**********************
PRINT
PRINT "CD-Laufwerk 1 ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

PRINT "CD-Laufwerk 1 ... "; firstcd$
'**********************
PRINT "Anzahl der CD-Laufwerke ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

PRINT "Anzahl der CD-Laufwerke ..."; cdanz%
'**********************
PRINT "CD-Lw. - Treiber ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF mscdex% = -1 THEN
  PRINT "CD-Lw. - Treiber ... MSCDEX"
ELSE
  PRINT "CD-Lw. - Treiber ... MSCDEX nicht gefunden"
END IF
'**********************
PRINT "Diskettenlaufwerke ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

PRINT "Diskettenlaufwerke ..."; flanz%
'**********************
PRINT
PRINT "Coprozessor ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF copro% = -1 THEN
 PRINT "Coprozessor ... vorhanden"
  OPEN "Speed.Cfg" FOR OUTPUT AS #1: WRITE #1, "1": CLOSE
ELSE
 PRINT "Coprozessor ... fehlt"
  OPEN "Speed.Cfg" FOR OUTPUT AS #1: WRITE #1, "0": CLOSE
END IF
'**********************
PRINT
PRINT "DosKey.EXE ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF IsDoskey% = -1 THEN
 PRINT "DosKey.EXE ... installiert"
ELSE
 PRINT "DosKey.EXE ... nicht installiert"
END IF
'**********************
PRINT "HiMem.SYS ... "
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF IsHimem% = -1 THEN
 PRINT "HiMem.SYS ... installiert"
ELSE
 PRINT "HiMem.SYS ... nicht installiert"
END IF
'*********************
PRINT "Ansi.SYS ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF IsAnsi% = -1 THEN
 PRINT "Ansi.SYS ... installiert"
ELSE
 PRINT "Ansi.SYS ... nicht installiert"
END IF
'*********************
PRINT "Share.EXE ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF IsShare% = -1 THEN
 PRINT "Share.EXE ... installiert"
ELSE
 PRINT "Share.EXE ... nicht installiert"
END IF
'*********************
PRINT
PRINT "Gameport ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF gp% = -1 THEN
 PRINT "Gameport ... gefunden"
ELSE
 PRINT "Gameport ... nicht gefunden"
END IF
'*********************
PRINT "Anzahl Drucker ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

PRINT "Anzahl Drucker ..."; printeranz%
'*********************
PRINT
PRINT "Bios Datum ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

PRINT "Bios Datum ... "; bd$
'*********************
PRINT "Computertyp ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

PRINT "Computertyp ... "; mt$
'*********************
PRINT "Suche Soundkarte ..."
LOCATE CSRLIN - 1

 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .5

IF Adlib% = 1 THEN
 PRINT "Suche Soundkarte ... gefunden"
ELSE
 PRINT "Suche Soundkarte ... nicht gefunden"
END IF
'*********************
PRINT
COLOR 26, 1
PRINT "Computer OK"
PRINT

'*********************
COLOR 30, 1
PRINT "berprfe Dateien ..."

CALL FileCheck

COLOR 10, 0
PRINT "Taste drcken"
SLEEP

COLOR 15, 0
LOCATE CSRLIN - 1
PRINT "             "
PRINT "Lade ...     "
 t! = TIMER: DO: LOOP UNTIL TIMER > t! + .8

OPEN "sb.cfg" FOR OUTPUT AS #1
 WRITE #1, Adlib%
CLOSE #1

RUN "LOGO"

END SUB

SUB FileCheck

CLOSE
OPEN "TUNNEL.BAS" FOR INPUT AS #1
OPEN "LOGO.BAS" FOR INPUT AS #2
OPEN "LOGO.EXE" FOR INPUT AS #3
OPEN "MENU.BAS" FOR INPUT AS #4
OPEN "INT_OS.BAS" FOR INPUT AS #5
OPEN "DATA_X.DAT" FOR INPUT AS #6
OPEN "DATA_Y.DAT" FOR INPUT AS #7
OPEN "GRAFIK_L.DAT" FOR INPUT AS #8
OPEN "GRAFIK_R.DAT" FOR INPUT AS #9

IF LOF(1) <> 53425 THEN LOCATE CSRLIN - 1: COLOR 12, 0: PRINT "berprfe Dateien ... FAILED": SYSTEM
IF LOF(2) <> 674 THEN LOCATE CSRLIN - 1: COLOR 12, 0: PRINT "berprfe Dateien ... FAILED": SYSTEM
IF LOF(3) <> 9265 THEN LOCATE CSRLIN - 1: COLOR 12, 0: PRINT "berprfe Dateien ... FAILED": SYSTEM
IF LOF(6) <> 9727 THEN LOCATE CSRLIN - 1: COLOR 12, 0: PRINT "berprfe Dateien ... FAILED": SYSTEM
IF LOF(7) <> 4927 THEN LOCATE CSRLIN - 1: COLOR 12, 0: PRINT "berprfe Dateien ... FAILED": SYSTEM
IF LOF(8) <> 811 THEN LOCATE CSRLIN - 1: COLOR 12, 0: PRINT "berprfe Dateien ... FAILED": SYSTEM
IF LOF(9) <> 811 THEN LOCATE CSRLIN - 1: COLOR 12, 0: PRINT "berprfe Dateien ... FAILED": SYSTEM

CLOSE

COLOR 0, 0
LOCATE CSRLIN - 1
PRINT SPC(30);
LOCATE CSRLIN, 1
 COLOR 26, 1
PRINT "Dateien  OK"


END SUB

DEFSNG A-Z
'Gets path to .EXE
'[MB]
FUNCTION GetCallingPath$
 
  regsx.ax = &H6200
  InterruptX &H21, regsx
  PSPStart% = regsx.bx

  DEF SEG = PSPStart%
  EnvironStart% = PEEK(&H2D) * 256 + PEEK(&H2C)
  DEF SEG

  DEF SEG = EnvironStart%
  DO
    Char = PEEK(a)
    IF Char = 0 THEN
      a = a + 1
      Char = PEEK(a)
      IF Char = 0 THEN
	Found = TRUE
      END IF
    END IF
    a = a + 1
  LOOP UNTIL Found
  a = a + 2
  Found = FALSE
  DO
    Char = PEEK(a)
    IF Char = 0 THEN
      Found = TRUE
    ELSE
      Path$ = Path$ + CHR$(Char)
    END IF
    a = a + 1
  LOOP UNTIL Found
  DEF SEG
  GetCallingPath$ = Path$

END FUNCTION

DEFINT A-Z
'Returns number of CD drives on system, first drive's letter, & whether
' MSCDEX is loaded.
'[Based on code by WH]
SUB GetCDRom (NoCDDrives, firstcd$, IsMSCDEX)

  '************************
  regsx.ax = &H1500
  regsx.bx = 0
  InterruptX &H2F, regsx

  NoCDDrives = regsx.bx

  IF NoCDDrives THEN
    firstcd$ = CHR$(65 + regsx.cx)
    regsx.ax = &H150B
    regsx.bx = 0
    InterruptX &H2F, regsx
    IsMSCDEX = (regsx.bx = &HADAD)
  END IF

END SUB

'Returns country specific info about machine:
' CountryID = Dos ID number
' CodePage = Dos code page
' DateForm$ = Date format
' CurrSym$ = Currency symbol
' CurrForm$(1) = Currency format (w/out decimal)
' CurrForm$(2) = Currency format (with decimal)
' ThousSep$ = '000s separator
' DecSep$ = Decimal separator
' TimeSep$ = Time separator
' Clock = 12/24 hour clock
' ASCIIZSep$ = ASCII data list separator
'[DB]
SUB GetCountryInfo (CountryID, CodePage, DateForm$, CurrSym$, CurrForm$(), ThousSep$, DecSep$, TimeSep$, Clock, ASCIIZSep$)

  DIM Val2(40) AS INTEGER
  DIM Buffer(40) AS INTEGER
  DIM BufLength AS LONG
 
  regsx.ax = &H6501
  regsx.bx = -1
  regsx.cx = 41
  regsx.dx = -1
  regsx.es = VARSEG(Buffer(0))
  regsx.di = VARPTR(Buffer(0))

  InterruptX &H21, regsx

  DEF SEG = VARSEG(Buffer(0))
  FOR a = 0 TO 2
    Val2(a) = PEEK(regsx.di + a)
  NEXT
  DEF SEG

'  IDCode = Val2(0) 'Don't know what use this is...

  BufLength = Val2(2) * 256 + Val2(1)
 
  DEF SEG = VARSEG(Buffer(0))
  FOR a = 3 TO BufLength + 2
    Val2(a) = PEEK(regsx.di + a)
  NEXT
  DEF SEG

  CountryID = 256 * Val2(4) + Val2(3)
  CodePage = 256 * Val2(6) + Val2(5)

  DateSep$ = CHR$(Val2(&H12))
  SELECT CASE Val2(7)
    CASE 0: DateForm$ = "mm" + DateSep$ + "dd" + DateSep$ + "yy"
    CASE 1: DateForm$ = "dd" + DateSep$ + "mm" + DateSep$ + "yy"
    CASE 2: DateForm$ = "yy" + DateSep$ + "mm" + DateSep$ + "dd"
  END SELECT
 
  CurrSym$ = CHR$(Val2(9)) + CHR$(Val2(10)) + CHR$(Val2(11)) + CHR$(Val2(12)) + CHR$(Val2(13))
  CurrSym$ = LEFT$(CurrSym$, INSTR(CurrSym$, CHR$(0)) - 1)
  ThousSep$ = CHR$(Val2(&HE))
  DecSep$ = CHR$(Val2(&H10))
  TimeSep$ = CHR$(Val2(&H14))
  DigsAftDec = Val2(&H17)
 
  SELECT CASE Val2(&H16)
    CASE 0
      CurrForm$(1) = CurrSym$ + "0"
      CurrForm$(2) = CurrSym$ + "0" + DecSep$ + STRING$(DigsAftDec, "0")
    CASE 1
      CurrForm$(1) = "0" + CurrSym$
      CurrForm$(2) = "0" + DecSep$ + STRING$(DigsAftDec, "0") + CurrSym$
    CASE 2
      CurrForm$(1) = CurrSym$ + " 0"
      CurrForm$(2) = CurrSym$ + " 0" + DecSep$ + STRING$(DigsAftDec, "0")
    CASE 3
      CurrForm$(1) = "0" + " " + CurrSym$
      CurrForm$(2) = "0" + DecSep$ + STRING$(DigsAftDec, "0") + " " + CurrSym$
    CASE 4
      CurrForm$(1) = CurrSym$ + "0"
      CurrForm$(2) = "0" + CurrSym$ + STRING$(DigsAftDec, "0")
    CASE 5
      CurrForm$(1) = "0" + CurrSym$
      CurrForm$(2) = "0" + CurrSym$ + STRING$(DigsAftDec, "0")
    CASE 6
      CurrForm$(1) = CurrSym$ + " 0"
      CurrForm$(2) = "0" + CurrSym$ + STRING$(DigsAftDec, "0")
    CASE 7
      CurrForm$(1) = "0 " + CurrSym$
      CurrForm$(2) = "0" + CurrSym$ + STRING$(DigsAftDec, "0")
  END SELECT

  Clock = 12 + Val2(&H18) * 12
  ASCIIZSep$ = CHR$(Val2(&H1D))

END SUB

DEFSNG A-Z
'[DB, using calculation kludges from code by DJ]
SUB GetDiskSpace (Dr$, TotalSpace&, FreeSpace&)

  IF Dr$ = "" THEN
    DrCode = 0
  ELSE
    Dr$ = UCASE$(LEFT$(Dr$, 1))
    DrCode = ASC(Dr$) - 64
  END IF

  regsx.ax = &H3600
  regsx.dx = DrCode
  InterruptX &H21, regsx

  IF regsx.ax = &HFFFF THEN
    FreeSpace& = -1
  ELSE
    bpc& = regsx.ax
    bpc& = bpc& * regsx.cx           ' Calculate bytes per cluster
    Temp& = bpc& * (regsx.bx AND &H7FFF)    ' Multiply by total clusters
    IF (regsx.bx < 0) THEN                  ' kludge time !
      Temp& = Temp& + (bpc& * &H4000)
      Temp& = Temp& + (bpc& * &H4000)
    END IF
    FreeSpace& = Temp&
    bpc& = regsx.ax
    bpc& = bpc& * regsx.cx           ' Calculate bytes per cluster
    Temp& = bpc& * (regsx.dx AND &H7FFF)    ' Multiply by total clusters
    IF (regsx.dx < 0) THEN                  ' kludge time !
      Temp& = Temp& + (bpc& * &H4000)
      Temp& = Temp& + (bpc& * &H4000)
    END IF
    TotalSpace& = Temp&
  END IF

  ' ax = sectors per cluster or error
  ' bx = number of available clusters
  ' cx = bytes per sector
  ' dx = total number of clusters

END SUB

'[DB]
FUNCTION GetDosVer

  regsx.ax = &H3000

  InterruptX &H21, regsx

  IF regsx.ax AND 255 = 0 THEN
    GetDosVer = 1
  ELSE
    GetDosVer = (regsx.ax AND 255) + (regsx.ax AND 65280) / 25600
  END IF

'[OEM's serial number = (regsx.bx AND 65280) / 256]
'[User's serial number = (regsx.bx AND 255) * 2 ^ 16 + regsx.cx]

END FUNCTION

DEFINT A-Z
' Simple program to return floppy disk info from CMOS RAM
'[Anon, I think from a PC mag]
SUB GetFloppyInfo (Dr$, FlopSize!, FlopCap$)

  FlopSize! = -1  'Default, unknown type

  IF Dr$ <> "" THEN
    Dr$ = UCASE$(LEFT$(Dr$, 1))
    IF Dr$ = "A" OR Dr$ = "B" THEN
      OUT &H70, &H10                  ' Request data for floppy diskettes
      info = INP(&H71)               ' Get returned data
      IF Dr$ = "A" THEN
	info = info / 16
      ELSE
	info = info AND 15
      END IF
     
      SELECT CASE info
	CASE 0
	  FlopSize! = 0
	  FlopCap$ = ""
	CASE 1
	  FlopSize! = 5.25
	  FlopCap$ = "360k"
	CASE 2
	  FlopSize! = 5.25
	  FlopCap$ = "1.2M"
	CASE 3
	  FlopSize! = 3.5
	  FlopCap$ = "720k"
	CASE 4
	  FlopSize! = 3.5
	  FlopCap$ = "1.44M"
      END SELECT
    END IF
  END IF

END SUB

'Reads BIOS to get machine info
'[DB]
SUB GetMachineInfo (BIOSDate$, MachType$)

  DEF SEG = &HF000
  BIOSDate$ = ""
  FOR Offset = &HFFF5 TO (&HFFF5 + 7)
    BIOSDate$ = BIOSDate$ + CHR$(PEEK(Offset))
  NEXT

  SELECT CASE PEEK(&HFFFE)
    CASE &H9A: MachType$ = "COMPAQ Plus"
    CASE &HFF: MachType$ = "IBM PC"
    CASE &HFE: MachType$ = "PC XT, Portable PC"
    CASE &HFD: MachType$ = "PCjr"
    CASE &HFC: MachType$ = "Personal Computer AT, PS/2 Models 50 und 60"
    CASE &HFB: MachType$ = "PC XT (nach 10.1.86)"
    CASE &HFA: MachType$ = "PS/2 Model 30"
    CASE &HF9: MachType$ = "Convertible PC"
    CASE &HF8: MachType$ = "PS/2 Model 80"
    CASE ELSE: MachType$ = "unbekannt"
  END SELECT
  DEF SEG

END SUB

'Gets memory available
'[DB]
SUB GetMem (convmem, extmem, videomem)

  InterruptX &H12, regsx
  convmem = regsx.ax
  regsx.ax = &H8800
  InterruptX &H15, regsx
  extmem = regsx.ax
  GetScreenMode 0, 0, 0, 0, 0, 0, 0, 0, videomem, 0

END SUB

' Return number of online drives
'[DJ]
FUNCTION GetNoDrives

  ' First, get default drive in AL
  regsx.ax = &H1900
  InterruptX &H21, regsx

  ' Now set to the drive we're already on....
  regsx.dx = regsx.ax
  regsx.ax = &HE00
  InterruptX &H21, regsx

  GetNoDrives = regsx.ax AND 255

END FUNCTION

'Returns information on the current screen mode:
'  ScrMode = Mode set by last SCREEN statement
'  ScrCols = Number of character columns
'  ScrRows = Number of character rows
'  CharHor = Width in pixels of text character
'  CharVer = Height in pixels of text character
'  ScrMaxX = Width in pixels of screen
'  ScrMaxY = Height in pixels of screen
'  MaxColours = Number of colours
'  VideoMem = Maximum video memory (in kbytes)
'  Page = Current screen page
'[DB]
SUB GetScreenMode (ScrMode, ScrCols, ScrRows, CharHor, CharVer, ScrMaxX, ScrMaxY, MaxColours, videomem, Page)

  DIM Buffer(200) AS INTEGER

  regsx.ax = &H1130
  regsx.bx = &H0
  InterruptX &H10, regsx
  ScrRows = (regsx.dx AND 255) + 1

  regsx.ax = &HF00
  InterruptX &H10, regsx
  ScrCols = (regsx.ax AND 65280) / 256
  Page = (regsx.bx AND 65280) / 256

  SELECT CASE regsx.ax AND 255
    CASE 0, 1
      ScrMode = 0
      CharHor = 9
      CharVer = 16
      ScrMaxX = 0
      ScrMaxY = 0
      MaxColours = 16

    CASE 2, 3
      ScrMode = 0
      IF ScrRows = 25 THEN
	CharHor = 9
	CharVer = 16
      ELSE
	CharHor = 8
	CharVer = 8
      END IF
      ScrMaxX = 0
      ScrMaxY = 0
      MaxColours = 16
	
    CASE 4, 5
      ScrMode = 1
      CharHor = 8
      CharVer = 8
      ScrMaxX = 320
      ScrMaxY = 200
      MaxColours = 4

    CASE 6
      ScrMode = 2
      CharHor = 8
      CharVer = 8
      ScrMaxX = 640
      ScrMaxY = 200
      MaxColours = 2

    CASE 7
      ScrMode = 0
      IF ScrRows = 25 THEN
	CharHor = 9
	CharVer = 16
      ELSE
	CharHor = 8
	CharVer = 8
      END IF
      ScrMaxX = 0
      ScrMaxY = 0
      MaxColours = 16

    CASE 13
      ScrMode = 7
      CharHor = 8
      CharVer = 8
      ScrMaxX = 320
      ScrMaxY = 200
      MaxColours = 16

    CASE 14
      ScrMode = 8
      CharHor = 8
      CharVer = 8
      ScrMaxX = 640
      ScrMaxY = 200
      MaxColours = 16

    CASE 15
      ScrMode = 10
      IF ScrRows = 25 THEN
	CharHor = 8
	CharVer = 14
      ELSE
	CharHor = 8
	CharVer = 8
      END IF
      ScrMaxX = 640
      ScrMaxY = 350
      MaxColours = 4

    CASE 16
      ScrMode = 9
      IF ScrRows = 25 THEN
	CharHor = 8
	CharVer = 14
      ELSE
	CharHor = 8
	CharVer = 8
      END IF
      ScrMaxX = 640
      ScrMaxY = 350
      MaxColours = 16

    CASE 17
      ScrMode = 11
      IF ScrRows = 30 THEN
	CharHor = 8
	CharVer = 16
      ELSE
	CharHor = 8
	CharVer = 8
      END IF
      ScrMaxX = 640
      ScrMaxY = 480
      MaxColours = 2

    CASE 18
      ScrMode = 12
      IF ScrRows = 30 THEN
	CharHor = 8
	CharVer = 16
      ELSE
	CharHor = 8
	CharVer = 8
      END IF
      ScrMaxX = 640
      ScrMaxY = 480
      MaxColours = 16

    CASE 19
      ScrMode = 13
      CharHor = 8
      CharVer = 8
      ScrMaxX = 320
      ScrMaxY = 200
      MaxColours = 256

  END SELECT
 
  regsx.ax = &H1B00
  regsx.bx = &H0
  regsx.es = VARSEG(Buffer(0))
  regsx.di = VARPTR(Buffer(0))

  SCREEN ScrMode
  WIDTH ScrCols, ScrRows

  InterruptX &H10, regsx

  DEF SEG = VARSEG(Buffer(0))
  videomem = PEEK(regsx.di + 49)
  DEF SEG

  SELECT CASE videomem
    CASE 0
      videomem = 64
    CASE 1
      videomem = 128
    CASE 2
      videomem = 192
    CASE 3
      videomem = 256
  END SELECT

END SUB

'Returns system setup info:
' FlDrives = Number of floppy drives
' CoPro = Co-processor present
' RS232s = Number of RS232s
' GPort = Game port present
' Modem = Modem present
' Printers = Number of printers
'[DB]
SUB GetSysConfig (FlDrives, copro, RS232s, GPort, modem, Printers)
 
  InterruptX &H11, regsx

  IF regsx.ax AND 1 THEN
    FlDrives = (regsx.ax AND 192) / 64 + 1
  END IF
 
  copro = ((regsx.ax AND 2) <> 0)
 
  RS232s = (regsx.ax AND 3584) / 512
  GPort = ((regsx.ax AND 4096) <> 0)
  modem = ((regsx.ax AND 8192 <> 0))
  Printers = (regsx.ax AND 49152) / 16384

END SUB

'[IM, from code by DG]
SUB InterruptX (IntNum, regsx AS RegTypeX) STATIC

  STATIC FileNum, IntOffset, Loaded
  
  ' use fixed-length string to fix its position in memory
  ' and so we don't mess up string pool before routine
  ' gets its pointers from caller
  DIM IntCode AS STRING * 200
  IF NOT Loaded THEN                        ' loaded will be 0 first time
   
    FOR k = 0 TO 145 'bit of a bodge, this, but it works <dg>
      READ h%        'if anyone fixes it, or explains it, let me know :) <dg>
      Icode$ = Icode$ + CHR$(h%)
    NEXT             'end of bodge <dg>
    
    IntCode = Icode$  ' load routine and determine
    IntOffset = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1 ' int # offset
    Loaded = -1
  END IF
 
  DEF SEG = VARSEG(IntCode)             ' poke interrupt number into
  POKE VARPTR(IntCode) * 1& + IntOffset - 1, IntNum' code block
  CALL absolute(regsx, VARPTR(IntCode$)) ' call routine
  DEF SEG

END SUB

'Returns whether ANSI.SYS is loaded
'[DB, from code by WH]
FUNCTION IsAnsi
 
  regsx.ax = &H1A00
  InterruptX &H2F, regsx
  IsAnsi = ((regsx.ax AND &HFF) <> 0)

END FUNCTION

'Returns whether DOSKEY.COM is loaded
'[DB, from code by WH]
FUNCTION IsDoskey
   
  regsx.ax = &H4800
  InterruptX &H2F, regsx
  IsDoskey = ((regsx.ax AND &HFF) <> 0)

END FUNCTION

'Returns whether HIMEM.SYS is loaded
'[DB, from code by WH]
FUNCTION IsHimem

  regsx.ax = &H4300
  InterruptX &H2F, regsx
  IsHimem = ((regsx.ax AND &HFF) <> 0)

END FUNCTION

'Returns whether there is a print queue
'[DB, from code by WH]
FUNCTION IsPrintQ
 
  regsx.ax = &H100
  InterruptX &H2F, regsx
  IsPrintQ = ((regsx.ax AND &HFF) <> 0)

END FUNCTION

'Returns whether SHARE.EXE, or Windows similar, is loaded
'[DB, from code by WH]
FUNCTION IsShare

  regsx.ax = &H1000
  InterruptX &H2F, regsx
  IsShare = ((regsx.ax AND &HFF) <> 0)

END FUNCTION

'Similar to MouseInit, but returns mouse status
'
FUNCTION MouseCheck

  MouseDriver 0, 0, 0, 0
  MouseCheck = MousePresent

END FUNCTION

'General interrupt routine for mouse. See more advanced programming
' information for list of possible parameters.
'[DB, from code by MS]
SUB MouseDriver (m0, m1, m2, m3) STATIC

  IF NOT (MouseChecked) THEN
    DEF SEG = 0
    MouseSegment& = 256& * PEEK(207) + PEEK(206)
    MouseOffset& = 256& * PEEK(205) + PEEK(204)
    DEF SEG = MouseSegment&

    IF (MouseSegment& = 0 AND MouseOffset& = 0) OR PEEK(MouseOffset&) = 207 THEN
      MousePresent = FALSE
      MouseChecked = TRUE
      DEF SEG
    END IF
  END IF

  IF NOT (MouseChecked) OR MousePresent THEN

    ' Calls interrupt &H33 to invoke mouse functions in the MS Mouse Driver.
    regsx.ax = m0
    regsx.bx = m1
    regsx.cx = m2
    regsx.dx = m3

    InterruptX &H33, regsx

    m0 = regsx.ax
    m1 = regsx.bx
    m2 = regsx.cx
    m3 = regsx.dx

    IF NOT MouseChecked THEN
      ' Check for successful mouse initialization
      IF m0 THEN
	MousePresent = TRUE
	DEF SEG
      END IF
      MouseChecked = TRUE
    END IF
  END IF

END SUB

'MouseVers = Mouse driver version (x.xx)
'MouseType$ = Describes mouse
'MouseIRQ = IRQ being used by mouse (0 = PS/2 system)
'[DB]
SUB MouseInfo (MouseVers!, MouseType$, MouseIRQ)

  m0% = &H24
  MouseDriver m0%, m1%, m2%, m3%

  MouseVers! = ((m1% AND &HFF00) / 256) + ((m1% AND 255) / 100)
  SELECT CASE (m2% AND &HFF00) / 256
    CASE 1: MouseType$ = "Bus"
    CASE 2: MouseType$ = "Serial"
    CASE 3: MouseType$ = "InPort"
    CASE 4: MouseType$ = "PS/2"
    CASE 5: MouseType$ = "HP"
    CASE ELSE: MouseType$ = "Unknown"
  END SELECT
  MouseIRQ = m2% AND 255

END SUB

'Mouse driver's initialisation routine
'[MS]
SUB MouseInit

  MouseDriver 0, 0, 0, 0

END SUB

SUB Soundk (Adlib%)

OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H60: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H80: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
Astat1 = INP(&H388)
OUT &H388, &H2: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &HFF: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H21: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
SLEEP 1
Astat2 = INP(&H388)
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H60: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H80: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
Ares1 = Astat1 AND &HE0: Ares2 = Astat2 AND &HE0
Adlib% = 0: IF Ares1 = 0 AND Ares2 = 192 THEN Adlib% = 1

END SUB

'Returns the volume label for drive Dr$: based on Ian Musgrave's DIR$
'[DB, from code by BJ]
FUNCTION VolLab$ (Dr$)

  DIM DTA AS STRING * 44

  '-----  Set up our own DTA so we don't destroy COMMAND$
  regsx.ax = &H1A00                    'Set DTA function
  regsx.dx = VARPTR(DTA)               'DS:DX points to our DTA
  regsx.ds = -1                        'Use current value for DS
  InterruptX &H21, regsx                 'Do the interrupt
    
  IF Dr$ <> "" THEN
    Dr$ = UCASE$(LEFT$(Dr$, 1)) + ":"
  END IF

  DrZ$ = Dr$ + "\*.*" + CHR$(0)                           ' make a$ asciiz

  regsx.ax = &H4E00              'Perform a FindFirst
  regsx.cx = 8
  regsx.dx = SADD(DrZ$)       'DS:DX points to ASCIIZ file
  regsx.ds = -1                     'Use current DS
    
  InterruptX &H21, regsx                 'Do the interrupt
    
  '-----  Return file name or null
  IF regsx.flags AND 1 THEN            'No files found
    VolLab$ = ""                        'Return null string
  ELSE
    Null = INSTR(31, DTA, CHR$(0))     'Get the filename found
    Temp$ = MID$(DTA, 31, Null - 31)  'It's an ASCIIZ string starting
  END IF                              'at offset 30 of the DTA
  Dot = INSTR(Temp$, ".")
  IF Dot THEN
    Temp$ = LEFT$(Temp$, Dot - 1) + MID$(Temp$, Dot + 1)
  END IF
 
  VolLab$ = LTRIM$(RTRIM$(Temp$))

END FUNCTION

