; Function to move font data to screen location masking out zero pixles
; Mode X (320x240, 256 colors). Uses Linear bitmaps, copying one plane at
; a time.
; Y dim is 10 and X dim is 8
; PageOffset is a modulo 4 location anywhere in video ram
;  C near-callable as:
;    void CopyFontToDisplay(char* SourcePtr, unsigned int PageOffset,
;                              unsigned int Yloc, unsigned int Xloc)

SC_INDEX equ    03c4h   ;Sequence Controller Index register port
MAP_MASK equ    02h     ;index in SC of Map Mask register
SCREEN_SEG equ  0a000h  ;segment of display memory in mode X

parms   struc
        dw      2 dup (?) ;pushed BP and return address
SourcePtr    dw ?       ; pointer in DS to start of bitmap in which
                        ; source resides
PageOffset   dw ?       ; base offset in display memory of video page
Yloc         dw ?       ; Y offset (0-303) in video page of
                        ; sprite upper left corner
Xloc         dw ?       ; X offset (0-383) in video page of
                        ; sprite upper left corner
parms   ends


        .model  small
        .code
        public  _CopyFontToDisplay
_CopyFontToDisplay proc    near
        push    bp      ;preserve caller's stack frame
        mov     bp,sp   ;point to local stack frame
        push    si      ;preserve caller's register variables
        push    di

        cld
        mov     ax,SCREEN_SEG     ;point ES to display memory
        mov     es,ax


        mov     dx,SC_INDEX     ;point to SC Index register
        mov     al,MAP_MASK
        out     dx,al           ;point SC Index reg to the Map Mask
        inc     dx              ;point DX to SC Data reg

        mov    cx,[bp+SourcePtr] ;offset of first source rect pixel
        mov    si,cx             ; in DS

        mov    ax, [bp+PageOffset]

        mov    bx, [bp+Yloc]
        shl    bx, 5
        add    ax, bx           ; YLoc * 32 added to PageOffset
        shl    bx, 1
        add    ax, bx           ; Yloc * 64 added to PageOffset

        mov    bx, [bp+Xloc]
        mov    cl, bl
        shr    bx, 2            ; Divide Xloc by 2  to get video mem address
        add    ax, bx           ; add to PageOffset
        mov    [bp+PageOffset], ax    ; store dest address

        and    cl, 011b         ; find dest offset modulo 4
        mov    al, 1
        shl    al, cl           ; set mask to first plane
        mov    bh, al
        xor    cx, cx
        push   cx
CopyPlane:
       mov     di,[bp+PageOffset] ;offset of first dest pixel
                                ; in display memory
       mov     bl, 10           ; number of rows to copy
       mov     al, bh
       out     dx,al            ; set the plane for this pixel
CopyScanLine:
       mov     cl, 2            ; number of bytes in scan line to copy
CopyLoop:
       lodsb                    ; load the next pixel
       or      al, al
       jz      BlankPixel       ; Do not copy if zero
       stosb                    ; copy byte to display
       jmp     CopiedByte
BlankPixel:
       inc     di               ; increment dest if not copied
CopiedByte:
       dec     cl
       jnz     CopyLoop         ; keep going until end of scanline
       add     di, 94           ; increment destination to next line
       dec     bl
       jnz     CopyScanLine
       rol     bh,1            ; set mask for next pixel's plane
       cmp     bh, 16
       jne     NoBoundry
       mov     bh, 1
       add     [bp+PageOffset], 1  ; inc dest due to plane crossing
NoBoundry:
       pop     cx
       inc     cx
       push    cx
       cmp     cx, 4
       jl      CopyPlane

       pop     ax
       pop     di      ;restore caller's register variables
       pop     si
       mov     sp,bp   ;discard storage for local variables
       pop     bp      ;restore caller's stack frame
       ret
_CopyFontToDisplay endp
	end
