//       Keyboard Interrupt Handler for game design
//                By Dan Green  November 1994
// *******************************************************
//  Uses an array of char as flags to show which keys are
//  currently down. 1 = down, 0 = up. There is one array for regular keys
//  and one for extended.


#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include "keyintr.h"
#define BYTE unsigned char
#define TRUE 1
#define FALSE 0

#define KEYPORT        0x60        /* keyboard scan code port       */
        /* macro that returns the scancode of the key that caused   */
        /* the interrupt                                            */
#define keyport()      inportb(KEYPORT)


volatile char keys[128];           /* array of key states           */
volatile char ekeys[128];          /* array of AT key states        */
void (_interrupt _far *oldkbisr)(void);    /* address of old ISR   */


void install_key_handler(void){
  int i;
   for(i=1;i<=128;i++){ keys[i]=0; ekeys[i]=0; }
   oldkbisr=getvect(0x09);
   setvect(0x09, newkbisr);
   }

void remove_key_handler(void){  setvect(0x09, oldkbisr); }

void _interrupt _far newkbisr(void)
{
      static extkey;
      BYTE scancode = (BYTE)keyport();         /* read keyboard scan code */

      if (scancode == 0xe0)
            extkey = 1;               /* use ekey array on next scan code */
      else
      {
            if (scancode & 0x80)                          /* key released */
                  (extkey ? ekeys : keys)[scancode & 0x7f] = 0;
            else  (extkey ? ekeys : keys)[scancode] = 1;
            extkey = 0;
      }
#ifdef DEBUG
      oldkbisr();               /* chain to previous keyboard ISR */
#else
      outportb(0x20,0x20);      /* signal end of interupt */
#endif
}



