; Function to copy display to display memory 32x32 block without masking.
; Mode X (320x240, 256 colors). Uses approach of reading 4 pixels at a time
; from source into latches, then writing latches to destination.
; Copies 32x32 block from SourcePoint. Top and bottom clipping performed
; by setting Line to the scan line to start or stop at and Clip to 0 for
; the whole image or 1 to top clip of 2 for bottom clip
; C near callable as
;    void DrawUnmaskedBlock(unsigned int DestPoint, unsigned int SourcePoint,
;                           int Clip, int Line);

SC_INDEX equ    03c4h   ;Sequence Controller Index register port
MAP_MASK equ    02h     ;index in SC of Map Mask register
GC_INDEX equ    03ceh   ;Graphics Controller Index register port
BIT_MASK equ    08h     ;index in GC of Bit Mask register
SCREEN_SEG equ  0a000h  ;segment of display memory in mode X

parms   struc
        dw      2 dup (?) ;pushed BP and return address

DestPoint   dw ?       ; location in video ram to start drawing
SourcePoint dw ?       ; offset in display memory of image
Clip        dw ?       ; 0=noclip, 1=topclip, 2=bottomclip
Line        dw ?       ; Scan line to start or stop clipping at


parms   ends

        .model  small
        .code
        public  _DrawUnmaskedBlock

_DrawUnmaskedBlock proc    near

        push    bp      ;preserve caller's stack frame
        mov     bp,sp   ;point to local stack frame
        push    si      ;preserve caller's register variables
        push    di
        push    ds
        cld

        mov     dx,GC_INDEX     ;set the bit mask to select all bits
        mov     ax,00000h+BIT_MASK ; from the latches and none from
        out     dx,ax           ; the CPU, so that we can write the
                                ; latch contents directly to memory
        mov     dx,SC_INDEX
        mov     al,MAP_MASK
        out     dx,al           ;point SC Index register to Map Mask
        inc     dx              ;point to SC Data register
        mov     al, 15
        out     dx,al           ;set the mask to copy all bits from video


        mov     ax,SCREEN_SEG   ;point ES to display memory
        mov     es,ax

        mov     di,[bp+DestPoint]    ; set es:di to start of drawing point

        mov     si, [bp+SourcePoint] ; set ds:si to start of bitmap block

        mov     ax, [bp+Clip]
        or      ax, ax
        jz      CopyAll
        cmp     ax,2
        je      ClipBottom

ClipTop:
        mov     ax, [bp+Line]
        mov     bx, ax
        shl     bx, 3               ; multiply line by 8
        mov     ax, si
        add     ax, bx
        mov     si, ax              ; set new bitmap source start
        mov     ax, [bp+Line]       ; set cl= number of scanlines to copy
        mov     cx, 32
        sub     cx, ax
        jmp     CopyBlock

ClipBottom:
        mov     ax, [bp+Line]
        mov     cx, 33
        sub     cx, ax             ; set cl=number of scanlines to copy
        jmp     CopyBlock

CopyAll:
        mov    cx, 32
CopyBlock:
        mov    bx, cx
        mov    ax, SCREEN_SEG
        mov    ds, ax            ; set ds:si to video seg
NextScanLine:
        mov   cx, 8
        rep   movsb
        add   di, 88             ; set to start of next scanline
        dec   bx
        jnz  NextScanLine

        mov     dx,GC_INDEX+1   ; restore the bit mask to its default,
        mov     al,0ffh         ; which selects all bits from the CPU
        out     dx,al           ; and none from the latches (the GC
                                ; Index still points to Bit Mask)

        pop     ds      ;restore caller's register variables
        pop     di
        pop     si
        mov     sp,bp   ;discard storage for local variables
        pop     bp      ;restore caller's stack frame
        ret
_DrawUnmaskedBlock endp
        end
