; Function to move sprite data to off screen location for later use
; Mode X (320x240, 256 colors). Uses Linear bitmaps, copying one plane at
; a time into a linear location.
; Sprite must be 32 x 32 bitmap and DestLocation is a modulo 4 locataion
; anywhere in video ram
;  C near-callable as:
;    void CopySpriteToDisplay(char* SourcePtr, unsigned int DestLocation);

SC_INDEX equ    03c4h   ;Sequence Controller Index register port
MAP_MASK equ    02h     ;index in SC of Map Mask register
SCREEN_SEG equ  0a000h  ;segment of display memory in mode X

parms   struc
        dw      2 dup (?) ;pushed BP and return address
SourcePtr    dw ?       ; pointer in DS to start of bitmap in which
                        ; source resides
DestLocation dw ?       ; base offset in display memory of where
                        ; sprite to reside
parms   ends

        .model  small
        .code
        public  _CopySpriteToDisplay
_CopySpriteToDisplay proc    near
        push    bp      ;preserve caller's stack frame
        mov     bp,sp   ;point to local stack frame
        push    si      ;preserve caller's register variables
        push    di

        cld
        mov     ax,SCREEN_SEG     ;point ES to display memory
        mov     es,ax


        mov     dx,SC_INDEX     ;point to SC Index register
        mov     al,MAP_MASK
        out     dx,al           ;point SC Index reg to the Map Mask
        inc     dx              ;point DX to SC Data reg

       mov     cx,[bp+SourcePtr] ;offset of first source rect pixel
       mov     si,cx             ; in DS
       mov     al, 1            ; set to plane 0

CopyPlane:
       mov     di,[bp+DestLocation] ;offset of first dest pixel
                                ; in display memory
       mov     bl, 32           ; number of rows to copy
       out     dx,al           ; set the plane for this pixel
CopyScanLine:
       mov     cx, 8            ; number of bytes in scan line to copy
       rep     movsb            ; copy the pixels to the screen
       dec     bl
       jnz    CopyScanLine
       shl     al,1            ; set mask for next pixel's plane
       cmp     al, 8           ; see if greater than plane 3
       jle    CopyPlane

       pop     di      ;restore caller's register variables
       pop     si
       mov     sp,bp   ;discard storage for local variables
       pop     bp      ;restore caller's stack frame
       ret
_CopySpriteToDisplay endp
	end
