//**************************************************************************
//                     X-SHOOTER - Version 4
//                       First C++ version
//               By Dan Green - Started 17-12-95
//**************************************************************************
extern "C"{
#include "modex.h"        // header files for my external modules
#include "keyintr.h"
}

#include <iostream.h>
#include <fstream.h>
#include <time.h>
#include <alloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

//#define TEST

#define TRUE 1
#define FALSE 0

#define MAX_POWER 3         // maximum power level of ship
#define LAST_LINE 6560      // last line of level

#define page1  3080         // visible page 1
#define page2  32264       // visible page 2
#define spr_page1 0        // virtual page one with 32 pixel boundries
                           // on all sides for sprite motion
#define spr_page2 29184    // virtual page two with 32 pixel boundries
                           // on all sides for sprite motion

#define backpage 58368     // backpage for off-screen sprite data

#define no_clip 0         // defines for clipping background tiles
#define top_clip 1
#define bottom_clip 2


typedef struct edata      // data for enimy ships to be placed in level
 {
   unsigned int line_number;  // line number to appear
   char enimy_number;         // enimy type
   unsigned int x_location;  // horizontal location to appear at
 };

extern volatile char keys[128];           // array of key states
extern volatile char ekeys[128];          // array of AT key states
unsigned char palette[768];               // custom pallette
unsigned char scroll_pal[8] = {32,38,43,49,55,60,63}; // scolling indexes

//************************************************************************
//          Main Image Data Arrays
//************************************************************************
unsigned char *Images[100];  // array of pointers to image data
unsigned char Shot[] = {2,4,0,0,74,74,74,74,0,0}; // bullet image
char *shot = Shot;                               // pointer to bullet image
unsigned char *Font1[40];  // font 1 storeage

#ifdef TEST
int fps = 0;
time_t  start_time, stop_time; // to calcuate frames per second
#endif

unsigned int page[] = {page1, page2};         // display pages for background
unsigned int spr_page[] = {spr_page1, spr_page2};// display pages for sprites
unsigned char current_page = 0;
unsigned BackLine;    // index to current background display
int score=0;

edata EMap[] = { { 450,0,50  },   // map of enimy locations
                 { 470,0,150 },
                 { 490,0,250 },
                 { 650,1,80 },
                 { 650,1,280 },
                 { 800,0,60 },
                 { 800,0,130 },
                 { 800,0,220 },
                 { 800,0,300 },
                 { 1000,0,60 },
                 { 1000,0,130 },
                 { 1000,0,220 },
                 { 1000,0,300 },
                 { 1080,0,60 },
                 { 1080,0,130 },
                 { 1080,0,220 },
                 { 1080,0,300 },
                 { 1140,0,100 },
                 { 1140,0,150 },
                 { 1140,0,240 },
                 { 1140,0,290 },
                 { 1200,0,175 },
                 { 1200,0,210 },
                 { 1240,1,40 },
                 { 1240,1,320 },
                 { 1280,0,35 },
                 { 1300,0,70 },
                 { 1320,0,105 },
                 { 1340,0,175 },
                 { 1360,0,210 },
                 { 1380,0,245 },
                 { 1400,0,280 },
                 { 1420,0,315 },
                 { 1480,1,45 },
                 { 1480,1,307 },
                 { 1480,1,175 },
                 { 1500,0,110 },
                 { 1500,0,241 },
                 { 1550,0,150 },
                 { 1570,0,250 },
                 { 1650,1,80 },
                 { 1650,1,280 },
                 { 1800,0,60 },
                 { 1800,0,130 },
                 { 1800,0,220 },
                 { 1800,0,300 },
                 { 2000,0,60 },
                 { 2000,0,130 },
                 { 2000,0,220 },
                 { 2000,0,300 },
                 { 2080,0,60 },
                 { 2080,0,130 },
                 { 2080,0,220 },
                 { 2080,0,300 },
                 { 2140,0,100 },
                 { 2140,0,150 },
                 { 2140,0,240 },
                 { 2140,0,290 },
                 { 2200,0,175 },
                 { 2200,0,210 },
                 { 2240,1,40 },
                 { 2240,1,320 },
                 { 2280,0,35 },
                 { 2300,0,70 },
                 { 2320,0,105 },
                 { 2340,0,175 },
                 { 2360,0,210 },
                 { 2380,0,245 },
                 { 2400,0,280 },
                 { 2420,0,315 },
                 { 2480,1,45 },
                 { 2480,1,307 },
                 { 2480,1,175 },
                 { 2500,1,110 },
                 { 2500,1,241 },
                 { 2570,1,150 },
                 { 2590,1,250 },
                 { 2650,1,80 },
                 { 2650,1,280 },
                 { 2800,0,60 },
                 { 2800,0,130 },
                 { 2800,0,220 },
                 { 2800,0,300 },
                 { 3000,0,60 },
                 { 3000,0,130 },
                 { 3000,0,220 },
                 { 3000,0,300 },
                 { 3080,0,60 },
                 { 3080,0,130 },
                 { 3080,0,220 },
                 { 3080,0,300 },
                 { 3140,0,100 },
                 { 3140,0,150 },
                 { 3140,0,240 },
                 { 3140,0,290 },
                 { 3200,0,175 },
                 { 3200,0,210 },
                 { 3280,3,80},
                 { 3280,3,240},
                 { 3376,3,80},
                 { 3376,3,240},
                 { 3472,3,80},
                 { 3472,3,240},
                 { 3568,3,80},
                 { 3568,3,240},
                 { 3650,1,80 },
                 { 3650,1,280 },
                 { 3800,0,60 },
                 { 3800,0,130 },
                 { 3800,0,220 },
                 { 3800,0,300 },
                 { 3900,1,165 },
                 { 3900,1,210 },
                 { 3984,3,80},
                 { 3984,3,240},
                 { 4080,3,80},
                 { 4080,3,240},
                 { 4176,3,80},
                 { 4176,3,240},
                 { 4200,1,110 },
                 { 3200,1,280 },
                 { 4272,3,80},
                 { 4272,3,240},
                 { 4300,0,40 },
                 { 4350,0,130 },
                 { 4400,0,215 },
                 { 4450,0,300 },
                 { 4500,0,60 },
                 { 4600,0,160 },
                 { 4600,0,280 },
                 { 4640,0,160 },
                 { 4640,0,280 },
                 { 4700,0,60 },
                 { 4700,0,260 },
                 { 4740,2,65 },
                 { 4800,0,60 },
                 { 4800,0,260 },
                 { 4900,2,175 },
                 { 4950,1,84 },
                 { 5000,0,130 },
                 { 5000,0,300 },
                 { 5050,2,96 },
                 { 5050,2,224 },
                 { 5150,0,60 },
                 { 5150,0,130 },
                 { 5150,0,220 },
                 { 5150,0,300 },
                 { 5200,2,96 },
                 { 5200,2,224 },
                 { 5350,1,40 },
                 { 5350,1,320 },
                 { 5450,1,140 },
                 { 5450,1,220 },
                 { 5500,0,40 },
                 { 5550,0,130 },
                 { 5600,0,215 },
                 { 5650,0,300 },
                 { 5700,0,60 },
                 { 5800,0,160 },
                 { 5800,0,280 },
                 { 5840,0,160 },
                 { 5840,0,280 },
                 { 5900,0,60 },
                 { 5900,0,260 },
                 { 5940,2,65 },
                 { 6000,0,60 },
                 { 6000,0,260 },
                 { 6100,2,175 },
                 { 6250,1,84 },
                 { 6300,0,130 },
                 { 6300,0,300 },
                 { 6350,2,96 },
                 { 6350,2,224 },
                 { 6520,4,85 },
                 { 6520,4,145 },
                 { 6520,4,205 },
                 { 30000,1,1} /* end marker */
               };


int  Map [] = {        // map of background image data
                        1,0,1,0,1,0,1,1,1,0,
                        0,0,1,1,1,0,0,0,1,1,
                        3,0,0,0,1,1,1,0,0,0,
                        1,1,1,3,1,0,0,0,2,1,
                        1,0,0,0,1,3,1,0,0,0,
                        1,0,1,1,1,0,1,1,1,0,
                        0,0,1,1,1,1,2,0,0,2,
                        1,1,1,0,0,0,1,1,1,0,
                        0,0,1,1,1,0,0,0,2,1,
                        1,0,1,0,1,1,1,1,1,0,
                        3,1,1,0,0,0,0,0,1,1,
                        1,0,0,0,1,0,1,0,0,0,
                        1,1,1,0,0,0,1,1,1,1,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,1,0,0,0,3,1,1,0,
                        0,0,2,0,1,0,1,1,1,1,
                        1,1,1,1,1,0,1,1,1,2,
                        0,0,1,1,1,0,1,1,2,0,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,1,1,1,0,0,0,1,1,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,1,0,0,0,1,1,1,0,
                        0,0,1,1,0,2,1,0,1,0,
                        1,1,1,0,0,0,2,1,1,0,
                        3,0,2,1,1,0,0,0,1,1,
                        1,0,0,0,1,1,3,1,1,0,
                        0,0,1,1,1,0,0,0,1,1,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,1,0,0,0,1,1,1,1,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,2,0,0,0,1,1,1,0,
                        0,0,1,1,1,0,0,0,1,1,
                        1,1,1,0,0,0,3,1,1,0,
                        0,0,1,1,1,0,0,0,1,1,
                        1,0,0,0,3,1,1,0,0,0,
                        1,1,1,1,1,0,2,1,1,0,
                        0,0,0,0,1,1,1,0,0,2,
                        1,1,1,0,0,0,1,1,1,0,
                        3,0,1,1,1,0,1,0,0,0,
                        1,1,1,0,0,0,0,1,1,0,
                        0,0,0,1,1,0,0,0,1,0,
                        1,0,0,0,1,1,1,1,1,0,
                        0,0,1,1,1,0,0,0,1,3,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,1,3,0,0,1,1,1,1,
                        1,0,0,0,1,1,1,2,0,0,
                        1,1,1,0,2,0,1,1,1,0,
                        0,0,1,1,0,0,0,0,1,1,
                        1,1,1,0,1,0,0,1,1,0,
                        1,0,1,1,1,0,0,0,0,0,
                        1,0,0,0,1,0,3,0,1,1,
                        0,1,1,1,1,0,0,0,1,1,
                        1,0,0,0,1,3,1,0,0,0,
                        1,1,1,2,0,0,1,1,1,0,
                        0,0,1,1,1,1,1,0,0,0,
                        1,1,1,0,0,0,1,1,1,0,
                        0,0,1,1,1,0,0,0,0,1,
                        1,0,0,0,1,1,0,0,0,0,
                        0,0,1,1,1,1,0,0,0,0,
                        0,0,0,0,1,1,1,0,0,0,
                        0,1,1,1,0,0,1,1,1,1,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,1,0,0,0,1,1,1,0,
                        2,0,0,1,1,0,0,0,1,1,
                        1,1,1,0,0,0,1,1,1,0,
                        1,0,1,1,1,0,0,2,1,1,
                        1,0,0,0,0,1,1,0,0,0,
                        1,1,1,1,1,0,0,0,1,0,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,1,0,0,0,1,1,1,0,
                        1,2,1,1,1,1,1,0,0,2,
                        1,1,1,1,0,0,1,1,1,0,
                        0,0,1,3,1,0,0,0,1,1,
                        1,0,0,0,1,1,1,1,1,0,
                        0,0,1,1,1,0,2,0,1,1,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,1,0,0,0,1,1,1,1,
                        1,0,2,0,1,0,1,0,0,0,
                        1,1,1,0,0,0,1,1,1,0,
                        0,0,3,1,1,0,0,0,1,1,
                        1,1,1,0,0,0,1,1,1,0,
                        1,0,1,1,1,0,0,0,1,1,
                        1,0,0,0,1,1,1,0,0,1,
                        0,1,1,1,1,3,0,0,1,1,
                        1,0,0,0,1,1,1,0,0,0,
                        3,3,3,0,0,0,1,1,1,0,
                        2,0,1,1,1,1,1,0,0,0,
                        1,1,1,3,0,0,1,1,1,0,
                        0,0,1,1,1,0,0,0,1,1,
                        3,0,0,0,1,1,1,1,1,0,
                        0,2,1,1,1,0,0,0,1,3,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,1,0,1,0,1,1,1,1,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,1,0,2,0,1,1,1,0,
                        0,2,1,1,1,0,0,0,1,1,
                        1,1,1,0,0,0,1,1,1,0,
                        0,0,1,1,1,0,0,0,1,1,
                        1,0,0,0,1,1,1,0,0,0,
                        1,1,1,1,1,0,1,0,1,0,
                        1,1,1,0,2,0,1,1,1,0,
                        0,2,1,1,1,0,0,0,1,1,
                        3,6,7,0,0,0,6,7,0,1,
                        3,9,8,0,0,0,9,8,0,1,
                        3,0,0,0,0,0,0,0,0,1,
                        3,6,7,0,0,0,6,7,0,1,
                        3,9,8,0,0,0,9,8,0,1,
                        3,0,0,0,0,0,0,0,0,1,
                        3,6,7,0,0,0,6,7,0,1,
                        3,9,8,0,0,0,9,8,0,1,
                        3,0,0,0,0,0,0,0,0,1,
                        3,6,7,0,0,0,6,7,0,1,
                        3,9,8,0,0,0,9,8,0,1,
                        3,0,0,0,0,0,0,0,0,1,
                        10,11,0,10,11,0,10,11,0,10,
                        14,15,0,14,15,0,14,15,0,14,
                        14,15,0,14,15,0,14,15,0,14,
                        14,15,0,14,15,0,14,15,0,14,
                        14,15,0,14,15,0,14,15,0,14,
                        14,15,0,14,15,0,14,15,0,14,
                        14,15,0,14,15,0,14,15,0,14,
                        13,12,0,13,12,0,13,12,0,13,
                        3,0,0,0,0,0,0,0,0,1,
                        3,2,1,1,1,0,0,0,1,1,
                        3,6,7,0,0,0,6,7,0,1,
                        3,9,8,0,0,0,9,8,0,1,
                        3,0,0,0,0,0,0,0,0,1,
                        3,6,7,0,0,0,6,7,0,1,
                        3,9,8,0,0,0,9,8,0,1,
                        3,0,0,0,0,0,0,0,0,1,
                        3,6,7,0,0,0,6,7,0,1,
                        3,9,8,0,0,0,9,8,0,1,
                        3,0,0,0,0,0,0,0,0,1,
                        3,6,7,0,0,0,6,7,0,1,
                        3,9,8,0,0,0,9,8,0,1,
                        3,0,0,0,0,0,0,0,0,1,
                        16,16,16,16,16,16,16,16,16,16,
                        17,17,17,17,17,17,17,17,17,17,
                        18,18,18,18,18,18,18,18,18,18,
                        19,20,21,20,19,21,21,20,19,19,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,4,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,4,21,5,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        4,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,5,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,4,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,5,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,5,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,4,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,5,19,21,21,19,20,19,21,21,
                        19,20,21,20,19,21,21,20,19,19,
                        21,19,20,19,20,20,21,21,20,20,
                        20,21,19,21,21,19,20,19,21,21,
                        22,23,23,24,22,23,24,23,22,23,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25,
                        25,25,25,25,25,25,25,25,25,25
             };

//****************************************************************
//    CLASS definitions
//****************************************************************
class thing  // basic type for every object on the screen
{
public:
  thing *prev, *next; // pointers to next and prev thing in linked list
  unsigned int x,y;        // screen co-ordinates for the top left corner
  unsigned int bound_x1, bound_x2,  // left and right edges of the collsion
                                    // box, relative to x,y
               bound_y1, bound_y2;  // top and bottom edges of collision box
  unsigned char hit_points;          // number of hit points for object
  unsigned char points;              // value of destroyed object
public:
  thing(void);
  virtual char show(void);           // main function - does all object
                                     // actions
};

class PowerUp : public thing    // power up globe that gives weapon boost
{
  unsigned char state;         // current state of object
public:
  PowerUp(int newx, int newy);
  char show(void);
};

class Ship : public thing    // player's ship
{
  unsigned char state;
  unsigned char shot_wait;    // waiting time between bullets
public:
  unsigned char power_level;  // current weapon level
public:
  Ship(int newx, int newy);
  void reset(void);          // reset the data when ship is destroyed
  char show(void);
};


class Small_Explosion : public thing  // small ship explosion
{
  unsigned char state;
public:
  Small_Explosion(int newx, int newy);
  char show(void);
};

class Tiny_Explosion : public thing  // explosion when weapon hits target
{
  unsigned char state;
public:
  Tiny_Explosion(int newx, int newy);
  char show(void);
};

class Gunnie_Explosion : public thing  // explosion when gunnie dies
{
  unsigned char state;
public:
  Gunnie_Explosion(int newx, int newy);
  char show(void);
};

class bullet : public thing    // bullet class
{
 public:
   bullet(int newx, int newy);
   char show(void);
};

class ebullet : public thing  // enimy bullets
{
 public:
   ebullet(int newx, int newy);
   char show(void);
};

class Enimy1 : public thing
{
  unsigned char state;
public:
  Enimy1(int newx, int newy);
  char show(void);
};

class Smoke : public thing  // smoke trails for missles
{
  unsigned char state;
public:
  Smoke(int newx, int newy);
  char show(void);
};

class EMissle : public thing  // enimy2 missles
{
  unsigned char state;
  unsigned char speed;
public:
  EMissle(int newx, int newy);
  char show(void);
};

class Enimy2 : public thing    // enimy type 2
{
  unsigned char state1, state2;
public:
  Enimy2(int newx, int newy);
  char show(void);
};

class Gunnie : public thing   // big enimy
{
  unsigned char state;
public:
  Gunnie(int newx, int newy);
  char show(void);
};

class GunnieShot : public thing  // bullets from gunnie
{
  unsigned char state;
  unsigned char state_count;
public:
  GunnieShot(int newx, int newy);
  char show(void);
};

class Floater : public thing  // blaster shots
{
  unsigned char state;
public:
  Floater(int newx, int newy);
  char show(void);
};

class Blaster : public thing
{
  unsigned char state;
public:
  Blaster(int newx, int newy);
  char show(void);
};

class Boss : public thing   // boss enimy
{
  unsigned char state;
  unsigned char bstate;
public:
  Boss(int newx, int newy);
  char show(void);
};

// ********************************************************************
// End CLASS definitions
// ********************************************************************

//  Some global variables

Ship ship(176,211);   // player's ship

// Linked lists of things

thing *temp = NULL;     // tempory pointer to things
thing *shot_list = NULL;  // player's shots
thing *eshot_list = NULL; // enimy shots
thing *enimy_list = NULL; // enimies
thing *extra_list = NULL;  //smoke, explosions, whatnot
thing *ground_list = NULL;  //ground enimies

// CLASS THING  *************************************************

thing::thing(void)
{
  prev = NULL;
  next = NULL;
}

char thing::show(void)              // dummy function -> for inheritence
{
 return(FALSE);
}

// CLASS bullet **************************************************

bullet :: bullet(int newx, int newy)
{
  x = newx;
  y = newy;
  bound_x1 = x;   // set up bounding rectangle for collsions
  bound_x2 = x+4;
  bound_y1 = y;
  bound_y2 = y+4;
}

char bullet :: show(void)
{
  thing *newtemp;
  char Type;

  if(y>30)    // if bullet is still on the visible screen, update it
  {
   y-=6;
   bound_y1-=6;
   bound_y2-=6;

   temp = enimy_list;   // pass through enimy list and check for hits
   while(temp!=NULL)
    {
      if(((temp->bound_x1<bound_x1)&&
         (temp->bound_x2>bound_x1))||
         ((temp->bound_x1<bound_x2)&&
         (temp->bound_x2>bound_x2)))
         {
          if(((temp->bound_y1<bound_y1)&&
             (temp->bound_y2>bound_y1))||
             ((temp->bound_y1<bound_y2)&&
             (temp->bound_y2>bound_y2)))
             {                          // bullet has hit object

              temp->hit_points--;
              if(temp->hit_points == 0)   // if enimy is dead
               {
                if(temp->points>10)   // check if this is a gunnie
                { Type = 1;}
                else
                {Type = 0;}

                score+=temp->points;      // add points to score
                if(temp->prev != NULL)
                 {
                  temp->prev->next = temp->next;
                 }
                 else
                 {
                  enimy_list = temp->next;
                 }
                if(temp->next != NULL)
                 {
                 temp->next->prev = temp->prev;
                 }
                 x = temp->x;
                 y = temp->y;
                 delete temp;  // delete the enimy ship

                 if(Type == 0)
                  {
                   temp = new Small_Explosion(x,y); // add a small explosion
                  }
                 else
                  {
                   temp = new Gunnie_Explosion(x,y); // add a gunnie exp.
                  }

                 temp->next = extra_list;
                 if(extra_list!=NULL)
                   {
                     extra_list->prev = temp;
                    }
                  extra_list = temp;

                  if((rand()%20)==1)        // maybe generate a powerup
                    {
                      temp = new PowerUp(x,y);
                      temp->next = extra_list;
                      if(extra_list!=NULL)
                        {
                          extra_list->prev = temp;
                        }
                       extra_list = temp;
                     }
                 }
                else
                {   // bullet has hit object, but it was not destroyed
                  newtemp = new Tiny_Explosion(x,y);  // add an explosion
                  newtemp->next = extra_list;
                  if(extra_list!=NULL)
                   {
                     extra_list->prev = newtemp;
                    }
                   extra_list = newtemp;
                }
               return(TRUE);   // delete the bullet if a collsion occured
             }
         }
       temp = temp->next;
     }

   temp = ground_list;   // pass through ground enimy list and check for hits
   while(temp!=NULL)
    {
      if(((temp->bound_x1<bound_x1)&&
         (temp->bound_x2>bound_x1))||
         ((temp->bound_x1<bound_x2)&&
         (temp->bound_x2>bound_x2)))
         {
          if(((temp->bound_y1<bound_y1)&&
             (temp->bound_y2>bound_y1))||
             ((temp->bound_y1<bound_y2)&&
             (temp->bound_y2>bound_y2)))
             {                          // bullet has hit object

              temp->hit_points--;
              if(temp->hit_points == 0)   // if enimy is dead
               {
                score+=temp->points;      // add points to score
                if(temp->prev != NULL)
                 {
                  temp->prev->next = temp->next;
                 }
                 else
                 {
                  ground_list = temp->next;
                 }
                if(temp->next != NULL)
                 {
                 temp->next->prev = temp->prev;
                 }
                 x = temp->x;
                 y = temp->y;
                 delete temp;  // delete the ground enimy

                 temp = new Small_Explosion(x,y);      // add an explosion
                 temp->next = extra_list;
                 if(extra_list!=NULL)
                   {
                     extra_list->prev = temp;
                    }
                  extra_list = temp;
                 }
                else
                {   // bullet has hit object, but it was not destroyed
                  newtemp = new Tiny_Explosion(x,y);  // add an explosion
                  newtemp->next = extra_list;
                  if(extra_list!=NULL)
                   {
                     extra_list->prev = newtemp;
                    }
                   extra_list = newtemp;
                }
               return(TRUE);   // delete the bullet if a collsion occured
             }
         }
       temp = temp->next;
     }

   CopyMSpriteToDisplay(shot,spr_page[current_page],y,x);  // draw bullet
   return(FALSE);
  }
 else
  {
   return(TRUE);  // delete the bullet if it is off screen
  }
}

// SHIP CLASS *********************************************************

Ship::Ship(int newx,int  newy)
{
  x = newx;
  y = newy;
  state =6;             // start with flat ship
  shot_wait = 0;
  power_level = 0;     // start with lowest weapon
  hit_points = 100;    // start with 100 hit points
}

void Ship::reset()    // reset the variables after ship destroyed
{
  x = 176;
  y = 211;
  state =6;
  shot_wait = 0;
  power_level = 0;
  hit_points = 100;
  score = 0;        // lose all your score!!
}

char Ship::show(void)
{
  if(!hit_points)   // it the ship has no hit points left
   {
     if(state<50)   // if this is the first time without hitpoints, set to 50
      {
        state = 50;
        bound_x1=0;   // clear bounds to prevent more collsions
        bound_x2=0;
        bound_y1=0;
        bound_y2=0;
      }
     if((state<80)&&(state%2==0))  // create an explosion every other frame
      {                            // for the first 30 frames
       temp = new Small_Explosion(x+(rand()%40)-20,y);      // add explosions
       temp->next = extra_list;
       if(extra_list!=NULL)
        {
         extra_list->prev = temp;
        }
       extra_list = temp;
       state++;
       return(FALSE);     // do not delete ship yet
      }
     if(state==120)      // wait for 40 more frames before deleteing ship
      {
        return(TRUE);   // delete ship
      }
     else
      {
        state++;
        return(FALSE);
      }
   }
  if(shot_wait) shot_wait--;       // if shot wait is not zero, dec it

  if((keys[SCAN_LEFT_CTRL])&&(!shot_wait))  // if fire button pushed, and
  {                                         // we are not waiting to fire
  if(power_level==0)                       // lowest power level, 1 bullet
   {
    temp = new bullet(x+14, y+4);
    temp->next = shot_list;
    if(shot_list!=NULL) temp->next->prev = temp;
    shot_list = temp;
    shot_wait=10;                         // wait 10 frames to fire again
   }
   else
   {
    temp = new bullet(x+12, y+4);         // now have 2 bullets
    temp->next = shot_list;
    if(shot_list!=NULL) temp->next->prev = temp;
    shot_list = temp;

    temp = new bullet(x+17, y+4);
    temp->next = shot_list;
    temp->next->prev = temp;
    shot_list = temp;

    if(power_level==1)                    // if we are at power level 1,
     shot_wait=10;                        // we must wait 10 frames between
    else                                 // shots
     shot_wait = 5;                       // otherwise only five
   }
  }

  if((ekeys[SCAN_LEFT])&&(x>32))        // if we can move left
   {
     x-=4;
     if(state)                          // if state is not zero
      {
        state--;                       // decrement it to lean ship
      }
   }
  else                                // if it is leaning and left is not
   {                                  // pressed, unlean it
    if(state<6)
     {
      state++;
     }
    }

  if((ekeys[SCAN_RIGHT])&&(x<318))    // same as above for right button
   {
     x+=4;
    if(state<12)
     {
      state++;
     }
   }
  else
   {
    if(state>6)
     {
      state--;
     }
   }

  if((ekeys[SCAN_UP])&&(y>33))      // move ship up and down when we can
   {
     y-=4;
   }

  if((ekeys[SCAN_DOWN])&&(y<239))
   {
     y+=4;
   }

  switch (state/3)                 // set the collsion boundry based on
   {                               // current ship image
    case 0 :
             bound_x1 = x+8;
             bound_x2 = x+24;
             bound_y1 = y+3;
             bound_y2 = y+26;
            break;
    case 1 :
             bound_x1 = x+5;
             bound_x2 = x+24;
             bound_y1 = y+2;
             bound_y2 = y+25;
            break;
    case 2 :
             bound_x1 = x+4;
             bound_x2 = x+28;
             bound_y1 = y+4;
             bound_y2 = y+25;
            break;
    case 3 :
             bound_x1 = x+7;
             bound_x2 = x+26;
             bound_y1 = y+3;
             bound_y2 = y+25;
            break;
    case 4 :
             bound_x1 = x+7;
             bound_x2 = x+24;
             bound_y1 = y+4;
             bound_y2 = y+26;
            break;
     }
                                // draw the ship
  CopyMSpriteToDisplay(Images[state/3],spr_page[current_page], y,x);

  return(FALSE);
}

// ENIMY BULLET CLASS **************************************************

ebullet :: ebullet(int newx, int newy)
{
  x = newx;
  y = newy;
  bound_x1 = x;
  bound_x2 = x+4;
  bound_y1 = y;
  bound_y2 = y+4;
  hit_points = 1;     // each bullet delivers one hitpoint
}

char ebullet :: show(void)
{
  if(y<272)           // if the bullet is still on the visible screen
  {                  // move it down
   y+=3;
   bound_y1+=3;
   bound_y2+=3;

  if(((ship.bound_x1<bound_x1)&&     // check if it has hit the ship
      (ship.bound_x2>bound_x1))||
      ((ship.bound_x1<bound_x2)&&
       (ship.bound_x2>bound_x2)))
         {
          if(((ship.bound_y1<bound_y1)&&
             (ship.bound_y2>bound_y1))||
             ((ship.bound_y1<bound_y2)&&
             (ship.bound_y2>bound_y2)))
            {                          // bullet has hit ship

             if(ship.hit_points > hit_points)  // if ship is not destroyed
             {
               ship.hit_points -= hit_points;

               temp = new Tiny_Explosion(x,y);      // add an explosion
               temp->next = extra_list;
               if(extra_list!=NULL)
                {
                 extra_list->prev = temp;
                }
               extra_list = temp;
              }
             else ship.hit_points=0;      // if ship is destroyed
             return(TRUE);
            }
          }

   CopyMSpriteToDisplay(shot,spr_page[current_page],y,x);  // draw the shot
   return(FALSE);
  }
 else
  {
   return(TRUE);    // delete the enimy bullet if it is offscreen
  }
}

//  SMALL SHIP EXPLOSION CLASS ******************************************

Small_Explosion::Small_Explosion(int newx,int  newy)
{
  x = newx;
  y = newy;
  state =16;
}

char Small_Explosion::show(void)
{
  if(state>0)        // if explosion not finished
   {
     state--;
     y++;
     if(y>272) return(TRUE);  // delete the explosion if offscreen
     CopyMSpriteToDisplay(Images[9+(state/4)],spr_page[current_page],y,x);
     return(FALSE);
   }
  else
  {
   return(TRUE);  // delete the explosion, it is finished
  }
}

// TINY EXPLOSION CLASS *************************************************

Tiny_Explosion::Tiny_Explosion(int newx,int  newy)
{
  x = newx;
  y = newy;
  state =16;
}

char Tiny_Explosion::show(void)
{
  if(state>0)   // if it is not done
   {
     state--;
     y++;
     if(y>272) return(TRUE);  // delete the explosion if offscreen
     CopyMSpriteToDisplay(Images[21+(state/4)],spr_page[current_page],y,x);
     return(FALSE);
   }
  else
  {
   return(TRUE);  // delete the explosion , it is done
  }
}

// GUNNIE EXPLOSION ****************************************************

Gunnie_Explosion::Gunnie_Explosion(int newx,int  newy)
{
  x = newx;
  y = newy;
  state =16;
}

char Gunnie_Explosion::show(void)
{
  if(state>0)        // if explosion not finished
   {
     state--;
     y++;
     if(y>272) return(TRUE);  // delete the explosion if offscreen
     CopyMSpriteToDisplay(Images[27+(state/4)],spr_page[current_page],y,x);
     return(FALSE);
   }
  else
  {
   return(TRUE);  // delete the explosion, it is finished
  }
}

//  GUNNIE SHOT CLASS **************************************************

GunnieShot::GunnieShot(int newx,int  newy)
{
  x = newx;
  y = newy;
  state =0;
  state_count = 0;
  bound_x1 = x+1;
  bound_x2 = x+5;
  bound_y1 = y+3;
  bound_y2 = y+7;
  hit_points = 10;   // shot delivers 10 hit points
}

char GunnieShot::show(void)
{
  if(((ship.bound_x1<bound_x1)&&   // check if ship is hit
      (ship.bound_x2>bound_x1))||
      ((ship.bound_x1<bound_x2)&&
       (ship.bound_x2>bound_x2)))
         {
          if(((ship.bound_y1<bound_y1)&&
             (ship.bound_y2>bound_y1))||
             ((ship.bound_y1<bound_y2)&&
             (ship.bound_y2>bound_y2)))
            {                          // bullet has hit ship
             if(ship.hit_points > hit_points)  // if ship is not destroyed
             {
               ship.hit_points -= hit_points;
               temp = new Tiny_Explosion(x,y);      // add an explosion
               temp->next = extra_list;
               if(extra_list!=NULL)
                {
                 extra_list->prev = temp;
                }
               extra_list = temp;

              }
              else ship.hit_points=0;  // ship is destroyed
             return(TRUE);
            }
          }

  CopyMSpriteToDisplay(Images[6+state],spr_page[current_page],y,x);
  state_count++;
  if(state_count == 10)// show the first image for first 10 frames
  {
   state_count = 0;   // then cycle through the last two only
   state++;
   if(state == 3) state = 1;
  }
  switch (state)// change the collsion bounding rectangle based on the image
  {
   case 0 : {
               bound_x1 = x+1;
               bound_x2 = x+5;
               bound_y1 = y+3;
               bound_y2 = y+7;
               break;
             }
   case 1 : {
               bound_x1 = x+1;
               bound_x2 = x+5;
               bound_y1 = y+0;
               bound_y2 = y+10;
               break;
             }
   case 2 : {
               bound_x1 = x;
               bound_x2 = x+6;
               bound_y1 = y;
               bound_y2 = y+10;
               break;
             }
       }
  if(y<271)     // if shot is not off the visible screen
   {
     y+=3;
     bound_y1+=3;
     bound_y2+=3;
   }
  else
   {
     return(TRUE); // end of screen reached, so erase
   }

  return(FALSE);
}

// GUNNIE CLASS *********************************************************

Gunnie::Gunnie(int newx,int  newy)
{
  x = newx;
  y = newy;
  state =20;
  bound_x1 = x+3;
  bound_x2 = x+59;
  bound_y1 = y+6;
  bound_y2 = y+49;
  hit_points = 30;    // ship has 30 hit points
  points = 30; // worth 30 points
}

char Gunnie::show(void)
{
  if(((bound_x1<=ship.bound_x1)&&   // check if ship has collided with player
      (bound_x2>=ship.bound_x1))||
      ((bound_x1<=ship.bound_x2)&&
       (bound_x2>=ship.bound_x2)))
         {
          if(((bound_y1<=ship.bound_y1)&&
             (bound_y2>=ship.bound_y1))||
             ((bound_y1<=ship.bound_y2)&&
             (bound_y2>=ship.bound_y2)))
            {                           // ship has collided
               score+=points;
               temp = new Small_Explosion(x,y); //fix     // add an explosion
               temp->next = extra_list;
               if(extra_list!=NULL)
               {
                 extra_list->prev = temp;
               }
                extra_list = temp;

             if(ship.hit_points > hit_points)  // if player not destroyed
             {
               ship.hit_points -= hit_points;
              }
             else ship.hit_points=0;   // player is destroyed
             return(TRUE);
            }
          }


  state++;
  CopyMSpriteToDisplay(Images[13],spr_page[current_page],y,x);

  if(state == 40)  // wait 40 frames between shots
   {
     temp = new GunnieShot(x+18, y+41);  // double barrel shooter
     temp->next = eshot_list;
     if(eshot_list != NULL) eshot_list->prev = temp;
     eshot_list = temp;

     temp = new GunnieShot(x+39, y+41);
     temp->next = eshot_list;
     eshot_list->prev = temp;
     eshot_list = temp;
     state = 0;
   }

   if(y<271)   // if gunnie is not off the screen
   {
     y+=2;
     bound_y1+=2;
     bound_y2+=2;
   }
  else
   {
     return(TRUE); // end of screen reached, so erase
   }
  return(FALSE);
}

// ENIMY 1 CLASS *******************************************************

Enimy1::Enimy1(int newx,int  newy)
{
  x = newx;
  y = newy;
  state =0;
  bound_x1 = x+1;
  bound_x2 = x+29;
  bound_y1 = y+3;
  bound_y2 = y+26;
  hit_points = 2;   // 2 hit points
  points = 2;   // 2 points
}

char Enimy1::show(void)
{
  if(((bound_y1<=ship.bound_y1)&&   // check if ship has collied with player
      (bound_y2>=ship.bound_y1))||
      ((bound_y1<=ship.bound_y2)&&
       (bound_y2>=ship.bound_y2)))
        {
         if(((bound_x1<=ship.bound_x1)&&
             (bound_x2>=ship.bound_x1))||
             ((bound_x1<=ship.bound_x2)&&
              (bound_x2>=ship.bound_x2)))
              {                          // ship has collided
               score+=points;
               if(ship.hit_points > hit_points) // if player not destroyed
               {
                ship.hit_points -= hit_points;
                temp = new Small_Explosion(x,y);     // add an explosion
                temp->next = extra_list;
                if(extra_list!=NULL)
                {
                  extra_list->prev = temp;
                }
                extra_list = temp;
               }
             else ship.hit_points = 0;   // player is destroyed
             return(TRUE);
            }
          }

  state++;
  if(state > 20)   // wait 20 frames between shots
   {
     state=0;                       // double barrel
     temp = new ebullet(x+5, y+22);
     temp->next = eshot_list;
     if(eshot_list != NULL) eshot_list->prev = temp;
     eshot_list = temp;

     temp = new ebullet(x+22, y+22);
     temp->next = eshot_list;
     eshot_list->prev = temp;
     eshot_list = temp;
     state = 0;
   }
  CopyMSpriteToDisplay(Images[5],spr_page[current_page],y,x);

  if(y<270)    // if ship is still on the visible screen
   {
     y+=2;
     bound_y1+=2;
     bound_y2+=2;
   }
  else  // bottom of screen reached, so erase
   {
     return(TRUE);
   }
  return(FALSE);
}

// SMOKE CLASS ***************************************************

Smoke::Smoke(int newx,int  newy)
{
  x = newx;
  y = newy;
  state =0;
}


char Smoke::show(void)
{
  CopyMSpriteToDisplay(Images[16+(state/6)],spr_page[current_page],y,x);

  if(state<17)
     {
      state++;
     }
    else
     {
     return(TRUE);  // smoke finished, so delete
     }
 return(FALSE);
}

// POWER UP CLASS *******************************************************

PowerUp::PowerUp(int newx,int  newy)
{
  x = newx;
  y = newy;
  bound_x1 = x+1;
  bound_x2 = x+13;
  bound_y1 = y+1;
  bound_y2 = y+13;
  points = 50;   // worth 50 points
}


char PowerUp::show(void)
{
  if(((ship.bound_x1<bound_x1)&&    // check if player has collided
      (ship.bound_x2>bound_x1))||
      ((ship.bound_x1<bound_x2)&&
       (ship.bound_x2>bound_x2)))
         {
          if(((ship.bound_y1<bound_y1)&&
             (ship.bound_y2>bound_y1))||
             ((ship.bound_y1<bound_y2)&&
             (ship.bound_y2>bound_y2)))
            {                          // ship has collided
             score+=points;
             if(ship.power_level<MAX_POWER) ship.power_level++; // powerup
             return(TRUE);     // delete the powerup
            }
          }

  CopyMSpriteToDisplay(Images[19],spr_page[current_page],y,x);

  if(y<270)  // check if still on visible screen
     {
      y+=2;
      bound_y1+=2;
      bound_y2+=2;
     }
    else
     {
     return(TRUE);   // delete if not
     }
 return(FALSE);
}

// ENIMY MISSLE CLASS *************************************************

EMissle::EMissle(int newx,int  newy)
{
  x = newx;
  y = newy;
  state =0;
  speed = 0;
  bound_x1 = x;   /* fix these */
  bound_x2 = x+3;
  bound_y1 = y;
  bound_y2 = y+11;
  hit_points = 10;  // does 10 points damage
}

char EMissle::show(void)
{
 if(((ship.bound_x1<bound_x1)&&         // playert collision detection
      (ship.bound_x2>bound_x1))||
      ((ship.bound_x1<bound_x2)&&
       (ship.bound_x2>bound_x2)))
         {
          if(((ship.bound_y1<bound_y1)&&
             (ship.bound_y2>bound_y1))||
             ((ship.bound_y1<bound_y2)&&
             (ship.bound_y2>bound_y2)))
            {                           // missle has hit ship
             if(ship.hit_points > hit_points)  // if player not dead
             {
               ship.hit_points -= hit_points;
               temp = new Tiny_Explosion(x,y);      // add an explosion
               temp->next = extra_list;
               if(extra_list!=NULL)
                {
                 extra_list->prev = temp;
                }
               extra_list = temp;
             }
              else ship.hit_points = 0;  // player is dead
             return(TRUE);
            }
          }
   // No collision
  CopyMSpriteToDisplay(Images[15],spr_page[current_page],y,x);

  if(state<3)   // spawn a smoke trail every 3 frames
     {
      state++;
     }
    else
     {
      // spawn smoke
     state = 0;
     temp = new Smoke(x-1,y);
     temp->next = extra_list;
     if(extra_list != NULL) extra_list->prev = temp;
     extra_list = temp;
     }

  if(speed<24) speed++;  // increase speed over 24 frames to y+4

  if(y<270)   // if missle is still on visible screen
   {
     y+=speed/6;
     bound_y1+=speed/6;
     bound_y2+=speed/6;
   }
  else  // bottom of screen reached, so erase
   {
     return(TRUE);
   }
 return(FALSE);
}

// ENIMY TWO CLASS ***************************************************

Enimy2::Enimy2(int newx,int  newy)
{
  x = newx;
  y = newy;
  state1 =25;
  state2 = 0;
  bound_x1 = x+1;
  bound_x2 = x+29;
  bound_y1 = y+3;
  bound_y2 = y+26;
  hit_points = 7;   // has 7 hit points
  points = 7;  // worth 7 points
}

char Enimy2::show(void)
{
  if(((bound_x1<=ship.bound_x1)&&   // check if player has collided
      (bound_x2>=ship.bound_x1))||
      ((bound_x1<=ship.bound_x2)&&
       (bound_x2>=ship.bound_x2)))
         {
          if(((bound_y1<=ship.bound_y1)&&
             (bound_y2>=ship.bound_y1))||
             ((bound_y1<=ship.bound_y2)&&
              (bound_y2>ship.bound_y2)))
            {                           // ship has collided
               score+=points;
               temp = new Small_Explosion(x,y);  // add an explosion
               temp->next = extra_list;
               if(extra_list!=NULL)
               {
                 extra_list->prev = temp;
               }
                extra_list = temp;
             if(ship.hit_points > hit_points)   // if player still alive
             {
               ship.hit_points -= hit_points;
              }
             else ship.hit_points=0;  // player is dead
             return(TRUE);
            }
          }
  CopyMSpriteToDisplay(Images[14],spr_page[current_page],y,x);

  if(state1<50)   // launch one missle every 50 frames
  {
     state1++;
     if(state1>25) // missle appears on ship after 25 frames
     {
      CopyMSpriteToDisplay(Images[15],spr_page[current_page],y+6,x+7);
     }
  }
   else
  {
     temp = new EMissle(x+7,y+6);    // launch the missle
     temp->next = eshot_list;
     if(eshot_list != NULL) eshot_list->prev = temp;
     eshot_list = temp;
     state1=0;
   }

  if(state2<50)    // same as first missle, but offset 25 frames
  {
     state2++;
     if(state2>25)
     {
      CopyMSpriteToDisplay(Images[15],spr_page[current_page],y+6,x+21);
     }
  }
   else
  {

     temp = new EMissle(x+21, y+6);
     temp->next = eshot_list;
     eshot_list->prev = temp;
     eshot_list = temp;
     state2 = 0;
   }

  if(y<270)   // if ship is still on visible screen
   {
     y+=2;
     bound_y1+=2;
     bound_y2+=2;
   }
  else  // bottom of screen reached, so erase
   {
     return(TRUE);
   }
  return(FALSE);
}

// FLOATER CLASS *******************************************************

Floater :: Floater(int newx, int newy)
{
  state = 0;
  x = newx;
  y = newy;
  bound_x1 = x+1;
  bound_x2 = x+13;
  bound_y1 = y;
  bound_y2 = y+12;
  hit_points = 5;     // each floater delivers 5 hitpoints
}

char Floater :: show(void)
{
  state++;
  if(state<75) // floater lasts 75 frames
  {
   if(y > ship.y)   // track the ship
     {
       y--;
       bound_y1--;
       bound_y2--;
     }
   else
     {
      if(y < ship.y)
       {
         y+=2;
         bound_y1+=2;
         bound_y2+=2;
       }
     }
   if(x < ship.x)
     {
       x++;
       bound_x1++;
       bound_x2++;
     }
    else
     {
       if( x > ship.x)
        {
         x--;
         bound_x1--;
         bound_x2--;
        }
     }
   if(((bound_x1<ship.bound_x1)&&     // check if it has hit the ship
      (bound_x2>ship.bound_x1))||
      ((bound_x1<ship.bound_x2)&&
       (bound_x2>ship.bound_x2)))
         {
          if(((bound_y1<ship.bound_y1)&&
             (bound_y2>ship.bound_y1))||
             ((bound_y1<ship.bound_y2)&&
             (bound_y2>ship.bound_y2)))
            {                          // floater has hit ship

             if(ship.hit_points > hit_points)  // if ship is not destroyed
             {
               ship.hit_points -= hit_points;

               temp = new Tiny_Explosion(x,y);      // add an explosion
               temp->next = extra_list;
               if(extra_list!=NULL)
                {
                 extra_list->prev = temp;
                }
               extra_list = temp;
            }
            else ship.hit_points=0;      // if ship is destroyed
            return(TRUE);
           }
         }

   CopyMSpriteToDisplay(Images[26],spr_page[current_page],y,x);  // draw the shot
   return(FALSE);
  }
 else
  {
   return(TRUE);    // delete the floater if it is offscreen
  }
}

// BLASTER CLASS **********************************************************

Blaster::Blaster(int newx,int  newy)
{
  x = newx;
  y = newy;
  state =0;
  bound_x1 = x+3;
  bound_x2 = x+29;
  bound_y1 = y+3;
  bound_y2 = y+29;
  hit_points = 10;   // 10 hit points
  points = 10;   // 10 points
}

char Blaster::show(void)
{
  state++;
  if(state > 100)   // wait 100 frames between shots
   {
     state=0;                       // spawn floater
     temp = new Floater(x+6, y+6);
     temp->next = eshot_list;
     if(eshot_list != NULL) eshot_list->prev = temp;
     eshot_list = temp;
   }
  CopyMSpriteToDisplay(Images[25],spr_page[current_page],y,x);

  if(y<270)    // if blaster is still on the visible screen
   {
     y++;
     bound_y1++;
     bound_y2++;
   }
  else  // bottom of screen reached, so erase
   {
     return(TRUE);
   }
  return(FALSE);
}

// BOSS CLASS *********************************************************

Boss::Boss(int newx,int  newy)  // Boss class - just a gunnie - Out of time!
{
  x = newx;
  y = newy;
  state =20;
  bstate = 0;
  bound_x1 = x+3;
  bound_x2 = x+59;
  bound_y1 = y+6;
  bound_y2 = y+49;
  hit_points = 60;    // ship has 60 hit points
  points = 100; // worth 100 points
}

char Boss::show(void)
{
  if(((bound_x1<=ship.bound_x1)&&   // check if ship has collided with player
      (bound_x2>=ship.bound_x1))||
      ((bound_x1<=ship.bound_x2)&&
       (bound_x2>=ship.bound_x2)))
         {
          if(((bound_y1<=ship.bound_y1)&&
             (bound_y2>=ship.bound_y1))||
             ((bound_y1<=ship.bound_y2)&&
             (bound_y2>=ship.bound_y2)))
            {                           // ship has collided
               score+=points;
               temp = new Small_Explosion(x,y); //fix     // add an explosion
               temp->next = extra_list;
               if(extra_list!=NULL)
               {
                 extra_list->prev = temp;
               }
                extra_list = temp;

             if(ship.hit_points > hit_points)  // if player not destroyed
             {
               ship.hit_points -= hit_points;
              }
             else ship.hit_points=0;   // player is destroyed
             return(TRUE);
            }
          }


  state++;
  CopyMSpriteToDisplay(Images[13],spr_page[current_page],y,x);

  if(state == 50)  // wait 50 frames between shots
   {
     temp = new GunnieShot(x+18, y+41);  // double barrel shooter
     temp->next = eshot_list;
     if(eshot_list != NULL) eshot_list->prev = temp;
     eshot_list = temp;

     temp = new GunnieShot(x+39, y+41);
     temp->next = eshot_list;
     eshot_list->prev = temp;
     eshot_list = temp;
     state = 0;
   }

  if(BackLine < LAST_LINE)  // only move down until end of level
   {
     y++;
     bound_y1++;
     bound_y2++;
   }
  else
  {
   if(bstate<20)      // since this ship does not go down, rock it back
                     // and forth
    {
      if(bstate<10)
       {
         x++;
         bound_x1++;
         bound_x2++;
       }
      else
       {
         x--;
         bound_x1--;
         bound_x2--;
       }
      bstate++;
    }
   else  bstate = 0;
  }

  return(FALSE);
}

/************************ END OF CLASS FUNCTIONS **************************/

void setpal(void)     // load the main pallette in
{
 int i;
  outportb(0x3C8,0);
  for(i=0;i<768;i++){ outportb(0x3C9,palette[i]); }
}

void palscroll(void)   // scroll the pallette each frame
{
   int i;

  outportb(0x3C8,153);
  for(i=0;i<7;i++)
  {
    outportb(0x3C9,3);
    outportb(0x3C9,scroll_pal[i]);
    outportb(0x3C9,3);
    scroll_pal[i] = scroll_pal[(i+1)%7];  // shift pallette
  }
}


char ReadLevelData()    // read in the data file
{

FILE *LevelDataFile;
unsigned char x,y,index = 0,
     sprites_done=FALSE;
int  blocksize, bytes_read, i;



 if ((LevelDataFile = fopen("level1.dat", "rb"))
                     == NULL) return(FALSE);

 fread(palette,1,768,LevelDataFile); // read the pallette first

 for(i=0;i<13;i++)
 {
  Font1[i] = (char *)malloc(80);
  if(Font1[i] == NULL) return(FALSE);
  fread(Font1[i],1,80,LevelDataFile);  // read font1
 }


 while(!sprites_done)   // read in the sprites
  {
    x = fgetc(LevelDataFile);
    y = fgetc(LevelDataFile);  // first two bytes of each sprite are x and y
    if((x == 0x11) && (y == 0x22))  // end of sprite marker
     {
       sprites_done = TRUE;
       break;
     }
    blocksize = x*y;

    Images[index] = (char *)malloc(blocksize+2);// allocate memory for sprite
    if(Images[index] == NULL) return(FALSE);

    *Images[index] = x;
    *(Images[index]+1) = y;
    bytes_read = fread((Images[index]+2), 1, blocksize, LevelDataFile);
    if(bytes_read != blocksize) return(FALSE);
    index++;
   }
       // read in the background tiles next
  Images[index] = (char *)malloc(1024);  // will be stored in video memory
                                         // so only need memory for now
  if (Images[index] == NULL) return(FALSE);
  i=0;

  do   // read the background tiles -> all 32 x 32 with no indexes
   {
     bytes_read = fread(Images[index], 1, 1024, LevelDataFile);
     if ((bytes_read != 1024) && (bytes_read != 0)) return(FALSE);
                  // store the tile in video memory
     CopySpriteToDisplay(Images[index], backpage+(i*256));
     i++;
   }while(!feof(LevelDataFile));

  free(Images[index]);  // release the temporary storage
  fclose(LevelDataFile);
  return(TRUE);
}


void DrawBackLevel(unsigned int pageloc)  // draw the background tiles
{
  int i,block, offset, currentline;

  block=BackLine/32;     // current block derived from current top line

  currentline=0;
  if(block*32==BackLine)   // if we are on the edge of a tile
    {
      offset=0;           // no offset into tile needed
    }
  else
    {
      offset=BackLine-(block*32);  // find the offset for first row of tiles
      offset=32-offset;
    }

  block=block*10;

  if(offset)   // draw first tiles with offset if nessecary
   {
    for(i=0;i<10;i++)
     {
        DrawUnmaskedBlock(pageloc+(i*8),backpage+(Map[block+i]*256),top_clip,offset);
     }
    currentline=currentline+(32-offset);
    pageloc=pageloc+(32-offset)*96;
   }

  do    // draw the bulk of the tiles
   {
    block-=10;
    for(i=0;i<10;i++)
     {
      DrawUnmaskedBlock(pageloc+(i*8),backpage+(Map[block+i]*256),no_clip,0);
     }
    currentline+=32;
    pageloc+=3072;
   }while(currentline<208);

   if(currentline<239)   // if we did not stop on an even tile end
    {
     offset=239-currentline;
     offset=32-offset;
     block=block-10;
     for(i=0;i<10;i++)   // draw the clipped tiles at bottom
      {
       DrawUnmaskedBlock(pageloc+(i*8), backpage+(Map[block+i]*256), bottom_clip, offset);
      }
    }
}


void WriteScore(void)   // draw the current score in upper left of screen
{
 int temp, temp_score;

 temp = score/10000;
 CopyFontToDisplay(Font1[temp],spr_page[current_page],40,310);
 temp_score = score-temp*10000;
 temp = temp_score/1000;
 CopyFontToDisplay(Font1[temp],spr_page[current_page],40,318);
 temp_score = temp_score - temp*1000;
 temp = temp_score/100;
 CopyFontToDisplay(Font1[temp],spr_page[current_page],40,326);
 temp_score = temp_score - temp*100;
 temp = temp_score/10;
 CopyFontToDisplay(Font1[temp],spr_page[current_page],40,334);
 temp_score = temp_score - temp*10;
 CopyFontToDisplay(Font1[temp_score],spr_page[current_page],40,342);
}

void WriteShields()   // draw bars indication sheild levels is top left
{
  int i;

  for(i=0; i<(ship.hit_points/10); i++)
   {
     CopyMSpriteToDisplay(Images[20],spr_page[current_page],60,300+(i*5));
   }
}

//********************************************************************
//   MAIN PROGRAM LOOP
//********************************************************************
void main()
{
#ifdef TEST
 unsigned int start_time,
     stop_time,
     fps=0;
#endif

 unsigned char remove, Done = FALSE, scroll_count = 0;
 unsigned char enimy_index = 0;
 thing *current = NULL;


install_key_handler();

asm { mov ah, 0       // set to mode 13h
      mov al, 0x13
      int 0x10 }

Set320x240Mode();     // now tweak to 320 by 200 mode X with virtual screen
                      // width of 384

if (!ReadLevelData())   // if we could not read data file
 {
  asm { mov ax, 3       // go back to text mode
       int 0x10 }

   remove_key_handler();  // reset the keyboard

   cerr << "Cannot read level data file.\n";
   return;     // end program
 }


 ShowPage(page2);      // show second page before we draw on the first
 BackLine=320;        // top of screen initally line 320

 setpal();            // load the pallette

#ifdef TEST
 start_time = time(NULL);  /* initialise count for fps */
#endif

while(!Done)
{
   DrawBackLevel(page[current_page]);  // draw the background

   while(EMap[enimy_index].line_number <= BackLine) // check if any enimies
                                                    // need creating
    {
      switch (EMap[enimy_index].enimy_number)  // generate the enimy
        {
           case 0: // enimy1
                  temp = new Enimy1(EMap[enimy_index].x_location,0);
                  temp->next = enimy_list;
                  if (enimy_list != NULL)
                  {
                   enimy_list->prev = temp;
                  }
                  enimy_list = temp;
                 break;

          case  1: // enimy2
                  temp = new Enimy2(EMap[enimy_index].x_location,0);
                  temp->next = enimy_list;
                  if (enimy_list != NULL)
                  {
                   enimy_list->prev = temp;
                  }
                  enimy_list = temp;
                 break;
          case  2: // gunnie
                  temp = new Gunnie(EMap[enimy_index].x_location,0);
                  temp->next = enimy_list;
                  if (enimy_list != NULL)
                  {
                   enimy_list->prev = temp;
                  }
                  enimy_list = temp;
                 break;
         case  3: // blaster
                  temp = new Blaster(EMap[enimy_index].x_location,0);
                  temp->next = ground_list;
                  if (ground_list != NULL)
                  {
                   ground_list->prev = temp;
                  }
                  ground_list = temp;
                 break;
         case  4: // Boss
                  temp = new Boss(EMap[enimy_index].x_location,0);
                  temp->next = enimy_list;
                  if (enimy_list != NULL)
                  {
                   enimy_list->prev = temp;
                  }
                  enimy_list = temp;
                 break;
        }
       enimy_index++;    // go to next struct
     }

//************************************* DRAW ITEMS *********************

   current = ground_list;
   while(current != NULL)         // iterator to show ground enimies
   {
    remove = current->show();
    if (remove == TRUE)
     {
      temp = current;
      current = current->next;
      if(temp->prev != NULL)
       {
         temp->prev->next = temp->next;
       }
      else
       {
         ground_list = temp->next;
       }
      if(temp->next != NULL)
       {
        temp->next->prev = temp->prev;
       }
       delete temp;
     }
    else
     current = current->next;
   }

   remove = ship.show();    // draw the player's ship
   if(remove == TRUE)       // if ship destroyed,  resest (infinite ships)
     {
       ship.reset();
     }

   current = enimy_list;
   while(current != NULL)         // iterator to show enimies
   {
    remove = current->show();
    if (remove == TRUE)
     {
      temp = current;
      current = current->next;
      if(temp->prev != NULL)
       {
         temp->prev->next = temp->next;
       }
      else
       {
         enimy_list = temp->next;
       }
      if(temp->next != NULL)
       {
        temp->next->prev = temp->prev;
       }
       delete temp;
     }
    else
     current = current->next;
   }


   current = eshot_list;
   while(current != NULL)     // iterator to show all enimy shots
   {
    remove = current->show();
    if (remove == TRUE)
     {
      temp = current;
      current = current->next;
      if(temp->prev != NULL)
       {
         temp->prev->next = temp->next;
       }
      else
       {
         eshot_list = temp->next;
       }
      if(temp->next != NULL)
       {
        temp->next->prev = temp->prev;
       }
       delete temp;
     }
    else
     current = current->next;
   }


   current = extra_list;
   while(current != NULL)         // iterator to show extras
   {
    remove = current->show();
    if (remove == TRUE)
     {
      temp = current;
      current = current->next;
      if(temp->prev != NULL)
       {
         temp->prev->next = temp->next;
       }
      else
       {
         extra_list = temp->next;
       }
      if(temp->next != NULL)
       {
        temp->next->prev = temp->prev;
       }
       delete temp;
     }
    else
     current = current->next;
   }


   current = shot_list;
   while(current != NULL)    // iterator to show all shots
   {
    remove = current->show();
    if (remove == TRUE)
     {
      temp = current;
      current = current->next;
      if(temp->prev != NULL)
       {
         temp->prev->next = temp->next;
       }
      else
       {
         shot_list = temp->next;
       }
      if(temp->next != NULL)
       {
        temp->next->prev = temp->prev;
       }
       delete temp;
     }
    else
     current = current->next;
   }

  WriteScore();
  WriteShields();

  while(keys[SCAN_D]){}   // pause if delay key pressed

  if(BackLine<LAST_LINE)
   {
    BackLine++;  // keep scolling untill the end is reached
   }
  else
   {
     if(enimy_list == NULL)  // end of level and no more enimies
      {
        Done = TRUE;
      }
   }
#ifdef TEST
  fps++;
#endif

  ShowPage(page[current_page]);  // show the page we just drew to

  scroll_count++;  // scroll the pallette every 5 frames
  scroll_count = scroll_count%5;
  if(scroll_count == 0) palscroll();

  current_page++;                               // increment the page number
  if(current_page==2){ current_page=0; }

  if(keys[SCAN_ESC]) Done = TRUE;    // exit if escape is pressed

}

#ifdef TEST
 stop_time = time(NULL);  /* stop the fsp counter */
#endif

 asm { mov ax, 3     // reset to text mode
       int 0x10 }


// REMOVE ALL OBJECTS

 current = ground_list;
 while(current != NULL)
 {
   temp = current;
   current = current->next;
   delete temp;
 }

 current = shot_list;
 while(current != NULL)
 {
   temp = current;
   current = current->next;
   delete temp;
 }

 current = extra_list;
 while(current != NULL)
 {
   temp = current;
   current = current->next;
   delete temp;
 }

 current = eshot_list;
 while(current != NULL)
 {
   temp = current;
   current = current->next;
   delete temp;
 }

 current = enimy_list;
 while(current != NULL)
 {
   temp = current;
   current = current->next;
   delete temp;
 }

#ifdef TEST
 cout << " Frames per second : " << fps/(stop_time-start_time) << "\n";
#endif

 remove_key_handler();  // reset the keyboard

 return;  // exit
}
