DECLARE SUB instruction ()
DECLARE SUB options ()
DECLARE SUB credits ()
DECLARE SUB scolors ()
DECLARE SUB finished ()
'$INCLUDE: 'directqb.bi'

DECLARE FUNCTION PITCal& ()
DECLARE SUB delay (Seconds!)
DECLARE SUB PlayMid (FileName$)
DECLARE SUB PlayMIDI (MIDISegment%, MIDIOffset%)
DECLARE SUB LoadMIDI (FileName$, MIDISegment%, MIDIOffset%)
DECLARE FUNCTION BytesRequired& (FileName$)
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE FUNCTION MIDIError$ ()
DECLARE SUB PauseMIDI ()
DECLARE SUB ResumeMIDI ()
DECLARE SUB StopMIDI ()
DECLARE FUNCTION TimeMIDI! ()


'Used by DriversLoaded
DECLARE SUB InternalGetIntVector (IntNum%, Segment%, Offset%)

DIM SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER
DIM SHARED MIDI.LOADED AS INTEGER, SBMIDI.INTERRUPT AS INTEGER
DIM SHARED SBSIM.INTERRUPT AS INTEGER, PAUSED AS SINGLE
DIM SHARED SENSITIVE AS INTEGER, SOUND.DISABLED AS INTEGER

DIM SHARED Pal AS STRING * 768
DIM SHARED spider(400) AS INTEGER
DIM SHARED butfly(400) AS INTEGER
DIM SHARED xm, ym, speedtold AS INTEGER
DIM SHARED speedt!
DIM SHARED PIT(1) AS LONG


REM DriversLoaded SBMIDI.INTERRUPT, SBSIM.INTERRUPT
REM IF SBMIDI.INTERRUPT = 0 THEN SBMIDI.INTERRUPT = &H80
REM IF SBSIM.INTERRUPT = 0 THEN SBSIM.INTERRUPT = &H81


'PIT(0) = PITCal
'OPEN "SETTINGS.CFG" FOR INPUT AS #1
'INPUT #1, speedt!
'CLOSE #1


IF DQBinit(10, 4, 0) THEN finished
DQBinitVGA
DQBsetFrameRate 50
IF DQBloadImage(1, 0, 0, "DATA\spider.bmp", Pal, 100, 16) THEN finished
FOR i = 0 TO 1
DQBget 1, i * 16, 0, i * 16 + 16, 16, VARSEG(spider(i * 200)), VARPTR(spider(i * 200))
NEXT i
DQBclearLayer 1
IF DQBloadImage(1, 0, 0, "DATA\butfly.bmp", Pal, 100, 16) THEN finished
FOR i = 0 TO 1
DQBget 1, i * 16, 0, i * 16 + 16, 16, VARSEG(butfly(i * 200)), VARPTR(butfly(i * 200))
NEXT i

DQBsetPal Pal
   
   
   
    scolors

DQBgetPal Pal
DO: LOOP UNTIL NOT DQBkey(KEYESC)
DQBclearLayer 2: DQBclearLayer 3
DQBprints 2, "NEW GAME   ", CENTERED, 50, 100, BOLD
DQBprints 2, "INSTRUCTION", CENTERED, 70, 99, BOLD
DQBprints 2, "INTRO      ", CENTERED, 90, 98, BOLD
DQBprints 2, "CREDITS    ", CENTERED, 110, 97, BOLD
DQBprints 2, "QUIT       ", CENTERED, 130, 96, BOLD


t = 0
x = 0: y = 0: dx = 1: dy = 1: x1 = 90: dx1 = 1: menuopt = 0

begin:


DO
DQBcopyLayer 3, 1
t = (t + 1) MOD 2
x = x + dx: y = y + dy: x1 = x1 + dx1
IF x < 1 OR x > 302 THEN dx = -dx
IF y < 1 OR y > 182 THEN dy = -dy
IF x1 < 1 OR x1 > 302 THEN dx1 = -dx1
DQBput 1, x, y, VARSEG(spider(t * 200)), VARPTR(spider(t * 200))
DQBput 1, x1, 100 + 50 * SIN(2 * x1 * (3.14 / 180)), VARSEG(butfly(t * 200)), VARPTR(butfly(t * 200))
DQBpset 3, x + 8, y + 8, 232
DQBcopyTransLayer 2, 1
xm = DQBmouseX: ym = DQBmouseY
DQBcopyLayer 1, 4
DQBbtri 4, xm, ym, xm + 16, ym + 5, xm + 9, ym + 14, 233, 1
DQBcopyLayer 4, 0

        IF xm > 99 AND xm < 216 THEN
            SELECT CASE ym
                CASE 45 TO 59
                    IF menuopt <> 1 THEN
                    DQBplaySound 1, 1, 22050, ONCE
                    menuopt = 1
                    END IF
                    FOR i = 96 TO 100: DQBsetCol i, 0, 20 + (i - 96) * 10, 0: NEXT i
                    DQBsetCol 100, 63, 50, 63
                 CASE 65 TO 79
                    IF menuopt <> 2 THEN
                    DQBplaySound 1, 1, 22050, ONCE
                    menuopt = 2
                    END IF
                    FOR i = 96 TO 100: DQBsetCol i, 0, 20 + (i - 96) * 10, 0: NEXT i
                    DQBsetCol 99, 56, 40, 56
                 CASE 85 TO 99
                    IF menuopt <> 3 THEN
                    DQBplaySound 1, 1, 22050, ONCE
                    menuopt = 3
                    END IF
                    FOR i = 96 TO 100: DQBsetCol i, 0, 20 + (i - 96) * 10, 0: NEXT i
                    DQBsetCol 98, 50, 30, 50
                 CASE 105 TO 119
                    IF menuopt <> 4 THEN
                    DQBplaySound 1, 1, 22050, ONCE
                    menuopt = 4
                    END IF
                    FOR i = 96 TO 100: DQBsetCol i, 0, 20 + (i - 96) * 10, 0: NEXT i
                    DQBsetCol 97, 45, 20, 45
                 CASE 125 TO 139
                    IF menuopt <> 5 THEN
                    DQBplaySound 1, 1, 22050, ONCE
                    menuopt = 5
                    END IF
                    FOR i = 96 TO 100: DQBsetCol i, 0, 20 + (i - 96) * 10, 0: NEXT i
                    DQBsetCol 96, 40, 10, 40
                 CASE ELSE
                        menuopt = 0
                        FOR i = 96 TO 100: DQBsetCol i, 0, 20 + (i - 96) * 10, 0: NEXT i
                 END SELECT
        ELSE
                        menuopt = 0
                        FOR i = 96 TO 100: DQBsetCol i, 0, 20 + (i - 96) * 10, 0: NEXT i
        END IF

IF DQBkey(KEYESC) THEN
REM StopMidi
DQBclose
END
END IF
DO: LOOP UNTIL DQBframeReady
LOOP UNTIL DQBmouseLB
        
        DQBwait 3
       
        IF xm > 99 AND xm < 216 THEN
            SELECT CASE ym
                CASE 45 TO 59
                DQBplaySound 4, 4, 22050, ONCE
                DQBwait 60
                DQBclose
                dummy& = SETMEM(30000)
                RUN "ROUTINES\arkanoid.exe"
                END
                CASE 65 TO 79
                DQBplaySound 4, 4, 22050, ONCE
                instruction
                GOTO begin
                CASE 85 TO 99
                DQBplaySound 4, 4, 22050, ONCE
                RUN "ROUTINES\start.exe"
                GOTO begin
                CASE 105 TO 119
                DQBplaySound 4, 4, 22050, ONCE
                credits
                GOTO begin
                CASE 125 TO 139
                    REM StopMidi
                    DQBplaySound 2, 2, 22050, ONCE
                    DQBwait 50
                    DQBclose
                    END
                CASE ELSE
                        DQBplaySound 3, 3, 22050, ONCE
                        GOTO begin
                END SELECT
        ELSE
                        DQBplaySound 3, 3, 22050, ONCE
                        GOTO begin
        END IF



REM StopMidi
DQBclose
dummy& = SETMEM(30000)
END
DEFSNG A-Z

REM $DYNAMIC
FUNCTION BytesRequired& (FileName$)
'Open the file.
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
'Store the length of the file.
FileLen& = LOF(FF%)
'Close the file.
CLOSE FF%
'If the length of the file is 0, assume it does not exist and delete it.
IF FileLen& = 0 THEN
    KILL FileName$
    MIDI.ERROR = 1
    EXIT FUNCTION
END IF
'Return the length of the file as the number of bytes required.
BytesRequired& = FileLen&
MIDI.ERROR = 0

END FUNCTION

REM $STATIC
DEFINT A-Z
SUB credits
    DO: LOOP UNTIL NOT DQBmouseLB
   
    rc1 = 0: gc1 = 0: bc1 = 0: rc2 = 0: gc2 = 0: bc2 = 0
    
    CALL DQBgetCol(1, rc1, gc1, bc1)
    CALL DQBgetCol(2, rc2, gc2, bc2)
    DQBtri 0, xm, ym, xm + 16, ym + 5, xm + 9, ym + 14, 0
    DQBcopyLayer 0, 5
    DQBclearLayer 0: DQBclearLayer 6: DQBclearLayer 7
    DQBsetCol 0, 0, 0, 0
    DQBsetBiosFont
    DQBsetCol 1, 35, 0, 0
    DQBsetCol 2, 34, 49, 67
    DQBsetClipBox 0, 19, 319, 180
   
    DO
    FOR i = 200 TO -750 STEP -1
            DQBprints 6, "Author:", CENTERED, i, 1, ITALIC
            DQBprints 6, "ALEKSANDER TROJANOWSKI", CENTERED, i + 20, 2, BOLD

            DQBprints 6, "Programming:", CENTERED, i + 50, 1, ITALIC
            DQBprints 6, "ALEKSANDER TROJANOWSKI", CENTERED, i + 70, 2, BOLD

            DQBprints 6, "Objects designing:", CENTERED, i + 100, 1, ITALIC
            DQBprints 6, "ALEKSANDER TROJANOWSKI", CENTERED, i + 120, 2, BOLD

            DQBprints 6, "SFX:", CENTERED, i + 150, 1, ITALIC
            DQBprints 6, "I DON'T KNOW BUT THANKS", CENTERED, i + 170, 2, BOLD

            DQBprints 6, "General idea:", CENTERED, i + 200, 1, ITALIC
            DQBprints 6, "BASED ON A POPULAR 8-bit GAME", CENTERED, i + 220, 2, BOLD

            DQBprints 6, STRING$(30, "-"), CENTERED, i + 280, 1, NONE

            DQBprints 6, "THANKS TO", CENTERED, i + 340, 1, BOLD
            DQBprints 6, "ANGELO MOTTOLA", CENTERED, i + 360, 2, NONE
            DQBprints 6, "from", CENTERED, i + 380, 2, NONE
            DQBprints 6, "ENHANCED CREATIONS", CENTERED, i + 400, 2, BOLD + ITALIC
            DQBprints 6, "for his stunning library", CENTERED, i + 420, 2, NONE
            DQBprints 6, "DirectQB", CENTERED, i + 440, 2, BOLD + ITALIC
            DQBprints 6, "and tons of useful tips...", CENTERED, i + 460, 2, NONE

            DQBprints 6, STRING$(10, "*"), CENTERED, i + 490, 1, NONE

            DQBprints 6, "JESSE DORLAND", CENTERED, i + 520, 2, NONE
            DQBprints 6, "for his QMidi routines", CENTERED, i + 540, 2, NONE

            DQBprints 6, STRING$(10, "*"), CENTERED, i + 570, 1, NONE
           
            DQBprints 6, "ANDREW L. AYERS", CENTERED, i + 600, 2, NONE
            DQBprints 6, "for his GET \ PUT", CENTERED, i + 620, 2, NONE
            DQBprints 6, "Information and Techniques", CENTERED, i + 640, 2, NONE

            DQBprints 6, STRING$(30, "*"), CENTERED, i + 690, 1, NONE

            DQBprints 6, "AlexSoft(C) February 2001", CENTERED, i + 740, 254, BOLD


DQBcopyLayer 6, 0
DQBclearLayer 6
IF DQBinkey$ > "" OR DQBmouseLB OR DQBmouseRB THEN GOTO endCredits
DO: LOOP UNTIL DQBframeReady
    NEXT i
LOOP

endCredits:
                    DQBplaySound 2, 2, 22050, ONCE
IF DQBloadFont("DATA\thin2.fnt") THEN finished
DQBsetClipBox 0, 0, 319, 199
DQBsetCol 1, rc1, gc1, bc1
DQBsetCol 2, rc2, gc2, bc2
DQBcopyLayer 5, 0
DQBsetMousePos 80, 100
END SUB

SUB delay (Seconds!)
    d& = FIX(Seconds! * PIT(0))
    FOR t& = 0 TO d&: WAIT 64, 128: WAIT 64, 128, 128: NEXT
END SUB

REM $DYNAMIC
DEFSNG A-Z
SUB DriversLoaded (SBMIDI%, SBSIM%) STATIC
'Open the data file.
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
'If the file is empty, return an error
FileSize& = LOF(FF%)
IF FileSize& = 0 THEN
    CLOSE FF%
    KILL "DRIVERS.DAT"
    MIDI.ERROR = 1
    EXIT SUB
'If the file is not exactly 1 kilobyte in size, return an error
ELSEIF FileSize& <> 1024 THEN
    CLOSE FF%
    MIDI.ERROR = 9
    EXIT SUB
END IF
'Load the driver data.
REDIM DRIVERDATA$(1 TO 5)
FOR i% = 1 TO 4
    DRIVERDATA$(i%) = INPUT$(256, #FF%)
NEXT i%
CLOSE #FF%

'Check the interrupt handlers for int 80h-E1h to see if they contain
'program code from either SBSIM or SBMIDI.
SBMIDI% = 0
SBSIM% = 0
FOR i% = &H80 TO &HE1
    'Get the address of the interrupt handler.
    InternalGetIntVector i%, Segment%, Offset%
    'If the address is null, then the interrupt is not in use, and can be
    'skipped.
    IF Segment% = 0 AND Offset% = 0 THEN GOTO Skip:
    'The following code checks for the drivers by looking for the text
    '"SBMIDI" and "SBSIM" at certain locations in the driver code.  It
    'sounds simplistic, but it's very accurate.  If it doesn't work,
    'a different method is used.
    IF SBMIDI% = 0 THEN
        NewSegment% = CVI(MKI$(CVL(MKI$(Segment%) + CHR$(0) + CHR$(0)) - &H11&))
        DEF SEG = NewSegment%
        TEMP$ = ""
        FOR J% = 1 TO 6
            TEMP$ = TEMP$ + CHR$(PEEK(271 + J%))
        NEXT
        IF TEMP$ = "SBMIDI" THEN SBMIDI% = i%
    END IF
    IF SBSIM% = 0 THEN
        NewSegment% = CVI(MKI$(CVL(MKI$(Segment%) + CHR$(0) + CHR$(0)) - &H1&))
        DEF SEG = NewSegment%
        TEMP$ = ""
        FOR J% = 1 TO 5
            TEMP$ = TEMP$ + CHR$(PEEK(274 + J%))
        NEXT
        IF TEMP$ = "SBSIM" THEN SBSIM% = i%
    END IF

    'This is the second detection method.  It's more complex than the first
    'method, but not really any more accurate.  In fact, it's probably
    'less accurate.  It's kind of a last ditch effort in case the first
    'method fails.

    'Point to the segment of the interrupt handler.
    DEF SEG = Segment%
    'Read 256 bytes of the driver code.
    DRIVERDATA$(5) = ""
    FOR J% = 0 TO 255
        Byte% = PEEK(Offset% + J%)
        DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(Byte%)
    NEXT J%
    'Check to see if the code matches any of the previously saved data.
    FOR J% = 1 TO 4
        MATCH% = 1
        FOR K% = 0 TO 255
            IF MID$(DRIVERDATA$(J%), K% + 1, 1) <> MID$(DRIVERDATA$(5), K% + 1, 1) THEN
                SELECT CASE K%
                    CASE IS = 14, 15, 113, 114, 235, 236
                    CASE ELSE
                        MATCH% = 0
                        EXIT FOR
                END SELECT
            END IF
        NEXT K%
        IF MATCH% THEN
            IF J% = 1 THEN SBSIM% = i%
            IF J% <> 1 THEN SBMIDI% = i%
        END IF
        IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
    NEXT J%
    IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
Skip:
NEXT i%
MIDI.ERROR = 0
END SUB

REM $STATIC
DEFINT A-Z
SUB finished
REM StopMidi
DQBclose
PRINT DQBerror$
dummy& = SETMEM(30000)
END
END SUB

SUB instruction

    DO: LOOP UNTIL NOT DQBmouseLB
  
    rc1 = 0: gc1 = 0: bc1 = 0: rc2 = 0: gc2 = 0: bc2 = 0
   
    CALL DQBgetCol(1, rc1, gc1, bc1)
    CALL DQBgetCol(2, rc2, gc2, bc2)
    DQBtri 0, xm, ym, xm + 16, ym + 5, xm + 9, ym + 14, 0
    DQBcopyLayer 0, 5
    DQBclearLayer 0: DQBclearLayer 6: DQBclearLayer 7
    DQBsetCol 0, 0, 0, 0
    DQBsetBiosFont
    DQBsetCol 1, 35, 0, 0
    DQBsetCol 2, 34, 49, 67
    DQBsetCol 3, 63, 50, 30
    DQBsetCol 4, 0, 10, 50
    DQBsetCol 5, 50, 3, 4

 REM info
    DQBprint 0, "Use       to direct your pallete", CENTERED, 5, 2
    DQBprints 0, "MOUSE", 60, 5, 3, BOLD
    DQBprints 0, "L-CLICK", 10, 21, 3, BOLD
    DQBprint 0, "makes your ball move", 90, 21, 2
    DQBprints 0, "R-CLICK", 10, 37, 3, BOLD
    DQBprint 0, "launches a laser", 90, 37, 2
    DQBprint 0, "(if you have one)", 90, 53, 2
    DQBprints 0, "P key", 10, 69, 3, BOLD
    DQBprint 0, "pauses a game", 90, 69, 2
    DQBprints 0, "ESC key", 10, 85, 3, BOLD
    DQBprint 0, "turns you back to the menu", 90, 85, 2

    DQBprints 0, "While playing you'll see some", CENTERED, 110, 4, ITALIC
    DQBprints 0, "letters falling down after your", CENTERED, 126, 4, ITALIC
    DQBprints 0, "ball touches a brick.", CENTERED, 142, 4, ITALIC
    DQBprints 0, "The meaninig of them is as follows:", CENETERED, 158, 4, ITALIC

    DQBprints 0, "L-CLICK", 60, 180, 5, BOLD
    DQBprint 0, "to continue...", 140, 180, 2
DO: LOOP UNTIL DQBmouseLB OR DQBmouseRB OR DQBkey(KEYESC)
DQBplaySound 2, 2, 22050, ONCE
DO: LOOP UNTIL NOT DQBkey(KEYESC)
DO: LOOP UNTIL NOT DQBmouseLB
DO: LOOP UNTIL NOT DQBmouseRB
IF DQBloadFont("DATA\arca2.fnt") THEN finished
DQBclearLayer 0
    DQBsetCol 49, 0, 50, 6
    DQBsetCol 50, 0, 10, 60
    DQBsetCol 50, 30, 50, 0
    DQBsetCol 51, 50, 50, 0
    DQBsetCol 52, 40, 0, 0
    DQBsetCol 53, 40, 30, 30
    DQBsetCol 54, 63, 10, 11
    DQBsetCol 55, 30, 0, 32
    DQBsetCol 56, 25, 40, 33
    DQBsetCol 57, 0, 40, 16
    DQBsetCol 58, 30, 2, 11
    DQBsetCol 59, 50, 50, 50
    DQBsetCol 60, 50, 50, 50
    DQBsetCol 61, 40, 40, 40

    DQBsetCol 62, 0, 20, 0
    DQBsetCol 63, 0, 40, 0
    DQBsetCol 64, 0, 50, 0
    DQBsetCol 65, 0, 30, 0
    DQBsetCol 66, 0, 20, 0
    DQBsetCol 67, 50, 12, 11

DQBprint 0, "L", 25, 0, 49
DQBprint 0, "N", 25, 10, 50
DQBprint 0, "S", 25, 20, 51
DQBprint 0, "$", 25, 30, 51
DQBprint 0, "P", 25, 40, 52
DQBprint 0, "G", 25, 50, 53
DQBprint 0, "L", 25, 60, 54
DQBprint 0, "D", 25, 70, 55
DQBprint 0, "F", 25, 80, 56
DQBprint 0, "B", 25, 90, 57
DQBprint 0, "T", 25, 100, 58
DQBprint 0, "M", 25, 110, 59
DQBprint 0, "I", 25, 120, 67

DQBprint 0, "additional life", 50, 0, 3
DQBprint 0, "next level", 50, 10, 3
DQBprint 0, "ball speed increased", 50, 20, 3
DQBprint 0, "some extra points", 50, 30, 3
DQBprint 0, "previous level", 50, 40, 3
DQBprint 0, "enables you to glue the ball to your pallete", 50, 50, 3
DQBprint 0, "enables you to fire a laser cannon", 50, 60, 3
DQBprint 0, "ball speed decreased", 50, 70, 3
DQBprint 0, "lengthen you pallete", 50, 80, 3
DQBprint 0, "invulnerability", 50, 90, 3
DQBprint 0, "shorten your pallete", 50, 100, 3
DQBprint 0, "multiball", 50, 110, 3
DQBprint 0, "your mouse get inversed", 50, 120, 3
DQBsetBiosFont
    DQBprints 0, "L-CLICK", 20, 180, 5, BOLD
    DQBprint 0, "to get back to the menu...", 100, 180, 2




DO: LOOP UNTIL DQBmouseLB OR DQBmouseRB OR DQBkey(KEYESC)
DO: LOOP UNTIL NOT DQBkey(KEYESC)
DQBplaySound 2, 2, 22050, ONCE
IF DQBloadFont("DATA\thin2.fnt") THEN finished
DQBsetClipBox 0, 0, 319, 199
DQBsetCol 1, rc1, gc1, bc1
DQBsetCol 2, rc2, gc2, bc2
DQBsetPal Pal
DQBcopyLayer 5, 0
DQBsetMousePos 80, 100
END SUB

REM $DYNAMIC
DEFSNG A-Z
SUB InternalGetIntVector (IntNum%, Segment%, Offset%)
'If the code hasn't been loaded already, do it now.
IF GetIntVCodeLoaded% = 0 THEN
    asm$ = asm$ + CHR$(&H55)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
    asm$ = asm$ + CHR$(&H8A) + CHR$(&H7)
    asm$ = asm$ + CHR$(&HB4) + CHR$(&H35)
    asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
    asm$ = asm$ + CHR$(&H8C) + CHR$(&HC1)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HDA)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HF)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
    asm$ = asm$ + CHR$(&H89) + CHR$(&H17)
    asm$ = asm$ + CHR$(&H5D)
    asm$ = asm$ + CHR$(&HCB)
    asm$ = asm$ + CHR$(&H34) + CHR$(&H0)
    asm$ = asm$ + CHR$(&H60)
    asm$ = asm$ + CHR$(&H23) + CHR$(&H0)
    GetIntVCodeLoaded% = 1
END IF
'Execute the code
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(IntNum%, Segment%, Offset%, SADD(asm$))
END SUB

SUB LoadAndPlayLarge (FileName$) STATIC
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
'See if an extension was supplied, and if not, add one.
IF INSTR(FileName$, ".") = 0 THEN FileName$ = FileName$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
'If the file contains no data, return an error
FileLen& = LOF(FF%)
CLOSE #FF%
IF FileLen& = 0 THEN
    KILL FileName$
    MIDI.ERROR = 1
    EXIT SUB
END IF
'The sound driver needs an ASCIIZ string (a string that ends with
'character 0) for a file name.
IF RIGHT$(FileName$, 1) <> CHR$(0) THEN FileName$ = FileName$ + CHR$(0)
'Initialize the MIDI driver and load the file in memory
IF Lasm$ = "" THEN
        Lasm$ = Lasm$ + CHR$(&H55)
        Lasm$ = Lasm$ + CHR$(&H89) + CHR$(&HE5)
        Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H7)
        Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
        Lasm$ = Lasm$ + CHR$(&H8B) + CHR$(&H17)
        Lasm$ = Lasm$ + CHR$(&HBB) + CHR$(&H0) + CHR$(&H5)
        Lasm$ = Lasm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
        Lasm$ = Lasm$ + CHR$(&H5D)
        Lasm$ = Lasm$ + CHR$(&HCB)
END IF
DEF SEG = VARSEG(Lasm$)
Offset% = SADD(Lasm$)
CALL ABSOLUTE(SADD(FileName$), VARSEG(FileName$), Offset%)

'Start the music!!
IF Pasm$ = "" THEN
        Pasm$ = Pasm$ + CHR$(&HBB) + CHR$(&H1) + CHR$(&H5)
        Pasm$ = Pasm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
        Pasm$ = Pasm$ + CHR$(&HCB)
END IF
IF SOUND.DISABLED = 0 THEN
    DEF SEG = VARSEG(Pasm$)
    Offset% = SADD(Pasm$)
    CALL ABSOLUTE(Offset%)
    MIDI.PLAYTIME = TIMER
END IF
MIDI.LOADED = 1
MIDI.ERROR = 0
END SUB

SUB LoadMIDI (FileName$, MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'See if an extension was supplied, and if not, add one.
IF INSTR(FileName$, ".") = 0 THEN FileName$ = FileName$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL FileName$: MIDI.ERROR = 1: EXIT SUB
'If the file is too large, exit now.
IF FileLen& > 65536 THEN MIDI.ERROR = 2: EXIT SUB
'Make the filename an ASCIIZ string.
FileName$ = FileName$ + CHR$(0)
'Check if the assembly language code has already been loaded;
'if not, do it now.
IF ask$ = "" THEN
        asm$ = asm$ + CHR$(&H1E)
        asm$ = asm$ + CHR$(&H55)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
        asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
        asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HC6)
        asm$ = asm$ + CHR$(&HB4) + CHR$(&H3F)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&HF)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
        asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HF3)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&HB4) + CHR$(&H3E)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&H5D)
        asm$ = asm$ + CHR$(&H1F)
        asm$ = asm$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
END IF
'Call the assembly language routine.
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(VARSEG(FileName$), SADD(FileName$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm$))
MIDI.ERROR = 0
END SUB

FUNCTION MIDIError$
SELECT CASE MIDI.ERROR
        CASE 0: MIDIError$ = "NO ERROR"
        CASE 1: MIDIError$ = "FILE CONTAINS NO DATA"
        CASE 2: MIDIError$ = "FILE IS TOO LARGE"
        CASE 3: MIDIError$ = "NO MIDI FILE PLAYING"
        CASE 4: MIDIError$ = "INVALID SBMIDI INTERRUPT"
        CASE 5: MIDIError$ = "INVALID SBSIM INTERRUPT"
        CASE 6: MIDIError$ = "NO MIXER CHIP"
        CASE 7: MIDIError$ = "COULD NOT DETECT SOUND CARD"
        CASE 8: MIDIError$ = "FEATURE UNAVAILABLE"
        CASE 9: MIDIError$ = "FILE IS CORRUPT"
        CASE 10: MIDIError$ = "INVALID SOUND CARD TYPE"
        CASE ELSE: MIDIError$ = "UNKNOWN ERROR"
END SELECT
END FUNCTION

REM $STATIC
DEFINT A-Z
SUB options
   
    OPEN "DATA\lines.cfg" FOR INPUT AS #1
    INPUT #1, music
    INPUT #1, sfx
    INPUT #1, cpu
    INPUT #1, rounds
    INPUT #1, speedtold
    CLOSE #1
    KILL "DATA\lines.cfg"
    
    opt = 0
    REM StopMidi
    REM PlayMid "DATA\options.mid"
    DQBgetPal Pal
    DQBtri 0, xm, ym, xm + 16, ym + 5, xm + 9, ym + 14, 0
    DQBcopyLayer 0, 5
    DQBclearLayer 0: DQBclearLayer 6: DQBclearLayer 7
    FOR i = 1 TO 6: DQBsetCol i, 0, 40, 5: NEXT i
    
DQBsetSolidPut


beginoptions:
DO
    IF music = 1 THEN
    DQBprints 6, "GAME MUSIC                ON", 1, 20, 1, BOLD
    ELSE
    DQBprints 6, "GAMES MUSIC              OFF", 1, 20, 1, BOLD
    END IF
    IF sfx = 1 THEN
    DQBprints 6, "GAMES SFX                 ON", 1, 50, 2, BOLD
    ELSE
    DQBprints 6, "GAME  SFX                OFF", 1, 50, 2, BOLD
    END IF

    DQBprints 6, "CPU IQ                    " + LTRIM$(STR$(cpu)), 1, 80, 3, BOLD
    DQBprints 6, "NUMBER OF ROUNDS          " + LTRIM$(STR$(rounds)), 1, 110, 4, BOLD
    DQBprints 6, "DONE", CENTERED, 180, 6, BOLD
   xm = DQBmouseX: ym = DQBmouseY
DQBcopyLayer 6, 7
DQBbtri 7, xm, ym, xm + 16, ym + 5, xm + 9, ym + 14, 233, 1
DQBcopyLayer 7, 0

            SELECT CASE ym
                CASE 15 TO 29
                IF opt <> 1 THEN
                DQBplaySound 1, 1, 22050, ONCE
                opt = 1
                END IF
                FOR i = 1 TO 6: DQBsetCol i, 0, 40, 5: NEXT i
                DQBsetCol 1, 63, 50, 63

                CASE 45 TO 59
                IF opt <> 2 THEN
                DQBplaySound 1, 1, 22050, ONCE
                opt = 2
                END IF
                FOR i = 1 TO 6: DQBsetCol i, 0, 40, 5: NEXT i
                DQBsetCol 2, 50, 40, 50

                CASE 75 TO 89
                IF opt <> 3 THEN
                DQBplaySound 1, 1, 22050, ONCE
                opt = 3
                END IF
                FOR i = 1 TO 6: DQBsetCol i, 0, 40, 5: NEXT i
                DQBsetCol 3, 50, 40, 50

                CASE 105 TO 119
                IF opt <> 4 THEN
                DQBplaySound 1, 1, 22050, ONCE
                opt = 4
                END IF
                FOR i = 1 TO 6: DQBsetCol i, 0, 40, 5: NEXT i
                DQBsetCol 4, 50, 40, 50

                CASE 175 TO 189
                IF opt <> 6 THEN
                DQBplaySound 1, 1, 22050, ONCE
                opt = 6
                END IF
                FOR i = 1 TO 6: DQBsetCol i, 0, 40, 5: NEXT i
                DQBsetCol 6, 50, 40, 50
               
                CASE ELSE
                FOR i = 1 TO 6: DQBsetCol i, 0, 40, 5: NEXT i
                opt = 0
                END SELECT
LOOP UNTIL DQBmouseLB
            SELECT CASE ym
                
                CASE 15 TO 29
                DQBplaySound 4, 4, 22050, ONCE
                DQBboxf 6, 0, 20, 319, 30, 0
                DQBwait 20
                IF music = 1 THEN music = 0: GOTO beginoptions
                IF music = 0 THEN music = 1: GOTO beginoptions
                CASE 45 TO 59
                DQBplaySound 4, 4, 22050, ONCE
                DQBboxf 6, 0, 50, 319, 60, 0
                DQBwait 20
                IF sfx = 1 THEN sfx = 0: GOTO beginoptions
                IF sfx = 0 THEN sfx = 1: GOTO beginoptions
                CASE 75 TO 89
                DQBplaySound 4, 4, 22050, ONCE
                DQBboxf 6, 0, 80, 319, 90, 0
                DQBwait 20
                IF cpu = 1 THEN cpu = 2: GOTO beginoptions
                IF cpu = 2 THEN cpu = 3: GOTO beginoptions
                IF cpu = 3 THEN cpu = 1: GOTO beginoptions
               
                CASE 105 TO 119
                DQBplaySound 4, 4, 22050, ONCE
                DQBboxf 6, 0, 100, 319, 120, 0
                DQBwait 20
                IF rounds = 1 THEN rounds = 3: GOTO beginoptions
                IF rounds = 3 THEN rounds = 5: GOTO beginoptions
                IF rounds = 5 THEN rounds = 1: GOTO beginoptions
               
                CASE 175 TO 189
                DQBplaySound 4, 4, 22050, ONCE
                DQBwait 20
                GOTO endOptions
                CASE ELSE
                DQBplaySound 3, 3, 22050, ONCE
                DQBwait 5
                GOTO beginoptions
                END SELECT
                       
endOptions:

OPEN "DATA\lines.cfg" FOR APPEND AS #1
    PRINT #1, music
    PRINT #1, sfx
    PRINT #1, cpu
    PRINT #1, rounds
    PRINT #1, speedtold
CLOSE #1
DQBsetTransPut
DQBsetPal Pal
DQBcopyLayer 5, 0
DQBsetMousePos 80, 100
REM StopMidi
REM PlayMid "DATA\menu2.mid"
END SUB

REM $DYNAMIC
DEFSNG A-Z
SUB PauseMIDI
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
'If no MIDI file is playing, exit now
IF MIDI.PLAYTIME = 0 THEN
    MIDI.ERROR = 3
    EXIT SUB
END IF
'Pause the music.
IF asm$ = "" THEN
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H3) + CHR$(&H5)
        asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
        asm$ = asm$ + CHR$(&HCB)
END IF
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL ABSOLUTE(Offset%)
'Save the number of seconds the MIDI file has been playing.
PAUSED = TimeMIDI!
'If it hasn't been playing long enough for TimeMIDI! to return
'a value greater than 0, change PAUSED to a tiny positive value.
IF PAUSED = 0! THEN PAUSED = .00001
'Indicate that the file has stopped playing.
MIDI.PLAYTIME = 0
MIDI.ERROR = 0
END SUB

REM $STATIC
DEFINT A-Z
FUNCTION PITCal&
   p& = 0: DEF SEG = 0: x% = (PEEK(&H46C) + 1) AND 255
   WHILE x% <> (PEEK(&H46C) AND 255): WEND
   WHILE x% = (PEEK(&H46C) AND 255)
      p& = p& + 33
      FOR t% = 1 TO 19: WAIT (64), 128, 128: WAIT (64), 128: NEXT
   WEND
   PITCal& = p& * 11.02
END FUNCTION

REM $DYNAMIC
DEFSNG A-Z
SUB PlayMid (FileName$)

    DIM MIDI%(BytesRequired&(FileName$) \ 2)
    LoadMIDI FileName$, VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
    PlayMIDI VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
    ERASE MIDI%

END SUB

SUB PlayMIDI (MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Check to see if the MIDI playing code has previously been loaded.
'If not, load it now.
IF asm$ = "" THEN
        'Load the machine codes into a string.
        asm$ = asm$ + CHR$(&H55)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H7)
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
        asm$ = asm$ + CHR$(&H5D)
        asm$ = asm$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
END IF
IF SOUND.DISABLED = 0 THEN
    'Call the machine language routine to play the music.
    DEF SEG = VARSEG(asm$)
    Offset% = SADD(asm$)
    CALL ABSOLUTE(MIDISegment%, MIDIOffset%, Offset%)
    'Start the MIDI timer.
    MIDI.PLAYTIME = TIMER
END IF
END SUB

SUB ResumeMIDI
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
'If no MIDI file is paused, exit now
IF PAUSED = 0! THEN EXIT SUB
'Resume playing.
IF asm$ = "" THEN
        asm$ = ""
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H5)
        asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
        asm$ = asm$ + CHR$(&HCB)
END IF
DEF SEG = VARSEG(asm$)
Offset% = SADD(asm$)
CALL ABSOLUTE(Offset%)
MIDI.PLAYTIME = TIMER - PAUSED
PAUSED = 0!
MIDI.ERROR = 0
END SUB

REM $STATIC
DEFINT A-Z
SUB scolors

DQBsetCol 0, 0, 0, 0
DQBsetCol 255, 0, 0, 0
DQBsetCol 232, 15, 15, 15
DQBsetCol 233, 0, 20, 63
DQBsetCol 231, 50, 0, 0

FOR i = 96 TO 100: DQBsetCol i, 0, 20 + (i - 96) * 10, 0: NEXT i

FOR i = 234 TO 254: DQBsetCol i, 0, 0, 289 - i: NEXT i

dummy& = SETMEM(-30000)
IF DQBcreateBMap(1, 233, 233) THEN finished
FOR f = 0 TO 200 STEP 10
FOR b = f TO f + 9
    DQBsetBMap 1, 233, b * (255 / 210), 234 + f \ 10
NEXT b, f


IF DQBloadFont("DATA\thin2.fnt") THEN finished
IF NOT DQBmouseDetected THEN finished
DQBsetMousePos 150, 100

DQBinstallKeyboard

IF DQBinstallSB(TRUE, 5, 22050, &H220, AUTO, AUTO) THEN finished
IF DQBloadSound(1, "DATA\SFX\click2.wav") THEN finished
IF DQBloadSound(2, "DATA\SFX\box2.wav") THEN finished
IF DQBloadSound(3, "DATA\SFX\option.wav") THEN finished
IF DQBloadSound(4, "DATA\SFX\optionin.wav") THEN finished
DQBsetTransPut
END SUB

REM $DYNAMIC
DEFSNG A-Z
SUB StopMIDI STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Stop the music!!
IF asm$ = "" THEN
    asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
    asm$ = asm$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
    asm$ = asm$ + CHR$(&HCB)
END IF
IF MIDI.PLAYTIME THEN
    DEF SEG = VARSEG(asm$)
    Offset% = SADD(asm$)
    CALL ABSOLUTE(Offset%)
    MIDI.ERROR = 0
ELSE
    MIDI.ERROR = 3
END IF
'No MIDI file is playing, so reset the timer
MIDI.PLAYTIME = 0
END SUB

FUNCTION TimeMIDI!
'If a MIDI file is paused, lock the current playing time
IF PAUSED > 0! THEN
    TimeMIDI! = PAUSED
    MIDI.ERROR = 0
'If a MIDI file is playing, carry out the timing routine
ELSEIF MIDI.PLAYTIME THEN
    'Get the current time
    CurrentTime! = TIMER
    'If midnight has come since the MIDI file started playing, change
    'CurrentTime! accordingly
    IF CurrentTime! - MIDI.PLAYTIME < 0 THEN
        CurrentTime! = 86400 + CurrentTime!
    END IF
    'Get the final result
    TimeMIDI! = CurrentTime! - MIDI.PLAYTIME
    MIDI.ERROR = 0
ELSE
    MIDI.ERROR = 3
END IF
END FUNCTION

