' ALIEN EGG HUNT
' by Aaron Severn

' Make sure that all the game data files are in your QBasic directory.
' The files are ALPHABET.DAT, EGGEXPL.DAT, EGGRAPH1.DAT, EGGRAPH2.DAT,
' EGGRAPH3.DAT and SYMBOL.DAT.  I could have set up something to find the
' files but the game is already so memory hungry that I didn't want to use up
' any more.

DEFINT A-Z

DECLARE SUB breakOff ()
DECLARE SUB breakOn ()
DECLARE SUB clearRegister ()
DECLARE FUNCTION clock% (oldTime&)
DECLARE SUB clrConvert (clr%)
DECLARE FUNCTION compSpeed! ()
DECLARE SUB delay (secs!)
DECLARE FUNCTION detectCard ()
DECLARE SUB fileCheck (fileName$)
DECLARE SUB font (x%, y%, text$)
DECLARE SUB gameOver ()
DECLARE SUB getRecordFile (fileName$, errorCode%)
DECLARE FUNCTION getLabel$ ()
DECLARE SUB initGraphics ()
DECLARE SUB instructions ()
DECLARE SUB intro (ply%)
DECLARE SUB highScore (score&)
DECLARE SUB levelIntro (level%, eggs%)
DECLARE SUB levelOutro (bonusPts%)
DECLARE SUB newPut (x%, y%, sprite!())
DECLARE SUB musicPlayer (chan%)
DECLARE SUB playAgain ()
DECLARE SUB playEggHunt ()
DECLARE SUB plotStars (numStars%)
DECLARE SUB putFile (text$)
DECLARE SUB SBInit ()
DECLARE SUB SBPlay (chan%, freq%, octave%, vol%)
DECLARE SUB screenShot (errorCode%)
DECLARE SUB setChannel (chan%, fileName$)
DECLARE SUB setFX (chan%, curFX%())
DECLARE SUB SFXPlay (chan%, freq%, vol%)
DECLARE SUB title ()
DECLARE SUB viewRecording ()
DECLARE SUB winGame ()
DECLARE SUB WriteReg (reg%, value%)

RANDOMIZE TIMER

SCREEN 9
CLS

'These variables hold the letter and number sprites
DIM lA!(60)
DIM lB!(60)
DIM lC!(60)
DIM lD!(60)
DIM lE!(60)
DIM lF!(60)
DIM lG!(60)
DIM lH!(60)
DIM lI!(60)
DIM lJ!(60)
DIM lK!(60)
DIM lL!(60)
DIM lM!(60)
DIM lN!(60)
DIM lO!(60)
DIM lP!(60)
DIM lQ!(60)
DIM lR!(60)
DIM lS!(60)
DIM lT!(60)
DIM lU!(60)
DIM lV!(60)
DIM lW!(60)
DIM lX!(60)
DIM lY!(60)
DIM lZ!(60)
DIM l1!(60)
DIM l2!(60)
DIM l3!(60)
DIM l4!(60)
DIM l5!(60)
DIM l6!(60)
DIM l7!(60)
DIM l8!(60)
DIM l9!(60)
DIM l0!(60)

'Hold the ship sprites
DIM ship1!(100)
DIM ship2!(100)

'Hold the missile sprites
DIM missileL!(100)
DIM missileR!(100)

'Hold the egg sprites
DIM eggL!(60)
DIM eggD!(60)
DIM eggR!(60)
DIM eggU!(60)

'Hold the dynamite sprites
DIM tnt1!(60)
DIM tnt2!(60)
DIM tnt3!(60)
DIM tnt4!(60)

'Hold the two symbols, an underline for the high score routine and a diamond
'for the intro screen
DIM underline!(20)
DIM diamond!(20)

'Hold the explosion sprites
DIM explode1!(60)
DIM explode2!(60)

'Hold the shooting star sprites
DIM star1!(60)
DIM star2!(60)
DIM star3!(60)

'Keep track of the location and colour of the stars
DIM starLocX%(300)
DIM starLocY%(300)
DIM starClr%(300)

DIM brk$(3)

ON ERROR GOTO errorTrap

breakOff

IF detectCard% THEN
  snd% = 0
 
  PRINT "AdLib-compatible sound card detected."
  PRINT " Initalizing...";
  SBInit
  PRINT " Done."
 
  setChannel 0, "snare"
  setChannel 1, "percuss"
  setChannel 2, "bass"
  setChannel 3, "eguitar"
  setChannel 4, "eguitar"
  setChannel 5, "eguitar"
  setChannel 6, "aguitar"
  setChannel 7, "landscp"
ELSE
  snd% = 2
  PRINT "Unable to find/detect sound card."
  PRINT "Sound effects disabled."
  PRINT "Press a key..."
  BEEP
  SLEEP
END IF

speed! = compSpeed!                             'Get the speed of the computer
IF speed! > 1 THEN
  tempTime! = 20 + 5 * (speed! - 1)             'Temporarily adjust the time
ELSE                                            'allowed per level up or down
  tempTime! = 20 - 5 * (ABS(speed! - 1))        'depending on the speed of
  IF tempTime! < 15 THEN tempTime! = 15         'the computer
END IF

' This is a variation on the standard round off equation ((a + 5) \ 10) * 10.
' The game requires the time to be rounded off to the nearest 5 instead of the
' nearest 10 so the formula is adjusted accordingly.  If you're wondering why
' 2 is added to the tempTime! instead of 2.5, which generally produces a more
' accurate result, it is because QBasic's integer divide function is a bit
' strange as it rounds the numbers off instead of just taking off anything
' after the decimal.  In order to adjust for QBasic's little anomaly, the
' number must be decreased by .5.  This is done by adding 2 instead of 2.5 so
' that when integer divide rounds off the number it gives the desired result.
baseTime% = ((tempTime! + 2) \ 5) * 5

CLS

initGraphics

title

DO
  intro ply%
  IF ply% = 1 THEN
    playEggHunt
  ELSE
    viewRecording
  END IF
LOOP

errorTrap:

SELECT CASE ERR
       CASE 53
           OPEN "egghunt.hi" FOR OUTPUT AS #1           'If the high score
                                                        'file doesn't exist
           FOR i = 1 TO 5                               'create a new one
              hiName$(i) = "EGG HUNTER"                 'with some preset
              hiScore&(i) = 3000 - 500 * i               'high scores
              
              WRITE #1, hiName$(i)
              WRITE #1, hiScore&(i)
           NEXT i

           CLOSE #1

           RESUME
END SELECT

SUB breakOff

SHARED brk$()

' First save the current vectors:             
DEF SEG = 0
FOR i% = 108 TO 111
   brk$(i% - 108) = STR$(PEEK(i%))
NEXT i%

' Then poke new interrupt vectors:                
POKE 108, 83: POKE 109, 255: POKE 110, 0: POKE 111, 240: DEF SEG

END SUB

SUB breakOn

SHARED brk$()

DEF SEG = 0
FOR i% = 108 TO 111
   POKE i%, VAL(brk$(i% - 108))
NEXT i%

DEF SEG

END SUB

' Waits for a key press and then clears the keyboard register, useful for
' press any key to continue situation
SUB clearRegister

DO: a$ = INKEY$: LOOP UNTIL a$ <> ""
DO: a$ = INKEY$: LOOP UNTIL a$ = ""

END SUB

' Function to see if a second has passed
FUNCTION clock% (oldTime&)

newTime& = INT(TIMER)

IF newTime& > oldTime& THEN
  clock% = 1
ELSE
  clock% = 0
END IF

oldTime& = newTime&

END FUNCTION

' Convert the colours so they can be used with the palette set by the BMP
' viewer.
SUB clrConvert (clr%)

SELECT CASE clr%
       CASE 1
           clr% = 12
       CASE 3
           clr% = 14
       CASE 4
           clr% = 9
       CASE 6
           clr% = 1
       CASE 9
           clr% = 6
       CASE 11
           clr% = 7
       CASE 12
           clr% = 9
       CASE 14
           clr% = 11
END SELECT
         
END SUB

' This function calculates how long it takes the computer to execute a timing
' loop.  That number will then be used to adjust for computer speed in the
' game.
FUNCTION compSpeed!

' Although the game does all its timing using the computer's timer and not
' timing loops, some things still have to be adjusted for the computer's
' speed.  The time that the player is given to finish each level must be
' adjusted according to the speed of the computer because the game will
' take longer to execute the code on a slower computer thus making the game
' play slower.  In order to give everyone a fair chance no matter what kind
' of computer they own the length of time allowed for each level must be
' increased for slow computers and decreased for fast computers.

PRINT "Adjusting for computer speed..."

startTime! = TIMER
FOR t% = 1 TO 20000: NEXT t%
endTime! = TIMER

totTime! = endTime! - startTime!

IF totTime! = 0 THEN totTime! = .05

compSpeed! = totTime!

END FUNCTION

' Causes a delay of any number of seconds (or fractions of seconds), this is
' better than a timing loop because it uses the computer's internal clock to
' calculate the delay thus eliminating the problem of varying computer speeds
SUB delay (secs!)

curTime! = TIMER
finalTime! = curTime! + secs!
DO
  curTime! = TIMER
LOOP UNTIL curTime! > finalTime!

END SUB

FUNCTION detectCard%

WriteReg &H4, &H60
WriteReg &H4, &H80
B = INP(&H388)
WriteReg &H2, &HFF
WriteReg &H4, &H21

FOR x% = 0 TO 130
   a = INP(&H388)
NEXT x%

C = INP(&H388)
WriteReg &H4, &H60
WriteReg &H4, &H80
Success% = 0
IF (B AND &HE0) = &H0 THEN
  IF (C AND &HE0) = &HC0 THEN
    Success% = -1
  END IF
END IF
detectCard% = Success%

END FUNCTION

' This checks to see if a data file exists or not, if the file doesn't exist
' the game can't get some required data so it shuts down.
SUB fileCheck (fileName$)

IF LOF(1) < 1 THEN
  CLOSE #1
  KILL fileName$

  CLS
  PRINT "Program terminated due to missing data file "; fileName$; "."
  PRINT "If you have this file in a different directory please move it to"
  PRINT "your QBasic directory and try again."

  SLEEP
  SYSTEM
END IF

END SUB

' Displays the letters and numbers where the program wants to put them
SUB font (x%, y%, text$)

SHARED lA!(), lB!(), lC!(), lD!(), lE!(), lF!(), lG!(), lH!(), lI!(), lJ!(), lK!(), lL!(), lM!(), lN!(), lO!(), lP!(), lQ!(), lR!(), lS!(), lT!(), lU!(), lV!(), lW!(), lX!(), lY!(), lZ!(), l1!(), l2!(), l3!(), l4!(), l5!(), l6!(), l7!(), l8!(), l9!(), l0!()

FOR i% = 1 TO LEN(text$)
   char$ = MID$(text$, i%, 1)
   SELECT CASE char$
          CASE "A"
              PUT (x% + 20 * (i% - 1), y%), lA!, PSET
          CASE "B"
              PUT (x% + 20 * (i% - 1), y%), lB!, PSET
          CASE "C"
              PUT (x% + 20 * (i% - 1), y%), lC!, PSET
          CASE "D"
              PUT (x% + 20 * (i% - 1), y%), lD!, PSET
          CASE "E"
              PUT (x% + 20 * (i% - 1), y%), lE!, PSET
          CASE "F"
              PUT (x% + 20 * (i% - 1), y%), lF!, PSET
          CASE "G"
              PUT (x% + 20 * (i% - 1), y%), lG!, PSET
          CASE "H"
              PUT (x% + 20 * (i% - 1), y%), lH!, PSET
          CASE "I"
              PUT (x% + 20 * (i% - 1), y%), lI!, PSET
          CASE "J"
              PUT (x% + 20 * (i% - 1), y%), lJ!, PSET
          CASE "K"
              PUT (x% + 20 * (i% - 1), y%), lK!, PSET
          CASE "L"
              PUT (x% + 20 * (i% - 1), y%), lL!, PSET
          CASE "M"
              PUT (x% + 20 * (i% - 1), y%), lM!, PSET
          CASE "N"
              PUT (x% + 20 * (i% - 1), y%), lN!, PSET
          CASE "O"
              PUT (x% + 20 * (i% - 1), y%), lO!, PSET
          CASE "P"
              PUT (x% + 20 * (i% - 1), y%), lP!, PSET
          CASE "Q"
              PUT (x% + 20 * (i% - 1), y%), lQ!, PSET
          CASE "R"
              PUT (x% + 20 * (i% - 1), y%), lR!, PSET
          CASE "S"
              PUT (x% + 20 * (i% - 1), y%), lS!, PSET
          CASE "T"
              PUT (x% + 20 * (i% - 1), y%), lT!, PSET
          CASE "U"
              PUT (x% + 20 * (i% - 1), y%), lU!, PSET
          CASE "V"
              PUT (x% + 20 * (i% - 1), y%), lV!, PSET
          CASE "W"
              PUT (x% + 20 * (i% - 1), y%), lW!, PSET
          CASE "X"
              PUT (x% + 20 * (i% - 1), y%), lX!, PSET
          CASE "Y"
              PUT (x% + 20 * (i% - 1), y%), lY!, PSET
          CASE "Z"
              PUT (x% + 20 * (i% - 1), y%), lZ!, PSET
          CASE "1"
              PUT (x% + 20 * (i% - 1), y%), l1!, PSET
          CASE "2"
              PUT (x% + 20 * (i% - 1), y%), l2!, PSET
          CASE "3"
              PUT (x% + 20 * (i% - 1), y%), l3!, PSET
          CASE "4"
              PUT (x% + 20 * (i% - 1), y%), l4!, PSET
          CASE "5"
              PUT (x% + 20 * (i% - 1), y%), l5!, PSET
          CASE "6"
              PUT (x% + 20 * (i% - 1), y%), l6!, PSET
          CASE "7"
              PUT (x% + 20 * (i% - 1), y%), l7!, PSET
          CASE "8"
              PUT (x% + 20 * (i% - 1), y%), l8!, PSET
          CASE "9"
              PUT (x% + 20 * (i% - 1), y%), l9!, PSET
          CASE "0"
              PUT (x% + 20 * (i% - 1), y%), l0!, PSET
   END SELECT
NEXT i%

END SUB

' Displays the game over screen
SUB gameOver

SCREEN 9, 0, 1, 1
CLS

SCREEN 9, 0, 0, 0
CLS

font 200, 150, "GAME OVER"

delay 1.5

CLS

END SUB

' This function gets a name from the user that will be used to label the
' recording file which they have just started.
FUNCTION getLabel$

SHARED underline!()

FOR i% = 1 TO 21
   DO
     a$ = INKEY$
   LOOP UNTIL a$ <> ""

   a$ = UCASE$(a$)
   chr% = ASC(a$)

   IF chr% = 32 OR (chr% >= 48 AND chr% <= 57) OR (chr% >= 65 AND chr% <= 90) THEN
     IF i% < 16 THEN
       font 10 + 20 * (i% - 1), 40, a$
       label$ = label$ + a$
     END IF
   ELSEIF chr% = 8 THEN
     IF i% > 1 THEN
       LINE (10 + 20 * (i% - 2), 40)-(30 + 20 * (i% - 2), 60), 0, BF
       PUT (15 + 20 * (i% - 2), 50), underline!, PSET
       label$ = LEFT$(label$, i% - 2)
       i% = i% - 2
     ELSE
       i% = i% - 1
     END IF
   ELSEIF chr% = 13 THEN
     EXIT FOR
   ELSEIF chr% = 27 THEN
     label$ = ""
     EXIT FOR
   ELSE
     i% = i% - 1
   END IF
NEXT i%

IF LEN(label$) > 0 THEN                                 'Make it 20 characters
  addOn% = 20 - LEN(label$)                             'long even if it is
                                                        'shorter
  FOR i% = 1 TO addOn%
     label$ = label$ + " "
  NEXT i%
END IF

getLabel$ = label$

END FUNCTION

' Searches the directory for EGGREC[number].RC[number] files, displays them
' and makes it possible for the user to select a file from a scrolling list
' of their labels (chosen upon the recording by the user) for viewing or for
' deleting.
SUB getRecordFile (fileName$, errorCode%)

errorCode% = 0

u$ = CHR$(0) + CHR$(72)
d$ = CHR$(0) + CHR$(80)
cr$ = CHR$(13)
esc$ = CHR$(27)
del$ = CHR$(0) + CHR$(83)

SCREEN 9, 0, 1, 1
CLS
SCREEN 9, 0, 0, 0
CLS

font 10, 10, "SEARCHING FOR RECORDING FILES"

eggFiles$ = ""
FOR i% = 0 TO 9                                         'Search the directory
   FOR j% = 0 TO 99                                     'for recording files.
      num1$ = LTRIM$(RTRIM$(STR$(i%)))
      ext$ = ".rc" + num1$
      num2$ = LTRIM$(RTRIM$(STR$(j%)))
      fileName$ = "eggrec" + num2$ + ext$

      OPEN fileName$ FOR APPEND AS #1
     
      IF LOF(1) < 1 THEN
        CLOSE #1
        KILL fileName$
      ELSE
        CLOSE #1

        OPEN fileName$ FOR BINARY AS #1

        id$ = INPUT$(7, #1)

        IF id$ = "EGGREC1" THEN                         'If a valid recording
          file$ = INPUT$(20, #1)                        'file is found its
          eggFiles$ = eggFiles$ + file$                 'label is kept on
        END IF                                          'record.

        CLOSE #1
      END IF
   NEXT j%
NEXT i%

CLS

scrnFlip% = 1
SCREEN 9, 0, 1, 0
location% = 1
y% = 8
yLoc% = 1

IF LEN(fileName$) > 0 THEN
  DO
    font 10, 255, "ENTER    VIEW RECORDING"
    font 10, 285, "DELETE   DELETE RECORDING"
    font 10, 315, "ESCAPE   RETURN TO MAIN MENU"

    LINE (5, 5)-(435, 245), 15, B
    LINE (8, y%)-(432, y% + 24), 15, B

    FOR i% = 1 TO 8
       pntr% = ((20 * (location% - 1)) + 20 * (i% - 1)) + 1
    
       IF LEN(eggFiles$) >= pntr% + 19 THEN
         fileName$ = MID$(eggFiles$, pntr%, 20)
       ELSE
         EXIT FOR
       END IF
                                                        'Display the files
       font 10, 10 + 30 * (i% - 1), fileName$            'that have been found
    NEXT i%

    IF scrnFlip% = 1 THEN
      SCREEN 9, 0, 0, 1
      scrnFlip% = 2
    ELSE
      SCREEN 9, 0, 1, 0
      scrnFlip% = 1
    END IF

    CLS

    DO
      a$ = INKEY$
    LOOP UNTIL a$ <> ""

    SELECT CASE a$
           CASE u$                                      'If the user wants to
               yLoc% = yLoc% - 1                          'scroll up, adjust
               y% = y% - 30                               'for it.
               IF yLoc% = 0 THEN
                 yLoc% = 1
                 y% = 8
                 location% = location% - 1
                 IF location% = 0 THEN location% = 1
               END IF
           CASE d$                                      'Same for scroll down
               yLoc% = yLoc% + 1
               y% = y% + 30
               IF yLoc% = 9 THEN
                 yLoc% = 8
                 y% = y% - 30
                 location% = location% + 1
                 IF location% = (LEN(eggFiles$) / 20) + 1 THEN
                   location% = LEN(eggFiles$) / 20
                 END IF
               END IF
           CASE cr$
               pntr% = ((20 * (location% - 1)) + 20 * (yLoc% - 1)) + 1
               name$ = MID$(eggFiles$, pntr%, 20)        'Open the recording
               EXIT DO                                  'on ENTER
           CASE del$
               pntr% = ((20 * (location% - 1)) + 20 * (yLoc% - 1)) + 1
               name$ = MID$(eggFiles$, pntr%, 20)        'Delete the recording
               FOR i% = 0 TO 9                           'on DEL
                  FOR j% = 0 TO 99
                     num1$ = LTRIM$(RTRIM$(STR$(i%)))    'Find the file that
                     ext$ = ".rc" + num1$               'is to be deleted
                     num2$ = LTRIM$(RTRIM$(STR$(j%)))
                     fileName$ = "eggrec" + num2$ + ext$

                     OPEN fileName$ FOR APPEND AS #1
   
                     IF LOF(1) < 1 THEN
                       CLOSE #1
                       KILL fileName$
                     ELSE
                       CLOSE #1

                       OPEN fileName$ FOR BINARY AS #1

                       id$ = INPUT$(7, #1)
     
                       IF id$ = "EGGREC1" THEN          'When the requested
                         file$ = INPUT$(20, #1)         'file is found it is
                         IF file$ = name$ THEN          'deleted
                           CLOSE #1
                           KILL fileName$
                           getOut% = 1
                           EXIT FOR
                         ELSE
                           CLOSE #1
                         END IF
                       ELSE
                         CLOSE #1
                       END IF
                     END IF
                  NEXT j%

                  IF getOut% = 1 THEN
                    getOut% = 0
                    EXIT FOR
                  END IF
               NEXT i%

               MID$(eggFiles$, pntr%, 20) = "                    "
           CASE esc$                                    'Quit without loading
               errorCode% = 1                            'on ESC
               EXIT SUB
    END SELECT

    DO: a$ = INKEY$: LOOP UNTIL a$ = ""
  LOOP
ELSE
  errorCode% = 1
END IF

SCREEN 9, 0, 1, 1
CLS
SCREEN 9, 0, 0, 0
CLS

font 10, 10, "FINDING FILE"

FOR i% = 0 TO 9                                          'If the user wants
   FOR j% = 0 TO 99                                      'to load a recording
      num1$ = LTRIM$(RTRIM$(STR$(i%)))                   'look for the
      ext$ = ".rc" + num1$                              'requested file.
      num2$ = LTRIM$(RTRIM$(STR$(j%)))
      fileName$ = "eggrec" + num2$ + ext$

      OPEN fileName$ FOR APPEND AS #1
    
      IF LOF(1) < 1 THEN
        CLOSE #1
        KILL fileName$
      ELSE
        CLOSE #1

        OPEN fileName$ FOR BINARY AS #1

        id$ = INPUT$(7, #1)
       
        IF id$ = "EGGREC1" THEN                         'When the file is
          file$ = INPUT$(20, #1)                        'found we return that
          IF file$ = name$ THEN                         'name to the viewer
            CLOSE #1                                    'and that file is
            EXIT SUB                                    'viewed.
          END IF
        END IF

        CLOSE #1
      END IF
   NEXT j%
NEXT i%

CLS

END SUB

' The high score routine
SUB highScore (score&)

SHARED underline!()

DIM hiScore&(5)
DIM hiName$(5)

DO: a$ = INKEY$: LOOP UNTIL a$ = ""

name$ = ""

'Get the old high scores from the high score file
OPEN "egghunt.hi" FOR INPUT AS #1

FOR i% = 1 TO 5
   INPUT #1, hiName$(i%)
   INPUT #1, hiScore&(i%)
NEXT i%

CLOSE #1

'If the player beat any of the high scores, give them a high score
IF score& > hiScore&(5) THEN
  font 30, 100, "YOU HAVE A NEW HIGH SCORE"

  font 60, 150, "PLEASE ENTER YOUR NAME"

  FOR i% = 1 TO 15
     PUT (135 + 20 * (i% - 1), 210), underline!, PSET
  NEXT i%

  'Get the player's name
  FOR i% = 1 TO 16
     DO
       a$ = INKEY$
     LOOP UNTIL a$ <> ""

     a$ = UCASE$(a$)
     chr% = ASC(a$)

     IF chr% = 32 OR (chr% >= 48 AND chr% <= 57) OR (chr% >= 65 AND chr% <= 90) THEN
       IF i% < 16 THEN
         font 130 + 20 * (i% - 1), 200, a$
         name$ = name$ + a$
       END IF
     ELSEIF chr% = 8 THEN
       IF i% > 1 THEN
         LINE (130 + 20 * (i% - 2), 200)-(150 + 20 * (i% - 2), 220), 0, BF
         PUT (135 + 20 * (i% - 2), 210), underline!, PSET
         name$ = LEFT$(name$, i% - 2)
         i% = i% - 2
       ELSE
         i% = i% - 1
       END IF
     ELSEIF chr% = 13 THEN
       EXIT FOR
     ELSE
       i% = i% - 1
     END IF
  NEXT i%

  'Make the player's score replace the low score on the high score list
  hiName$(5) = name$
  hiScore&(5) = score&

  'Sort the high score list
  FOR i% = 1 TO 4
     FOR j% = i% + 1 TO 5
        IF hiScore&(j%) > hiScore&(i%) THEN
          SWAP hiScore&(j%), hiScore&(i%)
          SWAP hiName$(j%), hiName$(i%)
        END IF
     NEXT j%
  NEXT i%

  'Write the new high score list to the high score file
  OPEN "egghunt.hi" FOR OUTPUT AS #1

  FOR i% = 1 TO 5
     WRITE #1, hiName$(i%)
     WRITE #1, hiScore&(i%)
  NEXT i%

  CLOSE #1
END IF
     
CLS

'Display the high scores
font 170, 20, "HIGH SCORES"

FOR i% = 1 TO 5
   hiScore$ = LTRIM$(RTRIM$(STR$(hiScore&(i%))))
  
   font 50, 70 + 30 * (i% - 1), hiName$(i%)
   font 400, 70 + 30 * (i% - 1), hiScore$
NEXT i%

font 170, 310, "PRESS A KEY"

clearRegister

END SUB

' Loads all the sprite data from the DAT files and stores it in the sprite
' arrays.
SUB initGraphics

SHARED lA!(), lB!(), lC!(), lD!(), lE!(), lF!(), lG!(), lH!(), lI!(), lJ!(), lK!(), lL!(), lM!(), lN!(), lO!(), lP!(), lQ!(), lR!(), lS!(), lT!(), lU!(), lV!(), lW!(), lX!(), lY!(), lZ!(), l1!(), l2!(), l3!(), l4!(), l5!(), l6!(), l7!(), l8!(), l9!(), l0!(), ship1!(), ship2!(), missileL!(), missileR!(), eggL!(), eggD!(), eggR!(), eggU!(), tnt1!(), tnt2!(), tnt3!(), tnt4!(), underline!(), diamond!(), explode1!(), explode2!(), star1!(), star2!(), star3!()

DIM clr(0) AS STRING * 1
DIM holder!(2257)

'The percentage display is just for show.
pct$ = "0%"

LOCATE 10, 25: PRINT "Loading graphics...please wait."
LINE (214, 150)-(415, 165), 15, B
LOCATE 13, 38: PRINT pct$

OPEN "alphabet.dat" FOR APPEND AS #1
fileCheck "alphabet.dat"
CLOSE #1

'Open the ALPHABET.DAT file to get the data for the letters and numbers
DEF SEG = VARSEG(holder!(0))
BLOAD "alphabet.dat", 0

ctr% = 0
FOR i% = 0 TO 60                                 'A
   lA!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "2%"
LOCATE 13, 38: PRINT pct$
LINE (215, 151)-(218, 164), 15, BF

FOR i% = 0 TO 60                                 'B
   lB!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "4%"
LOCATE 13, 38: PRINT pct$
LINE (219, 151)-(222, 164), 15, BF

FOR i% = 0 TO 60                                 'C
   lC!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "6%"
LOCATE 13, 38: PRINT pct$
LINE (223, 151)-(226, 164), 15, BF
                   
FOR i% = 0 TO 60                                 'D
   lD!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "8%"
LOCATE 13, 38: PRINT pct$
LINE (227, 151)-(230, 164), 15, BF

FOR i% = 0 TO 60                                 'E
   lE!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "10%"
LOCATE 13, 38: PRINT pct$
LINE (231, 151)-(234, 164), 15, BF

FOR i% = 0 TO 60                                 'F
   lF!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "12%"
LOCATE 13, 38: PRINT pct$
LINE (235, 151)-(238, 164), 15, BF

FOR i% = 0 TO 60                                 'G
   lG!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "14%"
LOCATE 13, 38: PRINT pct$
LINE (239, 151)-(242, 164), 15, BF

FOR i% = 0 TO 60                                 'H
   lH!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "16%"
LOCATE 13, 38: PRINT pct$
LINE (243, 151)-(246, 164), 15, BF

FOR i% = 0 TO 60                                 'I
   lI!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "18%"
LOCATE 13, 38: PRINT pct$
LINE (247, 151)-(250, 164), 15, BF

FOR i% = 0 TO 60                                 'J
   lJ!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "20%"
LOCATE 13, 38: PRINT pct$
LINE (251, 151)-(254, 164), 15, BF

FOR i% = 0 TO 60                                 'K
   lK!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "22%"
LOCATE 13, 38: PRINT pct$
LINE (255, 151)-(258, 164), 15, BF

FOR i% = 0 TO 60                                 'L
   lL!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "24%"
LOCATE 13, 38: PRINT pct$
LINE (259, 151)-(262, 164), 15, BF

FOR i% = 0 TO 60                                 'M
   lM!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "26%"
LOCATE 13, 38: PRINT pct$
LINE (263, 151)-(266, 164), 15, BF

FOR i% = 0 TO 60                                 'N
   lN!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "28%"
LOCATE 13, 38: PRINT pct$
LINE (267, 151)-(270, 164), 15, BF

FOR i% = 0 TO 60                                 'O
   lO!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "30%"
LOCATE 13, 38: PRINT pct$
LINE (271, 151)-(274, 164), 15, BF

FOR i% = 0 TO 60                                 'P
   lP!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "32%"
LOCATE 13, 38: PRINT pct$
LINE (275, 151)-(278, 164), 15, BF

FOR i% = 0 TO 60                                 'Q
   lQ!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "34%"
LOCATE 13, 38: PRINT pct$
LINE (279, 151)-(282, 164), 15, BF

FOR i% = 0 TO 60                                 'R
   lR!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "36%"
LOCATE 13, 38: PRINT pct$
LINE (283, 151)-(286, 164), 15, BF

FOR i% = 0 TO 60                                 'S
   lS!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "38%"
LOCATE 13, 38: PRINT pct$
LINE (287, 151)-(290, 164), 15, BF

FOR i% = 0 TO 60                                 'T
   lT!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "40%"
LOCATE 13, 38: PRINT pct$
LINE (291, 151)-(294, 164), 15, BF

FOR i% = 0 TO 60                                 'U
   lU!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "42%"
LOCATE 13, 38: PRINT pct$
LINE (295, 151)-(298, 164), 15, BF

FOR i% = 0 TO 60                                 'V
   lV!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "44%"
LOCATE 13, 38: PRINT pct$
LINE (299, 151)-(302, 164), 15, BF

FOR i% = 0 TO 60                                 'W
   lW!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "46%"
LOCATE 13, 38: PRINT pct$
LINE (303, 151)-(306, 164), 15, BF

FOR i% = 0 TO 60                                 'X
   lX!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "48%"
LOCATE 13, 38: PRINT pct$
LINE (307, 151)-(310, 164), 15, BF

FOR i% = 0 TO 60                                 'Y
   lY!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "50%"
LOCATE 13, 38: PRINT pct$
LINE (311, 151)-(314, 164), 15, BF

FOR i% = 0 TO 60                                 'Z
   lZ!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "52%"
LOCATE 13, 38: PRINT pct$
LINE (315, 151)-(318, 164), 15, BF

FOR i% = 0 TO 60                                 '1
   l1!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "54%"
LOCATE 13, 38: PRINT pct$
LINE (319, 151)-(322, 164), 15, BF

FOR i% = 0 TO 60                                 '2
   l2!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "56%"
LOCATE 13, 38: PRINT pct$
LINE (323, 151)-(326, 164), 15, BF

FOR i% = 0 TO 60                                 '3
   l3!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "58%"
LOCATE 13, 38: PRINT pct$
LINE (327, 151)-(330, 164), 15, BF

FOR i% = 0 TO 60                                 '4
   l4!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "60%"
LOCATE 13, 38: PRINT pct$
LINE (331, 151)-(334, 164), 15, BF

FOR i% = 0 TO 60                                 '5
   l5!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "62%"
LOCATE 13, 38: PRINT pct$
LINE (335, 151)-(338, 164), 15, BF

FOR i% = 0 TO 60                                 '6
   l6!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "64%"
LOCATE 13, 38: PRINT pct$
LINE (339, 151)-(342, 164), 15, BF

FOR i% = 0 TO 60                                 '7
   l7!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "66%"
LOCATE 13, 38: PRINT pct$
LINE (343, 151)-(346, 164), 15, BF

FOR i% = 0 TO 60                                 '8
   l8!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "68%"
LOCATE 13, 38: PRINT pct$
LINE (347, 151)-(350, 164), 15, BF

FOR i% = 0 TO 60                                 '9
   l9!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "70%"
LOCATE 13, 38: PRINT pct$
LINE (351, 151)-(354, 164), 15, BF

FOR i% = 0 TO 60                                 '0
   l0!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "72%"
LOCATE 13, 38: PRINT pct$
LINE (355, 151)-(358, 164), 15, BF

OPEN "eggraph1.dat" FOR APPEND AS #1
fileCheck "eggraph1.dat"
CLOSE #1

'All the graphics data is stored in the next four files
DEF SEG = VARSEG(holder!(0))
BLOAD "eggraph1.dat", 0

ctr% = 0
FOR i% = 0 TO 100                                 '1st of two ship sprites
   ship1!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "74%"
LOCATE 13, 38: PRINT pct$
LINE (359, 151)-(362, 164), 15, BF

FOR i% = 0 TO 100                                 '2nd of two ship sprites
   ship2!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "76%"
LOCATE 13, 38: PRINT pct$
LINE (363, 151)-(366, 164), 15, BF

FOR i% = 0 TO 100                                 'missile coming from the left
   missileL!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "78%"
LOCATE 13, 38: PRINT pct$
LINE (367, 151)-(370, 164), 15, BF

FOR i% = 0 TO 100                                 'missile coming from the right
   missileR!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "80%"
LOCATE 13, 38: PRINT pct$
LINE (371, 151)-(374, 164), 15, BF

OPEN "eggraph2.dat" FOR APPEND AS #1
fileCheck "eggraph2.dat"
CLOSE #1

DEF SEG = VARSEG(holder!(0))
BLOAD "eggraph2.dat", 0

ctr% = 0
FOR i% = 0 TO 60                                 'egg facing left
   eggL!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "82%"
LOCATE 13, 38: PRINT pct$
LINE (375, 151)-(378, 164), 15, BF

FOR i% = 0 TO 60                                 'egg facing down
   eggD!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "84%"
LOCATE 13, 38: PRINT pct$
LINE (379, 151)-(382, 164), 15, BF

FOR i% = 0 TO 60                                 'egg facing right
   eggR!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "86%"
LOCATE 13, 38: PRINT pct$
LINE (383, 151)-(386, 164), 15, BF

FOR i% = 0 TO 60                                 'egg facing up
   eggU!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "88%"
LOCATE 13, 38: PRINT pct$
LINE (387, 151)-(390, 164), 15, BF

FOR i% = 0 TO 60                                 '1st stage of dynamite
   tnt1!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "90%"
LOCATE 13, 38: PRINT pct$
LINE (391, 151)-(394, 164), 15, BF

FOR i% = 0 TO 60                                 '2nd stage of dynamite
   tnt2!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "91%"
LOCATE 13, 38: PRINT pct$
LINE (395, 151)-(396, 164), 15, BF

FOR i% = 0 TO 60                                 '3rd stage of dynamite
   tnt3!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "92%"
LOCATE 13, 38: PRINT pct$
LINE (397, 151)-(398, 164), 15, BF

FOR i% = 0 TO 60                                 'Final stage of dynamite
   tnt4!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "93%"
LOCATE 13, 38: PRINT pct$
LINE (399, 151)-(400, 164), 15, BF

OPEN "symbol.dat" FOR APPEND AS #1
fileCheck "symbol.dat"
CLOSE #1

DEF SEG = VARSEG(holder!(0))
BLOAD "symbol.dat", 0

ctr% = 0
FOR i% = 0 TO 20                                 'underline for high scores
   underline!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "94%"
LOCATE 13, 38: PRINT pct$
LINE (401, 151)-(402, 164), 15, BF

FOR i% = 0 TO 20                                 'diamond for intro screen
   diamond!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "95%"
LOCATE 13, 38: PRINT pct$
LINE (403, 151)-(404, 164), 15, BF

OPEN "eggexpl.dat" FOR APPEND AS #1
fileCheck "eggexpl.dat"
CLOSE #1

DEF SEG = VARSEG(holder!(0))
BLOAD "eggexpl.dat", 0

ctr% = 0
FOR i% = 0 TO 60                                 '1st and last explosion sprite
   explode1!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "96%"
LOCATE 13, 38: PRINT pct$
LINE (405, 151)-(406, 164), 15, BF

FOR i% = 0 TO 60                                 '2nd explosion sprite
   explode2!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "97%"
LOCATE 13, 38: PRINT pct$
LINE (407, 151)-(408, 164), 15, BF

OPEN "eggraph3.dat" FOR APPEND AS #1
fileCheck "eggraph3.dat"
CLOSE #1

DEF SEG = VARSEG(holder!(0))
BLOAD "eggraph3.dat", 0

ctr% = 0
FOR i% = 0 TO 60                                 '1st star sprite
   star1!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "98%"
LOCATE 13, 38: PRINT pct$
LINE (409, 151)-(410, 164), 15, BF

FOR i% = 0 TO 60                                 '2nd and last star sprite
   star2!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "99%"
LOCATE 13, 38: PRINT pct$
LINE (411, 151)-(412, 164), 15, BF

FOR i% = 0 TO 60                                 '3rd star sprite
   star3!(i%) = holder!(ctr%)
   ctr% = ctr% + 1
NEXT i%

pct$ = "100%"
LOCATE 13, 38: PRINT pct$
LINE (413, 151)-(414, 164), 15, BF

CLS

ERASE holder!

END SUB

' Displays the instructions
SUB instructions

SHARED baseTime%

baseTime$ = LTRIM$(RTRIM$(STR$(baseTime%)))

SCREEN 9, 0, 1, 1

CLS

font 50, 20, "YOUR PLANET HAS RUN OUT"
font 220, 50, "OF FOOD"
font 30, 80, "YOUR SCIENTISTS ARE TRYING"
font 30, 110, "TO GROW MORE FOOD BUT THEY"
font 60, 140, "NEED LIVE EGGS TO DO SO"
font 40, 170, "IN A RECENT EXPEDITION TO"
font 20, 200, "EXPLORE OTHER SOLAR SYSTEMS"
font 10, 230, "YOU HAVE DISCOVERED A PLANET"
font 150, 260, "RICH WITH FOOD"

font 180, 310, "PRESS A KEY"

clearRegister
CLS

font 30, 20, "THIS PLANET IS CALLED EARTH"
font 60, 50, "IT IS UP TO YOU TO GO TO"
font 30, 80, "EARTH TO FIND EGGS FOR YOUR"
font 200, 110, "SCIENTISTS"
font 50, 140, "BUT THE EARTHLINGS ARENT"
font 60, 170, "GOING TO STAND AROUND AND"
font 80, 200, "LET YOU TAKE THEIR FOOD"
font 10, 230, "THEY ARE GOING TO FIGHT BACK"

font 180, 310, "PRESS A KEY"

clearRegister
CLS

font 40, 20, "GUIDE YOUR UFO THROUGH THE"
font 90, 50, "SKY IN SEARCH OF EGGS"
font 50, 80, "BUT WATCH OUT FOR ATTACKS"
font 30, 110, "THE US MILITARY WILL TRY TO"
font 20, 140, "SHOOT YOU DOWN WITH MISSILES"
font 130, 170, "AND WITH DYNAMITE"
font 90, 200, "WATCH OUT FOR FALLING"
font 210, 230, "STARS TOO"

font 180, 310, "PRESS A KEY"

clearRegister
CLS

font 10, 20, "USE THE ARROW KEYS TO CONTROL"
font 220, 50, "YOUR UFO"
font 30, 80, "COLLECT EGGS BY FLYING INTO"
font 40, 110, "THEM BUT DONT FLY INTO THE"
font 30, 140, "MISSILES OR THE DEBRIS FROM"
font 110, 170, "THE DYNAMITE BLASTS"
font 10, 200, "ALT Q QUITS THE CURRENT GAME"
font 80, 230, "ALT P PAUSES THE GAME"
font 20, 260, "TO RESUME PLAY PRESS ANY KEY"

font 180, 310, "PRESS A KEY"

clearRegister
CLS

font 230, 20, "SCORING"
font 40, 50, "EACH EGG SCORES 100 POINTS"
font 20, 80, "10 POINT TIME BONUS FOR EACH"
font 10, 110, "SECOND UNDER THE ALLOTED TIME"
font 40, 140, "BUT IF YOU RUN OUT OF TIME"
font 20, 170, "YOU WILL DROP 1 EGG EVERY": font 540, 170, baseTime$
font 20, 200, "SECONDS UNTIL YOU FINISH THE"
font 250, 230, "LEVEL"
font 20, 260, "EXTRA LIFE EVERY 1000 POINTS"

font 180, 310, "PRESS A KEY"

clearRegister
CLS

font 90, 20, "OTHER GAME FUNCTIONS"
font 40, 50, "ALT X TURNS SOUND ON OR OFF"
font 30, 80, "ALT R TURNS RECORD ON OR OFF"
font 60, 110, "ALT S TAKES A SCREEN SHOT"
font 40, 140, "SEE README FILE FOR DETAILS"
font 70, 170, "ON USING THESE FUNCTIONS"

font 180, 310, "PRESS A KEY"

clearRegister
CLS

SCREEN 9, 0, 0, 0

END SUB

' Displays the screen that lets you choose between playing, viewing the
' instructions and exiting.
SUB intro (ply%)

SHARED diamond!(), brk$()

'Up arrow, down arrow, and enter keys
u$ = CHR$(0) + CHR$(72)
d$ = CHR$(0) + CHR$(80)
cr$ = CHR$(13)

diamondPlace% = 1

SCREEN 9, 0, 0, 0
CLS

font 200, 75, "BEGIN GAME"
font 160, 125, "VIEW RECORDING"
font 180, 175, "INSTRUCTIONS"
font 260, 225, "EXIT"

PUT (130, 80), diamond!, PSET

y = 80

DO
  DO
    a$ = INKEY$
  LOOP UNTIL a$ <> ""

  SELECT CASE a$
         CASE u$
             diamondPlace% = diamondPlace% - 1
             IF diamondPlace% = 0 THEN diamondPlace% = 4
         CASE d$
             diamondPlace% = diamondPlace% + 1
             IF diamondPlace% = 5 THEN diamondPlace% = 1
         CASE cr$
             IF diamondPlace% = 1 THEN
               CLS
               ply% = 1
               EXIT DO
             ELSEIF diamondPlace% = 2 THEN
               CLS
               ply% = 2
               EXIT DO
             ELSEIF diamondPlace% = 3 THEN
               instructions
             ELSEIF diamondPlace% = 4 THEN
               breakOn
               CLS
               SYSTEM
             END IF
  END SELECT

  PUT (130, y%), diamond!, XOR
  
  y% = 30 + 50 * diamondPlace%

  PUT (130, y%), diamond!, PSET
LOOP
     
END SUB

' Displays the intro screen to each level
SUB levelIntro (level%, eggs%)

SHARED lL!(), lE!(), lV!(), l1!(), l2!(), l3!(), l4!(), l5!(), l6!(), l7!(), l8!(), l9!(), l0!(), lC!(), lO!(), lT!(), lG!(), lS!()

SCREEN 9, 0, 1, 0

CLS

PAINT (1, 1), 15, 15

PUT (250, 150), lL!, PRESET
PUT (270, 150), lE!, PRESET
PUT (290, 150), lV!, PRESET
PUT (310, 150), lE!, PRESET
PUT (330, 150), lL!, PRESET

PUT (170, 180), lC!, PRESET
PUT (190, 180), lO!, PRESET
PUT (210, 180), lL!, PRESET
PUT (230, 180), lL!, PRESET
PUT (250, 180), lE!, PRESET
PUT (270, 180), lC!, PRESET
PUT (290, 180), lT!, PRESET

PUT (370, 180), lE!, PRESET
PUT (390, 180), lG!, PRESET
PUT (410, 180), lG!, PRESET
PUT (430, 180), lS!, PRESET

SELECT CASE level%
       CASE 1
           PUT (360, 150), l1!, PRESET
           PUT (330, 180), l2!, PRESET
       CASE 2
           PUT (360, 150), l2!, PRESET
           PUT (330, 180), l4!, PRESET
       CASE 3
           PUT (360, 150), l3!, PRESET
           PUT (330, 180), l6!, PRESET
       CASE 4
           PUT (360, 150), l4!, PRESET
           PUT (330, 180), l8!, PRESET
       CASE 5
           PUT (360, 150), l5!, PRESET
           PUT (320, 180), l1!, PRESET
           PUT (340, 180), l0!, PRESET
       CASE 6
           PUT (360, 150), l6!, PRESET
           PUT (320, 180), l1!, PRESET
           PUT (340, 180), l2!, PRESET
       CASE 7
           PUT (360, 150), l7!, PRESET
           PUT (320, 180), l1!, PRESET
           PUT (340, 180), l4!, PRESET
       CASE 8
           PUT (360, 150), l8!, PRESET
           PUT (320, 180), l1!, PRESET
           PUT (340, 180), l6!, PRESET
       CASE 9
           PUT (360, 150), l9!, PRESET
           PUT (320, 180), l1!, PRESET
           PUT (340, 180), l8!, PRESET
       CASE 10
           PUT (360, 150), l1!, PRESET
           PUT (380, 150), l0!, PRESET
           PUT (320, 180), l2!, PRESET
           PUT (340, 180), l0!, PRESET
       CASE 11
           PUT (360, 150), l1!, PRESET
           PUT (380, 150), l1!, PRESET
           PUT (320, 180), l2!, PRESET
           PUT (340, 180), l2!, PRESET
       CASE 12
           PUT (360, 150), l1!, PRESET
           PUT (380, 150), l2!, PRESET
           PUT (320, 180), l2!, PRESET
           PUT (340, 180), l4!, PRESET
       CASE 13
           PUT (360, 150), l1!, PRESET
           PUT (380, 150), l3!, PRESET
           PUT (320, 180), l2!, PRESET
           PUT (340, 180), l6!, PRESET
       CASE 14
           PUT (360, 150), l1!, PRESET
           PUT (380, 150), l4!, PRESET
           PUT (320, 180), l2!, PRESET
           PUT (340, 180), l8!, PRESET
       CASE 15
           PUT (360, 150), l1!, PRESET
           PUT (380, 150), l5!, PRESET
           PUT (320, 180), l3!, PRESET
           PUT (340, 180), l0!, PRESET
       CASE 16
           PUT (360, 150), l1!, PRESET
           PUT (380, 150), l6!, PRESET
           PUT (320, 180), l3!, PRESET
           PUT (340, 180), l2!, PRESET
       CASE 17
           PUT (360, 150), l1!, PRESET
           PUT (380, 150), l7!, PRESET
           PUT (320, 180), l3!, PRESET
           PUT (340, 180), l4!, PRESET
       CASE 18
           PUT (360, 150), l1!, PRESET
           PUT (380, 150), l8!, PRESET
           PUT (320, 180), l3!, PRESET
           PUT (340, 180), l6!, PRESET
       CASE 19
           PUT (360, 150), l1!, PRESET
           PUT (380, 150), l9!, PRESET
           PUT (320, 180), l3!, PRESET
           PUT (340, 180), l8!, PRESET
       CASE 20
           PUT (360, 150), l2!, PRESET
           PUT (380, 150), l0!, PRESET
           PUT (320, 180), l4!, PRESET
           PUT (340, 180), l0!, PRESET
END SELECT

SCREEN 9, 0, 0, 1

delay 1.5

END SUB

' Displays the screen at the conclusion of each level
SUB levelOutro (bonusPts%)

SHARED lL!(), lE!(), lV!(), lC!(), lA!(), lR!(), lD!(), lT!(), lI!(), lM!(), lB!(), lO!(), lN!(), lU!(), lS!(), l1!(), l2!(), l3!(), l4!(), l5!(), l6!(), l7!(), l8!(), l9!(), l0!(), snd%

SCREEN 9, 0, 1, 0

CLS

PAINT (1, 1), 15, 15

PUT (180, 150), lL!, PRESET
PUT (200, 150), lE!, PRESET
PUT (220, 150), lV!, PRESET
PUT (240, 150), lE!, PRESET
PUT (260, 150), lL!, PRESET
PUT (300, 150), lC!, PRESET
PUT (320, 150), lL!, PRESET
PUT (340, 150), lE!, PRESET
PUT (360, 150), lA!, PRESET
PUT (380, 150), lR!, PRESET
PUT (400, 150), lE!, PRESET
PUT (420, 150), lD!, PRESET

PUT (180, 180), lT!, PRESET
PUT (200, 180), lI!, PRESET
PUT (220, 180), lM!, PRESET
PUT (240, 180), lE!, PRESET
PUT (280, 180), lB!, PRESET
PUT (300, 180), lO!, PRESET
PUT (320, 180), lN!, PRESET
PUT (340, 180), lU!, PRESET
PUT (360, 180), lS!, PRESET

bonus$ = LTRIM$(RTRIM$(STR$(bonusPts%)))

FOR i = 1 TO LEN(bonus$)
   char$ = MID$(bonus$, i, 1)
   SELECT CASE char$
          CASE "1"
              PUT (400 + 20 * (i - 1), 180), l1!, PRESET
          CASE "2"
              PUT (400 + 20 * (i - 1), 180), l2!, PRESET
          CASE "3"
              PUT (400 + 20 * (i - 1), 180), l3!, PRESET
          CASE "4"
              PUT (400 + 20 * (i - 1), 180), l4!, PRESET
          CASE "5"
              PUT (400 + 20 * (i - 1), 180), l5!, PRESET
          CASE "6"
              PUT (400 + 20 * (i - 1), 180), l6!, PRESET
          CASE "7"
              PUT (400 + 20 * (i - 1), 180), l7!, PRESET
          CASE "8"
              PUT (400 + 20 * (i - 1), 180), l8!, PRESET
          CASE "9"
              PUT (400 + 20 * (i - 1), 180), l9!, PRESET
          CASE "0"
              PUT (400 + 20 * (i - 1), 180), l0!, PRESET
   END SELECT
NEXT i

SCREEN 9, 0, 1, 1

IF snd% = 0 THEN
  WriteReg &HA0 + 8, &H0
  WriteReg &HB0 + 8, &H0

  SFXPlay 8, 255, 10
  delay .35

  SFXPlay 8, 0, 10
  delay .35

  SFXPlay 8, 100, 10
  delay .8

  WriteReg &HA0 + 8, &H0
  WriteReg &HB0 + 8, &H0
ELSE
  delay 1.5
END IF

CLS

END SUB

SUB musicPlayer (chan%)

SHARED speed!

DIM song$(chan%)
DIM octave%(chan%)
DIM repeat%(chan%)
DIM pntr%(chan%)
DIM vol%(chan%)

song$(0) = "V00O4{a a ....}R2{........a ..............a ......}R72........a ..............a a a a " '73
song$(1) = "V00O1{........}R2{e ....e ....e ......e ..........}R73" '73
song$(2) = "V08O1{........}R2{e.....e.g+...e.......e...g+.......}R72{ ...............}R2" '73
song$(3) = "V00{........}R2{................................}R4{O5f...............................d...............f.......d.......O4c ..............................................................}R4{................}R16{O5f...............................d...............f.......g.......O4c ..............................................................}R8{................}R26" '73
song$(4) = "V00{........}R2{................................}R4{O4c...............................c...............c.......c.......c ..............................................................}R4{................}R16{O4c...............................c...............c.......c.......c ..............................................................}R8{................}R26" '73
song$(5) = "V00{........}R2{................................}R4{O2a...............................O1g...............O2a.......O1g.......f ..............................................................}R16{................}R18" '73
song$(6) = "V04{........}R2{................................}R12{O4c.O5d.O4c.b.c.b...c...O5d.O4c.b.c.b.O5g.O6a.b.a.O5g.f+.g.f+...g...f+.e.d.e.d.O4c.b.}R4{O8c. ...c. ...c. ...c. ...c. .....................................}R4{O4c.O5d.O4c.b.c.b...c...O5d.O4c.b.c.O5d.g.O6a.b.a.O5g.f+.g.f+...g...O6a.b.c.b.a.O5g.f+.}R8{O7f...............................d...............O8a...............}R8O6c...............{................}R25" '73
song$(7) = "V00O4{........}R2{................................}R12{..................................................................b............................................................ }R8{................................}R16{................}R26" '73

getOut% = 0

DO
  delay 1

  FOR i% = 0 TO chan%
     repeat%(i%) = 0
     pntr%(i%) = 1
     vol%(i%) = 0
  NEXT i%

  endSong% = 0
  nextNote% = 0
  DO
    FOR i% = 0 TO chan%
       nextNote% = 0
   
       DO
         char$ = MID$(song$(i%), pntr%(i%), 1)

         SELECT CASE char$
                CASE "\"
                    DO
                      pntr%(i%) = pntr%(i%) + 1
                      char$ = MID$(song$(i%), pntr%(i%), 1)
                    LOOP UNTIL char$ = "\"
                CASE "V"
                    pntr%(i%) = pntr%(i%) + 1
                    volume$ = MID$(song$(i%), pntr%(i%), 2)
                    vol%(i%) = VAL(volume$)
                    pntr%(i%) = pntr%(i%) + 1
                CASE "O"
                    pntr%(i%) = pntr%(i%) + 1
                    octave$ = MID$(song$(i%), pntr%(i%), 1)
                    octave%(i%) = VAL(octave$)
                CASE "R"
                    pntr%(i%) = pntr%(i%) + 1
                    times$ = MID$(song$(i%), pntr%(i%), 1)
                    IF pntr%(i%) + 1 <= LEN(song$(i%)) THEN
                      pntr%(i%) = pntr%(i%) + 1
                      ascVal% = ASC(MID$(song$(i%), pntr%(i%), 1))
                      IF ascVal% >= 48 AND ascVal% <= 57 THEN
                        times$ = times$ + MID$(song$(i%), pntr%(i%), 1)
                      ELSE
                        pntr%(i%) = pntr%(i%) - 1
                      END IF
                    END IF

                    IF repeat%(i%) = 1 THEN
                      repeat%(i%) = 0
                    ELSE
                      IF repeat%(i%) = 0 THEN
                        repeat%(i%) = VAL(times$) - 1
                      ELSE
                        repeat%(i%) = repeat%(i%) - 1
                      END IF
                  
                      DO
                        pntr%(i%) = pntr%(i%) - 1
                        char$ = MID$(song$(i%), pntr%(i%), 1)
                      LOOP UNTIL char$ = "{"
                    END IF
                CASE " "
                    WriteReg &HA0 + i%, &H0
                    WriteReg &HB0 + i%, &H0
                    nextNote% = 1
                CASE "."
                    nextNote% = 1
                CASE "a"
                    IF MID$(song$(i%), pntr%(i%) + 1, 1) = "+" THEN
                      freq% = 2
                      pntr%(i%) = pntr%(i%) + 1
                    ELSE
                      freq% = 1
                    END IF
                    nextNote% = 1
                    WriteReg &HB0 + i%, &H0
                    SBPlay i%, freq%, octave%(i%), vol%(i%)
                CASE "b"
                    freq% = 4
                    nextNote% = 1
                    WriteReg &HB0 + i%, &H0
                    SBPlay i%, freq%, octave%(i%), vol%(i%)
                CASE "c"
                    IF MID$(song$(i%), pntr%(i%) + 1, 1) = "+" THEN
                      freq% = 7
                      pntr%(i%) = pntr%(i%) + 1
                    ELSE
                      freq% = 6
                    END IF
                    nextNote% = 1
                    WriteReg &HB0 + i%, &H0
                    SBPlay i%, freq%, octave%(i%), vol%(i%)
                CASE "d"
                    IF MID$(song$(i%), pntr%(i%) + 1, 1) = "+" THEN
                      freq% = 2
                      pntr%(i%) = pntr%(i%) + 1
                    ELSE
                      freq% = 1
                    END IF
                    nextNote% = 1
                    WriteReg &HB0 + i%, &H0
                    SBPlay i%, freq%, octave%(i%), vol%(i%)
                CASE "e"
                    freq% = 3
                    nextNote% = 1
                    WriteReg &HB0 + i%, &H0
                    SBPlay i%, freq%, octave%(i%), vol%(i%)
                CASE "f"
                    IF MID$(song$(i%), pntr%(i%) + 1, 1) = "+" THEN
                      freq% = 5
                      pntr%(i%) = pntr%(i%) + 1
                    ELSE
                      freq% = 4
                    END IF
                    nextNote% = 1
                    WriteReg &HB0 + i%, &H0
                    SBPlay i%, freq%, octave%(i%), vol%(i%)
                CASE "g"
                    IF MID$(song$(i%), pntr%(i%) + 1, 1) = "+" THEN
                      freq% = 7
                      pntr%(i%) = pntr%(i%) + 1
                    ELSE
                      freq% = 6
                    END IF
                    nextNote% = 1
                    WriteReg &HB0 + i%, &H0
                    SBPlay i%, freq%, octave%(i%), vol%(i%)
         END SELECT

         pntr%(i%) = pntr%(i%) + 1
         IF pntr%(i%) > LEN(song$(i%)) THEN endSong% = 1

         a$ = INKEY$
         IF a$ <> "" THEN
           endSong% = 1
           getOut% = 1
         END IF
       LOOP UNTIL nextNote% OR endSong%
       FOR t% = 1 TO speed! * 70175: NEXT t%
    NEXT i%
  LOOP UNTIL endSong%
LOOP UNTIL getOut% = 1

FOR i% = 0 TO chan%
   WriteReg &HA0 + i%, &H0
   WriteReg &HB0 + i%, &H0
NEXT i%
                   
END SUB

SUB newPut (x%, y%, sprite!())

DEF SEG = VARSEG(sprite!(0))

xLen% = PEEK(0)
yLen% = PEEK(2)

wBytes% = ((xLen% / 9 + .5) \ 1)
wSize% = wBytes% * yLen%

DIM wImage!(wSize%)
GET (x%, y%)-(x% + xLen% - 1, y% + yLen% - 1), wImage!

totBytes% = wBytes% * 4 * yLen%

FOR i% = 4 TO totBytes%
   DEF SEG = VARSEG(sprite!(0))
   byte1% = PEEK(i%)
   DEF SEG = VARSEG(wImage!(0))
   byte2% = PEEK(i%)
   
   newByte% = byte1% OR byte2%
   DEF SEG = VARSEG(wImage!(0))
   pntr% = VARPTR(wImage!(0))
   POKE pntr% + i%, newByte%
NEXT i%

PUT (x%, y%), wImage!, PSET

END SUB

' Ask the player if they want another game
SUB playAgain

SHARED brk$()

CLS

font 70, 150, "DO YOU WANT TO PLAY AGAIN"

DO: a$ = INKEY$: a$ = LCASE$(a$): LOOP UNTIL a$ = "y" OR a$ = "n"

IF a$ = "n" THEN                                'If they don't want to play
  SCREEN 9, 0, 0, 0                             'again, end the game
  CLS

  SCREEN 9, 0, 1, 1
  CLS

  breakOn
 
  SYSTEM
END IF

CLS

END SUB

' The main game play sub-routine
SUB playEggHunt

SHARED ship1!(), ship2!(), missileL!(), missileR!(), eggL!(), eggD!(), eggR!(), eggU!(), tnt1!(), tnt2!(), tnt3!(), tnt4!(), starLocX%(), starLocY%(), starClr%(), explode1!(), explode2!(), star1!(), star2!(), star3!(), underline!(), baseTime%, snd%

'Arrays to track the missiles
DIM missileType%(20)
DIM missileX%(20)
DIM missileY%(20)
DIM missileSpeed%(20)

'Track the dynamite
DIM tntState%(5)
DIM tntX%(5)
DIM tntY%(5)

'Track the debris from the dynamite explosions
DIM debrisState%(5)
DIM debrisDir%(5)
DIM debrisX%(5)
DIM debrisY%(5)

'Track the shooting stars
DIM starType%(10)
DIM starX%(10)
DIM starY%(10)

'Track the eggs
DIM eggState%(3)
DIM eggX%(3)
DIM eggY%(3)
DIM eggDir%(3)

'Sound effects arrays and values
DIM shipSnd%(12)
shipSnd%(1) = 0: shipSnd%(2) = 13: shipSnd%(3) = 143: shipSnd%(4) = 15
shipSnd%(5) = 241: shipSnd%(6) = 243: shipSnd%(7) = 0: shipSnd%(8) = 0
shipSnd%(9) = 0: shipSnd%(10) = 3: shipSnd%(11) = 0: shipSnd%(12) = 0
setFX 3, shipSnd%()

DIM missSnd%(12)
missSnd%(1) = 1: missSnd%(2) = 1: missSnd%(3) = 6: missSnd%(4) = 20
missSnd%(5) = 255: missSnd%(6) = 220: missSnd%(7) = 60: missSnd%(8) = 0
missSnd%(9) = 0: missSnd%(10) = 3: missSnd%(11) = 6: missSnd%(12) = 0
setFX 4, missSnd%()

DIM tntExplSnd%(12)
tntExplSnd%(1) = 1: tntExplSnd%(2) = 0: tntExplSnd%(3) = 138: tntExplSnd%(4) = 0
tntExplSnd%(5) = 75: tntExplSnd%(6) = 255: tntExplSnd%(7) = 5: tntExplSnd%(8) = 4
tntExplSnd%(9) = 0: tntExplSnd%(10) = 2: tntExplSnd%(11) = 0: tntExplSnd%(12) = 0
setFX 2, tntExplSnd%()
setFX 6, tntExplSnd%()

DIM clockSnd%(12)
clockSnd%(1) = 10: clockSnd%(2) = 5: clockSnd%(3) = 143: clockSnd%(4) = 0
clockSnd%(5) = 241: clockSnd%(6) = 243: clockSnd%(7) = 7: clockSnd%(8) = 9
clockSnd%(9) = 0: clockSnd%(10) = 3: clockSnd%(11) = 6: clockSnd%(12) = 0
setFX 0, clockSnd%()

DIM tntSnd%(12)
tntSnd%(1) = 16: tntSnd%(2) = 0: tntSnd%(3) = 14: tntSnd%(4) = 15
tntSnd%(5) = 255: tntSnd%(6) = 16: tntSnd%(7) = 4: tntSnd%(8) = 5
tntSnd%(9) = 0: tntSnd%(10) = 0: tntSnd%(11) = 15: tntSnd%(12) = 255
setFX 1, tntSnd%()

DIM starSnd%(12)
starSnd%(1) = 255: starSnd%(2) = 255: starSnd%(3) = 20: starSnd%(4) = 20
starSnd%(5) = 241: starSnd%(6) = 241: starSnd%(7) = 0: starSnd%(8) = 0
starSnd%(9) = 0: starSnd%(10) = 0: starSnd%(11) = 0: starSnd%(12) = 0
setFX 5, starSnd%()

DIM alarmSnd%(12)
alarmSnd%(1) = 8: alarmSnd%(2) = 13: alarmSnd%(3) = 10: alarmSnd%(4) = 0
alarmSnd%(5) = 241: alarmSnd%(6) = 243: alarmSnd%(7) = 0: alarmSnd%(8) = 0
alarmSnd%(9) = 0: alarmSnd%(10) = 1: alarmSnd%(11) = 0: alarmSnd%(12) = 0
setFX 7, alarmSnd%()

DIM levelClrSnd%(12)
levelClrSnd%(1) = 15: levelClrSnd%(2) = 15: levelClrSnd%(3) = 10: levelClrSnd%(4) = 0
levelClrSnd%(5) = 241: levelClrSnd%(6) = 243: levelClrSnd%(7) = 3: levelClrSnd%(8) = 3
levelClrSnd%(9) = 0: levelClrSnd%(10) = 1: levelClrSnd%(11) = 0: levelClrSnd%(12) = 9
setFX 8, levelClrSnd%()

level% = 1
score& = 0
lives% = 5
eggs% = 0
extras& = 1
altFlag = 0

noMissile$ = "ARMYCUTBACKS"                             'Cheat codes
noTnt$ = "LOUSYCHEMISTS"
noStar$ = "CALMSKIES"
noHeatSeek$ = "COOLSHIP"
noEverything$ = "ISUCK"
godMode$ = "CHARIOTOFAGOD"
missileOn% = 1
tntOn% = 1
starOn% = 1
heatSeekOn% = 1
everythingOn% = 1
deathOn% = 1
cheatString$ = ""

record% = 0

FOR level% = 1 TO 20
   SELECT CASE level%
          CASE 1
              maxMissile% = 5                            'Set the difficulty
              maxHeatSeek% = 0                           'settings for each
              maxTnt% = 0                                'level
              maxMissSpeed% = 10
              maxStar% = 0
              eggSpeed% = 5
          CASE 2
              maxMissile% = 5
              maxHeatSeek% = 0
              maxTnt% = 1
              maxMissSpeed% = 10
              maxStar% = 0
              eggSpeed% = 5
          CASE 3
              maxMissile% = 7
              maxHeatSeek% = 0
              maxTnt% = 1
              maxMissSpeed% = 10
              maxStar% = 0
              eggSpeed% = 6
          CASE 4
              maxMissile% = 7
              maxHeatSeek% = 0
              maxTnt% = 1
              maxMissSpeed% = 12
              maxStar% = 0
              eggSpeed% = 6
          CASE 5
              maxMissile% = 8
              maxHeatSeek% = 0
              maxTnt% = 2
              maxMissSpeed% = 12
              maxStar% = 0
              eggSpeed% = 6
          CASE 6
              maxMissile% = 8
              maxHeatSeek% = 0
              maxTnt% = 2
              maxMissSpeed% = 12
              maxStar% = 0
              eggSpeed% = 7
          CASE 7
              maxMissile% = 8
              maxHeatSeek% = 0
              maxTnt% = 2
              maxMissSpeed% = 12
              maxStar% = 2
              eggSpeed% = 7
          CASE 8
              maxMissile% = 10
              maxHeatSeek% = 1
              maxTnt% = 2
              maxMissSpeed% = 15
              maxStar% = 0
              eggSpeed% = 7
          CASE 9
              maxMissile% = 10
              maxHeatSeek% = 1
              maxTnt% = 3
              maxMissSpeed% = 15
              maxStar% = 0
              eggSpeed% = 8
          CASE 10
              maxMissile% = 12
              maxHeatSeek% = 1
              maxTnt% = 3
              maxMissSpeed% = 15
              maxStar% = 3
              eggSpeed% = 8
          CASE 11
              maxMissile% = 12
              maxHeatSeek% = 1
              maxTnt% = 3
              maxMissSpeed% = 15
              maxStar% = 0
              eggSpeed% = 8
          CASE 12
              maxMissile% = 13
              maxHeatSeek% = 2
              maxTnt% = 3
              maxMissSpeed% = 15
              maxStar% = 3
              eggSpeed% = 9
          CASE 13
              maxMissile% = 13
              maxHeatSeek% = 2
              maxTnt% = 3
              maxMissSpeed% = 18
              maxStar% = 3
              eggSpeed% = 9
          CASE 14
              maxMissile% = 15
              maxHeatSeek% = 2
              maxTnt% = 4
              maxMissSpeed% = 18
              maxStar% = 5
              eggSpeed% = 10
          CASE 15
              maxMissile% = 15
              maxHeatSeek% = 3
              maxTnt% = 4
              maxMissSpeed% = 18
              maxStar% = 5
              eggSpeed% = 10
          CASE 16
              maxMissile% = 17
              maxHeatSeek% = 3
              maxTnt% = 4
              maxMissSpeed% = 20
              maxStar% = 5
              eggSpeed% = 12
          CASE 17
              maxMissile% = 17
              maxHeatSeek% = 4
              maxTnt% = 4
              maxMissSpeed% = 20
              maxStar% = 8
              eggSpeed% = 12
          CASE 18
              maxMissile% = 18
              maxHeatSeek% = 4
              maxTnt% = 5
              maxMissSpeed% = 20
              maxStar% = 8
              eggSpeed% = 13
          CASE 19
              maxMissile% = 18
              maxHeatSeek% = 5
              maxTnt% = 5
              maxMissSpeed% = 22
              maxStar% = 8
              eggSpeed% = 13
          CASE 20
              maxMissile% = 20
              maxHeatSeek% = 5
              maxTnt% = 5
              maxMissSpeed% = 25
              maxStar% = 10
              eggSpeed% = 15
   END SELECT
  
   timeLeft% = baseTime% * level%
   maxEgg% = level% * 2
  
   messageStage% = 0
  
   levelIntro level%, maxEgg%
  
   'Reset all the game play variables

   totMissile% = 0
   totHeatSeek% = 0
   totTnt% = 0
   totStar% = 0
   totEgg% = 0

   FOR i% = 1 TO 20
      missileType%(i%) = 0
      missileX%(i%) = 0
      missileY%(i%) = 0
      missileSpeed%(i%) = 0
   NEXT i%

   FOR i% = 1 TO 5
      tntState%(i%) = 0
      tntX%(i%) = 0
      tntY%(i%) = 0
   NEXT i%

   FOR i% = 1 TO 5
      debrisState%(i%) = 0
      debrisDir%(i%) = 0
      debrisX%(i%) = 0
      debrisY%(i%) = 0
   NEXT i%

   FOR i% = 1 TO 10
      starType%(i%) = 0
      starX%(i%) = 0
      starY%(i%) = 0
   NEXT i%

   FOR i% = 1 TO 3
      eggState%(i%) = 0
      eggX%(i%) = 0
      eggY%(i%) = 0
      eggDir%(i%) = 0
   NEXT i%
  
   eggs% = 0
  
   shipType% = 1
   shipX% = 300
   shipY% = 195
        
   lMove% = 0
   rMove% = 0
   uMove% = 0
   dMove% = 0

   explodeState% = 0
   flashState% = 0
   flashStartTime& = 0

   oldTime& = INT(TIMER)                 'This gets the start time of the level
   justTicked% = 0

   bonus% = 1
   bonusPts% = 0

   scrnFlip% = 1

   plotStars 300
  
   DO: a$ = INKEY$: LOOP UNTIL a$ = ""

   SCREEN 9, 0, 0, 1
   
   DO
     CLS

     FOR j% = 1 TO 300                                   'Draw the stars
        PSET (starLocX%(j%), starLocY%(j%)), starClr%(j%)
     NEXT j%

     font 1, 1, "LEVEL"                                 'Draw the text at the
     level$ = LTRIM$(RTRIM$(STR$(level%)))               'top of the screen
     font 121, 1, level$

     font 1, 31, "LIVES"
     lives$ = LTRIM$(RTRIM$(STR$(lives%)))
     font 121, 31, lives$

     font 401, 1, "SCORE"
     score$ = LTRIM$(RTRIM$(STR$(score&)))
     font 521, 1, score$

     font 401, 31, "EGGS"
     eggs$ = LTRIM$(RTRIM$(STR$(eggs%)))
     font 521, 31, eggs$

     timeLeft$ = LTRIM$(RTRIM$(STR$(timeLeft%)))
     font 251, 16, timeLeft$

     IF totTnt% <> 0 THEN                                'Draw the dynamite if
       FOR i% = 1 TO maxTnt%                              'there is any in play
          IF tntState%(i%) <> 0 THEN
            SELECT CASE tntState%(i%)                     'Animate the dynamite
                   CASE 1 TO 2
                       newPut tntX%(i%), tntY%(i%), tnt1!()
                   CASE 3 TO 4
                       newPut tntX%(i%), tntY%(i%), tnt2!()
                   CASE 5 TO 6
                       newPut tntX%(i%), tntY%(i%), tnt3!()
                   CASE 7 TO 8
                       newPut tntX%(i%), tntY%(i%), tnt4!()
                   CASE 9
            END SELECT
         
            IF snd% = 0 THEN
              WriteReg &HA0 + 1, &H0
              WriteReg &HB0 + 1, &H0
              SFXPlay 1, 255, 20
            END IF
          END IF
       NEXT i%
     END IF

     IF totStar% <> 0 THEN                               'Draw the falling
       FOR i% = 1 TO maxStar%                             'stars if there are
          IF starType%(i%) <> 0 THEN                      'any.
            SELECT CASE starType%(i%)
                   CASE 1
                       PUT (starX%(i%), starY%(i%)), star1!, PSET
                   CASE 2
                       PUT (starX%(i%), starY%(i%)), star2!, PSET
                   CASE 3
                       PUT (starX%(i%), starY%(i%)), star3!, PSET
                   CASE 4
                       PUT (starX%(i%), starY%(i%)), star2!, PSET
            END SELECT

            IF snd% = 0 THEN
              vol% = 40 - totStar%
              SFXPlay 5, 0, vol%
            END IF
          END IF
       NEXT i%
     END IF

     IF totMissile% <> 0 THEN                            'Draw the missiles if
       FOR i% = 1 TO maxMissile%                          'there are any in play
          IF missileType%(i%) <> 0 THEN
            IF missileType%(i%) = 1 OR missileType%(i%) = 3 THEN
              PUT (missileX%(i%), missileY%(i%)), missileL!, PSET
            ELSE
              PUT (missileX%(i%), missileY%(i%)), missileR!, PSET
            END IF

            IF snd% = 0 THEN
              vol% = 20 - totMissile%
              SFXPlay 4, 0, vol%
            END IF
          END IF
       NEXT i%
     END IF

     IF totEgg% <> 0 THEN
       FOR i% = 1 TO 3
          IF eggState%(i%) <> 0 THEN                      'Draw the egg if it is
            SELECT CASE eggState%(i%)                     'in play
                   CASE 1
                       PUT (eggX%(i%), eggY%(i%)), eggL!, PSET 'Get the animated
                   CASE 2                                  'rolling action by
                       PUT (eggX%(i%), eggY%(i%)), eggD!, PSET 'drawing a
                   CASE 3                                  'particular sprite
                       PUT (eggX%(i%), eggY%(i%)), eggR!, PSET
                   CASE 4
                       PUT (eggX%(i%), eggY%(i%)), eggU!, PSET
            END SELECT
          END IF
       NEXT i%
     END IF
    
     FOR i% = 1 TO maxTnt%                                'Draw the debris if
        IF debrisState%(i%) <> 0 THEN                     'there is any
          debX1% = debrisX%(i%) - 7 * debrisState%(i%)
          debX2% = debrisX%(i%) - 4 * debrisState%(i%)
          debX3% = debrisX%(i%) + 4 * debrisState%(i%)
          debX4% = debrisX%(i%) + 7 * debrisState%(i%)
          debY1% = debrisY%(i%) - 7 * debrisState%(i%)
          debY2% = debrisY%(i%) - 4 * debrisState%(i%)
          debY3% = debrisY%(i%) + 4 * debrisState%(i%)
          debY4% = debrisY%(i%) + 7 * debrisState%(i%)

          IF debX1% > 9 THEN PSET (debX1%, debrisY%(i%)), 14
          IF debX2% > 9 AND debY2% > 69 THEN PSET (debX2%, debY2%), 14
          IF debY1% > 69 THEN PSET (debrisX%(i%), debY1%), 14
          IF debX3% < 631 AND debY2% > 69 THEN PSET (debX3%, debY2%), 14
          IF debX4% < 631 THEN PSET (debX4%, debrisY%(i%)), 14
          IF debX3% < 631 AND debY3% < 341 THEN PSET (debX3%, debY3%), 14
          IF debY4% < 341 THEN PSET (debrisX%(i%), debY4%), 14
          IF debX2% > 9 AND debY3% < 341 THEN PSET (debX2%, debY3%), 14
        END IF
     NEXT i%

     IF explodeState% = 0 THEN                           'If the ship isn't
       IF scrnFlip% = 1 THEN                             'exploding, draw it
         IF flashState% <= 2 THEN                        'Animate the ship
           PUT (shipX%, shipY%), ship1!, PSET            'with the two ship
         END IF                                          'sprites
       ELSEIF scrnFlip% = 2 THEN
         IF flashState% <= 2 THEN PUT (shipX%, shipY%), ship2!, PSET
       END IF

       IF flashState% THEN
         flashState% = flashState% + 1
         IF flashState% = 4 THEN flashState% = 1
       END IF
      
       IF TIMER > (flashStartTime& + 3) THEN
         flashState% = 0
         deathOn% = 1
       END IF

       IF snd% = 0 THEN
         IF lMove% > 0 THEN
           freq% = 10 * lMove%
         ELSE
           freq% = 10 * rMove%
         END IF

         IF uMove% > 0 THEN
           freq% = freq% + (10 * uMove%)
         ELSE
           freq% = freq% + (10 * dMove%)
         END IF

         SFXPlay 3, freq%, 15
       END IF
     ELSE                                               'If the ship is
       IF explodeState% = 1 OR explodeState% = 3 THEN     'exploding, draw the
         PUT (shipX% + 10, shipY%), explode1!, PSET       'explosion
       ELSEIF explodeState% = 2 THEN                     'Animate the explosion
         PUT (shipX% + 10, shipY%), explode2!, PSET
       END IF
     END IF
    
     LINE (0, 60)-(639, 349), 8, B                      'Draw the border
     LINE (4, 64)-(635, 345), 7, B
     LINE (9, 69)-(631, 341), 15, B

     IF messageStage% <> 0 THEN                          'Print the message
       messageStage% = messageStage% + 1                  'if there is one.
       IF messageStage% = 10 THEN messageStage% = 0

       font messageX%, 315, message$
     END IF

     IF scrnFlip% = 1 THEN                               'Switch between two
       SCREEN 9, 0, 1, 0                                'video pages to allow
       scrnFlip% = 2                                     'smooth animation
     ELSEIF scrnFlip% = 2 THEN
       SCREEN 9, 0, 0, 1
       scrnFlip% = 1
     END IF

     CLS

     IF record% = 1 THEN
       frame% = frame% + 1
       
       recString$ = "F"
       add$ = LTRIM$(RTRIM$(STR$(frame%)))
       IF LEN(add$) = 1 THEN add$ = "0000" + add$
       IF LEN(add$) = 2 THEN add$ = "000" + add$
       IF LEN(add$) = 3 THEN add$ = "00" + add$
       IF LEN(add$) = 4 THEN add$ = "0" + add$
       recString$ = recString$ + add$

       PUT #1, , recString$

       recString$ = "T"
       add$ = LTRIM$(RTRIM$(STR$(timeLeft%)))
       IF LEN(add$) = 1 THEN add$ = "00" + add$
       IF LEN(add$) = 2 THEN add$ = "0" + add$
       recString$ = recString$ + add$

       PUT #1, , recString$
     END IF
    
     a$ = INKEY$
     char = INP(&H60)

     IF explodeState% = 0 THEN                           'allow ship motion
       SELECT CASE char                                  'if it isn't exploding
              CASE 72
                  IF dMove% = 0 THEN                     'adjust the motion
                    uMove% = uMove% + 1                   'factors according
                    IF uMove% > 10 THEN uMove% = 10       'to the key press
                  ELSE
                    dMove% = dMove% - 1
                  END IF
                  cheatString$ = ""
              CASE 80
                  IF uMove% = 0 THEN
                    dMove% = dMove% + 1
                    IF dMove% > 10 THEN dMove% = 10
                  ELSE
                    uMove% = uMove% - 1
                  END IF
                  cheatString$ = ""
              CASE 75
                  IF rMove% = 0 THEN
                    lMove% = lMove% + 1
                    IF lMove% > 10 THEN lMove% = 10
                  ELSE
                    rMove% = rMove% - 1
                  END IF
                  cheatString$ = ""
              CASE 77
                  IF lMove% = 0 THEN
                    rMove% = rMove% + 1
                    IF rMove% > 10 THEN rMove% = 10
                  ELSE
                    lMove% = lMove% - 1
                  END IF
                  cheatString$ = ""
              CASE 16                                   'quit the game on
                  IF altFlag THEN                       '<Alt> Q
                    SCREEN 9, 0, 0, 1
                    CLS

                    SCREEN 9, 0, 1, 0
                    CLS

                    cheatString$ = ""
                 
                    IF snd% = 0 THEN
                      FOR i% = 0 TO 8
                         WriteReg &HA0 + i%, &H0
                         WriteReg &HB0 + i%, &H0
                      NEXT i%
                    END IF
                    EXIT SUB
                  END IF
              CASE 25                                   'pause on <Alt> P
                  IF altFlag THEN
                    clearRegister
                    cheatString$ = ""
                  END IF
              CASE 19                                    'record on/off on
                  IF altFlag THEN                        '<Alt> R
                    IF record% = 0 THEN
                      record% = 1
                      noRoom% = 0

                      FOR i% = 0 TO 9                    'Look for an unused
                         FOR j% = 0 TO 99                'file name
                            num1$ = LTRIM$(RTRIM$(STR$(i%)))
                            ext$ = ".rc" + num1$
                            num2$ = LTRIM$(RTRIM$(STR$(j%)))
                            fileName$ = "eggrec" + num2$ + ext$

                            OPEN fileName$ FOR APPEND AS #1
                            IF LOF(1) < 1 THEN getOut% = 1
                            CLOSE #1

                            IF i = 9 AND j = 99 AND getOut% = 0 THEN
                              noRoom% = 1
                              getOut% = 1
                            END IF
                         
                            IF getOut% THEN EXIT FOR
                         NEXT j
                
                         IF getOut% = 1 THEN
                           getOut% = 0
                           EXIT FOR
                         END IF
                      NEXT i
                 
                      IF noRoom% THEN                    'If there are no
                        messageStage% = 1                'unused files say so
                        message$ = "NO ROOM FOR RECORDING"
                        messageX% = 70
                      ELSE
                        OPEN fileName$ FOR BINARY AS #1
                   
                        IF scrnFlip% = 2 THEN
                          SCREEN 9, 0, 1, 1
                        ELSE
                          SCREEN 9, 0, 0, 0
                        END IF

                        CLS
                        font 10, 10, "ENTER A NAME FOR THE RECORDING"
                        FOR i% = 1 TO 20
                           PUT (15 + 20 * (i% - 1), 50), underline!, PSET
                        NEXT i%

                        id$ = "EGGREC1"                 'Identify as recording
                        label$ = getLabel$
                        IF label$ = "" THEN             'If no label was given
                          CLOSE #1                      'it is assumed that
                          KILL fileName$                'the user doesn't want
                          record% = 0                    'to record after all
                        ELSE
                          frame$ = "F00001"             'Get all the initial
                          frame% = 1                     'values for the file
                   
                          PUT #1, , id$
                          PUT #1, , label$
                          PUT #1, , frame$
                    
                          recString$ = "L"
                          add$ = LTRIM$(RTRIM$(STR$(level%)))
                          IF LEN(add$) = 1 THEN add$ = "0" + add$
                          recString$ = recString$ + add$
                          PUT #1, , recString$
                   
                          recString$ = "I"
                          add$ = LTRIM$(RTRIM$(STR$(lives%)))
                          IF LEN(add$) = 1 THEN add$ = "0" + add$
                          recString$ = recString$ + add$
                          PUT #1, , recString$

                          recString$ = "C"
                          add$ = LTRIM$(RTRIM$(STR$(score&)))
                          IF LEN(add$) = 1 THEN add$ = "0000" + add$
                          IF LEN(add$) = 2 THEN add$ = "000" + add$
                          IF LEN(add$) = 3 THEN add$ = "00" + add$
                          IF LEN(add$) = 4 THEN add$ = "0" + add$
                          recString$ = recString$ + add$
                          PUT #1, , recString$

                          recString$ = "G"
                          add$ = LTRIM$(RTRIM$(STR$(eggs%)))
                          IF LEN(add$) = 1 THEN add$ = "0" + add$
                          recString$ = recString$ + add$
                          PUT #1, , recString$
           
                          recString$ = "T"
                          add$ = LTRIM$(RTRIM$(STR$(timeLeft%)))
                          IF LEN(add$) = 1 THEN add$ = "00" + add$
                          IF LEN(add$) = 2 THEN add$ = "0" + add$
                          recString$ = recString$ + add$
                          PUT #1, , recString$
                   
                          missileOn% = 1                 'Turn off all cheats
                          tntOn% = 1
                          starOn% = 1
                          heatSeekOn% = 1
                          everythingOn% = 1
                          deathOn% = 1

                          messageStage% = 1
                          message$ = "RECORD ON"
                          messageX% = 190
                        END IF
                   
                        IF scrnFlip% = 2 THEN
                          SCREEN 9, 0, 1, 0
                        ELSE
                          SCREEN 9, 0, 0, 1
                        END IF
                      END IF
                    ELSE
                      record% = 0                        'Turn off the
                                                         'recording
                      CLOSE #1

                      messageStage% = 1
                      message$ = "RECORD OFF"
                      messageX% = 180
                    END IF
                    cheatString$ = ""
                  END IF
              CASE 31                                    'Take a screen shot
                  IF altFlag THEN                        'on <Alt> S
                    IF scrnFlip% = 2 THEN
                      SCREEN 9, 0, 0, 0
                    ELSE
                      SCREEN 9, 0, 1, 1
                    END IF

                    screenShot errorCode%
                 
                    IF errorCode% THEN                   'If there isn't an
                      messageStage% = 1                  'available screen shot
                      message$ = "NO ROOM FOR SCREEN SHOT"
                      messageX% = 50                     'file then say so
                    END IF

                    cheatString$ = ""

                    IF scrnFlip% = 2 THEN
                      SCREEN 9, 0, 0, 1
                    ELSE
                      SCREEN 9, 0, 1, 0
                    END IF
                  END IF
              CASE 45
                  IF altFlag THEN
                    IF snd% = 0 THEN
                      FOR i% = 0 TO 7
                         WriteReg &HA0 + i%, &H0
                         WriteReg &HB0 + i%, &H0
                      NEXT i%
                      snd% = 1
                    ELSEIF snd% = 1 THEN
                      snd% = 0
                    END IF
                  END IF
              CASE 56
                  altFlag = 1
              CASE 184
                  altFlag = 0
       END SELECT

       ' Check to see if a cheat code has been entered.
       IF record% = 0 THEN
         IF a$ <> "" THEN
           letter% = ASC(a$)
           IF (letter% >= 65 AND letter% <= 90) OR (letter% >= 97 AND letter% <= 122) THEN
             a$ = UCASE$(a$)
             cheatString$ = cheatString$ + a$

             IF cheatString$ = noMissile$ THEN
               IF missileOn% = 1 THEN
                 missileOn% = 0
                 message$ = "NO MISSILE MODE ON"
                 messageX% = 100
               ELSE
                 missileOn% = 1
                 message$ = "NO MISSILE MODE OFF"
                 messageX% = 90
               END IF
               messageStage% = 1
            
               cheatString$ = ""
             ELSEIF cheatString$ = noTnt$ THEN
               IF tntOn% = 1 THEN
                 tntOn% = 0
                 message$ = "NO DYNAMITE MODE ON"
                 messageX% = 90
               ELSE
                 tntOn% = 1
                 message$ = "NO DYNAMITE MODE OFF"
                 messageX% = 80
               END IF
               messageStage% = 1
            
               cheatString$ = ""
             ELSEIF cheatString$ = noStar$ THEN
               IF starOn% = 1 THEN
                 starOn% = 0
                 message$ = "NO FALLING STAR MODE ON"
                 messageX% = 50
               ELSE
                 starOn% = 1
                 message$ = "NO FALLING STAR MODE OFF"
                 messageX% = 40
               END IF
               messageStage% = 1
                
               cheatString$ = ""
             ELSEIF cheatString$ = noHeatSeek$ THEN
               IF heatSeekOn% = 1 THEN
                 heatSeekOn% = 0
                 message$ = "NO HEAT SEEKERS MODE ON"
                 messageX% = 50
               ELSE
                 heatSeekOn% = 1
                 message$ = "NO HEAT SEEKERS MODE OFF"
                 messageX% = 40
               END IF
               messageStage% = 1
            
               cheatString$ = ""
             ELSEIF cheatString$ = noEverything$ THEN
               IF everythingOn% = 1 THEN
                 everythingOn% = 0
                 missileOn% = 0
                 tntOn% = 0
                 starOn% = 0
                 heatSeekOn% = 0
                 message$ = "NO ENEMY MODE ON"
                 messageX% = 120
               ELSE
                 everythingOn% = 1
                 missileOn% = 1
                 tntOn% = 1
                 starOn% = 1
                 heatSeekOn% = 1
                 message$ = "NO ENEMY MODE OFF"
                 messageX% = 110
               END IF
               messageStage% = 1
          
               cheatString$ = ""
             ELSEIF cheatString$ = godMode$ THEN
               IF deathOn% = 1 THEN
                 deathOn% = 0
                 message$ = "GOD MODE ON"
                 messageX% = 170
               ELSE
                 deathOn% = 1
                 message$ = "GOD MODE OFF"
                 messageX% = 160
               END IF
               messageStage% = 1

               cheatString$ = ""
             END IF
           END IF
         END IF
       END IF

       shipX% = shipX% + rMove% - lMove%                    'move the ship
       shipY% = shipY% + dMove% - uMove%
    
       IF shipX% < 10 THEN                               'make sure the ship
         shipX% = 10                                     'stays on the
         lMove% = 0                                      'playing field
       END IF
       IF shipX% > 590 THEN
         shipX% = 590
         rMove% = 0
       END IF
       IF shipY% < 70 THEN
         shipY% = 70
         uMove% = 0
       END IF
       IF shipY% > 320 THEN
         shipY% = 320
         dMove% = 0
       END IF
     ELSE                                               'if the ship is
       IF snd% = 0 THEN
         IF explodeState% = 1 THEN
           WriteReg &HA0 + 3, &H0
           WriteReg &HB0 + 3, &H0
           SFXPlay 6, 0, 0
         END IF
       END IF

       explodeState% = explodeState% + 1                  'exploding, blow it up
       IF explodeState% = 4 THEN
         explodeState% = 0                               'if the ship has
         uMove% = 0                                      'just finished
         rMove% = 0                                      'exploding, reset the
         lMove% = 0                                      'ship motion
         dMove% = 0                                      'variables and remove
         lives% = lives% - 1                             'one life
         flashState% = 1
         flashStartTime& = INT(TIMER)
         deathOn% = 0
         IF lives% < 0 THEN                              'if there are no lives
           DO: a$ = INKEY$: LOOP UNTIL a$ = ""           'left, end the game
           IF record% = 1 THEN CLOSE #1
           FOR i% = 0 TO 8
              WriteReg &HA0 + i%, &H0
              WriteReg &HB0 + i%, &H0
           NEXT i%
           gameOver
           highScore score&
           playAgain
           EXIT SUB
         END IF
         WriteReg &HA0 + 6, &H0
         WriteReg &HB0 + 6, &H0
       END IF
     END IF

     DO: a$ = INKEY$: LOOP UNTIL a$ = ""

     IF record% = 1 THEN
       recString$ = "U"
       add$ = LTRIM$(RTRIM$(STR$(shipX%)))
       IF LEN(add$) = 2 THEN add$ = "0" + add$
       recString$ = recString$ + add$
       add$ = LTRIM$(RTRIM$(STR$(shipY%)))
       IF LEN(add$) = 2 THEN add$ = "0" + add$
       recString$ = recString$ + add$

       PUT #1, , recString$
     END IF

     IF totMissile% <> 0 THEN                            'Calculate the motion
       FOR i% = 1 TO maxMissile%                          'of each missile
          IF missileType%(i%) <> 0 THEN                   'currently in play
            IF missileType%(i%) = 1 OR missileType%(i%) = 3 THEN
              missileX%(i%) = missileX%(i%) + missileSpeed%(i%)
              IF missileType%(i%) = 3 THEN
                distY% = shipY% - missileY%(i%)
                moveY% = distY% / 500 * missileSpeed%(i%)
                missileY%(i%) = missileY%(i%) + moveY%
              END IF

              IF missileX%(i%) >= 600 THEN
                IF missileType%(i%) = 3 THEN totHeatSeek% = totHeatSeek% - 1
                missileType%(i%) = 0                      'If the missile goes
                missileX%(i%) = 0                         'off the screen,
                missileY%(i%) = 0                         'remove it from play
                missileSpeed%(i%) = 0
                totMissile% = totMissile% - 1
                IF totMissile% = 0 THEN
                  WriteReg &HA0 + 4, &H0
                  WriteReg &HB0 + 4, &H0
                END IF
              END IF
            ELSE
              missileX%(i%) = missileX%(i%) - missileSpeed%(i%)
              IF missileType%(i%) = 4 THEN
                distY% = shipY% - missileY%(i%)
                moveY% = (distY% / 500) * missileSpeed%(i%)
                missileY%(i%) = missileY%(i%) + moveY%
              END IF
             
              IF missileX%(i%) <= 0 THEN
                IF missileType%(i%) = 4 THEN totHeatSeek% = totHeatSeek% - 1
                missileType%(i%) = 0
                missileX%(i%) = 0
                missileY%(i%) = 0
                missileSpeed%(i%) = 0
                totMissile% = totMissile% - 1
              END IF
            END IF

            IF deathOn% THEN
              IF missileX%(i%) >= shipX% - 35 AND missileX%(i%) <= shipX% + 35 THEN
                IF missileY%(i%) >= shipY% - 15 AND missileY%(i%) <= shipY% + 15 THEN
                  missileType%(i%) = 0
                  missileX%(i%) = 0                       'If the missile hits
                  missileY%(i%) = 0                       'the ship, set the
                  missileSpeed%(i%) = 0                   'explosion in motion
                  totMissile% = totMissile% - 1
                  explodeState% = 1
                END IF
              END IF
            END IF
          END IF
       NEXT i%
     END IF
    
     IF missileOn% THEN
       IF totMissile% < maxMissile% THEN                  'Randomly bring on
         newMissile% = INT(RND * 5)                      'new missiles
         IF newMissile% = 0 THEN
           FOR i% = 1 TO maxMissile%
              IF missileType%(i%) = 0 THEN
                newHeatSeek% = INT(RND * 5)
                IF totHeatSeek% < maxHeatSeek% AND heatSeekOn% THEN
                  IF newHeatSeek% = 0 THEN
                    missileType%(i%) = INT(RND * 2) + 3
                    totHeatSeek% = totHeatSeek% + 1
                  ELSE
                    missileType%(i%) = INT(RND * 2) + 1
                  END IF
                ELSE
                    missileType%(i%) = INT(RND * 2) + 1
                END IF

                missileY%(i%) = INT(RND * 250) + 70
                missileSpeed%(i%) = INT(RND * (maxMissSpeed% - 5)) + 5
                IF missileType%(i%) = 1 OR missileType%(i%) = 3 THEN
                  missileX%(i%) = 0
                ELSEIF missileType%(i%) = 2 OR missileType%(i%) = 4 THEN
                  missileX%(i%) = 599
                END IF
                totMissile% = totMissile% + 1
               
                IF record% = 1 THEN
                  recString$ = "M"
                  add$ = LTRIM$(RTRIM$(STR$(missileType%(i%))))
                  recString$ = recString$ + add$
                  add$ = LTRIM$(RTRIM$(STR$(missileY%(i%))))
                  IF LEN(add$) = 2 THEN add$ = "0" + add$
                  recString$ = recString$ + add$
                  add$ = LTRIM$(RTRIM$(STR$(missileSpeed%(i%))))
                  IF LEN(add$) = 1 THEN add$ = "0" + add$
                  recString$ = recString$ + add$

                  PUT #1, , recString$
                END IF

                EXIT FOR
              END IF
           NEXT i%
         END IF
       END IF
     END IF

     FOR i% = 1 TO maxTnt%                                'Calculate the debris
        IF debrisState%(i%) <> 0 THEN                     'motion
          debrisState%(i%) = debrisState%(i%) + 1
          IF debrisState%(i%) = 9 THEN                    'Remove the debris
            debrisState%(i%) = 0                          'if it's been around
            debrisX%(i%) = 0                              'long enough
            debrisY%(i%) = 0
          END IF

          IF debrisState%(i%) = 2 THEN
            WriteReg &HA0 + 2, &H0
            WriteReg &HB0 + 2, &H0
          END IF

          'Check to see if any debris hits the ship, if it does, start the
          'explosion.
          IF deathOn% THEN
            IF debrisX%(i%) - 7 * debrisState%(i%) >= shipX% AND debrisX%(i%) - 7 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) >= shipY% AND debrisY%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) - 4 * debrisState%(i%) >= shipX% AND debrisX%(i%) - 4 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) - 4 * debrisState%(i%) >= shipY% AND debrisY%(i%) - 4 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) >= shipX% AND debrisX%(i%) <= shipX% + 40 AND debrisY%(i%) - 7 * debrisState%(i%) >= shipY% AND debrisY%(i%) - 7 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) + 4 * debrisState%(i%) >= shipX% AND debrisX%(i%) + 4 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) - 4 * debrisState%(i%) >= shipY% AND debrisY%(i%) - 4 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) + 7 * debrisState%(i%) >= shipX% AND debrisX%(i%) + 7 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) >= shipY% AND debrisY%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) + 4 * debrisState%(i%) >= shipX% AND debrisX%(i%) + 4 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) + 4 * debrisState%(i%) >= shipY% AND debrisY%(i%) + 4 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) >= shipX% AND debrisX%(i%) <= shipX% + 40 AND debrisY%(i%) + 7 * debrisState%(i%) >= shipY% AND debrisY%(i%) + 7 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) - 4 * debrisState%(i%) >= shipX% AND debrisX%(i%) - 4 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) + 4 * debrisState%(i%) >= shipY% AND debrisY%(i%) + 4 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            END IF
          END IF
        END IF
     NEXT i%

     IF totTnt% <> 0 THEN                                'Calculate changes to
       FOR i% = 1 TO maxTnt%                              'dynamite
          IF tntState%(i%) <> 0 THEN
            tntState%(i%) = tntState%(i%) + 1
            IF tntState%(i%) = 10 THEN                    'If the dynamite blows
              FOR j% = 1 TO maxTnt%                       'up, send debris
                 IF debrisState%(j%) = 0 THEN             'flying everywhere
                   debrisState%(j%) = 1
                   debrisX%(j%) = tntX%(i%) + 10
                   debrisY%(j%) = tntY%(i%) + 10
                   EXIT FOR
                 END IF
              NEXT j%
             
              IF snd% = 0 THEN
                WriteReg &HA0 + 1, &H0
                WriteReg &HB0 + 1, &H0
                WriteReg &HA0 + 2, &H0
                WriteReg &HB0 + 2, &H0
                SFXPlay 2, 0, 0
              END IF

              tntState%(i%) = 0
              tntX%(i%) = 0
              tntY%(i%) = 0
              totTnt% = totTnt% - 1
            END IF
          END IF
       NEXT i%
     END IF

     IF tntOn% THEN
       IF totTnt% < maxTnt% THEN                            'Randomly create new
         newTnt% = INT(RND * 10)                           'dynamite
         IF newTnt% = 0 THEN
           FOR i% = 1 TO maxTnt%
              IF tntState%(i%) = 0 THEN
                tntState%(i%) = 1
                tntX%(i%) = INT(RND * 600) + 10
                tntY%(i%) = INT(RND * 250) + 70
                totTnt% = totTnt% + 1

                IF record% = 1 THEN
                  recString$ = "D"
                  add$ = LTRIM$(RTRIM$(STR$(tntX%(i%))))
                  IF LEN(add$) = 2 THEN add$ = "0" + add$
                  recString$ = recString$ + add$
                  add$ = LTRIM$(RTRIM$(STR$(tntY%(i%))))
                  IF LEN(add$) = 2 THEN add$ = "0" + add$
                  recString$ = recString$ + add$

                  PUT #1, , recString$
                END IF

                EXIT FOR
              END IF
           NEXT i%
         END IF
       END IF
     END IF

     IF totStar% <> 0 THEN                               'Calculate the motion
       FOR i% = 1 TO maxStar%                             'of each star
          IF starType%(i%) <> 0 THEN                      'currently in play
            starType%(i%) = starType%(i%) + 1               'Switch between stars
            IF starType%(i%) = 5 THEN starType%(i%) = 1     'for animation

            starY%(i%) = starY%(i%) + 5

            IF starY%(i%) >= 325 THEN
              starType%(i%) = 0                           'If the star goes
              starX%(i%) = 0                              'off the screen,
              starY%(i%) = 0                              'remove it from play
              totStar% = totStar% - 1
              IF totStar% = 0 THEN
                WriteReg &HA0 + 5, &H0
                WriteReg &HB0 + 5, &H0
              END IF
            END IF

            IF deathOn% THEN
              IF starX%(i%) >= shipX% - 15 AND starX%(i%) <= shipX% + 35 THEN
                IF starY%(i%) >= shipY% - 15 AND starY%(i%) <= shipY% + 15 THEN
                  starType%(i%) = 0
                  starX%(i%) = 0                          'If the star hits
                  starY%(i%) = 0                          'the ship, set the
                  totStar% = totStar% - 1                 'explosion in motion
                  explodeState% = 1
                END IF
              END IF
            END IF
          END IF
       NEXT i%
     END IF
   
     IF starOn% THEN
       IF totStar% < maxStar% THEN                        'Randomly bring on
         newStar% = INT(RND * 10)                        'new falling stars
         IF newStar% = 0 THEN
           FOR i% = 1 TO maxStar%
              IF starType%(i%) = 0 THEN
                starType%(i%) = INT(RND * 4) + 1
                starY%(i%) = 70
                starX%(i%) = INT(RND * 600) + 10
                totStar% = totStar% + 1

                IF record% = 1 THEN
                  recString$ = "S"
                  add$ = LTRIM$(RTRIM$(STR$(starType%(i%))))
                  recString$ = recString$ + add$
                  add$ = LTRIM$(RTRIM$(STR$(starX%(i%))))
                  IF LEN(add$) = 2 THEN add$ = "0" + add$
                  recString$ = recString$ + add$

                  PUT #1, , recString$
                END IF

                EXIT FOR
              END IF
           NEXT i%
         END IF
       END IF
     END IF

     IF totEgg% <> 0 THEN
       FOR i% = 1 TO 3
          IF eggState%(i%) <> 0 THEN                      'Calculate egg motion
            IF eggDir%(i%) = 1 THEN
              eggState%(i%) = eggState%(i) - 1             'Four egg states allow
              IF eggState%(i%) = 0 THEN eggState%(i%) = 4   'for rolling effect
              eggX%(i%) = eggX%(i%) + eggSpeed%
              IF eggX%(i%) >= 619 THEN
                eggState%(i%) = 0
                eggX%(i%) = 0
                eggY%(i%) = 0
                eggDir%(i%) = 0
                totEgg% = totEgg% - 1
              END IF
            ELSEIF eggDir%(i%) = 2 THEN
              eggState%(i%) = eggState%(i%) + 1
              IF eggState%(i%) = 5 THEN eggState%(i%) = 1
              eggX%(i%) = eggX%(i%) - eggSpeed%
              IF eggX%(i%) <= 0 THEN
                eggState%(i%) = 0
                eggX%(i%) = 0
                eggY%(i%) = 0
                eggDir%(i%) = 0
                totEgg% = totEgg% - 1
              END IF
            END IF

            IF eggX%(i%) >= shipX% - 15 AND eggX%(i%) <= shipX% + 35 THEN
              IF eggY%(i%) >= shipY% - 15 AND eggY%(i%) <= shipY% + 15 THEN
                eggs% = eggs% + 1
                score& = score& + 100                     'If the ship catches
                eggState%(i%) = 0                         'the egg, adjust
                eggX%(i%) = 0                             'variables accordingly
                eggY%(i%) = 0
                eggDir%(i%) = 0
                totEgg% = totEgg% - 1

                IF snd% = 0 THEN
                  WriteReg &HA0 + 8, &H0
                  WriteReg &HB0 + 8, &H0
                  SFXPlay 8, 100, 15
                END IF
                                                        'If enough eggs are
                IF eggs% = maxEgg THEN EXIT DO           'caught, end the level
              END IF
            END IF
          END IF
       NEXT i%
     END IF
    
     IF totEgg% < 3 THEN
       newEgg% = INT(RND * 25)
       IF newEgg% = 0 THEN
      
         FOR i% = 1 TO 3
            IF eggState%(i%) = 0 THEN                     'Randomly generate
              eggState%(i%) = INT(RND * 4) + 1            'new eggs if there
              eggY%(i%) = INT(RND * 250) + 70             'aren't enough on the
              eggDir%(i%) = INT(RND * 2) + 1              'screen
              IF eggDir%(i%) = 1 THEN eggX%(i%) = 0
              IF eggDir%(i%) = 2 THEN eggX%(i%) = 619
              
              totEgg% = totEgg% + 1

              IF record% = 1 THEN
                recString$ = "E"
                add$ = LTRIM$(RTRIM$(STR$(eggState%(i%))))
                recString$ = recString$ + add$
                add$ = LTRIM$(RTRIM$(STR$(eggY%(i%))))
                IF LEN(add$) = 2 THEN add$ = "0" + add$
                recString$ = recString$ + add$
                add$ = LTRIM$(RTRIM$(STR$(eggDir%(i%))))
                recString$ = recString$ + add$
                add$ = LTRIM$(RTRIM$(STR$(eggSpeed%)))
                IF LEN(add$) = 1 THEN add$ = "0" + add$
                recString$ = recString$ + add$

                PUT #1, , recString$
              END IF

              EXIT FOR
            END IF
         NEXT i%
       END IF
     END IF

     changeTime% = clock%(oldTime&)

     IF snd% = 0 THEN
       IF justTicked% = 1 THEN
         justTicked% = 0
         WriteReg &HA0, &H0
         WriteReg &HB0, &H0
       ELSEIF justTicked% = 2 THEN
         justTicked% = 0
         WriteReg &HA0 + 7, &H0
         WriteReg &HB0 + 7, &H0
       ELSEIF justTicked% > 2 THEN
         justTicked% = justTicked% - 1
       END IF

       IF changeTime% THEN
         SFXPlay 0, 0, 10
         justTicked% = 1
       END IF
     END IF

     timeLeft% = timeLeft% - changeTime%                  'adjust the timer
     IF timeLeft% = -1 THEN                              'If there is no time
       timeLeft% = baseTime%                              'left, reset the clock
       IF bonus% = 0 THEN                                'to the base time,
         eggs% = eggs% - 1                                'drop an egg if time
         IF eggs% < 0 THEN eggs% = 0                      'has run out before
       END IF
       IF snd% = 0 THEN
         WriteReg &HA0 + 7, &H0
         WriteReg &HB0 + 7, &H0
         SFXPlay 7, 255, 0
         justTicked% = 8
       END IF
       bonus% = 0                                        'remove any chance of
     END IF                                             'a time bonus

     IF score& >= 1000 * extras& THEN                     'if an extra ship is
       lives% = lives% + 1                                'due, give it
       extras& = extras& + 1
     END IF
   LOOP
  
   IF snd% = 0 THEN
     FOR i% = 0 TO 8
        WriteReg &HA0 + i%, &H0
        WriteReg &HB0 + i%, &H0
     NEXT i%
   END IF
  
   IF bonus% = 1 THEN                                    'if a time bonus is
     bonusPts% = timeLeft% * 10                           'due, give it
     score& = score& + bonusPts%
   END IF

   SCREEN 9, 0, 1, 0
   CLS
  
   SCREEN 9, 0, 0, 1
   CLS

   levelOutro bonusPts%

   IF record% = 1 THEN
     recString$ = "L"
     add$ = LTRIM$(RTRIM$(STR$(level% + 1)))
     IF LEN(add$) = 1 THEN add$ = "0" + add$
     recString$ = recString$ + add$

     PUT #1, , recString$
   END IF
NEXT level%

IF record% = 1 THEN CLOSE #1
score& = score& + 100 * lives%
winGame
highScore score&
playAgain

END SUB

' Determines the location and colour of the background stars
SUB plotStars (numStars%)

SHARED starLocX%(), starLocY%(), starClr%()

FOR i% = 1 TO numStars%
   starLocX%(i%) = INT(RND * 620) + 10
   starLocY%(i%) = INT(RND * 270) + 70
   num% = INT(RND * 3)
   IF num% = 0 THEN
     starClr%(i%) = 8
   ELSEIF num% = 1 THEN
     starClr%(i%) = 7
   ELSE
     starClr%(i%) = 15
   END IF
NEXT i%

END SUB

SUB SBInit

FOR q% = 1 TO &HF5
   WriteReg q%, 0
NEXT q%

END SUB

SUB SBPlay (chan%, freq%, octave%, vol%)

SELECT CASE freq%
       CASE 1
           freq% = &H2
       CASE 2
           freq% = &H23
       CASE 3
           freq% = &H43
       CASE 4
           freq% = &H6B
       CASE 5
           freq% = &H81
       CASE 6
           freq% = &HB0
       CASE 7
           freq% = &HCA
END SELECT
            
oct% = octave%

IF oct% > 7 THEN oct% = oct% + 2
IF oct% > 5 THEN oct% = oct% + 2
IF oct% > 3 THEN oct% = oct% + 2
IF oct% > 1 THEN oct% = oct% + 2
oct% = oct% + &H22

channel% = chan%
IF channel% > 5 THEN channel% = channel% + 5
IF channel% > 2 THEN channel% = channel% + 5

WriteReg &H43 + channel%, vol%

WriteReg &HA0 + chan%, freq%

WriteReg &HB0 + chan%, oct%

WriteReg &HE0 + chan%, &H0

END SUB

' This sub takes a screen shot which is saved to a BMP file.
SUB screenShot (errorCode%)

errorCode% = 0

DIM ttle&(30)
DIM pal&(63)
DIM clrStr%(155)

FOR i% = 0 TO 99                                         'Find an unused
   num$ = LTRIM$(RTRIM$(STR$(i%)))                       'screen shot file
   fileName$ = "scshot" + num$ + ".bmp"

   OPEN fileName$ FOR APPEND AS #2

   IF LOF(2) < 1 THEN
     CLOSE #2
     EXIT FOR
   ELSE
     CLOSE #2

     IF i% = 99 THEN
       errorCode% = 1
       EXIT SUB
     END IF
   END IF
NEXT i%

OPEN fileName$ FOR BINARY AS #2

ttle$ = "BM"                                            'Set up all the values
ttle&(1) = 240118                                       'for the file header
ttle&(2) = 0
ttle&(3) = 118
ttle&(4) = 40
ttle&(5) = 620
ttle&(6) = 270
ttle&(7) = 262145
ttle&(8) = 0
ttle&(9) = 240000
ttle&(10) = 3790
ttle&(11) = 3800
FOR i% = 12 TO 30
   ttle&(i%) = 0
NEXT i%

DEF SEG = VARSEG(ttle&(1))
pointer = VARPTR(ttle&(1))

FOR i% = 0 TO 51                                         'Put header values
   byte% = PEEK(pointer% + i%)                             'into ttle$ string
   byte$ = CHR$(byte)
   ttle$ = ttle$ + byte$
NEXT i%

PUT #2, , ttle$                                         'Write header to file

FOR i% = 0 TO 5                                          'Set up palette info
   pal&(i%) = 0
NEXT i%
pal&(6) = 128: pal&(7) = 0: pal&(8) = 0: pal&(9) = 128: pal&(10) = 0
pal&(11) = 0: pal&(12) = 0: pal&(13) = 128: pal&(14) = 128: pal&(15) = 0
pal&(16) = 128: pal&(17) = 0: pal&(18) = 0: pal&(19) = 0: pal&(20) = 128
pal&(21) = 0: pal&(22) = 128: pal&(23) = 0: pal&(24) = 128: pal&(25) = 128
pal&(26) = 0: pal&(27) = 0: pal&(28) = 192: pal&(29) = 192: pal&(30) = 192
pal&(31) = 0: pal&(32) = 128: pal&(33) = 128: pal&(34) = 128: pal&(35) = 0
pal&(36) = 0: pal&(37) = 0: pal&(38) = 255: pal&(39) = 0: pal&(40) = 0
pal&(41) = 255: pal&(42) = 0: pal&(43) = 0: pal&(44) = 0: pal&(45) = 255
pal&(46) = 255: pal&(47) = 0: pal&(48) = 255: pal&(49) = 0: pal&(50) = 0
pal&(51) = 0: pal&(52) = 255: pal&(53) = 0: pal&(54) = 255: pal&(55) = 0
pal&(56) = 255: pal&(57) = 255: pal&(58) = 0: pal&(59) = 0: pal&(60) = 255
pal&(61) = 255: pal&(62) = 255: pal&(63) = 0

pal$ = ""
FOR i% = 0 TO 63
   clr$ = CHR$(pal&(i%))
   pal$ = pal$ + clr$
NEXT i
                                                        'Write palette info
PUT #2, , pal$                                          'to the file

FOR y% = 339 TO 70 STEP -1                               'Write the pixel info
   FOR x% = 10 TO 629 STEP 2                             'to the file
      clr1% = POINT(x%, y%)
      clrConvert clr1%
      clr1% = clr1% * 17
     
      clr2% = POINT(x% + 1, y%)
      clrConvert clr2%
      clr2% = clr2% * 17

      clr% = (clr1% * 16) + (clr2% AND 15)
     
      DEF SEG = VARSEG(clrStr%(0))
      pointer% = VARPTR(clrStr%(0))

      POKE pointer% + ((x% - 10) / 2), clr%
   NEXT x%

   FOR x% = 0 TO 155
      PUT #2, , clrStr%(x%)
   NEXT x%
NEXT y%

CLOSE #2

BEEP                                                    'Signal when done

END SUB

SUB setChannel (chan%, fileName$)

DIM curIns%(12)

IF RIGHT$(fileName$, 4) <> ".mui" THEN fileName$ = fileName$ + ".mui"

OPEN fileName$ FOR BINARY AS #1

FOR i% = 1 TO 12
   GET #1, , curIns%(i%)
NEXT i%

CLOSE #1

IF chan% > 5 THEN chan% = chan% + 5
IF chan% > 2 THEN chan% = chan% + 5

WriteReg &H20 + chan%, curIns%(1)  ' Set modulator's multiple to F
WriteReg &H40 + chan%, curIns%(3)  ' Set modulator's level to 40 dB
WriteReg &H60 + chan%, curIns%(5)  ' Modulator attack: quick, decay: long
WriteReg &H80 + chan%, curIns%(7)  ' Modulator sustain: medium, release: medium
WriteReg &HE0 + chan%, curIns%(9)
WriteReg &HC0 + chan%, curIns%(11)
                   
WriteReg &H23 + chan%, curIns%(2)  ' Set carrier's multiple to 0
WriteReg &H43 + chan%, curIns%(4)  ' Set carrier's level to 0 dB
WriteReg &H63 + chan%, curIns%(6)  ' Carrier attack: quick, decay: long
WriteReg &H83 + chan%, curIns%(8)  ' Carrier sustain: quick, release: quick
WriteReg &HE3 + chan%, curIns%(10)
WriteReg &HC0 + chan%, curIns%(12)

END SUB

SUB setFX (chan%, curFX%())

DIM curIns%(12)

IF chan% > 5 THEN chan% = chan% + 5
IF chan% > 2 THEN chan% = chan% + 5

WriteReg &H20 + chan%, curFX%(1)  ' Set modulator's multiple to F
WriteReg &H40 + chan%, curFX%(3)  ' Set modulator's level to 40 dB
WriteReg &H60 + chan%, curFX%(5)  ' Modulator attack: quick, decay: long
WriteReg &H80 + chan%, curFX%(7)  ' Modulator sustain: medium, release: medium
WriteReg &HE0 + chan%, curFX%(9)
WriteReg &HC0 + chan%, curFX%(11)
                  
WriteReg &H23 + chan%, curFX%(2)  ' Set carrier's multiple to 0
WriteReg &H43 + chan%, curFX%(4)  ' Set carrier's level to 0 dB
WriteReg &H63 + chan%, curFX%(6)  ' Carrier attack: quick, decay: long
WriteReg &H83 + chan%, curFX%(8)  ' Carrier sustain: quick, release: quick
WriteReg &HE3 + chan%, curFX%(10)
WriteReg &HC0 + chan%, curFX%(12)

END SUB

SUB SFXPlay (chan%, freq%, vol%)

channel% = chan%
IF channel% > 5 THEN channel% = channel% + 5
IF channel% > 2 THEN channel% = channel% + 5

WriteReg &H43 + channel%, vol%

WriteReg &HA0 + chan%, freq%

WriteReg &HB0 + chan%, &H26

WriteReg &HE0 + chan%, &H0

END SUB

' View the title bitmap.
SUB title

SHARED snd%

DIM byte AS STRING * 1

OPEN "title.bmp" FOR APPEND AS #1

IF LOF(1) < 1 THEN
  CLOSE #1
  EXIT SUB
ELSE
  CLOSE #1
END IF

OPEN "title.bmp" FOR BINARY AS #1

table$ = INPUT$(54, #1)                 'Get the file header (54 bytes)
DIM table&(30)                          'Create numerical array for header
DEF SEG = VARSEG(table&(1))
pointer% = VARPTR(table&(1))

'Poke the data from string "table$" into numerical array "table&"
FOR x% = 0 TO 51
   POKE pointer% + x%, ASC(MID$(table$, x% + 3, 1))
NEXT
DEF SEG

SCREEN 12
CLS

theColors$ = INPUT$(table&(3) - 54, #1) 'Read in pallette info

DEF SEG = VARSEG(pal&)
pointer% = VARPTR(pal&)

'Poke the pallette info from the string "thecolors$"
'into pal& and reduce to 6 bits per byte.
FOR x% = 0 TO 63 STEP 4
   POKE pointer%, (ASC(MID$(theColors$, x% + 3, 1))) \ 4
   POKE pointer% + 1, (ASC(MID$(theColors$, x% + 2, 1))) \ 4
   POKE pointer% + 2, (ASC(MID$(theColors$, x% + 1, 1))) \ 4
   POKE pointer% + 3, 0
   PALETTE x% \ 4, pal&
NEXT x%
DEF SEG

'Read in Bitmap data and set pixels accordingly
y% = table&(6) + 100                     'Put number of vertical pixels into y%
DO
  data$ = INPUT$((((table&(5) - 1) OR 7) + 1) \ 2, #1)
 
  IF (table&(5) \ 2) < LEN(data$) THEN
    linelength% = table&(5) \ 2
  ELSE
    linelength% = LEN(data$)
  END IF
   
  FOR x% = 6 TO linelength% + 5
     pixel% = ASC(MID$(data$, x% - 5, 1))
     PSET (x% * 2 + 1, y%), pixel% AND 15
     PSET (x% * 2, y%), pixel% \ 16
  NEXT x%
  y% = y% - 1
LOOP UNTIL EOF(1)

CLOSE #1

font 160, 50, "ALIEN EGG HUNT"
font 80, 400, "A GAME BY AARON SEVERN"

IF snd% = 0 THEN
  musicPlayer 7
ELSE
  DO: a$ = INKEY$: LOOP UNTIL a$ = ""
  DO: a$ = INKEY$: LOOP UNTIL a$ <> ""
END IF

DO: a$ = INKEY$: LOOP UNTIL a$ = ""

END SUB

' View a recorded game.  Essentially the same as playEggHunt sub except
' without user interaction.
SUB viewRecording

SHARED ship1!(), ship2!(), missileL!(), missileR!(), eggL!(), eggD!(), eggR!(), eggU!(), tnt1!(), tnt2!(), tnt3!(), tnt4!(), starLocX%(), starLocY%(), starClr%(), explode1!(), explode2!(), star1!(), star2!(), star3!(), underline!(), baseTime%, snd%

getRecordFile fileName$, errorCode%

IF errorCode% THEN EXIT SUB                      'If the viewing was cancelled
                                                'leave without doing anything
OPEN fileName$ FOR BINARY AS #1

id$ = INPUT$(7, #1)                             'Get the file ID and label
label$ = INPUT$(20, #1)                         'out of the way

'Arrays to track the missiles
DIM missileType%(20)
DIM missileX%(20)
DIM missileY%(20)
DIM missileSpeed%(20)
DIM missileFTO%(20)

'Track the dynamite
DIM tntState%(5)
DIM tntX%(5)
DIM tntY%(5)
DIM tntFTO%(5)

'Track the debris from the dynamite explosions
DIM debrisState%(5)
DIM debrisDir%(5)
DIM debrisX%(5)
DIM debrisY%(5)

'Track the shooting stars
DIM starType%(10)
DIM starX%(10)
DIM starY%(10)
DIM starFTO%(10)

'Track the eggs
DIM eggState%(3)
DIM eggX%(3)
DIM eggY%(3)
DIM eggDir%(3)
DIM eggFTO%(3)

'Sound effects arrays and values
DIM shipSnd%(12)
shipSnd%(1) = 0: shipSnd%(2) = 13: shipSnd%(3) = 143: shipSnd%(4) = 15
shipSnd%(5) = 241: shipSnd%(6) = 243: shipSnd%(7) = 0: shipSnd%(8) = 0
shipSnd%(9) = 0: shipSnd%(10) = 3: shipSnd%(11) = 0: shipSnd%(12) = 0
setFX 3, shipSnd%()

DIM missSnd%(12)
missSnd%(1) = 1: missSnd%(2) = 1: missSnd%(3) = 6: missSnd%(4) = 20
missSnd%(5) = 255: missSnd%(6) = 220: missSnd%(7) = 60: missSnd%(8) = 0
missSnd%(9) = 0: missSnd%(10) = 3: missSnd%(11) = 6: missSnd%(12) = 0
setFX 4, missSnd%()

DIM tntExplSnd%(12)
tntExplSnd%(1) = 1: tntExplSnd%(2) = 0: tntExplSnd%(3) = 138: tntExplSnd%(4) = 0
tntExplSnd%(5) = 75: tntExplSnd%(6) = 255: tntExplSnd%(7) = 5: tntExplSnd%(8) = 4
tntExplSnd%(9) = 0: tntExplSnd%(10) = 2: tntExplSnd%(11) = 0: tntExplSnd%(12) = 0
setFX 2, tntExplSnd%()
setFX 6, tntExplSnd%()

DIM clockSnd%(12)
clockSnd%(1) = 10: clockSnd%(2) = 5: clockSnd%(3) = 143: clockSnd%(4) = 0
clockSnd%(5) = 241: clockSnd%(6) = 243: clockSnd%(7) = 7: clockSnd%(8) = 9
clockSnd%(9) = 0: clockSnd%(10) = 3: clockSnd%(11) = 6: clockSnd%(12) = 0
setFX 0, clockSnd%()

DIM tntSnd%(12)
tntSnd%(1) = 16: tntSnd%(2) = 0: tntSnd%(3) = 14: tntSnd%(4) = 15
tntSnd%(5) = 255: tntSnd%(6) = 16: tntSnd%(7) = 4: tntSnd%(8) = 5
tntSnd%(9) = 0: tntSnd%(10) = 0: tntSnd%(11) = 15: tntSnd%(12) = 255
setFX 1, tntSnd%()

DIM starSnd%(12)
starSnd%(1) = 255: starSnd%(2) = 255: starSnd%(3) = 20: starSnd%(4) = 20
starSnd%(5) = 241: starSnd%(6) = 241: starSnd%(7) = 0: starSnd%(8) = 0
starSnd%(9) = 0: starSnd%(10) = 0: starSnd%(11) = 0: starSnd%(12) = 0
setFX 5, starSnd%()

DIM alarmSnd%(12)
alarmSnd%(1) = 8: alarmSnd%(2) = 13: alarmSnd%(3) = 10: alarmSnd%(4) = 0
alarmSnd%(5) = 241: alarmSnd%(6) = 243: alarmSnd%(7) = 0: alarmSnd%(8) = 0
alarmSnd%(9) = 0: alarmSnd%(10) = 1: alarmSnd%(11) = 0: alarmSnd%(12) = 0
setFX 7, alarmSnd%()

DIM levelClrSnd%(12)
levelClrSnd%(1) = 15: levelClrSnd%(2) = 15: levelClrSnd%(3) = 10: levelClrSnd%(4) = 0
levelClrSnd%(5) = 241: levelClrSnd%(6) = 243: levelClrSnd%(7) = 3: levelClrSnd%(8) = 3
levelClrSnd%(9) = 0: levelClrSnd%(10) = 1: levelClrSnd%(11) = 0: levelClrSnd%(12) = 9
setFX 8, levelClrSnd%()

'Initial inputs from the file for the starting game parameters
frame$ = INPUT$(6, #1)                          'Starting frame
level$ = INPUT$(3, #1)                          'Current level
level$ = RIGHT$(level$, 2)
startLevel = VAL(level$)
lives$ = INPUT$(3, #1)                          'Lives left
lives$ = RIGHT$(lives$, 2)
lives% = VAL(lives$)
score$ = INPUT$(6, #1)                          'Current score
score$ = RIGHT$(score$, 5)
score& = VAL(score$)
eggs$ = INPUT$(3, #1)                           'Eggs caught
eggs$ = RIGHT$(eggs$, 2)
eggs% = VAL(eggs$)

extras& = score& \ 1000 + 1

'Arrow keys and escape
u$ = CHR$(0) + CHR$(72)
l$ = CHR$(0) + CHR$(75)
r$ = CHR$(0) + CHR$(77)
d$ = CHR$(0) + CHR$(80)
esc$ = CHR$(0) + CHR$(16)
pause$ = CHR$(0) + CHR$(25)
record$ = CHR$(0) + CHR$(19)

startView% = 1
deathOn% = 1

FOR level% = startLevel TO 20
   levelEnd% = 0                                 'Initialize all game play
                                                'variables
   totMissile% = 0
   totHeatSeek% = 0
   totTnt% = 0
   totStar% = 0
   totEgg% = 0

   FOR i% = 1 TO 20
      missileType%(i%) = 0
      missileX%(i%) = 0
      missileY%(i%) = 0
      missileSpeed%(i%) = 0
      missileFTO%(i%) = 0
   NEXT i%

   FOR i% = 1 TO 5
      tntState%(i%) = 0
      tntX%(i%) = 0
      tntY%(i%) = 0
      tntFTO%(i%) = 0
   NEXT i%

   FOR i% = 1 TO 5
      debrisState%(i%) = 0
      debrisDir%(i%) = 0
      debrisX%(i%) = 0
      debrisY%(i%) = 0
   NEXT i%

   FOR i% = 1 TO 10
      starType%(i%) = 0
      starX%(i%) = 0
      starY%(i%) = 0
      starFTO%(i%) = 0
   NEXT i%

   FOR i% = 1 TO 3
      eggState%(i%) = 0
      eggX%(i%) = 0
      eggY%(i%) = 0
      eggDir%(i%) = 0
      eggFTO%(i%) = 0
   NEXT i%

   explodeState% = 0
   flashState% = 0
  
   flashStartTime& = 0

   bonus% = 1
   bonusPts% = 0

   scrnFlip% = 1

   plotStars 300
 
   DO: a$ = INKEY$: LOOP UNTIL a$ = ""

   SCREEN 9, 0, 0, 1
  
   DO
     IF scrnFlip% = 1 THEN                               'Switch between two
       SCREEN 9, 0, 1, 0                                'video pages to allow
       scrnFlip% = 2                                     'smooth animation
     ELSEIF scrnFlip% = 2 THEN
       SCREEN 9, 0, 0, 1
       scrnFlip% = 1
     END IF

     CLS

     a$ = INKEY$

     IF a$ = CHR$(27) THEN
       CLOSE #1
       IF snd% = 0 THEN
         FOR i% = 0 TO 7
            WriteReg &HA0 + i%, &H0
            WriteReg &HB0 + i%, &H0
         NEXT i%
       END IF

       EXIT SUB
     ELSEIF a$ = CHR$(0) + CHR$(31) THEN
       IF scrnFlip% = 2 THEN
         SCREEN 9, 0, 0, 0
       ELSE
         SCREEN 9, 0, 1, 1
       END IF

       screenShot errorCode%

       IF errorCode% THEN                                'If there isn't an
         font 50, 315, "NO ROOM FOR SCREEN SHOT"        'unused screen shot
         clearRegister                                  'file then say so
       END IF

       IF scrnFlip% = 2 THEN
         SCREEN 9, 0, 0, 1
       ELSE
         SCREEN 9, 0, 1, 0
       END IF
     ELSEIF a$ = CHR$(0) + CHR$(45) THEN
       IF snd% = 0 THEN
         FOR i% = 0 TO 7
            WriteReg &HA0 + i%, &H0
            WriteReg &HB0 + i%, &H0
         NEXT i%
         snd% = 1
       ELSEIF snd% = 1 THEN
         snd% = 0
       END IF
     END IF
    
     IF explodeState% <> 0 THEN                          'if the ship is
       IF snd% = 0 THEN
         IF explodeState% = 1 THEN
           WriteReg &HA0 + 3, &H0
           WriteReg &HB0 + 3, &H0
           SFXPlay 6, 0, 0
         END IF
       END IF
      
       explodeState% = explodeState% + 1                  'exploding, blow it up
       IF explodeState% = 4 THEN
         explodeState% = 0
         lives% = lives% - 1
         flashState% = 1
         flashStartTime& = INT(TIMER)
         deathOn% = 0
         IF lives% < 0 THEN
           CLOSE #1
           IF snd% = 0 THEN
             FOR i% = 0 TO 7
                WriteReg &HA0 + i%, &H0
                WriteReg &HB0 + i%, &H0
             NEXT i%
           END IF

           EXIT SUB
         END IF
       END IF
     ELSE
       IF snd% = 0 THEN
         freq% = shipMove% * 10
         SFXPlay 3, freq%, 15
       END IF
     END IF

     IF snd% = 0 THEN
       IF ticked% = 1 THEN
         ticked% = 0
         justTicked% = 1
         SFXPlay 0, 0, 10
       ELSEIF ticked% = 3 THEN
         ticked% = 0
         justTicked% = 8
        
         WriteReg &HA0 + 7, &H0
         WriteReg &HB0 + 7, &H0
         SFXPlay 7, 255, 0
       END IF

       IF justTicked% = 1 THEN
         justTicked% = 2
       ELSEIF justTicked% = 2 THEN
         justTicked% = 0
         WriteReg &HA0, &H0
         WriteReg &HB0, &H0
       ELSEIF justTicked% = 3 THEN
         justTicked% = 0
         WriteReg &HA0 + 7, &H0
         WriteReg &HB0 + 7, &H0
       ELSEIF justTicked% > 3 THEN
         justTicked% = justTicked% - 1
       END IF
     END IF

     IF totMissile% <> 0 THEN                            'Calculate the motion
       FOR i% = 1 TO 20                                  'of each missile
          IF missileType%(i%) <> 0 THEN                   'currently in play
            IF missileFTO%(i%) = 0 THEN
              IF missileType%(i%) = 1 OR missileType%(i%) = 3 THEN
                missileX%(i%) = missileX%(i%) + missileSpeed%(i%)
                IF missileType%(i%) = 3 THEN
                  distY% = shipY% - missileY%(i%)
                  moveY% = distY% / 500 * missileSpeed%(i%)
                  missileY%(i%) = missileY%(i%) + moveY%
                END IF

                IF missileX%(i%) >= 600 THEN
                  IF missileType%(i%) = 3 THEN totHeatSeek% = totHeatSeek% - 1
                  missileType%(i%) = 0                      'If the missile goes
                  missileX%(i%) = 0                         'off the screen,
                  missileY%(i%) = 0                         'remove it from play
                  missileSpeed%(i%) = 0
                  totMissile% = totMissile% - 1
                END IF
              ELSE
                missileX%(i%) = missileX%(i%) - missileSpeed%(i%)
                IF missileType%(i%) = 4 THEN
                  distY% = shipY% - missileY%(i%)
                  moveY% = (distY% / 500) * missileSpeed%(i%)
                  missileY%(i%) = missileY%(i%) + moveY%
                END IF
            
                IF missileX%(i%) <= 0 THEN
                  IF missileType%(i%) = 4 THEN totHeatSeek% = totHeatSeek% - 1
                  missileType%(i%) = 0
                  missileX%(i%) = 0
                  missileY%(i%) = 0
                  missileSpeed%(i%) = 0
                  totMissile% = totMissile% - 1
                END IF
              END IF

              IF deathOn% THEN
                IF missileX%(i%) >= shipX% - 35 AND missileX%(i%) <= shipX% + 35 THEN
                  IF missileY%(i%) >= shipY% - 15 AND missileY%(i%) <= shipY% + 15 THEN
                    missileType%(i%) = 0
                    missileX%(i%) = 0                     'If the missile hits
                    missileY%(i%) = 0                     'the ship, set the
                    missileSpeed%(i%) = 0                 'explosion in motion
                    totMissile% = totMissile% - 1
                    explodeState% = 1
                  END IF
                END IF
              END IF
            ELSE
              missileFTO%(i%) = 0
            END IF
          END IF
       NEXT i%
     END IF

     FOR i% = 1 TO 5                                     'Calculate the debris
        IF debrisState%(i%) <> 0 THEN                     'motion
          debrisState%(i%) = debrisState%(i%) + 1
          IF debrisState%(i%) = 9 THEN                    'Remove the debris
            debrisState%(i%) = 0                          'if it's been around
            debrisX%(i%) = 0                              'long enough
            debrisY%(i%) = 0
          END IF

          IF debrisState%(i%) = 2 THEN
            WriteReg &HA0 + 2, &H0
            WriteReg &HB0 + 2, &H0
          END IF
         
          'Check to see if any debris hits the ship, if it does, start the
          'explosion.
          IF deathOn% THEN
            IF debrisX%(i%) - 7 * debrisState%(i%) >= shipX% AND debrisX%(i%) - 7 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) >= shipY% AND debrisY%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) - 4 * debrisState%(i%) >= shipX% AND debrisX%(i%) - 4 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) - 4 * debrisState%(i%) >= shipY% AND debrisY%(i%) - 4 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) >= shipX% AND debrisX%(i%) <= shipX% + 40 AND debrisY%(i%) - 7 * debrisState%(i%) >= shipY% AND debrisY%(i%) - 7 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) + 4 * debrisState%(i%) >= shipX% AND debrisX%(i%) + 4 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) - 4 * debrisState%(i%) >= shipY% AND debrisY%(i%) - 4 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) + 7 * debrisState%(i%) >= shipX% AND debrisX%(i%) + 7 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) >= shipY% AND debrisY%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) + 4 * debrisState%(i%) >= shipX% AND debrisX%(i%) + 4 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) + 4 * debrisState%(i%) >= shipY% AND debrisY%(i%) + 4 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) >= shipX% AND debrisX%(i%) <= shipX% + 40 AND debrisY%(i%) + 7 * debrisState%(i%) >= shipY% AND debrisY%(i%) + 7 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            ELSEIF debrisX%(i%) - 4 * debrisState%(i%) >= shipX% AND debrisX%(i%) - 4 * debrisState%(i%) <= shipX% + 40 AND debrisY%(i%) + 4 * debrisState%(i%) >= shipY% AND debrisY%(i%) + 4 * debrisState%(i%) <= shipY% + 20 THEN
              explodeState% = 1
              debrisState%(i%) = 0
              debrisX%(i%) = 0
              debrisY%(i%) = 0
            END IF
          END IF
        END IF
     NEXT i%

     IF totTnt% <> 0 THEN                                'Calculate changes to
       FOR i% = 1 TO 5                                   'dynamite
          IF tntState%(i%) <> 0 THEN
            IF tntFTO%(i%) = 0 THEN
              tntState%(i%) = tntState%(i%) + 1
              IF tntState%(i%) = 10 THEN                    'If the dynamite blows
                FOR j% = 1 TO 5                            'up, send debris
                   IF debrisState%(j%) = 0 THEN             'flying everywhere
                     debrisState%(j%) = 1
                     debrisX%(j%) = tntX%(i%) + 10
                     debrisY%(j%) = tntY%(i%) + 10
                     EXIT FOR
                   END IF
                NEXT j%
            
                IF snd% = 0 THEN
                  WriteReg &HA0 + 1, &H0
                  WriteReg &HB0 + 1, &H0
                  WriteReg &HA0 + 2, &H0
                  WriteReg &HB0 + 2, &H0
                  SFXPlay 2, 0, 0
                END IF
             
                tntState%(i%) = 0
                tntX%(i%) = 0
                tntY%(i%) = 0
                totTnt% = totTnt% - 1
              END IF
            ELSE
              tntFTO%(i%) = 0
            END IF
          END IF
       NEXT i%
     END IF

     IF totStar% <> 0 THEN                               'Calculate the motion
       FOR i% = 1 TO 10                                  'of each star
          IF starType%(i%) <> 0 THEN                      'currently in play
            IF starFTO%(i%) = 0 THEN
              starType%(i%) = starType%(i%) + 1               'Switch between stars
              IF starType%(i%) = 5 THEN starType%(i%) = 1     'for animation

              starY%(i%) = starY%(i%) + 5

              IF starY%(i%) >= 325 THEN
                starType%(i%) = 0                           'If the star goes
                starX%(i%) = 0                              'off the screen,
                starY%(i%) = 0                              'remove it from play
                totStar% = totStar% - 1
              END IF

              IF deathOn% THEN
                IF starX%(i%) >= shipX% - 15 AND starX%(i%) <= shipX% + 35 THEN
                  IF starY%(i%) >= shipY% - 15 AND starY%(i%) <= shipY% + 15 THEN
                    starType%(i%) = 0
                    starX%(i%) = 0                        'If the star hits
                    starY%(i%) = 0                        'the ship, set the
                    totStar% = totStar% - 1               'explosion in motion
                    explodeState% = 1
                  END IF
                END IF
              END IF
            ELSE
              starFTO%(i%) = 0
            END IF
          END IF
       NEXT i%
     END IF

     IF totEgg% <> 0 THEN
       FOR i% = 1 TO 3
          IF eggState%(i%) <> 0 THEN                      'Calculate egg motion
            IF eggFTO%(i%) = 0 THEN
              IF eggDir%(i%) = 1 THEN
                eggState%(i%) = eggState%(i%) - 1             'Four egg states allow
                IF eggState%(i%) = 0 THEN eggState%(i%) = 4   'for rolling effect
                eggX%(i%) = eggX%(i%) + eggSpeed%
                IF eggX%(i%) >= 619 THEN
                  eggState%(i%) = 0
                  eggX%(i%) = 0
                  eggY%(i%) = 0
                  eggDir%(i%) = 0
                  totEgg% = totEgg% - 1
                END IF
              ELSEIF eggDir%(i%) = 2 THEN
                eggState%(i%) = eggState%(i%) + 1
                IF eggState%(i%) = 5 THEN eggState%(i%) = 1
                eggX%(i%) = eggX%(i%) - eggSpeed%
                IF eggX%(i%) <= 0 THEN
                  eggState%(i%) = 0
                  eggX%(i%) = 0
                  eggY%(i%) = 0
                  eggDir%(i%) = 0
                  totEgg% = totEgg% - 1
                END IF
              END IF

              IF eggX%(i%) >= shipX% - 15 AND eggX%(i%) <= shipX% + 35 THEN
                IF eggY%(i%) >= shipY% - 15 AND eggY%(i%) <= shipY% + 15 THEN
                  eggs% = eggs% + 1
                  score& = score& + 100                     'If the ship catches
                  eggState%(i%) = 0                         'the egg, adjust
                  eggX%(i%) = 0                             'variables accordingly
                  eggY%(i%) = 0
                  eggDir%(i%) = 0
                  totEgg% = totEgg% - 1
                  WriteReg &HA0 + 8, &H0
                  WriteReg &HB0 + 8, &H0
                  SFXPlay 8, 100, 15
                                                          'If enough eggs are
                  IF eggs% = maxEgg% THEN EXIT DO           'caught, end the level
                END IF
              END IF
            ELSE
              eggFTO%(i%) = 0
            END IF
          END IF
       NEXT i%
     END IF

     IF score& >= 1000 * extras& THEN                     'if an extra ship is
       lives% = lives% + 1                                'due, give it
       extras& = extras& + 1
     END IF
  
     CLS

     FOR j% = 1 TO 300                                   'Draw the stars
        PSET (starLocX%(j%), starLocY%(j%)), starClr%(j%)
     NEXT j%

     font 1, 1, "LEVEL"                                 'Draw the text at the
     level$ = LTRIM$(RTRIM$(STR$(level%)))               'top of the screen
     font 121, 1, level$

     font 1, 31, "LIVES"
     lives$ = LTRIM$(RTRIM$(STR$(lives%)))
     font 121, 31, lives$

     font 401, 1, "SCORE"
     score$ = LTRIM$(RTRIM$(STR$(score&)))
     font 521, 1, score$

     font 401, 31, "EGGS"
     eggs$ = LTRIM$(RTRIM$(STR$(eggs%)))
     font 521, 31, eggs$

     timeLeft$ = LTRIM$(RTRIM$(STR$(timeLeft%)))
     font 251, 16, timeLeft$

     IF totTnt% <> 0 THEN                                'Draw the dynamite if
       FOR i% = 1 TO 5                                   'there is any in play
          IF tntState%(i%) <> 0 THEN
            SELECT CASE tntState%(i%)                     'Animate the dynamite
                   CASE 1 TO 2
                       newPut tntX%(i%), tntY%(i%), tnt1!()
                   CASE 3 TO 4
                       newPut tntX%(i%), tntY%(i%), tnt2!()
                   CASE 5 TO 6
                       newPut tntX%(i%), tntY%(i%), tnt3!()
                   CASE 7 TO 8
                       newPut tntX%(i%), tntY%(i%), tnt4!()
                   CASE 9
            END SELECT

            IF snd% = 0 THEN
              WriteReg &HA0 + 1, &H0
              WriteReg &HB0 + 1, &H0
              SFXPlay 1, 255, 20
            END IF
          END IF
       NEXT i%
     END IF

     IF totStar% <> 0 THEN                               'Draw the falling
       FOR i% = 1 TO 10                                  'stars if there are
          IF starType%(i%) <> 0 THEN                      'any.
            SELECT CASE starType%(i%)
                   CASE 1
                       PUT (starX%(i%), starY%(i%)), star1!, PSET
                   CASE 2
                       PUT (starX%(i%), starY%(i%)), star2!, PSET
                   CASE 3
                       PUT (starX%(i%), starY%(i%)), star3!, PSET
                   CASE 4
                       PUT (starX%(i%), starY%(i%)), star2!, PSET
            END SELECT
         
            IF snd% = 0 THEN
              vol% = 40 - totStar%
              SFXPlay 5, 0, vol%
            END IF
          END IF
       NEXT i%
     END IF
                               
     IF totMissile% <> 0 THEN                            'Draw the missiles if
       FOR i% = 1 TO 20                                  'there are any in play
          IF missileType%(i%) <> 0 THEN
            IF missileType%(i%) = 1 OR missileType%(i%) = 3 THEN
              PUT (missileX%(i%), missileY%(i%)), missileL!, PSET
            ELSE
              PUT (missileX%(i%), missileY%(i%)), missileR!, PSET
            END IF
         
            IF snd% = 0 THEN
              vol% = 20 - totMissile%
              SFXPlay 4, 0, vol%
            END IF
          END IF
       NEXT i%
     END IF

     IF totEgg% <> 0 THEN
       FOR i% = 1 TO 3
          IF eggState%(i%) <> 0 THEN                      'Draw the egg if it is
            SELECT CASE eggState%(i%)                     'in play
                   CASE 1
                       PUT (eggX%(i%), eggY%(i%)), eggL!, PSET  'Get the animated
                   CASE 2                                  'rolling action by
                       PUT (eggX%(i%), eggY%(i%)), eggD!, PSET  'drawing a
                   CASE 3                                  'particular sprite
                       PUT (eggX%(i%), eggY%(i%)), eggR!, PSET
                   CASE 4
                       PUT (eggX%(i%), eggY%(i%)), eggU!, PSET
            END SELECT
          END IF
       NEXT i%
     END IF

     FOR i% = 1 TO 5                                     'Draw the debris if
        IF debrisState%(i%) <> 0 THEN                     'there is any
          debX1% = debrisX%(i%) - 7 * debrisState%(i%)
          debX2% = debrisX%(i%) - 4 * debrisState%(i%)
          debX3% = debrisX%(i%) + 4 * debrisState%(i%)
          debX4% = debrisX%(i%) + 7 * debrisState%(i%)
          debY1% = debrisY%(i%) - 7 * debrisState%(i%)
          debY2% = debrisY%(i%) - 4 * debrisState%(i%)
          debY3% = debrisY%(i%) + 4 * debrisState%(i%)
          debY4% = debrisY%(i%) + 7 * debrisState%(i%)

          IF debX1% > 9 THEN PSET (debX1%, debrisY%(i%)), 14
          IF debX2% > 9 AND debY2% > 69 THEN PSET (debX2%, debY2%), 14
          IF debY1% > 69 THEN PSET (debrisX%(i%), debY1%), 14
          IF debX3% < 631 AND debY2% > 69 THEN PSET (debX3%, debY2%), 14
          IF debX4% < 631 THEN PSET (debX4%, debrisY%(i%)), 14
          IF debX3% < 631 AND debY3% < 341 THEN PSET (debX3%, debY3%), 14
          IF debY4% < 341 THEN PSET (debrisX%(i%), debY4%), 14
          IF debX2% > 9 AND debY3% < 341 THEN PSET (debX2%, debY3%), 14
        END IF
     NEXT i%

     IF startView% = 0 THEN
       IF explodeState% = 0 THEN                           'If the ship isn't
         IF scrnFlip% = 1 THEN                             'exploding, draw it
           IF flashState% <= 2 THEN                        'Animate the ship
             PUT (shipX%, shipY%), ship1!, PSET            'with the two ship
           END IF                                          'sprites
         ELSEIF scrnFlip% = 2 THEN
           IF flashState% <= 2 THEN PUT (shipX%, shipY%), ship2!, PSET
         END IF

         IF flashState% THEN
           flashState% = flashState% + 1
           IF flashState% = 4 THEN flashState% = 1
         END IF
     
         IF TIMER > (flashStartTime& + 3) THEN
           flashState% = 0
           deathOn% = 1
         END IF
       ELSE                                               'If the ship is
         IF explodeState% = 1 OR explodeState% = 3 THEN     'exploding, draw the
           PUT (shipX% + 10, shipY%), explode1!, PSET        'explosion
         ELSEIF explodeState% = 2 THEN                     'Animate the explosion
           PUT (shipX% + 10, shipY%), explode2!, PSET
         END IF
       END IF
     END IF

     LINE (0, 60)-(639, 349), 8, B                      'Draw the border
     LINE (4, 64)-(635, 345), 7, B
     LINE (9, 69)-(631, 341), 15, B

     ' This section of code gets the recorded data from the file and makes
     ' some sense out of it.
     DO
       char$ = INPUT$(1, #1)

       SELECT CASE char$
              CASE "M"                                  'On M bring a new
                  FOR i% = 1 TO 20                       'missile on the screen
                     IF missileType%(i%) = 0 THEN         'with the recorded
                       type$ = INPUT$(1, #1)            'location, speed,
                       missileType%(i%) = VAL(type$)      'direction, and type
                       y$ = INPUT$(3, #1)
                       missileY%(i%) = VAL(y$)
                       speed$ = INPUT$(2, #1)
                       missileSpeed%(i%) = VAL(speed$)

                       IF missileType%(i%) = 1 OR missileType%(i%) = 3 THEN
                         missileX%(i%) = 0
                       ELSE
                         missileX%(i%) = 599
                       END IF

                       totMissile% = totMissile% + 1
                       IF missileType%(i%) = 3 OR missileType%(i%) = 4 THEN
                         totHeatSeek% = totHeatSeek% + 1
                       END IF

                       missileFTO%(i%) = 1

                       EXIT FOR
                     END IF
                  NEXT i%
              CASE "D"                                  'On D put some new
                  FOR i% = 1 TO 5                        'dynamite on the
                     IF tntState%(i%) = 0 THEN            'screen in the
                       tntState%(i%) = 1                  'recorded location
                       x$ = INPUT$(3, #1)
                       tntX%(i%) = VAL(x$)
                       y$ = INPUT$(3, #1)
                       tntY%(i%) = VAL(y$)

                       totTnt% = totTnt% + 1
                       tntFTO%(i%) = 1

                       EXIT FOR
                     END IF
                  NEXT i%
              CASE "S"                                  'On S, a new falling
                  FOR i% = 1 TO 10                       'star
                     IF starType%(i%) = 0 THEN
                       type$ = INPUT$(1, #1)
                       starType%(i%) = VAL(type$)
                       x$ = INPUT$(3, #1)
                       starX%(i%) = VAL(x$)
                       starY%(i%) = 70
                      
                       totStar% = totStar% + 1
                       starFTO%(i%) = 1

                       EXIT FOR
                     END IF
                  NEXT i%
              CASE "E"                                  'On E, a new egg
                  FOR i% = 1 TO 3
                     IF eggState%(i%) = 0 THEN
                       type$ = INPUT$(1, #1)
                       eggState%(i%) = VAL(type$)
                       y$ = INPUT$(3, #1)
                       eggY%(i%) = VAL(y$)
                       dir$ = INPUT$(1, #1)
                       eggDir%(i%) = VAL(dir$)
                       speed$ = INPUT$(2, #1)
                       eggSpeed% = VAL(speed$)

                       IF eggDir%(i%) = 1 THEN
                         eggX%(i%) = 0
                       ELSE
                         eggX%(i%) = 619
                       END IF

                       totEgg% = totEgg% + 1
                       eggFTO%(i%) = 1

                       EXIT FOR
                     END IF
                  NEXT i%
              CASE "U"                                  'Get the ship(UFO)
                  oldX% = shipX%
                  oldY% = shipY%
                
                  x$ = INPUT$(3, #1)                    'position variables
                  shipX% = VAL(x$)                       'on U.
                  y$ = INPUT$(3, #1)
                  shipY% = VAL(y$)

                  IF startView% = 1 THEN
                    oldX% = shipX%
                    oldY% = shipY%
                    startView% = 0
                  END IF
                 
                  moveX% = shipX% - oldX%
                  moveY% = shipY% - oldY%
                  shipMove% = ABS(moveX%) + ABS(moveY%)
              CASE "T"                                  'Time left on T
                  oldTime% = timeLeft%
                  tm$ = INPUT$(3, #1)
                  timeLeft% = VAL(tm$)
                  IF oldTime% <> timeLeft% THEN ticked% = 1
              CASE "L"                                  'Change levels on L
                  level$ = INPUT$(2, #1)
                  levelEnd% = 1
       END SELECT
     LOOP UNTIL EOF(1) OR char$ = "F"                   'Get more until the
                                                        'end of the file or
     IF EOF(1) THEN                                     'a new frame
       CLOSE #1
       IF snd% = 0 THEN
         FOR i% = 0 TO 7
            WriteReg &HA0 + i%, &H0
            WriteReg &HB0 + i%, &H0
         NEXT i%
       END IF
     
       EXIT SUB                                         'Get out if at the end
     END IF                                             'of the file
     IF char$ = "F" THEN frame$ = INPUT$(5, #1)

     IF timeLeft% = baseTime% AND oldTime% = 0 THEN
       IF bonus% = 0 THEN
         eggs% = eggs% - 1
         IF eggs% < 0 THEN eggs% = 0
       END IF
       IF snd% = 0 THEN
         ticked% = 3
       END IF
       bonus% = 0                                        'remove any chance of
     END IF                                             'a time bonus
   LOOP UNTIL levelEnd%

   IF snd% = 0 THEN
     FOR i% = 0 TO 7
        WriteReg &HA0 + i%, &H0
        WriteReg &HB0 + i%, &H0
     NEXT i%
   END IF
  
   IF bonus% = 1 THEN                                    'if a time bonus is
     bonusPts% = timeLeft% * 10                           'due, give it
     score& = score& + bonusPts%
   END IF

   SCREEN 9, 0, 1, 0
   CLS
 
   SCREEN 9, 0, 0, 1
   CLS

   levelOutro bonusPts%

   levelIntro level% + 1, (level% + 1) * 2
NEXT level%

END SUB

' If the player somehow finds a way to win, give congratulations
SUB winGame

DO: a$ = INKEY$: LOOP UNTIL a$ = ""

CLS

font 200, 50, "WAY TO GO"

delay 1

font 50, 120, "YOU HAVE COLLECTED ENOUGH"
font 60, 150, "EGGS TO SAVE YOUR PLANET"

delay 1

font 70, 200, "YOUR SCIENTISTS CAN NOW"
font 50, 230, "CONDUCT THEIR EXPERIMENTS"
font 180, 260, "SUCCESSFULLY"

delay 1

font 190, 310, "PRESS A KEY"

clearRegister

CLS

font 220, 10, "CREDITS"

delay 1

font 180, 70, "PROGRAMMING"
font 170, 100, "AARON SEVERN"

delay 1

font 210, 150, "GRAPHICS"
font 170, 180, "AARON SEVERN"

delay 1

font 90, 230, "SOUND PROGRAMMING BY"
font 170, 260, "AARON SEVERN"

delay 1

font 180, 310, "PRESS A KEY"

clearRegister

CLS

font 130, 150, "THANKS FOR PLAYING"

delay 1.5

CLS

END SUB

SUB WriteReg (reg%, value%)

OUT &H388, reg%     '388h = address/status port, 389h = dataport

FOR x = 0 TO 5     ' This tells the SB what register we want to write to
   a = INP(&H388)  ' After we write to the address port we must wait 3.3ms
NEXT x

OUT &H389, value%   ' Send the value for the register to 389h

FOR x = 0 TO 34    ' Here we must also wait, this time 23ms
   a = INP(&H388)
NEXT x

END SUB

