program blocx;
uses crt,vgatext,sprgfx,miscvga,dos{,detect,smix};
const
 XMSRequired   = 190;    {XMS memory required to load the sounds (KBytes) }
 SharedEMB     = true;
   {TRUE:   All sounds will be stored in a shared EMB}
   {FALSE:  Each sound will be stored in a separate EMB}
 NumSounds = 5;

var
 ball,bat	: sprite;
 blocks		: sprite;
 qmark		: sprite;
 cursor		: sprite;
 level		: array[0..11,0..29] of byte;
 eXMouse	: integer;
 xmouse,ymouse	: integer;
 BatX		: integer;
 bmouse		: integer;
 bneeded	: integer;
 banim		: integer;
 bkanim		: integer;
 blockanim	: integer;
 bac		: integer;
 banimcount	: integer;
 stab		: array[0..2047] of integer;
 suh		: array[0..4095] of byte;
 rkey		: char;
 pirkko		: integer;
 leveldelay	: integer;
 slev		: string;
 stlev		: integer;

 dead			: boolean;
 hold			: boolean;
 ballx,bally		: integer;
 bsx,bsy		: integer;
 hp1,hp2,hp3,hp4	: integer;
 tx,ty			: integer;
 ltx,lty		: integer;
 tblk			: integer;
 balls			: integer;
 bricks			: integer;
 score			: longint;
 playtime		: longint;
 spd			: integer;

 bounce			: boolean;
 goodieanim		: array[0..15,0..1] of integer;
 goodiex,goodiey	: array[0..15] of integer;
 goodieu		: array[0..15] of integer;
 gc			: integer;

 stuff			: integer;

 curbat			: integer;
 curbatsize		: integer;

 shoot			: integer;
 bigbat			: boolean;
 sticky			: boolean;
 superball		: boolean;
 ballspr		: integer;
 sdelay			: integer;

 ax,ay,aa		: array[0..15] of integer;
 ac			: integer;

 tstr			: string;
 ftx			: array[0..15] of integer;
 fty			: array[0..15] of integer;
 ftu			: array[0..15] of integer;
 fts			: array[0..15] of string;
 ftc			: integer;

 bhdx			: integer;
 curlevel		: integer;

 nukefade		: boolean;
 nukefadecount		: integer;
 nux,nuy		: integer;
 bkanimstore		: integer;

 ztpix			: array[0..511,0..1] of integer;
 ztactive		: integer;
 ztpixcount		: integer;
{
 BaseIO: word; IRQ, DMA, DMA16: byte;
 Sound: array[0..NumSounds-1] of PSound;}
 i: byte;
 Counter: LongInt;
 InKey: char;
 Stop: boolean;
 Num: byte;
 Temp: integer;
 OldExitProc: pointer;

 procedure ztext(txt:string); forward;
{
  procedure OurExitProc; far;
   {If the program terminates with a runtime error before the extended memory}
   {is deallocated, then the memory will still be allocated, and will be lost}
   {until the next reboot.  This exit procedure is ALWAYS called upon program}
   {termination and will deallocate extended memory if necessary.            }
{    var
      i: byte;
    begin
      for i := 0 to NumSounds-1 do
        if Sound[i] <> nil then FreeSound(Sound[i]);
      if SharedEMB then ShutdownSharing;
      ExitProc := OldExitProc; {Chain to next exit procedure}
{    end;

{ *************	Init stuff ************************************************* }
procedure init;
begin
 randomize;
{
 if not(GetSettings(BaseIO, IRQ, DMA, DMA16)) then begin
  writeln('Error initializing:  Invalid or non-existant BLASTER environment variable');
  Halt(1); {BLASTER environment variable invalid or non-existant}
{ end else begin
  if not(InitSB(BaseIO, IRQ, DMA, DMA16)) then begin
   writeln('Error initializing sound card');
   writeln('Incorrect base IO address, sound card not installed, or broken');
   Halt(2); {Sound card could not be initialized}
{  end;
  write('DSP version ', DSPVersion:0:2, ':  ');
  if SixteenBit then write('16-bit, ') else write('8-bit, ');
  if AutoInit then writeln('Auto-initialized')
  else writeln('Single-cycle');
  if not(InitXMS) then begin
   writeln('Error initializing extended memory');
   writeln('HIMEM.SYS must be installed');
   Halt(3); {XMS driver not installed}
{  end else begin
   writeln('Extended memory succesfully initialized');
   write('Free XMS memory:  ', GetFreeXMS, 'k  ');
   if GetFreeXMS < XMSRequired then begin
    writeln('Insufficient free XMS');
    writeln('You are probably running MIXTEST from the protected mode IDE');
    writeln('Run it from the command line or read the documentation');
    Halt(4); {Insufficient XMS memory}
{   end else begin
    writeln('Loading sounds');
    if SharedEMB then InitSharing;
    LoadSound(Sound[0], 'crash.smp');
    LoadSound(Sound[1], 'laser.smp');
    LoadSound(Sound[2], 'nuke.smp');
    LoadSound(Sound[3], 'bump.smp');
    LoadSound(Sound[4], 'tnt.smp');
    OldExitProc := ExitProc;
    ExitProc := @OurExitProc;
   end
  end;
  InitMixing;
 end;
}
{ readkey;}

 setgfx;
 setvirtual;
 cls(0,vaddr);
 loadpal('gscr.pal');
 raw2sprite('ball.raw',8,8,2,ball);
 raw2sprite('bat.raw',48,12,6,bat);
 raw2sprite('blocks.raw',20,6,64,blocks);
{ readkey;}
 raw2sprite('qmark.raw',18,18,16,qmark);
 sethotspot(ball,3,3);
 sethotspot(bat,24,4);
 sethotspot(qmark,9,0);
 setrgb(1,0,0,24);
 for banim:=3 to 5 do setrgb(banim,6+banim*2,6+banim*2,6+banim*2);
 for banim:=0 to 2047 do stab[banim]:=trunc(sin(banim*pi/90)*8);
 for banim:=0 to 4095 do begin
  suh[banim]:=3+random(3);
 end;
 bkanim:=0;
 bar(0,0,16,16,0,vga);
 preparesprite(16,16,1,cursor);

 asm
 	mov	ax,01h
        int	033h
 	mov	ax,04h
        mov	cx,0
        mov	dx,1
        int	033h
 end;

 grabspriteimage(1,0,cursor,0,vga);
 asm
 	mov	ax,02h
        int	033h
 end;
 for bsy:=0 to 29 do for bsx:=0 to 11 do level[bsx,bsy]:=0;

end;

function biu(blk:integer):boolean;
var
 tmb	: integer;
begin
 biu:=false;
 if blk=0 then exit;
 tmb:=(blk-1) and 7;
 if (tmb=0) or (tmb=1) or (tmb=2) then biu:=true;
end;
{ *************	Clean up procedure ***************************************** }
procedure quit;
begin
{ ShutdownMixing;
 ShutdownSB;
 for i := 0 to NumSounds-1 do FreeSound(Sound[i]);
 if SharedEMB then ShutdownSharing;}
 freevirtual;
 settxt;
end;

{ *************	Update mouse variables ************************************* }
procedure updmouse; assembler;
asm

	mov	ax,03h
        int	033h
        shr	cx,1
        mov	XMouse,cx
        mov	YMouse,dx
        mov	BMouse,bx

	mov	BatX,cx
{       mov	ax,0bh
        int	033h

        sar	cx,2
        add	BatX,cx
}
end;

{ *************	Double buffering functions ********************************* }
{ ------------- Show virtual screen ---------------------------------------- }
procedure showvirtual; assembler;
asm
	push	ds
        mov	ax,0a000h
        mov	es,ax
        mov	ax,[vaddr]
        mov	ds,ax
        xor	di,di
        xor	si,si
	add	si,8*320+8
        add	di,8*320+8
	mov	dx,189
@ylp:
        mov	cx,50
        db	66h
        rep	movsw
        add	si,320-200
        add	di,320-200
	dec	dx
        jnz	@ylp

        pop	ds
end;
{ ------------- Clear virtual screen --------------------------------------- }
procedure clearvirtual; assembler;
asm
	push	ds
        mov	ax,[vaddr]
        mov	es,ax
        mov	ds,ax
        xor	di,di
        xor	si,si
	add	si,8*320+8
        add	di,8

        db	66h
        xor	ax,ax

	mov	dx,200
@ylp:   mov	cx,50
        db	66h
        rep	stosw
{        add	si,320-200}
        add	di,320-200
	dec	dx
        jnz	@ylp

        pop	ds
end;
{ *************	Generate random level ************************************** }
procedure randommap;
var
 mx,my		: integer;
begin
 for my:=0 to 29 do for mx:=0 to 11 do level[mx,my]:=0;

 bneeded:=0;

 for my:=1 to 20 do for mx:=1 to 10 do begin
  if random(3)=1 then begin
   level[mx,my]:=3+(random(7)*8);
   if level[mx,my]<40 then begin
    if random(5)=1 then begin
     dec(level[mx,my]);
     if random(5)=1 then begin
      dec(bneeded);
      dec(level[mx,my]);
     end;
    end;
   end;
   inc(bneeded);
  end;
 end;

{
 bneeded:=0;
 for my:=1 to 20 do for mx:=1 to 10 do begin
  level[mx,my]:=51;
  inc(bneeded);
 end;
}
end;
{ *************	Generate background **************************************** }
procedure background;
var
 dx,dy,y	: integer;

 dfx,dfy	: integer;
 doff,doff2	: integer;
 fs,fo		: word;
 px,py		: integer;
 edy,edx	: integer;
 voff		: word;
begin
 if bkanim<>4 then begin
  clearvirtual;
 end;
 if bkanim=0 then exit;

{ setrgb(0,16,0,0);}

 if bkanim=1 then begin
  inc(banim); if banim>15 then banim:=0;
  dx:=16+banim;
  for y:=0 to 11 do begin
   line(8,dx,dx,8,1,vaddr);
   inc(dx,16);
  end;
  dx:=16-banim;
  for y:=0 to 11 do begin
   line(208,200-dx,208-dx,200,1,vaddr);
   inc(dx,16);
  end;
 end;

 if bkanim=2 then begin
  inc(banim,1); if banim>179 then dec(banim,180);
  doff:=banim;
  dy:=8;
  for dfy:=0 to 19 do begin
   dx:=8;
   for dfx:=0 to 20 do begin
    doff2:=doff+(dfx shl 2);
    px:=stab[doff2];
    py:=stab[doff2 shl 1+90];
    plot(dx+px,dy+py,1,vaddr);
    inc(dx,10);
   end;
   inc(doff,16);
   inc(dy,10);
  end;
 end;

 if bkanim=3 then begin
  inc(banim,1); if banim>179 then dec(banim,180);
  doff:=banim;
  dy:=8;
  for dfy:=0 to 9 do begin
   edx:=0;
   edy:=dy;
   dx:=8;
   for dfx:=0 to 21 do begin
    doff2:=doff+(dfx shl 2);
    px:=stab[doff2];
    py:=stab[doff2 shl 1+70];
    line(edx,edy,dx+px,dy+py,1,vaddr);
{    plot(dx+px,dy+py,1,vaddr);}
    edx:=dx+px; edy:=dy+py;
    inc(dx,10);
   end;
   edx:=0;
   inc(doff,12);
   inc(dy,20);
  end;
 end;

 if bkanim=4 then begin
{  inc(banim,1); if banim>179 then dec(banim,180);}
  for doff:=0 to 95 do begin
   fs:=seg(suh);
   fo:=ofs(suh)+random(800)*4;
   voff:=2560+doff*320+8;
   for dx:=0 to 49 do begin
    meml[vaddr:voff]:=meml[fs:fo];
    meml[vaddr:voff+30400]:=meml[fs:fo];
    inc(fo,4); inc(voff,4);
   end;
  end;
 end;

end;
{ *************	Draw the bricks ******************************************** }
procedure showblocks;
var
 x,y	: integer;
 dx,dy	: integer;
 mb	: integer;
 m7	: integer;
 tb	: integer;
begin
 background;
{ setrgb(0,8,16,8);}
 inc(blockanim);
 if blockanim>3 then blockanim:=0;
 if blockanim=0 then bac:=1 else bac:=0;
  dy:=8;
  for y:=0 to 27 do begin
   dx:=8;
   for x:=0 to 9 do begin
    mb:=level[x+1,y+1];
    if mb>0 then begin
     if mb>52 then begin
      pastesprite(blocks,dx,dy,mb,vaddr);
      if mb=53 then begin
       {StopSound(4);
       StartSound(Sound[4], 4, false);}
       level[x+1,y+1]:=54;
       dec(bneeded);
       tb:=(level[x,y+1]-1) and 7;
       if (tb=1) or (tb=2) then inc(level[x,y+1]);
       tb:=(level[x+1,y]-1) and 7;
       if (tb=1) or (tb=2) then inc(level[x+1,y]);
       tb:=(level[x+2,y+1]-1) and 7;
       if (tb=1) or (tb=2) then inc(level[x+2,y+1]);
       tb:=(level[x+1,y+2]-1) and 7;
       if (tb=1) or (tb=2) then inc(level[x+1,y+2]);
      end else begin
       inc(level[x+1,y+1],bac);
       if level[x+1,y+1]=58 then level[x+1,y+1]:=0;
      end;
     end else begin
      m7:=(mb-1) and 7;
      if m7>2 then begin
       pastesprite(blocks,dx,dy,mb,vaddr);
       inc(level[x+1,y+1],bac);
       if m7=7 then begin
        level[x+1,y+1]:=0;
        dec(bneeded);
       end;
      end else begin
       pastesprite(blocks,dx,dy,mb,vaddr);
      end;
     end;
    end;
    inc(dx,20);
   end;
   inc(dy,6);
  end;
{ end else begin
 end;           }
end;
{ *************	Begin a new game (resets all variables to default) ********* }
procedure newgame;
var
 t	: integer;
begin
 bkanim:=2; banim:=0;
 for t:=0 to 7 do ftu[t]:=0;		{ floating texts }
 ftc:=0;				{ floating text count }
 for t:=0 to 7 do goodieu[t]:=0;	{ goodies	 }
 gc:=0;					{ goodiecount	 }

 dead:=false;

 {
 ballx:=100*128;
 bally:=187*128;
 }
 bsx:=64; bsy:=-256;

 hold:=true;		{ ball is in the bat	}
 balls:=5;
 spd:=24;
 score:=0;

 curbat:=0;		{ current bat image }
 curbatsize:=16;	{ currnet bat size  }

 { features	}
 shoot:=0;
 bigbat:=false;
 sticky:=false;
 superball:=false;

 sdelay:=0;
 bhdx:=0;
 batx:=108;
 playtime:=0;
 curlevel:=0;

 nukefade:=false;
 nukefadecount:=0;
end;
{ *************	Launch a floating text ************************************* }
procedure ftext(xpos,ypos:integer; txt:string);
begin
 fts[ftc]:=txt;
 ftu[ftc]:=32;
 ftx[ftc]:=xpos-length(fts[ftc])*4;
 fty[ftc]:=ypos;
 inc(ftc); if ftc>15 then ftc:=0;
end;
{ *************	Launch goodie ********************************************** }
procedure goodie(xpos,ypos:integer);
begin
 goodiex[gc]:=xpos; goodiey[gc]:=ypos;
 goodieu[gc]:=1; goodieanim[gc,0]:=0; goodieanim[gc,1]:=0;
 inc(gc); if gc>15 then gc:=0;
end;
{ *************	fire weapon ************************************************ }
procedure fire(xpos,ypos:integer);
begin
 ax[ac]:=xpos;
 ay[ac]:=ypos;
 aa[ac]:=1;
 inc(ac);
 if ac>15 then ac:=0;
end;
{ *************	Handle goodies, and draw them ****************************** }
procedure DoGoodies;
var
 tc		: integer;
 tnx,tny	: integer;
 again		: boolean;
begin
 for tc:=0 to 15 do begin
  if goodieu[tc]>0 then begin
   drawsprite(qmark,goodiex[tc],goodiey[tc],goodieanim[tc,0],vaddr);
   inc(goodieanim[tc,1]);
   if goodieanim[tc,1]>3 then begin
    goodieanim[tc,1]:=0;
    inc(goodieanim[tc,0]);
    if goodieanim[tc,0]>15 then goodieanim[tc,0]:=0;
   end;
   inc(goodiey[tc]);
   if goodiey[tc]>199 then goodieu[tc]:=0;
   if goodiey[tc]>175 then begin
    if abs(batx-goodiex[tc])<curbatsize then begin
     goodieu[tc]:=0;
     repeat
      again:=false;
      stuff:=random(4)+1;
      if (sticky) and (stuff=3) then again:=true;
{      if (superball) and (stuff=3) then again:=true;}
      if (bigbat) and (stuff=1) then again:=true;
      if (shoot>0) and (stuff=2) then again:=true;
     until not again;
{     stuff:=6;}
     if stuff>4 then stuff:=4;
     if random(20)=1 then stuff:=97;
     if random(20)=8 then stuff:=99;
     if random(20)=0 then stuff:=98;
     if (random(8)=0) and (not superball) then stuff:=96;
     if stuff=1 then begin
      bigbat:=true;
      ftext(goodiex[tc],goodiey[tc],'BigBat');
     end;

     if stuff=3 then begin
      sticky:=true;
      ftext(goodiex[tc],goodiey[tc],'StickyBall');
     end;

     if stuff=2 then begin
      inc(shoot,100);
      ftext(goodiex[tc],goodiey[tc],'Ammo');
     end;
     if stuff=4 then begin
      ftu[ftc]:=random(200)+50;
      inc(score,ftu[ftc]);
      str(ftu[ftc],fts[ftc]);
      fts[ftc]:='+'+fts[ftc];
      ftext(goodiex[tc],goodiey[tc],fts[ftc]);
     end;
     if stuff=96 then begin
      superball:=true;
      ftext(goodiex[tc],goodiey[tc],'SuperBall');
     end;
     if stuff=97 then begin
      bneeded:=0;
      for tny:=1 to 28 do for tnx:=1 to 10 do if level[tnx,tny]>0 then begin
       level[tnx,tny]:=51;
       inc(bneeded);
      end;
{      ftext(goodiex[tc],goodiey[tc],'TNT-Level!');}
      ztext('TNT!')
     end;
     if stuff=98 then begin
{      ftext(goodiex[tc],goodiey[tc],'NUKE!');}
      nukefade:=true;
      nukefadecount:=127;
      ztext('NUKE!')
     end;
     if stuff=99 then begin
      inc(balls,1);
      ztext('XBALL')
{      ftext(goodiex[tc],goodiey[tc]-8,'** EXTRA **');
      ftext(goodiex[tc],goodiey[tc],'** BALL **');}
     end;
    end;
   end;
  end;
 end;
end;
{ *************	Handle ammos, and draw them ******************************** }
procedure doammos;
var
 tc	: integer;
 b7	: integer;
begin
 for tc:=0 to 15 do begin
  if aa[tc]>0 then begin
   dec(ay[tc],6);
   if ay[tc]<0 then aa[tc]:=0;

  if (aa[tc]=1) or (aa[tc]=2) then begin

   if point(ax[tc]-13,ay[tc],vaddr)>127 then begin
    ltx:=(ax[tc]-13-8) div 20+1;
    lty:=(ay[tc]-8) div 6+1;
    tblk:=level[ltx,lty];
    if biu(tblk) then begin
     b7:=(tblk-1) and 7;
     if b7<>0 then begin
      level[ltx,lty]:=tblk+1;
      inc(score,5);
      if aa[tc]=1 then aa[tc]:=3 else aa[tc]:=0;
      if random(20)=1 then begin
       goodiex[gc]:=ax[tc]-13; goodiey[gc]:=ay[tc];
       goodieu[gc]:=1; goodieanim[gc,0]:=0;goodieanim[gc,1]:=0;
       inc(gc); if gc>7 then gc:=0;
      end;
     end else begin
      if aa[tc]=1 then aa[tc]:=3 else aa[tc]:=0;
     end;
    end;
   end;

  end;
  if (aa[tc]=1) or (aa[tc]=3) then begin

   if point(ax[tc]+12,ay[tc],vaddr)>127 then begin
    ltx:=(ax[tc]+12-8) div 20+1;
    lty:=(ay[tc]-8) div 6+1;
    tblk:=level[ltx,lty];
    if biu(tblk) then begin
     b7:=(tblk-1) and 7;
     if b7<>0 then begin
      level[ltx,lty]:=tblk+1;
      inc(score,5);
      if aa[tc]=1 then aa[tc]:=2 else aa[tc]:=0;
      if random(20)=1 then begin
       goodiex[gc]:=ax[tc]+12; goodiey[gc]:=ay[tc];
       goodieu[gc]:=1; goodieanim[gc,0]:=0;goodieanim[gc,0]:=0;
       inc(gc); if gc>7 then gc:=0;
      end;
     end else begin
      if aa[tc]=1 then aa[tc]:=2 else aa[tc]:=0;
     end;
    end;
   end;

  end;

  if aa[tc]>0 then drawsprite(bat,ax[tc],ay[tc],2+aa[tc],vaddr);
  end;
 end;
end;
{ *************	Handle texts, and draw them ******************************** }
procedure dofloattexts;
var
 tc		: integer;
begin
 for tc:=0 to 15 do begin
  if ftu[tc]>0 then begin
   dec(ftu[tc]);
   dec(fty[tc]);
   if fty[tc]<0 then ftu[tc]:=0;
   textdestseg:=vaddr;
{    text( ftx[tc]-1,fty[tc],0,fts[tc]);
    text( ftx[tc]+1,fty[tc],0,fts[tc]);
    text( ftx[tc],fty[tc]-1,0,fts[tc]);
    text( ftx[tc],fty[tc]+1,0,fts[tc]);}
   text( ftx[tc],fty[tc],31-(ftu[tc] shr 1),fts[tc]);
   textdestseg:=vga;
  end;
 end;
end;
{ *************	Go to a new level ****************************************** }
function loadlevel(num:integer):boolean;
var
 f	: file;
 nim	: string;
 cx,cy	: integer;
 tc	: integer;
 incl	: boolean;
 cc	: integer;
const
 blkar		: array[0..12] of integer = (2,3,10,11,18,19,26,+
 		  27,34,35,42,43,51);
begin
 str(num,nim);
 nim:='lev.'+nim;
 assign(f,nim);
 {$I-}
 reset(f,1);
 if ioresult=0 then begin
  blockread(f,level,12*30);
  close(f);
  loadlevel:=true;
  bneeded:=0;
  for cy:=1 to 28 do for cx:=1 to 10 do begin
   tc:=level[cx,cy];
   incl:=false;
   for cc:=0 to 12 do if blkar[cc]=tc then incl:=true;
   if incl then inc(bneeded);
  end;

 end else begin
  loadlevel:=false;
 end;
 {$I+}
 leveldelay:=0;
end;

procedure new_level;
var
 x,y,mb		: integer;
 off		: integer;
 by		: integer;
 dx,dy		: integer;
 off2		: integer;
 style		: integer;
 kukko		: string;
begin
 bally:=187*128;
 bsx:=32; bsy:=-256;
 sticky:=false;
 bigbat:=false;
 superball:=false;
 hold:=true;
 if not loadlevel(curlevel) then randommap;
 inc(curlevel);
 spd:=24;
 inc(bkanim); if bkanim>4 then bkanim:=1;

 str(curlevel-1,kukko);
 kukko:='LEVEL '+kukko;

 textdestseg:=vaddr;
 style:=random(2);
 if style=0 then begin
  for off:=0 to 49 do begin
   background;
   text(100-length(kukko)*4,100,16,kukko);
   dy:=8;
   for y:=1 to 28 do begin
    dx:=208-(off*4);
    for x:=1 to 10 do begin
     by:=level[x,y];
     if by>0 then drawsprite(blocks,dx,dy,by,vaddr);
     inc(dx,20);
    end;
    inc(dy,6);
   end;
   waitvbl;
   showvirtual;
  end;
 end;
 if style=1 then begin
  for off:=0 to 47 do begin
   background;
   text(100-length(kukko)*4,100,16,kukko);
   dy:=199-(off*4);
   for y:=1 to 28 do begin
    if dy<199 then begin
     dx:=8;
     for x:=1 to 10 do begin
      by:=level[x,y];
      if by>0 then drawsprite(blocks,dx,dy,by,vaddr);
      inc(dx,20);
     end;
    end;
    inc(dy,6);
   end;
   waitvbl;
   showvirtual;
  end;
 end;
 textdestseg:=vga;

end;
{ *************	Show player stats ****************************************** }
procedure updateinfos;
begin
 bar(268,33,315,80,139,vga);
 str(balls,tstr);
 text(270,34,0,tstr);
 str(score,tstr);
 text(270,43,0,tstr);
 str(bneeded,tstr);
 text(270,52,0,tstr);
 str(shoot,tstr);
 text(270,61,0,tstr);
 str(curlevel-1,tstr);
 text(270,70,0,tstr);
end;
{ ************************************************************************** }
{ *************	level editor *********************************************** }
{ ************************************************************************** }
procedure savelevel(nimi:string);
var
 f	: file;
 s	: searchrec;
 li	: integer;
 maxlev	: integer;
 code	: integer;
begin
 maxlev:=0;
 if nimi='lev.+' then begin
  FindFirst('lev.*',Archive,s);
  while DosError = 0 do begin
   val(copy(s.name,pos('.',s.name)+1,255),li,code);
   if li>maxlev then maxlev:=li;
   FindNext(s);
  end;
  maxlev:=maxlev+1;
  str(maxlev,nimi);
  nimi:='lev.'+nimi;
  text(12,50,16,nimi);
 end;
 assign(f,nimi);
 rewrite(f,1);
 blockwrite(f,level,12*30);
 close(f);
end;

procedure leved;
var
 done		: boolean;
 ch		: char;
 cblok		: integer;

 emx,emy,emb	: integer;
 rmx,rmy,rmb	: integer;
 rx,ry		: integer;
 ln		: char;
 lns		: string;
 tln		: integer;
 code		: integer;
 clx,cly	: integer;

const
 maxbloks	 = 14;
 blkar		: array[0..maxbloks] of integer = (0,1,2,3,10,11,18,19,26,+
 		  27,34,35,42,43,51);
 dmode		: boolean = false;
begin
 done:=false;
 loadraw('gscr.raw',vga);
{
 asm
  mov ax,01h
  int 033h;
 end;
}
 cblok:=0;
 emx:=0; emy:=0;
 while not done do begin
  waitvbl;
  bar(259,99,280,106,0,vga);
  pastesprite(blocks,260,100,blkar[cblok],vga);
  clearvirtual;

  asm
	mov	ax,03h
	int	033h
        shr	cx,1
        mov	emx,cx
        mov	emy,dx
        mov	emb,bx
  	mov	rmx,cx
        mov	rmy,dx
  end;

  if emx<8 then emx:=8;
  if emy<8 then emy:=8;
  if emx>207 then emx:=207;
  if emy>168 then emy:=168;

  emx:=(emx-8) div 20;
  emy:=(emy-6) div 6;

  showblocks;
  rx:=emx*20+8;
  ry:=emy*6+8;

  line(rx,ry,rx+19,ry,16,vaddr);
  line(rx+19,ry,rx+19,ry+5,16,vaddr);
  line(rx,ry,rx,ry+5,16,vaddr);
  line(rx,ry+5,rx+19,ry+5,16,vaddr);
{  bar(emx*20+8,emy*6+8,emx*20+27,emy*6+13,16,vaddr);}
{
  if ch='7' then begin
   if level[emx+1,emy+1]<>0 then level[emx+1,emy+1]:=0 else level[emx+1,emy+1]:=blkar[cblok];
  end;
  if ch='9' then begin
   level[emx+1,emy+1]:=0;
  end;
  if ch=#13 then dmode:=not dmode;
  if dmode then level[emx+1,emy+1]:=blkar[cblok];
}
  if emb=1 then begin
   level[emx+1,emy+1]:=blkar[cblok];
  end;
  if emb=2 then begin
   level[emx+1,emy+1]:=0;
  end;

  drawsprite(cursor,rmx,rmy,0,vaddr);
  showvirtual;


  if keypressed then ch:=readkey else ch:=#0;
  if ch=#27 then done:=true;
  if ch='s' then begin
   bar(8,22,207,32,0,vga);
   lns:='';
   text(12,12,16,'Level number to save?:');
   repeat
    if keypressed then ln:=readkey else ln:=#0;
    if (ln<>#0) and (ln<>#13) then begin
     if ln=#8 then begin
      lns:=copy(lns,1,length(lns)-1);
      bar(8,22,207,32,0,vga);
      text(12,22,18,lns);
     end else begin
      lns:=lns+ln;
      text(12,22,18,lns);
     end;
    end;
   until ln=#13;
   if lns<>'' then begin
    savelevel('lev.'+lns);
    text(12,32,16,'Level saved.');
    readkey;
   end;
  end;

  if ch='l' then begin
   lns:='';
   text(12,12,16,'Level number to load?:');
   repeat
    if keypressed then ln:=readkey else ln:=#0;
    if (ln<>#0) and (ln<>#13) then begin
     lns:=lns+ln;
     text(12,22,18,lns);
    end;
   until ln=#13;
   if lns<>'' then begin
    val(lns,tln,code);
    loadlevel(tln);
   end;
  end;
  if ch='+' then begin
   inc(cblok); if cblok>maxbloks then cblok:=0;
  end;
  if ch='-' then begin
   dec(cblok); if cblok<0 then cblok:=maxbloks;
  end;

  if ch='c' then begin
   for cly:=0 to 29 do for clx:=0 to 11 do level[clx,cly]:=0;
  end;
{
  if ch='6' then inc(emx);
  if ch='4' then dec(emx);
  if ch='8' then dec(emy);
  if ch='5' then inc(emy);}
  if emx<0 then emx:=0;
  if emy<0 then emy:=0;
  if emx>9 then emx:=9;
  if emy>27 then emy:=27;
 end;

end;

procedure effect(blk:integer);
var
 m7	: integer;
begin
 if blk>0 then begin
  m7:=(blk-1) and 7;
  if (blk>0) and (blk<50) then begin
   if m7>1 then begin
{    StopSound(0);
    StartSound(Sound[0], 0, false);}
   end else begin
    if not superball then begin
{     StopSound(3);
     StartSound(Sound[3], 3, false);}
    end;
   end;
  end else if blk>49 then begin
{   StopSound(4);
   StartSound(Sound[4], 4, false);}
  end;
 end;
end;

procedure ztext(txt:string);
var
 x,y,c		: integer;
begin
 ztactive:=1;
 textdestseg:=vaddr;
 bar(0,0,47,7,0,vaddr);
 text(0,0,255,txt);
 ztpixcount:=0;
 for y:=0 to 7 do begin
  for x:=0 to 63 do begin
   if point(x,y,vaddr)=255 then begin
    ztpix[ztpixcount,0]:=(x-length(txt)*4);
    ztpix[ztpixcount,1]:=(y-4);
    inc(ztpixcount);
   end;
  end;
 end;

 dec(ztpixcount);
 textdestseg:=vga;
end;


procedure doztext;
var
 vc		: integer;
 x,y		: integer;
 zz		: integer;
 strb		: integer;
begin
 if ztactive>0 then begin
  zz:=ztactive;
  if zz>31 then zz:=32;
  strb:=16;
  if zz=32 then begin
   if (ztactive shr 3) mod 2=0 then strb:=16 else strb:=0;
  end;
  if strb=16 then begin
  for vc:=0 to ztpixcount do begin
    x:=(ztpix[vc,0]*zz) div 8;
    y:=(ztpix[vc,1]*zz) div 8;
    plot(108+x,140+y,strb,vaddr);
    plot(109+x,140+y,strb,vaddr);
    plot(108+x,141+y,strb,vaddr);
    plot(109+x,141+y,strb,vaddr);
   end;
  end;
  inc(ztactive);
  if ztactive>95 then ztactive:=0;
 end;
end;

{ ************************************************************************** }
{ *************	Main game program ****************************************** }
{ ************************************************************************** }
begin
 slev:='0';
 if paramcount>0 then slev:=paramstr(1);

 init;
 newgame;
 leved;

 loadraw('gscr.raw',vga);

 val(slev,stlev,pirkko);
 curlevel:=stlev;

 new_level;

 bar(220,33,310,80,139,vga);
 str(balls,tstr);
 text(222,35,141,'Balls: '+tstr);
 text(221,34,0,'Balls: '+tstr);
 str(score,tstr);
 text(222,44,141,'Score: '+tstr);
 text(221,43,0,'Score: '+tstr);
 str(bneeded,tstr);
 text(222,53,141,'Left : '+tstr);
 text(221,52,0,'Left : '+tstr);
 str(shoot,tstr);
 text(222,62,141,'Ammo : '+tstr);
 text(221,61,0,'Ammo : '+tstr);
 text(222,71,141,'Level:');
 text(221,70,0,'Level: ');

 ftext(108,180,'GAME ON!!');
{ ztext('KALLE!');}
 while not dead do begin
  updmouse;
  if batx<22 then batx:=22;
  if batx>194 then batx:=194;
  if hold then begin
   if bmouse=1 then hold:=false;
   ballx:=batx shl 7+bhdx*128;
   bally:=186*128;
  end else begin
   inc(ballx,(bsx*spd) div 32); inc(bally,(bsy*spd) div 32);
   inc(playtime);
  end;

  if playtime>150 then begin
   playtime:=0;
   if spd<128 then inc(spd,1);
  end;

  showblocks;

  if bally<1408 then begin
   bsy:=abs(bsy);
{   StopSound(3);
   StartSound(Sound[3], 3, false);}
  end;

  if ballx<1408 then begin
   bsx:=abs(bsx);
{   StopSound(3);
   StartSound(Sound[3], 3, false);}
  end;
  if ballx>204*128 then begin
   bsx:=-(abs(bsx));
{   StopSound(3);
   StartSound(Sound[3], 3, false);}
  end;
  if bally>186*128 then begin
   if abs( (ballx shr 7)-batx) <curbatsize then begin
    if not sticky then begin
     bsy:=- (abs(bsy));
     bsx:= (((ballx shr 7)-batx) shr 1) *32;
{     StopSound(3);
     StartSound(Sound[3], 3, false);}
    end else begin
     bsy:=- (abs(bsy));
     bsx:= (((ballx shr 7)-batx) shr 1) *32;
     hold:=true;
     bhdx:=(ballx shr 7)-batx;
    end;
   end else begin
    if bally>199 shl 7 then begin
     bigbat:=false;
     sticky:=false;
     superball:=false;
     shoot:=0;
     hold:=true;
     if balls=0 then dead:=true;
     dec(balls);
     spd:=24;
     bsx:=32; bsy:=-256;
     bhdx:=0;
    end;
   end;
  end;

  tx:=ballx shr 7; ty:=bally shr 7;
  hp1:=point(tx,ty-3,vaddr);
  hp2:=point(tx+3,ty,vaddr);
  hp3:=point(tx,ty+3,vaddr);
  hp4:=point(tx-3,ty,vaddr);
  if hp1>127 then begin
   if not superball then bsy:=abs(bsy);
   ltx:=(tx-8) div 20+1;
   lty:=(ty-11) div 6+1;
   tblk:=level[ltx,lty];
   if biu(tblk) then begin
    effect(tblk);
    if tblk and 7>1 then begin
     level[ltx,lty]:=tblk+1;
     bounce:=true;
    end;
   end;
  end;
  if hp2>127 then begin
   if not superball then bsx:=-(abs(bsx));
   ltx:=(tx-5) div 20+1;
   lty:=(ty-8) div 6+1;
   tblk:=level[ltx,lty];
   tblk:=level[ltx,lty];
   if biu(tblk) then begin
    effect(tblk);
    if tblk and 7>1 then begin
     level[ltx,lty]:=tblk+1;
     bounce:=true;
    end;
   end;
  end;
  if hp3>127 then begin
   if not superball then bsy:=-(abs(bsy));
   ltx:=(tx-8) div 20+1;
   lty:=(ty-5) div 6+1;
   tblk:=level[ltx,lty];
   if biu(tblk) then begin
    effect(tblk);
    if tblk and 7>1 then begin
     level[ltx,lty]:=tblk+1;
     bounce:=true;
    end;
   end;
  end;
  if hp4>127 then begin
   if not superball then bsx:=(abs(bsy));
   ltx:=(tx-11) div 20+1;
   lty:=(ty-8) div 6+1;
   tblk:=level[ltx,lty];
   if biu(tblk) then begin
    effect(tblk);
    if tblk and 7>1 then begin
     level[ltx,lty]:=tblk+1;
     bounce:=true;
    end;
   end;
  end;

  if bounce then begin
   inc(score,5);
   if superball then begin
    if random(40)=12 then goodie(tx,ty);
   end else begin
    if random(10)=4 then goodie(tx,ty);
   end;
   bounce:=false;
  end;

  if shoot>0 then begin
   curbat:=2; curbatsize:=22;
   if sdelay>0 then dec(sdelay);
   if bmouse=2 then begin
    if sdelay=0 then begin
     fire(batx,190);
     sdelay:=4;
     dec(shoot);
{     stopsound(1);
     StartSound(Sound[1], 1, false);}
    end;
   end;
  end else begin
   if bigbat then begin
    curbat:=1; curbatsize:=22;
   end else begin
    curbat:=0; curbatsize:=16;
   end;
  end;

  if superball then ballspr:=1 else ballspr:=0;
  drawsprite(bat,batx,190,curbat,vaddr);
  drawsprite(ball,ballx shr 7,bally shr 7,ballspr,vaddr);
  dogoodies;
  doammos;
  dofloattexts;
  doztext;
  updateinfos;
{  setrgb(0,8,8,16);}
  waitvbl;
  if nukefade then begin
   if nukefadecount=127 then begin
    bkanimstore:=bkanim;
    bkanim:=0;
    for nuy:=1 to 28 do for nux:=1 to 10 do if level[nux,nuy]>0 then level[nux,nuy]:=52;
   end;
   if nukefadecount>95 then begin
    stuff:=63-(nukefadecount-96)*2;
    setrgb(0,stuff,stuff,stuff);
   end;
   if nukefadecount<64 then begin
    stuff:=nukefadecount;
    setrgb(0,stuff,stuff,stuff);
   end;
   if nukefadecount>0 then dec(nukefadecount);
   if nukefadecount=80 then begin
{    StartSound(Sound[2], 2, false);}
   end;
  end;
{  setrgb(0,0,0,0);}
  showvirtual;

  if keypressed then begin
   rkey:=readkey;
   if rkey=#27 then dead:=true;
   if rkey='+' then inc(shoot,10);
   if rkey='n' then begin bneeded:=0; leveldelay:=1; end;
  end;
  if (bneeded<=0) and (leveldelay=0) then begin
   bsx:=0; bsy:=0; spd:=0;
   leveldelay:=150;
  end;
  if leveldelay>1 then dec(leveldelay);
  if leveldelay=140 then begin
   inc(score,1000);
   ftext(108,150,'Level Complete');
   ftext(108,160,'Bonus +1000');
  end;
  if leveldelay=1 then begin
   if bkanimstore<>0 then begin
    bkanim:=bkanimstore;
    bkanimstore:=0;
   end;
   new_level;
  end;
 end;
 quit;
end.
