Unit MiscVGA;
INTERFACE
var
 VirScr		: Pointer;
 Vaddr		: word;

const
 VGA		: word = $a000;

procedure bar(x1,y1,x2,y2:integer; color:integer; where:word);
procedure SetVirtual;
procedure FreeVirtual;
PROCEDURE SetRGB(Nr,R,G,B:Byte);
procedure SetGfx;
procedure SetTxt;
procedure Cls(colour:byte; segm:word);
procedure Plot(x,y,c,segm : word);
function Point(x,y:integer; segm:word):integer;
procedure Flip(source,dest:word);
procedure WaitVbl;
procedure loadraw(fname:string; where:word);
procedure saveraw(fname:string; where:word);
procedure line(x1,y1,x2,y2:integer; color:byte; where:word);

IMPLEMENTATION
procedure bar(x1,y1,x2,y2:integer; color:integer; where:word);
var
 xk,yk,xmod	: integer;
begin
 if x1>x2 then begin
  xk:=x1; x1:=x2; x2:=xk;
 end;
 if y1>y2 then begin
  yk:=y1; y1:=y2; y2:=yk;
 end;
 xk:=x2-x1+1;
 yk:=y2-y1+1;
 xmod:=320-xk;
 asm
	mov	ax,where
	mov	es,ax
        cld

        mov	ax,y1
        mov	di,ax
        shl	ax,8
        shl	di,6
        add	di,ax
	add	di,x1

        mov	dx,yk
@ylp:	mov	cx,xk
        mov	ax,color
        rep	stosb
        add	di,xmod
        dec	dx
        jnz	@ylp
 end;
end;

procedure SetVirtual; begin
 GetMem(VirScr,65535);
 Vaddr:=Seg(VirScr^);
end;

procedure FreeVirtual; begin
 FreeMem(VirScr,65535);
end;

PROCEDURE SetRGB(Nr,R,G,B:Byte);
BEGIN
    Port[$3C8]:=Nr;
    Port[$3C9]:=R;
    Port[$3C9]:=G;
    Port[$3C9]:=B;
END;

procedure SetGfx; assembler;
asm
	mov	ax,13h
        int	10h
end;
procedure SetTxt; assembler;
asm
	mov	ax,3h
        int	10h
end;

procedure Cls(colour:byte; segm:word); assembler;
asm
        mov	ax,segm
        mov	es,ax
        db      066h
        xor	di,di
        db	066h
        xor	ax,ax
        mov	cx,16000
        db	66h
        rep	stosw
end;

procedure Plot(x,y,c,segm : word); assembler;
asm
        mov	ax,[segm]
	mov	es,ax
        mov	ax,[y]
        mov	di,ax
        shl	ax,8
        shl	di,6
        add	di,ax
	add	di,[x]
        mov	ax,[c]
        mov	[es:di],al
end;

function Point(x,y:integer; segm:word):integer; assembler;
asm
        mov	ax,0
        cmp	x,0
        jl	@PntExit
        cmp	x,319
        jg	@PntExit
        cmp	y,0
        jl	@PntExit
        cmp	y,190
        jg	@PntExit

        mov	ax,[segm]
	mov	es,ax
        mov	ax,[y]
        mov	di,ax
        shl	ax,8
        shl	di,6
        add	di,ax
	add	di,[x]
        mov	ax,[es:di]
        xor	ah,ah
@PntExit:
end;

procedure Flip(source,dest:word); assembler;
asm
	push	ds
        mov	ax,[dest]
        mov	es,ax
        mov	ax,[source]
        mov	ds,ax
        xor	di,di
        xor	si,si
        mov	cx,16000
        db	66h
        rep	movsw
        pop	ds
end;

procedure WaitVbl; assembler;
label
  l1, l2;
asm
    mov dx,3DAh
l1:
    in al,dx
    and al,08h
    jnz l1
l2:
    in al,dx
    and al,08h
    jz  l2
end;

procedure loadraw(fname:string; where:word);
var
 f	: file;
begin
 assign(f,fname);
 reset(f,1);
 blockread(f,ptr(where,0)^,64000);
 close(f);
end;

procedure saveraw(fname:string; where:word);
var
 f	: file;
begin
 assign(f,fname);
 rewrite(f,1);
 blockwrite(f,ptr(where,0)^,64000);
 close(f);
end;

procedure Line(x1, y1, x2, y2 : integer; color : byte; where:word);
var
    deltax, deltay, numpixels,
    d, dinc1, dinc2,
    xinc1,xinc2,yinc1,yinc2	: integer;
    screen			: word;
    screeninc1, screeninc2	: integer;
begin
  { Calculate deltax and deltay for initialisation }
  deltax := abs(x2 - x1);
  deltay := abs(y2 - y1);
  { Initialize all vars based on which is the independent variable }
  if deltax >= deltay then begin { x is independent variable }
      numpixels := deltax + 1;
      d := (2 * deltay) - deltax;
      dinc1 := deltay Shl 1;
      dinc2 := (deltay - deltax) shl 1;
      xinc1 := 1;
      xinc2 := 1;
      yinc1 := 0;
      yinc2 := 1;
    end else begin { y is independent variable }
      numpixels := deltay + 1;
      d := (2 * deltax) - deltay;
      dinc1 := deltax Shl 1;
      dinc2 := (deltax - deltay) shl 1;
      xinc1 := 0;
      xinc2 := 1;
      yinc1 := 1;
      yinc2 := 1;
    end;

  { Make sure x and y move in the right directions }
  if x1 > x2 then
    begin
      xinc1 := - xinc1;
      xinc2 := - xinc2;
    end;
  if y1 > y2 then
    begin
      yinc1 := - yinc1;
      yinc2 := - yinc2;
    end;

  { Start drawing at <x1, y1> }
  screen := word(y1) * 320 + x1;
  screeninc1 := yinc1 * 320 + xinc1;
  screeninc2 := yinc2 * 320 + xinc2;

  { Draw the pixels }
  asm

    { Use as many registers as are available }
    push [where]
    pop es
    mov di, screen
    mov dx, d
    mov al, color
    mov cx, numpixels
    mov bx, dinc1

    @bres1:

    { Draw the current pixel and compare the decision variable to 0 }
    mov es:[di], al
    cmp dx, 0
    jnl @bres2

    { D < 0 }
    add dx, bx { bx = dinc1 }
    add di, screeninc1
    jmp @bres3

    @bres2:

    { D >= 0 }
    add dx, dinc2
    add di, screeninc2

    @bres3:

    loop @bres1
  end;
end;

END.