unit sprgfx;

INTERFACE
type
 sprite		= record
 		xpos	: integer;
                ypos	: integer;
                xsize	: integer;
                ysize	: integer;
                bytesize: integer;
                bmptr	: pointer;
                bkptr	: pointer;
                sseg	: word;
                soff	: word;
                hotx	: integer;
                hoty	: integer;
                imagenum: integer;
                curimage: integer;
                end;
var
 sprpalette	: array[0..255,0..2] of byte;
const
 sclipx1	: integer = 0;
 sclipy1	: integer = 0;
 sclipx2	: integer = 319;
 sclipy2	: integer = 199;

procedure loadpal(pname:string);
procedure raw2sprite(rawname:string;xkoko,ykoko,lukum: integer; var spr:sprite);
procedure sethotspot(var spr:sprite; xoff,yoff:integer);
procedure setspriteclip(x1,y1,x2,y2:integer);
procedure drawsprite(var spr:sprite; x,y,i:integer; where:word);
procedure pastesprite(var spr:sprite; x,y,i:integer; where:word);
procedure preparesprite(xkoko,ykoko,lukum: integer; var spr:sprite);
procedure grabspriteimage(x,y:integer; var spr:sprite; i:integer; fseg:word);

IMPLEMENTATION
uses crt;

procedure loadpal(pname:string);
var
 f	: file;
 c	: integer;
begin
 assign(f,pname);
 reset(f,1);
 blockread(f,sprpalette,768);
 close(f);
 asm
    push ds
    mov	ax,seg sprpalette
    mov	ds,ax
    mov si,offset sprpalette
    mov cx,768
    mov dx,03c8h
    xor al,al
    out dx,al
    inc dx
@1: rep outsb
    pop	ds
 end;
end;

procedure raw2sprite(rawname:string;xkoko,ykoko,lukum: integer; var spr:sprite);
var
 f		: file;
 ss,so		: word;
 pr		: integer;
 rc		: integer;
 x,y		: integer;
 xx,yy		: integer;
 sc		: integer;
begin
 if spr.bmptr<>nil then exit;
 getmem(spr.bmptr,lukum*ykoko*xkoko);
 if spr.bmptr=nil then exit;
 getmem(spr.bkptr,xkoko*ykoko);
 if spr.bkptr=nil then begin
  freemem(spr.bmptr,lukum*ykoko*xkoko);
  exit;
 end;
{
 getmem(spr.cmptr,xkoko*ykoko);
 if spr.cmptr=nil then begin
  freemem(spr.bmptr,lukum*ykoko*xkoko);
  freemem(spr.bkptr,ykoko*xkoko);
  exit;
 end;
}
 ss:=seg(spr.bmptr^);
 so:=ofs(spr.bmptr^);

 spr.sseg:=ss; spr.soff:=so;

 assign(f,rawname);
 reset(f,1);
 blockread(f,ptr($a000,0)^,63999);
 close(f);

 pr:=320 div xkoko;

 xx:=0; yy:=0;

 rc:=pr;
 for sc:=0 to lukum-1 do begin
  for y:=0 to ykoko-1 do for x:=0 to xkoko-1 do begin
   mem[ss:so]:=mem[$a000:(yy+y)*320+(xx+x)];
{   mem[$a000:(yy+y)*320+(xx+x)]:=5;}
   inc(so);
  end;
  inc(xx,xkoko);
  if xx>320-xkoko then begin
   inc(yy,ykoko);
   xx:=0;
  end;
 end;

 spr.xpos:=0; spr.ypos:=0;
 spr.xsize:=xkoko; spr.ysize:=ykoko;
 spr.bytesize:=xkoko*ykoko;
 spr.hotx:=0; spr.hoty:=0;
 spr.imagenum:=lukum; spr.curimage:=0;

end;

procedure preparesprite(xkoko,ykoko,lukum: integer; var spr:sprite);
var
 ss,so		: word;
 cbmp		: word;
begin
 if spr.bmptr<>nil then exit;
 getmem(spr.bmptr,lukum*ykoko*xkoko);
 if spr.bmptr=nil then exit;
 getmem(spr.bkptr,xkoko*ykoko);
 if spr.bkptr=nil then begin
  freemem(spr.bmptr,lukum*ykoko*xkoko);
  exit;
 end;

 ss:=seg(spr.bmptr^);
 so:=ofs(spr.bmptr^);

 spr.sseg:=ss; spr.soff:=so;
 for cbmp:=0 to lukum*ykoko*xkoko-1 do mem[ss:so+cbmp]:=0;

 spr.xpos:=0; spr.ypos:=0;
 spr.xsize:=xkoko; spr.ysize:=ykoko;
 spr.bytesize:=xkoko*ykoko;
 spr.hotx:=0; spr.hoty:=0;
 spr.imagenum:=lukum; spr.curimage:=0;
end;

procedure grabspriteimage(x,y:integer; var spr:sprite; i:integer; fseg:word);
var
 ss,so		: word;
 gx,gy		: integer;
begin
 ss:=spr.sseg;
 so:=spr.soff;
 inc(so,i*spr.bytesize);
 for gy:=y to y+spr.ysize-1 do begin
  for gx:=x to x+spr.xsize-1 do begin
   mem[ss:so]:=mem[fseg:gy*320+gx];
   inc(so);
  end;
 end;
end;

procedure sethotspot(var spr:sprite; xoff,yoff:integer);
begin
 spr.hotx:=xoff;
 spr.hoty:=yoff;
end;

procedure drawsprite(var spr:sprite; x,y,i:integer; where:word);
var
 sseg,soff	: word;
 xs,ys		: word;

 rlx,rly	: word;
 xadd,xadd2	: word;
 mx		: word;
 mx2		: word;

begin
	spr.xpos:=x; spr.ypos:=y;
        spr.curimage:=i;

        dec(x,spr.hotx);
        dec(y,spr.hoty);

 if (x<sclipx1-(spr.xsize-1)) or (x>sclipx2) or (y<sclipy1-(spr.ysize-1)) or (y>sclipy2) then exit;

        xs:=spr.xsize; ys:=spr.ysize;


 mx:=320-xs;
 mx2:=0;
 rlx:=xs; rly:=ys;
 xadd:=0;
 xadd2:=0;

 if x>sclipx2-(spr.xsize-1) then begin
  rlx:=sclipx2+1-x;
 end;
 if y>sclipy2-(spr.ysize-1) then begin
  rly:=sclipy2+1-y;
 end;

 if x<sclipx1 then begin
  xadd:=sclipx1-x;
  xadd2:=xadd;
  dec(rlx,xadd);
 end;
 if y<sclipy1 then begin
  inc(xadd,(sclipy1-y)*320);
  inc(xadd2,(sclipy1-y)*xs);
  dec(rly,sclipy1-y);
 end;

 mx:=320-rlx;
 mx2:=xs-rlx;

{ this code will save the background before draawing sprite --> }
{
	sseg:=seg(spr.bkptr^);
	soff:=ofs(spr.bkptr^);
asm
	push	ds

        mov	si,soff
        mov	ax,[y]
        mov	di,ax
        shl	di,8
        shl	ax,6
        add	di,ax
	add	di,[x]

        mov	dx,ys
        mov	bx,xs

        mov	ax,where
        mov	es,ax
        mov	ax,sseg
        mov	ds,ax

@sloop:	mov	cx,bx
@ss: 	mov	al,es:[di]
	mov	ds:[si],al
	inc	si
	inc	di
	dec	cx
	jnz	@ss
	add	di,320
        sub	di,bx
        dec	dx
        jnz	@sloop

        pop	ds
end;

}
{*************************************************************************}

	sseg:=spr.sseg;
        soff:=spr.soff;
        inc(soff,i*spr.bytesize);
asm
        push	ds
        cld

        mov	si,soff
        add	si,xadd2

        mov	ax,[y]
        mov	di,ax
        shl	di,8
        shl	ax,6
        add	di,ax
	add	di,[x]		{ di = offset in screen }
        add	di,xadd

        mov	dx,rly
        mov	dh,dl
        xor	dl,dl

        mov	ax,mx2
        mov	dl,al

        mov	bx,rlx

        mov	ax,where
        mov	es,ax
        mov	ax,sseg
        mov	ds,ax

{;	mov	dx,ys}

@by:	mov	cx,bx
@bylsi: mov	al,ds:[si]
        cmp	al,0
        je	@trans
	mov	es:[di],al
@trans: inc	si
	inc	di
	dec	cx
	jnz	@bylsi
	add	di,320
        sub	di,bx

        mov	ax,dx
        xor	ah,ah
	add	si,ax
{        add	si,320
        sub	si,bx}
        dec	dh
        jnz	@by
	pop	ds
end;
end;

procedure pastesprite(var spr:sprite; x,y,i:integer; where:word);
var
 sseg,soff	: word;
 xs,ys		: word;
begin
 xs:=spr.xsize;
 ys:=spr.ysize;
 sseg:=spr.sseg;
 soff:=spr.soff;
 inc(soff,i*spr.bytesize);
asm
        push	ds
        cld

        mov	si,soff

        mov	ax,[y]
        mov	di,ax
        shl	di,8
        shl	ax,6
        add	di,ax
	add	di,[x]		{ di = offset in screen }

        mov	dx,ys
        mov	bx,xs

        mov	ax,where
        mov	es,ax
        mov	ax,sseg
        mov	ds,ax

@by:	mov	cx,bx

@bylsi: mov	al,ds:[si]
	test	al,$ff
        jz	@trans
	mov	es:[di],al
@trans:	inc	si
	inc	di
	dec	cx
	jnz	@bylsi
	add	di,320
        sub	di,bx
        dec	dx
        jnz	@by
	pop	ds
end;
end;

procedure setspriteclip(x1,y1,x2,y2:integer);
begin
 sclipx1:=x1; sclipy1:=y1;
 sclipx2:=x2; sclipy2:=y2;
end;

end.

