Uses Key;

Const
      PalMask = $36C;
      PalRegR = $3C7;
      PalRegW = $3C8;
      PalData = $3C9;

      CrsWait = 10;
      MaxFire = 50;
      FadeSpeed = 20;

Type TPalette = Array[0..255] of record R,G,B : Byte; End;

Var
DBuf : Pointer;
SegDB : Word;
F : File;
Pal,NullPal : TPalette;
Spr : Array[1..8] of Pointer;
A,B,C : LongInt;
GameOver : Byte;
X : Integer;
D : ShortInt;
Lev : Integer;
Crs,NCF,BPF : Array[1..50] of record X,Y : Word; End;
NC : Array[1..100] of record X,Y,En : Integer;Xp,Yp : ShortInt; End;
BP : Array[1..100] of record X,Y,En : Integer;Xp,Yp : ShortInt;T : Byte; End;
NCrs,NNC,NNCF,NBP,NBPF : Word;
CrsReFire : Byte;
En,Lives : Integer;

{$L spr}
Procedure Sprites; far; external;

Procedure GrInit;
var a,b,c : longint;
s,o : Word;
Begin
  GetMem(DBuf,64000+16);
  SegDB:=Seg(DBuf^)+1;
  asm
    mov ax,13h
    int 10h
  end;
End;

Procedure GrDone;
Begin
  FreeMem(DBuf,64000+16);
  asm
    mov ax,3
    int 10h
  end;
End;

Procedure PixelD(x,y : Word;Color : Byte); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  Mov al,Byte Ptr color
  Mov es : [di],al
End;

Procedure SetPalReg(index,Red,Green,Blue : Byte);
Begin
  Port[PalMask]:=$FF;
  Port[PalRegW]:=index;
  Port[PalData]:=Red;
  Port[PalData]:=Green;
  Port[PalData]:=Blue;
End;

Procedure SetPalette(Pal : TPalette);
Var I : Byte;
Begin
  For I:=0 to 255 do SetPalReg(I,Pal[I].R,Pal[I].G,Pal[I].B);
End;

Procedure FadePal(Pal : TPalette);
Var A,B : LongInt;
P : TPalette;
T : LongInt;
Begin
  For B:=FadeSpeed downto 0 do
  Begin
    For A:=0 to 255 do
    Begin
      P[A].R:=Trunc(Pal[A].R*B/FadeSpeed);
      P[A].G:=Trunc(Pal[A].G*B/FadeSpeed);
      P[A].B:=Trunc(Pal[A].B*B/FadeSpeed);
    End;
    SetPalette(P);
    T:=MemL[$40:$6c];
    Repeat Until MemL[$40:$6c]-T>=1;
  End;
End;

Procedure LightPal(Pal : TPalette);
Var A,B : LongInt;
P : TPalette;
T : LongInt;
Begin
  For B:=0 to FadeSpeed do
  Begin
    For A:=0 to 255 do
    Begin
      P[A].R:=Trunc(Pal[A].R*B/FadeSpeed);
      P[A].G:=Trunc(Pal[A].G*B/FadeSpeed);
      P[A].B:=Trunc(Pal[A].B*B/FadeSpeed);
    End;
    SetPalette(P);
    T:=MemL[$40:$6c];
    Repeat Until MemL[$40:$6c]-T>=1;
  End;
End;

Procedure ShowDouble; assembler;
asm
  mov ax,0A000h
  mov es,ax
  xor di,di
  xor si,si
  mov cx,32000
  push ds
  mov ds,SegDB
  Cld
  rep movsw
  pop ds
End;

Procedure Cls(Color : Byte); assembler;
asm
  mov ax,0A000h
  mov es,ax
  xor di,di
  mov al,Color
  mov ah,al
  mov cx,32000
  Cld
  rep stosw
End;

Procedure ClsD(Color : Byte); assembler;
asm
  mov es,SegDB
  xor di,di
  mov al,Color
  mov ah,al
  mov cx,32000
  Cld
  rep stosw
End;

Procedure PrintD(S : String;x,y : Word; color : Byte);
Var Segm,i,x1,y1,Off : Word;
  Procedure PrtD(Ch : Char;x,y,off : Word; color : Byte);
  Var WrkSeg,WrkOff,TOff : Word;
  BitMask : Byte;
  Begin
    TOff:=Off;
    WrkSeg:=$F000;
    WrkOff:=$FA6E+(Ord(Ch) shl 3);
    For y:=0 to 7 do
    Begin
      BitMask:=$80;
      For x:=0 to 7 do
      Begin
        If Mem[WrkSeg:WrkOff] and BitMask<>0 then Mem[Segm:(TOff+x)]:=color;
        BitMask:=BitMask shr 1;
      End;
      Inc(TOff,320);
      Inc(WrkOff);
    End;
  End;
Begin
  x1:=x;y1:=y;
  Off:=(y shl 8)+(y shl 6)+x;
  Segm:=SegDB;
  For i:=1 to length(s) do
  Begin
    PrtD(s[i],x1,y1,off,color);
    Inc(x1,8);
    Inc(off,8);
  End;
End;

Procedure ShowTransD(x,y : Word;Spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  push ds
  mov cx,32
  mov bx,32
  lds si,spr
@Met1 :
  push cx
  mov cx,bx
@Met2 :
  mov al,ds:[si]
  cmp al,7
  jz @Met3
  mov es:[di],al
@Met3:
  inc di
  inc si
  loop @Met2
  pop cx
  add di,320
  sub di,bx
  Loop @Met1
  Pop ds
End;

Procedure ShowRevD(x,y : Word;Spr : Pointer); assembler;
Asm
  Mov ax,SegDB
  Mov es,ax
  Mov di,y
  Shl di,6
  Mov bx,di
  Shl di,2
  Add di,bx
  Add di,x
  add di,32
  dec di
  push ds
  mov cx,32
  mov bx,32
  lds si,spr
@Met1 :
  push cx
  mov cx,bx
@Met2 :
  mov al,ds:[si]
  cmp al,7
  jz @Met3
  mov es:[di],al
@Met3:
  dec di
  inc si
  loop @Met2
  pop cx
  add di,320
  add di,bx
  Loop @Met1
  Pop ds
End;

procedure VRT; assembler;
asm
  mov dx,3DAh
@VRT1:
  in al,dx
  test al,8
  jnz @VRT1
@VRT2:
  in al,dx
  test al,8
  jz @VRT2
end;

Procedure ShowAll;
Var S : String;
C : Byte;
Begin
  If D=1 then ShowTransD(X,164,Spr[3]) else
              ShowRevD(X,164,Spr[3]);
  For A:=0 to 31 do PixelD(X+A,195,9);
  PixelD(X+4,196,8); PixelD(X+27,196,8);
  For A:=1 to NCrs do
    ShowTransD(Crs[A].X,Crs[A].Y,Spr[1]);
  For A:=1 to NNC do
    ShowTransD(NC[A].X,NC[A].Y,Spr[2]);
  For A:=1 to NNCF do
    ShowTransD(NCF[A].X,NCF[A].Y,Spr[5]);
  For A:=1 to NBP do
    ShowTransD(BP[A].X,BP[A].Y,Spr[6+BP[A].T]);
  For A:=1 to NBPF do
    ShowTransD(BPF[A].X,BPF[A].Y,Spr[4]);
  Str(Lev,S);
  PrintD('Level: '+S,80,0,13);
  Str(Lives,S);
  ShowTransD(0,0,Spr[3]);
  PrintD(':'+S,40,12,13);
  If En>3 then C:=2;
  If En=3 then C:=3;
  If En<3 then C:=1;
  For A:=1 to En*5 do
    For B:=0 to 5 do
      PixelD(A+40,B,C);
  VRT;
  ShowDouble;
End;

Procedure ChangePos;
Begin
  A:=1;
  While A<=NCrs do
  Begin
    For B:=1 to NNC do
      If (Abs(NC[B].X-Crs[A].X)<16) and (Abs(NC[B].Y-Crs[A].Y)<16) then
      Begin
        Dec(NC[B].En);
        If NC[B].En=0 then
        Begin
          NC[B]:=NC[NNC];
          Dec(NNC);
        End;
        Crs[A].Y:=0;
        Break;
      End;
    For B:=1 to NBP do
      If (Abs(BP[B].X-Crs[A].X)<16) and (Abs(BP[B].Y-Crs[A].Y)<16) then
      Begin
        Dec(BP[B].En);
        If BP[B].En=0 then
        Begin
          BP[B]:=BP[NBP];
          Dec(NBP);
        End;
        Crs[A].Y:=0;
        Break;
      End;
    If Crs[A].Y<2 then
    Begin
      Dec(NCrs);
      If A=NCrs+1 then Break;
      Crs[A]:=Crs[NCrs+1];
    End else
    Begin
      Dec(Crs[A].Y,2);
      Inc(A);
    End;
  End;
  A:=1;
  While A<=NNCF do
  Begin
    If (NCF[A].Y>164-32) and (Abs(NCF[A].X-X)<32) then
    Begin
      Dec(En);
      If En<=0 then GameOver:=2;
      NCF[A].Y:=170;
    End;
    If NCF[A].Y>167 then
    Begin
      Dec(NNCF);
      If A=NNCF+1 then  Break;
      NCF[A]:=NCF[NNCF+1];
    End else
    Begin
      Inc(NCF[A].Y);
      Inc(A);
    End;
  End;
  For A:=1 to NNC do
  Begin
    Inc(NC[A].X,NC[A].XP);
    Inc(NC[A].Y,NC[A].YP);
    If (NC[A].X<0) or (NC[A].X>320-32) then
    Begin
      Dec(NC[A].X,NC[A].XP);
      NC[A].XP:=-NC[A].XP;
      Inc(NC[A].X,NC[A].XP);
    End;
    If (NC[A].Y<0) or (NC[A].Y>128) then
    Begin
      Dec(NC[A].Y,NC[A].YP);
      NC[A].YP:=-NC[A].YP;
      Inc(NC[A].Y,NC[A].YP);
    End;
    If (Random(400)>398) and (NNCF<MaxFire) then
    Begin
      Inc(NNCF);
      NCF[NNCF].X:=NC[A].X;
      NCF[NNCF].Y:=NC[A].Y;
    End;
  End;
  A:=1;
  While A<=NBPF do
  Begin
    If (BPF[A].Y>164-32) and (Abs(BPF[A].X-X)<32) then
    Begin
      Dec(En);
      If En<=0 then GameOver:=2;
      BPF[A].Y:=170;
    End;
    If BPF[A].Y>167 then
    Begin
      Dec(NBPF);
      If A=NBPF+1 then  Break;
      BPF[A]:=BPF[NBPF+1];
    End else
    Begin
      Inc(BPF[A].Y);
      Inc(A);
    End;
  End;
  For A:=1 to NBP do
  Begin
    If BP[A].X<4 then BP[A].XP:=1;
    If BP[A].X>316-32 then BP[A].XP:=-1;
    If BP[A].Y<4 then BP[A].YP:=1;
    If BP[A].Y>124 then BP[A].YP:=-1;
    Inc(BP[A].X,BP[A].Xp);
    Inc(BP[A].Y,BP[A].Yp);
    If Random(100)>95 then
    Begin
      BP[A].XP:=Random(5)-2;
      BP[A].YP:=Random(5)-2;
    End;
    If (Random(500)>498) and (NBPF<MaxFire) then
    Begin
      Inc(NBPF);
      BPF[NBPF].X:=BP[A].X;
      BPF[NBPF].Y:=BP[A].Y;
    End;
  End;
End;

Procedure GetKey;
Begin
  If Pressed[scLeft] then
    If D=1 then D:=-1 else
      If X>0 then Dec(X,2);
  If Pressed[scRight] then
    If D=-1 then D:=1 else
      If X<320-32 then Inc(X,2);
  If Pressed[scSpace] and (CrsReFire=0) then
  Begin
    CrsReFire:=CrsWait;
    Inc(NCrs);
    Crs[NCrs].Y:=153;
    If D=1 then
      Crs[NCrs].X:=X-11 else
      Crs[NCrs].X:=X+12;
  End;
  If CrsReFire>0 then Dec(CrsReFire);
End;

Procedure Init;
Begin
  GameOver:=0;
  En:=5;
  X:=150;
  D:=1;
  NCrs:=0;
  CrsReFire:=0;
  NNC:=Lev+Random(3);
  NNCF:=0;
  For A:=1 to NNC do
  Begin
    NC[A].X:=Random(320-32);
    NC[A].Y:=Random(128);
    NC[A].Xp:=Random(3)-1;
    NC[A].Yp:=Random(3)-1;
    NC[A].En:=5;
  End;
  NBPF:=0;
  NBP:=Lev+Random(3);
  For A:=1 to NBP do
  Begin
    BP[A].X:=Random(320-32);
    BP[A].Y:=Random(128);
    BP[A].XP:=Random(3)-1;
    BP[A].YP:=Random(3)-1;
    BP[A].T:=Random(3);
    BP[A].En:=5;
  End;
  SetPalette(NullPal);
  ClsD(0);
  ShowAll;
  LightPal(Pal);
End;

Begin
  GrInit;
  Install_Handler;
  Cls(0);
  Lives:=5;
  Lev:=1;
  For A:=1 to 8 do
    Spr[A]:=Ptr(Seg(Sprites),Ofs(Sprites)+32*32*(A-1));
  Move(Ptr(Seg(Sprites),Ofs(Sprites)+32*32*8)^,Pal,768);
  FillChar(NullPal,768,0);
  Repeat
    Init;
    Repeat
      ClsD(0);
      ShowAll;
      ChangePos;
      GetKey;
      If (NBP=0) and (NNC=0) then GameOver:=1;
      If Pressed[scEsc] then GameOver:=3;
    Until GameOver<>0;
    FadePal(Pal);
    If GameOver=3 then Break;
    If GameOver=1 then
    Begin
      A:=MemL[$40:$6c];
      Repeat Until MemL[$40:$6c]-A>30;
      Inc(Lev);
      If Lev>30 then
      Begin
        Restore_Handler;
        GrDone;
        WriteLn('You finished the game. Are you cheating?');
        Halt(0);
      End;
    End;
    If GameOver=2 then
    Begin
      Dec(Lives);
      If Lives>0 then
      Begin
        GameOver:=0;
        A:=MemL[$40:$6c];
        Repeat Until MemL[$40:$6c]-A>30;
      End;
    End;
    If GameOver=3 then GameOver:=2;
  Until GameOver=2;
  Restore_Handler;
  GrDone;
  WriteLn('Game Over, Out of life...');
End.