unit key;
interface
const
      scEsc       = 001;
      scSpace     = 057;
      scUp        = 072;
      scLeft      = 075;
      scRight     = 077;
      scDown      = 080;
var
  pressed : array [0..127] of boolean;
  lastpressed : byte;
  lastreleased : byte;
  saveint09 : procedure;
procedure int09handler; interrupt;
procedure install_handler;
procedure restore_handler;
implementation
procedure int09handler;
Begin
 asm
  in al,60h
  mov dl,al
  mov al,20h
  out 20h,al
  cmp dl,0E0h
  je @@finish
  xor dh,dh
  mov si,dx
  and si,007Fh
  test dl,80h
  jnz @@released
    mov [lastpressed],dl
    mov al,true
  jmp @@savestate
  @@released:
    and dl,7Fh
    mov [lastreleased],dl
    mov al,false
  @@savestate:
  mov ds:byte ptr [pressed+si],al
  @@finish:
{  pushf}
 End;
{ SaveInt09;}
end;

procedure install_handler; assembler;
{Begin
  FillChar(Pressed,SizeOf(Pressed),False);
  GetIntVec(9,@SaveInt09);
  SetIntVec(9,@int09handler);
End;}
asm
  xor ax,ax
  mov di,offset pressed
  mov cx,(128+1+1)/2
  cld
  segds rep stosw
  cli
  mov es,ax
  mov ax,es:[09h*4]
  mov bx,es:[09h*4+2]
  mov word ptr [saveint09],ax
  mov word ptr [saveint09+2],bx
  mov es:word ptr [09h*4],offset int09handler
  mov es:word ptr [09h*4+2],cs
  sti
end;

procedure restore_handler;assembler;
{Begin
  SetIntVec(9,@SaveInt09);
End;}
asm
  cli
  xor ax,ax
  mov es,ax
  mov ax,word ptr [saveint09]
  mov bx,word ptr [saveint09+2]
  mov es:[09h*4],ax
  mov es:[09h*4+2],bx
  sti
end;
end.