'$INCLUDE: 'CHOPPER.BI'

MusicFlag = 1
SoundFlag = 1

GameOver

DO

 CheckChopperPos
  IF Missile(1).Flag = 1 OR Missile(2).Flag = 1 THEN
   CheckMissilePos
   CheckHitDetection
  END IF
 
   IF Stp = 16 THEN Stp = 0

    PUT (Chopper(1).XPos, Chopper(1).YPos), Copter(ChopperStepOrder(Stp) * ChopperEPI), PSET
    PUT (Chopper(2).XPos, Chopper(2).YPos), Copter(ChopperStepOrder(Stp + 16) * ChopperEPI), PSET

   Stp = Stp + StepAdd

   CheckKey
  CheckPlayerKeyPress
 MilliDelay Speed

LOOP

SUB ChangeChopperColors

SetPal 13

ScreenOnOff 1

COLOR 15
LOCATE 1, 1: PRINT "PLAYER 1 "
LOCATE 21, 1: PRINT "PRESS <- AND ->"
LOCATE 22, 1: PRINT "ARROW KEYS TO CYCLE"
LOCATE 23, 1: PRINT "THROUGH COLORS";
LOCATE 1, 33: PRINT "PLAYER 2"
LOCATE 21, 28: PRINT "PRESS A AND D"
LOCATE 22, 25: PRINT "TO CYCLE THROUGH"
LOCATE 23, 35: PRINT "COLORS";
LOCATE 25, 1: PRINT "PRESS ESC TO RETURN TO THE OPTIONS MENU";

LINE (160, 0)-(160, 187), 48
LINE (0, 187)-(320, 187), 48

DEF SEG = &HA000
Colr = 58
AddColr = 3

FOR x% = 0 TO 8
 FOR y% = 0 TO 319
  IF POINT(y%, x%) = 15 THEN
   POKE (y% + x% * 320&), Colr
  END IF
  IF POINT(y%, x% + 192) = 15 THEN
   POKE (y% + (x% + 192) * 320&), Colr
  END IF
 NEXT
 IF Colr = 49 OR Colr > 58 THEN AddColr = -AddColr
 Colr = Colr - AddColr
NEXT

Colr = 58
AddColr = 3
FOR x% = 160 TO 167
 FOR y% = 0 TO 319
  IF POINT(y%, x%) = 15 THEN
   POKE (y% + x% * 320&), Colr
  END IF
  IF POINT(y%, (x% + 8)) = 15 THEN
   POKE (y% + (x% + 8) * 320&), Colr
  END IF
  IF POINT(y%, (x% + 16)) = 15 THEN
   POKE (y% + (x% + 16) * 320&), Colr
  END IF
 NEXT
 IF Colr = 49 OR Colr > 58 THEN AddColr = -AddColr
 Colr = Colr - AddColr
NEXT

ScreenOnOff 2

ColorChange:

DO

 K$ = INKEY$

 IF Stp = 16 THEN Stp = 0

  PUT (40, 75), Copter(ChopperStepOrder(Stp) * ChopperEPI), PSET
  PUT (50, 95), Weapon(MissileStepOrder(Stp / 16) * MissileEPI), PSET

  PUT (235, 75), Copter(ChopperStepOrder(Stp + 16) * ChopperEPI), PSET
  PUT (245, 95), Weapon(MissileStepOrder((Stp + 32) / 16) * MissileEPI), PSET

 Stp = Stp + StepAdd

 MilliDelay Speed

LOOP WHILE K$ = ""

SELECT CASE K$
 CASE CHR$(0) + CHR$(75)
  LoopCount(1) = LoopCount(1) - 1
  IF LoopCount(1) = 0 THEN LoopCount(1) = 10
 CASE CHR$(0) + CHR$(77)
  LoopCount(1) = LoopCount(1) + 1
  IF LoopCount(1) = 11 THEN LoopCount(1) = 1
 CASE "A", "a"
  LoopCount(2) = LoopCount(2) - 1
  IF LoopCount(2) = 0 THEN LoopCount(2) = 10
 CASE "D", "d"
  LoopCount(2) = LoopCount(2) + 1
  IF LoopCount(2) = 11 THEN LoopCount(2) = 1
 CASE CHR$(27)
  SetPal 12
  EXIT SUB
END SELECT

ChangePal:

 SELECT CASE LoopCount(1)
  CASE 1
   '//** Red **\\
   Custom(1).Red = 4
   Custom(1).Green = 256
   Custom(1).Blue = 256
  CASE 2
   '//** Dark Teal **\\
   Custom(1).Red = 256
   Custom(1).Green = 2
   Custom(1).Blue = 2
  CASE 3
   '//** Dark Purple **\\
   Custom(1).Red = 2
   Custom(1).Green = 256
   Custom(1).Blue = 2
  CASE 4
   '//** Blue **\\
   Custom(1).Red = 256
   Custom(1).Green = 256
   Custom(1).Blue = 3
  CASE 5
   '//** Yellow **\\
   Custom(1).Red = 3
   Custom(1).Green = 3
   Custom(1).Blue = 256
  CASE 6
   '//** Grey Blue **\\
   Custom(1).Red = 2
   Custom(1).Green = 3
   Custom(1).Blue = 3
  CASE 7
   '//** Pale Yellow **\\
   Custom(1).Red = 3
   Custom(1).Green = 3
   Custom(1).Blue = 2
  CASE 8
   '//** Lavender **\\
   Custom(1).Red = 2
   Custom(1).Green = 2
   Custom(1).Blue = 3
  CASE 9
   '//** Dark Green **\\
   Custom(1).Red = 256
   Custom(1).Green = 2
   Custom(1).Blue = 256
  CASE 10
   '//** Brown **\\
   Custom(1).Red = 3
   Custom(1).Green = 2
   Custom(1).Blue = 256
 END SELECT

 SELECT CASE LoopCount(2)
  CASE 1
   '//** Red **\\
   Custom(2).Red = 4
   Custom(2).Green = 256
   Custom(2).Blue = 256
  CASE 2
   '//** Dark Teal **\\
   Custom(2).Red = 256
   Custom(2).Green = 2
   Custom(2).Blue = 2
  CASE 3
   '//** Dark Purple **\\
   Custom(2).Red = 2
   Custom(2).Green = 256
   Custom(2).Blue = 2
  CASE 4
   '//** Blue **\\
   Custom(2).Red = 256
   Custom(2).Green = 256
   Custom(2).Blue = 3
  CASE 5
   '//** Yellow **\\
   Custom(2).Red = 3
   Custom(2).Green = 3
   Custom(2).Blue = 256
  CASE 6
   '//** Grey Blue **\\
   Custom(2).Red = 2
   Custom(2).Green = 3
   Custom(2).Blue = 3
  CASE 7
   '//** Pale Yellow **\\
   Custom(2).Red = 3
   Custom(2).Green = 3
   Custom(2).Blue = 2
  CASE 8
   '//** Lavender **\\
   Custom(2).Red = 2
   Custom(2).Green = 2
   Custom(2).Blue = 3
  CASE 9
   '//** Dark Green **\\
   Custom(2).Red = 256
   Custom(2).Green = 2
   Custom(2).Blue = 256
  CASE 10
   '//** Brown **\\
   Custom(2).Red = 3
   Custom(2).Green = 2
   Custom(2).Blue = 256
 END SELECT

'//** Chopper 1 Color Range **\\
 FOR t = 15 TO 31
   OUT &H3C8, t
    OUT &H3C9, (-t + 31) * Custom(1).Red
    OUT &H3C9, (-t + 31) * Custom(1).Green
    OUT &H3C9, (-t + 31) * Custom(1).Blue
 NEXT

'//** Chopper 2 Color Range **\\
 FOR t = 15 TO 31
   OUT &H3C8, t + 15
    OUT &H3C9, (-t + 31) * Custom(2).Red
    OUT &H3C9, (-t + 31) * Custom(2).Green
    OUT &H3C9, (-t + 31) * Custom(2).Blue
 NEXT

GOTO ColorChange

END SUB

SUB CheckChopperPos

'//** Check Player 1 Position **\\

 IF Chopper(1).XPos <= 0 THEN
  Chopper(1).XPos = 0
  Chopper(1).Left = 0
 END IF
 IF Chopper(1).XPos >= 120 THEN
  Chopper(1).XPos = 120
  Chopper(1).Right = 0
 END IF
 IF Chopper(1).YPos <= 18 THEN
  Chopper(1).YPos = 18
  Chopper(1).Up = 0
 END IF
 IF Chopper(1).YPos >= 180 THEN
  Chopper(1).YPos = 180
  Chopper(1).Down = 0
 END IF

'//** Check Player 2 Position **\\

 IF Chopper(2).XPos <= 160 THEN
  Chopper(2).XPos = 160
  Chopper(2).Left = 0
 END IF
 IF Chopper(2).XPos >= 280 THEN
  Chopper(2).XPos = 280
  Chopper(2).Right = 0
 END IF
 IF Chopper(2).YPos <= 18 THEN
  Chopper(2).YPos = 18
  Chopper(2).Up = 0
 END IF
 IF Chopper(2).YPos >= 180 THEN
  Chopper(2).YPos = 180
  Chopper(2).Down = 0
 END IF

END SUB

SUB CheckHitDetection

FOR y = 0 TO 17
 IF ((Missile(1).YPos - y) + 3) = ABS(Chopper(2).YPos) AND Missile(1).XPos + 20 >= ABS(Chopper(2).XPos + 4) AND Missile(1).XPos <= ABS((Chopper(2).XPos) + 40) THEN
  Chopper(2).HitFlag = 1
  IF SoundFlag = 1 THEN
   SOUND 147, .5
  END IF
 END IF
 IF ((Missile(2).YPos - y) + 3) = ABS(Chopper(1).YPos) AND Missile(2).XPos <= ABS((Chopper(1).XPos) + 36) AND Missile(2).XPos + 20 >= ABS(Chopper(1).XPos) THEN
  Chopper(1).HitFlag = 1
  IF SoundFlag = 1 THEN
   SOUND 147, .5
  END IF
 END IF
NEXT

'//** Check If Chopper 1 Got Hit **\\

IF Chopper(1).HitFlag = 1 THEN
   Chopper(2).Score = Chopper(2).Score + 1
   LINE (Missile(2).XPos, Missile(2).YPos)-(Missile(2).XPos + 20, Missile(2).YPos + 10), 0, BF
   IF Chopper(2).Score = 3 THEN RoundWinner 2
   IF Chopper(2).Round = VAL(Rounds$) THEN GameWinner 2
   Missile(2).Flag = 0
   Missile(2).XPos = Chopper(2).XPos + 40
   Missile(2).YPos = Chopper(2).YPos + 10
   Chopper(1).HitFlag = 0
END IF

'//** Check If Chopper 2 Got Hit **\\

IF Chopper(2).HitFlag = 1 THEN
   Chopper(1).Score = Chopper(1).Score + 1
   LINE (Missile(1).XPos, Missile(1).YPos)-(Missile(1).XPos + 20, Missile(1).YPos + 10), 0, BF
   IF Chopper(1).Score = 3 THEN RoundWinner 1
   IF Chopper(1).Round = VAL(Rounds$) THEN GameWinner 1
   Missile(1).Flag = 0
   Missile(1).XPos = Chopper(1).XPos - 20
   Missile(1).YPos = Chopper(1).YPos + 10
   Chopper(2).HitFlag = 0
END IF

END SUB

SUB CheckKey

KeyPress$ = INKEY$

SELECT CASE KeyPress$

'//** Misc. Controls **\\

 CASE "+", "="
  IF Speed = 0 THEN Speed = 1
  Speed = Speed - 1
  COLOR 48
  LOCATE 25, 1: PRINT Speed;
  MilliDelay 15
  LOCATE 25, 1: PRINT "    ";

 CASE "-"
  IF Speed = 100 THEN Speed = 99
  Speed = Speed + 1
  COLOR 48
  LOCATE 25, 1: PRINT Speed;
  MilliDelay 15
  LOCATE 25, 1: PRINT "    ";

 CASE CHR$(27)
  GameOver

'//** Player 1 Keyboard Controls **\\

 CASE CHR$(0) + CHR$(72)
  Chopper(1).Up = 1         ' Up

 CASE CHR$(0) + CHR$(75)
  Chopper(1).Left = 1       ' Left

 CASE CHR$(0) + CHR$(77)
  Chopper(1).Right = 1      ' Right

 CASE CHR$(0) + CHR$(80)
  Chopper(1).Down = 1       ' Down

 CASE CHR$(32)              ' Fire
  IF Missile(1).Flag = 0 THEN
   Missile(1).XPos = Chopper(1).XPos + 40
   Missile(1).YPos = Chopper(1).YPos + 10
   Missile(1).Flag = 1
   IF Missile(1).XPos >= 300 THEN Missile(1).Flag = 0
  END IF
 
'//** Player 2 Keybord Controls **\\

 CASE "W", "w"
  Chopper(2).Up = 1     ' Up

 CASE "A", "a"
  Chopper(2).Left = 1   ' Left

 CASE "D", "d"
  Chopper(2).Right = 1  ' Right

 CASE "S", "s"
  Chopper(2).Down = 1   ' Down

 CASE CHR$(9)           ' Fire
  IF Missile(2).Flag = 0 THEN
   Missile(2).XPos = Chopper(2).XPos - 20
   Missile(2).YPos = Chopper(2).YPos + 10
   Missile(2).Flag = 1
   IF Missile(2).XPos <= 0 THEN Missile(2).Flag = 0
  END IF

 CASE ELSE

END SELECT

DEF SEG = &H40
POKE &H1A, PEEK(&H1C)

END SUB

SUB CheckMissilePos

'//** Check Player 1 Missile Position **\\

 IF Missile(1).Flag = 1 THEN
   PUT (Missile(1).XPos, Missile(1).YPos), Weapon(MissileStepOrder(Stp / 16) * MissileEPI), PSET
   IF Missile(1).XPos >= 299 THEN
    LINE (Missile(1).XPos, Missile(1).YPos)-(Missile(1).XPos + 20, Missile(1).YPos + 10), 0, BF
    Missile(1).Flag = 0
   END IF
  Missile(1).XPos = Missile(1).XPos + 2
 END IF

'//** Check Player 2 Missile Position **\\

 IF Missile(2).Flag = 1 THEN
   PUT (Missile(2).XPos, Missile(2).YPos), Weapon(MissileStepOrder((Stp + 32) / 16) * MissileEPI), PSET
   IF Missile(2).XPos <= 1 THEN
    LINE (Missile(2).XPos, Missile(2).YPos)-(Missile(2).XPos + 20, Missile(2).YPos + 10), 0, BF
    Missile(2).Flag = 0
   END IF
  Missile(2).XPos = Missile(2).XPos - 2
 END IF

END SUB

SUB CheckPlayerKeyPress

'//** Check Player 1 Key Press **\\

 IF Chopper(1).Up = 1 THEN
   IF Chopper(1).Down = 0 THEN
    Chopper(1).YPos = Chopper(1).YPos - 1
   ELSE
    Chopper(1).Up = 0
    Chopper(1).Down = 0
   END IF
 END IF
 IF Chopper(1).Right = 1 THEN
   IF Chopper(1).Left = 1 THEN
    Chopper(1).Left = 0
    Chopper(1).Right = 0
   ELSEIF Chopper(1).Left = 0 THEN
    Chopper(1).XPos = Chopper(1).XPos + 1
   END IF
 END IF
 IF Chopper(1).Left = 1 THEN
   IF Chopper(1).Right = 1 THEN
    Chopper(1).Right = 0
    Chopper(1).Left = 0
   ELSEIF Chopper(1).Right = 0 THEN
    Chopper(1).XPos = Chopper(1).XPos - 1
   END IF
 END IF
 IF Chopper(1).Down = 1 THEN
   IF Chopper(1).Up = 1 THEN
    Chopper(1).Up = 0
   ELSEIF Chopper(1).Up = 0 THEN
    Chopper(1).YPos = Chopper(1).YPos + 1
   END IF
 END IF

'//** Check Player 2 Key Press **\\

 IF Chopper(2).Up = 1 THEN
   IF Chopper(2).Down = 0 THEN
    Chopper(2).YPos = Chopper(2).YPos - 1
   ELSE
    Chopper(2).Up = 0
    Chopper(2).Down = 0
   END IF
 END IF
 IF Chopper(2).Right = 1 THEN
   IF Chopper(2).Left = 1 THEN
    Chopper(2).Left = 0
    Chopper(2).Right = 0
   ELSEIF Chopper(2).Left = 0 THEN
    Chopper(2).XPos = Chopper(2).XPos + 1
   END IF
 END IF
 IF Chopper(2).Left = 1 THEN
   IF Chopper(2).Right = 1 THEN
    Chopper(2).Right = 0
    Chopper(2).Left = 0
   ELSEIF Chopper(2).Right = 0 THEN
    Chopper(2).XPos = Chopper(2).XPos - 1
   END IF
 END IF
 IF Chopper(2).Down = 1 THEN
   IF Chopper(2).Up = 1 THEN
    Chopper(2).Up = 0
   ELSEIF Chopper(2).Up = 0 THEN
    Chopper(2).YPos = Chopper(2).YPos + 1
   END IF
 END IF

END SUB

SUB Credits

SetPal 12

COLOR 15
 LOCATE 1, 1: PRINT "Chopper! Is An Original M&M Production (1997)";
 LOCATE 2, 1: PRINT STRING$(45, 196)
 LOCATE 5, 1: PRINT "Programming, Artwork, & Music By:"
COLOR 1
 LOCATE 6, 15: PRINT "Matthew Pulley"
COLOR 15
 LOCATE 8, 1: PRINT "Artwork Created With:"
 LOCATE 9, 15: PRINT "Fred Sexton's"
 LOCATE 10, 15: PRINT "QBasic Image Editor"
 LOCATE 14, 1: PRINT "Chopper! Is Coded In"; : COLOR 2: PRINT " 100%"; : COLOR 15: PRINT " QuickBasic"
 LOCATE 15, 1: PRINT "No Artificial Additives Or Preservatives"
 LOCATE 19, 1: PRINT "Thanks And Greets Go To:"
 LOCATE 20, 15: PRINT CHR$(34); : COLOR 3: PRINT "     "; : COLOR 15: PRINT CHR$(34)
COLOR 3
 LOCATE 21, 16: PRINT "ketch "
COLOR 4
 LOCATE 22, 15: PRINT "Fred Sexton Jr."; : COLOR 15: PRINT " - Thanks For IMG-EDIT And MilliDelay!"
COLOR 5
 LOCATE 23, 15: PRINT "Andrew L. Ayers"; : COLOR 15: PRINT " - Thanks For The Explosions!"
COLOR 6
 LOCATE 24, 15: PRINT "Dave Shea"; : COLOR 15: PRINT " - Thanks For The Idea!"
COLOR 7
 LOCATE 25, 15: PRINT "Nick Coons"; : COLOR 15: PRINT " - Thanks For Putting Up With Me!"
 LOCATE 26, 15: PRINT "Everybody In The"; : COLOR 8: PRINT " QUIK_BAS"; : COLOR 15: PRINT " FIDO Echo!"
COLOR 9
 LOCATE 30, 65: PRINT "Press Any Key...";

Pal = 1
AddPal = 1
DO
 IF Pal = 0 OR Pal = 63 THEN AddPal = -AddPal
 OUT &H3C8, 1
  OUT &H3C9, 0
  OUT &H3C9, 0
  OUT &H3C9, Pal
 OUT &H3C8, 2
  OUT &H3C9, 0
  OUT &H3C9, Pal
  OUT &H3C9, Pal
 OUT &H3C8, 3
  OUT &H3C9, 0
  OUT &H3C9, Pal / 2
  OUT &H3C9, 0
 OUT &H3C8, 4
  OUT &H3C9, Pal
  OUT &H3C9, Pal / 2
  OUT &H3C9, Pal / 8
 OUT &H3C8, 5
  OUT &H3C9, Pal
  OUT &H3C9, 0
  OUT &H3C9, Pal
 OUT &H3C8, 6
  OUT &H3C9, Pal / 3
  OUT &H3C9, Pal / 2
  OUT &H3C9, Pal
 OUT &H3C8, 7
  OUT &H3C9, Pal
  OUT &H3C9, Pal
  OUT &H3C9, 0
 OUT &H3C8, 8
  OUT &H3C9, Pal
  OUT &H3C9, 0
  OUT &H3C9, 0
 OUT &H3C8, 9
  OUT &H3C9, Pal
  OUT &H3C9, Pal
  OUT &H3C9, Pal
 Pal = Pal + AddPal
 MilliDelay 15
LOOP WHILE INKEY$ = ""

END SUB

SUB EndScreen

SCREEN 2
SCREEN 0
COLOR 15
LOCATE 1, 1: PRINT "Chopper!"
COLOR 9
LOCATE 2, 1: PRINT "Programming And Artwork By - Matthew Pulley"
COLOR 7
LOCATE 3, 1: PRINT "Comments, Suggestion, Criticisms Welcome!"
LOCATE 4, 1: PRINT "e-mail: airwalk_mp@juno.com"
END

END SUB

' This Routine Was Originally Written By Andrew L. Ayers. I Use It
' Here With Little Modification, Save For The Starting Position Of
' The Explosion And The Color Change, Due To The Changed Palette.
'
SUB Explode (PlayerNum)

IF PlayerNum% = 1 THEN
  tx% = Chopper(1).XPos + 22
  ty% = Chopper(1).YPos + 9
END IF

IF PlayerNum% = 2 THEN
  tx% = Chopper(2).XPos + 15
  ty% = Chopper(2).YPos + 9
END IF

DIM x(50), y(50), xv(50), yv(50), ox(50), oy(50)
 
  FOR t% = 0 TO 50
    x(t%) = 0
    y(t%) = 0
    dir = RND * 6.28: vel = INT(RND * 5) + 1
    xv(t%) = SIN(dir) * vel
    yv(t%) = COS(dir) * vel
  NEXT t%
 
  c% = 48: done% = 0
 
  DO
    FOR t% = 0 TO 50
      LINE (ox(t%) + tx%, oy(t%) + ty%)-(x(t%) + tx%, y(t%) + ty%), 0
      ox(t%) = x(t%): oy(t%) = y(t%)
      x(t%) = x(t%) + xv(t%)
      y(t%) = y(t%) + yv(t%)
      LINE -(x(t%) + tx%, y(t%) + ty%), c%
    NEXT
    c% = c% + 1: IF c% > 62 THEN done% = 1 ' Do another explosion if done
  MilliDelay Speed + 50
  LOOP UNTIL done%

MilliDelay 2000

DO
LOOP WHILE INKEY$ <> ""

END SUB

SUB GameOver

'//** Reset Default Values **\\

CLS

Player1Row = 2
Player2Row = 32
Speed = 5
Stp = 1
StepAdd = 1

Chopper(1).XPos = 0
Chopper(1).YPos = 90
Chopper(1).Score = 0
Chopper(1).Round = 0
Chopper(1).Up = 0
Chopper(1).Left = 0
Chopper(1).Right = 0
Chopper(1).Down = 0
Chopper(2).XPos = 280
Chopper(2).YPos = 90
Chopper(2).Score = 0
Chopper(2).Round = 0
Chopper(2).Up = 0
Chopper(2).Left = 0
Chopper(2).Right = 0
Chopper(2).Down = 0

Missile(1).XPos = Chopper(1).XPos + 37
Missile(1).YPos = Chopper(1).YPos + 10
Missile(1).Flag = 0
Missile(2).XPos = Chopper(2).XPos - 17
Missile(2).YPos = Chopper(2).YPos + 10
Missile(2).Flag = 0

TitleScreen

END SUB

SUB GameWinner (PlayerNum)

Song1$ = "MFL16O3CO1CCCCCCCO2B-O3CP16P16P16P16P16P16O3CO1CCCCCCCO3E-O3CP16P16P16"
Song2$ = "P16P16P16O3CO1CCO3E-O1CCO3FO1CCO3F+O1CCO3FO1CO3E-O1CO3CO1CCO2B-O1CCO2G"
Song3$ = "O1CCO2B-O1CCO3CO1CO3E-O1CO3CO1CCO3E-O1CCO3FO1CCO3F+O1CCO3FO1CO3E-O1CO3"
Song4$ = "CO1CCO2B-O1CCO2GO1CCO2B-O1CCO3E-O1CO2B-O1CO3CO1CCCCCCCO2B-O3CP16P16P16"
Song5$ = "P16P16P16O3CO1CCCCCCCO3E-O3CP16P16P16P16P16P16"

'//** If Player 1 Wins **\\

IF PlayerNum = 1 THEN

 Explode 2

ScreenOnOff 1

 CLS
 COLOR 15
 LOCATE 10, 3: PRINT "CONGRATULATIONS "; : COLOR 16: PRINT PlayerName$(1); : COLOR 15: PRINT "!"
 LOCATE 12, 4: PRINT "YOU HAVE BEATEN "; : COLOR 32: PRINT PlayerName$(2); : COLOR 15: PRINT " AT CHOPPER!"

DEF SEG = &HA000
Colr = 58
AddColr = 3

FOR x% = 72 TO 96
 FOR y% = 16 TO 319
  IF POINT(y%, x%) = 15 THEN
   POKE (y% + x% * 320&), Colr
  END IF
 NEXT
 IF Colr = 49 OR Colr > 58 THEN AddColr = -AddColr
 Colr = Colr - AddColr
NEXT

ScreenOnOff 2

 IF MusicFlag = 1 THEN
  PLAY Song1$
  PLAY Song2$
  PLAY Song3$
  PLAY Song4$
  PLAY Song5$
  DO
  LOOP WHILE INKEY$ = ""
 ELSE
  DO
  LOOP WHILE INKEY$ = ""
 END IF

 GameOver

'//** If Player 2 Wins **\\

ELSEIF PlayerNum = 2 THEN

 Explode 1

 ScreenOnOff 1

 CLS
 COLOR 15
 LOCATE 10, 3: PRINT "CONGRATULATIONS "; : COLOR 32: PRINT PlayerName$(2); : COLOR 15: PRINT "!"
 LOCATE 12, 4: PRINT "YOU HAVE BEATEN "; : COLOR 16: PRINT PlayerName$(1); : COLOR 15: PRINT " AT CHOPPER!"

DEF SEG = &HA000
Colr = 58
AddColr = 3

FOR x% = 72 TO 96
 FOR y% = 16 TO 319
  IF POINT(y%, x%) = 15 THEN
   POKE (y% + x% * 320&), Colr
  END IF
 NEXT
 IF Colr = 49 OR Colr > 58 THEN AddColr = -AddColr
 Colr = Colr - AddColr
NEXT

ScreenOnOff 2

 IF MusicFlag = 1 THEN
  PLAY Song1$
  PLAY Song2$
  PLAY Song3$
  PLAY Song4$
  PLAY Song5$
  DO
  LOOP WHILE INKEY$ = ""
 ELSE
  DO
  LOOP WHILE INKEY$ = ""
 END IF

 GameOver

END IF

END SUB

SUB Instructions

SetPal 12

 OUT &H3C8, 2
  OUT &H3C9, 63
  OUT &H3C9, 63
  OUT &H3C9, 0
 OUT &H3C8, 3
  OUT &H3C9, 32
  OUT &H3C9, 0
  OUT &H3C9, 63

LOCATE 1, 1: PRINT "Chopper! Is An Original M&M Production (1997)                             Page 1"
LOCATE 2, 1: PRINT STRING$(45, 196)
PRINT
PRINT
COLOR 2
PRINT "Instructions"
COLOR 15
PRINT ""
PRINT
PRINT
PRINT "The object of Chopper! is to defeat your opponent using your limitless"
PRINT "arsenal of dumb missiles. Players 1 and 2 maneuver around their flight"
PRINT "space while firing and dodging missiles. If one player hits another"
PRINT "three times, then that player wins one round, designated under that"
PRINT "player's name with a star. The first person to win the chosen number"
PRINT "of rounds is the winner. The players move and shoot using the following"
PRINT "keyboard controls:"
PRINT
PRINT
PRINT "            Player 1 (Left Side)                     Player 2 (Right Side)"
PRINT "                                 "
PRINT "               (Up Arrow Key)                                (W)"
PRINT "                     Up                                       Up "
PRINT
PRINT "(Left Arrow Key) Left  Right (Right Arrow Key)        (A) Left  Right (D)"
PRINT
PRINT "                    Down                                     Down     "
PRINT "              (Down Arrow Key)                                (S)"
PRINT
PRINT "           Spacebar Fires Missile                       TAB Fires Missile"
COLOR 1
LOCATE 30, 65: PRINT "Press Any Key...";

Pal = 0
AddPal = 1
DO
 OUT &H3C8, 1
  OUT &H3C9, Pal
  OUT &H3C9, Pal
  OUT &H3C9, 0
 Pal = Pal + AddPal
 IF Pal = 0 OR Pal = 63 THEN AddPal = -AddPal
 MilliDelay 15
LOOP WHILE INKEY$ = ""

FOR t = 7 TO 29
 LOCATE t, 1: PRINT STRING$(80, 0);
 OUT &H3C8, 1
  OUT &H3C9, Pal
  OUT &H3C9, Pal
  OUT &H3C9, 0
 Pal = Pal + AddPal
 IF Pal = 0 OR Pal = 63 THEN AddPal = -AddPal
 MilliDelay 4
NEXT

COLOR 15
LOCATE 1, 75: PRINT "Page 2";
LOCATE 9, 1: PRINT "Game speed may be increased or decreased during the game using the + and - keys."
PRINT "A speed indicator will flash at the bottom left of the screen for a fraction of"
PRINT "a second. Speed ranges from 0 to 100, 0 being the fastest, 100 the slowest."
PRINT
PRINT "Chopper Colors may be toggled under the OPTIONS menu."
PRINT
PRINT "Sound and Music may be turned ON or OFF from the OPTIONS menu."
PRINT
PRINT "Game play may be terminated at any time by pressing the ESC key."
PRINT
PRINT "Many secret keys and easter eggs also await you. You just have to find them..."
PRINT
PRINT "Enjoy, and please look for future quality"
PRINT "programs coming to you from M&M Productions!"
PRINT
PRINT
PRINT "Please send any comments, suggestions,"
PRINT "and criticisms to:"
PRINT
COLOR 3
PRINT "                               airwalk_mp@juno.com"

DO
 OUT &H3C8, 1
  OUT &H3C9, Pal
  OUT &H3C9, Pal
  OUT &H3C9, 0
 Pal = Pal + AddPal
 IF Pal = 0 OR Pal = 63 THEN AddPal = -AddPal
 MilliDelay 15
LOOP WHILE INKEY$ = ""

FOR t = 1 TO 30
 LOCATE t, 1: PRINT STRING$(80, 0)
 OUT &H3C8, 1
  OUT &H3C9, Pal
  OUT &H3C9, Pal
  OUT &H3C9, 0
 Pal = Pal + AddPal
 IF Pal = 0 OR Pal = 63 THEN AddPal = -AddPal
 MilliDelay 4
NEXT

END SUB

' This Routine Was Originally Written By Fred Sexton Jr. I Obtained
' It From His Book, 'QBasic Games And More,' And Faithfully Use It
' In Almost All Of My Programs.
'
SUB MilliDelay (msecs) STATIC

 IF sysfact& THEN
  IF msecs THEN
   Count& = (sysfact& * msecs) \ -54
   DO
    Count& = Count& + 1
    IF Count& = Z THEN EXIT DO
   LOOP UNTIL t2 = PEEK(&H6C)
  END IF
 ELSE
  DEF SEG = &H40
   t1 = PEEK(&H6C)
   DO
    t2 = PEEK(&H6C)
   LOOP UNTIL t2 <> t1
   DO
    sysfact& = sysfact& + 1
    IF sysfact& = Z THEN EXIT DO
   LOOP UNTIL t2 <> PEEK(&H6C)
 t2 = 256
END IF

END SUB

SUB Options

SetPal 12

Pal = 1
AddPal = 1

OUT &H3C8, 7
 OUT &H3C9, 0
 OUT &H3C9, 32
 OUT &H3C9, 63

StartSub:

COLOR 15
 LOCATE 1, 1: PRINT "Chopper! Is An Original M&M Production (1997)"
 LOCATE 2, 1: PRINT STRING$(45, 196)
COLOR 7
 LOCATE 5, 1: PRINT "Options Menu"
COLOR 15
 LOCATE 6, 1: PRINT STRING$(12, 196)

  LOCATE 9, 1: PRINT "("; : COLOR 1: PRINT "C"; : COLOR 15: PRINT ")hange Chopper Colors"
  LOCATE 15, 1: PRINT "("; : COLOR 1: PRINT "E"; : COLOR 15: PRINT ")xit"
 
'//** Music On/Off **\\

 LOCATE 11, 1: PRINT "("; : COLOR 1: PRINT "M"; : COLOR 15: PRINT ")usic ";
  IF MusicFlag = 1 THEN
   MusicStat$ = "On "
  ELSE
   MusicStat$ = "Off"
  END IF
 LOCATE 11, 9: PRINT MusicStat$

'//** Sound On/Off **\\

  LOCATE 13, 1: PRINT "("; : COLOR 1: PRINT "S"; : COLOR 15: PRINT ")ound ";
  IF SoundFlag = 1 THEN
   SoundStat$ = "On "
  ELSE
   SoundStat$ = "Off"
  END IF
 LOCATE 13, 10: PRINT SoundStat$

DO
 K$ = INKEY$
 IF Pal = 0 OR Pal = 63 THEN AddPal = -AddPal
 OUT &H3C8, 1
  OUT &H3C9, Pal
  OUT &H3C9, Pal
  OUT &H3C9, Pal
 Pal = Pal + AddPal
 MilliDelay 15
LOOP WHILE K$ = ""

 IF UCASE$(K$) = "C" THEN
  ChangeChopperColors
  Pal = 1
  AddPal = 1
  OUT &H3C8, 7
   OUT &H3C9, 0
   OUT &H3C9, 32
   OUT &H3C9, 63
  GOTO StartSub
 ELSEIF UCASE$(K$) = "S" THEN
  IF SoundFlag = 1 THEN
   SoundFlag = 0
   GOTO StartSub
  END IF
  IF SoundFlag = 0 THEN
   SoundFlag = 1
   GOTO StartSub
  END IF
 ELSEIF UCASE$(K$) = "M" THEN
  IF MusicFlag = 1 THEN
   MusicFlag = 0
   GOTO StartSub
  END IF
  IF MusicFlag = 0 THEN
   MusicFlag = 1
   GOTO StartSub
  END IF
 ELSEIF UCASE$(K$) = "E" THEN
  EXIT SUB
 END IF

GOTO StartSub

END SUB

SUB RoundWinner (PlayerNum)

'//** Keeps Track Of Player Hits **\\

IF PlayerNum = 1 THEN
 LOCATE 2, Player1Row: COLOR 16: PRINT "*"
  Chopper(1).Score = 0
  Chopper(1).Round = Chopper(1).Round + 1
  Player1Row = Player1Row + 1
ELSEIF PlayerNum = 2 THEN
 LOCATE 2, Player2Row: COLOR 32: PRINT "*"
  Chopper(2).Score = 0
  Chopper(2).Round = Chopper(2).Round + 1
  Player2Row = Player2Row + 1
END IF

END SUB

SUB ScreenOnOff (Status%)

IF Status% = 1 THEN
 OUT &H3C4, 1
 OUT &H3C5, INP(&H3C5) OR 32
ELSEIF Status% = 2 THEN
 OUT &H3C4, 1
 OUT &H3C5, INP(&H3C5) AND NOT 32
END IF

END SUB

SUB SetPal (ScreenMode)

'//** Screen 13 Color Values **\\

IF ScreenMode = 13 THEN

 SCREEN 13
 FOR t = 15 TO 31

  '//** Player 1 Chopper **\\
   OUT &H3C8, t
    OUT &H3C9, (-t + 31) * Custom(1).Red
    OUT &H3C9, (-t + 31) * Custom(1).Green
    OUT &H3C9, (-t + 31) * Custom(1).Blue

  '//** Player 2 Chopper **\\
   OUT &H3C8, t + 15
    OUT &H3C9, (-t + 31) * Custom(2).Red
    OUT &H3C9, (-t + 31) * Custom(2).Green
    OUT &H3C9, (-t + 31) * Custom(2).Blue

  '//** White (Cockpit, Blades, Missiles) **\\
   OUT &H3C8, t + 31
    OUT &H3C9, (-t + 15) * 4
    OUT &H3C9, (-t + 15) * 4
    OUT &H3C9, (-t + 15) * 4

  '//** Army Green (Title)
   OUT &H3C8, t + 48
    OUT &H3C9, (-t + 33) * 256
    OUT &H3C9, (-t + 33) * 2
    OUT &H3C9, (-t + 33) * 256
    
 NEXT

'//** Title Screen Color Values **\\

ELSEIF ScreenMode = Title THEN

 SCREEN 13
 FOR t = 15 TO 31

  '//** Left Chopper **\\
   OUT &H3C8, t
    OUT &H3C9, (-t + 31) * 4
    OUT &H3C9, (-t + 31) * 256
    OUT &H3C9, (-t + 31) * 256

  '//** Right Chopper **\\
   OUT &H3C8, t + 15
    OUT &H3C9, (-t + 31) * 256
    OUT &H3C9, (-t + 31) * 2
    OUT &H3C9, (-t + 31) * 256

  '//** White (Cockpit, Blades, Missiles) **\\
   OUT &H3C8, t + 31
    OUT &H3C9, (-t + 31) * 4
    OUT &H3C9, (-t + 31) * 4
    OUT &H3C9, (-t + 31) * 4

  '//** Army Green (Title)
   OUT &H3C8, t + 48
    OUT &H3C9, (-t + 31) * 256
    OUT &H3C9, (-t + 31) * 2
    OUT &H3C9, (-t + 31) * 256
   
 NEXT

'//** Screen 12 Color Values **\\

ELSEIF ScreenMode = 12 THEN

 SCREEN 12
 Pal = 0
 OUT &H3C8, 1
  OUT &H3C9, 0
  OUT &H3C9, 0
  OUT &H3C9, Pal
 OUT &H3C8, 2
  OUT &H3C9, 0
  OUT &H3C9, Pal
  OUT &H3C9, Pal
 OUT &H3C8, 3
  OUT &H3C9, 0
  OUT &H3C9, Pal / 2
  OUT &H3C9, 0
 OUT &H3C8, 4
  OUT &H3C9, Pal
  OUT &H3C9, Pal / 2
  OUT &H3C9, Pal / 8
 OUT &H3C8, 5
  OUT &H3C9, Pal
  OUT &H3C9, 0
  OUT &H3C9, Pal
 OUT &H3C8, 6
  OUT &H3C9, Pal / 3
  OUT &H3C9, Pal / 2
  OUT &H3C9, Pal
 OUT &H3C8, 7
  OUT &H3C9, Pal
  OUT &H3C9, Pal
  OUT &H3C9, 0
 OUT &H3C8, 8
  OUT &H3C9, Pal
  OUT &H3C9, 0
  OUT &H3C9, 0
 OUT &H3C8, 9
  OUT &H3C9, Pal
  OUT &H3C9, Pal
  OUT &H3C9, Pal

END IF

END SUB

SUB StartNewGame

'//** Get Player Names And How Many Rounds They Want To Play **\\

CLS
SetPal 13

PlayerName$(1) = Nul$
PlayerName$(2) = Nul$
Rounds$ = Nul$
Player = 16

FOR InputName = 1 TO 2

ScreenOnOff 1

 COLOR 15
 LOCATE 15, 16: PRINT STRING$(8, 0)
 LOCATE 15, 1: PRINT "PLAYER"; InputName; "NAME:"

DEF SEG = &HA000
Colr = 58
AddColr = 3

FOR x% = 112 TO 120
 FOR y% = 0 TO 107
  IF POINT(y%, x%) = 15 THEN
   POKE (y% + x% * 320&), Colr
  END IF
 NEXT
 IF Colr = 49 OR Colr > 58 THEN AddColr = -AddColr
 Colr = Colr - AddColr
NEXT

ScreenOnOff 2

 BkSpc$ = CHR$(8)
 Ent$ = CHR$(13)
 Valid$ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ- "
 DO
 COLOR 48
  K$ = UCASE$(INKEY$)
  IF LEN(K$) THEN
   Length = LEN(PlayerName$(InputName))
   IF INSTR(Valid$, K$) THEN
    IF Length < 8 THEN PlayerName$(InputName) = PlayerName$(InputName) + K$
   ELSEIF K$ = BkSpc$ THEN
    IF Length THEN PlayerName$(InputName) = LEFT$(PlayerName$(InputName), Length - 1)
   END IF
   LOCATE 15, 16: PRINT STRING$(Length, 0)
   LOCATE 15, 16: COLOR Player: PRINT PlayerName$(InputName)
  END IF

 LOOP UNTIL K$ = Ent$
 IF PlayerName$(InputName) = "GOD" THEN PlayerName$(InputName) = "Matthew"

 Player = 32
           
NEXT

ScreenOnOff 1

 COLOR 15
 LOCATE 15, 16: PRINT STRING$(8, 0)
 LOCATE 15, 1: PRINT "HOW MANY ROUNDS (1-8)?"

DEF SEG = &HA000
Colr = 58
AddColr = 3

FOR x% = 112 TO 120
 FOR y% = 0 TO 173
  IF POINT(y%, x%) = 15 THEN
   POKE (y% + x% * 320&), Colr
  END IF
 NEXT
 IF Colr = 49 OR Colr > 58 THEN AddColr = -AddColr
 Colr = Colr - AddColr
NEXT

ScreenOnOff 2

 BkSpc$ = CHR$(8)
 Ent$ = CHR$(13)
 Valid$ = "12345678"

Reenter:
 Rounds$ = Nul$
 DO
 COLOR 48
  K$ = UCASE$(INKEY$)
  IF LEN(K$) THEN
   Length = LEN(Rounds$)
   IF INSTR(Valid$, K$) THEN
    IF Length < 1 THEN Rounds$ = Rounds$ + K$
   ELSEIF K$ = BkSpc$ THEN
    IF Length THEN Rounds$ = LEFT$(Rounds$, Length - 1)
   END IF
   LOCATE 15, 24: PRINT STRING$(Length, 0)
   LOCATE 15, 24: PRINT Rounds$
  END IF

 LOOP UNTIL K$ = Ent$
 IF LEN(Rounds$) = 0 THEN GOTO Reenter

'//** Sets Up Game Screen **\\

ScreenOnOff 1

CLS
COLOR 62
LOCATE 1, 1: PRINT "Chopper!"
FOR x = 0 TO 63
 FOR y = 0 TO 7
  IF POINT(x, y) <> 0 THEN
   LINE ((x * 2) + 94, (y * 2))-((x * 2) + 95, (y * 2)), RND * 10 + 63, BF
  END IF
 NEXT
NEXT
LOCATE 1, 1: PRINT "        "
COLOR 15
IF PlayerName$(1) <> "Matthew" THEN
 LOCATE 1, 2: PRINT PlayerName$(1)
ELSE
 LOCATE 1, 1: PRINT PlayerName$(1)
END IF
IF PlayerName$(2) <> "Matthew" THEN
 LOCATE 1, 32: PRINT PlayerName$(2)
ELSE
 LOCATE 1, 32: PRINT PlayerName$(2)
END IF

DEF SEG = &HA000
Colr = 58
AddColr = 3

FOR x% = 0 TO 8
 FOR y% = 0 TO 319
  IF POINT(y%, x%) = 15 THEN
   POKE (y% + x% * 320&), Colr
  END IF
 NEXT
 IF Colr = 49 OR Colr > 58 THEN AddColr = -AddColr
 Colr = Colr - AddColr
NEXT
LINE (0, 17)-(319, 17), 48

ScreenOnOff 2

END SUB

SUB TitleScreen

Title:

SetPal Title

ScreenOnOff 1

 COLOR 62
  LOCATE 1, 1: PRINT "Chopper!"
 COLOR 15
  LOCATE 10, 13: PRINT "(P)LAY CHOPPER!"
 COLOR 15
  LOCATE 12, 13: PRINT "(O)PTIONS"
 COLOR 15
  LOCATE 14, 13: PRINT "(I)NSTRUCTIONS"
 COLOR 15
  LOCATE 16, 13: PRINT "(C)REDITS"
 COLOR 15
  LOCATE 18, 13: PRINT "(E)XIT"
 FOR x = 0 TO 63
  FOR y = 0 TO 7
   IF POINT(x, y) = 62 THEN
    LINE ((x * 2) + 94, (y * 2) + 3)-((x * 2) + 95, (y * 2) + 3), RND * 10 + 63
   END IF
  NEXT
 NEXT
 LOCATE 1, 1: PRINT "        "
 
 DEF SEG = &HA000
 Colr = 58
 AddColr = 3
 FOR x% = 72 TO 158
  FOR y% = 96 TO 215
   IF POINT(y%, x%) = 15 THEN
    POKE (y% + x% * 320&), Colr
   END IF
  NEXT
  IF Colr = 49 OR Colr > 58 THEN AddColr = -AddColr
  Colr = Colr - AddColr
 NEXT

ScreenOnOff 2

Start:
 DO
 K$ = INKEY$
 
  IF Stp = 16 THEN Stp = 0

   PUT (29, 0), Copter(ChopperStepOrder(Stp) * ChopperEPI), PSET
   PUT (241, 0), Copter(ChopperStepOrder(Stp + 16) * ChopperEPI), PSET
 
  Stp = Stp + StepAdd

  MilliDelay Speed

LOOP WHILE K$ = ""

IF UCASE$(K$) = "P" THEN
 StartNewGame
 EXIT SUB
ELSEIF UCASE$(K$) = "O" THEN
 Options
 GOTO Title
ELSEIF UCASE$(K$) = "I" THEN
 Instructions
 GOTO Title
ELSEIF UCASE$(K$) = "C" THEN
 Credits
 GOTO Title
ELSEIF UCASE$(K$) = "E" THEN
 EndScreen
ELSE
 GOTO Title
END IF

DEF SEG = &H40
POKE &H1A, PEEK(&H1C)

GOTO Start

END SUB

