#ifndef __DBVIDEO_H
#define __DBVIDEO_H
////////////////////////////////////////////////////////////////////////////
#include "mnvideo.h"
#include "sbsgame.h"

//DEFINES CHAR DRAW//////////////////////////////////////////////////////////
#define CHAR_WIDTH     8
#define CHAR_HEIGHT    8 

//DEFINES DRAWING TILES TO SCREEN//////////////////////////////////////////////////////////
#define CELLS_SHOWX    11 // size of cell based matrix
#define CELLS_SHOWY    11  

#define CELL_WIDTH     16  // width of a cell in pixels
#define CELL_HEIGHT    16  // height of a cell in pixels 

//DEFINES DOUBLE BUFFER STUFF//////////////////////////////////////////////////////////
#define VGA_INPUT_STATUS_1   0x3DA // vga status reg 1, bit 3 is the vsync
                                   // when 1 - retrace in progress
                                   // when 0 - no retrace

#define VGA_VSYNC_MASK 0x08        // masks off unwanted bit of status reg
#define NUM_WORMS  320
//GLOBALS////////////////////////////////////////////////////////////////////////////
extern unsigned char far *rom_char_set;   // rom characters 8x8
extern unsigned char far *double_buffer;

//S T R U C T S//////////////////////////////////////////////////////////////
typedef struct worm_typ
{
        int y;       // current y position of worm
        int color;   // color of worm
        int speed;   // speed of worm
        int counter; // counter

} worm, *worm_ptr;


//P R O T O T Y P E S////////////////////////////////////////////////////////
void Show_Double_Buffer(char far *buffer);
int  Create_Double_Buffer(int num_lines);
void Fill_Double_Buffer(int color);
void Delete_Double_Buffer(void);
void Plot_Pixel_Fast_DB(int x,int y,unsigned char color);
void Scale_Sprite(sprite_ptr sprite,float scale);
void Fade_Lights(void);
void Disolve(void);
void Melt(void);
void Sheer(void);
void Wait_For_Vsync(void);
void Behind_Sprite_DB(sprite_ptr sprite);
void Erase_Sprite_DB(sprite_ptr sprite);
void Draw_Sprite_DB(sprite_ptr sprite);
void Blit_Char_DB(int xc,int yc,char c,int color,int trans_flag);
void Blit_String_DB(int x,int y,int color, char *string,int trans_flag);       
void Draw_Screen(char **screen, sprite_ptr sprite, your_char_ptr your_char, int fill_back);
void Draw_Objects(char **screen, sprite_ptr sprite, your_char_ptr your_char);
/*void Draw_Scolling(char **screen, sprite_ptr sprite, your_char_ptr your_char, int fill_back);*/

#endif
