

#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <bios.h>
#include <fcntl.h>
#include <memory.h>
#include <malloc.h>
#include <math.h>
#include <string.h>
#include "mnvideo.h"

//GLOBALS////////////////////////////////////////////////////////////////////////////
unsigned char far *video_buffer = (char far *)0xA0000000L; // vram byte ptr
unsigned int far *video_buffer_w= (int far *)0xA0000000L;  // vram word ptr
unsigned int buffer_height = SCREEN_HEIGHT;
unsigned int buffer_size = SCREEN_WIDTH*SCREEN_HEIGHT/2; 

/////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
void Set_Video_Mode(int mode)
{   

	union REGS inregs, outregs; 
	inregs.h.ah = 0;
	inregs.h.al = (unsigned char)mode;
  _int86(0x10, &inregs, &outregs);
	
}  

////////////////////////////////////////////////////////////////////////////
void Fill_Screen(int color_value) 
{
   _fmemset(video_buffer, (char)color_value, SCREEN_WIDTH*SCREEN_HEIGHT+1);
}  

////////////////////////////////////////////////////////////////////////////
void Plot_Pixel(int x, int y, char color)
{
	video_buffer[((y<<8) + (y<<6)) + x] = color;  
} 

///////////////////////////////////////////////////////////////////////////////

void Get_Palette_Register(int index, RGB_color_ptr color)
{

// this function gets the data out of a color lookup regsiter and places it
// into color
// set the palette mask register

_outp(PALETTE_MASK,0xff);
// tell vga card which register we will be reading
_outp(PALETTE_REGISTER_RD, index);
// now extract the data
color->red   = _inp(PALETTE_DATA);
color->green = _inp(PALETTE_DATA);
color->blue  = _inp(PALETTE_DATA);

} // end Get_Palette_Color

///////////////////////////////////////////////////////////////////////////////

void Set_Palette_Register(int index, RGB_color_ptr color)
{

// this function sets a single color look up table value indexed by index
// with the value in the color structure

// tell VGA card we are going to update a pallete register

_outp(PALETTE_MASK,0xff);

// tell vga card which register we will be updating

_outp(PALETTE_REGISTER_WR, index);

// now update the RGB triple, note the same port is used each time

_outp(PALETTE_DATA,color->red);
_outp(PALETTE_DATA,color->green);
_outp(PALETTE_DATA,color->blue);

} // end Set_Palette_Color

///////////////////////////////////////////////////////////////////////////////
void Delay(int clicks)
{
// this function uses the internal time keeper timer i.e. the one that goes
// at 18.2 clicks/sec to to a time delay.  You can find a 32 bit value of
// this timer at 0000:046Ch

unsigned int far *clock = (unsigned int far *)0x0000046CL;

unsigned int now;

// get current time

now = *clock;

// wait till time has gone past current time plus the amount we eanted to
// wait.  Note each click is approx. 55 milliseconds.

while(abs(*clock - now) < clicks){}

} // end Delay

////////////////////////////////////////////////////////////////////////////////

void PCX_Init(pcx_picture_ptr image)
{
// this function allocates the buffer region needed to load a pcx file

if (!(image->buffer = (char far *)_fmalloc(SCREEN_WIDTH * SCREEN_HEIGHT + 1)))

   printf("\ncouldn't allocate screen buffer");

} // end PCX_Init

//////////////////////////////////////////////////////////////////////////////

void PCX_Load(char *filename, pcx_picture_ptr image,int enable_palette)
{

FILE *fp;
int num_bytes,index;
long count;
unsigned char data;
char far *temp_buffer;

// open the file
fp = fopen(filename,"rb");
if (fp==NULL) 
{
  Set_Video_Mode(TEXT_MODE);
  printf("Can not find a pcx file!");
  exit(1);
}
// load the header

temp_buffer = (char far *)image;

for (index=0; index<128; index++)
    {
    temp_buffer[index] = (char)getc(fp);
    } // end for index

// load the data and decompress into buffer

count=0;

while(count<=SCREEN_WIDTH * SCREEN_HEIGHT)
     {
     // get the first piece of data

     data = (unsigned char)getc(fp);

     // is this a rle?

     if (data>=192 && data<=255)
        {
        // how many bytes in run?

        num_bytes = data-192;

        // get the actual data for the run

        data  = (unsigned char)getc(fp);

        // replicate data in buffer num_bytes times

        while(num_bytes-->0)
             {
             image->buffer[count++] = data;

             } // end while

        } // end if rle
     else
        {
        // actual data, just copy it into buffer at next location

        image->buffer[count++] = data;

        } // end else not rle

     } // end while

// move to end of file then back up 768 bytes i.e. to begining of palette

fseek(fp,-768L,SEEK_END);

// load the pallete into the palette

for (index=0; index<256; index++)
    {
    // get the red component

    image->palette[index].red   = (unsigned char)(getc(fp) >> 2);

    // get the green component

    image->palette[index].green = (unsigned char)(getc(fp) >> 2);

    // get the blue component

    image->palette[index].blue  = (unsigned char)(getc(fp) >> 2);

    } // end for index

fclose(fp);

// change the palette to newly loaded palette if commanded to do so

if (enable_palette)
   {

   // for each palette register set to the new color values

   for (index=0; index<256; index++)
       {

       Set_Palette_Register(index,(RGB_color_ptr)&image->palette[index]);

       } // end for index

   } // end if change palette

} // end PCX_Load

//////////////////////////////////////////////////////////////////////////////

void PCX_Delete(pcx_picture_ptr image)
{
// this function de-allocates the buffer region used for the pcx file load

_ffree(image->buffer);

} // end PCX_Delete

//////////////////////////////////////////////////////////////////////////////

void PCX_Show_Buffer(pcx_picture_ptr image)
{

char far *data;

data = image->buffer;

_asm
   {
   push ds               ; save the data segment
   les di, video_buffer  ; point es:di to video buffer
   lds si, data          ; point ds:si to data area
   mov cx,320*400/8      ; move 32000 words
   cld                   ; set direction to foward
   rep movsw             ; do the string operation
   pop ds                ; restore the data segment
   }

} // end PCX_Show_Picture

//////////////////////////////////////////////////////////////////////////////

unsigned char Get_Pixel(int x,int y)
{

// gets the color value of pixel at (x,y) from the screen and returns it

return video_buffer[((y<<8) + (y<<6)) + x];

} // end Get_Pixel

//////////////////////////////////////////////////////////////////////////////

void Sprite_Init(sprite_ptr sprite,int x,int y,int ac,int as,int mc,int ms,
                 int swidth, int sheight)
{
// this function initializes a sprite with the sent data

int index;

sprite->x            = x;
sprite->y            = y;
sprite->x_old        = x;
sprite->y_old        = y;
sprite->width        = swidth;
sprite->height       = sheight;
sprite->anim_clock   = ac;
sprite->anim_speed   = as;
sprite->motion_clock = mc;
sprite->motion_speed = ms;
sprite->curr_frame   = 0;
sprite->state        = SPRITE_DEAD;
sprite->num_frames   = 0;
sprite->background   = (char far *)_fmalloc(swidth * sheight+1);
// set all bitmap pointers to null

for (index=0; index<MAX_SPRITE_FRAMES; index++)
{  
	  sprite->trans_color[index]=-1;
    sprite->frames[index] = NULL;
    
}
} // end Sprite_Init

//////////////////////////////////////////////////////////////////////////////

void Sprite_Delete(sprite_ptr sprite)
{

int index;

_ffree(sprite->background);

// now de-allocate all the animation frames

for (index=0; index<MAX_SPRITE_FRAMES; index++)
    _ffree(sprite->frames[index]);

} // end Sprite_Delete


//////////////////////////////////////////////////////////////////////////////

void PCX_Grab_Bitmap(pcx_picture_ptr image,
                     sprite_ptr sprite,
                     int sprite_frame,
                     int grab_x, int grab_y, int transp)

{
// this function will grap a bitmap from the pcx frame buffer. it uses the
// convention that the 320x200 pixel matrix is sub divided into a smaller
// matrix of nxn adjacent squares

int x_off,y_off, x,y;
char far *sprite_data;

sprite->x_block=grab_x;
sprite->y_block=grab_y;
sprite->trans_color[sprite_frame]=transp;
// first allocate the memory for the sprite in the sprite structure

sprite->frames[sprite_frame] = (char far *)_fmalloc(sprite->width * sprite->height + 1);

// create an alias to the sprite frame for ease of access

sprite_data = sprite->frames[sprite_frame];

// now load the sprite data into the sprite frame array from the pcx picture

x_off = (sprite->width+1)  * grab_x + 1;
y_off = (sprite->height+1) * grab_y + 1;

// compute starting y address

y_off = y_off * 320; 

for (y=0; y<sprite->height; y++)
    {
    for (x=0; x<sprite->width; x++)
        {
        	// get the next byte of current row and place into next position in
        	// sprite frame data buffer
        	sprite_data[y*sprite->width + x] = image->buffer[y_off + x_off + x];
        } // end for x
        // move to next line of picture buffer
        y_off+=320;
    } // end for y
// increment number of frames
sprite->num_frames++;
// done!, let's bail!
} // end PCX_Grab_Bitmap

//////////////////////////////////////////////////////////////////////////////


int Sprite_Collide(sprite_ptr sprite_1, sprite_ptr sprite_2)
{
// this function tests the bounding boxes of each sprite to see if a
// collision has occured, if so a 1 is returned else a 0 is returned

int dx,dy;

// compute amount of overlap, if any

dx = abs(sprite_1->x - sprite_2->x);
dy = abs(sprite_1->y - sprite_2->y);

// test x and y extents, note how the width and height are decreased by a
// percentage of the actual width and height. this is to make the bounding
// box a little more realistic since very seldomly will an object be
// rectangula, this helps to insure that there is a solid collision

if (dx<((sprite_1->width)-((sprite_1->width)>>3)) && dy<((sprite_2->height)-((sprite_2->height)>>3)))
   {

   return(1);

   } // end if collision occured
else
   {

   return(0);

   } // end else

} // end Sprite_Collide

//////////////////////////////////////////////////////////////////////////////

void H_Line(int x1,int x2,int y,unsigned int color)
{
// draw a horizontal line useing the memset function
// note x2 > x1

_fmemset((char far *)(video_buffer + ((y<<8) + (y<<6)) + x1),color,x2-x1+1);

} // end H_Line

//////////////////////////////////////////////////////////////////////////////

void V_Line(int y1,int y2,int x,unsigned int color)
{
// draw a vertical line, note y2 > y1

unsigned int line_offset,
                    index;

// compute starting position

line_offset = ((y1<<8) + (y1<<6)) + x;

for (index=0; index<=(y2-y1); index++)
    {
    video_buffer[line_offset] = color;

     line_offset+=320; // move to next line

    } // end for index

} // end V_Line

//////////////////////////////////////////////////////////////////////////////

void Fill_Screen_Z(int color)
{
// this function will fill the mode Z video buffer with the sent color

// use the inline assembler for speed

_asm
   {
   mov dx,SEQUENCER          ; address the sequencer
   mov al,SEQ_PLANE_ENABLE   ; select the plane enable register
   mov ah,0fh                ; enable all four planes
   out dx,ax                 ; do it baby!
   les di,video_buffer   ; point es:di to video buffer
   mov al,BYTE PTR color ; move the color into al and ah
   mov ah,al             ; replicate color into ah
   mov cx,320*400/8      ; number of words to fill(using word is faster than bytes)
   rep stosw             ; move the color into the video buffer really fast!
   } // end inline asm

} // end Fill_Screen_Z

///////////////////////////////////////////////////////////////////////////////

void Write_Pixel_Z(int x,int y,int color)
{

// this function will write a pixel to screen in mode Z

// first select the proper color plane use inline for speed
// if we used C then there would be a function call and about 10-15 more
// instructions!

_asm
   {
   mov dx,SEQUENCER          ; address the sequencer
   mov al,SEQ_PLANE_ENABLE   ; select the plane enable register
   mov cl,BYTE PTR x         ; extract lower byte from x
   and cl,03h                ; extract the plane number = x MOD 4
   mov ah,1                  ; a "1" selects the plane in the plane enable
   shl ah,cl                 ; shift the "1" bit proper number of times
   out dx,ax                 ; do it baby!
   } // end asm

// write the pixel, offset = (y*320+x)/4

video_buffer[(y<<6)+(y<<4)+(x>>2)] = (unsigned char )color;

} // end Write_Pixel_Z

///////////////////////////////////////////////////////////////////////////////

void Set_Mode_Z(void)
{
// this function will set the video mode to 320x400x256

int data;  // used to store data

// set system to mode 13h and use it as a foundation to base 320x400 mode on

_asm
   {
   mov ax,0013h  ; ah=function number 00(set graphics mode), al=13h
   int 10h       ; video interrupt 10h
   } // end asm

// make changes to the crt controller first

// set number of scanlines to 1

_outp(CRT_CONTROLLER,CRT_MAX_SCANLINE);
data=_inp(CRT_CONTROLLER+1);
_outp(CRT_CONTROLLER+1,RESET_BITS(data,0x0f));

// use byte addressing instead of word

_outp(CRT_CONTROLLER,CRT_ADDR_MODE);
data=_inp(CRT_CONTROLLER+1);
_outp(CRT_CONTROLLER+1,RESET_BITS(data,0x40));

// second register that needs to reflect byte addressing

_outp(CRT_CONTROLLER,CRT_MODE_CONTROL);
data=_inp(CRT_CONTROLLER+1);
_outp(CRT_CONTROLLER+1,SET_BITS(data,0x40));

// make changes to graphics controller

// set addressing to not use odd/even memory writes

_outp(GFX_CONTROLLER,GFX_WRITE_MODE);
data=_inp(GFX_CONTROLLER+1);
_outp(GFX_CONTROLLER+1,RESET_BITS(data,0x10));

// don't chain the memory maps together

_outp(GFX_CONTROLLER,GFX_MISC);
data=_inp(GFX_CONTROLLER+1);
_outp(GFX_CONTROLLER+1,RESET_BITS(data,0x02));

// make changes to sequencer

// again we must select no chaining and no odd/even memory addressing

_outp(SEQUENCER,SEQ_MEMORY_MODE);
data =_inp(SEQUENCER+1);
data = RESET_BITS(data,0x08);
data = SET_BITS(data,0x04);
_outp(SEQUENCER+1,data);

// now clear the screen

_outp(SEQUENCER,SEQ_PLANE_ENABLE);
_outp(SEQUENCER+1,0x0f);

// clear the screen, remember it is 320x400, but that is divided into four
// planes, hence we need only to clear 32k out since there will ne four planes
// each being cleared in parallel for a total of 4*32k or 128 = 320x400
// note: "k" in this example means 1000 not 1024

_asm
   {

   les di,video_buffer   ; point es:di to video buffer, same addre for mode Z
   xor ax,ax             ; move a zero into al and ah
   mov cx,320*400/4      ; number of words to fill(using word is faster than bytes)
   rep stosw             ; move the color into the video buffer really fast!

   } // end inline asm

} // end Set_Mode_Z


RGB_color_ptr Read_Color_Reg(int index, RGB_color_ptr color)
{

// this function reads the RGB triple out of a palette register and places it
// into "color"

// tell vga card which register to read

_outp(COLOR_REGISTER_RD, index);

// now extract the data

color->red   = (unsigned char)_inp(COLOR_DATA);
color->green = (unsigned char)_inp(COLOR_DATA);
color->blue  = (unsigned char)_inp(COLOR_DATA);

// return a pointer to color so that the function can be used as an RVALUE

return(color);

} // end Read_Color_Reg
int Read_Pixel(int x,int y)
{
// this function read a pixel from the screen buffer


// use the fact that 320*y = 256*y + 64*y = y<<8 + y<<6

return((int)(video_buffer[((y<<8) + (y<<6)) + x]));

} // end Read_Pixel
