#ifndef __MN_VIDEO_H
#define __MN_VIDEO_H


////////DEFINES SCREEN + PALETTE////////////////////////////////////////////////////
#define VGA320x200x256   						0x13
#define TEXT_MODE       						0x03 
#define SCREEN_WIDTH  (unsigned int)320
#define SCREEN_HEIGHT (unsigned int)200 
#define PALETTE_MASK    						0x3C6
#define PALETTE_REGISTER_RD 				0x3C7
#define PALETTE_REGISTER_WR 				0x3C8
#define PALETTE_DATA        				0x3C9
////////DEFINES SPRITE//////////////////////////////////////////////////////////////
#define MAX_SPRITE_FRAMES 					26
#define SPRITE_DEAD       					0
#define SPRITE_ALIVE      					1
#define SPRITE_DYING      					2

/////EXTERNS VIDEO//////////////////////////////////////////////////////////////////
extern unsigned char far *video_buffer;   // vram byte ptr
extern unsigned int far *video_buffer_w;  // vram word ptr
extern unsigned int buffer_height;
extern unsigned int buffer_size;

typedef struct RGB_color_type
{
	unsigned char red;
	unsigned char green;
	unsigned char blue;
}  RGB_color, *RGB_color_ptr;

typedef struct pcx_header_typ
{
      char manufacturer;
      char version;
      char encoding;
      char bits_per_pixel;
      int x,y;
        int width,height;
        int horz_res;
        int vert_res;
        char ega_palette[48];
        char reserved;
        char num_color_planes;
        int bytes_per_line;
        int palette_type;
        char padding[58];
} pcx_header, *pcx_header_ptr;


typedef struct pcx_picture_typ
{
        pcx_header header;
        RGB_color palette[256];
        char far *buffer;
} pcx_picture, *pcx_picture_ptr;


typedef struct sprite_typ
{
        int x,y;            // position of sprite
        int x_old,y_old;    // old position of sprite
        int x_block,y_block;	// used to determine the tile numbers, 4,9 or 14,2
        int width,height;   // dimensions of sprite in pixels
        int anim_clock;     // the animation clock
        int anim_speed;     // the animation speed
        int motion_speed;   // the motion speed
        int motion_clock;   // the motion clock
        int trans_color[MAX_SPRITE_FRAMES];		//-1 = none 0=Black......
        char far *frames[MAX_SPRITE_FRAMES]; // array of pointers to the images
        int direction;
        int curr_frame;                      // current frame being displayed
        int num_frames;                      // total number of frames
        int state;                           // state of sprite, alive, dead...
        char far *background;                // whats under the sprite

} sprite, *sprite_ptr;



//P R O T O T Y P E S////////////////////////////////////////////////////////
void Set_Video_Mode(int Mode);
void Fill_Screen(int color_value);
void Plot_Pixel(int x, int y, char color);
void Set_Palette_Register(int index, RGB_color_ptr color);
void Get_Palette_Register(int index, RGB_color_ptr color);
void Delay(int clicks);
void PCX_Delete(pcx_picture_ptr image);
void PCX_Init(pcx_picture_ptr image);
void PCX_Load(char *filename, pcx_picture_ptr image,int enable_palette);
void PCX_Delete(pcx_picture_ptr image);
void PCX_Show_Buffer(pcx_picture_ptr image);
void Sprite_Init(sprite_ptr sprite,int x,int y,int ac,int as,int mc,int ms, int width, int height);
void Sprite_Delete(sprite_ptr sprite);
void PCX_Grab_Bitmap(pcx_picture_ptr image, sprite_ptr sprite, int sprite_frame, int grab_x, int grab_y, int transp);  
unsigned char Get_Pixel(int x,int y);
int Sprite_Collide(sprite_ptr sprite_1, sprite_ptr sprite_2);
void H_Line(int x1,int x2,int y,unsigned int color);
void V_Line(int y1,int y2,int x,unsigned int color); 

#endif
