
#include <stdio.h>
#include <string.h> 
#include <stdlib.h>
#include "sbsgame.h"
#include "mnvideo.h"
#include "bool.h"

////////////////////////////////////////////////////////////////////

                          	 
void Init_Global_Data()
{

//walkable tiles 32 - 64 

	 map_cell_num[FOREST]=0;  			// +
   map_cell_num[SMALL_TREES]=1;  	// *
   map_cell_num[LARGE_TREES]=2;  	// %
   map_cell_num[DIRT]=3;  				// .
   map_cell_num[LARGE_DIRT]=4;  	// ;
   map_cell_num[SWAMP]=5;  				// :
   map_cell_num[BRIDGE]=6;  			// = 
   map_cell_num[SMALL_BTILE]=7;  	// #
   map_cell_num[CAVE]=9;  				// /  
   map_cell_num[LARGE_BTILE]=16;  // (
   map_cell_num[PINK_TILE]=17;  	// )  
   map_cell_num[CITY]=19; 				// 1
   map_cell_num[BOAT]=20; 				// >
   map_cell_num[RED_BRICK]=21; 		// 0
   map_cell_num[BRIDGE2]=22;  		// 9
   map_cell_num[WOOD]=24; 				// 7
   map_cell_num[BW_TILE]=25;  		// 8 
               
//unwalkable tiles 64 - 96 
   map_cell_num[RIVER]=8;  				// ]   river next to land
   map_cell_num[RIVER3]=23;  			// [   river next to land   
   map_cell_num[MOUNTIANS]=10;  	// M   Mountians 
   map_cell_num[MED_OCEAN]=11;  	// O   medium ocean
   map_cell_num[LARGE_OCEAN]=12;  // S   large ocean
   map_cell_num[SMALL_OCEAN]=13;  // P   small ocean
   map_cell_num[RIVER2]=14;  			// R   river
   map_cell_num[STONE_BLOCKS]=15; // /B   Stone Blocks


//characters,monsters 96 - 128
   map_cell_num[YOU]=18; // a    transparent you

// tiles pointed at        
	 universe[0] = (char **)screen_1a;
	 objects[0] = (char **)objects_1a;
	 universe[1] = (char **)screen_2a;
	 objects[1] = (char **)objects_2a;
   
}


void Init_Char(your_char_ptr your_char)
{
   
  your_char->status=0; 
	your_char->xpos=88;
	your_char->ypos=88;
	your_char->xblock=9;
	your_char->yblock=9;
	your_char->y_map_pixel=9*16;
	your_char->x_map_pixel=9*16;		
	your_char->gold=10;
	your_char->silver=10;
	your_char->health=100;
	your_char->strength=10;
	your_char->magic=0;
	your_char->dexterity=10;
	your_char->friendly=5;

}

void Read_Map(char *map[CELL_ROWS],char *obj[CELL_ROWS], char *file_name)
{

   int xmap=0;
   FILE *stream;
   char *alloc;

   char hold[CELL_COLUMNS];   //how many go down
   char temp[CELL_COLUMNS];
  
   if( (stream = fopen(file_name, "r" )) != NULL )
   {    
      for(xmap=0;xmap<CELL_ROWS;xmap++) //GETS THE MAIN MAP
      {
        fgets(hold, 2, stream);        
        fgets(temp, CELL_COLUMNS, stream);
        alloc = (char*)malloc(strlen(temp));
        strncpy(alloc, temp, strlen(temp));
        map[xmap]=alloc;
      } 
      for(xmap=0;xmap<CELL_ROWS;xmap++)  //GETS THE OBJECTS IN SAME FILE
      {
        fgets(hold, 2, stream);        
        fgets(temp, CELL_COLUMNS, stream);
        alloc = (char*)malloc(strlen(temp));
        strncpy(alloc, temp, strlen(temp));
        obj[xmap]=alloc;
      } 
   }
   else
   {
       printf("can not find map file!");
       exit(1);
   }   
   
   
   fclose( stream );
}

Boolean Can_Move(your_char_ptr your_char, char **screen,  char **objects, unsigned char direction)
{

	char *curr_row, *object_row;
	unsigned char map_char, object_map;
	int Walkable;  
	unsigned int cx,cy;

  cx=your_char->xblock;
  cy=your_char->yblock;
  
	if (your_char->status==0 || your_char->status==2)
	{        
  	if (direction==NORTH)
  	{ 
   	 	cy-=1; 
    	curr_row = screen[cy];
    	map_char = curr_row[cx];
    
  		object_row = objects[cy];
  		object_map = object_row[cx]; 	 	  	
  	}
  	else if (direction==SOUTH)
  	{ 
    	cy+=1; 
    	curr_row = screen[cy];
    	map_char = curr_row[cx];
  
  		object_row = objects[cy];
  		object_map = object_row[cx];
 	
  	}
  	else if (direction==WEST)
  	{ 
    	cx+=1;
    	curr_row = screen[cy];
    	map_char = curr_row[cx];
  
  		object_row = objects[cy];
  		object_map = object_row[cx];

  	}
  	else if (direction==EAST)
  	{
    	cx-=1;  
    	curr_row = screen[cy];
    	map_char = curr_row[cx];
      
  		object_row = objects[cy];
  		object_map = object_row[cx];
  	}

////////////////////////////////////////////////
  	if ((map_char>31 && map_char <64))
      	Walkable=1;
  	else if (map_char>63 && map_char <96)
      	Walkable=0;             
///////////////////////////////////////////////      
  	if (object_map==BLANK){}

  	else if ((object_map>31 && object_map <64))
      Walkable=1;
  	else if (object_map>63 && object_map <96)
      Walkable=0;
  	else
      return FALSE;

		if (Walkable==0) return FALSE;
	
  	if (object_map==BOAT)
  	{ 
  	  your_char->status=1;
  	  object_row[cx]=BLANK;
  	} 	          
/////OLD_POSITION//////////////////////////////////////
		your_char->xold_pos=your_char->xblock;
		your_char->yold_pos=your_char->yblock; 
    your_char->yblock=cy;
  	your_char->xblock=cx;

  	if(object_map==CITY)
  	{ 
  		your_char->xreturn_pos=your_char->xold_pos;
			your_char->yreturn_pos=your_char->yold_pos;
			your_char->xblock=8;
			your_char->yblock=8;
  	  your_char->status=2;
  	}
  	
  	if(object_map==QUOTE)
  	{ 
  		your_char->xblock=your_char->xreturn_pos;
			your_char->yblock=your_char->yreturn_pos;
			curr_screen=0;
  	  your_char->status=0;
  	} 
  	
  	  
  	return TRUE;
  }	
  else if	(your_char->status==1)////S T A T U S 1//BOAT/////////////////////////// 
  {
  	if (direction==NORTH)    //north
  	{ 
   	 	cy-=1; 
    	curr_row = screen[cy];
    	map_char = curr_row[cx];
    
  		object_row = objects[cy];
  		object_map = object_row[cx]; 	 	  	
  	}
  	else if (direction==SOUTH)     //south
  	{ 
    	cy+=1; 
    	curr_row = screen[cy];
    	map_char = curr_row[cx];
  
  		object_row = objects[cy];
  		object_map = object_row[cx];
 	
  	}
  	else if (direction==WEST)   //west
  	{ 
    	cx+=1;
    	curr_row = screen[cy];
    	map_char = curr_row[cx];
  
  		object_row = objects[cy];
  		object_map = object_row[cx];

  	}
  	else if (direction==EAST)
  	{
    	cx-=1;  
    	curr_row = screen[cy];
    	map_char = curr_row[cx];
      
  		object_row = objects[cy];
  		object_map = object_row[cx];
  	}

/////////////////////////////////////////////////////////  
  	if (map_char==80 || map_char==83 || map_char==79)
      	Walkable=1;
  	else if (map_char>31 && map_char <64)
  	{   
  			your_char->status=0;
      	Walkable=1;
    }      	
  	else
  	    Walkable=0;             
////////////////////////////////////////////////////////      
  	if (object_map!=BLANK) return FALSE;
    
		if (Walkable==0) return FALSE;
      
/////OLD_POSITION//////////////////////////////////////
		your_char->xold_pos=your_char->xblock;
		your_char->yold_pos=your_char->yblock;		 
////////////////////////////////////////////////////////      
  	if (direction==NORTH)
  	{  
  	  if (your_char->status==0) 
  	  {
    		object_row = objects[cy+1];
    		object_row[cx]=BOAT;
    	} 
    	your_char->yblock=cy;
  	}
  	else if (direction==SOUTH)
  	{ 
  	  if (your_char->status==0) 
  	  {
    		object_row = objects[cy-1];
    		object_row[cx]=BOAT;
    	}  	 
  	  your_char->yblock=cy;
  	}
  	else if (direction==WEST)
  	{ 
  	  if (your_char->status==0) object_row[cx-1]=BOAT;
   		your_char->xblock=cx;
  	}
  	else if (direction==EAST)
  	{ 
  	  if (your_char->status==0) object_row[cx+1]=BOAT; 
  		your_char->xblock=cx; 	
  	}
  	else
  	{
  	  return FALSE;
  	}  
  	return TRUE;
  }
  
}