#ifndef __SBSGAME_H
#define __SBSGAME_H 

#include "bool.h"
//D E F I N E S//////////////////////////////////////////////////////////////


#define CELL_COLUMNS   200 // size of string +1
#define CELL_ROWS      65 //# of map only map not including object

#define NUM_SCREENS    2   // number of screens in game 

//walkable tile 32 - 64//////////////////////////////////////////////////////
  //char - or 45 is used to skip drawing that tile 

#define QUOTE 34           //char " or 34 exit the city 
#define FOREST 43
#define SMALL_TREES 42
#define LARGE_TREES 37
#define DIRT 46           //.
#define LARGE_DIRT 59
#define SWAMP 58
#define BRIDGE 61
#define BRIDGE2 57        //9
#define SMALL_BTILE 35
#define CAVE 47
#define CITY 49 					//1
#define BOAT 62
#define BLANK 45
#define PINK_TILE 40    	// (     
#define LARGE_BTILE 41    // )             
#define RED_BRICK		48    // 0
#define WOOD				55    // 7
#define BW_TILE			56    // 8
              
//unwalkable tiles 64 - 96 
#define STONE_BLOCKS 66
#define MOUNTIANS 77
#define RIVER 91           //]
#define RIVER3 93          //[
#define MED_OCEAN 79
#define LARGE_OCEAN 83
#define SMALL_OCEAN 80
#define RIVER2 82

//characters,monsters 96 - 128
#define YOU 97

//DIRECTION/////////////////////////////////////////////////////////////////  
#define NORTH 72
#define SOUTH 80  
#define WEST 77
#define EAST 75

//MAP INFO//////////////////////////////////////////////////////////////////
#define CITY_A "city.txt"
#define LAND_A "map.txt"

///////////////////////
int curr_screen;
int map_cell_num[255];
char *screen_1a[CELL_ROWS];
char *objects_1a[CELL_ROWS];
char *screen_2a[CELL_ROWS];
char *objects_2a[CELL_ROWS];
char **universe[NUM_SCREENS];
char **objects[NUM_SCREENS];


typedef struct your_char_info
{ 
  unsigned char status;  //1boat/0land/2city/3cave... 
  unsigned int xold_pos, yold_pos;
  unsigned int xreturn_pos, yreturn_pos;  
	unsigned int xpos, ypos;  //where on screen, always center
	unsigned int x_map_pixel, y_map_pixel;	
	unsigned int xblock, yblock;
	unsigned int gold, silver;
	unsigned char health, strength;
	unsigned char magic, dexterity;
	unsigned char friendly;
		
} your_char, *your_char_ptr;	

//////////////////////////////////////////////////////////////////////////////
void Init_Global_Data();
void Read_Map(char *[CELL_ROWS],char *[CELL_ROWS], char *file_name);
void Init_Char(your_char_ptr your_char);
Boolean Can_Move(your_char_ptr your_char, char **screen,  char **objects, unsigned char direction);

#endif

