'************************************************************************
'*Programmer Name: Shougata Ghosh                                       *
'*Country: Bangladesh                                                   *
'*Address: H-53; Rd-7; Sec-4; Uttara, Dhaka, Bangladesh                 *
'*E-mail Address: s-ghosh@usa.net                                       *
'************************************************************************
'declares all subs and arrays
DECLARE SUB endgame ()
DECLARE SUB checkalphabet (couninp$, correct)
DECLARE SUB writeanswer (categoryname$, categorycheck)
DECLARE SUB sayings (flag%)
DECLARE SUB menuscreen ()
DECLARE SUB menu ()
DECLARE SUB openingscreen ()
DECLARE SUB displaypanel (x$)
DECLARE SUB display ()
DECLARE FUNCTION namecheck$ (a$)
DECLARE SUB showscr ()
DECLARE SUB hangman (x!, flag)
DECLARE SUB playgame (filename$, no.of.recs, category$)

'declares static arrays
DIM SHARED categoryname(1 TO 54) AS STRING
DIM SHARED delet(1 TO 31) AS STRING
DIM SHARED wisesaying(1 TO 28) AS STRING
DIM SHARED randm AS INTEGER
DIM SHARED alphanum AS INTEGER
DIM SHARED alphabet(1 TO 26) AS STRING
DIM SHARED categorycheck(1 TO 31) AS STRING

'calls errorhandler to cope with errors in case any error occurs
ON ERROR GOTO errorhandler

'starts the main part of the game by showing the opening screen
CALL openingscreen

'shows menu
CALL menu
'exits the program
LOCATE 28, 5: PRINT "Press any key to continue"
DO WHILE INKEY$ = ""
LOOP
CALL endgame
END

'this section is called when errors occur
errorhandler:
IF ERR = 53 THEN   'if any file is missing
	CLS             'clears screen
'prints message
	PRINT "File Not Found!! Load The Files & Run Again"
	END             'quits the program because of missing file
END IF

'Purpose: Checks whether one letter is pressed only once or not. If it is
'         pressed more than once, the program won't accept it.
'Parameters:couninp$(string)-the letter which has been entered by the user
'           correct -a flag variable which is ether zero or one
'Local Variable:pass(single)-flag variable either zero(false) or one(true)
'Other sub routines called: None
SUB checkalphabet (couninp$, correct)

	FOR i = 1 TO 26
'if the letter has been entered before
		IF alphabet(i) = UCASE$(couninp$) THEN
			correct = 0  'condition false
			pass = 0
			EXIT FOR     'gets out from the loop
		ELSE
'if the letter hasn't been entered before
			pass = 1
		END IF
	NEXT
'enters this section if the letter is pressed for the first time
	IF pass <> 0 THEN
'incrments the value of alphanum by one
		alphanum = alphanum + 1
'stores the letter pressed by the user in the variable alphabet at cell number
'alphanum
		alphabet(alphanum) = UCASE$(couninp$)
		correct = 1     'condition true
	ELSE
'beeps if letter has been entered before
		BEEP
	END IF

END SUB

'Purpose:Prints a display bar which has all the twenty-six alphabets. If a
'        letter is pressed then that letter vanishes from the display bar.
'Parameters:None
'Local Variables:None
'Other sub routines called: None
SUB display

	LINE (0, 0)-(639, 479), 14, B    'draws a box
	LINE (10, 10)-(629, 469), 14, B  'draws another box inside the first one
	PAINT (3, 3), 14                 'colours the space between two boxes
	'writes the twenty-six alphabets
	LOCATE 9, 14: COLOR 10: PRINT "A B C D E F G H I J K L M N O P Q R S T U V W X Y Z"
	'this section draws vertical bars to separate one letter from the other
	FOR i = 116 TO 516 STEP 16
		LINE (i, 118)-(i, 148), 9
	NEXT
	'this section draws border around the letters
	LINE (93, 110)-(522, 160), 8, B
	LINE (97, 115)-(517, 155), 8, B
	PAINT (95, 113), 8                'colours the border
	LINE (102, 120)-(512, 150), 8, B
	PAINT (100, 117), 1, 8            'colours the border
	COLOR 15                          'changes the colour to bright white

END SUB

'Purpose: This sub removes the letter, which has been entered by the user,
'         from the display panel.
'Local Variable/Array:check(string array)-contains twenty-six alphabets for
'                                         matching
'                     coloumn(single) -coloumn number where the alphabets are
'                     printed
'Parameters: x$(string)-Stores the letter to be deleted from the display panel
'Other sub routines called: None
SUB displaypanel (x$)

'declares the array check
	DIM check(65 TO 90) AS STRING
'this section stores all the alphabets in the string array check
	FOR i = 65 TO 90
		check(i) = CHR$(i)
	NEXT
	FOR i = 65 TO 90
'increment the value of coloumn by one
		coloumn = coloumn + 1
		IF UCASE$(x$) = check(i) THEN    'checks which letter has been pressed
			COLOR 2                       'changes the color to green
'removes the letter, which has been pressed, from the display panel
			LOCATE 9, (coloumn + 7 - 1) * 2: PRINT " "
		END IF
	NEXT
	COLOR 15                            'changes the colour to bright white

END SUB

SUB endgame

	SCREEN 0
	CLS
	LOCATE 15, 5: PRINT "This Game is licensed to Shougata Ghosh"
	LOCATE 16, 5: PRINT "Write comments:  "
	LOCATE 17, 5: PRINT "H-53; Rd-7; Sec-4"
	LOCATE 18, 5: PRINT "Uttara Model Town"
	LOCATE 19, 5: PRINT "      Dhaka      "
	LOCATE 20, 5: PRINT "    Bangladesh   "
	LOCATE 21, 5: PRINT "Email No: s-ghosh@usa.net"

END SUB

'Purpose: Draws the stand. Also draws the man part by part whenever the letter
'         entered is not there in the word. Shows the wise-saying from a file
'         into the screen.
'Parameters: x(single)-The value ranges from zero to ten. If value is 0 then
'                      draws the stand. If value is from one to ten then draws
'                      the man part by part.
'            flag(single)-The value of this variable can only be 0(flase) or 1
'                         (true).If it is 1 then the player loses.
'Other sub routines called:sayings-To print the wise-saying to the monitor.
'Constants:bl-Stores a constant value for blue used for changing colour
'          gr-Stores a constant value for green used for changing colour
'
SUB hangman (x, flag)

'declares constants
	bl = 65536
	gr = 256
	SELECT CASE x
		CASE 0       'draws the stand and background
			PALETTE 9, (bl * 29) + (gr * 23) + 52
			PALETTE 14, (bl * 38) + (gr * 52) + 0
			LINE (10, 200)-(629, 460), 9, BF
			LINE (10, 450)-(50, 450), 0
			LINE (25, 450)-(25, 250), 0
			LINE (25, 250)-(90, 250), 0
			LINE (90, 250)-(90, 270), 0
			LINE (0, 0)-(639, 479), 14, B
			LINE (10, 10)-(629, 469), 14, B
			PAINT (3, 3), 14
			LOCATE 25, 40: PRINT "Press <SPACEBAR> to quit"
		CASE 1       'draws the head
			CIRCLE (90, 290), 20, 0
			LINE (70, 285)-(108, 285), 0
			PAINT (80, 280), 0
			PALETTE 5, (bl * 41) + (gr * 48) + 63
			PAINT (90, 290), 5, 0
		CASE 2       'draws the body
			FOR i = 89 TO 91
				LINE (i, 310)-(i, 380), 0
			NEXT
		CASE 3       'draws the right leg
			FOR i = 89 TO 91
				LINE (i, 380)-(i - 25, 415), 0
			NEXT
		CASE 4       'draws the left leg
			FOR i = 89 TO 91
				LINE (i, 380)-(i + 25, 415), 0
			NEXT
		CASE 5       'draws the rigth arm
			FOR i = 89 TO 91
				LINE (i, 320)-(i - 25, 360), 0
			NEXT
		CASE 6       'draws the left arm
			FOR i = 89 TO 91
				LINE (i, 320)-(i + 25, 360), 0
			NEXT
		CASE 7       'draws the right eye
			CIRCLE (80, 292), 3, 0
			LINE (77, 292)-(83, 292), 0
			PAINT (80, 293), 0
		CASE 8       'draws the left eye
			CIRCLE (100, 292), 3, 0
			LINE (97, 292)-(103, 292), 0
			PAINT (100, 293), 0
		CASE 9       'draws the nose
			CIRCLE (90, 295), 2, 0
			PAINT (90, 296), 0
		CASE 10      'draws the lips
			LINE (87, 302)-(93, 302), 7
			LINE (87, 302)-(84, 305), 7
			LINE (93, 302)-(96, 305), 7
'repaints the message "Press <SPACEBAR> to quit" with the background colour
			LINE (300, 350)-(540, 410), 9, BF
'gives three beeps
			BEEP: BEEP: BEEP
'the value of flag becomes one
			flag = 1
'call sayings which displays wise-sayings
			CALL sayings(2)
		END SELECT

END SUB

'Purpose:Waits for the user's choice.
'Parameters:None
'Local Variables:menuchoice$(string)-stores the choice selected by the user
'                flag(single)-stores value which is either zero or one. When
'                             flag is one the program exits from this sub
'Other sub-routines called:playgame-plays the game
'                          menuscreen-draws the screen used by the menu
'                          help-displays help
SUB menu

'calls menuscreen which draws the screen
	CALL menuscreen
'loops until user wishes to quit
	DO
		flag = 0
'takes user's choice, which is categories or help or quit, in menuchpice$
		menuchoice$ = INPUT$(1)
		IF UCASE$(menuchoice$) = "S" THEN  'when user chooses categories
'when user's choice is categories
	'shows the six categories
			LOCATE 10, 30: COLOR 15: PRINT "CATEGORIES"
	'highlights "C" of "COUNTRY"
			LOCATE 12, 25: COLOR 7: PRINT "C"
			LOCATE 12, 26: COLOR 15: PRINT "OUNTRY"
	'highlights "L" of "LEADERS"
			LOCATE 12, 40: COLOR 7: PRINT "L"
			LOCATE 12, 41: COLOR 15: PRINT "EADERS"
	'highlights "M" of "MOVIES"
			LOCATE 14, 25: COLOR 7: PRINT "M"
			LOCATE 14, 26: COLOR 15: PRINT "OVIES"
	'highlights "Y" of "CURRENCY"
			LOCATE 14, 40: COLOR 15: PRINT "CURRENC"
			LOCATE 14, 47: COLOR 7: PRINT "Y"
			LOCATE 16, 25: COLOR 7: PRINT "W"
	'highlights "W" of "WRITER"
			LOCATE 16, 26: COLOR 15: PRINT "RITER"
			LOCATE 16, 40: COLOR 7: PRINT "B"
	'highlights "B" of "BOOKS"
			LOCATE 16, 41: COLOR 15: PRINT "OOKS"
	'draws the border around the six categories
			LINE (190, 175)-(250, 189), 4, B
			LINE (310, 175)-(370, 189), 4, B
			LINE (190, 207)-(241, 220), 4, B
			LINE (310, 207)-(379, 220), 4, B
			LINE (190, 239)-(241, 252), 4, B
			LINE (310, 239)-(353, 252), 4, B
	'takes user's choice of categories
			menuchoice$ = INPUT$(1)
			IF UCASE$(menuchoice$) = "C" THEN
		'when choice is country
			'calls playgame
				CALL playgame("COUNTRY.HAN", 44, "COUNTRY")
				CALL menuscreen             'redraws menuscreen
			END IF
			IF UCASE$(menuchoice$) = "L" THEN
		'when choice is leaders
			'calls playgame
				CALL playgame("LEADERS.HAN", 30, "LEADERS")
				CALL menuscreen
			END IF
			IF UCASE$(menuchoice$) = "M" THEN
		'when choice is cinemas
			'calls playgame
				CALL playgame("CINEMAS.HAN", 51, "MOVIES")
				CALL menuscreen
			END IF
			IF UCASE$(menuchoice$) = "Y" THEN
		'when choice is currency
			'calls playgame
				CALL playgame("CURRENCY.HAN", 27, "CURRENCY")
				CALL menuscreen
			END IF
			IF UCASE$(menuchoice$) = "W" THEN
		'when choice is writers
			'calls playgame
				CALL playgame("WRITERS.HAN", 46, "WRITER")
				CALL menuscreen
			END IF
			IF UCASE$(menuchoice$) = "B" THEN
		'when choice is books
			'calls playgame
				CALL playgame("BOOKS.HAN", 54, "BOOKS")
				CALL menuscreen
			END IF
		'ELSE
		'   LOCATE 22, 50: PRINT "INVALID CHOICE"
		'   'FOR i = 1 TO 9000: NEXT
		'   LINE (390, 320)-(540, 360), 8, BF
		END IF
'when user's choice is to exit the program
		IF UCASE$(menuchoice$) = "Q" THEN
	'the value of flag becomes one which evntually finishes the game
			flag = 1
		END IF
	LOOP UNTIL flag = 1
	
END SUB

'Purpose: This sub routine prepares the menuscreen from where the user makes
'         the choice. The sub routine menu also uses this screen.
'Local Variable: None
'Other sub routines called: None
'Parameters: None
SUB menuscreen

	CLS                'clears the screen
'this section draws the menu screen
	PSET (15, 12), 15
	DRAW "r610 d25 l610 u25"
	PAINT (9, 15), 8, 15
	LOCATE 2, 5: COLOR 15: PRINT "CATEGORIE"
'highlights "S" of "CATEGORIES"
	LOCATE 2, 14: COLOR 7: PRINT "S "
'highlights "H" of "HELP"
'''    LOCATE 2, 35: COLOR 7: PRINT "H"
'''    LOCATE 2, 36: COLOR 15: PRINT "ELP"
'highlights "Q" of "QUIT"
	LOCATE 2, 74: COLOR 7: PRINT "Q"
	LOCATE 2, 75: COLOR 15: PRINT "UIT"
'draws the border around the categories
	LINE (0, 0)-(639, 459), 6, B
	LINE (5, 5)-(634, 454), 6, B
	PAINT (4, 4), 6
	LINE (0, 459)-(639, 479), 0, BF

END SUB

'Purpose: This function takes the word selected by the computer, deletes all
'         the spaces and returns the word without the spaces.
'Local Variable: b$(string)-The new word without spaces is stored here
'Parameters: a$(string)-This parameter holds the word selected by the computer
'                       from the file
'Other sub routines called: None
FUNCTION namecheck$ (a$)

	FOR i = 1 TO LEN(a$)
		B$ = B$ + MID$(a$, i, 1)
		IF MID$(a$, i + 1, 1) = " " THEN i = i + 1
	NEXT
	namecheck$ = B$

END FUNCTION

'Purpose: This sub shows the opening screen which contains the name of the
'         program and the programmer
'Local variable:programmer$(string)-Contains the name of the programmer
'               coloumn(single)-Contains the coloumn number which changes
'               introduction$(string)-Stores the lines read from the file
'Parameters: None
'Other sub routines called: showscr-To wait for the user's response
SUB openingscreen
  
	SCREEN 12
'assigns constant values for bl & gr
	bl = 65536
	gr = 256
'changes existing colours
	PALETTE 1, (63 * bl) + (29 * gr) + 48 'stores violet colour in 1
	PALETTE 2, (55 * bl) + (0 * gr) + 0   'stores indigo colour in 1
	PALETTE 3, (63 * bl) + (45 * gr) + 0  'stores blue colour in 1
	PALETTE 4, (8 * bl) + (38 * gr) + 0   'stores green colour in 1
	PALETTE 5, (0 * bl) + (63 * gr) + 63  'stores yellow colour in 1
	PALETTE 6, (0 * bl) + (28 * gr) + 63  'stores orange colour in 1
	PALETTE 7, (0 * bl) + (0 * gr) + 63   'stores red colour in 1
'writes enlarged "h" of hang
	PSET (80, 50), 15
	DRAW "c1 d100 r15 u42 r15 d42 r15 u100 l15 d42 l15 u42 l15"
'writes enlarged "a" of hang
	PSET (140, 50), 15
	DRAW "c2 d100 r15 u42 r15 d42 r15 u100 l45 bd15 br15 d27 r15 u27 l15"
'writes enlarged "n" of hang
	PSET (200, 50), 15
	DRAW "c3 d100 r15 u42 m+15,+42 r15 u100 l15 d42 m-15,-42 l15"
'writes enlarged "g" of hang
	PSET (260, 50), 15
	DRAW "c4 d100 r55 u15 l5 u27 r5 u15 l25 d15 r5 d27 l20 u70 r40 u15 l55"
'writes enlarged "h" of him
	PSET (370, 50), 15
	DRAW "c5 d100 r15 u42 r15 d42 r15 u100 l15 d42 l15 u42 l15"
'writes enlarged "i" of him
	PSET (430, 50), 15
	DRAW "c6 r45 d15 l15 d70 r15 d15 l45 u15 r15 u70 l15 u15"
'writes enlarged "m" of him
	PSET (490, 50), 15
	DRAW "c7 d100 r15 u70 m+15,+30 m+15,-30 d70 r15 u100 l15 m-15,+30 m-15,-30 l15"
'this section writes the name of the programmer in the screen
	programmer$ = "* P R O G R A M * C O M P O S E D * B Y * S H O U G A T A *"
	coloumn = 10
	FOR i = 1 TO 59
		coloumn = coloumn + 1
		LOCATE 12, coloumn: PRINT UCASE$(MID$(programmer$, i, 1));
'dummy loop to slow down the speed of writing
		FOR j = 1 TO 1000: NEXT
	NEXT
'dummy loop which waits so that user can view the screen
	FOR j = 1 TO 50000: NEXT
	DO WHILE INKEY$ = ""
	LOOP
'this section shows the introductory screen
	CLS
'opens the file which contains the introductory screen
	OPEN "INTRODUC.han" FOR INPUT AS #1
'reads the contents of the file to the variable "introduction$"
	FOR i = 1 TO 22
		LINE INPUT #1, introduction$
'shows the introductory screen
		PRINT introduction$
	NEXT
'closes the file
	CLOSE #1
	LINE (0, 0)-(639, 479), 2, B
	LINE (5, 5)-(634, 474), 2, B
	PAINT (3, 3), 2
'calls sub showscr which waits until a key is pressed by the user
	CALL showscr
	
END SUB

'Purpose: This is the main part of the program where the game is played.
'Parameters: filename$(string)-the name of file to be opened
'            no.of.recs:(single)-number of records in the file
'            category$(string)-the category that has been chosen by the user
'Local Variables: c(single)-stores a random number
'                 n(single)-one fourth number of spaces
'                 flag(single)-either zero or one.When flag is one then the
'                              program exits this sub
SUB playgame (filename$, no.of.recs, category$)

	CLS
	COLOR 7
	LOCATE 2, 70: PRINT category$
	OPEN filename$ FOR INPUT AS #1
	FOR i = 1 TO no.of.recs
		INPUT #1, categoryname(i)
	NEXT
	CLOSE #1
	RANDOMIZE TIMER
	c = INT(RND * no.of.recs) + 1
	DIM wordnum(2) AS INTEGER
	SCREEN 12
	LOCATE 3, 4: COLOR 15
	n = 0
	FOR i = 1 TO LEN(categoryname(c))
		n = n + 1
		IF MID$(categoryname(c), i, 1) = " " THEN
			IF wordnum(1) <> 0 THEN
				PRINT
				n = 1
				wordnum(2) = i
				i = i + 1
			ELSE
				PRINT
				n = 1
				wordnum(1) = i
				i = i + 1
			END IF
		END IF
		PRINT TAB(n * 4); CHR$(196);
	NEXT
	flag = 0
	counlength = LEN(categoryname(c))
	actualword$ = categoryname(c)
	CALL hangman(0, flag)
	a$ = categoryname(c)
	k$ = namecheck$(a$)
	count = 0
	h = 2
	CALL display
	alphanum = 0
	FOR i = 1 TO 26
		alphabet(i) = ""
	NEXT
	DO WHILE flag = 0
		DO
			LOCATE 6, 7
			COLOR 15
			PRINT "Enter Letter :"
			couninp$ = INPUT$(1)
			LOCATE 6, 22: PRINT UCASE$(couninp$)
			IF couninp$ = "" THEN
				correct = 0
				BEEP
			ELSE
				CALL checkalphabet(couninp$, correct)
			END IF
		LOOP WHILE correct = 0
		IF couninp$ = CHR$(32) THEN EXIT DO
		x$ = couninp$
		CALL displaypanel(x$)
		inp$ = couninp$
		FOR i = 1 TO counlength
			h = 3
			IF MID$(categoryname(c), i, 1) = UCASE$(couninp$) THEN
				categorycheck(i) = couninp$
				IF wordnum(2) <> 0 AND i >= wordnum(2) THEN
					h = 5
					LOCATE h, (i - wordnum(2)) * 4: PRINT UCASE$(couninp$)
				ELSEIF wordnum(2) = 0 AND wordnum(1) <> 0 AND i >= wordnum(1) THEN 'AND i < wordnum(2) THEN
					h = 4
					LOCATE h, (i - wordnum(1)) * 4: PRINT UCASE$(couninp$)
				ELSEIF i >= wordnum(1) AND i < wordnum(2) THEN
					h = 4
					LOCATE h, (i - wordnum(1)) * 4: PRINT UCASE$(couninp$)
				ELSE
					LOCATE h, i * 4: PRINT UCASE$(couninp$)
				END IF
				count = 1
			END IF
		NEXT
		IF count <> 1 THEN
			x = x + 1
			CALL hangman(x, flag)
			IF flag = 1 THEN
				CALL writeanswer(categoryname(c), arraycheck)
				CALL showscr
			END IF
		END IF
		count = 0
		FOR i = 1 TO counlength
			check$ = check$ + categorycheck(i)
		NEXT
		IF wordnum(2) <> 0 THEN
			IF UCASE$(RIGHT$(check$, (counlength - 2))) = UCASE$(k$) THEN
				FOR i = 1 TO 31
					categorycheck(i) = ""
				NEXT
				BEEP
				CALL showscr
				CALL sayings(1)
				EXIT DO
			END IF
		ELSEIF wordnum(1) <> 0 THEN
			IF UCASE$(RIGHT$(check$, (counlength - 1))) = UCASE$(k$) THEN
				FOR i = 1 TO 31
					categorycheck(i) = ""
				NEXT
				BEEP
				CALL sayings(1)
				CALL showscr
				EXIT DO
			END IF
		ELSE
			IF UCASE$(RIGHT$(check$, counlength)) = UCASE$(k$) THEN
				FOR i = 1 TO 31
					categorycheck(i) = ""
				NEXT
				BEEP
				CALL sayings(1)
				CALL showscr
				EXIT DO
			END IF
		END IF
	LOOP
	
END SUB

'Purpose: Prints wise-saying on the screen after the game has been won or lost
'Local Variables/Arrays: wisesaying(string array)-Stores data from file
'                        randm(single)-a random number is stored in the file
'Parameters: flag(integer)-Either zero or one. If player wins then flag is one
'                          else flag is zero
'Other sub routines called:None
SUB sayings (flag%)

	SELECT CASE flag%
		CASE 1
'comes here when the player has won the game
'this section deletes all the previous data that was stored here
			FOR i = 1 TO 28
				wisesaying(i) = ""
			NEXT
'opens file
			OPEN "SUCCESS.han" FOR INPUT AS #1
'this section reads data from file stores it in wisesayings
			FOR i = 1 TO 16
				INPUT #1, wisesaying(i)
			NEXT
			CLOSE #1      'closes file "SUCCESS.dat"
'chooses a random number from one to fifteen
			RANDOMIZE TIMER
			randm = INT(RND * 15) + 1
			LOCATE 19, 40
'print the wisesaying on the screen
			PRINT wisesaying(randm)
		CASE 2
'comes here when the player has lost the game
'this section deletes all the previous data that was stored here
			FOR i = 1 TO 28
				wisesaying(i) = ""
			NEXT
'opens file
			OPEN "UNSUCCES.han" FOR INPUT AS #1
'this section reads data from file stores it in wisesayings
			FOR i = 1 TO 14
				INPUT #1, wisesaying(i)
			NEXT
			CLOSE #1      'closes the file "UNSUCCESS.dat"
'chooses a random number from one to fifteen
			RANDOMIZE TIMER
			randm = INT(RND * 13) + 1
			LOCATE 18, 40
'print the wisesaying on the screen
			PRINT wisesaying(randm)
	END SELECT

END SUB

'Purpose: This sub waits until a key is pressed by the user
'Local variable: None
'Parameters: None
'Other sub routines called: None
SUB showscr

	LOCATE 28, 50
'prints message
	COLOR 15: PRINT "Press any key to continue"
'loops until a key is pressed
	DO WHILE INKEY$ = ""
	LOOP
	CLS

END SUB

'Purpose: This sub writes the answer after the game has been lost
'Local Variables/Arrays: y(string array)-stores each letter in each cell
'                        row(single)-stores the row number
'                        wordnum(integer array)-number of words in the answer
'Parameters: categoryname$(string)
'            categorycheck$(string)
'Other sub routines called: None
SUB writeanswer (categoryname$, categorycheck)
'declares a string array
	DIM y(1 TO 31) AS STRING
'this section stores each letter of the word in the array y
	FOR i = 1 TO LEN(categoryname$)
		y(i) = MID$(categoryname$, i, 1)
	NEXT
'declares an integer array to record the number of words
	DIM wordnum(2) AS INTEGER
'this section stores the number of words in the answer
	FOR i = 1 TO LEN(categoryname$)
		IF MID$(categoryname$, i, 1) = " " THEN
'when the number of words is more than one
			IF wordnum(1) <> 0 THEN
				wordnum(2) = i
				i = i + 1
			ELSE
				wordnum(1) = i
				i = i + 1
			END IF
		END IF
	NEXT
	row = 3   'assigns the variable row with three
'this section prints the answer
	FOR i = 1 TO LEN(categoryname$)
		IF y(i) <> " " THEN
			row = 3
			'categorycheck(i) = couninp$
			IF wordnum(2) <> 0 AND i >= wordnum(2) THEN
'when there are three words in the answer
				row = 5
				COLOR 7
				LOCATE row, (i - wordnum(2)) * 4: PRINT UCASE$(y(i))
			ELSEIF wordnum(2) = 0 AND wordnum(1) <> 0 AND i >= wordnum(1) THEN
'when there are two words in the answer
				row = 4
				COLOR 7
				LOCATE row, (i - wordnum(1)) * 4: PRINT UCASE$(y(i))
			ELSEIF i >= wordnum(1) AND i < wordnum(2) THEN
'when there are two words in the answer
				row = 4
				COLOR 7
				LOCATE row, (i - wordnum(1)) * 4: PRINT UCASE$(y(i))
			ELSE
'when there is only one word in the answer
				COLOR 7
				LOCATE row, i * 4: PRINT UCASE$(y(i))
			END IF
			count = 1
		END IF
	NEXT

END SUB

