'*****************************************************************************
'Kiss Pong: Pong program made as fast and simple as possible (22 minutes).
'           (Kiss = Keep it simple stupid; important game principle)
'
'   player 1(left) keys:  up "w", down "s"
'   player 2(right) keys: up "i", down "k"
' 
'   Game too fast? Change the constant WaitCnt in a higher number!
'   It is currently set for a 486DX2-66.
'
'   (c) Marcel Smolenaars - 1997
'       m_smolenaars@hotmail.com
'       http://www.geocities.com/smolenaars.geo
'*****************************************************************************

CONST WaitCnt& = 5000      'computer speed constant: long integer

CONST MinX = 10: MaxX = 310
CONST MinY = 10: MaxY = 190
CONST BatHt = 15, BallSize = 3, BatSpeed = 4

DIM BallX AS INTEGER, BallY AS INTEGER, BallDx AS INTEGER, BallDy AS INTEGER
DIM Winner AS INTEGER, yLBat AS INTEGER, yRBat AS INTEGER
DIM WaitN AS LONG

SCREEN 13
DO
  Winner = 0
  BallX = MinX + (MaxX - MinX) / 2: BallY = MinY + (MaxY - MinY) / 2
  yRBat = MinY + (MaxY - MinY) / 2: yLBat = yRBat
  BallDx = 1: BallDy = 1
  CLS
  GOSUB DrawAll
  DO
    
    GOSUB EraseBall
    IF BallX + BallDx <= MinX THEN
      IF BallY + BallSize >= yLBat AND BallY <= yLBat + BatHt THEN BallDx = -BallDx: flag = 1
    END IF
    IF BallX + BallSize + BallDx >= MaxX THEN
      IF BallY + BallSize >= yRBat AND BallY <= yRBat + BatHt THEN BallDx = -BallDx: flag = 1
    END IF
   
    IF BallY + BallSize + BallDy >= MaxY OR BallY + BallDy <= MinY THEN BallDy = -BallDy
   
    IF BallX < MinX THEN Winner = 1
    IF BallX > MaxX THEN Winner = 2
   
    BallX = BallX + BallDx
    BallY = BallY + BallDy
   
    GOSUB DrawBall
    FOR WaitN = 0 TO WaitCnt: NEXT
    a$ = LCASE$(INKEY$)
    IF a$ <> "" THEN flag = ASC(a$) ELSE flag = 0
    SELECT CASE flag
     CASE ASC("i"): GOSUB EraseRBat: yRBat = yRBat - BatSpeed: GOSUB DrawRBat
     CASE ASC("k"): GOSUB EraseRBat: yRBat = yRBat + BatSpeed: GOSUB DrawRBat
     CASE ASC("w"): GOSUB EraseLBat: yLBat = yLBat - BatSpeed: GOSUB DrawLBat
     CASE ASC("s"): GOSUB EraseLBat: yLBat = yLBat + BatSpeed: GOSUB DrawLBat
    END SELECT
  LOOP UNTIL Winner
 
  IF Winner = 1 OR Winner = 2 THEN
   BEEP
   PRINT "Player"; Winner; " won !"
   DO
     PRINT "Play again (y/n) ?";
     a$ = LCASE$(INPUT$(1))
   LOOP UNTIL a$ = "n" OR a$ = "y"
  END IF

LOOP UNTIL a$ = "n"
END

DrawLBat: LINE (MinX, yLBat)-STEP(0, BatHt), 15: RETURN
EraseLBat: LINE (MinX, yLBat)-STEP(0, BatHt), 0: RETURN
DrawRBat: LINE (MaxX, yRBat)-STEP(0, BatHt), 15: RETURN
EraseRBat: LINE (MaxX, yRBat)-STEP(0, BatHt), 0: RETURN
DrawBall: LINE (BallX, BallY)-STEP(BallSize, BallSize), 15, BF: RETURN
EraseBall: LINE (BallX, BallY)-STEP(BallSize, BallSize), 0, BF: RETURN
DrawAll:
  LINE (MinX, MinY)-(MaxX, MinY), 15
  LINE (MinX, MaxY)-(MaxX, MaxY), 15
  GOSUB DrawLBat: GOSUB DrawRBat: GOSUB DrawBall
  RETURN

