/*
  Program:      Mine Mayhem
  File:         board.h
  Date:         July, 1996 to February, 1997

  Everything that defines the board.

  Freeware, Copyright 1996-7 Jason Hood.

  You are free to use this code, or a portion thereof, as long as an
  appropriate acknowledgement is made.
*/

#ifndef _board_h
#define _board_h

#include <tws/button.h>
#include "faces.h"
#include "digits.h"


// The levels - 2 to 10 are the appropriate random games.
enum { BEGINNER = 11, INTERMEDIATE, EXPERT, CUSTOM };

// Board dimensions.
struct Layout
{
  int width, height, mines;

  float diff() { return float(width*height) / mines; }

  operator==(const Layout& layout)
  {
    return (width == layout.width && height == layout.height &&
            mines == layout.mines);
  }
};


// A square on the board
struct Sq
{
  int value,                            // Number of mines around the square
                                        // or 9 for a mine.
      status;                           // 0 - unopened, 1 - opened,
                                        // 2 - marked, 3 - question.
};


// The minimum and maximum dimensions the board can have.
extern int MinGridX, MaxGridX, MinGridY, MaxGridY;

const Layout Beginner     = {  8,  8, 10 },
             Intermediate = { 16, 16, 40 },
             Expert       = { 30, 16, 99 };

extern Layout Custom, Random;


// This is queued when the right mouse button is pressed on the "face" button
#define E_BUTTONR(ID, function) \
  if (ev->Type == W_NOTIFY && ev->p1 == ID && ev->p2 == 1003) \
  { \
    function(); \
    return TRUE; \
  }


// The "face" button in the middle of the board.
class FaceButton : public IconButton {

  friend class BoardWindow;

public:
  FaceButton(Window* parent, ControlID ID, int x, int y, int icon) :
    IconButton(parent, ID, x, y, x+FACEICONW-1, y+FACEICONH-1, FaceIcon[icon]),
    curicon(icon) {}

  void ChangeIcon(int NewIcon)
  {
    IconButton::ChangeIcon(FaceIcon[NewIcon]);
    curicon = NewIcon;
  }
  void Display(int Icon);

protected:
  int curicon;

  // Display a different icon when the button is pressed
  void PaintWindow(int x1, int y1, int x2, int y2)
  {
    IconButton::ChangeIcon(FaceIcon[isDown ? FACEPUSHED : curicon]);
    IconButton::PaintWindow(x1, y1, x2, y2);
  }

  void RButtonDown(int, int, int)
  {
    ws.QueueEvent(parent, event(W_NOTIFY, butID, 1003));
  }

  DECLARE_RESPONSE_TABLE;
};


class BoardWindow : public Window
{
public:
  BoardWindow(int Level);
  ~BoardWindow();

  void NewGame(int Level = 0);
  int GetLevel() { return level; }
  BOOL GameinProgress() { return (isStarted && !isFinished); }
  void AdjustGame();                    // Changing from CLEAR to CROSS
  void AdjustWrap();                    // Toggling the Wrap-around option

protected:

  void Resize(int width, int height);
  void PaintWindow(int x1, int y1, int x2, int y2);

  void PlaceMine();                     // Place a mine on the grid
  BOOL MoveMine(int x, int y);          // Move a mine somewhere else
  void Open(int x, int y);              // Open the square
  void Clear(int x, int y);             // Open the surrounding squares
  void Mark(int x, int y);              // Mark the square
  void ClearAround(int x, int y, BOOL HiLite = TRUE);
  void HighLight(int x, int y, int type); // Indicate mine count is not right
  void LButtonUp(int, int, int);        // Remove the highlight for the
  void RButtonUp(int, int, int);        //  particular button
  void MButtonUp(int, int, int);
  BOOL GameOver(int x, int y);          // Test for game over and record time
  int  Count(int x, int y, int what);   // Count "what" around (x, y)
  void MineCount();                     // Display the number of mines to find
  void SpaceCount();                    // Display the number of spaces to clear
  void DisplayTime(BOOL full = FALSE);  // Display the time
  void Display(int num, int x, int y,   // Display num using LED digits
               ViewBuffer* bmp[] = Digit, BOOL zeros = FALSE);
  void DisplaySquare(int x, int y, int square, BOOL refresh = TRUE);
                                        // Display a square on the grid

  BOOL Convert(int& x, int& y);         // Mouse co-ord to grid co-ord

  void cmNewGame();                     // Press the button for a new game
  void LButtonDown(int x, int y, int);  // Left mouse button pressed
  void RButtonDown(int x, int y, int);  // Right  "      "      "
  void MButtonDown(int x, int y, int);  // Middle "      "      "
  void Timer();                         // Update the time taken
  void cmPause(int = 0);                // Right click the button or use
                                        // the P key (hence the parameter)

  DECLARE_RESPONSE_TABLE;

  FaceButton* Face;
  Sq** grid;                            // The minefield
  Layout layout;                        // Current layout
  int level,                            // Current level
      mines,                            // Mines found
      spaces,                           // Spaces cleared
      mynes,                            // Correct number of mines found
      secs, mils,                       // Time taken
      startmils, oldsecs, pausemils,    // Time calibration
      hx, hy;                           // "Highlight" centre position
  BOOL isStarted,                       // The game has begun
       isFinished,                      // The game is over
       isHiLite,                        // There is a "highlight" marked
       isPaused;                        // The game is paused
  int ox, oy, timex, spacesx;           // Offsets for display
  ViewBuffer* gridsave;                 // Copy of the grid for pause
};

extern BoardWindow* Board;


// Provide a simplified means of doing every square around (x, y), since
//
//  for (int y1 = y-1; y1 <= y+1; y1++)
//   for (int x1 = x-1; x1 <= x+1; x1++)
//
// fails on the edges.
class Around
{
public:
  Around(int cx, int cy, int width, int height);
  BOOL next();                        // FALSE if the loop is finished
  BOOL done();                        // TRUE if the loop is finished
  int x();
  int y();

protected:
  int row(int r);                     // Make sure the co-ordinate is
  int col(int c);                     //  valid for wrap-around
  int w, h;                           // Width and height
  int ax, ay,                         // "Absolute" - could be off-grid
      rx, ry;                         // "Real" - the actual square
  int x1, y1, x2, y2;                 // The top-left, bottom-right corners
};

#endif

