/*
  Program:      Mine Mayhem
  File:         custom.cc
  Date:         July, 1996 to February, 1997

  The custom layout dialog box and menu.

  Freeware, Copyright 1996-7 Jason Hood.

  You are free to use this code, or a portion thereof, as long as an
  appropriate acknowledgement is made.
*/

#include "custom.h"

#define EDIT_ID_WIDTH   20001
#define EDIT_ID_HEIGHT  20002
#define EDIT_ID_MINE    20003

#define ID_STR          20004
#define ID_BEG          20005
#define ID_INT          20006
#define ID_EXP          20007
#define ID_RAN          20008
#define ID_RES          20009


DEFINE_RESPONSE_TABLE(CustomDlg, TabWin)

   E_SPINCHANGE(EDIT_ID_WIDTH,  cmChange)
   E_SPINCHANGE(EDIT_ID_HEIGHT, cmChange)
   E_SPINCHANGE(EDIT_ID_MINE,   cmChange)

   E_BUTTONUP(ID_STR, cmStr)
   E_BUTTONUP(ID_BEG, cmBeg)
   E_BUTTONUP(ID_INT, cmInt)
   E_BUTTONUP(ID_EXP, cmExp)
   E_BUTTONUP(ID_RAN, cmRan)
   E_BUTTONUP(ID_RES, cmRes)

   E_BUTTONUP(ID_OK,     cmOK)
   E_BUTTONUP(ID_CANCEL, cmCancel)

END_RESPONSE_TABLE


#define DLG_WIDTH  (SysFont->width*42)
#define DLG_HEIGHT (SysFont->height*14)

CustomDlg::CustomDlg() :
  TabWin(NULL, "Custom",
         (ws.GetDeskWidth()-DLG_WIDTH-FWIDTH*2)/2,
         (ws.GetDeskHeight()-DLG_HEIGHT-FWIDTH-CAPTION_HEIGHT)/2,
         (ws.GetDeskWidth()+DLG_WIDTH+FWIDTH*2)/2-1,
         (ws.GetDeskHeight()+DLG_HEIGHT+FWIDTH+CAPTION_HEIGHT)/2,
         WA_VISABLE | WA_BORDER | WA_CAPTION | WA_SAVEAREA),
  isOK(FALSE), save(Custom)
{
  int ox = FWIDTH+8+StringWidth("Height:  ", SysFont),
      oy = FWIDTH+CAPTION_HEIGHT,
      wid = 10*SysFont->width;

  WidthEdit = new Spin(this, EDIT_ID_WIDTH, "", 3, ox, oy, wid);
  WidthEdit->SetNum(Custom.width);
  WidthEdit->SetMin(MinGridX); WidthEdit->SetMax(MaxGridX);
  AddAccelerator('W', WidthEdit);
  oy += (SysFont->height+4)*2;
  HeightEdit = new Spin(this, EDIT_ID_HEIGHT, "", 3, ox, oy, wid);
  HeightEdit->SetNum(Custom.height);
  HeightEdit->SetMin(MinGridY); HeightEdit->SetMax(MaxGridY);
  AddAccelerator('H', HeightEdit);
  oy += (SysFont->height+4)*2;
  MineEdit = new Spin(this, EDIT_ID_MINE, "", 4, ox, oy, wid);
  MineEdit->SetNum(Custom.mines);
  AddAccelerator('M', MineEdit);

  ox = FWIDTH+8+StringWidth("Difficulty:  ", SysFontItallic);
  oy += (SysFont->height+4)*3-2;
  char temp[6];
  sprintf(temp, "%.3g", Custom.diff());
  Diff = new StaticText(this, temp, ox, oy, wid);

  wid = 14*SysFont->width;
  int hyt = SysFontBold->height+4;
  ox = cx2-FWIDTH-8-wid; oy = FWIDTH+CAPTION_HEIGHT + SysFont->height;
  Str = new TextButton(this, ID_STR, ox,oy, ox+wid-1,oy+hyt-1, "&Stored");
  oy += hyt+4;
  Beg = new TextButton(this, ID_BEG, ox,oy, ox+wid-1,oy+hyt-1, "&Beginner");
  oy += hyt+4;
  Int = new TextButton(this, ID_INT, ox,oy, ox+wid-1,oy+hyt-1, "&Intermediate");
  oy += hyt+4;
  Exp = new TextButton(this, ID_EXP, ox,oy, ox+wid-1,oy+hyt-1, "&Expert");
  oy += hyt+4;
  Ran = new TextButton(this, ID_RAN, ox,oy, ox+wid-1,oy+hyt-1, "&Random");
  oy += hyt+4;
  Res = new TextButton(this, ID_RES, ox,oy, ox+wid-1,oy+hyt-1, "Res&tore");

  wid = 10*SysFont->width;
  ox = (DLG_WIDTH-wid*2-10)/2;
  oy = cy2-hyt-SysFont->height;
  OK = new TextButton(this, ID_OK, ox, oy, ox+wid-1, oy+hyt-1, "&OK");
  Cancel = new TextButton(this, ID_CANCEL, ox+wid+10, oy,
                          ox+wid+10+wid-1, oy+hyt-1, "&Cancel");

  AddTabStop(WidthEdit);
  AddTabStop(HeightEdit);
  AddTabStop(MineEdit);
  AddTabStop(Str);
  AddTabStop(Beg);
  AddTabStop(Int);
  AddTabStop(Exp);
  AddTabStop(Ran);
  AddTabStop(Res);
  AddTabStop(OK);
  AddTabStop(Cancel);
}


CustomDlg::~CustomDlg()
{
  delete WidthEdit; delete HeightEdit; delete MineEdit;
  delete Diff;
  delete Str; delete Beg; delete Int; delete Exp; delete Ran; delete Res;
  delete OK; delete Cancel;
}

extern BYTE HighLightColour;

void CustomDlg::PaintWindow(int x1, int y1, int x2, int y2)
{
  TabWin::PaintWindow(x1, y1, x2, y2);

  ViewBuffer* buf = GetSubBuffer(x1, y1, x2, y2);

  const int ox = FWIDTH+8;
  int oy = FWIDTH+CAPTION_HEIGHT+SysFont->height+2;
  WriteChar(buf, ox, oy, HighLightColour, SysFontBold, 'W');
  WriteText(buf, ox+CharWidth('W', SysFontBold), oy,
                 HighLightColour, SysFont, "idth:");
  oy += (SysFont->height+4)*2;
  WriteChar(buf, ox, oy, HighLightColour, SysFontBold, 'H');
  WriteText(buf, ox+CharWidth('H', SysFontBold), oy,
                 HighLightColour, SysFont, "eight:");
  oy += (SysFont->height+4)*2;
  WriteChar(buf, ox, oy, HighLightColour, SysFontBold, 'M');
  WriteText(buf, ox+CharWidth('M', SysFontBold), oy,
                 HighLightColour, SysFont, "ines:");
  oy += (SysFont->height+4)*2;
  WriteText(buf, ox, oy, HighLightColour, SysFontItallic, "Difficulty:");
  DeleteBuffer(buf);
}


BOOL CustomDlg::Run()
{
  Paint();
  RefreshWindow();
  CatchMouse();
  CatchKeys();
  ws.RunEvents();
  ws.ResetEvents();
  ReleaseMouse();
  ReleaseKeys();
  if (isOK)
  {
    Custom.width = WidthEdit->GetNum();
    Custom.height = HeightEdit->GetNum();
    Custom.mines = MineEdit->GetNum();
  }
  return isOK;
}

void CustomDlg::cmOK()
{
  isOK = TRUE;
  ws.StopRunningEvents();
}

void CustomDlg::cmCancel()
{
  isOK = FALSE;
  ws.StopRunningEvents();
}


// Save the current dimensions before selecting one of the predefines.
void CustomDlg::SaveState()
{
  Layout temp = { WidthEdit->GetNum(), HeightEdit->GetNum(),
                  MineEdit->GetNum() };
  if (!(temp == Beginner || temp == Intermediate ||
        temp == Expert || temp == Random)) save = temp;
}


// Set the edit fields to those in state.
void CustomDlg::SetState(const Layout& state)
{
  WidthEdit->SetNum(state.width);
  HeightEdit->SetNum(state.height);
  cmChange();
  MineEdit->SetNum(state.mines);
}


// Update the mine's minimum and maximum values, and the difficulty.
void CustomDlg::cmChange()
{
  char temp[8];
  int area = WidthEdit->GetNum() * HeightEdit->GetNum();
  MineEdit->SetMin(area/10 + (area%10 != 0)); // n point something goes to n+1
  MineEdit->SetMax(area/2);
  sprintf(temp, "%.3g", float(area) / MineEdit->GetNum());
  Diff->SetText(temp);
}


extern FONT *FixedFont, *SysFont1;      // The menu uses the fixed font

// Display the menu of custom games directly underneath the "Store" button,
// a bit to the right.
void CustomDlg::cmStr()
{
  if (CustomPopup.number == 0) return;
  Layout temp = Custom;                 // In case of Cancel
  BOOL rc;
  SysFont = FixedFont;
  rc = CustomPopupMenu(NULL, absx+cx2-FWIDTH-14*SysFont1->width,
                             absy+FWIDTH*4+2*SysFont1->height+
                              SysFontBold->height+3).Run();
  CatchKeys();                          // It seems PopupMenu releases keys
  SysFont = SysFont1;
  if (rc)
  {
    SaveState();
    SetState(Custom);
  }
  Custom = temp;
}


// Create the menu with no popouts and where the ID is the same as the position
// in the menu (starting from 0).
CustomPopupRes::CustomPopupRes() : number(0)
{
  for (unsigned j = 0; j < CustomGames; j++)
  {
    menu[j].ID = j;
    menu[j].npopout = 0;
    menu[j].popout = 0;
  }
}


// Insert a new layout into the custom menu, such that the order is easy (ie.
// difficulty 10) to hard (ie. difficulty 2).
void CustomPopupRes::Insert(Layout lo)
{
  unsigned j;
  for (j = 0; j < number; j++)
  {
    if (lo.diff() > layout[j].diff()) break;
  }
  if (j < number)
  { // Shift everything up one
    for (unsigned k = number; k > j; k--)
    {
      layout[k] = layout[k-1];
      menu[k].Text = menu[k-1].Text;
    }
  }
  layout[j] = lo;
  menu[j].Text = new char[CustomLen];
  sprintf(menu[j].Text, "%2d x %2d, %3d Mines",
                        lo.width, lo.height, lo.mines);
  number++;
}


//DEFINE_RESPONSE_TABLE(CustomPopupMenu, AutoPopupMenu)
BOOL CustomPopupMenu::DoEvents(const event* ev)
{
  // For some reason this event doesn't get called using the standard approach
  if (ev->Type == W_COMMAND &&
      (ev->p1 >= 0 && ev->p1 < (int)CustomPopup.number))
  {
    cmSelection(ev->p1);
    return TRUE;
  }
  if (AutoPopupMenu::DoEvents(ev)) return TRUE;

  E_KEYCODE(0x1b, 0x01, keyESC)
  E_LBUTTONDOWN

  return FALSE;
}
//END_RESPONSE_TABLE


BOOL CustomPopupMenu::Run()
{
  Paint();
  RefreshWindow();
  CatchMouse();
  CatchKeys();
  ws.RunEvents();
  ws.ResetEvents();
  ReleaseMouse();
  ReleaseKeys();
  return !cancelled;
}


void CustomPopupMenu::cmSelection(unsigned game)
{
  Custom = CustomPopup.layout[game];
  ws.StopRunningEvents();
}


void CustomPopupMenu::keyESC(int)
{
  ws.StopRunningEvents();
  cancelled = TRUE;
}

void CustomPopupMenu::LButtonDown(int x, int y, int)
{
  if (x < absx || x > absx+w ||
      y < absy || y > absy+h)
  {
    ws.StopRunningEvents();
    cancelled = TRUE;
  }
}

