/*
  Program:      Mine Mayhem
  File:         custom.h
  Date:         July, 1996 to February, 1997

  The custom layout dialog box and menu definitions.

  Freeware, Copyright 1996-7 Jason Hood.

  You are free to use this code, or a portion thereof, as long as an
  appropriate acknowledgement is made.
*/

#ifndef _custom_h
#define _custom_h

#include <tws/tabwin.h>
#include <tws/static.h>
#include <tws/button.h>
#include <tws/menu.h>
#include "board.h"
#include "spin.h"


class CustomDlg : public TabWin
{
public:
  CustomDlg();
  ~CustomDlg();

  BOOL Run();                           // TRUE for OK, FALSE for Cancel

protected:
  void PaintWindow(int x1, int y1, int x2, int y2);

  void SaveState();
  void SetState(const Layout& layout);

  void cmStr();
  void cmBeg() { SaveState(); SetState(Beginner); }
  void cmInt() { SaveState(); SetState(Intermediate); }
  void cmExp() { SaveState(); SetState(Expert); }
  void cmRan() { SaveState(); SetState(Random); }
  void cmRes() { SetState(save); }

  void cmChange();

  void cmOK();
  void cmCancel();

  DECLARE_RESPONSE_TABLE;

  Spin *WidthEdit, *HeightEdit, *MineEdit;
  StaticText *Diff;
  TextButton *Str, *Beg, *Int, *Exp, *Ran, *Res,
             *OK, *Cancel;
  BOOL isOK;
  Layout save;
};


const unsigned CustomGames = 20,        // Maximum number of custom games
               CustomLen = 18 + 1;      // "ww x hh, ddd Mines\0"


struct CustomPopupRes
{
  CustomPopupRes();

  unsigned number;                      // The number of custom games stored
  Layout layout[CustomGames];           // The layout of each
  PopupMenuRes menu[CustomGames];       // The menu data

  void Insert(Layout lo);               // Add a new game in order easy -> hard
};

extern CustomPopupRes CustomPopup;


class CustomPopupMenu : public AutoPopupMenu
{
public:
  CustomPopupMenu(Window* parent, int x, int y) : cancelled(FALSE),
    AutoPopupMenu(parent, CustomPopup.menu, CustomPopup.number, x, y) {}

  BOOL Run();

protected:
  void cmSelection(unsigned game);

  void keyESC(int);                             // Press Escape or click
  void LButtonDown(int x, int y, int);          // outside the menu to cancel

  DECLARE_RESPONSE_TABLE;

  BOOL cancelled;
};

#endif

