// MessageWindow - creates a window for displaying centred text.
// Jason Hood.
// 12 & 13 July, 1996.
// Tidied 1 August.

#include "msgwin.h"

DEFINE_RESPONSE_TABLE(MessageWindow, Window)
  E_BUTTONUP(ID_SYSBOX, cmSysBox)
END_RESPONSE_TABLE

// Add a string to the window
void MessageWindow::Write(char* text, int col, FONT* font) {
  int len = StringWidth(text, font) + Margin*2;
  if (len > width) width = len;         // The longest line determines width
  height += font->height+2;             // Height is determined by num. of lines
  if (head == NULL) head = line = new LineStatus;
  else line = line->next = new LineStatus;
  line->text = text;
  line->col = col;
  line->font = font;
  line->next = NULL;
}

// Write the strings to the window
void MessageWindow::PaintWindow(int x1, int y1, int x2, int y2) {
  Window::PaintWindow(x1, y1, x2, y2);
  ViewBuffer *buf = GetSubBuffer(x1, y1, x2, y2);
  int oy = CAPTION_HEIGHT+FWIDTH+Margin;    // The y-offset of the current line
  for (line = head; line != NULL; line = line->next) {
    WriteText(buf, (width-StringWidth(line->text, line->font))/2, oy,
              line->col, line->font, line->text);
    oy += line->font->height+2;
  }
  DeleteBuffer(buf);
}

void MessageWindow::Run() {
  // Centre the window on the screen with the determined dimensions
  Resize((ws.GetDeskWidth()-width)/2, (ws.GetDeskHeight()-height)/2,
         (ws.GetDeskWidth()+width)/2-1, (ws.GetDeskHeight()+height)/2-1);
  CatchMouse();
  CatchKeys();
  ws.RunEvents();
  ws.ResetEvents();
  ReleaseMouse();
  ReleaseKeys();
}

// Free the memory created by the linked list
MessageWindow::~MessageWindow() {
  for (line = head; line != NULL; line = head) {
    head = line->next;
    delete line;
  }
}

