/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> MYCONFIG.H
 -> MyConfigFile class for reading and writing configuration files.

 Jason Hood, 29 November, 1996.
 4 February, 1997 - Added GetItem and GetInt.
*/

#ifndef _myconfig_h
#define _myconfig_h

#include <types.h>
#include <stdlib.h>

class MyConfigFile {
public:
  BOOL Open(const char* filename);      // Read filename into memory
  BOOL Close();                         // Write memory back to filename

  MyConfigFile() : cfgfile(NULL) {};
  MyConfigFile(const char* filename) : cfgfile(NULL) { Open(filename); }
  ~MyConfigFile() { Close(); }

  char* GetItem(const char* name, char* defalt = "");
  int GetInt(const char* name, int defalt = 0);

  BOOL WriteItem(const char* name, const char* item);
  BOOL WriteInt(const char* name, int item) {
    return WriteItem(name, itoa(item, intbuffer, 10));
  }

private:
  char *cfgfile, intbuffer[33];

  struct LineList {
    char *line,                         // The line read from the file
         *Name,                         // Start of the name, ignoring ws
         *Item;                         // Start of the item, ignoring ws
    LineList *next,                     // Next line in the file
             *item;                     // Next item in the file
    char *pos, ch;                      // Position and char. replaced with null
    LineList() : line(NULL), next(NULL), item(NULL), pos(NULL) {}
    ~LineList() { free(line); }
  } *Head, *First,                      // First line/item in the file
    *Last, *LastItem;                   // Last line/item for appending new ones
};


#endif

