/*
  Program:      Mine Mayhem
  File:         options.cc
  Date:         July, 1996 to February, 1997

  The configuration dialog box.

  Freeware, Copyright 1996-7 Jason Hood.

  You are free to use this code, or a portion thereof, as long as an
  appropriate acknowledgement is made.
*/

#include "options.h"
#include "board.h"

#define ID_CHECK_MARKS     1000
#define ID_CHECK_WRAP      1001
#define ID_CHECK_AUTOMARK  1002
#define ID_CHECK_AUTOOPEN  1003

#define ID_CHECK_CLEAR     1004
#define ID_CHECK_FLAG      1005

#define ID_CHECK_FINOPEN   1006
#define ID_CHECK_FINMARK   1007


DEFINE_RESPONSE_TABLE(OptionDlg, TabWin)
   E_BUTTONUP(ID_OK, cmOK)
   E_BUTTONUP(ID_CANCEL, cmCancel)
END_RESPONSE_TABLE

#define DLG_WIDTH  (SysFont->width*48)
#define DLG_HEIGHT (SysFont->height*19)

OptionDlg::OptionDlg() :
  TabWin(NULL, "Options",
         (ws.GetDeskWidth()-DLG_WIDTH-FWIDTH*2)/2,
         (ws.GetDeskHeight()-DLG_HEIGHT-FWIDTH-CAPTION_HEIGHT)/2,
         (ws.GetDeskWidth()+DLG_WIDTH+FWIDTH*2)/2-1,
         (ws.GetDeskHeight()+DLG_HEIGHT+FWIDTH+CAPTION_HEIGHT)/2,
         WA_VISABLE | WA_BORDER | WA_CAPTION | WA_SAVEAREA),
  isOK(FALSE)
{
  int ox, oy, wid = 20*SysFont->width+8, hyt;

  ox = FWIDTH+8; oy = FWIDTH+CAPTION_HEIGHT+8+SysFont->height+2;
  hyt = 2*SysFont->height+8;
  game = new RadioButtonContainer(this, ox, oy, ox+wid-1, oy+hyt-1,
                                  RADIO_TYPE_DIP);
  game->AddButton("C&lear", CLEAR);
  game->AddButton("C&ross", CROSS);
  game->SelectButton(Game);

  oy += hyt+SysFont->height*2+2; hyt += SysFont->height+1;
  start = new RadioButtonContainer(this, ox, oy, ox+wid-1, oy+hyt-1,
                                   RADIO_TYPE_DIP);
  start->AddButton("&No repositioning", NO_REPOS);
  start->AddButton("One &displacement", ONE_REPOS);
  start->AddButton("&Automatic", AUTO);
  start->SelectButton(Start);

  ox += 4; oy += hyt+SysFont->height*2+2+3; int yo = oy;
  finishopen = new CheckBox(this, ID_CHECK_FINOPEN, "&Opened", ox, oy, wid,
                            (Finish & ALL_OPENED) != 0);
  oy += SysFont->height+2;
  finishmark = new CheckBox(this, ID_CHECK_FINMARK, "&Marked", ox, oy, wid,
                            (Finish & ALL_MARKED) != 0);

  ox = DLG_WIDTH - FWIDTH-8 - wid + 4;
  oy = FWIDTH+CAPTION_HEIGHT+8+SysFont->height+2+3;
  marks = new CheckBox(this, ID_CHECK_MARKS, "Marks (&?)", ox,oy, wid, isMarks);
  AddAccelerator('/', marks);
  oy += SysFont->height+2;
  wrap = new CheckBox(this, ID_CHECK_WRAP, "&Wrap-around", ox, oy, wid, isWrap);

  oy += SysFont->height+3+SysFont->height+SysFont->height+2+3;
  automark = new CheckBox(this, ID_CHECK_AUTOMARK, "Markin&g",
                          ox, oy, wid, isAutoMark);
  oy += SysFont->height+2;
  autoopen = new CheckBox(this, ID_CHECK_AUTOOPEN, "O&pening",
                          ox, oy, wid, isAutoOpen);

  ox -= 4; oy = yo-3 - (SysFont->height+1);
  clear = new RadioButtonContainer(this, ox, oy, ox+wid-1, oy+hyt-1,
                                   RADIO_TYPE_DIP);
  clear->AddButton("Le&ft", CLRLEFT);
  clear->AddButton("Righ&t", CLRRIGHT);
  clear->AddButton("M&iddle", CLRMIDDLE);
  clear->SelectButton(ClearButton);

  wid = 10*SysFont->width; hyt = SysFontBold->height+4;
  ox = (DLG_WIDTH-wid*2-10)/2;
  oy = cy2-hyt-SysFont->height;
  OK = new TextButton(this, ID_OK, ox, oy, ox+wid, oy+hyt-1, "O&K");
  Cancel = new TextButton(this, ID_CANCEL, ox+wid+10, oy,
                          ox+wid+10+wid-1, oy+hyt-1, "&Cancel");

  AddTabStop(game);
  AddTabStop(start);
  AddTabStop(finishopen);
  AddTabStop(finishmark);
  AddTabStop(marks);
  AddTabStop(wrap);
  AddTabStop(automark);
  AddTabStop(autoopen);
  AddTabStop(clear);
  AddTabStop(OK);
  AddTabStop(Cancel);
}


OptionDlg::~OptionDlg()
{
  delete Cancel; delete OK;
  delete game; delete start;
  delete finishopen; delete finishmark;
  delete clear;
  delete marks; delete wrap;
  delete automark; delete autoopen;
}

extern BYTE HighLightColour;

// Write all the headings and draw the boxes around the options.
void OptionDlg::PaintWindow(int x1, int y1, int x2, int y2)
{
  TabWin::PaintWindow(x1, y1, x2, y2);

  ViewBuffer* buf = GetSubBuffer(x1, y1, x2, y2);

  int ox = FWIDTH+8, oy = FWIDTH+CAPTION_HEIGHT+8,
      wid = 20*SysFont->width+8;

  WriteText(buf, ox,oy, HighLightColour, SysFontItallic, "Game Type");
  oy += SysFont->height+2 + 2*(SysFont->height+1) + 6 + SysFont->height;
  WriteText(buf, ox,oy, HighLightColour, SysFontItallic, "Starting Condition");
  oy += SysFont->height+2 + 3*(SysFont->height+1) + 6 + SysFont->height;
  WriteText(buf, ox,oy, HighLightColour, SysFontItallic, "Finishing Condition");

  oy += SysFont->height+2; int ey = oy + 2*(SysFont->height+2) + 3;
  HDip(buf, ox, ox+wid-2, oy);
  VDip(buf, ox, oy+1, ey);
  HDip(buf, ox, ox+wid-2, ey);
  VDip(buf, ox+wid-2, oy, ey);

  ox = DLG_WIDTH - (wid+8+FWIDTH); oy = FWIDTH+CAPTION_HEIGHT+8;
  WriteText(buf, ox, oy, HighLightColour, SysFontItallic, "General");
  oy += SysFont->height+2; ey = oy + 2*(SysFont->height+2) + 3;
  HDip(buf, ox, ox+wid-2, oy);
  VDip(buf, ox, oy+1, ey);
  HDip(buf, ox, ox+wid-2, ey);
  VDip(buf, ox+wid-2, oy, ey);

  oy += 4 + 2*(SysFont->height+2) + SysFont->height;
  WriteText(buf, ox,oy, HighLightColour, SysFontItallic, "Automatic");
  oy += SysFont->height+2; ey = oy + 2*(SysFont->height+2) + 3;
  HDip(buf, ox, ox+wid-2, oy);
  VDip(buf, ox, oy+1, ey);
  HDip(buf, ox, ox+wid-2, ey);
  VDip(buf, ox+wid-2, oy, ey);

  oy += 4 + 2*(SysFont->height+2) + SysFont->height;
  WriteText(buf, ox,oy, HighLightColour, SysFontItallic, "Clear-Around Button");

  DeleteBuffer(buf);
}


void OptionDlg::Run()
{
  Paint();
  RefreshWindow();
  SetFocus(OK);
  CatchMouse();
  CatchKeys();
  ws.RunEvents();
  ws.ResetEvents();
  ReleaseMouse();
  ReleaseKeys();
  if (isOK)
  {
    if (!Board->GameinProgress())
    {
      int oldopt = Game;
      Game = game->GetSelectedButton();
      if (Game == CROSS && oldopt == CLEAR) Board->AdjustGame();
      Start = start->GetSelectedButton();
      Finish = finishopen->isChecked() | (finishmark->isChecked() << 1);
      oldopt = isWrap;
      isWrap = wrap->isChecked();
      if (oldopt != isWrap) Board->AdjustWrap();
      isAutoMark = automark->isChecked();
      isAutoOpen = autoopen->isChecked();
    }
    isMarks = marks->isChecked();
    ClearButton = clear->GetSelectedButton();
  }
}

void OptionDlg::cmOK()
{
  isOK = TRUE;
  ws.StopRunningEvents();
}

void OptionDlg::cmCancel()
{
  isOK = FALSE;
  ws.StopRunningEvents();
}

