/*
  Program:      Mine Mayhem
  File:         times.h
  Date:         July, 1996 to February, 1997

  Everything to do with defining record times.

  Freeware, Copyright 1996-7 Jason Hood.

  You are free to use this code, or a portion thereof, as long as an
  appropriate acknowledgement is made.

  I was planning to use radio buttons to select the game and the level, but
  the radio button has no events associated with it, so I've had to use
  checkboxes instead.
*/

#ifndef _times_h
#define _times_h

#include <tws/tabwin.h>
#include <tws/static.h>
#include <tws/edit.h>
//#include <tws/radio.h>
#include <tws/checkbox.h>
#include <tws/menu.h>
#include <tws/button.h>

#include "board.h"
#include "options.h"
#include "custom.h"

extern FONT *FixedFont, *SysFont1;

const unsigned NameLen = 20 + 1,
               DateLen = 11 + 1,        // "dd-Mmm-yyyy\0"
               Entries = 5;


// This class holds the five fastest and slowest times.
class Table
{
friend class TimesWindow;

public:
  Table();

  BOOL Enter(unsigned time, unsigned spaces, unsigned mines);
                                        // Check if time (in ms) is a record
protected:
  unsigned games,                       // The number of games completed
           timetotal,                   // The total time for all games
           spacetotal,                  // Total number of spaces cleared
           minetotal;                   // Total number of mines found
                                        // (spaces and mines only meaningful
                                        //  for the cross game)

  struct Entry
  {
    unsigned time;                      // In milliseconds
    char name[NameLen],
         date[DateLen];
    int start, finish;                  // Start and Finish condition
    BOOL wrap;                          // Wraparound (all three for clear)
    unsigned spaces, mines;             // Spaces cleared, mines found (cross)
    Entry();
  } fastest[Entries], slowest[Entries];

  void shift(unsigned from, Entry which[]);     // Make room for the new entry
  void GetDate(Entry& entry);
  void AskName(unsigned position, Entry which[]);
  void Stats(unsigned time, unsigned spaces, unsigned mines,
             unsigned position, Entry which[]);
};


// This class holds the tables for each level and option.
class Times
{
friend class TimesWindow;

public:
  Times();
  ~Times();

  BOOL Check(int level, unsigned time, unsigned spaces, unsigned mines);
                                        // Is time a record for level?
  void Display(int level);              // Display the times for level

  BOOL Save();
  BOOL Load();

protected:
  Table* FindTable(int level, int game = Game, BOOL automark = isAutoMark,
                                               BOOL autoopen = isAutoOpen);

  Table Beginner[6], Intermediate[6], Expert[6];

  struct CustomTimes
  {
    Layout layout;
    Table times[6];
    CustomTimes* next;
  } *head, *prevCustom;
};

extern Times times;


// This is the class that does all the displaying.
class TimesWindow : public TabWin
{
public:
  TimesWindow(const Table& table);
  ~TimesWindow();

  void Run();

protected:
  void PaintWindow(int x1, int y1, int x2, int y2);

  void Print(const Table& table);

  void cmOK() { ws.StopRunningEvents(); }

  void CheckAutoMark();
  void CheckAutoOpen();

  void CheckGameClear();
  void CheckGameCross();
  void UnCheckGameClear();
  void UnCheckGameCross();
  void CheckLevelBeginner();
  void CheckLevelIntermediate();
  void CheckLevelExpert();
  void CheckLevelCustom();
  void UnCheckLevelBeginner();
  void UnCheckLevelIntermediate();
  void UnCheckLevelExpert();
  void UnCheckLevelCustom();

  void cmTable();

  DECLARE_RESPONSE_TABLE;

  StaticText *fast[Entries], *status, *slow[Entries];
  //RadioButtonContainer *game, *level;
  CheckBox *gameclear, *gamecross,
           *levelbeginner, *levelintermediate, *levelexpert, *levelcustom;
  CheckBox *automark, *autoopen;
  TextButton *ok;

  Layout CustomSave;
  BOOL first;                           // Don't pop-up the menu if custom is
};                                      // the first level displayed


// This is the dialog box to ask for the player's name.
class EnterNameDlg : public Window
{
public:
  EnterNameDlg(const char* message);
  ~EnterNameDlg();

  char* Run();

protected:
  void PaintWindow(int x1, int y1, int x2, int y2);

  void KeyEnter(int) { ws.StopRunningEvents(); }
  void cmOK() { ws.StopRunningEvents(); }

  DECLARE_RESPONSE_TABLE;

  StaticText* msg;
  EditText*   name;
  TextButton* ok;

  static char lastname[NameLen];
};

#endif

