REM **********************************************
REM   More Qbasic Software at the Software Page.
REM   http://www.euronet.nl/users/rkohm/software/
REM          Any questions? E-mail to:
REM              rkohm@euronet.nl
REM **********************************************

'				Mu Torere
'					by Robin Ohm
'
'I got this game from a book, but it originates from the Maori. To
'understand the rules of the game you'll have to start the program. You'll
'see nine circles. The middle one is called putahi, the other eight are
'called kewai. On the eight kewais you see four red and four blue "stones".
'Player 1 plays with the blue stones, player two with the red ones.
'
'Rules of the game:
'
'1. Stones can move...
'a. ...from a kewai to the putahi. But only if at least one of the adjacent
'   kewais is occupied by your opponent.
'b. ...from the putahi to an empty kewai.
'c. ...from one kewai to an empty, adjacent kewai.
'
'2. There is only one stone allowed on a field.
'
'3. You can't jump over another stone.
'
'4. The object of the game is to "lock your opponent in", so he isn't able
'   to move one of his stones.
'
'To simplify the game-controls you only have to say which stone to move
'and not where to move to, because there is only one empty spot throughout
'the entire game.

DECLARE SUB changeturn ()
DECLARE SUB check ()
DECLARE SUB redraw ()
DECLARE SUB printt (text$, linenr!)
DECLARE SUB getname (player!)
DECLARE SUB background ()

DIM SHARED pname(2) AS STRING, place(9)
COMMON SHARED turn, lockedin

place(1) = 1: place(2) = 1: place(3) = 1: place(4) = 1
place(5) = 2: place(6) = 2: place(7) = 2: place(8) = 2

ON KEY(10) GOSUB endofgame
KEY(10) ON

SCREEN 12
RANDOMIZE TIMER
background

COLOR 15: printt "", 0
printt "Player 1, what is your name?", 1
getname (1)
printt "Player 2, what is your name?", 2
getname (2)
DO: number = FIX(RND * 100 + 1): LOOP UNTIL number > 0 AND number <= 100
SELECT CASE number
 CASE IS <= 50: turn = 1: printt pname(1) + " begins the game. Press a key.", 3
 CASE IS > 50: turn = 2: printt pname(2) + " begins the game. Press a key.", 3
END SELECT
LOCATE 6, 66: PRINT pname(1) + SPACE$(10 - LEN(pname(1)))
LOCATE 8, 66: PRINT pname(2) + SPACE$(10 - LEN(pname(2)))

COLOR 15
DO: LOOP UNTIL INKEY$ <> ""

tryagain: printt "", 0
printt pname(turn) + ", choose a stone to move.", 1
DO: move$ = INKEY$: LOOP UNTIL move$ <> "" AND VAL(move$) > 0 AND VAL(move$) < 10
IF place(VAL(move$)) = 0 THEN
 PLAY "l30<ba>": printt "", 0
 printt "There is no stone at that position. Press a key.", 1
 DO: LOOP UNTIL INKEY$ <> ""
 GOTO tryagain
END IF
IF place(VAL(move$)) <> turn THEN
 PLAY "l30<ba>": printt "", 0
 printt "That is not one of your stones. Press a key..", 1
 DO: LOOP UNTIL INKEY$ <> ""
 GOTO tryagain
END IF
IF move$ = "1" AND place(2) = turn AND place(8) = turn AND place(9) = 0 THEN GOSUB illegal
IF move$ = "2" AND place(1) = turn AND place(3) = turn AND place(9) = 0 THEN GOSUB illegal
IF move$ = "3" AND place(2) = turn AND place(4) = turn AND place(9) = 0 THEN GOSUB illegal
IF move$ = "4" AND place(3) = turn AND place(5) = turn AND place(9) = 0 THEN GOSUB illegal
IF move$ = "5" AND place(4) = turn AND place(6) = turn AND place(9) = 0 THEN GOSUB illegal
IF move$ = "6" AND place(5) = turn AND place(7) = turn AND place(9) = 0 THEN GOSUB illegal
IF move$ = "7" AND place(6) = turn AND place(8) = turn AND place(9) = 0 THEN GOSUB illegal
IF move$ = "8" AND place(1) = turn AND place(7) = turn AND place(9) = 0 THEN GOSUB illegal

IF move$ = "1" AND place(8) <> 0 AND place(9) <> 0 AND place(2) <> 0 THEN GOSUB illegal2
IF move$ = "2" AND place(1) <> 0 AND place(9) <> 0 AND place(3) <> 0 THEN GOSUB illegal2
IF move$ = "3" AND place(2) <> 0 AND place(9) <> 0 AND place(4) <> 0 THEN GOSUB illegal2
IF move$ = "4" AND place(3) <> 0 AND place(9) <> 0 AND place(5) <> 0 THEN GOSUB illegal2
IF move$ = "5" AND place(4) <> 0 AND place(9) <> 0 AND place(6) <> 0 THEN GOSUB illegal2
IF move$ = "6" AND place(5) <> 0 AND place(9) <> 0 AND place(7) <> 0 THEN GOSUB illegal2
IF move$ = "7" AND place(6) <> 0 AND place(9) <> 0 AND place(8) <> 0 THEN GOSUB illegal2
IF move$ = "8" AND place(7) <> 0 AND place(9) <> 0 AND place(1) <> 0 THEN GOSUB illegal2

FOR t = 1 TO 9
 IF place(t) = 0 THEN
  place(t) = turn
  place(VAL(move$)) = 0
  redraw
  changeturn
  check
  GOTO tryagain
  EXIT FOR
 END IF
NEXT


END

endofgame:
END

illegal:
PLAY "l30<ba>": printt "", 0
printt "You are only allowed to move a stone to the middle", 1
printt "if at least one of the adjacent fields is occupied", 2
printt "by your opponent. Press a key.", 3
DO: LOOP UNTIL INKEY$ <> ""
GOTO tryagain

illegal2:
PLAY "l30<ba>": printt "", 0
printt "There is no adjacent field to move the stone to.", 1
printt "Press a key.", 2
DO: LOOP UNTIL INKEY$ <> ""
GOTO tryagain

SUB background
DRAW "bu90"
CIRCLE STEP(0, 0), 15, 15: PAINT STEP(0, 0), 15, 15
DRAW "u100": CIRCLE STEP(0, 0), 15, 15: DRAW "bu": PAINT STEP(0, 0), 15, 15
DRAW "c15bd101ta45u100": CIRCLE STEP(0, 0), 15, 15: DRAW "bu": PAINT STEP(0, 0), 15, 15
DRAW "c15bd101ta90u100": CIRCLE STEP(0, 0), 15, 15: DRAW "bu": PAINT STEP(0, 0), 15, 15
DRAW "c15bd101ta135u100": CIRCLE STEP(0, 0), 15, 15: DRAW "bu": PAINT STEP(0, 0), 15, 15
DRAW "c15bd101ta180u100": CIRCLE STEP(0, 0), 15, 15: DRAW "bu": PAINT STEP(0, 0), 15, 15
DRAW "c15bd101ta225u100": CIRCLE STEP(0, 0), 15, 15: DRAW "bu": PAINT STEP(0, 0), 15, 15
DRAW "c15bd101ta270u100": CIRCLE STEP(0, 0), 15, 15: DRAW "bu": PAINT STEP(0, 0), 15, 15
DRAW "c15bd101ta315u100": CIRCLE STEP(0, 0), 15, 15: DRAW "buta0": PAINT STEP(0, 0), 15, 15
redraw

DRAW "c14bm170,25d250r300u250l300"
DRAW "c14bd259bl54d53r407u53l407"
DRAW "c8bm220,132nl3nr3u13g3"
DRAW "bm265,65nr4l3lefu2e6u2h2l3g3"
DRAW "bm340,43e2r3f2d3g2f2d3g2l3h2"
DRAW "bm410,100u6d2nr3l6ta-30u9ta0"
DRAW "bm425,170l8d7e2r4f2d4g2l4h2"
DRAW "bm375,230g8d4f3r3e3u3h3l3g3"
DRAW "bm290,245 r10ta10g10ta0"
DRAW "bm238,195 l4g2d2f2r4f2d3g2l4h2u3e2r4e2u2h2"
DRAW "bm307,120 d3f3r3ng6e3u3h3l3g3"

DRAW "c14bm170,25d250r300u250l300"

LOCATE 6, 66: PRINT "Player 1"
CIRCLE (505, 87), 5, 1: PAINT (505, 87), 1, 1
LOCATE 8, 66: PRINT "Player 2"
CIRCLE (505, 119), 5, 4: PAINT (505, 119), 4, 4
DRAW "bm495,103 c14r110u32l110d65r110u65"
LOCATE 12, 66: COLOR 14: PRINT "F10 "; : COLOR 15: PRINT "Exit"
DRAW "bm495,170 c14r110d26l110u26"
COLOR 7: LOCATE 25, 35: PRINT "by Robin Ohm"
DRAW "bm265,380 d22r109u22l109"
DRAW "bm1,1p8,14"
END SUB

SUB changeturn
IF turn = 1 THEN
 turn = 2
 EXIT SUB
END IF
IF turn = 2 THEN
 turn = 1
 EXIT SUB
END IF
END SUB

SUB check
IF place(1) = turn AND place(8) <> 0 AND place(2) <> 0 AND place(9) <> 0 THEN lockedin = lockedin + 1
IF place(2) = turn AND place(1) <> 0 AND place(3) <> 0 AND place(9) <> 0 THEN lockedin = lockedin + 1
IF place(3) = turn AND place(2) <> 0 AND place(4) <> 0 AND place(9) <> 0 THEN lockedin = lockedin + 1
IF place(4) = turn AND place(3) <> 0 AND place(5) <> 0 AND place(9) <> 0 THEN lockedin = lockedin + 1
IF place(5) = turn AND place(4) <> 0 AND place(6) <> 0 AND place(9) <> 0 THEN lockedin = lockedin + 1
IF place(6) = turn AND place(5) <> 0 AND place(7) <> 0 AND place(9) <> 0 THEN lockedin = lockedin + 1
IF place(7) = turn AND place(6) <> 0 AND place(8) <> 0 AND place(9) <> 0 THEN lockedin = lockedin + 1
IF place(8) = turn AND place(7) <> 0 AND place(1) <> 0 AND place(9) <> 0 THEN lockedin = lockedin + 1

IF lockedin = 4 THEN
 changeturn
 printt "", 0
 printt pname(turn) + " wins the game! Congratulations!", 1
 printt "Press a key.", 2
 DO: LOOP UNTIL INKEY$ <> ""
 CLS
 END
END IF
lockedin = 0
END SUB

SUB getname (player)
SELECT CASE player
 CASE 1
  COLOR 15: LOCATE 19, 45: PRINT "__________"
  g = 45
  COLOR 15
  DO
   hit$ = INKEY$
   IF hit$ = "" THEN GOTO dothis
   SELECT CASE ASC(hit$)
    CASE 8    'backspace
     IF g > 45 THEN g = g - 1: LOCATE 19, g: PRINT "_"
    CASE 13
     EXIT DO
    CASE ELSE  'not backspace
     IF g < 55 THEN
      LOCATE 19, g: PRINT hit$: g = g + 1
     END IF
   END SELECT
dothis:
  LOOP

  nothing$ = "no"
  FOR h = 54 TO 45 STEP -1
   part = SCREEN(19, h)
   SELECT CASE part
    CASE ASC("_")
     IF nothing$ = "yes" THEN pname(1) = pname(1) + " "
    CASE ELSE
     nothing$ = "yes"
     pname(1) = CHR$(part) + pname(1)
   END SELECT
  NEXT

 CASE 2
  COLOR 15: LOCATE 20, 45: PRINT "__________"
  g = 45
  COLOR 15
  DO
   hit$ = INKEY$
   IF hit$ = "" THEN GOTO dothis2
   SELECT CASE ASC(hit$)
    CASE 8    'backspace
     IF g > 45 THEN g = g - 1: LOCATE 20, g: PRINT "_"
    CASE 13
     EXIT DO
    CASE ELSE  'not backspace
     IF g < 55 THEN
      LOCATE 20, g: PRINT hit$: g = g + 1
     END IF
   END SELECT
dothis2:
  LOOP

  nothing$ = "no"
  FOR h = 54 TO 45 STEP -1
   part = SCREEN(20, h)
   SELECT CASE part
    CASE ASC("_")
     IF nothing$ = "yes" THEN pname(2) = pname(2) + " "
    CASE ELSE
     nothing$ = "yes"
     pname(2) = CHR$(part) + pname(2)
   END SELECT
  NEXT
END SELECT
END SUB

SUB printt (text$, linenr)
SELECT CASE linenr
 CASE 1: LOCATE 19, 16: PRINT text$
 CASE 2: LOCATE 20, 16: PRINT text$
 CASE 3: LOCATE 21, 16: PRINT text$
 CASE 0: LOCATE 19, 16: PRINT SPACE$(50)
 LOCATE 20, 16: PRINT SPACE$(50): LOCATE 21, 16: PRINT SPACE$(50)
END SELECT
END SUB

SUB redraw
SELECT CASE place(1)
 CASE 0: PAINT (219, 149), 15, 15
 CASE 1: CIRCLE (219, 149), 10, 1: PAINT (219, 149), 1, 1
 CASE 2: CIRCLE (219, 149), 10, 4: PAINT (219, 149), 4, 4
END SELECT
SELECT CASE place(2)
 CASE 0: PAINT (249, 79), 15, 15
 CASE 1: CIRCLE (249, 79), 10, 1: PAINT (249, 79), 1, 1
 CASE 2: CIRCLE (249, 79), 10, 4: PAINT (249, 79), 4, 4
END SELECT
SELECT CASE place(3)
 CASE 0: PAINT (320, 50), 15, 15
 CASE 1: CIRCLE (320, 50), 10, 1: PAINT (320, 50), 1, 1
 CASE 2: CIRCLE (320, 50), 10, 4: PAINT (320, 50), 4, 4
END SELECT
SELECT CASE place(4)
 CASE 0: PAINT (390, 80), 15, 15
 CASE 1: CIRCLE (390, 80), 10, 1: PAINT (390, 80), 1, 1
 CASE 2: CIRCLE (390, 80), 10, 4: PAINT (390, 80), 4, 4
END SELECT
SELECT CASE place(5)
 CASE 0: PAINT (419, 151), 15, 15
 CASE 1: CIRCLE (419, 151), 10, 1: PAINT (419, 151), 1, 1
 CASE 2: CIRCLE (419, 151), 10, 4: PAINT (419, 151), 4, 4
END SELECT
SELECT CASE place(6)
 CASE 0: PAINT (389, 221), 15, 15
 CASE 1: CIRCLE (389, 221), 10, 1: PAINT (389, 221), 1, 1
 CASE 2: CIRCLE (389, 221), 10, 4: PAINT (389, 221), 4, 4
END SELECT
SELECT CASE place(7)
 CASE 0: PAINT (318, 250), 15, 15
 CASE 1: CIRCLE (318, 250), 10, 1: PAINT (318, 250), 1, 1
 CASE 2: CIRCLE (318, 250), 10, 4: PAINT (318, 250), 4, 4
END SELECT
SELECT CASE place(8)
 CASE 0: PAINT (248, 220), 15, 15
 CASE 1: CIRCLE (248, 220), 10, 1: PAINT (248, 220), 1, 1
 CASE 2: CIRCLE (248, 220), 10, 4: PAINT (248, 220), 4, 4
END SELECT
SELECT CASE place(9)
 CASE 0: PAINT (320, 150), 15, 15
 CASE 1: CIRCLE (320, 150), 10, 1: PAINT (320, 150), 1, 1
 CASE 2: CIRCLE (320, 150), 10, 4: PAINT (320, 150), 4, 4
END SELECT
END SUB

