DECLARE SUB waitkey ()
DECLARE SUB setscreenmode ()
DECLARE SUB showkeys ()
DECLARE SUB centreprint (pstring$, x%, y%, c%)
DECLARE SUB saveold ()
DECLARE SUB resetfmcard ()
DECLARE SUB cleanup ()
DECLARE SUB doskidvideoeffects ()
DECLARE SUB DOSKIDSOUNDS ()
DECLARE SUB setskidsound ()
DECLARE SUB updatestatsprites ()
DECLARE SUB addstatussprite (x%, y%, z%, frame%, imxnumber%, colourtable%, flags%, silhouette%)
DECLARE SUB initstatussprites ()
DECLARE SUB exitgame ()
DECLARE SUB setmotorsound ()
DECLARE SUB DOCARENGINE ()
DECLARE SUB FMPinit ()
DECLARE SUB PLAYSONG (pfilename$)
DECLARE SUB CONTINUEPLAYSONG ()
DECLARE SUB STOPPLAYSONG ()
DECLARE SUB FMPadlport (adressreg%, bdata%)
DECLARE SUB FMPplaystart (pfilename$)
DECLARE SUB controlplayer ()
DECLARE SUB updatespritedata ()
DECLARE SUB addsprite (x%, y%, z%, frame%, imxnumber%, colourtable%, flags%, silhouette%)
DECLARE SUB initvariables ()
DECLARE SUB playgame ()
DECLARE SUB loadimx ()
DECLARE SUB initsprites ()
DECLARE SUB addflatsprite (p1%, p2%, p3%, p4%, p5%, p6%, p7%, p8%)
DECLARE SUB approach0 (p%)
DECLARE SUB docamera ()
DECLARE SUB dec (pvalue%)
DECLARE SUB inc (pvalue%)
DECLARE SUB limitcamera ()
DECLARE SUB minlimit (pvalue%, plimit%)
DECLARE SUB maxlimit (pvalue%, plimit%)
DECLARE SUB onkb ()
DECLARE SUB offkb ()
DECLARE SUB drawscreen ()
DECLARE SUB loadassembly ()
DECLARE SUB inittileindirect ()
DECLARE SUB initcolourtables ()
DECLARE SUB initmaskenable ()
DECLARE SUB initviewports ()
DECLARE SUB addviewport (x1%, y1%, x2%, y2%)
DECLARE SUB errorexit (errormessage$)
DECLARE SUB loadlevel ()
DECLARE SUB loadtiles ()
DECLARE SUB loadpalette ()

'Define files
DIM SHARED imxfile$(8)
DIM SHARED palfile1$, levfile1$, chrfile1$, asmfile1$, asmfile2$, songfile1$
palfile1$ = "nfirefmx.pal"
levfile1$ = "track1.lev"
chrfile1$ = "track1.til"
asmfile1$ = "fmxengin.rtn"
asmfile2$ = "keyb2.rtn"
songfile1$ = "rocktune.fmp"
imxfile$(0) = "acura.imx"
imxfile$(1) = "track1.imx"
imxfile$(2) = "status.imx"
imxfile$(3) = "skids.imx"

'Define engine constants
CONST MAXVIEWPORTS = 2
CONST MAXLEVELSPRITES = 10
CONST MAXFLATSPRITES = 100
CONST MAXSTATUSSPRITES = 50

'Define option constants
CONST MUSICDAMPER = 5
CONST SOUNDON = 1
CONST MILESPERHOUR = 0

'Define game constants
CONST SPEDOMETERFACTOR = 8.6

'Define max / min constants
CONST SKIDTOLERANCE = .5

'Define types
TYPE viewporttype
 x1 AS INTEGER
 y1 AS INTEGER
 x2 AS INTEGER
 y2 AS INTEGER
 statussegment AS INTEGER
 statusoffset AS INTEGER
 totalstatussprites AS INTEGER
 camerax AS INTEGER
 cameray AS INTEGER
END TYPE

TYPE spritetype
 x AS INTEGER
 y AS INTEGER
 z AS INTEGER
 frame AS INTEGER
 imxnumber AS INTEGER
 colourtable AS INTEGER
 flags AS INTEGER
 silhouette AS INTEGER
END TYPE

'Fm pipes player main section
CONST TOTALVOICES = 7
TYPE keybtype: flow AS INTEGER: fhi AS INTEGER: foct AS INTEGER: location AS INTEGER: END TYPE: TYPE voicetype: scancode AS INTEGER: inuse AS INTEGER: delay AS INTEGER: regB0 AS INTEGER: END TYPE
DIM SHARED adlportasm%(512), keyb(128) AS keybtype, totalkeys%, voice(9) AS voicetype, setoldinstrumentsflag%, currentsong$
DIM SHARED kbmatrix2%(257), currentkbmatrix2%(257), oldkbmatrix2%(257), transpose%, playbuffer&(2048), playbufferindex&, playdelaycounter&, keycount&, keyindex&, playmode%
DIM SHARED fmpwavebeats%, wavefx%
wavefx% = 1: fmpwavebeats% = 8
keyDATA:
DATA 0,0,0,0,0,0,0,0,0,0,0,0,21,1,5,27,55,1,5,25,0,0,0,0,114,1,5,22,159,1,5,20,210,1,5,18,0,0,0,0,21,1,6,15,55,1,6,13,0,0,0,0,114,1,6,10,210,1,6,6,238,1,4,29,6,1,5,28,38,1,5,26,74,1,5,24,93,1,5,23,136,1,5,21,184,1,5,19,238,1,5,17,6,1,6,16
DATA 38,1,6,14,74,1,6,12,93,1,6,11,136,1,6,9,184,1,6,7,0,0,0,0,0,0,0,0,21,1,4,39,55,1,4,37,0,0,0,0,114,1,4,34,159,1,4,32,210,1,4,30,0,0,0,0,21,1,5,27,55,1,5,25,93,1,5,23,210,1,4,30,238,1,3,41,159,1,6,8,6,1,4,40,38,1,4,38,74,1,4,36,93,1,4,35
DATA 136,1,4,33,184,1,4,31,238,1,4,29,6,1,5,28,38,1,5,26,74,1,5,24,93,1,5,23,0,0,0,0,0,0,0,0,0,0,0,0,210,1,3,42,-1,-1,-1,-1
adlportDATA:
DATA 85,137,229,80,83,81,82,30,86,6,87,190,6,0,177,4,54,139,26,139,7,54,137,2,70,70,254,201,117,242,22,31,139,86,10,138,70,6,238,185,6,0,236,73,117,252,139,86,12,138,70,8,238,139,86,10,185,35,0,236
DATA 73,117,252,95,7,94,31,90,89,91,88,137,236,93,202,8,-1
FMPinit

'Define arrays
'engine variables
DIM SHARED engine%(8192)
DIM SHARED pal%(512)
DIM SHARED level%(8000), levelxsize%, levelysize%
DIM SHARED tiles%(15360)
DIM SHARED viewport(MAXVIEWPORTS) AS viewporttype
DIM SHARED totalviewports%
DIM SHARED sprite(MAXLEVELSPRITES) AS spritetype
DIM SHARED totalsprites%
DIM SHARED spritestream(MAXLEVELSPRITES) AS spritetype
DIM SHARED flatsprite(MAXFLATSPRITES) AS spritetype
DIM SHARED totalflatsprites%, flatindex%
DIM SHARED status0(MAXSTATUSSPRITES) AS spritetype
DIM SHARED status1(MAXSTATUSSPRITES) AS spritetype
DIM SHARED totalstatussprites0%
DIM SHARED totalstatussprites1%
DIM SHARED tileindirect%(256)
DIM SHARED maskenable%(256)
DIM SHARED colourtable0%(256)
DIM SHARED colourtable1%(256)
DIM SHARED colourtable2%(256)
DIM SHARED doublebuffer%(2560)
DIM SHARED imx0%(10259), imx1%(3000), imx2%(2000), imx3%(192)
DIM SHARED imx4%(0), imx5%(0), imx6%(0), imx7%(0)

'game variables
 'keyboard interrupt
DIM SHARED keyb2%(128), kbmatrix%(128), keyboardonflag%
 'camera control
DIM SHARED camerax%, cameray%, cameradx%, camerady%
 
 'player variables
DIM SHARED carx, cary, carz, carangle, carvelocity, throttle%, carskidsound%
DIM SHARED cardx, cardy
DIM SHARED currenttiregrip, turndelta, oldcarvelocity

 'skid variables
DIM SHARED oldskidx1%, oldskidy1%, oldskidx2%, oldskidy2%, oldcarskidsound%

'Intro screen
showkeys

'Initialize
setscreenmode
loadpalette
loadlevel
loadtiles
loadassembly
loadimx
inittileindirect
initviewports
initcolourtables
initmaskenable
initvariables
initsprites
setmotorsound
setskidsound

'Main
playgame

'Exit
exitgame

SUB addflatsprite (p1%, p2%, p3%, p4%, p5%, p6%, p7%, p8%)
i% = totalflatsprites%
f% = 0
IF i% >= MAXFLATSPRITES THEN
 'errorexit "Out of flat object space"
 i% = flatindex%
 flatindex% = flatindex% + 1
 IF flatindex% >= totalflatsprites% THEN flatindex% = 0
 f% = 1
END IF
flatsprite(i%).x = p1%
flatsprite(i%).y = p2%
flatsprite(i%).z = p3%
flatsprite(i%).frame = p4%
flatsprite(i%).imxnumber = p5%
flatsprite(i%).colourtable = p6%
flatsprite(i%).flags = p7%
flatsprite(i%).silhouette = p8%
IF f% = 0 THEN
 totalflatsprites% = i% + 1
END IF
END SUB

SUB addsprite (x%, y%, z%, frame%, imxnumber%, colourtable%, flags%, silhouette%)
i% = totalsprites%
IF i% >= MAXLEVELSPRITES THEN errorexit "out of object space"
sprite(i%).x = x%
sprite(i%).y = y%
sprite(i%).z = z%
sprite(i%).frame = frame%
sprite(i%).imxnumber = imxnumber%
sprite(i%).colourtable = colourtable%
sprite(i%).flags = flags%
sprite(i%).silhouette = silhouette%
totalsprites% = i% + 1
END SUB

SUB addstatussprite (x%, y%, z%, frame%, imxnumber%, colourtable%, flags%, silhouette%)
i% = totalstatussprites0%
IF i% >= MAXSTATUSSPRITES THEN errorexit "out of status sprites"
status0(i%).x = x%
status0(i%).y = y%
status0(i%).z = z%
status0(i%).frame = frame%
status0(i%).imxnumber = imxnumber%
status0(i%).colourtable = colourtable%
status0(i%).flags = flags%
status0(i%).silhouette = silhouette%
totalstatussprites0% = i% + 1
END SUB

SUB addviewport (x1%, y1%, x2%, y2%)
i% = totalviewports%
IF i% >= MAXVIEWPORTS THEN errorexit "could not add viewport"
viewport(i%).x1 = x1%
viewport(i%).y1 = y1%
viewport(i%).x2 = x2%
viewport(i%).y2 = y2%
viewport(i%).camerax = 0
viewport(i%).cameray = 0

SELECT CASE i%
 CASE 0
  s& = VARSEG(status0(0).x)
  o& = VARPTR(status0(0).x)
 CASE 1
  s& = VARSEG(status1(0).x)
  o& = VARPTR(status1(0).x)
END SELECT
viewport(i%).statussegment = s&
viewport(i%).statusoffset = o&
totalviewports% = i% + 1
END SUB

SUB approach0 (p%)
IF p% < 0 THEN p% = p% + 1
IF p% > 0 THEN p% = p% - 1
END SUB

SUB centreprint (pstring$, x%, y%, c%)
COLOR c%
LOCATE y%, x% - (LEN(pstring$) \ 2)
PRINT pstring$;
END SUB

SUB channeldoc
'Fm channels      usage
'0-3              music
'4-6              unused
'7                car engine
'8                car skids / wheelspin
END SUB

SUB cleanup
offkb
resetfmcard
SCREEN 0
WIDTH 80, 25
CLS
END SUB

SUB CONTINUEPLAYSONG
IF playmode% = 0 THEN EXIT SUB
DO WHILE kbmatrix2%(128) > 0
 FOR n% = 0 TO TOTALVOICES - 1
  voice(n%).delay = voice(n%).delay + 1
  IF voice(n%).delay > 32000 THEN voice(n%).delay = 32000
 NEXT
 saveflag% = 0
 keycode% = kbmatrix2%(128 + kbmatrix2%(128))
 originalkeycode% = keycode%
 kbmatrix2%(128) = kbmatrix2%(128) - 1
 IF keycode% > 127 THEN
 keycode% = keycode% - 128
 IF keycode% < totalkeys% THEN
 saveflag% = 1
 voicenumber% = -1
 FOR n% = 0 TO TOTALVOICES - 1
 IF voice(n%).scancode = keycode% THEN voicenumber% = n%
 NEXT
 IF voicenumber% = -1 THEN GOTO FMPskip2
 byte% = voice(voicenumber%).regB0
 byte% = byte% AND (255 - 32)
 FMPadlport &HB0 + voicenumber%, byte%
 flag% = 1
 FOR n% = 0 TO TOTALVOICES - 1
 IF n% <> voicenumber% THEN
 IF voice(n%).inuse = 1 AND (keyb(voice(n%).scancode).location = keyb(voice(voicenumber%).scancode).location) THEN flag% = 0
 END IF
 NEXT
 voice(voicenumber%).delay = 0
 voice(voicenumber%).inuse = 0
FMPskip2:
 END IF
 GOTO keyrespondSKIP0
 ELSE
 IF keycode% < totalkeys% THEN
 WAVEBEATS% = 0
 GOSUB playvoice
 IF wavefx% = 1 THEN
  WAVEBEATS% = fmpwavebeats%
  GOSUB playvoice
 END IF
 GOTO keyrespondSKIP0
 END IF
 END IF
 SELECT CASE keycode%
 CASE 74
 saveflag% = 1
 transpose% = transpose% - 1
 IF transpose% < -4 THEN transpose% = -4
 CASE 78
 saveflag% = 1
 transpose% = transpose% + 1
 IF transpose% > 1 THEN transpose% = 1
 END SELECT
keyrespondSKIP0:
keyrespondSKIP1:
LOOP
FOR n% = 0 TO TOTALVOICES - 1
IF voice(n%).inuse = 1 THEN
IF kbmatrix2%(voice(n%).scancode) = 0 THEN
byte% = voice(n%).regB0
byte% = byte% AND (255 - 32)
FMPadlport &HB0 + n%, byte%
flag% = 1
FOR n2% = 0 TO TOTALVOICES - 1
IF n2% <> n% THEN
IF voice(n2%).inuse = 1 AND (keyb(voice(n2%).scancode).location = keyb(voice(n%).scancode).location) THEN flag% = 0
END IF
NEXT
voice(n%).delay = 0
voice(n%).inuse = 0
END IF
END IF
NEXT
GOSUB fmkeysDOPLAY
EXIT SUB

fmkeysDOPLAY:
playdelaycounter& = playdelaycounter& + 1
BACK0:
DEF SEG = VARSEG(playbuffer&(0))
IF playdelaycounter& >= PEEK(playbufferindex&) THEN
i% = PEEK(playbufferindex& + 1)
n% = kbmatrix2%(128)
kbmatrix2%(n% + 129) = i%
kbmatrix2%(128) = n% + 1
IF i% < 128 THEN
kbmatrix2%(i%) = 1
ELSE
kbmatrix2%(i% - 128) = 0
END IF
DEF SEG
keyindex& = keyindex& + 1
IF keyindex& >= playbuffer&(3) THEN PLAYSONG currentsong$
playbufferindex& = playbufferindex& + 2
playdelaycounter& = 0
IF playmode% = 1 THEN GOTO BACK0
END IF
DEF SEG
RETURN

playvoice:
saveflag% = 1
unused% = -1
FOR n% = 0 TO TOTALVOICES - 1
IF voice(n%).inuse = 0 THEN unused% = n%
NEXT
largest% = 0
IF unused% = -1 THEN
voicenumber% = -1
FOR n% = 0 TO TOTALVOICES - 1
IF voice(n%).delay > largest% THEN
largest% = voice(n%).delay
voicenumber% = n%
END IF
NEXT
ELSE
voicenumber% = -1
FOR n% = 0 TO TOTALVOICES - 1
IF voice(n%).inuse = 0 THEN
IF voice(n%).delay > largest% THEN
largest% = voice(n%).delay
voicenumber% = n%
END IF
END IF
NEXT
END IF
voice(voicenumber%).scancode = keycode%
voice(voicenumber%).delay = 0
voice(voicenumber%).inuse = 1
scan% = voice(voicenumber%).scancode
lobyte% = keyb(scan%).flow
hibyte% = keyb(scan%).fhi
fr = lobyte% + (hibyte% * 256)
FOR n% = 0 TO 4
fr = fr * 1.05946
NEXT
ffr% = INT(fr) + WAVEBEATS%
lobyte% = ffr% AND 255
hibyte% = INT(ffr% / 256)
hibyte% = hibyte% OR ((keyb(scan%).foct + transpose%) * 4)
hibyte% = hibyte% OR 32
FMPadlport &HA0 + voicenumber%, lobyte%
FMPadlport &HB0 + voicenumber%, hibyte%
voice(voicenumber%).regB0 = hibyte%
FOR n% = 0 TO TOTALVOICES - 1
voice(n%).delay = voice(n%).delay + 1
NEXT
RETURN

END SUB

SUB controlplayer
friction = .01
accel = 0
IF kbmatrix%(72) THEN GOSUB caraccel
IF kbmatrix%(77) THEN turndelta = turndelta + 1.3
'If there's grass under the car, increase friction
grassflag% = 0
DEF SEG = VARSEG(level%(0))
i& = (INT(cary - 16) \ 16) * levelxsize% + (INT(carx) \ 16) + VARPTR(level%(0))
IF PEEK(i&) = 10 THEN friction = friction * 16: grassflag% = 1
DEF SEG
IF kbmatrix%(80) THEN
 IF carvelocity > 0 THEN
  IF grassflag% = 0 THEN
   friction = friction * 8
   currenttiregrip = .8
  ELSE
   friction = friction * 2
   currenttiregrip = .1
  END IF
  carvelocity = carvelocity - .5
 ELSE
  GOSUB carreverse
 END IF
END IF
IF kbmatrix%(75) THEN turndelta = turndelta - 1.3
'Hand brake
IF kbmatrix%(29) THEN
 currenttiregrip = .1
 friction = friction * 8
END IF
carangle = carangle + (turndelta / (1 + ABS(carvelocity) / 100))
turndelta = turndelta / 4
IF carangle > 31 THEN carangle = carangle - 32
IF carangle < 0 THEN carangle = carangle + 32
currenttiregrip = currenttiregrip / (1 + ABS(turndelta / 20))
GOSUB docartirephysics
ndx = (carvelocity * SIN((carangle - .5) * .196))
ndy = (carvelocity * COS((carangle - .5) * .196))
cardx = (ndx * currenttiregrip) + (1 - currenttiregrip) * cardx
cardy = (ndy * currenttiregrip) + (1 - currenttiregrip) * cardy
carx = carx + cardx
cary = cary - cardy

'Throttle control
IF kbmatrix%(51) THEN throttle% = throttle% - 4
IF kbmatrix%(52) THEN throttle% = throttle% + 4
IF throttle% < 0 THEN throttle% = 0
IF throttle% > 143 THEN throttle% = 143

'Do skid effects
IF carskidsound% = 1 THEN doskidvideoeffects

EXIT SUB

'Gas pedal event
caraccel:
accel = .1 * (throttle% / 5)
RETURN

'Gas pedal event, reverse style
carreverse:
accel = -.05 * (throttle% / 5)
RETURN


docartirephysics:
velocitydelta = accel * currenttiregrip - carvelocity * friction
carskidsound% = 0
IF ABS(velocitydelta) > SKIDTOLERANCE THEN
 carskidsound% = 1
 currenttiregrip = currenttiregrip / 1.1
END IF
IF currenttiregrip < 1 THEN
 currenttiregrip = currenttiregrip + ((1 - currenttiregrip) / 30)
END IF
velocitydelta = accel * currenttiregrip - carvelocity * friction
IF ABS(velocitydelta) <= SKIDTOLERANCE THEN carskidsound% = 0
IF carskidsound% = 1 THEN velocitydelta = velocitydelta / 2
carvelocity = carvelocity + velocitydelta
RETURN

END SUB

SUB docamera
camerax% = INT(carx) - 160
cameray% = INT(cary) - 120
END SUB

SUB DOCARENGINE
'Plays car's engine sound
frequency& = 400 + ABS(carvelocity * 60)
IF (carskidsound% = 1) AND oldcarvelocity < carvelocity THEN
 frequency& = frequency& * 2
END IF
octave& = frequency& \ 1024
frequency& = frequency& \ 2 ^ octave&
L% = frequency& AND 255
H% = 32 + (octave& * 4) + (frequency& \ 256)
FMPadlport &HA7, L%
FMPadlport &HB7, H%
END SUB

SUB DOSKIDSOUNDS
'Skids / wheelspin sound effects
frequency& = 500
octave& = frequency& \ 1024
frequency& = frequency& \ 2 ^ octave&
L% = frequency& AND 255
H% = (carskidsound% * 32) + (octave& * 4) + (frequency& \ 256)
FMPadlport &HA8, L%
FMPadlport &HB8, H%
END SUB

SUB doskidvideoeffects
frame% = (INT(carangle) AND 7)
cx = carx
cy = cary - 12
x1% = cx + (5 * -COS(carangle * .196))
y1% = cy + (5 * SIN(carangle * .196))
x2% = cx + (5 * COS(carangle * .196))
y2% = cy + (5 * -SIN(carangle * .196))
addflatsprite (x1% - 4), (y1% - 3), 0, frame%, 3, 0, 0, 0
addflatsprite (x2% - 4), (y2% - 3), 0, frame%, 3, 0, 0, 0
IF (oldcarskidsound% = 1) THEN
 x3% = (x1% + oldskidx1%) / 2
 y3% = (y1% + oldskidy1%) / 2
 x4% = (x2% + oldskidx2%) / 2
 y4% = (y2% + oldskidy2%) / 2
 addflatsprite (x3% - 4), (y3% - 3), 0, frame%, 3, 0, 0, 0
 addflatsprite (x4% - 4), (y4% - 3), 0, frame%, 3, 0, 0, 0
END IF
oldskidx1% = x1%
oldskidy1% = y1%
oldskidx2% = x2%
oldskidy2% = y2%
END SUB

SUB drawscreen
engine%(132) = levelxsize%
engine%(135) = totalviewports%
engine%(138) = totalsprites%
engine%(150) = totalflatsprites%
viewport(0).camerax = camerax%
viewport(0).cameray = cameray%
viewport(0).totalstatussprites = totalstatussprites0%
viewport(1).totalstatussprites = totalstatussprites1%
DEF SEG = VARSEG(engine%(0))
CALL ABSOLUTE(0)
DEF SEG
END SUB

SUB errorexit (errormessage$)
cleanup
COLOR 15
LOCATE 1, 1
PRINT errormessage$
SYSTEM
END SUB

SUB exitgame
cleanup
COLOR 14
PRINT "Nitrofire ";
COLOR 11
PRINT "FMX ";
COLOR 9
PRINT "alpha version .02"
PRINT
COLOR 7
PRINT "Produced by:  ";
COLOR 12
PRINT "Milo Sedlacek (a.k.a. Gradius)"
COLOR 7
PRINT "              send mail to: ";
COLOR 13
PRINT "sedlacek@execulink.com"
SYSTEM
END SUB

SUB FMPadlport (adressreg%, bdata%)
DEF SEG = VARSEG(adlportasm%(0))
p1% = &H389
p2% = &H388
p3% = bdata%
p4% = adressreg%
CALL ABSOLUTE(p1%, p2%, p3%, p4%, 0)
DEF SEG
END SUB

SUB FMPinit
RESTORE keyDATA
index% = 0
GOTO FMPINITskip0
DO
keyb(index%).flow = a%
keyb(index%).fhi = b%
keyb(index%).foct = c%
keyb(index%).location = d%
index% = index% + 1
FMPINITskip0:
READ a%, b%, c%, d%
LOOP UNTIL a% = -1
totalkeys% = index%
RESTORE adlportDATA
DEF SEG = VARSEG(adlportasm%(0))
i% = VARPTR(adlportasm%(0))
GOTO FMPINITskip1
DO
POKE i%, q%
i% = i% + 1
FMPINITskip1:
READ q%
LOOP UNTIL q% = -1
DEF SEG
resetfmcard
FMPadlport 1, 32
END SUB

SUB FMPplaystart (pfilename$)
DEF SEG = VARSEG(playbuffer&(0))
BLOAD pfilename$, 0
DEF SEG
poffset& = 0
psegment& = VARSEG(playbuffer&(0))
DEF SEG = psegment&
byte% = PEEK(0 + poffset&)
basead% = &H20
FMPadlport basead% + 0, byte%
FMPadlport basead% + 1, byte%
FMPadlport basead% + 2, byte%
FMPadlport basead% + 8, byte%
FMPadlport basead% + 9, byte%
FMPadlport basead% + 10, byte%
FMPadlport basead% + 16, byte%
DEF SEG = psegment&
byte% = PEEK(1 + poffset&)
basead% = &H20
FMPadlport basead% + 3, byte%
FMPadlport basead% + 4, byte%
FMPadlport basead% + 5, byte%
FMPadlport basead% + 11, byte%
FMPadlport basead% + 12, byte%
FMPadlport basead% + 13, byte%
FMPadlport basead% + 19, byte%
DEF SEG = psegment&
byte% = PEEK(2 + poffset&)
basead% = &H40
FMPadlport basead% + 0, byte%
FMPadlport basead% + 1, byte%
FMPadlport basead% + 2, byte%
FMPadlport basead% + 8, byte%
FMPadlport basead% + 9, byte%
FMPadlport basead% + 10, byte%
FMPadlport basead% + 16, byte%
DEF SEG = psegment&
byte% = PEEK(3 + poffset&)
volume% = byte% AND 63
volume% = volume% + MUSICDAMPER
IF volume% > 63 THEN volume% = 63
byte% = (byte% AND &HC0) OR volume%
basead% = &H40
FMPadlport basead% + 3, byte%
FMPadlport basead% + 4, byte%
FMPadlport basead% + 5, byte%
FMPadlport basead% + 11, byte%
FMPadlport basead% + 12, byte%
FMPadlport basead% + 13, byte%
FMPadlport basead% + 19, byte%
DEF SEG = psegment&
byte% = PEEK(4 + poffset&)
basead% = &H60
FMPadlport basead% + 0, byte%
FMPadlport basead% + 1, byte%
FMPadlport basead% + 2, byte%
FMPadlport basead% + 8, byte%
DEF SEG = psegment&
byte% = PEEK(5 + poffset&)
basead% = &H60
FMPadlport basead% + 0, byte%
FMPadlport basead% + 1, byte%
FMPadlport basead% + 2, byte%
FMPadlport basead% + 8, byte%
FMPadlport basead% + 9, byte%
FMPadlport basead% + 10, byte%
FMPadlport basead% + 16, byte%
DEF SEG = psegment&
byte% = PEEK(5 + poffset&)
basead% = &H60
FMPadlport basead% + 3, byte%
FMPadlport basead% + 4, byte%
FMPadlport basead% + 5, byte%
FMPadlport basead% + 11, byte%
FMPadlport basead% + 12, byte%
FMPadlport basead% + 13, byte%
FMPadlport basead% + 19, byte%
DEF SEG = psegment&
byte% = PEEK(6 + poffset&)
basead% = &H80
FMPadlport basead% + 0, byte%
FMPadlport basead% + 1, byte%
FMPadlport basead% + 2, byte%
FMPadlport basead% + 8, byte%
FMPadlport basead% + 9, byte%
FMPadlport basead% + 10, byte%
FMPadlport basead% + 16, byte%
DEF SEG = psegment&
byte% = PEEK(7 + poffset&)
basead% = &H80
FMPadlport basead% + 3, byte%
FMPadlport basead% + 4, byte%
FMPadlport basead% + 5, byte%
FMPadlport basead% + 11, byte%
FMPadlport basead% + 12, byte%
FMPadlport basead% + 13, byte%
FMPadlport basead% + 19, byte%
DEF SEG = psegment&
byte% = PEEK(8 + poffset&)
basead% = &HE0
FMPadlport basead% + 0, byte%
FMPadlport basead% + 1, byte%
FMPadlport basead% + 2, byte%
FMPadlport basead% + 8, byte%
FMPadlport basead% + 9, byte%
FMPadlport basead% + 10, byte%
FMPadlport basead% + 16, byte%
DEF SEG = psegment&
byte% = PEEK(9 + poffset&)
basead% = &HE0
FMPadlport basead% + 3, byte%
FMPadlport basead% + 4, byte%
FMPadlport basead% + 5, byte%
FMPadlport basead% + 11, byte%
FMPadlport basead% + 12, byte%
FMPadlport basead% + 13, byte%
FMPadlport basead% + 19, byte%
DEF SEG = psegment&
byte% = PEEK(10 + poffset&)
basead% = &HC0
FMPadlport basead%, byte%
FMPadlport basead% + 1, byte%
FMPadlport basead% + 2, byte%
FMPadlport basead% + 3, byte%
FMPadlport basead% + 4, byte%
FMPadlport basead% + 5, byte%
FMPadlport basead% + 6, byte%
DEF SEG
DEF SEG = VARSEG(playbuffer&(0))
transpose% = PEEK(11) - 4
DEF SEG
IF transpose% < -4 THEN transpose% = -4
IF transpose% > 1 THEN transpose% = 1
playmode% = 1
keyindex& = 0
playdelaycounter& = 0
playbufferindex& = 16
IF playbuffer&(3) = 0 THEN STOPPLAYSONG
END SUB

SUB initcolourtables
FOR i% = 0 TO 255
 colourtable0%(i%) = i%
 colourtable1%(i%) = i%
 colourtable2%(i%) = i%
NEXT
END SUB

SUB initmaskenable
FOR i% = 0 TO 255
 maskenable%(i%) = 0
NEXT
END SUB

SUB initsprites
addsprite INT(carx), INT(cary), INT(carz), 0, 0, 0, 0, 0
initstatussprites
END SUB

SUB initstatussprites
'Mini map
addstatussprite 2, 2, 0, 2, 1, 0, 0, 0
addstatussprite 0, 0, 0, 0, 2, 0, 0, 0
'Speedometer
addstatussprite 20, 170, 0, 1, 2, 0, 0, 0
addstatussprite 29, 170, 0, 1, 2, 0, 0, 0
addstatussprite 38, 170, 0, 1, 2, 0, 0, 0
f% = 12
IF MILESPERHOUR THEN f% = 11
addstatussprite 47, 175, 0, f%, 2, 0, 0, 0
'Throttle gage
addstatussprite 300, 90, 0, 13, 2, 0, 0, 0
END SUB

SUB inittileindirect
FOR i% = 0 TO 255
 tileindirect%(i%) = i%
NEXT
END SUB

SUB initvariables
carx = 900
cary = 300
carangle = 24
throttle% = 72
currenttiregrip = 1
END SUB

SUB initviewports
addviewport 0, 0, 319, 199
END SUB

SUB limitcamera
minlimit camerax%, 0
minlimit cameray%, 0
maxlimit camerax%, (levelxsize% * 16) - 320
maxlimit cameray%, (levelysize% * 16) - 200
END SUB

SUB loadassembly
'Load graphics engine
DEF SEG = VARSEG(engine%(0))
BLOAD asmfile1$, 0
i& = 256
n& = VARSEG(tiles%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(tiles%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(level%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(level%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
i& = i& + 2
n& = VARSEG(viewport(0).x1): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(viewport(0).x1): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
i& = i& + 2
n& = VARSEG(sprite(0).x): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(sprite(0).x): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
i& = i& + 2
n& = VARSEG(tileindirect%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(tileindirect%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(colourtable0%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(colourtable0%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(colourtable1%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(colourtable1%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(colourtable2%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(colourtable2%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(maskenable%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(maskenable%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(flatsprite(0).x): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
i& = i& + 2
n& = VARSEG(spritestream(0).x): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(spritestream(0).x): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
i& = i& + 2
n& = VARSEG(doublebuffer%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(doublebuffer%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
i& = 320
n& = VARSEG(imx0%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(imx0%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(imx1%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(imx1%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(imx2%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(imx2%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(imx3%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(imx3%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(imx4%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(imx4%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(imx5%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(imx5%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(imx6%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(imx6%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARSEG(imx7%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(imx7%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
DEF SEG
'Load keyboard interrupt
DEF SEG = VARSEG(keyb2%(0))
BLOAD asmfile2$, 0
i& = 16
n& = VARSEG(kbmatrix%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
n& = VARPTR(kbmatrix%(0)): L& = n& AND 255: H& = (n& AND &HFF00) \ 256: POKE i&, L&: POKE i& + 1, H&: i& = i& + 2
DEF SEG
END SUB

SUB loadimx
i% = 0
DO WHILE imxfile$(i%) <> ""
 SELECT CASE i%
 CASE 0
  s& = VARSEG(imx0%(0))
  o& = VARPTR(imx0%(0))
 CASE 1
  s& = VARSEG(imx1%(0))
  o& = VARPTR(imx1%(0))
 CASE 2
  s& = VARSEG(imx2%(0))
  o& = VARPTR(imx2%(0))
 CASE 3
  s& = VARSEG(imx3%(0))
  o& = VARPTR(imx3%(0))
 CASE 4
  s& = VARSEG(imx4%(0))
  o& = VARPTR(imx4%(0))
 CASE 5
  s& = VARSEG(imx5%(0))
  o& = VARPTR(imx5%(0))
 CASE 6
  s& = VARSEG(imx6%(0))
  o& = VARPTR(imx6%(0))
 CASE 7
  s& = VARSEG(imx7%(0))
  o& = VARPTR(imx7%(0))
 END SELECT
 DEF SEG = s&
 BLOAD imxfile$(i%), o&
 i% = i% + 1
LOOP
DEF SEG
END SUB

SUB loadlevel
DEF SEG = VARSEG(level%(0))
BLOAD levfile1$, VARPTR(level%(0))
DEF SEG
levelxsize% = 160
levelysize% = 100
END SUB

SUB loadpalette
DEF SEG = VARSEG(pal%(0))
i& = VARPTR(pal%(0))
BLOAD palfile1$, i&
FOR c% = 0 TO 255
 OUT &H3C8, c%
 OUT &H3C9, PEEK(i&)
 OUT &H3C9, PEEK(i& + 1)
 OUT &H3C9, PEEK(i& + 2)
 i& = i& + 3
NEXT
DEF SEG
END SUB

SUB loadtiles
DEF SEG = VARSEG(tiles%(0))
BLOAD chrfile1$, VARPTR(tiles%(0))
DEF SEG
END SUB

SUB maxlimit (pvalue%, plimit%)
IF pvalue% > plimit% THEN pvalue% = plimit%
END SUB

SUB minlimit (pvalue%, plimit%)
IF pvalue% < plimit% THEN pvalue% = plimit%
END SUB

SUB offkb
IF keyboardonflag% = 0 THEN EXIT SUB
keyboardonflag% = 0
DEF SEG = VARSEG(keyb2%(0))
CALL ABSOLUTE(3)
DEF SEG
END SUB

SUB onkb
IF keyboardonflag% = 1 THEN EXIT SUB
keyboardonflag% = 1
DEF SEG = VARSEG(keyb2%(0))
CALL ABSOLUTE(0)
DEF SEG
END SUB

SUB playgame
PLAYSONG songfile1$
onkb
DO WHILE kbmatrix%(1) = 0
 controlplayer
 docamera
 limitcamera
 updatespritedata
 drawscreen
 CONTINUEPLAYSONG
 CONTINUEPLAYSONG
 CONTINUEPLAYSONG
 IF SOUNDON = 1 THEN
  DOCARENGINE
  DOSKIDSOUNDS
 END IF
 saveold
LOOP
offkb
STOPPLAYSONG
END SUB

SUB PLAYSONG (pfilename$)
currentsong$ = pfilename$
FOR n% = 0 TO TOTALVOICES - 1: voice(n%).inuse = 0: voice(n%).delay = 0: NEXT
FOR i% = 0 TO 127: kbmatrix2%(i%) = 0: NEXT
FMPplaystart (pfilename$)
END SUB

SUB resetfmcard
FOR n% = 0 TO 244
FMPadlport n%, 0
NEXT
END SUB

SUB saveold
oldcarvelocity = carvelocity
oldcarskidsound% = carskidsound%
END SUB

SUB setmotorsound
'Set Modulator sound characteristic
FMPadlport &H20 + &H11, &H20
'Set Carrier sound characteristic
FMPadlport &H20 + &H14, &H20
'Set Modulator output level
FMPadlport &H40 + &H11, 0
'Set Carrier output level
FMPadlport &H40 + &H14, 0
'Set Modulator Attack / Decay
FMPadlport &H60 + &H11, &H44
'Set Carrier Attack / Decay
FMPadlport &H60 + &H14, &H44
'Set Modulator Sustain / Release
FMPadlport &H80 + &H11, &HF
'Set Carrier Sustain / Release
FMPadlport &H80 + &H14, &HF
'Set Modulator Wave Select
FMPadlport &HE0 + &H11, 0
'Set Carrier Wave Select
FMPadlport &HE0 + &H14, 1
'Set Feedback Level
FMPadlport &HC0 + 7, &H2
END SUB

SUB setscreenmode
CLS
SCREEN 13
centreprint "Loading...", 20, 12, 12
END SUB

SUB setskidsound
'Set Modulator sound characteristic
FMPadlport &H20 + &H12, &H20
'Set Carrier sound characteristic
FMPadlport &H20 + &H15, &H20
'Set Modulator output level
FMPadlport &H40 + &H12, 0
'Set Carrier output level
FMPadlport &H40 + &H15, 0
'Set Modulator Attack / Decay
FMPadlport &H60 + &H12, &HFF
'Set Carrier Attack / Decay
FMPadlport &H60 + &H15, &HFF
'Set Modulator Sustain / Release
FMPadlport &H80 + &H12, &H1
'Set Carrier Sustain / Release
FMPadlport &H80 + &H15, &H8
'Set Modulator Wave Select
FMPadlport &HE0 + &H12, 0
'Set Carrier Wave Select
FMPadlport &HE0 + &H15, 3
'Set Feedback Level
FMPadlport &HC0 + 8, 14
END SUB

SUB showkeys

CLS
SCREEN 0
WIDTH 80, 25

centreprint "NITROFIRE", 37, 1, 11
centreprint "FMX", 44, 1, 14
COLOR 13
LOCATE 5, 30: PRINT "Controls"
LOCATE 6, 30: PRINT "========"
LOCATE 8, 30: PRINT CHR$(24)
LOCATE 9, 28: PRINT CHR$(27); "   "; CHR$(26); "      control car"
LOCATE 10, 30: PRINT CHR$(25)
LOCATE 12, 30: PRINT "<        decrease throttle"
LOCATE 13, 30: PRINT ">        increase throttle"
LOCATE 15, 30: PRINT "ctrl     start skid"
centreprint "Press any key to start", 40, 25, 12
waitkey
END SUB

SUB STOPPLAYSONG
playmode% = 0
resetfmcard
END SUB

SUB updatespritedata
'Update player's car sprite
sprite(0).x = INT(carx)
sprite(0).y = INT(cary)
sprite(0).z = INT(carz)
a% = INT(carangle) AND 31
f% = 0
IF a% > 16 THEN
 a% = 16 - (a% - 16)
 f% = 2
END IF
sprite(0).frame = a%
sprite(0).flags = (sprite(0).flags AND 253) OR f%
'Update status sprites
updatestatsprites
END SUB

SUB updatestatsprites
'Update map cursor
status0(1).x = (carx \ 32) - 10
status0(1).y = (cary \ 32) - 6
'Update spedometer
v = ABS(carvelocity) * SPEDOMETERFACTOR
IF MILESPERHOUR THEN v = v / 1.6
status0(2).flags = 1    'Hide digits
status0(3).flags = 1
msbdigit% = v \ 100
digit% = (v MOD 100) \ 10
lsbdigit% = v MOD 10
IF digit% OR msbdigit% THEN
 status0(3).flags = 0
 IF msbdigit% THEN status0(2).flags = 0
END IF
status0(2).frame = 1 + msbdigit%  'Calculate frames for digits
status0(3).frame = 1 + digit%
status0(4).frame = 1 + lsbdigit%
'Update throttle meter
FOR i% = 0 TO 7
 OUT &H3C8, i% + 168
 b = 0
 IF (throttle% \ 16) > i% THEN
  r = 20 + i% * 7
  g = 20 + i% * 4
 ELSEIF (throttle% \ 16) = i% THEN
  r = (20 + i% * 7) * (throttle% AND 15) / 16
  g = (20 + i% * 4) * (throttle% AND 15) / 16
 ELSE
  r = i% * 1.7
  g = i% * 1.7
  b = i% * 1.7
 END IF
 IF r > 63 THEN r = 63
 OUT &H3C9, INT(r)
 OUT &H3C9, INT(g)
 OUT &H3C9, INT(b)
NEXT


END SUB

SUB waitkey
SLEEP
DO UNTIL INKEY$ = ""
LOOP
END SUB

